/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CaptioningManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int DEFAULT_ENABLED = 0;
    private static int DEFAULT_PRESET = 0;
    private static float DEFAULT_FONT_SCALE = 1.0f;
    private ArrayList<CaptioningChangeListener> mListeners;
    private ContentResolver mContentResolver;
    private ContentObserver mContentObserver;
    private Runnable mStyleChangedRunnable;

    private void $$robo$$android_view_accessibility_CaptioningManager$__constructor__(Context context) {
        this.mListeners = new ArrayList();
        this.mStyleChangedRunnable = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CaptioningManager this$0;

            private void $$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(CaptioningManager this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_view_accessibility_CaptioningManager_1$run() {
                this.this$0.notifyUserStyleChanged();
            }

            private void __constructor__(CaptioningManager captioningManager) {
                this.$$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(captioningManager);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(android.view.accessibility.CaptioningManager ), this, captioningManager);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_accessibility_CaptioningManager_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContentResolver = context.getContentResolver();
        Handler handler = new Handler(context.getMainLooper());
        this.mContentObserver = new MyContentObserver(this, handler);
    }

    private final boolean $$robo$$android_view_accessibility_CaptioningManager$isEnabled() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_enabled", 0) == 1;
    }

    private final String $$robo$$android_view_accessibility_CaptioningManager$getRawLocale() {
        return Settings.Secure.getString(this.mContentResolver, "accessibility_captioning_locale");
    }

    private final Locale $$robo$$android_view_accessibility_CaptioningManager$getLocale() {
        String rawLocale = this.getRawLocale();
        if (!TextUtils.isEmpty(rawLocale)) {
            String[] splitLocale = rawLocale.split("_");
            switch (splitLocale.length) {
                case 3: {
                    return new Locale(splitLocale[0], splitLocale[1], splitLocale[2]);
                }
                case 2: {
                    return new Locale(splitLocale[0], splitLocale[1]);
                }
                case 1: {
                    return new Locale(splitLocale[0]);
                }
            }
        }
        return null;
    }

    private final float $$robo$$android_view_accessibility_CaptioningManager$getFontScale() {
        return Settings.Secure.getFloat(this.mContentResolver, "accessibility_captioning_font_scale", 1.0f);
    }

    private final int $$robo$$android_view_accessibility_CaptioningManager$getRawUserStyle() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_preset", 0);
    }

    private final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager$getUserStyle() {
        int preset = this.getRawUserStyle();
        if (preset == -1) {
            return CaptionStyle.getCustomStyle(this.mContentResolver);
        }
        return CaptionStyle.PRESETS[preset];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$addCaptioningChangeListener(CaptioningChangeListener listener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mListeners.isEmpty()) {
                this.registerObserver("accessibility_captioning_enabled");
                this.registerObserver("accessibility_captioning_foreground_color");
                this.registerObserver("accessibility_captioning_background_color");
                this.registerObserver("accessibility_captioning_window_color");
                this.registerObserver("accessibility_captioning_edge_type");
                this.registerObserver("accessibility_captioning_edge_color");
                this.registerObserver("accessibility_captioning_typeface");
                this.registerObserver("accessibility_captioning_font_scale");
                this.registerObserver("accessibility_captioning_locale");
                this.registerObserver("accessibility_captioning_preset");
            }
            this.mListeners.add(listener);
        }
    }

    private final void $$robo$$android_view_accessibility_CaptioningManager$registerObserver(String key) {
        this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor(key), false, this.mContentObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$removeCaptioningChangeListener(CaptioningChangeListener listener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(listener);
            if (this.mListeners.isEmpty()) {
                this.mContentResolver.unregisterContentObserver(this.mContentObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyEnabledChanged() {
        boolean enabled = this.isEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onEnabledChanged(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyUserStyleChanged() {
        CaptionStyle userStyle = this.getUserStyle();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onUserStyleChanged(userStyle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyLocaleChanged() {
        Locale locale = this.getLocale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onLocaleChanged(locale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyFontScaleChanged() {
        float fontScale = this.getFontScale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onFontScaleChanged(fontScale);
            }
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_accessibility_CaptioningManager$__constructor__(context);
    }

    public CaptioningManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager$__constructor__(android.content.Context ), this, context);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_CaptioningManager$isEnabled(), this);
    }

    public String getRawLocale() {
        return InvokeDynamicSupport.bootstrap("getRawLocale", $$robo$$android_view_accessibility_CaptioningManager$getRawLocale(), this);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_view_accessibility_CaptioningManager$getLocale(), this);
    }

    public float getFontScale() {
        return (float)InvokeDynamicSupport.bootstrap("getFontScale", $$robo$$android_view_accessibility_CaptioningManager$getFontScale(), this);
    }

    public int getRawUserStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getRawUserStyle", $$robo$$android_view_accessibility_CaptioningManager$getRawUserStyle(), this);
    }

    public CaptionStyle getUserStyle() {
        return InvokeDynamicSupport.bootstrap("getUserStyle", $$robo$$android_view_accessibility_CaptioningManager$getUserStyle(), this);
    }

    public void addCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        InvokeDynamicSupport.bootstrap("addCaptioningChangeListener", $$robo$$android_view_accessibility_CaptioningManager$addCaptioningChangeListener(android.view.accessibility.CaptioningManager$CaptioningChangeListener ), this, captioningChangeListener);
    }

    private void registerObserver(String string2) {
        InvokeDynamicSupport.bootstrap("registerObserver", $$robo$$android_view_accessibility_CaptioningManager$registerObserver(java.lang.String ), this, string2);
    }

    public void removeCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        InvokeDynamicSupport.bootstrap("removeCaptioningChangeListener", $$robo$$android_view_accessibility_CaptioningManager$removeCaptioningChangeListener(android.view.accessibility.CaptioningManager$CaptioningChangeListener ), this, captioningChangeListener);
    }

    private void notifyEnabledChanged() {
        InvokeDynamicSupport.bootstrap("notifyEnabledChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyEnabledChanged(), this);
    }

    private void notifyUserStyleChanged() {
        InvokeDynamicSupport.bootstrap("notifyUserStyleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyUserStyleChanged(), this);
    }

    private void notifyLocaleChanged() {
        InvokeDynamicSupport.bootstrap("notifyLocaleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyLocaleChanged(), this);
    }

    private void notifyFontScaleChanged() {
        InvokeDynamicSupport.bootstrap("notifyFontScaleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyFontScaleChanged(), this);
    }

    public /* synthetic */ CaptioningManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptioningManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class CaptioningChangeListener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__() {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onEnabledChanged(boolean enabled) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onUserStyleChanged(CaptionStyle userStyle) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onLocaleChanged(Locale locale) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onFontScaleChanged(float fontScale) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__();
        }

        public CaptioningChangeListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__(), this);
        }

        public void onEnabledChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onEnabledChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onEnabledChanged(boolean ), this, bl);
        }

        public void onUserStyleChanged(CaptionStyle captionStyle) {
            InvokeDynamicSupport.bootstrap("onUserStyleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onUserStyleChanged(android.view.accessibility.CaptioningManager$CaptionStyle ), this, captionStyle);
        }

        public void onLocaleChanged(Locale locale) {
            InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onLocaleChanged(java.util.Locale ), this, locale);
        }

        public void onFontScaleChanged(float f) {
            InvokeDynamicSupport.bootstrap("onFontScaleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onFontScaleChanged(float ), this, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptioningChangeListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CaptionStyle
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int COLOR_NONE_OPAQUE = 255;
        public static int COLOR_UNSPECIFIED = 0xFFFFFF;
        private static CaptionStyle WHITE_ON_BLACK;
        private static CaptionStyle BLACK_ON_WHITE;
        private static CaptionStyle YELLOW_ON_BLACK;
        private static CaptionStyle YELLOW_ON_BLUE;
        private static CaptionStyle DEFAULT_CUSTOM;
        private static CaptionStyle UNSPECIFIED;
        public static CaptionStyle DEFAULT;
        public static CaptionStyle[] PRESETS;
        public static int PRESET_CUSTOM = -1;
        public static int EDGE_TYPE_UNSPECIFIED = -1;
        public static int EDGE_TYPE_NONE = 0;
        public static int EDGE_TYPE_OUTLINE = 1;
        public static int EDGE_TYPE_DROP_SHADOW = 2;
        public static int EDGE_TYPE_RAISED = 3;
        public static int EDGE_TYPE_DEPRESSED = 4;
        public int foregroundColor;
        public int backgroundColor;
        public int edgeType;
        public int edgeColor;
        public int windowColor;
        public String mRawTypeface;
        private boolean mHasForegroundColor;
        private boolean mHasBackgroundColor;
        private boolean mHasEdgeType;
        private boolean mHasEdgeColor;
        private boolean mHasWindowColor;
        private Typeface mParsedTypeface;

        private void $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(int foregroundColor, int backgroundColor, int edgeType, int edgeColor, int windowColor, String rawTypeface) {
            this.mHasForegroundColor = CaptionStyle.hasColor(foregroundColor);
            this.mHasBackgroundColor = CaptionStyle.hasColor(backgroundColor);
            this.mHasEdgeType = edgeType != -1;
            this.mHasEdgeColor = CaptionStyle.hasColor(edgeColor);
            this.mHasWindowColor = CaptionStyle.hasColor(windowColor);
            this.foregroundColor = this.mHasForegroundColor ? foregroundColor : -1;
            this.backgroundColor = this.mHasBackgroundColor ? backgroundColor : -16777216;
            this.edgeType = this.mHasEdgeType ? edgeType : 0;
            this.edgeColor = this.mHasEdgeColor ? edgeColor : -16777216;
            this.windowColor = this.mHasWindowColor ? windowColor : 255;
            this.mRawTypeface = rawTypeface;
        }

        private static final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasColor(int packedColor) {
            return packedColor >>> 24 != 0 || (packedColor & 0xFFFF00) == 0;
        }

        private final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$applyStyle(CaptionStyle overlay) {
            int newForegroundColor = overlay.hasForegroundColor() ? overlay.foregroundColor : this.foregroundColor;
            int newBackgroundColor = overlay.hasBackgroundColor() ? overlay.backgroundColor : this.backgroundColor;
            int newEdgeType = overlay.hasEdgeType() ? overlay.edgeType : this.edgeType;
            int newEdgeColor = overlay.hasEdgeColor() ? overlay.edgeColor : this.edgeColor;
            int newWindowColor = overlay.hasWindowColor() ? overlay.windowColor : this.windowColor;
            String newRawTypeface = overlay.mRawTypeface != null ? overlay.mRawTypeface : this.mRawTypeface;
            return new CaptionStyle(newForegroundColor, newBackgroundColor, newEdgeType, newEdgeColor, newWindowColor, newRawTypeface);
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasBackgroundColor() {
            return this.mHasBackgroundColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasForegroundColor() {
            return this.mHasForegroundColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeType() {
            return this.mHasEdgeType;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeColor() {
            return this.mHasEdgeColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasWindowColor() {
            return this.mHasWindowColor;
        }

        private final Typeface $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getTypeface() {
            if (this.mParsedTypeface == null && !TextUtils.isEmpty(this.mRawTypeface)) {
                this.mParsedTypeface = Typeface.create(this.mRawTypeface, 0);
            }
            return this.mParsedTypeface;
        }

        private static final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getCustomStyle(ContentResolver cr) {
            CaptionStyle defStyle = DEFAULT_CUSTOM;
            int foregroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_foreground_color", defStyle.foregroundColor);
            int backgroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_background_color", defStyle.backgroundColor);
            int edgeType = Settings.Secure.getInt(cr, "accessibility_captioning_edge_type", defStyle.edgeType);
            int edgeColor = Settings.Secure.getInt(cr, "accessibility_captioning_edge_color", defStyle.edgeColor);
            int windowColor = Settings.Secure.getInt(cr, "accessibility_captioning_window_color", defStyle.windowColor);
            String rawTypeface = Settings.Secure.getString(cr, "accessibility_captioning_typeface");
            if (rawTypeface == null) {
                rawTypeface = defStyle.mRawTypeface;
            }
            return new CaptionStyle(foregroundColor, backgroundColor, edgeType, edgeColor, windowColor, rawTypeface);
        }

        static void __staticInitializer__() {
            WHITE_ON_BLACK = new CaptionStyle(-1, -16777216, 0, -16777216, 255, null);
            BLACK_ON_WHITE = new CaptionStyle(-16777216, -1, 0, -16777216, 255, null);
            YELLOW_ON_BLACK = new CaptionStyle(-256, -16777216, 0, -16777216, 255, null);
            YELLOW_ON_BLUE = new CaptionStyle(-256, -16776961, 0, -16777216, 255, null);
            UNSPECIFIED = new CaptionStyle(0xFFFFFF, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, null);
            PRESETS = new CaptionStyle[]{WHITE_ON_BLACK, BLACK_ON_WHITE, YELLOW_ON_BLACK, YELLOW_ON_BLUE, UNSPECIFIED};
            DEFAULT_CUSTOM = WHITE_ON_BLACK;
            DEFAULT = WHITE_ON_BLACK;
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2) {
            this.$$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(n, n2, n3, n4, n5, string2);
        }

        public CaptionStyle(int n, int n2, int n3, int n4, int n5, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(int int int int int java.lang.String ), this, n, n2, n3, n4, n5, string2);
        }

        public static boolean hasColor(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasColor(int ), (int)n);
        }

        public CaptionStyle applyStyle(CaptionStyle captionStyle) {
            return InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$applyStyle(android.view.accessibility.CaptioningManager$CaptionStyle ), this, captionStyle);
        }

        public boolean hasBackgroundColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasBackgroundColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasBackgroundColor(), this);
        }

        public boolean hasForegroundColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasForegroundColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasForegroundColor(), this);
        }

        public boolean hasEdgeType() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasEdgeType", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeType(), this);
        }

        public boolean hasEdgeColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasEdgeColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeColor(), this);
        }

        public boolean hasWindowColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasWindowColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasWindowColor(), this);
        }

        public Typeface getTypeface() {
            return InvokeDynamicSupport.bootstrap("getTypeface", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getTypeface(), this);
        }

        public static CaptionStyle getCustomStyle(ContentResolver contentResolver) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomStyle", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getCustomStyle(android.content.ContentResolver ), (ContentResolver)contentResolver);
        }

        static {
            RobolectricInternals.classInitializing(CaptionStyle.class);
        }

        public /* synthetic */ CaptionStyle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionStyle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MyContentObserver
    extends ContentObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ CaptioningManager this$0;

        private void $$robo$$android_view_accessibility_CaptioningManager_MyContentObserver$__constructor__(CaptioningManager captioningManager, Handler handler) {
            this.this$0 = captioningManager;
            this.mHandler = handler;
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_MyContentObserver$onChange(boolean selfChange, Uri uri) {
            String uriPath = uri.getPath();
            String name = uriPath.substring(uriPath.lastIndexOf(47) + 1);
            if ("accessibility_captioning_enabled".equals(name)) {
                this.this$0.notifyEnabledChanged();
            } else if ("accessibility_captioning_locale".equals(name)) {
                this.this$0.notifyLocaleChanged();
            } else if ("accessibility_captioning_font_scale".equals(name)) {
                this.this$0.notifyFontScaleChanged();
            } else {
                this.mHandler.removeCallbacks(this.this$0.mStyleChangedRunnable);
                this.mHandler.post(this.this$0.mStyleChangedRunnable);
            }
        }

        private void __constructor__(CaptioningManager captioningManager, Handler handler) {
            this.$$robo$$android_view_accessibility_CaptioningManager_MyContentObserver$__constructor__(captioningManager, handler);
        }

        public MyContentObserver(CaptioningManager captioningManager, Handler handler) {
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_MyContentObserver$__constructor__(android.view.accessibility.CaptioningManager android.os.Handler ), this, captioningManager, handler);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_view_accessibility_CaptioningManager_MyContentObserver$onChange(boolean android.net.Uri ), this, bl, uri);
        }

        public /* synthetic */ MyContentObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyContentObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

