/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ClipRectAnimation
extends Animation
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected Rect mFromRect;
    protected Rect mToRect;
    private int mFromLeftType;
    private int mFromTopType;
    private int mFromRightType;
    private int mFromBottomType;
    private int mToLeftType;
    private int mToTopType;
    private int mToRightType;
    private int mToBottomType;
    private float mFromLeftValue;
    private float mFromTopValue;
    private float mFromRightValue;
    private float mFromBottomValue;
    private float mToLeftValue;
    private float mToTopValue;
    private float mToRightValue;
    private float mToBottomValue;

    private void $$robo$$android_view_animation_ClipRectAnimation$__constructor__(Context context, AttributeSet attrs) {
        this.mFromRect = new Rect();
        this.mToRect = new Rect();
        this.mFromLeftType = 0;
        this.mFromTopType = 0;
        this.mFromRightType = 0;
        this.mFromBottomType = 0;
        this.mToLeftType = 0;
        this.mToTopType = 0;
        this.mToRightType = 0;
        this.mToBottomType = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ClipRectAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(1));
        this.mFromLeftType = d.type;
        this.mFromLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(3));
        this.mFromTopType = d.type;
        this.mFromTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(2));
        this.mFromRightType = d.type;
        this.mFromRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(0));
        this.mFromBottomType = d.type;
        this.mFromBottomValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(5));
        this.mToLeftType = d.type;
        this.mToLeftValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(7));
        this.mToTopType = d.type;
        this.mToTopValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(6));
        this.mToRightType = d.type;
        this.mToRightValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(4));
        this.mToBottomType = d.type;
        this.mToBottomValue = d.value;
        a.recycle();
    }

    private void $$robo$$android_view_animation_ClipRectAnimation$__constructor__(Rect fromClip, Rect toClip) {
        this.mFromRect = new Rect();
        this.mToRect = new Rect();
        this.mFromLeftType = 0;
        this.mFromTopType = 0;
        this.mFromRightType = 0;
        this.mFromBottomType = 0;
        this.mToLeftType = 0;
        this.mToTopType = 0;
        this.mToRightType = 0;
        this.mToBottomType = 0;
        if (fromClip == null || toClip == null) {
            throw new RuntimeException("Expected non-null animation clip rects");
        }
        this.mFromLeftValue = fromClip.left;
        this.mFromTopValue = fromClip.top;
        this.mFromRightValue = fromClip.right;
        this.mFromBottomValue = fromClip.bottom;
        this.mToLeftValue = toClip.left;
        this.mToTopValue = toClip.top;
        this.mToRightValue = toClip.right;
        this.mToBottomValue = toClip.bottom;
    }

    private void $$robo$$android_view_animation_ClipRectAnimation$__constructor__(int fromL, int fromT, int fromR, int fromB, int toL, int toT, int toR, int toB) {
    }

    private final void $$robo$$android_view_animation_ClipRectAnimation$applyTransformation(float it, Transformation tr) {
        int l = this.mFromRect.left + (int)((float)(this.mToRect.left - this.mFromRect.left) * it);
        int t = this.mFromRect.top + (int)((float)(this.mToRect.top - this.mFromRect.top) * it);
        int r = this.mFromRect.right + (int)((float)(this.mToRect.right - this.mFromRect.right) * it);
        int b = this.mFromRect.bottom + (int)((float)(this.mToRect.bottom - this.mFromRect.bottom) * it);
        tr.setClipRect(l, t, r, b);
    }

    private final boolean $$robo$$android_view_animation_ClipRectAnimation$willChangeTransformationMatrix() {
        return false;
    }

    private final void $$robo$$android_view_animation_ClipRectAnimation$initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromRect.set((int)this.resolveSize(this.mFromLeftType, this.mFromLeftValue, width, parentWidth), (int)this.resolveSize(this.mFromTopType, this.mFromTopValue, height, parentHeight), (int)this.resolveSize(this.mFromRightType, this.mFromRightValue, width, parentWidth), (int)this.resolveSize(this.mFromBottomType, this.mFromBottomValue, height, parentHeight));
        this.mToRect.set((int)this.resolveSize(this.mToLeftType, this.mToLeftValue, width, parentWidth), (int)this.resolveSize(this.mToTopType, this.mToTopValue, height, parentHeight), (int)this.resolveSize(this.mToRightType, this.mToRightValue, width, parentWidth), (int)this.resolveSize(this.mToBottomType, this.mToBottomValue, height, parentHeight));
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_ClipRectAnimation$__constructor__(context, attributeSet);
    }

    public ClipRectAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ClipRectAnimation$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Rect rect, Rect rect2) {
        this.$$robo$$android_view_animation_ClipRectAnimation$__constructor__(rect, rect2);
    }

    public ClipRectAnimation(Rect rect, Rect rect2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ClipRectAnimation$__constructor__(android.graphics.Rect android.graphics.Rect ), this, rect, rect2);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.$$robo$$android_view_animation_ClipRectAnimation$__constructor__(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public ClipRectAnimation(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(new Rect(n, n2, n3, n4), new Rect(n5, n6, n7, n8));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_ClipRectAnimation$__constructor__(int int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$android_view_animation_ClipRectAnimation$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return (boolean)InvokeDynamicSupport.bootstrap("willChangeTransformationMatrix", $$robo$$android_view_animation_ClipRectAnimation$willChangeTransformationMatrix(), this);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_animation_ClipRectAnimation$initialize(int int int int ), this, n, n2, n3, n4);
    }

    public /* synthetic */ ClipRectAnimation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClipRectAnimation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

