/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.google.errorprone.annotations.DoNotMock;
import java.security.InvalidParameterException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InputContentInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Uri mContentUri;
    private int mContentUriOwnerUserId;
    private ClipDescription mDescription;
    private Uri mLinkUri;
    private IInputContentUriToken mUriToken;
    public static Parcelable.Creator<InputContentInfo> CREATOR;

    private void $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(Uri contentUri, ClipDescription description) {
    }

    private void $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(Uri contentUri, ClipDescription description, Uri linkUri) {
        InputContentInfo.validateInternal(contentUri, description, linkUri, true);
        this.mContentUri = contentUri;
        this.mContentUriOwnerUserId = ContentProvider.getUserIdFromUri(this.mContentUri, UserHandle.myUserId());
        this.mDescription = description;
        this.mLinkUri = linkUri;
    }

    private final boolean $$robo$$android_view_inputmethod_InputContentInfo$validate() {
        return InputContentInfo.validateInternal(this.mContentUri, this.mDescription, this.mLinkUri, false);
    }

    private static final boolean $$robo$$android_view_inputmethod_InputContentInfo$validateInternal(Uri contentUri, ClipDescription description, Uri linkUri, boolean throwException) {
        String scheme;
        if (contentUri == null) {
            if (throwException) {
                throw new NullPointerException("contentUri");
            }
            return false;
        }
        if (description == null) {
            if (throwException) {
                throw new NullPointerException("description");
            }
            return false;
        }
        String contentUriScheme = contentUri.getScheme();
        if (!"content".equals(contentUriScheme)) {
            if (throwException) {
                throw new InvalidParameterException("contentUri must have content scheme");
            }
            return false;
        }
        if (linkUri != null && ((scheme = linkUri.getScheme()) == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https"))) {
            if (throwException) {
                throw new InvalidParameterException("linkUri must have either http or https scheme");
            }
            return false;
        }
        return true;
    }

    private final Uri $$robo$$android_view_inputmethod_InputContentInfo$getContentUri() {
        if (this.mContentUriOwnerUserId != UserHandle.myUserId()) {
            return ContentProvider.maybeAddUserId(this.mContentUri, this.mContentUriOwnerUserId);
        }
        return this.mContentUri;
    }

    private final ClipDescription $$robo$$android_view_inputmethod_InputContentInfo$getDescription() {
        return this.mDescription;
    }

    private final Uri $$robo$$android_view_inputmethod_InputContentInfo$getLinkUri() {
        return this.mLinkUri;
    }

    private final void $$robo$$android_view_inputmethod_InputContentInfo$setUriToken(IInputContentUriToken token) {
        if (this.mUriToken != null) {
            throw new IllegalStateException("URI token is already set");
        }
        this.mUriToken = token;
    }

    private final void $$robo$$android_view_inputmethod_InputContentInfo$requestPermission() {
        if (this.mUriToken == null) {
            return;
        }
        try {
            this.mUriToken.take();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputContentInfo$releasePermission() {
        if (this.mUriToken == null) {
            return;
        }
        try {
            this.mUriToken.release();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_view_inputmethod_InputContentInfo$writeToParcel(Parcel dest, int flags) {
        Uri.writeToParcel(dest, this.mContentUri);
        dest.writeInt(this.mContentUriOwnerUserId);
        this.mDescription.writeToParcel(dest, flags);
        Uri.writeToParcel(dest, this.mLinkUri);
        if (this.mUriToken != null) {
            dest.writeInt(1);
            dest.writeStrongBinder(this.mUriToken.asBinder());
        } else {
            dest.writeInt(0);
        }
    }

    private void $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(Parcel source) {
        this.mContentUri = Uri.CREATOR.createFromParcel(source);
        this.mContentUriOwnerUserId = source.readInt();
        this.mDescription = ClipDescription.CREATOR.createFromParcel(source);
        this.mLinkUri = Uri.CREATOR.createFromParcel(source);
        this.mUriToken = source.readInt() == 1 ? IInputContentUriToken.Stub.asInterface(source.readStrongBinder()) : null;
    }

    private final int $$robo$$android_view_inputmethod_InputContentInfo$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<InputContentInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_inputmethod_InputContentInfo_1$__constructor__() {
            }

            private final InputContentInfo $$robo$$android_view_inputmethod_InputContentInfo_1$createFromParcel(Parcel source) {
                return new InputContentInfo(source, null);
            }

            private final InputContentInfo[] $$robo$$android_view_inputmethod_InputContentInfo_1$newArray(int size) {
                return new InputContentInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_inputmethod_InputContentInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputContentInfo_1$__constructor__(), this);
            }

            @Override
            public InputContentInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_inputmethod_InputContentInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public InputContentInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_inputmethod_InputContentInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Uri uri, ClipDescription clipDescription) {
        this.$$robo$$android_view_inputmethod_InputContentInfo$__constructor__(uri, clipDescription);
    }

    public InputContentInfo(Uri uri, ClipDescription clipDescription) {
        this(uri, clipDescription, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(android.net.Uri android.content.ClipDescription ), this, uri, clipDescription);
    }

    private void __constructor__(Uri uri, ClipDescription clipDescription, Uri uri2) {
        this.$$robo$$android_view_inputmethod_InputContentInfo$__constructor__(uri, clipDescription, uri2);
    }

    public InputContentInfo(Uri uri, ClipDescription clipDescription, Uri uri2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(android.net.Uri android.content.ClipDescription android.net.Uri ), this, uri, clipDescription, uri2);
    }

    public boolean validate() {
        return (boolean)InvokeDynamicSupport.bootstrap("validate", $$robo$$android_view_inputmethod_InputContentInfo$validate(), this);
    }

    private static boolean validateInternal(Uri uri, ClipDescription clipDescription, Uri uri2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("validateInternal", $$robo$$android_view_inputmethod_InputContentInfo$validateInternal(android.net.Uri android.content.ClipDescription android.net.Uri boolean ), (Uri)uri, (ClipDescription)clipDescription, (Uri)uri2, (boolean)bl);
    }

    public Uri getContentUri() {
        return InvokeDynamicSupport.bootstrap("getContentUri", $$robo$$android_view_inputmethod_InputContentInfo$getContentUri(), this);
    }

    public ClipDescription getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_view_inputmethod_InputContentInfo$getDescription(), this);
    }

    public Uri getLinkUri() {
        return InvokeDynamicSupport.bootstrap("getLinkUri", $$robo$$android_view_inputmethod_InputContentInfo$getLinkUri(), this);
    }

    void setUriToken(IInputContentUriToken iInputContentUriToken) {
        InvokeDynamicSupport.bootstrap("setUriToken", $$robo$$android_view_inputmethod_InputContentInfo$setUriToken(com.android.internal.inputmethod.IInputContentUriToken ), this, iInputContentUriToken);
    }

    public void requestPermission() {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_view_inputmethod_InputContentInfo$requestPermission(), this);
    }

    public void releasePermission() {
        InvokeDynamicSupport.bootstrap("releasePermission", $$robo$$android_view_inputmethod_InputContentInfo$releasePermission(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_inputmethod_InputContentInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_inputmethod_InputContentInfo$__constructor__(parcel);
    }

    public InputContentInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_inputmethod_InputContentInfo$describeContents(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_inputmethod_InputContentInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ InputContentInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputContentInfo$__constructor__(android.os.Parcel android.view.inputmethod.InputContentInfo$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(InputContentInfo.class);
    }

    public /* synthetic */ InputContentInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputContentInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

