/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.PendingIntent;
import android.app.RemoteAction;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.Log;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassification
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static TextClassification EMPTY;
    private static String LOG_TAG = "TextClassification";
    private static int MAX_LEGACY_ICON_SIZE = 192;
    private String mText;
    private Drawable mLegacyIcon;
    private String mLegacyLabel;
    private Intent mLegacyIntent;
    private View.OnClickListener mLegacyOnClickListener;
    private List<RemoteAction> mActions;
    private EntityConfidence mEntityConfidence;
    private String mId;
    public static Parcelable.Creator<TextClassification> CREATOR;

    private void $$robo$$android_view_textclassifier_TextClassification$__constructor__(String text, Drawable legacyIcon, String legacyLabel, Intent legacyIntent, View.OnClickListener legacyOnClickListener, List<RemoteAction> actions, Map<String, Float> entityConfidence, String id2) {
        this.mText = text;
        this.mLegacyIcon = legacyIcon;
        this.mLegacyLabel = legacyLabel;
        this.mLegacyIntent = legacyIntent;
        this.mLegacyOnClickListener = legacyOnClickListener;
        this.mActions = Collections.unmodifiableList(actions);
        this.mEntityConfidence = new EntityConfidence(entityConfidence);
        this.mId = id2;
    }

    private final String $$robo$$android_view_textclassifier_TextClassification$getText() {
        return this.mText;
    }

    private final int $$robo$$android_view_textclassifier_TextClassification$getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    private final String $$robo$$android_view_textclassifier_TextClassification$getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    private final float $$robo$$android_view_textclassifier_TextClassification$getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    private final List<RemoteAction> $$robo$$android_view_textclassifier_TextClassification$getActions() {
        return this.mActions;
    }

    @Deprecated
    private final Drawable $$robo$$android_view_textclassifier_TextClassification$getIcon() {
        return this.mLegacyIcon;
    }

    @Deprecated
    private final CharSequence $$robo$$android_view_textclassifier_TextClassification$getLabel() {
        return this.mLegacyLabel;
    }

    @Deprecated
    private final Intent $$robo$$android_view_textclassifier_TextClassification$getIntent() {
        return this.mLegacyIntent;
    }

    private final View.OnClickListener $$robo$$android_view_textclassifier_TextClassification$getOnClickListener() {
        return this.mLegacyOnClickListener;
    }

    private final String $$robo$$android_view_textclassifier_TextClassification$getId() {
        return this.mId;
    }

    private final String $$robo$$android_view_textclassifier_TextClassification$toString() {
        return String.format(Locale.US, "TextClassification {text=%s, entities=%s, actions=%s, id=%s}", this.mText, this.mEntityConfidence, this.mActions, this.mId);
    }

    private static final View.OnClickListener $$robo$$android_view_textclassifier_TextClassification$createIntentOnClickListener(PendingIntent intent) {
        Preconditions.checkNotNull(intent);
        return v -> {
            try {
                intent.send();
            }
            catch (PendingIntent.CanceledException e) {
                Log.e("TextClassification", "Error sending PendingIntent", e);
            }
        };
    }

    private static final PendingIntent $$robo$$android_view_textclassifier_TextClassification$createPendingIntent(Context context, Intent intent, int requestCode) {
        int flags = 0x8000000;
        switch (TextClassification.getIntentType(intent, context)) {
            case 0: {
                return PendingIntent.getActivity(context, requestCode, intent, 0x8000000);
            }
            case 1: {
                return PendingIntent.getService(context, requestCode, intent, 0x8000000);
            }
        }
        return null;
    }

    private static final int $$robo$$android_view_textclassifier_TextClassification$getIntentType(Intent intent, Context context) {
        ResolveInfo serviceRI;
        Preconditions.checkArgument(context != null);
        Preconditions.checkArgument(intent != null);
        ResolveInfo activityRI = context.getPackageManager().resolveActivity(intent, 0);
        if (activityRI != null) {
            if (context.getPackageName().equals(activityRI.activityInfo.packageName)) {
                return 0;
            }
            boolean exported = activityRI.activityInfo.exported;
            if (exported && TextClassification.hasPermission(context, activityRI.activityInfo.permission)) {
                return 0;
            }
        }
        if ((serviceRI = context.getPackageManager().resolveService(intent, 0)) != null) {
            if (context.getPackageName().equals(serviceRI.serviceInfo.packageName)) {
                return 1;
            }
            boolean exported = serviceRI.serviceInfo.exported;
            if (exported && TextClassification.hasPermission(context, serviceRI.serviceInfo.permission)) {
                return 1;
            }
        }
        return -1;
    }

    private static final boolean $$robo$$android_view_textclassifier_TextClassification$hasPermission(Context context, String permission2) {
        return permission2 == null || context.checkSelfPermission(permission2) == 0;
    }

    private final int $$robo$$android_view_textclassifier_TextClassification$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_textclassifier_TextClassification$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mText);
        dest.writeTypedList(this.mActions);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mId);
    }

    private void $$robo$$android_view_textclassifier_TextClassification$__constructor__(Parcel in) {
        this.mText = in.readString();
        this.mActions = in.createTypedArrayList(RemoteAction.CREATOR);
        if (!this.mActions.isEmpty()) {
            RemoteAction action = this.mActions.get(0);
            this.mLegacyIcon = TextClassification.maybeLoadDrawable(action.getIcon());
            this.mLegacyLabel = action.getTitle().toString();
            this.mLegacyOnClickListener = TextClassification.createIntentOnClickListener(this.mActions.get(0).getActionIntent());
        } else {
            this.mLegacyIcon = null;
            this.mLegacyLabel = null;
            this.mLegacyOnClickListener = null;
        }
        this.mLegacyIntent = null;
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mId = in.readString();
    }

    private static final Drawable $$robo$$android_view_textclassifier_TextClassification$maybeLoadDrawable(Icon icon) {
        if (icon == null) {
            return null;
        }
        switch (icon.getType()) {
            case 1: {
                return new BitmapDrawable(Resources.getSystem(), icon.getBitmap());
            }
            case 5: {
                return new AdaptiveIconDrawable(null, new BitmapDrawable(Resources.getSystem(), icon.getBitmap()));
            }
            case 3: {
                return new BitmapDrawable(Resources.getSystem(), BitmapFactory.decodeByteArray(icon.getDataBytes(), icon.getDataOffset(), icon.getDataLength()));
            }
        }
        return null;
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextClassification$__constructor__(String x0, Drawable x1, String x2, Intent x3, View.OnClickListener x4, List x5, Map x6, String x7, 1 x8) {
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextClassification$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        EMPTY = new Builder().build();
        CREATOR = new Parcelable.Creator<TextClassification>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textclassifier_TextClassification_1$__constructor__() {
            }

            private final TextClassification $$robo$$android_view_textclassifier_TextClassification_1$createFromParcel(Parcel in) {
                return new TextClassification(in, null);
            }

            private final TextClassification[] $$robo$$android_view_textclassifier_TextClassification_1$newArray(int size) {
                return new TextClassification[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textclassifier_TextClassification_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_1$__constructor__(), this);
            }

            @Override
            public TextClassification createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextClassification_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public TextClassification[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextClassification_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, Drawable drawable2, String string3, Intent intent, View.OnClickListener onClickListener, List<RemoteAction> list, Map<String, Float> map, String string4) {
        this.$$robo$$android_view_textclassifier_TextClassification$__constructor__(string2, drawable2, string3, intent, onClickListener, list, map, string4);
    }

    public TextClassification(String string2, Drawable drawable2, String string3, Intent intent, View.OnClickListener onClickListener, List<RemoteAction> list, Map<String, Float> map, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification$__constructor__(java.lang.String android.graphics.drawable.Drawable java.lang.String android.content.Intent android.view.View$OnClickListener java.util.List<android.app.RemoteAction> java.util.Map<java.lang.String, java.lang.Float> java.lang.String ), this, string2, drawable2, string3, intent, onClickListener, list, map, string4);
    }

    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_textclassifier_TextClassification$getText(), this);
    }

    public int getEntityCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEntityCount", $$robo$$android_view_textclassifier_TextClassification$getEntityCount(), this);
    }

    public String getEntity(int n) {
        return InvokeDynamicSupport.bootstrap("getEntity", $$robo$$android_view_textclassifier_TextClassification$getEntity(int ), this, n);
    }

    public float getConfidenceScore(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_TextClassification$getConfidenceScore(java.lang.String ), this, string2);
    }

    public List<RemoteAction> getActions() {
        return InvokeDynamicSupport.bootstrap("getActions", $$robo$$android_view_textclassifier_TextClassification$getActions(), this);
    }

    @Deprecated
    public Drawable getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_view_textclassifier_TextClassification$getIcon(), this);
    }

    @Deprecated
    public CharSequence getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_view_textclassifier_TextClassification$getLabel(), this);
    }

    @Deprecated
    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_view_textclassifier_TextClassification$getIntent(), this);
    }

    public View.OnClickListener getOnClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnClickListener", $$robo$$android_view_textclassifier_TextClassification$getOnClickListener(), this);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_textclassifier_TextClassification$getId(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextClassification$toString(), this);
    }

    public static View.OnClickListener createIntentOnClickListener(PendingIntent pendingIntent) {
        return InvokeDynamicSupport.bootstrapStatic("createIntentOnClickListener", $$robo$$android_view_textclassifier_TextClassification$createIntentOnClickListener(android.app.PendingIntent ), (PendingIntent)pendingIntent);
    }

    public static PendingIntent createPendingIntent(Context context, Intent intent, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createPendingIntent", $$robo$$android_view_textclassifier_TextClassification$createPendingIntent(android.content.Context android.content.Intent int ), (Context)context, (Intent)intent, (int)n);
    }

    private static int getIntentType(Intent intent, Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntentType", $$robo$$android_view_textclassifier_TextClassification$getIntentType(android.content.Intent android.content.Context ), (Intent)intent, (Context)context);
    }

    private static boolean hasPermission(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasPermission", $$robo$$android_view_textclassifier_TextClassification$hasPermission(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextClassification$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextClassification$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textclassifier_TextClassification$__constructor__(parcel);
    }

    public TextClassification(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification$__constructor__(android.os.Parcel ), this, parcel);
    }

    private static Drawable maybeLoadDrawable(Icon icon) {
        return InvokeDynamicSupport.bootstrapStatic("maybeLoadDrawable", $$robo$$android_view_textclassifier_TextClassification$maybeLoadDrawable(android.graphics.drawable.Icon ), (Icon)icon);
    }

    private /* synthetic */ void __constructor__(String string2, Drawable drawable2, String string3, Intent intent, View.OnClickListener onClickListener, List list, Map map, String string4, 1 var9_9) {
        this.$$robo$$android_view_textclassifier_TextClassification$__constructor__(string2, drawable2, string3, intent, onClickListener, list, map, string4, var9_9);
    }

    public /* synthetic */ TextClassification(String string2, Drawable drawable2, String string3, Intent intent, View.OnClickListener onClickListener, List list, Map map, String string4, 1 var9_9) {
        this(string2, drawable2, string3, intent, onClickListener, list, map, string4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification$__constructor__(java.lang.String android.graphics.drawable.Drawable java.lang.String android.content.Intent android.view.View$OnClickListener java.util.List java.util.Map java.lang.String android.view.textclassifier.TextClassification$1 ), this, string2, drawable2, string3, intent, onClickListener, list, map, string4, var9_9);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_textclassifier_TextClassification$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ TextClassification(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification$__constructor__(android.os.Parcel android.view.textclassifier.TextClassification$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(TextClassification.class);
    }

    public /* synthetic */ TextClassification() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassification)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Options
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TextClassificationSessionId mSessionId;
        private Request mRequest;
        private LocaleList mDefaultLocales;
        private ZonedDateTime mReferenceTime;

        private void $$robo$$android_view_textclassifier_TextClassification_Options$__constructor__() {
        }

        private void $$robo$$android_view_textclassifier_TextClassification_Options$__constructor__(TextClassificationSessionId sessionId, Request request) {
            this.mSessionId = sessionId;
            this.mRequest = request;
        }

        private static final Options $$robo$$android_view_textclassifier_TextClassification_Options$from(TextClassificationSessionId sessionId, Request request) {
            Options options = new Options(sessionId, request);
            options.setDefaultLocales(request.getDefaultLocales());
            options.setReferenceTime(request.getReferenceTime());
            return options;
        }

        private final Options $$robo$$android_view_textclassifier_TextClassification_Options$setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        private final Options $$robo$$android_view_textclassifier_TextClassification_Options$setReferenceTime(ZonedDateTime referenceTime) {
            this.mReferenceTime = referenceTime;
            return this;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextClassification_Options$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final ZonedDateTime $$robo$$android_view_textclassifier_TextClassification_Options$getReferenceTime() {
            return this.mReferenceTime;
        }

        private final Request $$robo$$android_view_textclassifier_TextClassification_Options$getRequest() {
            return this.mRequest;
        }

        private final TextClassificationSessionId $$robo$$android_view_textclassifier_TextClassification_Options$getSessionId() {
            return this.mSessionId;
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassification_Options$__constructor__();
        }

        public Options() {
            this(null, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Options$__constructor__(), this);
        }

        private void __constructor__(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$$android_view_textclassifier_TextClassification_Options$__constructor__(textClassificationSessionId, request);
        }

        public Options(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Options$__constructor__(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextClassification$Request ), this, textClassificationSessionId, request);
        }

        public static Options from(TextClassificationSessionId textClassificationSessionId, Request request) {
            return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_view_textclassifier_TextClassification_Options$from(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextClassification$Request ), (TextClassificationSessionId)textClassificationSessionId, (Request)request);
        }

        public Options setDefaultLocales(LocaleList localeList) {
            return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextClassification_Options$setDefaultLocales(android.os.LocaleList ), this, localeList);
        }

        public Options setReferenceTime(ZonedDateTime zonedDateTime) {
            return InvokeDynamicSupport.bootstrap("setReferenceTime", $$robo$$android_view_textclassifier_TextClassification_Options$setReferenceTime(java.time.ZonedDateTime ), this, zonedDateTime);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextClassification_Options$getDefaultLocales(), this);
        }

        public ZonedDateTime getReferenceTime() {
            return InvokeDynamicSupport.bootstrap("getReferenceTime", $$robo$$android_view_textclassifier_TextClassification_Options$getReferenceTime(), this);
        }

        public Request getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_view_textclassifier_TextClassification_Options$getRequest(), this);
        }

        public TextClassificationSessionId getSessionId() {
            return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_view_textclassifier_TextClassification_Options$getSessionId(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Options)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Request
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence mText;
        private int mStartIndex;
        private int mEndIndex;
        private LocaleList mDefaultLocales;
        private ZonedDateTime mReferenceTime;
        public static Parcelable.Creator<Request> CREATOR;

        private void $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales, ZonedDateTime referenceTime) {
            this.mText = text;
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mDefaultLocales = defaultLocales;
            this.mReferenceTime = referenceTime;
        }

        private final CharSequence $$robo$$android_view_textclassifier_TextClassification_Request$getText() {
            return this.mText;
        }

        private final int $$robo$$android_view_textclassifier_TextClassification_Request$getStartIndex() {
            return this.mStartIndex;
        }

        private final int $$robo$$android_view_textclassifier_TextClassification_Request$getEndIndex() {
            return this.mEndIndex;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextClassification_Request$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final ZonedDateTime $$robo$$android_view_textclassifier_TextClassification_Request$getReferenceTime() {
            return this.mReferenceTime;
        }

        private final int $$robo$$android_view_textclassifier_TextClassification_Request$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_textclassifier_TextClassification_Request$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeInt(this.mStartIndex);
            dest.writeInt(this.mEndIndex);
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mReferenceTime != null ? 1 : 0);
            if (this.mReferenceTime != null) {
                dest.writeString(this.mReferenceTime.toString());
            }
        }

        private void $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(Parcel in) {
            this.mText = in.readString();
            this.mStartIndex = in.readInt();
            this.mEndIndex = in.readInt();
            this.mDefaultLocales = in.readInt() == 0 ? null : LocaleList.CREATOR.createFromParcel(in);
            this.mReferenceTime = in.readInt() == 0 ? null : ZonedDateTime.parse(in.readString());
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(CharSequence x0, int x1, int x2, LocaleList x3, ZonedDateTime x4, 1 x5) {
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Request>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_textclassifier_TextClassification_Request_1$__constructor__() {
                }

                private final Request $$robo$$android_view_textclassifier_TextClassification_Request_1$createFromParcel(Parcel in) {
                    return new Request(in, null);
                }

                private final Request[] $$robo$$android_view_textclassifier_TextClassification_Request_1$newArray(int size) {
                    return new Request[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_textclassifier_TextClassification_Request_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request_1$__constructor__(), this);
                }

                @Override
                public Request createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextClassification_Request_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Request[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextClassification_Request_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(CharSequence charSequence, int n, int n2, LocaleList localeList, ZonedDateTime zonedDateTime) {
            this.$$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(charSequence, n, n2, localeList, zonedDateTime);
        }

        public Request(CharSequence charSequence, int n, int n2, LocaleList localeList, ZonedDateTime zonedDateTime) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(java.lang.CharSequence int int android.os.LocaleList java.time.ZonedDateTime ), this, charSequence, n, n2, localeList, zonedDateTime);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_textclassifier_TextClassification_Request$getText(), this);
        }

        public int getStartIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getStartIndex", $$robo$$android_view_textclassifier_TextClassification_Request$getStartIndex(), this);
        }

        public int getEndIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getEndIndex", $$robo$$android_view_textclassifier_TextClassification_Request$getEndIndex(), this);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextClassification_Request$getDefaultLocales(), this);
        }

        public ZonedDateTime getReferenceTime() {
            return InvokeDynamicSupport.bootstrap("getReferenceTime", $$robo$$android_view_textclassifier_TextClassification_Request$getReferenceTime(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextClassification_Request$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextClassification_Request$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(parcel);
        }

        public Request(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(CharSequence charSequence, int n, int n2, LocaleList localeList, ZonedDateTime zonedDateTime, 1 var6_6) {
            this.$$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(charSequence, n, n2, localeList, zonedDateTime, var6_6);
        }

        public /* synthetic */ Request(CharSequence charSequence, int n, int n2, LocaleList localeList, ZonedDateTime zonedDateTime, 1 var6_6) {
            this(charSequence, n, n2, localeList, zonedDateTime);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(java.lang.CharSequence int int android.os.LocaleList java.time.ZonedDateTime android.view.textclassifier.TextClassification$1 ), this, charSequence, n, n2, localeList, zonedDateTime, var6_6);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ Request(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request$__constructor__(android.os.Parcel android.view.textclassifier.TextClassification$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Request.class);
        }

        public /* synthetic */ Request() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private CharSequence mText;
            private int mStartIndex;
            private int mEndIndex;
            private LocaleList mDefaultLocales;
            private ZonedDateTime mReferenceTime;

            private void $$robo$$android_view_textclassifier_TextClassification_Request_Builder$__constructor__(CharSequence text, int startIndex, int endIndex) {
                TextClassifier.Utils.checkArgument(text, startIndex, endIndex);
                this.mText = text;
                this.mStartIndex = startIndex;
                this.mEndIndex = endIndex;
            }

            private final Builder $$robo$$android_view_textclassifier_TextClassification_Request_Builder$setDefaultLocales(LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            private final Builder $$robo$$android_view_textclassifier_TextClassification_Request_Builder$setReferenceTime(ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            private final Request $$robo$$android_view_textclassifier_TextClassification_Request_Builder$build() {
                return new Request(this.mText, this.mStartIndex, this.mEndIndex, this.mDefaultLocales, this.mReferenceTime, null);
            }

            private void __constructor__(CharSequence charSequence, int n, int n2) {
                this.$$robo$$android_view_textclassifier_TextClassification_Request_Builder$__constructor__(charSequence, n, n2);
            }

            public Builder(CharSequence charSequence, int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Request_Builder$__constructor__(java.lang.CharSequence int int ), this, charSequence, n, n2);
            }

            public Builder setDefaultLocales(LocaleList localeList) {
                return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextClassification_Request_Builder$setDefaultLocales(android.os.LocaleList ), this, localeList);
            }

            public Builder setReferenceTime(ZonedDateTime zonedDateTime) {
                return InvokeDynamicSupport.bootstrap("setReferenceTime", $$robo$$android_view_textclassifier_TextClassification_Request_Builder$setReferenceTime(java.time.ZonedDateTime ), this, zonedDateTime);
            }

            public Request build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextClassification_Request_Builder$build(), this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private List<RemoteAction> mActions;
        private Map<String, Float> mEntityConfidence;
        private String mText;
        private Drawable mLegacyIcon;
        private String mLegacyLabel;
        private Intent mLegacyIntent;
        private View.OnClickListener mLegacyOnClickListener;
        private String mId;

        private void $$robo$$android_view_textclassifier_TextClassification_Builder$__constructor__() {
            this.mActions = new ArrayList<RemoteAction>();
            this.mEntityConfidence = new ArrayMap<String, Float>();
        }

        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setText(String text) {
            this.mText = text;
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$addAction(RemoteAction action) {
            Preconditions.checkArgument(action != null);
            this.mActions.add(action);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setIcon(Drawable icon) {
            this.mLegacyIcon = icon;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setLabel(String label) {
            this.mLegacyLabel = label;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setIntent(Intent intent) {
            this.mLegacyIntent = intent;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setOnClickListener(View.OnClickListener onClickListener) {
            this.mLegacyOnClickListener = onClickListener;
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextClassification_Builder$setId(String id2) {
            this.mId = id2;
            return this;
        }

        private final TextClassification $$robo$$android_view_textclassifier_TextClassification_Builder$build() {
            return new TextClassification(this.mText, this.mLegacyIcon, this.mLegacyLabel, this.mLegacyIntent, this.mLegacyOnClickListener, this.mActions, this.mEntityConfidence, this.mId, null);
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassification_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassification_Builder$__constructor__(), this);
        }

        public Builder setText(String string2) {
            return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_view_textclassifier_TextClassification_Builder$setText(java.lang.String ), this, string2);
        }

        public Builder setEntityType(String string2, float f) {
            return InvokeDynamicSupport.bootstrap("setEntityType", $$robo$$android_view_textclassifier_TextClassification_Builder$setEntityType(java.lang.String float ), this, string2, f);
        }

        public Builder addAction(RemoteAction remoteAction) {
            return InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_view_textclassifier_TextClassification_Builder$addAction(android.app.RemoteAction ), this, remoteAction);
        }

        @Deprecated
        public Builder setIcon(Drawable drawable2) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_view_textclassifier_TextClassification_Builder$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
        }

        @Deprecated
        public Builder setLabel(String string2) {
            return InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_view_textclassifier_TextClassification_Builder$setLabel(java.lang.String ), this, string2);
        }

        @Deprecated
        public Builder setIntent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_view_textclassifier_TextClassification_Builder$setIntent(android.content.Intent ), this, intent);
        }

        @Deprecated
        public Builder setOnClickListener(View.OnClickListener onClickListener) {
            return InvokeDynamicSupport.bootstrap("setOnClickListener", $$robo$$android_view_textclassifier_TextClassification_Builder$setOnClickListener(android.view.View$OnClickListener ), this, onClickListener);
        }

        public Builder setId(String string2) {
            return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_view_textclassifier_TextClassification_Builder$setId(java.lang.String ), this, string2);
        }

        public TextClassification build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextClassification_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface IntentType {
        public static final int UNSUPPORTED = -1;
        public static final int ACTIVITY = 0;
        public static final int SERVICE = 1;
    }
}

