/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.database.ContentObserver;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.textclassifier.TextClassifierService;
import android.view.textclassifier.Log;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSession;
import android.view.textclassifier.TextClassificationSessionFactory;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassificationManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TextClassificationManager";
    private Object mLock;
    private TextClassificationSessionFactory mDefaultSessionFactory;
    private Context mContext;
    private SettingsObserver mSettingsObserver;
    @GuardedBy(value="mLock")
    private TextClassifier mCustomTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassifier mLocalTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassifier mSystemTextClassifier;
    @GuardedBy(value="mLock")
    private TextClassificationSessionFactory mSessionFactory;
    @GuardedBy(value="mLock")
    private TextClassificationConstants mSettings;

    private void $$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(Context context) {
        this.mLock = new Object();
        this.mDefaultSessionFactory = classificationContext -> new TextClassificationSession(classificationContext, this.getTextClassifier());
        this.mContext = Preconditions.checkNotNull(context);
        this.mSessionFactory = this.mDefaultSessionFactory;
        this.mSettingsObserver = new SettingsObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCustomTextClassifier != null) {
                return this.mCustomTextClassifier;
            }
            if (this.isSystemTextClassifierEnabled()) {
                return this.getSystemTextClassifier();
            }
            return this.getLocalTextClassifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassifier(TextClassifier textClassifier) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCustomTextClassifier = textClassifier;
        }
    }

    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier(int type) {
        switch (type) {
            case 0: {
                return this.getLocalTextClassifier();
            }
        }
        return this.getSystemTextClassifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassificationConstants $$robo$$android_view_textclassifier_TextClassificationManager$getSettings() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSettings == null) {
                this.mSettings = TextClassificationConstants.loadFromString(Settings.Global.getString(this.getApplicationContext().getContentResolver(), "text_classifier_constants"));
            }
            return this.mSettings;
        }
    }

    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$createTextClassificationSession(TextClassificationContext classificationContext) {
        Preconditions.checkNotNull(classificationContext);
        TextClassifier textClassifier = this.mSessionFactory.createTextClassificationSession(classificationContext);
        Preconditions.checkNotNull(textClassifier, "Session Factory should never return null");
        return textClassifier;
    }

    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$createTextClassificationSession(TextClassificationContext classificationContext, TextClassifier textClassifier) {
        Preconditions.checkNotNull(classificationContext);
        Preconditions.checkNotNull(textClassifier);
        return new TextClassificationSession(classificationContext, textClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassificationSessionFactory(TextClassificationSessionFactory factory) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionFactory = factory != null ? factory : this.mDefaultSessionFactory;
        }
    }

    private final void $$robo$$android_view_textclassifier_TextClassificationManager$finalize() throws Throwable {
        try {
            if (this.mSettingsObserver != null) {
                this.getApplicationContext().getContentResolver().unregisterContentObserver(this.mSettingsObserver);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$getSystemTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSystemTextClassifier == null && this.isSystemTextClassifierEnabled()) {
                try {
                    this.mSystemTextClassifier = new SystemTextClassifier(this.mContext, this.getSettings());
                    Log.d("TextClassificationManager", "Initialized SystemTextClassifier");
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    Log.e("TextClassificationManager", "Could not initialize SystemTextClassifier", e);
                }
            }
        }
        if (this.mSystemTextClassifier != null) {
            return this.mSystemTextClassifier;
        }
        return TextClassifier.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$getLocalTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocalTextClassifier == null) {
                if (this.getSettings().isLocalTextClassifierEnabled()) {
                    this.mLocalTextClassifier = new TextClassifierImpl(this.mContext, this.getSettings(), TextClassifier.NO_OP);
                } else {
                    Log.d("TextClassificationManager", "Local TextClassifier disabled");
                    this.mLocalTextClassifier = TextClassifier.NO_OP;
                }
            }
            return this.mLocalTextClassifier;
        }
    }

    private final boolean $$robo$$android_view_textclassifier_TextClassificationManager$isSystemTextClassifierEnabled() {
        return this.getSettings().isSystemTextClassifierEnabled() && TextClassifierService.getServiceComponentName(this.mContext) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_textclassifier_TextClassificationManager$invalidate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSettings = null;
            this.mLocalTextClassifier = null;
            this.mSystemTextClassifier = null;
        }
    }

    private final Context $$robo$$android_view_textclassifier_TextClassificationManager$getApplicationContext() {
        return this.mContext.getApplicationContext() != null ? this.mContext.getApplicationContext() : this.mContext;
    }

    private static final TextClassificationConstants $$robo$$android_view_textclassifier_TextClassificationManager$getSettings(Context context) {
        Preconditions.checkNotNull(context);
        TextClassificationManager tcm = context.getSystemService(TextClassificationManager.class);
        if (tcm != null) {
            return tcm.getSettings();
        }
        return TextClassificationConstants.loadFromString(Settings.Global.getString(context.getApplicationContext().getContentResolver(), "text_classifier_constants"));
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(context);
    }

    public TextClassificationManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(android.content.Context ), this, context);
    }

    public TextClassifier getTextClassifier() {
        return InvokeDynamicSupport.bootstrap("getTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier(), this);
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        InvokeDynamicSupport.bootstrap("setTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassifier(android.view.textclassifier.TextClassifier ), this, textClassifier);
    }

    public TextClassifier getTextClassifier(int n) {
        return InvokeDynamicSupport.bootstrap("getTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier(int ), this, n);
    }

    private TextClassificationConstants getSettings() {
        return InvokeDynamicSupport.bootstrap("getSettings", $$robo$$android_view_textclassifier_TextClassificationManager$getSettings(), this);
    }

    public TextClassifier createTextClassificationSession(TextClassificationContext textClassificationContext) {
        return InvokeDynamicSupport.bootstrap("createTextClassificationSession", $$robo$$android_view_textclassifier_TextClassificationManager$createTextClassificationSession(android.view.textclassifier.TextClassificationContext ), this, textClassificationContext);
    }

    public TextClassifier createTextClassificationSession(TextClassificationContext textClassificationContext, TextClassifier textClassifier) {
        return InvokeDynamicSupport.bootstrap("createTextClassificationSession", $$robo$$android_view_textclassifier_TextClassificationManager$createTextClassificationSession(android.view.textclassifier.TextClassificationContext android.view.textclassifier.TextClassifier ), this, textClassificationContext, textClassifier);
    }

    public void setTextClassificationSessionFactory(TextClassificationSessionFactory textClassificationSessionFactory) {
        InvokeDynamicSupport.bootstrap("setTextClassificationSessionFactory", $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassificationSessionFactory(android.view.textclassifier.TextClassificationSessionFactory ), this, textClassificationSessionFactory);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_textclassifier_TextClassificationManager$finalize(), this);
    }

    private TextClassifier getSystemTextClassifier() {
        return InvokeDynamicSupport.bootstrap("getSystemTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$getSystemTextClassifier(), this);
    }

    private TextClassifier getLocalTextClassifier() {
        return InvokeDynamicSupport.bootstrap("getLocalTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$getLocalTextClassifier(), this);
    }

    private boolean isSystemTextClassifierEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemTextClassifierEnabled", $$robo$$android_view_textclassifier_TextClassificationManager$isSystemTextClassifierEnabled(), this);
    }

    private void invalidate() {
        InvokeDynamicSupport.bootstrap("invalidate", $$robo$$android_view_textclassifier_TextClassificationManager$invalidate(), this);
    }

    Context getApplicationContext() {
        return InvokeDynamicSupport.bootstrap("getApplicationContext", $$robo$$android_view_textclassifier_TextClassificationManager$getApplicationContext(), this);
    }

    public static TextClassificationConstants getSettings(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSettings", $$robo$$android_view_textclassifier_TextClassificationManager$getSettings(android.content.Context ), (Context)context);
    }

    public /* synthetic */ TextClassificationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<TextClassificationManager> mTcm;

        private void $$robo$$android_view_textclassifier_TextClassificationManager_SettingsObserver$__constructor__(TextClassificationManager tcm) {
            this.mTcm = new WeakReference<TextClassificationManager>(tcm);
            tcm.getApplicationContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("text_classifier_constants"), false, this);
        }

        private final void $$robo$$android_view_textclassifier_TextClassificationManager_SettingsObserver$onChange(boolean selfChange) {
            TextClassificationManager tcm = (TextClassificationManager)this.mTcm.get();
            if (tcm != null) {
                tcm.invalidate();
            }
        }

        private void __constructor__(TextClassificationManager textClassificationManager) {
            this.$$robo$$android_view_textclassifier_TextClassificationManager_SettingsObserver$__constructor__(textClassificationManager);
        }

        public SettingsObserver(TextClassificationManager textClassificationManager) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationManager_SettingsObserver$__constructor__(android.view.textclassifier.TextClassificationManager ), this, textClassificationManager);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_view_textclassifier_TextClassificationManager_SettingsObserver$onChange(boolean ), this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

