/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextSelection
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mStartIndex;
    private int mEndIndex;
    private EntityConfidence mEntityConfidence;
    private String mId;
    public static Parcelable.Creator<TextSelection> CREATOR;

    private void $$robo$$android_view_textclassifier_TextSelection$__constructor__(int startIndex, int endIndex, Map<String, Float> entityConfidence, String id2) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence(entityConfidence);
        this.mId = id2;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getSelectionStartIndex() {
        return this.mStartIndex;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getSelectionEndIndex() {
        return this.mEndIndex;
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    private final float $$robo$$android_view_textclassifier_TextSelection$getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$getId() {
        return this.mId;
    }

    private final String $$robo$$android_view_textclassifier_TextSelection$toString() {
        return String.format(Locale.US, "TextSelection {id=%s, startIndex=%d, endIndex=%d, entities=%s}", this.mId, this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
    }

    private final int $$robo$$android_view_textclassifier_TextSelection$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_textclassifier_TextSelection$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStartIndex);
        dest.writeInt(this.mEndIndex);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mId);
    }

    private void $$robo$$android_view_textclassifier_TextSelection$__constructor__(Parcel in) {
        this.mStartIndex = in.readInt();
        this.mEndIndex = in.readInt();
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mId = in.readString();
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextSelection$__constructor__(int x0, int x1, Map x2, String x3, 1 x4) {
    }

    private /* synthetic */ void $$robo$$android_view_textclassifier_TextSelection$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<TextSelection>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_textclassifier_TextSelection_1$__constructor__() {
            }

            private final TextSelection $$robo$$android_view_textclassifier_TextSelection_1$createFromParcel(Parcel in) {
                return new TextSelection(in, null);
            }

            private final TextSelection[] $$robo$$android_view_textclassifier_TextSelection_1$newArray(int size) {
                return new TextSelection[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_textclassifier_TextSelection_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_1$__constructor__(), this);
            }

            @Override
            public TextSelection createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextSelection_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public TextSelection[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextSelection_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, Map<String, Float> map, String string2) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(n, n2, map, string2);
    }

    public TextSelection(int n, int n2, Map<String, Float> map, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection$__constructor__(int int java.util.Map<java.lang.String, java.lang.Float> java.lang.String ), this, n, n2, map, string2);
    }

    public int getSelectionStartIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionStartIndex", $$robo$$android_view_textclassifier_TextSelection$getSelectionStartIndex(), this);
    }

    public int getSelectionEndIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionEndIndex", $$robo$$android_view_textclassifier_TextSelection$getSelectionEndIndex(), this);
    }

    public int getEntityCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEntityCount", $$robo$$android_view_textclassifier_TextSelection$getEntityCount(), this);
    }

    public String getEntity(int n) {
        return InvokeDynamicSupport.bootstrap("getEntity", $$robo$$android_view_textclassifier_TextSelection$getEntity(int ), this, n);
    }

    public float getConfidenceScore(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_TextSelection$getConfidenceScore(java.lang.String ), this, string2);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_textclassifier_TextSelection$getId(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_TextSelection$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextSelection$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextSelection$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(parcel);
    }

    public TextSelection(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection$__constructor__(android.os.Parcel ), this, parcel);
    }

    private /* synthetic */ void __constructor__(int n, int n2, Map map, String string2, 1 var5_5) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(n, n2, map, string2, var5_5);
    }

    public /* synthetic */ TextSelection(int n, int n2, Map map, String string2, 1 var5_5) {
        this(n, n2, map, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection$__constructor__(int int java.util.Map java.lang.String android.view.textclassifier.TextSelection$1 ), this, n, n2, map, string2, var5_5);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_textclassifier_TextSelection$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ TextSelection(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection$__constructor__(android.os.Parcel android.view.textclassifier.TextSelection$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(TextSelection.class);
    }

    public /* synthetic */ TextSelection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextSelection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Options
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TextClassificationSessionId mSessionId;
        private Request mRequest;
        private LocaleList mDefaultLocales;
        private boolean mDarkLaunchAllowed;

        private void $$robo$$android_view_textclassifier_TextSelection_Options$__constructor__() {
        }

        private void $$robo$$android_view_textclassifier_TextSelection_Options$__constructor__(TextClassificationSessionId sessionId, Request request) {
            this.mSessionId = sessionId;
            this.mRequest = request;
        }

        private static final Options $$robo$$android_view_textclassifier_TextSelection_Options$from(TextClassificationSessionId sessionId, Request request) {
            Options options = new Options(sessionId, request);
            options.setDefaultLocales(request.getDefaultLocales());
            return options;
        }

        private final Options $$robo$$android_view_textclassifier_TextSelection_Options$setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextSelection_Options$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final Request $$robo$$android_view_textclassifier_TextSelection_Options$getRequest() {
            return this.mRequest;
        }

        private final TextClassificationSessionId $$robo$$android_view_textclassifier_TextSelection_Options$getSessionId() {
            return this.mSessionId;
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextSelection_Options$__constructor__();
        }

        public Options() {
            this(null, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Options$__constructor__(), this);
        }

        private void __constructor__(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$$android_view_textclassifier_TextSelection_Options$__constructor__(textClassificationSessionId, request);
        }

        public Options(TextClassificationSessionId textClassificationSessionId, Request request) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Options$__constructor__(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextSelection$Request ), this, textClassificationSessionId, request);
        }

        public static Options from(TextClassificationSessionId textClassificationSessionId, Request request) {
            return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_view_textclassifier_TextSelection_Options$from(android.view.textclassifier.TextClassificationSessionId android.view.textclassifier.TextSelection$Request ), (TextClassificationSessionId)textClassificationSessionId, (Request)request);
        }

        public Options setDefaultLocales(LocaleList localeList) {
            return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextSelection_Options$setDefaultLocales(android.os.LocaleList ), this, localeList);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextSelection_Options$getDefaultLocales(), this);
        }

        public Request getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_view_textclassifier_TextSelection_Options$getRequest(), this);
        }

        public TextClassificationSessionId getSessionId() {
            return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_view_textclassifier_TextSelection_Options$getSessionId(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Options)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Request
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence mText;
        private int mStartIndex;
        private int mEndIndex;
        private LocaleList mDefaultLocales;
        private boolean mDarkLaunchAllowed;
        public static Parcelable.Creator<Request> CREATOR;

        private void $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales, boolean darkLaunchAllowed) {
            this.mText = text;
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mDefaultLocales = defaultLocales;
            this.mDarkLaunchAllowed = darkLaunchAllowed;
        }

        private final CharSequence $$robo$$android_view_textclassifier_TextSelection_Request$getText() {
            return this.mText;
        }

        private final int $$robo$$android_view_textclassifier_TextSelection_Request$getStartIndex() {
            return this.mStartIndex;
        }

        private final int $$robo$$android_view_textclassifier_TextSelection_Request$getEndIndex() {
            return this.mEndIndex;
        }

        private final boolean $$robo$$android_view_textclassifier_TextSelection_Request$isDarkLaunchAllowed() {
            return this.mDarkLaunchAllowed;
        }

        private final LocaleList $$robo$$android_view_textclassifier_TextSelection_Request$getDefaultLocales() {
            return this.mDefaultLocales;
        }

        private final int $$robo$$android_view_textclassifier_TextSelection_Request$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_textclassifier_TextSelection_Request$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mText.toString());
            dest.writeInt(this.mStartIndex);
            dest.writeInt(this.mEndIndex);
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
        }

        private void $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(Parcel in) {
            this.mText = in.readString();
            this.mStartIndex = in.readInt();
            this.mEndIndex = in.readInt();
            this.mDefaultLocales = in.readInt() == 0 ? null : LocaleList.CREATOR.createFromParcel(in);
            this.mDarkLaunchAllowed = false;
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(CharSequence x0, int x1, int x2, LocaleList x3, boolean x4, 1 x5) {
        }

        private /* synthetic */ void $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Request>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_textclassifier_TextSelection_Request_1$__constructor__() {
                }

                private final Request $$robo$$android_view_textclassifier_TextSelection_Request_1$createFromParcel(Parcel in) {
                    return new Request(in, null);
                }

                private final Request[] $$robo$$android_view_textclassifier_TextSelection_Request_1$newArray(int size) {
                    return new Request[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_textclassifier_TextSelection_Request_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request_1$__constructor__(), this);
                }

                @Override
                public Request createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_textclassifier_TextSelection_Request_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Request[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_textclassifier_TextSelection_Request_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(CharSequence charSequence, int n, int n2, LocaleList localeList, boolean bl) {
            this.$$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(charSequence, n, n2, localeList, bl);
        }

        public Request(CharSequence charSequence, int n, int n2, LocaleList localeList, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(java.lang.CharSequence int int android.os.LocaleList boolean ), this, charSequence, n, n2, localeList, bl);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_textclassifier_TextSelection_Request$getText(), this);
        }

        public int getStartIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getStartIndex", $$robo$$android_view_textclassifier_TextSelection_Request$getStartIndex(), this);
        }

        public int getEndIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getEndIndex", $$robo$$android_view_textclassifier_TextSelection_Request$getEndIndex(), this);
        }

        public boolean isDarkLaunchAllowed() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDarkLaunchAllowed", $$robo$$android_view_textclassifier_TextSelection_Request$isDarkLaunchAllowed(), this);
        }

        public LocaleList getDefaultLocales() {
            return InvokeDynamicSupport.bootstrap("getDefaultLocales", $$robo$$android_view_textclassifier_TextSelection_Request$getDefaultLocales(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_textclassifier_TextSelection_Request$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_textclassifier_TextSelection_Request$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(parcel);
        }

        public Request(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(CharSequence charSequence, int n, int n2, LocaleList localeList, boolean bl, 1 var6_6) {
            this.$$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(charSequence, n, n2, localeList, bl, var6_6);
        }

        public /* synthetic */ Request(CharSequence charSequence, int n, int n2, LocaleList localeList, boolean bl, 1 var6_6) {
            this(charSequence, n, n2, localeList, bl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(java.lang.CharSequence int int android.os.LocaleList boolean android.view.textclassifier.TextSelection$1 ), this, charSequence, n, n2, localeList, bl, var6_6);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ Request(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request$__constructor__(android.os.Parcel android.view.textclassifier.TextSelection$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Request.class);
        }

        public /* synthetic */ Request() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private CharSequence mText;
            private int mStartIndex;
            private int mEndIndex;
            private LocaleList mDefaultLocales;
            private boolean mDarkLaunchAllowed;

            private void $$robo$$android_view_textclassifier_TextSelection_Request_Builder$__constructor__(CharSequence text, int startIndex, int endIndex) {
                TextClassifier.Utils.checkArgument(text, startIndex, endIndex);
                this.mText = text;
                this.mStartIndex = startIndex;
                this.mEndIndex = endIndex;
            }

            private final Builder $$robo$$android_view_textclassifier_TextSelection_Request_Builder$setDefaultLocales(LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            private final Builder $$robo$$android_view_textclassifier_TextSelection_Request_Builder$setDarkLaunchAllowed(boolean allowed) {
                this.mDarkLaunchAllowed = allowed;
                return this;
            }

            private final Request $$robo$$android_view_textclassifier_TextSelection_Request_Builder$build() {
                return new Request(this.mText, this.mStartIndex, this.mEndIndex, this.mDefaultLocales, this.mDarkLaunchAllowed, null);
            }

            private void __constructor__(CharSequence charSequence, int n, int n2) {
                this.$$robo$$android_view_textclassifier_TextSelection_Request_Builder$__constructor__(charSequence, n, n2);
            }

            public Builder(CharSequence charSequence, int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Request_Builder$__constructor__(java.lang.CharSequence int int ), this, charSequence, n, n2);
            }

            public Builder setDefaultLocales(LocaleList localeList) {
                return InvokeDynamicSupport.bootstrap("setDefaultLocales", $$robo$$android_view_textclassifier_TextSelection_Request_Builder$setDefaultLocales(android.os.LocaleList ), this, localeList);
            }

            public Builder setDarkLaunchAllowed(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setDarkLaunchAllowed", $$robo$$android_view_textclassifier_TextSelection_Request_Builder$setDarkLaunchAllowed(boolean ), this, bl);
            }

            public Request build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextSelection_Request_Builder$build(), this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mStartIndex;
        private int mEndIndex;
        private Map<String, Float> mEntityConfidence;
        private String mId;

        private void $$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(int startIndex, int endIndex) {
            this.mEntityConfidence = new ArrayMap<String, Float>();
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        private final Builder $$robo$$android_view_textclassifier_TextSelection_Builder$setEntityType(String type, float confidenceScore) {
            Preconditions.checkNotNull(type);
            this.mEntityConfidence.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        private final Builder $$robo$$android_view_textclassifier_TextSelection_Builder$setId(String id2) {
            this.mId = id2;
            return this;
        }

        private final TextSelection $$robo$$android_view_textclassifier_TextSelection_Builder$build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mId, null);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(n, n2);
        }

        public Builder(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextSelection_Builder$__constructor__(int int ), this, n, n2);
        }

        public Builder setEntityType(String string2, float f) {
            return InvokeDynamicSupport.bootstrap("setEntityType", $$robo$$android_view_textclassifier_TextSelection_Builder$setEntityType(java.lang.String float ), this, string2, f);
        }

        public Builder setId(String string2) {
            return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_view_textclassifier_TextSelection_Builder$setId(java.lang.String ), this, string2);
        }

        public TextSelection build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_textclassifier_TextSelection_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

