/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FindAddress
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MIN_ADDRESS_WORDS = 4;
    private static int MAX_ADDRESS_WORDS = 14;
    private static int MAX_ADDRESS_LINES = 5;
    private static int kMaxAddressNameWordLength = 25;
    private static int MAX_LOCATION_NAME_DISTANCE = 5;
    private static ZipRange[] sStateZipCodeRanges;
    private static String NL = "\n\u000b\f\r\u0085\u2028\u2029";
    private static String SP = "\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000";
    private static String WS = "\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029";
    private static String WORD_DELIM = ",*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029";
    private static String WORD_END = "(?=[,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)";
    private static Pattern sWordRe;
    private static String HOUSE_POST_DELIM = ",\"'\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029";
    private static String HOUSE_END = "(?=[,\"'\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)";
    private static String HOUSE_PRE_DELIM = ":,\"'\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029";
    private static String HOUSE_COMPONENT = "(?:one|\\d+([a-z](?=[^a-z]|$)|st|nd|rd|th)?)";
    private static Pattern sHouseNumberRe;
    private static Pattern sStateRe;
    private static Pattern sLocationNameRe;
    private static Pattern sSuffixedNumberRe;
    private static Pattern sZipCodeRe;

    private void $$robo$$android_webkit_FindAddress$__constructor__() {
    }

    private static final boolean $$robo$$android_webkit_FindAddress$checkHouseNumber(String houseNumber) {
        int digitCount = 0;
        for (int i = 0; i < houseNumber.length(); ++i) {
            if (!Character.isDigit(houseNumber.charAt(i))) continue;
            ++digitCount;
        }
        if (digitCount > 5) {
            return false;
        }
        Matcher suffixMatcher = sSuffixedNumberRe.matcher(houseNumber);
        if (suffixMatcher.find()) {
            int num = Integer.parseInt(suffixMatcher.group(1));
            if (num == 0) {
                return false;
            }
            String suffix = suffixMatcher.group(2).toLowerCase(Locale.getDefault());
            switch (num % 10) {
                case 1: {
                    return suffix.equals(num % 100 == 11 ? "th" : "st");
                }
                case 2: {
                    return suffix.equals(num % 100 == 12 ? "th" : "nd");
                }
                case 3: {
                    return suffix.equals(num % 100 == 13 ? "th" : "rd");
                }
            }
            return suffix.equals("th");
        }
        return true;
    }

    private static final MatchResult $$robo$$android_webkit_FindAddress$matchHouseNumber(String content, int offset) {
        MatchResult matchResult;
        if (offset > 0 && ":,\"'\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029".indexOf(content.charAt(offset - 1)) == -1) {
            return null;
        }
        Matcher matcher = sHouseNumberRe.matcher(content).region(offset, content.length());
        if (matcher.lookingAt() && FindAddress.checkHouseNumber((matchResult = matcher.toMatchResult()).group(0))) {
            return matchResult;
        }
        return null;
    }

    private static final MatchResult $$robo$$android_webkit_FindAddress$matchState(String content, int offset) {
        if (offset > 0 && ",*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029".indexOf(content.charAt(offset - 1)) == -1) {
            return null;
        }
        Matcher stateMatcher = sStateRe.matcher(content).region(offset, content.length());
        return stateMatcher.lookingAt() ? stateMatcher.toMatchResult() : null;
    }

    private static final boolean $$robo$$android_webkit_FindAddress$isValidZipCode(String zipCode, MatchResult stateMatch) {
        if (stateMatch == null) {
            return false;
        }
        int stateIndex = stateMatch.groupCount();
        while (stateIndex > 0 && stateMatch.group(stateIndex--) == null) {
        }
        return sZipCodeRe.matcher(zipCode).matches() && sStateZipCodeRanges[stateIndex].matches(zipCode);
    }

    private static final boolean $$robo$$android_webkit_FindAddress$isValidLocationName(String location) {
        return sLocationNameRe.matcher(location).matches();
    }

    private static final int $$robo$$android_webkit_FindAddress$attemptMatch(String content, MatchResult houseNumberMatch) {
        int restartPos = -1;
        int nonZipMatch = -1;
        int it = houseNumberMatch.end();
        int numLines = 1;
        boolean consecutiveHouseNumbers = true;
        boolean foundLocationName = false;
        int wordCount = 1;
        String lastWord = "";
        Matcher matcher = sWordRe.matcher(content);
        while (it < content.length()) {
            if (!matcher.find(it)) {
                return -content.length();
            }
            if (matcher.end() - matcher.start() > 25) {
                return -matcher.end();
            }
            while (it < matcher.start()) {
                if ("\n\u000b\f\r\u0085\u2028\u2029".indexOf(content.charAt(it++)) == -1) continue;
                ++numLines;
            }
            if (numLines > 5 || ++wordCount > 14) break;
            if (FindAddress.matchHouseNumber(content, it) != null) {
                if (consecutiveHouseNumbers && numLines > 1) {
                    return -it;
                }
                if (restartPos == -1) {
                    restartPos = it;
                }
            } else {
                consecutiveHouseNumbers = false;
                if (FindAddress.isValidLocationName(matcher.group(0))) {
                    foundLocationName = true;
                } else {
                    MatchResult stateMatch;
                    if (wordCount == 5 && !foundLocationName) {
                        it = matcher.end();
                        break;
                    }
                    if (foundLocationName && wordCount > 4 && (stateMatch = FindAddress.matchState(content, it)) != null) {
                        if (lastWord.equals("et") && stateMatch.group(0).equals("al")) {
                            it = stateMatch.end();
                            break;
                        }
                        Matcher zipMatcher = sWordRe.matcher(content);
                        if (zipMatcher.find(stateMatch.end())) {
                            if (FindAddress.isValidZipCode(zipMatcher.group(0), stateMatch)) {
                                return zipMatcher.end();
                            }
                        } else {
                            nonZipMatch = stateMatch.end();
                        }
                    }
                }
            }
            lastWord = matcher.group(0);
            it = matcher.end();
        }
        if (nonZipMatch > 0) {
            return nonZipMatch;
        }
        return -(restartPos > 0 ? restartPos : it);
    }

    private static final String $$robo$$android_webkit_FindAddress$findAddress(String content) {
        Matcher houseNumberMatcher = sHouseNumberRe.matcher(content);
        int start = 0;
        while (houseNumberMatcher.find(start)) {
            if (FindAddress.checkHouseNumber(houseNumberMatcher.group(0))) {
                start = houseNumberMatcher.start();
                int end = FindAddress.attemptMatch(content, houseNumberMatcher);
                if (end > 0) {
                    return content.substring(start, end);
                }
                start = -end;
                continue;
            }
            start = houseNumberMatcher.end();
        }
        return null;
    }

    static void __staticInitializer__() {
        sStateZipCodeRanges = new ZipRange[]{new ZipRange(99, 99, -1, -1), new ZipRange(35, 36, -1, -1), new ZipRange(71, 72, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(85, 86, -1, -1), new ZipRange(90, 96, -1, -1), new ZipRange(80, 81, -1, -1), new ZipRange(6, 6, -1, -1), new ZipRange(20, 20, -1, -1), new ZipRange(19, 19, -1, -1), new ZipRange(32, 34, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(30, 31, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(50, 52, -1, -1), new ZipRange(83, 83, -1, -1), new ZipRange(60, 62, -1, -1), new ZipRange(46, 47, -1, -1), new ZipRange(66, 67, 73, -1), new ZipRange(40, 42, -1, -1), new ZipRange(70, 71, -1, -1), new ZipRange(1, 2, -1, -1), new ZipRange(20, 21, -1, -1), new ZipRange(3, 4, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(48, 49, -1, -1), new ZipRange(55, 56, -1, -1), new ZipRange(63, 65, -1, -1), new ZipRange(96, 96, -1, -1), new ZipRange(38, 39, -1, -1), new ZipRange(55, 56, -1, -1), new ZipRange(27, 28, -1, -1), new ZipRange(58, 58, -1, -1), new ZipRange(68, 69, -1, -1), new ZipRange(3, 4, -1, -1), new ZipRange(7, 8, -1, -1), new ZipRange(87, 88, 86, -1), new ZipRange(88, 89, 96, -1), new ZipRange(10, 14, 0, 6), new ZipRange(43, 45, -1, -1), new ZipRange(73, 74, -1, -1), new ZipRange(97, 97, -1, -1), new ZipRange(15, 19, -1, -1), new ZipRange(6, 6, 0, 9), new ZipRange(96, 96, -1, -1), new ZipRange(2, 2, -1, -1), new ZipRange(29, 29, -1, -1), new ZipRange(57, 57, -1, -1), new ZipRange(37, 38, -1, -1), new ZipRange(75, 79, 87, 88), new ZipRange(84, 84, -1, -1), new ZipRange(22, 24, 20, -1), new ZipRange(6, 9, -1, -1), new ZipRange(5, 5, -1, -1), new ZipRange(98, 99, -1, -1), new ZipRange(53, 54, -1, -1), new ZipRange(24, 26, -1, -1), new ZipRange(82, 83, -1, -1)};
        sWordRe = Pattern.compile("[^,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]+(?=[,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)", 2);
        sHouseNumberRe = Pattern.compile("(?:one|\\d+([a-z](?=[^a-z]|$)|st|nd|rd|th)?)(?:-(?:one|\\d+([a-z](?=[^a-z]|$)|st|nd|rd|th)?))*(?=[,\"'\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)", 2);
        sStateRe = Pattern.compile("(?:(ak|alaska)|(al|alabama)|(ar|arkansas)|(as|american[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+samoa)|(az|arizona)|(ca|california)|(co|colorado)|(ct|connecticut)|(dc|district[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+of[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+columbia)|(de|delaware)|(fl|florida)|(fm|federated[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+states[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+of[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+micronesia)|(ga|georgia)|(gu|guam)|(hi|hawaii)|(ia|iowa)|(id|idaho)|(il|illinois)|(in|indiana)|(ks|kansas)|(ky|kentucky)|(la|louisiana)|(ma|massachusetts)|(md|maryland)|(me|maine)|(mh|marshall[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+islands)|(mi|michigan)|(mn|minnesota)|(mo|missouri)|(mp|northern[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+mariana[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+islands)|(ms|mississippi)|(mt|montana)|(nc|north[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+carolina)|(nd|north[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+dakota)|(ne|nebraska)|(nh|new[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+hampshire)|(nj|new[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+jersey)|(nm|new[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+mexico)|(nv|nevada)|(ny|new[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+york)|(oh|ohio)|(ok|oklahoma)|(or|oregon)|(pa|pennsylvania)|(pr|puerto[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+rico)|(pw|palau)|(ri|rhode[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+island)|(sc|south[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+carolina)|(sd|south[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+dakota)|(tn|tennessee)|(tx|texas)|(ut|utah)|(va|virginia)|(vi|virgin[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+islands)|(vt|vermont)|(wa|washington)|(wi|wisconsin)|(wv|west[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+virginia)|(wy|wyoming))(?=[,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)", 2);
        sLocationNameRe = Pattern.compile("(?:alley|annex|arcade|ave[.]?|avenue|alameda|bayou|beach|bend|bluffs?|bottom|boulevard|branch|bridge|brooks?|burgs?|bypass|broadway|camino|camp|canyon|cape|causeway|centers?|circles?|cliffs?|club|common|corners?|course|courts?|coves?|creek|crescent|crest|crossing|crossroad|curve|circulo|dale|dam|divide|drives?|estates?|expressway|extensions?|falls?|ferry|fields?|flats?|fords?|forest|forges?|forks?|fort|freeway|gardens?|gateway|glens?|greens?|groves?|harbors?|haven|heights|highway|hills?|hollow|inlet|islands?|isle|junctions?|keys?|knolls?|lakes?|land|landing|lane|lights?|loaf|locks?|lodge|loop|mall|manors?|meadows?|mews|mills?|mission|motorway|mount|mountains?|neck|orchard|oval|overpass|parks?|parkways?|pass|passage|path|pike|pines?|plains?|plaza|points?|ports?|prairie|privada|radial|ramp|ranch|rapids?|rd[.]?|rest|ridges?|river|roads?|route|row|rue|run|shoals?|shores?|skyway|springs?|spurs?|squares?|station|stravenue|stream|st[.]?|streets?|summit|speedway|terrace|throughway|trace|track|trafficway|trail|tunnel|turnpike|underpass|unions?|valleys?|viaduct|views?|villages?|ville|vista|walks?|wall|ways?|wells?|xing|xrd)(?=[,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)", 2);
        sSuffixedNumberRe = Pattern.compile("(\\d+)(st|nd|rd|th)", 2);
        sZipCodeRe = Pattern.compile("(?:\\d{5}(?:-\\d{4})?)(?=[,*\u2022\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\n\u000b\f\r\u0085\u2028\u2029]|$)", 2);
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_FindAddress$__constructor__();
    }

    public FindAddress() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_FindAddress$__constructor__(), this);
    }

    private static boolean checkHouseNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkHouseNumber", $$robo$$android_webkit_FindAddress$checkHouseNumber(java.lang.String ), (String)string2);
    }

    private static MatchResult matchHouseNumber(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("matchHouseNumber", $$robo$$android_webkit_FindAddress$matchHouseNumber(java.lang.String int ), (String)string2, (int)n);
    }

    private static MatchResult matchState(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("matchState", $$robo$$android_webkit_FindAddress$matchState(java.lang.String int ), (String)string2, (int)n);
    }

    private static boolean isValidZipCode(String string2, MatchResult matchResult) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidZipCode", $$robo$$android_webkit_FindAddress$isValidZipCode(java.lang.String java.util.regex.MatchResult ), (String)string2, (MatchResult)matchResult);
    }

    private static boolean isValidLocationName(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidLocationName", $$robo$$android_webkit_FindAddress$isValidLocationName(java.lang.String ), (String)string2);
    }

    private static int attemptMatch(String string2, MatchResult matchResult) {
        return (int)InvokeDynamicSupport.bootstrapStatic("attemptMatch", $$robo$$android_webkit_FindAddress$attemptMatch(java.lang.String java.util.regex.MatchResult ), (String)string2, (MatchResult)matchResult);
    }

    static String findAddress(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findAddress", $$robo$$android_webkit_FindAddress$findAddress(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(FindAddress.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FindAddress)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ZipRange
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mLow;
        int mHigh;
        int mException1;
        int mException2;

        private void $$robo$$android_webkit_FindAddress_ZipRange$__constructor__(int low, int high, int exception1, int exception2) {
            this.mLow = low;
            this.mHigh = high;
            this.mException1 = exception1;
            this.mException2 = exception1;
        }

        private final boolean $$robo$$android_webkit_FindAddress_ZipRange$matches(String zipCode) {
            int prefix = Integer.parseInt(zipCode.substring(0, 2));
            return this.mLow <= prefix && prefix <= this.mHigh || prefix == this.mException1 || prefix == this.mException2;
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_webkit_FindAddress_ZipRange$__constructor__(n, n2, n3, n4);
        }

        public ZipRange(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_FindAddress_ZipRange$__constructor__(int int int int ), this, n, n2, n3, n4);
        }

        boolean matches(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_webkit_FindAddress_ZipRange$matches(java.lang.String ), this, string2);
        }

        public /* synthetic */ ZipRange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZipRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

