/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ActionMenuPresenter;
import android.widget.LinearLayout;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionMenuView
extends LinearLayout
implements MenuBuilder.ItemInvoker,
MenuView,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ActionMenuView";
    static int MIN_CELL_SIZE = 56;
    static int GENERATED_ITEM_PADDING = 4;
    private MenuBuilder mMenu;
    private Context mPopupContext;
    private int mPopupTheme;
    private boolean mReserveOverflow;
    private ActionMenuPresenter mPresenter;
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private MenuBuilder.Callback mMenuBuilderCallback;
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mMinCellSize;
    private int mGeneratedItemPadding;
    private OnMenuItemClickListener mOnMenuItemClickListener;

    private void $$robo$$android_widget_ActionMenuView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ActionMenuView$__constructor__(Context context, AttributeSet attrs) {
        this.setBaselineAligned(false);
        float density = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * density);
        this.mGeneratedItemPadding = (int)(4.0f * density);
        this.mPopupContext = context;
        this.mPopupTheme = 0;
    }

    private final void $$robo$$android_widget_ActionMenuView$setPopupTheme(int resId) {
        if (this.mPopupTheme != resId) {
            this.mPopupTheme = resId;
            this.mPopupContext = resId == 0 ? this.mContext : new ContextThemeWrapper(this.mContext, resId);
        }
    }

    private final int $$robo$$android_widget_ActionMenuView$getPopupTheme() {
        return this.mPopupTheme;
    }

    private final void $$robo$$android_widget_ActionMenuView$setPresenter(ActionMenuPresenter presenter) {
        this.mPresenter = presenter;
        this.mPresenter.setMenuView(this);
    }

    private final void $$robo$$android_widget_ActionMenuView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mPresenter != null) {
            this.mPresenter.updateMenuView(false);
            if (this.mPresenter.isOverflowMenuShowing()) {
                this.mPresenter.hideOverflowMenu();
                this.mPresenter.showOverflowMenu();
            }
        }
    }

    private final void $$robo$$android_widget_ActionMenuView$setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    private final void $$robo$$android_widget_ActionMenuView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean wasFormatted = this.mFormatItems;
        boolean bl = this.mFormatItems = View.MeasureSpec.getMode(widthMeasureSpec) == 0x40000000;
        if (wasFormatted != this.mFormatItems) {
            this.mFormatItemsWidth = 0;
        }
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        if (this.mFormatItems && this.mMenu != null && widthSize != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = widthSize;
            this.mMenu.onItemsChanged(true);
        }
        int childCount = this.getChildCount();
        if (this.mFormatItems && childCount > 0) {
            this.onMeasureExactFormat(widthMeasureSpec, heightMeasureSpec);
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                lp.rightMargin = 0;
                lp.leftMargin = 0;
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void $$robo$$android_widget_ActionMenuView$onMeasureExactFormat(int widthMeasureSpec, int heightMeasureSpec) {
        boolean singleItem;
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int itemHeightSpec = ActionMenuView.getChildMeasureSpec(heightMeasureSpec, heightPadding, -2);
        int cellCount = (widthSize -= widthPadding) / this.mMinCellSize;
        int cellSizeRemaining = widthSize % this.mMinCellSize;
        if (cellCount == 0) {
            this.setMeasuredDimension(widthSize, 0);
            return;
        }
        int cellSize = this.mMinCellSize + cellSizeRemaining / cellCount;
        int cellsRemaining = cellCount;
        int maxChildHeight = 0;
        int maxCellsUsed = 0;
        int expandableItemCount = 0;
        int visibleItemCount = 0;
        boolean hasOverflow = false;
        long smallestItemsAt = 0L;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            boolean isGeneratedItem = child instanceof ActionMenuItemView;
            ++visibleItemCount;
            if (isGeneratedItem) {
                child.setPadding(this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.expanded = false;
            lp.extraPixels = 0;
            lp.cellsUsed = 0;
            lp.expandable = false;
            lp.leftMargin = 0;
            lp.rightMargin = 0;
            lp.preventEdgeOffset = isGeneratedItem && ((ActionMenuItemView)child).hasText();
            int cellsAvailable = lp.isOverflowButton ? 1 : cellsRemaining;
            int cellsUsed = ActionMenuView.measureChildForCells(child, cellSize, cellsAvailable, itemHeightSpec, heightPadding);
            maxCellsUsed = Math.max(maxCellsUsed, cellsUsed);
            if (lp.expandable) {
                ++expandableItemCount;
            }
            if (lp.isOverflowButton) {
                hasOverflow = true;
            }
            cellsRemaining -= cellsUsed;
            maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight());
            if (cellsUsed != 1) continue;
            smallestItemsAt |= (long)(1 << i);
        }
        boolean centerSingleExpandedItem = hasOverflow && visibleItemCount == 2;
        boolean needsExpansion = false;
        while (expandableItemCount > 0 && cellsRemaining > 0) {
            LayoutParams lp;
            View child;
            int i;
            int minCells = Integer.MAX_VALUE;
            long minCellsAt = 0L;
            int minCellsItemCount = 0;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expandable) continue;
                if (lp.cellsUsed < minCells) {
                    minCells = lp.cellsUsed;
                    minCellsAt = 1 << i;
                    minCellsItemCount = 1;
                    continue;
                }
                if (lp.cellsUsed != minCells) continue;
                minCellsAt |= (long)(1 << i);
                ++minCellsItemCount;
            }
            smallestItemsAt |= minCellsAt;
            if (minCellsItemCount > cellsRemaining) break;
            ++minCells;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if ((minCellsAt & (long)(1 << i)) == 0L) {
                    if (lp.cellsUsed != minCells) continue;
                    smallestItemsAt |= (long)(1 << i);
                    continue;
                }
                if (centerSingleExpandedItem && lp.preventEdgeOffset && cellsRemaining == 1) {
                    child.setPadding(this.mGeneratedItemPadding + cellSize, 0, this.mGeneratedItemPadding, 0);
                }
                ++lp.cellsUsed;
                lp.expanded = true;
                --cellsRemaining;
            }
            needsExpansion = true;
        }
        boolean bl = singleItem = !hasOverflow && visibleItemCount == 1;
        if (cellsRemaining > 0 && smallestItemsAt != 0L && (cellsRemaining < visibleItemCount - 1 || singleItem || maxCellsUsed > 1)) {
            float expandCount = Long.bitCount(smallestItemsAt);
            if (!singleItem) {
                if ((smallestItemsAt & 1L) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(0).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
                if ((smallestItemsAt & (long)(1 << childCount - 1)) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(childCount - 1).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
            }
            int extraPixels = expandCount > 0.0f ? (int)((float)(cellsRemaining * cellSize) / expandCount) : 0;
            for (int i = 0; i < childCount; ++i) {
                if ((smallestItemsAt & (long)(1 << i)) == 0L) continue;
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (child instanceof ActionMenuItemView) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    if (i == 0 && !lp.preventEdgeOffset) {
                        lp.leftMargin = -extraPixels / 2;
                    }
                    needsExpansion = true;
                    continue;
                }
                if (lp.isOverflowButton) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    lp.rightMargin = -extraPixels / 2;
                    needsExpansion = true;
                    continue;
                }
                if (i != 0) {
                    lp.leftMargin = extraPixels / 2;
                }
                if (i == childCount - 1) continue;
                lp.rightMargin = extraPixels / 2;
            }
            cellsRemaining = 0;
        }
        if (needsExpansion) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expanded) continue;
                int width = lp.cellsUsed * cellSize + lp.extraPixels;
                child.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), itemHeightSpec);
            }
        }
        if (heightMode != 0x40000000) {
            heightSize = maxChildHeight;
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private static final int $$robo$$android_widget_ActionMenuView$measureChildForCells(View child, int cellSize, int cellsRemaining, int parentHeightMeasureSpec, int parentHeightPadding) {
        boolean expandable;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childHeightSize = View.MeasureSpec.getSize(parentHeightMeasureSpec) - parentHeightPadding;
        int childHeightMode = View.MeasureSpec.getMode(parentHeightMeasureSpec);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec(childHeightSize, childHeightMode);
        ActionMenuItemView itemView = child instanceof ActionMenuItemView ? (ActionMenuItemView)child : null;
        boolean hasText = itemView != null && itemView.hasText();
        int cellsUsed = 0;
        if (!(cellsRemaining <= 0 || hasText && cellsRemaining < 2)) {
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec(cellSize * cellsRemaining, Integer.MIN_VALUE);
            child.measure(childWidthSpec, childHeightSpec);
            int measuredWidth = child.getMeasuredWidth();
            cellsUsed = measuredWidth / cellSize;
            if (measuredWidth % cellSize != 0) {
                ++cellsUsed;
            }
            if (hasText && cellsUsed < 2) {
                cellsUsed = 2;
            }
        }
        lp.expandable = expandable = !lp.isOverflowButton && hasText;
        lp.cellsUsed = cellsUsed;
        int targetWidth = cellsUsed * cellSize;
        child.measure(View.MeasureSpec.makeMeasureSpec(targetWidth, 0x40000000), childHeightSpec);
        return cellsUsed;
    }

    private final void $$robo$$android_widget_ActionMenuView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int height;
        int width;
        int i;
        if (!this.mFormatItems) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        int childCount = this.getChildCount();
        int midVertical = (bottom - top) / 2;
        int dividerWidth = this.getDividerWidth();
        int overflowWidth = 0;
        int nonOverflowWidth = 0;
        int nonOverflowCount = 0;
        int widthRemaining = right - left - this.getPaddingRight() - this.getPaddingLeft();
        boolean hasOverflow = false;
        boolean isLayoutRtl = this.isLayoutRtl();
        for (int i2 = 0; i2 < childCount; ++i2) {
            View v = this.getChildAt(i2);
            if (v.getVisibility() == 8) continue;
            LayoutParams p = (LayoutParams)v.getLayoutParams();
            if (p.isOverflowButton) {
                int r;
                int l;
                overflowWidth = v.getMeasuredWidth();
                if (this.hasDividerBeforeChildAt(i2)) {
                    overflowWidth += dividerWidth;
                }
                int height2 = v.getMeasuredHeight();
                if (isLayoutRtl) {
                    l = this.getPaddingLeft() + p.leftMargin;
                    r = l + overflowWidth;
                } else {
                    r = this.getWidth() - this.getPaddingRight() - p.rightMargin;
                    l = r - overflowWidth;
                }
                int t = midVertical - height2 / 2;
                int b = t + height2;
                v.layout(l, t, r, b);
                widthRemaining -= overflowWidth;
                hasOverflow = true;
                continue;
            }
            int size = v.getMeasuredWidth() + p.leftMargin + p.rightMargin;
            nonOverflowWidth += size;
            widthRemaining -= size;
            if (this.hasDividerBeforeChildAt(i2)) {
                nonOverflowWidth += dividerWidth;
            }
            ++nonOverflowCount;
        }
        if (childCount == 1 && !hasOverflow) {
            View v = this.getChildAt(0);
            int width2 = v.getMeasuredWidth();
            int height3 = v.getMeasuredHeight();
            int midHorizontal = (right - left) / 2;
            int l = midHorizontal - width2 / 2;
            int t = midVertical - height3 / 2;
            v.layout(l, t, l + width2, t + height3);
            return;
        }
        int spacerCount = nonOverflowCount - (hasOverflow ? 0 : 1);
        int spacerSize = Math.max(0, spacerCount > 0 ? widthRemaining / spacerCount : 0);
        if (isLayoutRtl) {
            int startRight = this.getWidth() - this.getPaddingRight();
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)v.getLayoutParams();
                if (v.getVisibility() == 8 || lp.isOverflowButton) continue;
                width = v.getMeasuredWidth();
                height = v.getMeasuredHeight();
                int t = midVertical - height / 2;
                v.layout((startRight -= lp.rightMargin) - width, t, startRight, t + height);
                startRight -= width + lp.leftMargin + spacerSize;
            }
        } else {
            int startLeft = this.getPaddingLeft();
            for (i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)v.getLayoutParams();
                if (v.getVisibility() == 8 || lp.isOverflowButton) continue;
                width = v.getMeasuredWidth();
                height = v.getMeasuredHeight();
                int t = midVertical - height / 2;
                v.layout(startLeft += lp.leftMargin, t, startLeft + width, t + height);
                startLeft += width + lp.rightMargin + spacerSize;
            }
        }
    }

    private final void $$robo$$android_widget_ActionMenuView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopupMenus();
    }

    private final void $$robo$$android_widget_ActionMenuView$setOverflowIcon(Drawable icon) {
        this.getMenu();
        this.mPresenter.setOverflowIcon(icon);
    }

    private final Drawable $$robo$$android_widget_ActionMenuView$getOverflowIcon() {
        this.getMenu();
        return this.mPresenter.getOverflowIcon();
    }

    private final boolean $$robo$$android_widget_ActionMenuView$isOverflowReserved() {
        return this.mReserveOverflow;
    }

    private final void $$robo$$android_widget_ActionMenuView$setOverflowReserved(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
    }

    private final LayoutParams $$robo$$android_widget_ActionMenuView$generateDefaultLayoutParams() {
        LayoutParams params = new LayoutParams(-2, -2);
        params.gravity = 16;
        return params;
    }

    private final LayoutParams $$robo$$android_widget_ActionMenuView$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LayoutParams $$robo$$android_widget_ActionMenuView$generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p != null) {
            LayoutParams result;
            LayoutParams layoutParams = result = p instanceof LayoutParams ? new LayoutParams((LayoutParams)p) : new LayoutParams(p);
            if (result.gravity <= 0) {
                result.gravity = 16;
            }
            return result;
        }
        return this.generateDefaultLayoutParams();
    }

    private final boolean $$robo$$android_widget_ActionMenuView$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null && p instanceof LayoutParams;
    }

    private final LayoutParams $$robo$$android_widget_ActionMenuView$generateOverflowButtonLayoutParams() {
        LinearLayout.LayoutParams result = this.generateDefaultLayoutParams();
        ((LayoutParams)result).isOverflowButton = true;
        return result;
    }

    private final boolean $$robo$$android_widget_ActionMenuView$invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction(item, 0);
    }

    private final int $$robo$$android_widget_ActionMenuView$getWindowAnimations() {
        return 0;
    }

    private final void $$robo$$android_widget_ActionMenuView$initialize(MenuBuilder menu2) {
        this.mMenu = menu2;
    }

    private final Menu $$robo$$android_widget_ActionMenuView$getMenu() {
        if (this.mMenu == null) {
            Context context = this.getContext();
            this.mMenu = new MenuBuilder(context);
            this.mMenu.setCallback(new MenuBuilderCallback(this, null));
            this.mPresenter = new ActionMenuPresenter(context);
            this.mPresenter.setReserveOverflow(true);
            this.mPresenter.setCallback(this.mActionMenuPresenterCallback != null ? this.mActionMenuPresenterCallback : new ActionMenuPresenterCallback(this, null));
            this.mMenu.addMenuPresenter(this.mPresenter, this.mPopupContext);
            this.mPresenter.setMenuView(this);
        }
        return this.mMenu;
    }

    private final void $$robo$$android_widget_ActionMenuView$setMenuCallbacks(MenuPresenter.Callback pcb, MenuBuilder.Callback mcb) {
        this.mActionMenuPresenterCallback = pcb;
        this.mMenuBuilderCallback = mcb;
    }

    private final MenuBuilder $$robo$$android_widget_ActionMenuView$peekMenu() {
        return this.mMenu;
    }

    private final boolean $$robo$$android_widget_ActionMenuView$showOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.showOverflowMenu();
    }

    private final boolean $$robo$$android_widget_ActionMenuView$hideOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.hideOverflowMenu();
    }

    private final boolean $$robo$$android_widget_ActionMenuView$isOverflowMenuShowing() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowing();
    }

    private final boolean $$robo$$android_widget_ActionMenuView$isOverflowMenuShowPending() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowPending();
    }

    private final void $$robo$$android_widget_ActionMenuView$dismissPopupMenus() {
        if (this.mPresenter != null) {
            this.mPresenter.dismissPopupMenus();
        }
    }

    private final boolean $$robo$$android_widget_ActionMenuView$hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return false;
        }
        View childBefore = this.getChildAt(childIndex - 1);
        View child = this.getChildAt(childIndex);
        boolean result = false;
        if (childIndex < this.getChildCount() && childBefore instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)((Object)childBefore)).needsDividerAfter();
        }
        if (childIndex > 0 && child instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)((Object)child)).needsDividerBefore();
        }
        return result;
    }

    private final boolean $$robo$$android_widget_ActionMenuView$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        return false;
    }

    private final void $$robo$$android_widget_ActionMenuView$setExpandedActionViewsExclusive(boolean exclusive) {
        this.mPresenter.setExpandedActionViewsExclusive(exclusive);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ActionMenuView$__constructor__(context);
    }

    public ActionMenuView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ActionMenuView$__constructor__(context, attributeSet);
    }

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    public void setPopupTheme(int n) {
        InvokeDynamicSupport.bootstrap("setPopupTheme", $$robo$$android_widget_ActionMenuView$setPopupTheme(int ), this, n);
    }

    public int getPopupTheme() {
        return (int)InvokeDynamicSupport.bootstrap("getPopupTheme", $$robo$$android_widget_ActionMenuView$getPopupTheme(), this);
    }

    public void setPresenter(ActionMenuPresenter actionMenuPresenter) {
        InvokeDynamicSupport.bootstrap("setPresenter", $$robo$$android_widget_ActionMenuView$setPresenter(android.widget.ActionMenuPresenter ), this, actionMenuPresenter);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_ActionMenuView$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnMenuItemClickListener", $$robo$$android_widget_ActionMenuView$setOnMenuItemClickListener(android.widget.ActionMenuView$OnMenuItemClickListener ), this, onMenuItemClickListener);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_ActionMenuView$onMeasure(int int ), this, n, n2);
    }

    private void onMeasureExactFormat(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasureExactFormat", $$robo$$android_widget_ActionMenuView$onMeasureExactFormat(int int ), this, n, n2);
    }

    static int measureChildForCells(View view, int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("measureChildForCells", $$robo$$android_widget_ActionMenuView$measureChildForCells(android.view.View int int int int ), (View)view, (int)n, (int)n2, (int)n3, (int)n4);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_ActionMenuView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_ActionMenuView$onDetachedFromWindow(), this);
    }

    public void setOverflowIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setOverflowIcon", $$robo$$android_widget_ActionMenuView$setOverflowIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getOverflowIcon() {
        return InvokeDynamicSupport.bootstrap("getOverflowIcon", $$robo$$android_widget_ActionMenuView$getOverflowIcon(), this);
    }

    public boolean isOverflowReserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowReserved", $$robo$$android_widget_ActionMenuView$isOverflowReserved(), this);
    }

    public void setOverflowReserved(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverflowReserved", $$robo$$android_widget_ActionMenuView$setOverflowReserved(boolean ), this, bl);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_ActionMenuView$generateDefaultLayoutParams(), this);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_ActionMenuView$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_ActionMenuView$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_ActionMenuView$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    public LayoutParams generateOverflowButtonLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateOverflowButtonLayoutParams", $$robo$$android_widget_ActionMenuView$generateOverflowButtonLayoutParams(), this);
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeItem", $$robo$$android_widget_ActionMenuView$invokeItem(com.android.internal.view.menu.MenuItemImpl ), this, menuItemImpl);
    }

    @Override
    public int getWindowAnimations() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowAnimations", $$robo$$android_widget_ActionMenuView$getWindowAnimations(), this);
    }

    @Override
    public void initialize(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_ActionMenuView$initialize(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
    }

    public Menu getMenu() {
        return InvokeDynamicSupport.bootstrap("getMenu", $$robo$$android_widget_ActionMenuView$getMenu(), this);
    }

    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        InvokeDynamicSupport.bootstrap("setMenuCallbacks", $$robo$$android_widget_ActionMenuView$setMenuCallbacks(com.android.internal.view.menu.MenuPresenter$Callback com.android.internal.view.menu.MenuBuilder$Callback ), this, callback, callback2);
    }

    public MenuBuilder peekMenu() {
        return InvokeDynamicSupport.bootstrap("peekMenu", $$robo$$android_widget_ActionMenuView$peekMenu(), this);
    }

    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$android_widget_ActionMenuView$showOverflowMenu(), this);
    }

    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$android_widget_ActionMenuView$hideOverflowMenu(), this);
    }

    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$android_widget_ActionMenuView$isOverflowMenuShowing(), this);
    }

    public boolean isOverflowMenuShowPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowPending", $$robo$$android_widget_ActionMenuView$isOverflowMenuShowPending(), this);
    }

    public void dismissPopupMenus() {
        InvokeDynamicSupport.bootstrap("dismissPopupMenus", $$robo$$android_widget_ActionMenuView$dismissPopupMenus(), this);
    }

    @Override
    protected boolean hasDividerBeforeChildAt(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDividerBeforeChildAt", $$robo$$android_widget_ActionMenuView$hasDividerBeforeChildAt(int ), this, n);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$android_widget_ActionMenuView$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExpandedActionViewsExclusive", $$robo$$android_widget_ActionMenuView$setExpandedActionViewsExclusive(boolean ), this, bl);
    }

    public /* synthetic */ ActionMenuView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty(category="layout")
        public int cellsUsed;
        @ViewDebug.ExportedProperty(category="layout")
        public int extraPixels;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean expandable;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean preventEdgeOffset;
        public boolean expanded;

        private void $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
        }

        private void $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(ViewGroup.LayoutParams other) {
        }

        private void $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(LayoutParams other) {
            this.isOverflowButton = other.isOverflowButton;
        }

        private void $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(int width, int height) {
            this.isOverflowButton = false;
        }

        private void $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(int width, int height, boolean isOverflowButton) {
            this.isOverflowButton = isOverflowButton;
        }

        private final void $$robo$$android_widget_ActionMenuView_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("layout:overFlowButton", this.isOverflowButton);
            encoder.addProperty("layout:cellsUsed", this.cellsUsed);
            encoder.addProperty("layout:extraPixels", this.extraPixels);
            encoder.addProperty("layout:expandable", this.expandable);
            encoder.addProperty("layout:preventEdgeOffset", this.preventEdgeOffset);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(android.widget.ActionMenuView$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(int n, int n2, boolean bl) {
            this.$$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(n, n2, bl);
        }

        public LayoutParams(int n, int n2, boolean bl) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_LayoutParams$__constructor__(int int boolean ), this, n, n2, bl);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_ActionMenuView_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ActionMenuChildView {
        public boolean needsDividerBefore();

        public boolean needsDividerAfter();
    }

    private class ActionMenuPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuView this$0;

        private void $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(ActionMenuView actionMenuView) {
            this.this$0 = actionMenuView;
        }

        private final void $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        }

        private final boolean $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            return false;
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(ActionMenuView x0, 1 x1) {
        }

        private void __constructor__(ActionMenuView actionMenuView) {
            this.$$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(actionMenuView);
        }

        public ActionMenuPresenterCallback(ActionMenuView actionMenuView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(android.widget.ActionMenuView ), this, actionMenuView);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), this, menuBuilder, bl);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
        }

        private /* synthetic */ void __constructor__(ActionMenuView actionMenuView, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(actionMenuView, var2_2);
        }

        public /* synthetic */ ActionMenuPresenterCallback(ActionMenuView actionMenuView, 1 var2_2) {
            this(actionMenuView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_ActionMenuPresenterCallback$__constructor__(android.widget.ActionMenuView android.widget.ActionMenuView$1 ), this, actionMenuView, var2_2);
        }

        public /* synthetic */ ActionMenuPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MenuBuilderCallback
    implements MenuBuilder.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuView this$0;

        private void $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(ActionMenuView actionMenuView) {
            this.this$0 = actionMenuView;
        }

        private final boolean $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            return this.this$0.mOnMenuItemClickListener != null && this.this$0.mOnMenuItemClickListener.onMenuItemClick(item);
        }

        private final void $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$onMenuModeChange(MenuBuilder menu2) {
            if (this.this$0.mMenuBuilderCallback != null) {
                this.this$0.mMenuBuilderCallback.onMenuModeChange(menu2);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(ActionMenuView x0, 1 x1) {
        }

        private void __constructor__(ActionMenuView actionMenuView) {
            this.$$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(actionMenuView);
        }

        public MenuBuilderCallback(ActionMenuView actionMenuView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(android.widget.ActionMenuView ), this, actionMenuView);
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$onMenuItemSelected(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), this, menuBuilder, menuItem);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            InvokeDynamicSupport.bootstrap("onMenuModeChange", $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$onMenuModeChange(com.android.internal.view.menu.MenuBuilder ), this, menuBuilder);
        }

        private /* synthetic */ void __constructor__(ActionMenuView actionMenuView, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(actionMenuView, var2_2);
        }

        public /* synthetic */ MenuBuilderCallback(ActionMenuView actionMenuView, 1 var2_2) {
            this(actionMenuView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuView_MenuBuilderCallback$__constructor__(android.widget.ActionMenuView android.widget.ActionMenuView$1 ), this, actionMenuView, var2_2);
        }

        public /* synthetic */ MenuBuilderCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuBuilderCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

