/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.Button;
import android.widget.Checkable;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CompoundButton
extends Button
implements Checkable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private boolean mChecked;
    private boolean mBroadcasting;
    private Drawable mButtonDrawable;
    private ColorStateList mButtonTintList;
    private PorterDuff.Mode mButtonTintMode;
    private boolean mHasButtonTint;
    private boolean mHasButtonTintMode;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;
    private boolean mCheckedFromResource;
    private static int[] CHECKED_STATE_SET;

    private void $$robo$$android_widget_CompoundButton$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_CompoundButton$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_CompoundButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_CompoundButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mButtonTintList = null;
        this.mButtonTintMode = null;
        this.mHasButtonTint = false;
        this.mHasButtonTintMode = false;
        this.mCheckedFromResource = false;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CompoundButton, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(1);
        if (d != null) {
            this.setButtonDrawable(d);
        }
        if (a.hasValue(3)) {
            this.mButtonTintMode = Drawable.parseTintMode(a.getInt(3, -1), this.mButtonTintMode);
            this.mHasButtonTintMode = true;
        }
        if (a.hasValue(2)) {
            this.mButtonTintList = a.getColorStateList(2);
            this.mHasButtonTint = true;
        }
        boolean checked = a.getBoolean(0, false);
        this.setChecked(checked);
        this.mCheckedFromResource = true;
        a.recycle();
        this.applyButtonTint();
    }

    private final void $$robo$$android_widget_CompoundButton$toggle() {
        this.setChecked(!this.mChecked);
    }

    private final boolean $$robo$$android_widget_CompoundButton$performClick() {
        this.toggle();
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_CompoundButton$isChecked() {
        return this.mChecked;
    }

    private final void $$robo$$android_widget_CompoundButton$setChecked(boolean checked) {
        if (this.mChecked != checked) {
            AutofillManager afm;
            this.mCheckedFromResource = false;
            this.mChecked = checked;
            this.refreshDrawableState();
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
            if (this.mBroadcasting) {
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
            if (this.mOnCheckedChangeWidgetListener != null) {
                this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, this.mChecked);
            }
            if ((afm = this.mContext.getSystemService(AutofillManager.class)) != null) {
                afm.notifyValueChanged(this);
            }
            this.mBroadcasting = false;
        }
    }

    private final void $$robo$$android_widget_CompoundButton$setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    private final void $$robo$$android_widget_CompoundButton$setOnCheckedChangeWidgetListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeWidgetListener = listener;
    }

    private final void $$robo$$android_widget_CompoundButton$setButtonDrawable(int resId) {
        Drawable d = resId != 0 ? this.getContext().getDrawable(resId) : null;
        this.setButtonDrawable(d);
    }

    private final void $$robo$$android_widget_CompoundButton$setButtonDrawable(Drawable drawable2) {
        if (this.mButtonDrawable != drawable2) {
            if (this.mButtonDrawable != null) {
                this.mButtonDrawable.setCallback(null);
                this.unscheduleDrawable(this.mButtonDrawable);
            }
            this.mButtonDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                drawable2.setVisible(this.getVisibility() == 0, false);
                this.setMinHeight(drawable2.getIntrinsicHeight());
                this.applyButtonTint();
            }
        }
    }

    private final void $$robo$$android_widget_CompoundButton$onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.setLayoutDirection(layoutDirection);
        }
    }

    private final Drawable $$robo$$android_widget_CompoundButton$getButtonDrawable() {
        return this.mButtonDrawable;
    }

    private final void $$robo$$android_widget_CompoundButton$setButtonTintList(ColorStateList tint) {
        this.mButtonTintList = tint;
        this.mHasButtonTint = true;
        this.applyButtonTint();
    }

    private final ColorStateList $$robo$$android_widget_CompoundButton$getButtonTintList() {
        return this.mButtonTintList;
    }

    private final void $$robo$$android_widget_CompoundButton$setButtonTintMode(PorterDuff.Mode tintMode) {
        this.mButtonTintMode = tintMode;
        this.mHasButtonTintMode = true;
        this.applyButtonTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_CompoundButton$getButtonTintMode() {
        return this.mButtonTintMode;
    }

    private final void $$robo$$android_widget_CompoundButton$applyButtonTint() {
        if (this.mButtonDrawable != null && (this.mHasButtonTint || this.mHasButtonTintMode)) {
            this.mButtonDrawable = this.mButtonDrawable.mutate();
            if (this.mHasButtonTint) {
                this.mButtonDrawable.setTintList(this.mButtonTintList);
            }
            if (this.mHasButtonTintMode) {
                this.mButtonDrawable.setTintMode(this.mButtonTintMode);
            }
            if (this.mButtonDrawable.isStateful()) {
                this.mButtonDrawable.setState(this.getDrawableState());
            }
        }
    }

    private final CharSequence $$robo$$android_widget_CompoundButton$getAccessibilityClassName() {
        return CompoundButton.class.getName();
    }

    private final void $$robo$$android_widget_CompoundButton$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setChecked(this.mChecked);
    }

    private final void $$robo$$android_widget_CompoundButton$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setCheckable(true);
        info.setChecked(this.mChecked);
    }

    private final int $$robo$$android_widget_CompoundButton$getCompoundPaddingLeft() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingLeft();
        if (!this.isLayoutRtl() && (buttonDrawable = this.mButtonDrawable) != null) {
            padding += buttonDrawable.getIntrinsicWidth();
        }
        return padding;
    }

    private final int $$robo$$android_widget_CompoundButton$getCompoundPaddingRight() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingRight();
        if (this.isLayoutRtl() && (buttonDrawable = this.mButtonDrawable) != null) {
            padding += buttonDrawable.getIntrinsicWidth();
        }
        return padding;
    }

    private final int $$robo$$android_widget_CompoundButton$getHorizontalOffsetForDrawables() {
        Drawable buttonDrawable = this.mButtonDrawable;
        return buttonDrawable != null ? buttonDrawable.getIntrinsicWidth() : 0;
    }

    private final void $$robo$$android_widget_CompoundButton$onDraw(Canvas canvas) {
        Drawable buttonDrawable = this.mButtonDrawable;
        if (buttonDrawable != null) {
            int top;
            int verticalGravity = this.getGravity() & 0x70;
            int drawableHeight = buttonDrawable.getIntrinsicHeight();
            int drawableWidth = buttonDrawable.getIntrinsicWidth();
            switch (verticalGravity) {
                case 80: {
                    top = this.getHeight() - drawableHeight;
                    break;
                }
                case 16: {
                    top = (this.getHeight() - drawableHeight) / 2;
                    break;
                }
                default: {
                    top = 0;
                }
            }
            int bottom = top + drawableHeight;
            int left = this.isLayoutRtl() ? this.getWidth() - drawableWidth : 0;
            int right = this.isLayoutRtl() ? this.getWidth() : drawableWidth;
            buttonDrawable.setBounds(left, top, right, bottom);
            Drawable background = this.getBackground();
            if (background != null) {
                background.setHotspotBounds(left, top, right, bottom);
            }
        }
        super.onDraw(canvas);
        if (buttonDrawable != null) {
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            if (scrollX == 0 && scrollY == 0) {
                buttonDrawable.draw(canvas);
            } else {
                canvas.translate(scrollX, scrollY);
                buttonDrawable.draw(canvas);
                canvas.translate(-scrollX, -scrollY);
            }
        }
    }

    private final int[] $$robo$$android_widget_CompoundButton$onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CompoundButton.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    private final void $$robo$$android_widget_CompoundButton$drawableStateChanged() {
        super.drawableStateChanged();
        Drawable buttonDrawable = this.mButtonDrawable;
        if (buttonDrawable != null && buttonDrawable.isStateful() && buttonDrawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(buttonDrawable);
        }
    }

    private final void $$robo$$android_widget_CompoundButton$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.setHotspot(x, y);
        }
    }

    private final boolean $$robo$$android_widget_CompoundButton$verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mButtonDrawable;
    }

    private final void $$robo$$android_widget_CompoundButton$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mButtonDrawable != null) {
            this.mButtonDrawable.jumpToCurrentState();
        }
    }

    private final Parcelable $$robo$$android_widget_CompoundButton$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    private final void $$robo$$android_widget_CompoundButton$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    private final void $$robo$$android_widget_CompoundButton$encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        stream.addProperty("checked", this.isChecked());
    }

    private final void $$robo$$android_widget_CompoundButton$onProvideAutofillStructure(ViewStructure structure, int flags) {
        super.onProvideAutofillStructure(structure, flags);
        structure.setDataIsSensitive(!this.mCheckedFromResource);
    }

    private final void $$robo$$android_widget_CompoundButton$autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value.isToggle()) {
            Log.w(LOG_TAG, value + " could not be autofilled into " + this);
            return;
        }
        this.setChecked(value.getToggleValue());
    }

    private final int $$robo$$android_widget_CompoundButton$getAutofillType() {
        return this.isEnabled() ? 2 : 0;
    }

    private final AutofillValue $$robo$$android_widget_CompoundButton$getAutofillValue() {
        return this.isEnabled() ? AutofillValue.forToggle(this.isChecked()) : null;
    }

    static void __staticInitializer__() {
        LOG_TAG = CompoundButton.class.getSimpleName();
        CHECKED_STATE_SET = new int[]{0x10100A0};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_CompoundButton$__constructor__(context);
    }

    public CompoundButton(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_CompoundButton$__constructor__(context, attributeSet);
    }

    public CompoundButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_CompoundButton$__constructor__(context, attributeSet, n);
    }

    public CompoundButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_CompoundButton$__constructor__(context, attributeSet, n, n2);
    }

    public CompoundButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public void toggle() {
        InvokeDynamicSupport.bootstrap("toggle", $$robo$$android_widget_CompoundButton$toggle(), this);
    }

    @Override
    public boolean performClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_widget_CompoundButton$performClick(), this);
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_widget_CompoundButton$isChecked(), this);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_widget_CompoundButton$setChecked(boolean ), this, bl);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnCheckedChangeListener", $$robo$$android_widget_CompoundButton$setOnCheckedChangeListener(android.widget.CompoundButton$OnCheckedChangeListener ), this, onCheckedChangeListener);
    }

    void setOnCheckedChangeWidgetListener(OnCheckedChangeListener onCheckedChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnCheckedChangeWidgetListener", $$robo$$android_widget_CompoundButton$setOnCheckedChangeWidgetListener(android.widget.CompoundButton$OnCheckedChangeListener ), this, onCheckedChangeListener);
    }

    public void setButtonDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setButtonDrawable", $$robo$$android_widget_CompoundButton$setButtonDrawable(int ), this, n);
    }

    public void setButtonDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setButtonDrawable", $$robo$$android_widget_CompoundButton$setButtonDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$android_widget_CompoundButton$onResolveDrawables(int ), this, n);
    }

    public Drawable getButtonDrawable() {
        return InvokeDynamicSupport.bootstrap("getButtonDrawable", $$robo$$android_widget_CompoundButton$getButtonDrawable(), this);
    }

    public void setButtonTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setButtonTintList", $$robo$$android_widget_CompoundButton$setButtonTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    public ColorStateList getButtonTintList() {
        return InvokeDynamicSupport.bootstrap("getButtonTintList", $$robo$$android_widget_CompoundButton$getButtonTintList(), this);
    }

    public void setButtonTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setButtonTintMode", $$robo$$android_widget_CompoundButton$setButtonTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    public PorterDuff.Mode getButtonTintMode() {
        return InvokeDynamicSupport.bootstrap("getButtonTintMode", $$robo$$android_widget_CompoundButton$getButtonTintMode(), this);
    }

    private void applyButtonTint() {
        InvokeDynamicSupport.bootstrap("applyButtonTint", $$robo$$android_widget_CompoundButton$applyButtonTint(), this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_CompoundButton$getAccessibilityClassName(), this);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_CompoundButton$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_CompoundButton$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    public int getCompoundPaddingLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingLeft", $$robo$$android_widget_CompoundButton$getCompoundPaddingLeft(), this);
    }

    @Override
    public int getCompoundPaddingRight() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingRight", $$robo$$android_widget_CompoundButton$getCompoundPaddingRight(), this);
    }

    @Override
    public int getHorizontalOffsetForDrawables() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffsetForDrawables", $$robo$$android_widget_CompoundButton$getHorizontalOffsetForDrawables(), this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_CompoundButton$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_CompoundButton$onCreateDrawableState(int ), this, n);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_CompoundButton$drawableStateChanged(), this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_CompoundButton$drawableHotspotChanged(float float ), this, f, f2);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_CompoundButton$verifyDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_CompoundButton$jumpDrawablesToCurrentState(), this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_CompoundButton$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_CompoundButton$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_CompoundButton$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    @Override
    public void onProvideAutofillStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("onProvideAutofillStructure", $$robo$$android_widget_CompoundButton$onProvideAutofillStructure(android.view.ViewStructure int ), this, viewStructure, n);
    }

    @Override
    public void autofill(AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_widget_CompoundButton$autofill(android.view.autofill.AutofillValue ), this, autofillValue);
    }

    @Override
    public int getAutofillType() {
        return (int)InvokeDynamicSupport.bootstrap("getAutofillType", $$robo$$android_widget_CompoundButton$getAutofillType(), this);
    }

    @Override
    public AutofillValue getAutofillValue() {
        return InvokeDynamicSupport.bootstrap("getAutofillValue", $$robo$$android_widget_CompoundButton$getAutofillValue(), this);
    }

    static {
        RobolectricInternals.classInitializing(CompoundButton.class);
    }

    public /* synthetic */ CompoundButton() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompoundButton)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean checked;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_CompoundButton_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_CompoundButton_SavedState$__constructor__(Parcel in) {
            this.checked = (Boolean)in.readValue(null);
        }

        private final void $$robo$$android_widget_CompoundButton_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue(this.checked);
        }

        private final String $$robo$$android_widget_CompoundButton_SavedState$toString() {
            return "CompoundButton.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " checked=" + this.checked + "}";
        }

        private /* synthetic */ void $$robo$$android_widget_CompoundButton_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_CompoundButton_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_CompoundButton_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in, null);
                }

                private final SavedState[] $$robo$$android_widget_CompoundButton_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_CompoundButton_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_CompoundButton_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_CompoundButton_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_CompoundButton_SavedState$__constructor__(parcelable);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton_SavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_CompoundButton_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_CompoundButton_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_CompoundButton_SavedState$toString(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_CompoundButton_SavedState$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CompoundButton_SavedState$__constructor__(android.os.Parcel android.widget.CompoundButton$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }
}

