/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SimpleMonthView;
import com.android.internal.widget.PagerAdapter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DayPickerPagerAdapter
extends PagerAdapter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MONTHS_IN_YEAR = 12;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private SparseArray<ViewHolder> mItems;
    private LayoutInflater mInflater;
    private int mLayoutResId;
    private int mCalendarViewId;
    private Calendar mSelectedDay;
    private int mMonthTextAppearance;
    private int mDayOfWeekTextAppearance;
    private int mDayTextAppearance;
    private ColorStateList mCalendarTextColor;
    private ColorStateList mDaySelectorColor;
    private ColorStateList mDayHighlightColor;
    private OnDaySelectedListener mOnDaySelectedListener;
    private int mCount;
    private int mFirstDayOfWeek;
    private SimpleMonthView.OnDayClickListener mOnDayClickListener;

    private void $$robo$$android_widget_DayPickerPagerAdapter$__constructor__(Context context, int layoutResId, int calendarViewId) {
        this.mMinDate = Calendar.getInstance();
        this.mMaxDate = Calendar.getInstance();
        this.mItems = new SparseArray();
        this.mSelectedDay = null;
        this.mOnDayClickListener = new SimpleMonthView.OnDayClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DayPickerPagerAdapter this$0;

            private void $$robo$$android_widget_DayPickerPagerAdapter_1$__constructor__(DayPickerPagerAdapter this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_DayPickerPagerAdapter_1$onDayClick(SimpleMonthView view, Calendar day) {
                if (day != null) {
                    this.this$0.setSelectedDay(day);
                    if (this.this$0.mOnDaySelectedListener != null) {
                        this.this$0.mOnDaySelectedListener.onDaySelected(this.this$0, day);
                    }
                }
            }

            private void __constructor__(DayPickerPagerAdapter dayPickerPagerAdapter) {
                this.$$robo$$android_widget_DayPickerPagerAdapter_1$__constructor__(dayPickerPagerAdapter);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerPagerAdapter_1$__constructor__(android.widget.DayPickerPagerAdapter ), this, dayPickerPagerAdapter);
            }

            @Override
            public void onDayClick(SimpleMonthView simpleMonthView, Calendar calendar) {
                InvokeDynamicSupport.bootstrap("onDayClick", $$robo$$android_widget_DayPickerPagerAdapter_1$onDayClick(android.widget.SimpleMonthView android.icu.util.Calendar ), this, simpleMonthView, calendar);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mInflater = LayoutInflater.from(context);
        this.mLayoutResId = layoutResId;
        this.mCalendarViewId = calendarViewId;
        TypedArray ta = context.obtainStyledAttributes(new int[]{16843820});
        this.mDayHighlightColor = ta.getColorStateList(0);
        ta.recycle();
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setRange(Calendar min, Calendar max) {
        this.mMinDate.setTimeInMillis(min.getTimeInMillis());
        this.mMaxDate.setTimeInMillis(max.getTimeInMillis());
        int diffYear = this.mMaxDate.get(1) - this.mMinDate.get(1);
        int diffMonth = this.mMaxDate.get(2) - this.mMinDate.get(2);
        this.mCount = diffMonth + 12 * diffYear + 1;
        this.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setFirstDayOfWeek(int weekStart) {
        this.mFirstDayOfWeek = weekStart;
        int count = this.mItems.size();
        for (int i = 0; i < count; ++i) {
            SimpleMonthView monthView = this.mItems.valueAt((int)i).calendar;
            monthView.setFirstDayOfWeek(weekStart);
        }
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    private final boolean $$robo$$android_widget_DayPickerPagerAdapter$getBoundsForDate(Calendar day, Rect outBounds) {
        int position = this.getPositionForDay(day);
        ViewHolder monthView = this.mItems.get(position, null);
        if (monthView == null) {
            return false;
        }
        int dayOfMonth = day.get(5);
        return monthView.calendar.getBoundsForDay(dayOfMonth, outBounds);
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setSelectedDay(Calendar day) {
        ViewHolder newMonthView;
        ViewHolder oldMonthView;
        int newPosition;
        int oldPosition = this.getPositionForDay(this.mSelectedDay);
        if (oldPosition != (newPosition = this.getPositionForDay(day)) && oldPosition >= 0 && (oldMonthView = (ViewHolder)this.mItems.get(oldPosition, null)) != null) {
            oldMonthView.calendar.setSelectedDay(-1);
        }
        if (newPosition >= 0 && (newMonthView = (ViewHolder)this.mItems.get(newPosition, null)) != null) {
            int dayOfMonth = day.get(5);
            newMonthView.calendar.setSelectedDay(dayOfMonth);
        }
        this.mSelectedDay = day;
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setCalendarTextColor(ColorStateList calendarTextColor) {
        this.mCalendarTextColor = calendarTextColor;
        this.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setDaySelectorColor(ColorStateList selectorColor) {
        this.mDaySelectorColor = selectorColor;
        this.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setMonthTextAppearance(int resId) {
        this.mMonthTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setDayOfWeekTextAppearance(int resId) {
        this.mDayOfWeekTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getDayOfWeekTextAppearance() {
        return this.mDayOfWeekTextAppearance;
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$setDayTextAppearance(int resId) {
        this.mDayTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getDayTextAppearance() {
        return this.mDayTextAppearance;
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getCount() {
        return this.mCount;
    }

    private final boolean $$robo$$android_widget_DayPickerPagerAdapter$isViewFromObject(View view, Object object) {
        ViewHolder holder = (ViewHolder)object;
        return view == holder.container;
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getMonthForPosition(int position) {
        return (position + this.mMinDate.get(2)) % 12;
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getYearForPosition(int position) {
        int yearOffset = (position + this.mMinDate.get(2)) / 12;
        return yearOffset + this.mMinDate.get(1);
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getPositionForDay(Calendar day) {
        if (day == null) {
            return -1;
        }
        int yearOffset = day.get(1) - this.mMinDate.get(1);
        int monthOffset = day.get(2) - this.mMinDate.get(2);
        int position = yearOffset * 12 + monthOffset;
        return position;
    }

    private final Object $$robo$$android_widget_DayPickerPagerAdapter$instantiateItem(ViewGroup container, int position) {
        View itemView = this.mInflater.inflate(this.mLayoutResId, container, false);
        SimpleMonthView v = (SimpleMonthView)itemView.findViewById(this.mCalendarViewId);
        v.setOnDayClickListener(this.mOnDayClickListener);
        v.setMonthTextAppearance(this.mMonthTextAppearance);
        v.setDayOfWeekTextAppearance(this.mDayOfWeekTextAppearance);
        v.setDayTextAppearance(this.mDayTextAppearance);
        if (this.mDaySelectorColor != null) {
            v.setDaySelectorColor(this.mDaySelectorColor);
        }
        if (this.mDayHighlightColor != null) {
            v.setDayHighlightColor(this.mDayHighlightColor);
        }
        if (this.mCalendarTextColor != null) {
            v.setMonthTextColor(this.mCalendarTextColor);
            v.setDayOfWeekTextColor(this.mCalendarTextColor);
            v.setDayTextColor(this.mCalendarTextColor);
        }
        int month = this.getMonthForPosition(position);
        int year = this.getYearForPosition(position);
        int selectedDay = this.mSelectedDay != null && this.mSelectedDay.get(2) == month ? this.mSelectedDay.get(5) : -1;
        int enabledDayRangeStart = this.mMinDate.get(2) == month && this.mMinDate.get(1) == year ? this.mMinDate.get(5) : 1;
        int enabledDayRangeEnd = this.mMaxDate.get(2) == month && this.mMaxDate.get(1) == year ? this.mMaxDate.get(5) : 31;
        v.setMonthParams(selectedDay, month, year, this.mFirstDayOfWeek, enabledDayRangeStart, enabledDayRangeEnd);
        ViewHolder holder = new ViewHolder(position, itemView, v);
        this.mItems.put(position, holder);
        container.addView(itemView);
        return holder;
    }

    private final void $$robo$$android_widget_DayPickerPagerAdapter$destroyItem(ViewGroup container, int position, Object object) {
        ViewHolder holder = (ViewHolder)object;
        container.removeView(holder.container);
        this.mItems.remove(position);
    }

    private final int $$robo$$android_widget_DayPickerPagerAdapter$getItemPosition(Object object) {
        ViewHolder holder = (ViewHolder)object;
        return holder.position;
    }

    private final CharSequence $$robo$$android_widget_DayPickerPagerAdapter$getPageTitle(int position) {
        SimpleMonthView v = this.mItems.get((int)position).calendar;
        if (v != null) {
            return v.getMonthYearLabel();
        }
        return null;
    }

    private final SimpleMonthView $$robo$$android_widget_DayPickerPagerAdapter$getView(Object object) {
        if (object == null) {
            return null;
        }
        ViewHolder holder = (ViewHolder)object;
        return holder.calendar;
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$android_widget_DayPickerPagerAdapter$__constructor__(context, n, n2);
    }

    public DayPickerPagerAdapter(Context context, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerPagerAdapter$__constructor__(android.content.Context int int ), this, context, n, n2);
    }

    public void setRange(Calendar calendar, Calendar calendar2) {
        InvokeDynamicSupport.bootstrap("setRange", $$robo$$android_widget_DayPickerPagerAdapter$setRange(android.icu.util.Calendar android.icu.util.Calendar ), this, calendar, calendar2);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DayPickerPagerAdapter$setFirstDayOfWeek(int ), this, n);
    }

    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DayPickerPagerAdapter$getFirstDayOfWeek(), this);
    }

    public boolean getBoundsForDate(Calendar calendar, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoundsForDate", $$robo$$android_widget_DayPickerPagerAdapter$getBoundsForDate(android.icu.util.Calendar android.graphics.Rect ), this, calendar, rect);
    }

    public void setSelectedDay(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("setSelectedDay", $$robo$$android_widget_DayPickerPagerAdapter$setSelectedDay(android.icu.util.Calendar ), this, calendar);
    }

    public void setOnDaySelectedListener(OnDaySelectedListener onDaySelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnDaySelectedListener", $$robo$$android_widget_DayPickerPagerAdapter$setOnDaySelectedListener(android.widget.DayPickerPagerAdapter$OnDaySelectedListener ), this, onDaySelectedListener);
    }

    void setCalendarTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCalendarTextColor", $$robo$$android_widget_DayPickerPagerAdapter$setCalendarTextColor(android.content.res.ColorStateList ), this, colorStateList);
    }

    void setDaySelectorColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setDaySelectorColor", $$robo$$android_widget_DayPickerPagerAdapter$setDaySelectorColor(android.content.res.ColorStateList ), this, colorStateList);
    }

    void setMonthTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setMonthTextAppearance", $$robo$$android_widget_DayPickerPagerAdapter$setMonthTextAppearance(int ), this, n);
    }

    void setDayOfWeekTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayOfWeekTextAppearance", $$robo$$android_widget_DayPickerPagerAdapter$setDayOfWeekTextAppearance(int ), this, n);
    }

    int getDayOfWeekTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfWeekTextAppearance", $$robo$$android_widget_DayPickerPagerAdapter$getDayOfWeekTextAppearance(), this);
    }

    void setDayTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDayTextAppearance", $$robo$$android_widget_DayPickerPagerAdapter$setDayTextAppearance(int ), this, n);
    }

    int getDayTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getDayTextAppearance", $$robo$$android_widget_DayPickerPagerAdapter$getDayTextAppearance(), this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_DayPickerPagerAdapter$getCount(), this);
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("isViewFromObject", $$robo$$android_widget_DayPickerPagerAdapter$isViewFromObject(android.view.View java.lang.Object ), this, view, object);
    }

    private int getMonthForPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMonthForPosition", $$robo$$android_widget_DayPickerPagerAdapter$getMonthForPosition(int ), this, n);
    }

    private int getYearForPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getYearForPosition", $$robo$$android_widget_DayPickerPagerAdapter$getYearForPosition(int ), this, n);
    }

    private int getPositionForDay(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrap("getPositionForDay", $$robo$$android_widget_DayPickerPagerAdapter$getPositionForDay(android.icu.util.Calendar ), this, calendar);
    }

    @Override
    public Object instantiateItem(ViewGroup viewGroup, int n) {
        return InvokeDynamicSupport.bootstrap("instantiateItem", $$robo$$android_widget_DayPickerPagerAdapter$instantiateItem(android.view.ViewGroup int ), this, viewGroup, n);
    }

    @Override
    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        InvokeDynamicSupport.bootstrap("destroyItem", $$robo$$android_widget_DayPickerPagerAdapter$destroyItem(android.view.ViewGroup int java.lang.Object ), this, viewGroup, n, object);
    }

    @Override
    public int getItemPosition(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getItemPosition", $$robo$$android_widget_DayPickerPagerAdapter$getItemPosition(java.lang.Object ), this, object);
    }

    @Override
    public CharSequence getPageTitle(int n) {
        return InvokeDynamicSupport.bootstrap("getPageTitle", $$robo$$android_widget_DayPickerPagerAdapter$getPageTitle(int ), this, n);
    }

    SimpleMonthView getView(Object object) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_DayPickerPagerAdapter$getView(java.lang.Object ), this, object);
    }

    public /* synthetic */ DayPickerPagerAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPickerPagerAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(DayPickerPagerAdapter var1, Calendar var2);
    }

    private static class ViewHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int position;
        public View container;
        public SimpleMonthView calendar;

        private void $$robo$$android_widget_DayPickerPagerAdapter_ViewHolder$__constructor__(int position, View container, SimpleMonthView calendar) {
            this.position = position;
            this.container = container;
            this.calendar = calendar;
        }

        private void __constructor__(int n, View view, SimpleMonthView simpleMonthView) {
            this.$$robo$$android_widget_DayPickerPagerAdapter_ViewHolder$__constructor__(n, view, simpleMonthView);
        }

        public ViewHolder(int n, View view, SimpleMonthView simpleMonthView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerPagerAdapter_ViewHolder$__constructor__(int android.view.View android.widget.SimpleMonthView ), this, n, view, simpleMonthView);
        }

        public /* synthetic */ ViewHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

