/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.RemotableViewMethod;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.animation.GridLayoutAnimationController;
import android.widget.AbsListView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class GridView
extends AbsListView
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int NO_STRETCH = 0;
    public static int STRETCH_SPACING = 1;
    public static int STRETCH_COLUMN_WIDTH = 2;
    public static int STRETCH_SPACING_UNIFORM = 3;
    public static int AUTO_FIT = -1;
    private int mNumColumns;
    private int mHorizontalSpacing;
    private int mRequestedHorizontalSpacing;
    private int mVerticalSpacing;
    private int mStretchMode;
    private int mColumnWidth;
    private int mRequestedColumnWidth;
    private int mRequestedNumColumns;
    private View mReferenceView;
    private View mReferenceViewInSelectedRow;
    private int mGravity;
    private Rect mTempRect;

    private void $$robo$$android_widget_GridView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_GridView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_GridView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_GridView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int columnWidth;
        this.mNumColumns = -1;
        this.mHorizontalSpacing = 0;
        this.mVerticalSpacing = 0;
        this.mStretchMode = 2;
        this.mReferenceView = null;
        this.mReferenceViewInSelectedRow = null;
        this.mGravity = 0x800003;
        this.mTempRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridView, defStyleAttr, defStyleRes);
        int hSpacing = a.getDimensionPixelOffset(1, 0);
        this.setHorizontalSpacing(hSpacing);
        int vSpacing = a.getDimensionPixelOffset(2, 0);
        this.setVerticalSpacing(vSpacing);
        int index = a.getInt(3, 2);
        if (index >= 0) {
            this.setStretchMode(index);
        }
        if ((columnWidth = a.getDimensionPixelOffset(4, -1)) > 0) {
            this.setColumnWidth(columnWidth);
        }
        int numColumns = a.getInt(5, 1);
        this.setNumColumns(numColumns);
        index = a.getInt(0, -1);
        if (index >= 0) {
            this.setGravity(index);
        }
        a.recycle();
    }

    private final ListAdapter $$robo$$android_widget_GridView$getAdapter() {
        return this.mAdapter;
    }

    @RemotableViewMethod(asyncImpl="setRemoteViewsAdapterAsync")
    private final void $$robo$$android_widget_GridView$setRemoteViewsAdapter(Intent intent) {
        super.setRemoteViewsAdapter(intent);
    }

    private final void $$robo$$android_widget_GridView$setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        super.setAdapter(adapter);
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.mDataChanged = true;
            this.checkFocus();
            this.mDataSetObserver = new AbsListView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int position = this.mStackFromBottom ? this.lookForSelectablePosition(this.mItemCount - 1, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            this.checkSelectionChanged();
        } else {
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    private final int $$robo$$android_widget_GridView$lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        if (position < 0 || position >= this.mItemCount) {
            return -1;
        }
        return position;
    }

    private final void $$robo$$android_widget_GridView$fillGap(boolean down) {
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int count = this.getChildCount();
        if (down) {
            int paddingTop = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingTop = this.getListPaddingTop();
            }
            int startOffset = count > 0 ? this.getChildAt(count - 1).getBottom() + verticalSpacing : paddingTop;
            int position = this.mFirstPosition + count;
            if (this.mStackFromBottom) {
                position += numColumns - 1;
            }
            this.fillDown(position, startOffset);
            this.correctTooHigh(numColumns, verticalSpacing, this.getChildCount());
        } else {
            int paddingBottom = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingBottom = this.getListPaddingBottom();
            }
            int startOffset = count > 0 ? this.getChildAt(0).getTop() - verticalSpacing : this.getHeight() - paddingBottom;
            int position = this.mFirstPosition;
            position = !this.mStackFromBottom ? (position -= numColumns) : --position;
            this.fillUp(position, startOffset);
            this.correctTooLow(numColumns, verticalSpacing, this.getChildCount());
        }
    }

    private final View $$robo$$android_widget_GridView$fillDown(int pos, int nextTop) {
        View selectedView = null;
        int end = this.mBottom - this.mTop;
        if ((this.mGroupFlags & 0x22) == 34) {
            end -= this.mListPadding.bottom;
        }
        while (nextTop < end && pos < this.mItemCount) {
            View temp = this.makeRow(pos, nextTop, true);
            if (temp != null) {
                selectedView = temp;
            }
            nextTop = this.mReferenceView.getBottom() + this.mVerticalSpacing;
            pos += this.mNumColumns;
        }
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private final View $$robo$$android_widget_GridView$makeRow(int startPos, int y, boolean flow) {
        int last;
        int columnWidth = this.mColumnWidth;
        int horizontalSpacing = this.mHorizontalSpacing;
        boolean isLayoutRtl = this.isLayoutRtl();
        int nextLeft = isLayoutRtl ? this.getWidth() - this.mListPadding.right - columnWidth - (this.mStretchMode == 3 ? horizontalSpacing : 0) : this.mListPadding.left + (this.mStretchMode == 3 ? horizontalSpacing : 0);
        if (!this.mStackFromBottom) {
            last = Math.min(startPos + this.mNumColumns, this.mItemCount);
        } else {
            last = startPos + 1;
            if (last - (startPos = Math.max(0, startPos - this.mNumColumns + 1)) < this.mNumColumns) {
                int deltaLeft = (this.mNumColumns - (last - startPos)) * (columnWidth + horizontalSpacing);
                nextLeft += (isLayoutRtl ? -1 : 1) * deltaLeft;
            }
        }
        View selectedView = null;
        boolean hasFocus = this.shouldShowSelector();
        boolean inClick = this.touchModeDrawsInPressedState();
        int selectedPosition = this.mSelectedPosition;
        View child = null;
        int nextChildDir = isLayoutRtl ? -1 : 1;
        for (int pos = startPos; pos < last; ++pos) {
            boolean selected = pos == selectedPosition;
            int where = flow ? -1 : pos - startPos;
            child = this.makeAndAddView(pos, y, flow, nextLeft, selected, where);
            nextLeft += nextChildDir * columnWidth;
            if (pos < last - 1) {
                nextLeft += nextChildDir * horizontalSpacing;
            }
            if (!selected || !hasFocus && !inClick) continue;
            selectedView = child;
        }
        this.mReferenceView = child;
        if (selectedView != null) {
            this.mReferenceViewInSelectedRow = this.mReferenceView;
        }
        return selectedView;
    }

    private final View $$robo$$android_widget_GridView$fillUp(int pos, int nextBottom) {
        View selectedView = null;
        int end = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            end = this.mListPadding.top;
        }
        while (nextBottom > end && pos >= 0) {
            View temp = this.makeRow(pos, nextBottom, false);
            if (temp != null) {
                selectedView = temp;
            }
            nextBottom = this.mReferenceView.getTop() - this.mVerticalSpacing;
            this.mFirstPosition = pos;
            pos -= this.mNumColumns;
        }
        if (this.mStackFromBottom) {
            this.mFirstPosition = Math.max(0, pos + 1);
        }
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private final View $$robo$$android_widget_GridView$fillFromTop(int nextTop) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        this.mFirstPosition -= this.mFirstPosition % this.mNumColumns;
        return this.fillDown(this.mFirstPosition, nextTop);
    }

    private final View $$robo$$android_widget_GridView$fillFromBottom(int lastPosition, int nextBottom) {
        lastPosition = Math.max(lastPosition, this.mSelectedPosition);
        lastPosition = Math.min(lastPosition, this.mItemCount - 1);
        int invertedPosition = this.mItemCount - 1 - lastPosition;
        lastPosition = this.mItemCount - 1 - (invertedPosition - invertedPosition % this.mNumColumns);
        return this.fillUp(lastPosition, nextBottom);
    }

    private final View $$robo$$android_widget_GridView$fillSelection(int childrenTop, int childrenBottom) {
        int rowStart;
        int selectedPosition = this.reconcileSelectedPosition();
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
        }
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        View sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, topSelectionPixel, true);
        this.mFirstPosition = rowStart;
        View referenceView = this.mReferenceView;
        if (!this.mStackFromBottom) {
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
            this.pinToBottom(childrenBottom);
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
        } else {
            int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
            int offset = bottomSelectionPixel - referenceView.getBottom();
            this.offsetChildrenTopAndBottom(offset);
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
            this.pinToTop(childrenTop);
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
        }
        return sel;
    }

    private final void $$robo$$android_widget_GridView$pinToTop(int childrenTop) {
        int top;
        int offset;
        if (this.mFirstPosition == 0 && (offset = childrenTop - (top = this.getChildAt(0).getTop())) < 0) {
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    private final void $$robo$$android_widget_GridView$pinToBottom(int childrenBottom) {
        int bottom;
        int offset;
        int count = this.getChildCount();
        if (this.mFirstPosition + count == this.mItemCount && (offset = childrenBottom - (bottom = this.getChildAt(count - 1).getBottom())) > 0) {
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    private final int $$robo$$android_widget_GridView$findMotionRow(int y) {
        block4: {
            int childCount = this.getChildCount();
            if (childCount <= 0) break block4;
            int numColumns = this.mNumColumns;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < childCount; i += numColumns) {
                    if (y > this.getChildAt(i).getBottom()) continue;
                    return this.mFirstPosition + i;
                }
            } else {
                for (int i = childCount - 1; i >= 0; i -= numColumns) {
                    if (y < this.getChildAt(i).getTop()) continue;
                    return this.mFirstPosition + i;
                }
            }
        }
        return -1;
    }

    private final View $$robo$$android_widget_GridView$fillSpecific(int position, int top) {
        View below;
        View above;
        int motionRowStart;
        int numColumns = this.mNumColumns;
        int motionRowEnd = -1;
        if (!this.mStackFromBottom) {
            motionRowStart = position - position % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - position;
            motionRowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            motionRowStart = Math.max(0, motionRowEnd - numColumns + 1);
        }
        View temp = this.makeRow(this.mStackFromBottom ? motionRowEnd : motionRowStart, top, true);
        this.mFirstPosition = motionRowStart;
        View referenceView = this.mReferenceView;
        if (referenceView == null) {
            return null;
        }
        int verticalSpacing = this.mVerticalSpacing;
        if (!this.mStackFromBottom) {
            above = this.fillUp(motionRowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            below = this.fillDown(motionRowStart + numColumns, referenceView.getBottom() + verticalSpacing);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooHigh(numColumns, verticalSpacing, childCount);
            }
        } else {
            below = this.fillDown(motionRowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            above = this.fillUp(motionRowStart - 1, referenceView.getTop() - verticalSpacing);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooLow(numColumns, verticalSpacing, childCount);
            }
        }
        if (temp != null) {
            return temp;
        }
        if (above != null) {
            return above;
        }
        return below;
    }

    private final void $$robo$$android_widget_GridView$correctTooHigh(int numColumns, int verticalSpacing, int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int bottomOffset = end - lastBottom;
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            if (bottomOffset > 0 && (this.mFirstPosition > 0 || firstTop < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    bottomOffset = Math.min(bottomOffset, this.mListPadding.top - firstTop);
                }
                this.offsetChildrenTopAndBottom(bottomOffset);
                if (this.mFirstPosition > 0) {
                    this.fillUp(this.mFirstPosition - (this.mStackFromBottom ? 1 : numColumns), firstChild.getTop() - verticalSpacing);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private final void $$robo$$android_widget_GridView$correctTooLow(int numColumns, int verticalSpacing, int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            int start = this.mListPadding.top;
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int topOffset = firstTop - start;
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (topOffset > 0 && (lastPosition < this.mItemCount - 1 || lastBottom > end)) {
                if (lastPosition == this.mItemCount - 1) {
                    topOffset = Math.min(topOffset, lastBottom - end);
                }
                this.offsetChildrenTopAndBottom(-topOffset);
                if (lastPosition < this.mItemCount - 1) {
                    this.fillDown(lastPosition + (!this.mStackFromBottom ? 1 : numColumns), lastChild.getBottom() + verticalSpacing);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private final View $$robo$$android_widget_GridView$fillFromSelection(int selectedTop, int childrenTop, int childrenBottom) {
        int rowStart;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
        }
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
        View sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, selectedTop, true);
        this.mFirstPosition = rowStart;
        View referenceView = this.mReferenceView;
        this.adjustForTopFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        this.adjustForBottomFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        if (!this.mStackFromBottom) {
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
        } else {
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
        }
        return sel;
    }

    private final int $$robo$$android_widget_GridView$getBottomSelectionPixel(int childrenBottom, int fadingEdgeLength, int numColumns, int rowStart) {
        int bottomSelectionPixel = childrenBottom;
        if (rowStart + numColumns - 1 < this.mItemCount - 1) {
            bottomSelectionPixel -= fadingEdgeLength;
        }
        return bottomSelectionPixel;
    }

    private final int $$robo$$android_widget_GridView$getTopSelectionPixel(int childrenTop, int fadingEdgeLength, int rowStart) {
        int topSelectionPixel = childrenTop;
        if (rowStart > 0) {
            topSelectionPixel += fadingEdgeLength;
        }
        return topSelectionPixel;
    }

    private final void $$robo$$android_widget_GridView$adjustForBottomFadingEdge(View childInSelectedRow, int topSelectionPixel, int bottomSelectionPixel) {
        if (childInSelectedRow.getBottom() > bottomSelectionPixel) {
            int spaceAbove = childInSelectedRow.getTop() - topSelectionPixel;
            int spaceBelow = childInSelectedRow.getBottom() - bottomSelectionPixel;
            int offset = Math.min(spaceAbove, spaceBelow);
            this.offsetChildrenTopAndBottom(-offset);
        }
    }

    private final void $$robo$$android_widget_GridView$adjustForTopFadingEdge(View childInSelectedRow, int topSelectionPixel, int bottomSelectionPixel) {
        if (childInSelectedRow.getTop() < topSelectionPixel) {
            int spaceAbove = topSelectionPixel - childInSelectedRow.getTop();
            int spaceBelow = bottomSelectionPixel - childInSelectedRow.getBottom();
            int offset = Math.min(spaceAbove, spaceBelow);
            this.offsetChildrenTopAndBottom(offset);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_GridView$smoothScrollToPosition(int position) {
        super.smoothScrollToPosition(position);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_GridView$smoothScrollByOffset(int offset) {
        super.smoothScrollByOffset(offset);
    }

    private final View $$robo$$android_widget_GridView$moveSelection(int delta, int childrenTop, int childrenBottom) {
        View referenceView;
        View sel;
        int rowStart;
        int oldRowStart;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        int verticalSpacing = this.mVerticalSpacing;
        int rowEnd = -1;
        if (!this.mStackFromBottom) {
            oldRowStart = selectedPosition - delta - (selectedPosition - delta) % numColumns;
            rowStart = selectedPosition - selectedPosition % numColumns;
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            rowEnd = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            rowStart = Math.max(0, rowEnd - numColumns + 1);
            invertedSelection = this.mItemCount - 1 - (selectedPosition - delta);
            oldRowStart = this.mItemCount - 1 - (invertedSelection - invertedSelection % numColumns);
            oldRowStart = Math.max(0, oldRowStart - numColumns + 1);
        }
        int rowDelta = rowStart - oldRowStart;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, rowStart);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, numColumns, rowStart);
        this.mFirstPosition = rowStart;
        if (rowDelta > 0) {
            int oldBottom = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getBottom();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldBottom + verticalSpacing, true);
            referenceView = this.mReferenceView;
            this.adjustForBottomFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        } else if (rowDelta < 0) {
            int oldTop = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldTop - verticalSpacing, false);
            referenceView = this.mReferenceView;
            this.adjustForTopFadingEdge(referenceView, topSelectionPixel, bottomSelectionPixel);
        } else {
            int oldTop = this.mReferenceViewInSelectedRow == null ? 0 : this.mReferenceViewInSelectedRow.getTop();
            sel = this.makeRow(this.mStackFromBottom ? rowEnd : rowStart, oldTop, true);
            referenceView = this.mReferenceView;
        }
        if (!this.mStackFromBottom) {
            this.fillUp(rowStart - numColumns, referenceView.getTop() - verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillDown(rowStart + numColumns, referenceView.getBottom() + verticalSpacing);
        } else {
            this.fillDown(rowEnd + numColumns, referenceView.getBottom() + verticalSpacing);
            this.adjustViewsUpOrDown();
            this.fillUp(rowStart - 1, referenceView.getTop() - verticalSpacing);
        }
        return sel;
    }

    private final boolean $$robo$$android_widget_GridView$determineColumns(int availableSpace) {
        int requestedHorizontalSpacing = this.mRequestedHorizontalSpacing;
        int stretchMode = this.mStretchMode;
        int requestedColumnWidth = this.mRequestedColumnWidth;
        boolean didNotInitiallyFit = false;
        this.mNumColumns = this.mRequestedNumColumns == -1 ? (requestedColumnWidth > 0 ? (availableSpace + requestedHorizontalSpacing) / (requestedColumnWidth + requestedHorizontalSpacing) : 2) : this.mRequestedNumColumns;
        if (this.mNumColumns <= 0) {
            this.mNumColumns = 1;
        }
        block0 : switch (stretchMode) {
            case 0: {
                this.mColumnWidth = requestedColumnWidth;
                this.mHorizontalSpacing = requestedHorizontalSpacing;
                break;
            }
            default: {
                int spaceLeftOver = availableSpace - this.mNumColumns * requestedColumnWidth - (this.mNumColumns - 1) * requestedHorizontalSpacing;
                if (spaceLeftOver < 0) {
                    didNotInitiallyFit = true;
                }
                switch (stretchMode) {
                    case 2: {
                        this.mColumnWidth = requestedColumnWidth + spaceLeftOver / this.mNumColumns;
                        this.mHorizontalSpacing = requestedHorizontalSpacing;
                        break block0;
                    }
                    case 1: {
                        this.mColumnWidth = requestedColumnWidth;
                        if (this.mNumColumns > 1) {
                            this.mHorizontalSpacing = requestedHorizontalSpacing + spaceLeftOver / (this.mNumColumns - 1);
                            break block0;
                        }
                        this.mHorizontalSpacing = requestedHorizontalSpacing + spaceLeftOver;
                        break block0;
                    }
                    case 3: {
                        this.mColumnWidth = requestedColumnWidth;
                        this.mHorizontalSpacing = this.mNumColumns > 1 ? requestedHorizontalSpacing + spaceLeftOver / (this.mNumColumns + 1) : requestedHorizontalSpacing + spaceLeftOver;
                    }
                }
            }
        }
        return didNotInitiallyFit;
    }

    private final void $$robo$$android_widget_GridView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int ourSize;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode == 0) {
            widthSize = this.mColumnWidth > 0 ? this.mColumnWidth + this.mListPadding.left + this.mListPadding.right : this.mListPadding.left + this.mListPadding.right;
            widthSize += this.getVerticalScrollbarWidth();
        }
        int childWidth = widthSize - this.mListPadding.left - this.mListPadding.right;
        boolean didNotInitiallyFit = this.determineColumns(childWidth);
        int childHeight = 0;
        int childState = 0;
        this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        int count = this.mItemCount;
        if (count > 0) {
            View child = this.obtainView(0, this.mIsScrap);
            AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
            if (p == null) {
                p = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
                child.setLayoutParams(p);
            }
            p.viewType = this.mAdapter.getItemViewType(0);
            p.isEnabled = this.mAdapter.isEnabled(0);
            p.forceAdd = true;
            int childHeightSpec = GridView.getChildMeasureSpec(View.MeasureSpec.makeSafeMeasureSpec(View.MeasureSpec.getSize(heightMeasureSpec), 0), 0, p.height);
            int childWidthSpec = GridView.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, p.width);
            child.measure(childWidthSpec, childHeightSpec);
            childHeight = child.getMeasuredHeight();
            childState = GridView.combineMeasuredStates(childState, child.getMeasuredState());
            if (this.mRecycler.shouldRecycleViewType(p.viewType)) {
                this.mRecycler.addScrapView(child, -1);
            }
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (heightMode == Integer.MIN_VALUE) {
            int ourSize2 = this.mListPadding.top + this.mListPadding.bottom;
            int numColumns = this.mNumColumns;
            for (int i = 0; i < count; i += numColumns) {
                ourSize2 += childHeight;
                if (i + numColumns < count) {
                    ourSize2 += this.mVerticalSpacing;
                }
                if (ourSize2 < heightSize) continue;
                ourSize2 = heightSize;
                break;
            }
            heightSize = ourSize2;
        }
        if (widthMode == Integer.MIN_VALUE && this.mRequestedNumColumns != -1 && ((ourSize = this.mRequestedNumColumns * this.mColumnWidth + (this.mRequestedNumColumns - 1) * this.mHorizontalSpacing + this.mListPadding.left + this.mListPadding.right) > widthSize || didNotInitiallyFit)) {
            widthSize |= 0x1000000;
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    private final void $$robo$$android_widget_GridView$attachLayoutAnimationParameters(View child, ViewGroup.LayoutParams params, int index, int count) {
        GridLayoutAnimationController.AnimationParameters animationParams = (GridLayoutAnimationController.AnimationParameters)params.layoutAnimationParameters;
        if (animationParams == null) {
            animationParams = new GridLayoutAnimationController.AnimationParameters();
            params.layoutAnimationParameters = animationParams;
        }
        animationParams.count = count;
        animationParams.index = index;
        animationParams.columnsCount = this.mNumColumns;
        animationParams.rowsCount = count / this.mNumColumns;
        if (!this.mStackFromBottom) {
            animationParams.column = index % this.mNumColumns;
            animationParams.row = index / this.mNumColumns;
        } else {
            int invertedIndex = count - 1 - index;
            animationParams.column = this.mNumColumns - 1 - invertedIndex % this.mNumColumns;
            animationParams.row = animationParams.rowsCount - 1 - invertedIndex / this.mNumColumns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_GridView$layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (!blockLayoutRequests) {
            this.mBlockLayoutRequests = true;
        }
        try {
            View newAccessibilityFocusedView;
            View sel;
            View focusChild;
            View focusHost;
            boolean dataChanged;
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int childrenTop = this.mListPadding.top;
            int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
            int childCount = this.getChildCount();
            int delta = 0;
            View oldSel = null;
            View oldFirst = null;
            View newSel = null;
            switch (this.mLayoutMode) {
                case 2: {
                    int index = this.mNextSelectedPosition - this.mFirstPosition;
                    if (index < 0 || index >= childCount) break;
                    newSel = this.getChildAt(index);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (this.mNextSelectedPosition < 0) break;
                    delta = this.mNextSelectedPosition - this.mSelectedPosition;
                    break;
                }
                default: {
                    int index = this.mSelectedPosition - this.mFirstPosition;
                    if (index >= 0 && index < childCount) {
                        oldSel = this.getChildAt(index);
                    }
                    oldFirst = this.getChildAt(0);
                }
            }
            if (dataChanged = this.mDataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            this.setSelectedPositionInt(this.mNextSelectedPosition);
            AccessibilityNodeInfo accessibilityFocusLayoutRestoreNode = null;
            View accessibilityFocusLayoutRestoreView = null;
            int accessibilityFocusPosition = -1;
            ViewRootImpl viewRootImpl = this.getViewRootImpl();
            if (viewRootImpl != null && (focusHost = viewRootImpl.getAccessibilityFocusedHost()) != null && (focusChild = this.getAccessibilityFocusedChild(focusHost)) != null) {
                if (!dataChanged || focusChild.hasTransientState() || this.mAdapterHasStableIds) {
                    accessibilityFocusLayoutRestoreView = focusHost;
                    accessibilityFocusLayoutRestoreNode = viewRootImpl.getAccessibilityFocusedVirtualView();
                }
                accessibilityFocusPosition = this.getPositionForView(focusChild);
            }
            int firstPosition = this.mFirstPosition;
            AbsListView.RecycleBin recycleBin = this.mRecycler;
            if (dataChanged) {
                for (int i = 0; i < childCount; ++i) {
                    recycleBin.addScrapView(this.getChildAt(i), firstPosition + i);
                }
            } else {
                recycleBin.fillActiveViews(childCount, firstPosition);
            }
            this.detachAllViewsFromParent();
            recycleBin.removeSkippedScrap();
            switch (this.mLayoutMode) {
                case 2: {
                    if (newSel != null) {
                        sel = this.fillFromSelection(newSel.getTop(), childrenTop, childrenBottom);
                        break;
                    }
                    sel = this.fillSelection(childrenTop, childrenBottom);
                    break;
                }
                case 1: {
                    this.mFirstPosition = 0;
                    sel = this.fillFromTop(childrenTop);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 3: {
                    sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 4: {
                    sel = this.fillSpecific(this.mSelectedPosition, this.mSpecificTop);
                    break;
                }
                case 5: {
                    sel = this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                    break;
                }
                case 6: {
                    sel = this.moveSelection(delta, childrenTop, childrenBottom);
                    break;
                }
                default: {
                    if (childCount == 0) {
                        if (!this.mStackFromBottom) {
                            this.setSelectedPositionInt(this.mAdapter == null || this.isInTouchMode() ? -1 : 0);
                            sel = this.fillFromTop(childrenTop);
                            break;
                        }
                        int last = this.mItemCount - 1;
                        this.setSelectedPositionInt(this.mAdapter == null || this.isInTouchMode() ? -1 : last);
                        sel = this.fillFromBottom(last, childrenBottom);
                        break;
                    }
                    sel = this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount ? this.fillSpecific(this.mSelectedPosition, oldSel == null ? childrenTop : oldSel.getTop()) : (this.mFirstPosition < this.mItemCount ? this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenTop : oldFirst.getTop()) : this.fillSpecific(0, childrenTop));
                }
            }
            recycleBin.scrapActiveViews();
            if (sel != null) {
                this.positionSelector(-1, sel);
                this.mSelectedTop = sel.getTop();
            } else {
                View child;
                boolean inTouchMode;
                boolean bl = inTouchMode = this.mTouchMode > 0 && this.mTouchMode < 3;
                if (inTouchMode) {
                    child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mMotionPosition, child);
                    }
                } else if (this.mSelectedPosition != -1) {
                    child = this.getChildAt(this.mSelectorPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mSelectorPosition, child);
                    }
                } else {
                    this.mSelectedTop = 0;
                    this.mSelectorRect.setEmpty();
                }
            }
            if (viewRootImpl != null && (newAccessibilityFocusedView = viewRootImpl.getAccessibilityFocusedHost()) == null) {
                int position;
                View restoreView;
                if (accessibilityFocusLayoutRestoreView != null && accessibilityFocusLayoutRestoreView.isAttachedToWindow()) {
                    AccessibilityNodeProvider provider = accessibilityFocusLayoutRestoreView.getAccessibilityNodeProvider();
                    if (accessibilityFocusLayoutRestoreNode != null && provider != null) {
                        int virtualViewId = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityFocusLayoutRestoreNode.getSourceNodeId());
                        provider.performAction(virtualViewId, 64, null);
                    } else {
                        accessibilityFocusLayoutRestoreView.requestAccessibilityFocus();
                    }
                } else if (accessibilityFocusPosition != -1 && (restoreView = this.getChildAt(position = MathUtils.constrain(accessibilityFocusPosition - this.mFirstPosition, 0, this.getChildCount() - 1))) != null) {
                    restoreView.requestAccessibilityFocus();
                }
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            if (this.mPositionScrollAfterLayout != null) {
                this.post(this.mPositionScrollAfterLayout);
                this.mPositionScrollAfterLayout = null;
            }
            this.mNeedSync = false;
            this.setNextSelectedPositionInt(this.mSelectedPosition);
            this.updateScrollIndicators();
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        finally {
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private final View $$robo$$android_widget_GridView$makeAndAddView(int position, int y, boolean flow, int childrenLeft, boolean selected, int where) {
        View activeView;
        if (!this.mDataChanged && (activeView = this.mRecycler.getActiveView(position)) != null) {
            this.setupChild(activeView, position, y, flow, childrenLeft, selected, true, where);
            return activeView;
        }
        View child = this.obtainView(position, this.mIsScrap);
        this.setupChild(child, position, y, flow, childrenLeft, selected, this.mIsScrap[0], where);
        return child;
    }

    private final void $$robo$$android_widget_GridView$setupChild(View child, int position, int y, boolean flowDown, int childrenLeft, boolean selected, boolean isAttachedToWindow, int where) {
        int childLeft;
        Trace.traceBegin(8L, "setupGridItem");
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected != child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed != child.isPressed();
        boolean needToMeasure = !isAttachedToWindow || updateChildSelected || child.isLayoutRequested();
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.isEnabled = this.mAdapter.isEnabled(position);
        if (updateChildSelected) {
            child.setSelected(isSelected);
            if (isSelected) {
                this.requestFocus();
            }
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
            } else if (this.getContext().getApplicationInfo().targetSdkVersion >= 11) {
                child.setActivated(this.mCheckStates.get(position));
            }
        }
        if (isAttachedToWindow && !p.forceAdd) {
            this.attachViewToParent(child, where, p);
            if (!isAttachedToWindow || ((AbsListView.LayoutParams)child.getLayoutParams()).scrappedFromPosition != position) {
                child.jumpDrawablesToCurrentState();
            }
        } else {
            p.forceAdd = false;
            this.addViewInLayout(child, where, p, true);
        }
        if (needToMeasure) {
            int childHeightSpec = ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(0, 0), 0, p.height);
            int childWidthSpec = ViewGroup.getChildMeasureSpec(View.MeasureSpec.makeMeasureSpec(this.mColumnWidth, 0x40000000), 0, p.width);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childTop = flowDown ? y : y - h;
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        switch (absoluteGravity & 7) {
            case 3: {
                childLeft = childrenLeft;
                break;
            }
            case 1: {
                childLeft = childrenLeft + (this.mColumnWidth - w) / 2;
                break;
            }
            case 5: {
                childLeft = childrenLeft + this.mColumnWidth - w;
                break;
            }
            default: {
                childLeft = childrenLeft;
            }
        }
        if (needToMeasure) {
            int childRight = childLeft + w;
            int childBottom = childTop + h;
            child.layout(childLeft, childTop, childRight, childBottom);
        } else {
            child.offsetLeftAndRight(childLeft - child.getLeft());
            child.offsetTopAndBottom(childTop - child.getTop());
        }
        if (this.mCachingStarted && !child.isDrawingCacheEnabled()) {
            child.setDrawingCacheEnabled(true);
        }
        Trace.traceEnd(8L);
    }

    private final void $$robo$$android_widget_GridView$setSelection(int position) {
        if (!this.isInTouchMode()) {
            this.setNextSelectedPositionInt(position);
        } else {
            this.mResurrectToPosition = position;
        }
        this.mLayoutMode = 2;
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.requestLayout();
    }

    private final void $$robo$$android_widget_GridView$setSelectionInt(int position) {
        int previousSelectedPosition = this.mNextSelectedPosition;
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.setNextSelectedPositionInt(position);
        this.layoutChildren();
        int next = this.mStackFromBottom ? this.mItemCount - 1 - this.mNextSelectedPosition : this.mNextSelectedPosition;
        int previous = this.mStackFromBottom ? this.mItemCount - 1 - previousSelectedPosition : previousSelectedPosition;
        int nextRow = next / this.mNumColumns;
        int previousRow = previous / this.mNumColumns;
        if (nextRow != previousRow) {
            this.awakenScrollBars();
        }
    }

    private final boolean $$robo$$android_widget_GridView$onKeyDown(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    private final boolean $$robo$$android_widget_GridView$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.commonKey(keyCode, repeatCount, event);
    }

    private final boolean $$robo$$android_widget_GridView$onKeyUp(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    private final boolean $$robo$$android_widget_GridView$commonKey(int keyCode, int count, KeyEvent event) {
        if (this.mAdapter == null) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean handled = false;
        int action = event.getAction();
        if (KeyEvent.isConfirmKey(keyCode) && event.hasNoModifiers() && action != 1 && !(handled = this.resurrectSelectionIfNeeded()) && event.getRepeatCount() == 0 && this.getChildCount() > 0) {
            this.keyPressed();
            handled = true;
        }
        if (!handled && action != 1) {
            switch (keyCode) {
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(17);
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(66);
                    break;
                }
                case 19: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(33);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 92: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 93: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 122: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 123: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.sequenceScroll(2);
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    boolean bl = handled = this.resurrectSelectionIfNeeded() || this.sequenceScroll(1);
                }
            }
        }
        if (handled) {
            return true;
        }
        if (this.sendToTextFilter(keyCode, count, event)) {
            return true;
        }
        switch (action) {
            case 0: {
                return super.onKeyDown(keyCode, event);
            }
            case 1: {
                return super.onKeyUp(keyCode, event);
            }
            case 2: {
                return super.onKeyMultiple(keyCode, count, event);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_GridView$pageScroll(int direction) {
        int nextPage = -1;
        if (direction == 33) {
            nextPage = Math.max(0, this.mSelectedPosition - this.getChildCount());
        } else if (direction == 130) {
            nextPage = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount());
        }
        if (nextPage >= 0) {
            this.setSelectionInt(nextPage);
            this.invokeOnItemScrollListener();
            this.awakenScrollBars();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_GridView$fullScroll(int direction) {
        boolean moved = false;
        if (direction == 33) {
            this.mLayoutMode = 2;
            this.setSelectionInt(0);
            this.invokeOnItemScrollListener();
            moved = true;
        } else if (direction == 130) {
            this.mLayoutMode = 2;
            this.setSelectionInt(this.mItemCount - 1);
            this.invokeOnItemScrollListener();
            moved = true;
        }
        if (moved) {
            this.awakenScrollBars();
        }
        return moved;
    }

    private final boolean $$robo$$android_widget_GridView$arrowScroll(int direction) {
        int endOfRowPos;
        int startOfRowPos;
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        boolean moved = false;
        if (!this.mStackFromBottom) {
            startOfRowPos = selectedPosition / numColumns * numColumns;
            endOfRowPos = Math.min(startOfRowPos + numColumns - 1, this.mItemCount - 1);
        } else {
            int invertedSelection = this.mItemCount - 1 - selectedPosition;
            endOfRowPos = this.mItemCount - 1 - invertedSelection / numColumns * numColumns;
            startOfRowPos = Math.max(0, endOfRowPos - numColumns + 1);
        }
        switch (direction) {
            case 33: {
                if (startOfRowPos <= 0) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.max(0, selectedPosition - numColumns));
                moved = true;
                break;
            }
            case 130: {
                if (endOfRowPos >= this.mItemCount - 1) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(Math.min(selectedPosition + numColumns, this.mItemCount - 1));
                moved = true;
            }
        }
        boolean isLayoutRtl = this.isLayoutRtl();
        if (selectedPosition > startOfRowPos && (direction == 17 && !isLayoutRtl || direction == 66 && isLayoutRtl)) {
            this.mLayoutMode = 6;
            this.setSelectionInt(Math.max(0, selectedPosition - 1));
            moved = true;
        } else if (selectedPosition < endOfRowPos && (direction == 17 && isLayoutRtl || direction == 66 && !isLayoutRtl)) {
            this.mLayoutMode = 6;
            this.setSelectionInt(Math.min(selectedPosition + 1, this.mItemCount - 1));
            moved = true;
        }
        if (moved) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
            this.invokeOnItemScrollListener();
        }
        if (moved) {
            this.awakenScrollBars();
        }
        return moved;
    }

    private final boolean $$robo$$android_widget_GridView$sequenceScroll(int direction) {
        int endOfRow;
        int startOfRow;
        int selectedPosition = this.mSelectedPosition;
        int numColumns = this.mNumColumns;
        int count = this.mItemCount;
        if (!this.mStackFromBottom) {
            startOfRow = selectedPosition / numColumns * numColumns;
            endOfRow = Math.min(startOfRow + numColumns - 1, count - 1);
        } else {
            int invertedSelection = count - 1 - selectedPosition;
            endOfRow = count - 1 - invertedSelection / numColumns * numColumns;
            startOfRow = Math.max(0, endOfRow - numColumns + 1);
        }
        boolean moved = false;
        boolean showScroll = false;
        switch (direction) {
            case 2: {
                if (selectedPosition >= count - 1) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(selectedPosition + 1);
                moved = true;
                showScroll = selectedPosition == endOfRow;
                break;
            }
            case 1: {
                if (selectedPosition <= 0) break;
                this.mLayoutMode = 6;
                this.setSelectionInt(selectedPosition - 1);
                moved = true;
                boolean bl = showScroll = selectedPosition == startOfRow;
            }
        }
        if (moved) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
            this.invokeOnItemScrollListener();
        }
        if (showScroll) {
            this.awakenScrollBars();
        }
        return moved;
    }

    private final void $$robo$$android_widget_GridView$onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        int closestChildIndex = -1;
        if (gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.mScrollX, this.mScrollY);
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (!this.isCandidateSelection(i, direction)) continue;
                View other = this.getChildAt(i);
                other.getDrawingRect(otherRect);
                this.offsetDescendantRectToMyCoords(other, otherRect);
                int distance = GridView.getDistance(previouslyFocusedRect, otherRect, direction);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestChildIndex = i;
            }
        }
        if (closestChildIndex >= 0) {
            this.setSelection(closestChildIndex + this.mFirstPosition);
        } else {
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_GridView$isCandidateSelection(int childIndex, int direction) {
        int rowEnd;
        int rowStart;
        int count = this.getChildCount();
        int invertedIndex = count - 1 - childIndex;
        if (!this.mStackFromBottom) {
            rowStart = childIndex - childIndex % this.mNumColumns;
            rowEnd = Math.min(rowStart + this.mNumColumns - 1, count);
        } else {
            rowEnd = count - 1 - (invertedIndex - invertedIndex % this.mNumColumns);
            rowStart = Math.max(0, rowEnd - this.mNumColumns + 1);
        }
        switch (direction) {
            case 66: {
                return childIndex == rowStart;
            }
            case 130: {
                return rowStart == 0;
            }
            case 17: {
                return childIndex == rowEnd;
            }
            case 33: {
                return rowEnd == count - 1;
            }
            case 2: {
                return childIndex == rowStart && rowStart == 0;
            }
            case 1: {
                return childIndex == rowEnd && rowEnd == count - 1;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
    }

    private final void $$robo$$android_widget_GridView$setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayoutIfNecessary();
        }
    }

    private final int $$robo$$android_widget_GridView$getGravity() {
        return this.mGravity;
    }

    private final void $$robo$$android_widget_GridView$setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing != this.mRequestedHorizontalSpacing) {
            this.mRequestedHorizontalSpacing = horizontalSpacing;
            this.requestLayoutIfNecessary();
        }
    }

    private final int $$robo$$android_widget_GridView$getHorizontalSpacing() {
        return this.mHorizontalSpacing;
    }

    private final int $$robo$$android_widget_GridView$getRequestedHorizontalSpacing() {
        return this.mRequestedHorizontalSpacing;
    }

    private final void $$robo$$android_widget_GridView$setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing != this.mVerticalSpacing) {
            this.mVerticalSpacing = verticalSpacing;
            this.requestLayoutIfNecessary();
        }
    }

    private final int $$robo$$android_widget_GridView$getVerticalSpacing() {
        return this.mVerticalSpacing;
    }

    private final void $$robo$$android_widget_GridView$setStretchMode(int stretchMode) {
        if (stretchMode != this.mStretchMode) {
            this.mStretchMode = stretchMode;
            this.requestLayoutIfNecessary();
        }
    }

    private final int $$robo$$android_widget_GridView$getStretchMode() {
        return this.mStretchMode;
    }

    private final void $$robo$$android_widget_GridView$setColumnWidth(int columnWidth) {
        if (columnWidth != this.mRequestedColumnWidth) {
            this.mRequestedColumnWidth = columnWidth;
            this.requestLayoutIfNecessary();
        }
    }

    private final int $$robo$$android_widget_GridView$getColumnWidth() {
        return this.mColumnWidth;
    }

    private final int $$robo$$android_widget_GridView$getRequestedColumnWidth() {
        return this.mRequestedColumnWidth;
    }

    private final void $$robo$$android_widget_GridView$setNumColumns(int numColumns) {
        if (numColumns != this.mRequestedNumColumns) {
            this.mRequestedNumColumns = numColumns;
            this.requestLayoutIfNecessary();
        }
    }

    @ViewDebug.ExportedProperty
    private final int $$robo$$android_widget_GridView$getNumColumns() {
        return this.mNumColumns;
    }

    private final void $$robo$$android_widget_GridView$adjustViewsUpOrDown() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromBottom) {
                View child = this.getChildAt(0);
                delta = child.getTop() - this.mListPadding.top;
                if (this.mFirstPosition != 0) {
                    delta -= this.mVerticalSpacing;
                }
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                View child = this.getChildAt(childCount - 1);
                delta = child.getBottom() - (this.getHeight() - this.mListPadding.bottom);
                if (this.mFirstPosition + childCount < this.mItemCount) {
                    delta += this.mVerticalSpacing;
                }
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.offsetChildrenTopAndBottom(-delta);
            }
        }
    }

    private final int $$robo$$android_widget_GridView$computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            int numColumns = this.mNumColumns;
            int rowCount = (count + numColumns - 1) / numColumns;
            int extent = rowCount * 100;
            View view = this.getChildAt(0);
            int top = view.getTop();
            int height = view.getHeight();
            if (height > 0) {
                extent += top * 100 / height;
            }
            view = this.getChildAt(count - 1);
            int bottom = view.getBottom();
            height = view.getHeight();
            if (height > 0) {
                extent -= (bottom - this.getHeight()) * 100 / height;
            }
            return extent;
        }
        return 0;
    }

    private final int $$robo$$android_widget_GridView$computeVerticalScrollOffset() {
        if (this.mFirstPosition >= 0 && this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            int top = view.getTop();
            int height = view.getHeight();
            if (height > 0) {
                int numColumns = this.mNumColumns;
                int rowCount = (this.mItemCount + numColumns - 1) / numColumns;
                int oddItemsOnFirstRow = this.isStackFromBottom() ? rowCount * numColumns - this.mItemCount : 0;
                int whichRow = (this.mFirstPosition + oddItemsOnFirstRow) / numColumns;
                return Math.max(whichRow * 100 - top * 100 / height + (int)((float)this.mScrollY / (float)this.getHeight() * (float)rowCount * 100.0f), 0);
            }
        }
        return 0;
    }

    private final int $$robo$$android_widget_GridView$computeVerticalScrollRange() {
        int numColumns = this.mNumColumns;
        int rowCount = (this.mItemCount + numColumns - 1) / numColumns;
        int result = Math.max(rowCount * 100, 0);
        if (this.mScrollY != 0) {
            result += Math.abs((int)((float)this.mScrollY / (float)this.getHeight() * (float)rowCount * 100.0f));
        }
        return result;
    }

    private final CharSequence $$robo$$android_widget_GridView$getAccessibilityClassName() {
        return GridView.class.getName();
    }

    private final void $$robo$$android_widget_GridView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        int columnsCount = this.getNumColumns();
        int rowsCount = this.getCount() / columnsCount;
        int selectionMode = this.getSelectionModeForAccessibility();
        AccessibilityNodeInfo.CollectionInfo collectionInfo = AccessibilityNodeInfo.CollectionInfo.obtain(rowsCount, columnsCount, false, selectionMode);
        info.setCollectionInfo(collectionInfo);
        if (columnsCount > 0 || rowsCount > 0) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_TO_POSITION);
        }
    }

    private final boolean $$robo$$android_widget_GridView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        switch (action) {
            case 16908343: {
                int numColumns = this.getNumColumns();
                int row = arguments.getInt("android.view.accessibility.action.ARGUMENT_ROW_INT", -1);
                int position = Math.min(row * numColumns, this.getCount() - 1);
                if (row < 0) break;
                this.smoothScrollToPosition(position);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_GridView$onInitializeAccessibilityNodeInfoForItem(View view, int position, AccessibilityNodeInfo info) {
        int row;
        int column;
        super.onInitializeAccessibilityNodeInfoForItem(view, position, info);
        int count = this.getCount();
        int columnsCount = this.getNumColumns();
        int rowsCount = count / columnsCount;
        if (!this.mStackFromBottom) {
            column = position % columnsCount;
            row = position / columnsCount;
        } else {
            int invertedIndex = count - 1 - position;
            column = columnsCount - 1 - invertedIndex % columnsCount;
            row = rowsCount - 1 - invertedIndex / columnsCount;
        }
        AbsListView.LayoutParams lp = (AbsListView.LayoutParams)view.getLayoutParams();
        boolean isHeading = lp != null && lp.viewType == -2;
        boolean isSelected = this.isItemChecked(position);
        AccessibilityNodeInfo.CollectionItemInfo itemInfo = AccessibilityNodeInfo.CollectionItemInfo.obtain(row, 1, column, 1, isHeading, isSelected);
        info.setCollectionItemInfo(itemInfo);
    }

    private final void $$robo$$android_widget_GridView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("numColumns", this.getNumColumns());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_GridView$__constructor__(context);
    }

    public GridView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_GridView$__constructor__(context, attributeSet);
    }

    public GridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010071);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_GridView$__constructor__(context, attributeSet, n);
    }

    public GridView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_GridView$__constructor__(context, attributeSet, n, n2);
    }

    public GridView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_GridView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public ListAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_GridView$getAdapter(), this);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setRemoteViewsAdapterAsync")
    public void setRemoteViewsAdapter(Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsAdapter", $$robo$$android_widget_GridView$setRemoteViewsAdapter(android.content.Intent ), this, intent);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_GridView$setAdapter(android.widget.ListAdapter ), this, listAdapter);
    }

    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("lookForSelectablePosition", $$robo$$android_widget_GridView$lookForSelectablePosition(int boolean ), this, n, bl);
    }

    @Override
    void fillGap(boolean bl) {
        InvokeDynamicSupport.bootstrap("fillGap", $$robo$$android_widget_GridView$fillGap(boolean ), this, bl);
    }

    private View fillDown(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillDown", $$robo$$android_widget_GridView$fillDown(int int ), this, n, n2);
    }

    private View makeRow(int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("makeRow", $$robo$$android_widget_GridView$makeRow(int int boolean ), this, n, n2, bl);
    }

    private View fillUp(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillUp", $$robo$$android_widget_GridView$fillUp(int int ), this, n, n2);
    }

    private View fillFromTop(int n) {
        return InvokeDynamicSupport.bootstrap("fillFromTop", $$robo$$android_widget_GridView$fillFromTop(int ), this, n);
    }

    private View fillFromBottom(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillFromBottom", $$robo$$android_widget_GridView$fillFromBottom(int int ), this, n, n2);
    }

    private View fillSelection(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillSelection", $$robo$$android_widget_GridView$fillSelection(int int ), this, n, n2);
    }

    private void pinToTop(int n) {
        InvokeDynamicSupport.bootstrap("pinToTop", $$robo$$android_widget_GridView$pinToTop(int ), this, n);
    }

    private void pinToBottom(int n) {
        InvokeDynamicSupport.bootstrap("pinToBottom", $$robo$$android_widget_GridView$pinToBottom(int ), this, n);
    }

    @Override
    int findMotionRow(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findMotionRow", $$robo$$android_widget_GridView$findMotionRow(int ), this, n);
    }

    private View fillSpecific(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillSpecific", $$robo$$android_widget_GridView$fillSpecific(int int ), this, n, n2);
    }

    private void correctTooHigh(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("correctTooHigh", $$robo$$android_widget_GridView$correctTooHigh(int int int ), this, n, n2, n3);
    }

    private void correctTooLow(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("correctTooLow", $$robo$$android_widget_GridView$correctTooLow(int int int ), this, n, n2, n3);
    }

    private View fillFromSelection(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("fillFromSelection", $$robo$$android_widget_GridView$fillFromSelection(int int int ), this, n, n2, n3);
    }

    private int getBottomSelectionPixel(int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrap("getBottomSelectionPixel", $$robo$$android_widget_GridView$getBottomSelectionPixel(int int int int ), this, n, n2, n3, n4);
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getTopSelectionPixel", $$robo$$android_widget_GridView$getTopSelectionPixel(int int int ), this, n, n2, n3);
    }

    private void adjustForBottomFadingEdge(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustForBottomFadingEdge", $$robo$$android_widget_GridView$adjustForBottomFadingEdge(android.view.View int int ), this, view, n, n2);
    }

    private void adjustForTopFadingEdge(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustForTopFadingEdge", $$robo$$android_widget_GridView$adjustForTopFadingEdge(android.view.View int int ), this, view, n, n2);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$android_widget_GridView$smoothScrollToPosition(int ), this, n);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollByOffset(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollByOffset", $$robo$$android_widget_GridView$smoothScrollByOffset(int ), this, n);
    }

    private View moveSelection(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("moveSelection", $$robo$$android_widget_GridView$moveSelection(int int int ), this, n, n2, n3);
    }

    private boolean determineColumns(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("determineColumns", $$robo$$android_widget_GridView$determineColumns(int ), this, n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_GridView$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void attachLayoutAnimationParameters(View view, ViewGroup.LayoutParams layoutParams, int n, int n2) {
        InvokeDynamicSupport.bootstrap("attachLayoutAnimationParameters", $$robo$$android_widget_GridView$attachLayoutAnimationParameters(android.view.View android.view.ViewGroup$LayoutParams int int ), this, view, layoutParams, n, n2);
    }

    @Override
    protected void layoutChildren() {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_GridView$layoutChildren(), this);
    }

    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2, int n4) {
        return InvokeDynamicSupport.bootstrap("makeAndAddView", $$robo$$android_widget_GridView$makeAndAddView(int int boolean int boolean int ), this, n, n2, bl, n3, bl2, n4);
    }

    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3, int n4) {
        InvokeDynamicSupport.bootstrap("setupChild", $$robo$$android_widget_GridView$setupChild(android.view.View int int boolean int boolean boolean int ), this, view, n, n2, bl, n3, bl2, bl3, n4);
    }

    @Override
    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_GridView$setSelection(int ), this, n);
    }

    @Override
    void setSelectionInt(int n) {
        InvokeDynamicSupport.bootstrap("setSelectionInt", $$robo$$android_widget_GridView$setSelectionInt(int ), this, n);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_GridView$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_widget_GridView$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_GridView$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    private boolean commonKey(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("commonKey", $$robo$$android_widget_GridView$commonKey(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    boolean pageScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageScroll", $$robo$$android_widget_GridView$pageScroll(int ), this, n);
    }

    boolean fullScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("fullScroll", $$robo$$android_widget_GridView$fullScroll(int ), this, n);
    }

    boolean arrowScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("arrowScroll", $$robo$$android_widget_GridView$arrowScroll(int ), this, n);
    }

    boolean sequenceScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("sequenceScroll", $$robo$$android_widget_GridView$sequenceScroll(int ), this, n);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_GridView$onFocusChanged(boolean int android.graphics.Rect ), this, bl, n, rect);
    }

    private boolean isCandidateSelection(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCandidateSelection", $$robo$$android_widget_GridView$isCandidateSelection(int int ), this, n, n2);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_GridView$setGravity(int ), this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_GridView$getGravity(), this);
    }

    public void setHorizontalSpacing(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalSpacing", $$robo$$android_widget_GridView$setHorizontalSpacing(int ), this, n);
    }

    public int getHorizontalSpacing() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalSpacing", $$robo$$android_widget_GridView$getHorizontalSpacing(), this);
    }

    public int getRequestedHorizontalSpacing() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedHorizontalSpacing", $$robo$$android_widget_GridView$getRequestedHorizontalSpacing(), this);
    }

    public void setVerticalSpacing(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalSpacing", $$robo$$android_widget_GridView$setVerticalSpacing(int ), this, n);
    }

    public int getVerticalSpacing() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalSpacing", $$robo$$android_widget_GridView$getVerticalSpacing(), this);
    }

    public void setStretchMode(int n) {
        InvokeDynamicSupport.bootstrap("setStretchMode", $$robo$$android_widget_GridView$setStretchMode(int ), this, n);
    }

    public int getStretchMode() {
        return (int)InvokeDynamicSupport.bootstrap("getStretchMode", $$robo$$android_widget_GridView$getStretchMode(), this);
    }

    public void setColumnWidth(int n) {
        InvokeDynamicSupport.bootstrap("setColumnWidth", $$robo$$android_widget_GridView$setColumnWidth(int ), this, n);
    }

    public int getColumnWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnWidth", $$robo$$android_widget_GridView$getColumnWidth(), this);
    }

    public int getRequestedColumnWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedColumnWidth", $$robo$$android_widget_GridView$getRequestedColumnWidth(), this);
    }

    public void setNumColumns(int n) {
        InvokeDynamicSupport.bootstrap("setNumColumns", $$robo$$android_widget_GridView$setNumColumns(int ), this, n);
    }

    @ViewDebug.ExportedProperty
    public int getNumColumns() {
        return (int)InvokeDynamicSupport.bootstrap("getNumColumns", $$robo$$android_widget_GridView$getNumColumns(), this);
    }

    private void adjustViewsUpOrDown() {
        InvokeDynamicSupport.bootstrap("adjustViewsUpOrDown", $$robo$$android_widget_GridView$adjustViewsUpOrDown(), this);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$android_widget_GridView$computeVerticalScrollExtent(), this);
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$android_widget_GridView$computeVerticalScrollOffset(), this);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_widget_GridView$computeVerticalScrollRange(), this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_GridView$getAccessibilityClassName(), this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_GridView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_GridView$performAccessibilityActionInternal(int android.os.Bundle ), this, n, bundle);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoForItem", $$robo$$android_widget_GridView$onInitializeAccessibilityNodeInfoForItem(android.view.View int android.view.accessibility.AccessibilityNodeInfo ), this, view, n, accessibilityNodeInfo);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_GridView$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    public /* synthetic */ GridView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GridView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StretchMode {
    }
}

