/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumberPicker
extends LinearLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int SELECTOR_WHEEL_ITEM_COUNT = 3;
    private static long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static int SELECTOR_MIDDLE_ITEM_INDEX = 1;
    private static int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 8;
    private static int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static int SNAP_SCROLL_DURATION = 300;
    private static float TOP_AND_BOTTOM_FADING_EDGE_STRENGTH = 0.9f;
    private static int UNSCALED_DEFAULT_SELECTION_DIVIDER_HEIGHT = 2;
    private static int UNSCALED_DEFAULT_SELECTION_DIVIDERS_DISTANCE = 48;
    private static int DEFAULT_LAYOUT_RESOURCE_ID = 17367206;
    private static int SIZE_UNSPECIFIED = -1;
    private boolean mWrapSelectorWheelPreferred;
    private static TwoDigitFormatter sTwoDigitFormatter;
    private ImageButton mIncrementButton;
    private ImageButton mDecrementButton;
    private EditText mInputText;
    private int mSelectionDividersDistance;
    private int mMinHeight;
    private int mMaxHeight;
    private int mMinWidth;
    private int mMaxWidth;
    private boolean mComputeMaxWidth;
    private int mTextSize;
    private int mSelectorTextGapHeight;
    private String[] mDisplayedValues;
    private int mMinValue;
    private int mMaxValue;
    private int mValue;
    private OnValueChangeListener mOnValueChangeListener;
    private OnScrollListener mOnScrollListener;
    private Formatter mFormatter;
    private long mLongPressUpdateInterval;
    private SparseArray<String> mSelectorIndexToStringCache;
    private int[] mSelectorIndices;
    private Paint mSelectorWheelPaint;
    private Drawable mVirtualButtonPressedDrawable;
    private int mSelectorElementHeight;
    private int mInitialScrollOffset;
    private int mCurrentScrollOffset;
    private Scroller mFlingScroller;
    private Scroller mAdjustScroller;
    private int mPreviousScrollerY;
    private SetSelectionCommand mSetSelectionCommand;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private BeginSoftInputOnLongPressCommand mBeginSoftInputOnLongPressCommand;
    private float mLastDownEventY;
    private long mLastDownEventTime;
    private float mLastDownOrMoveEventY;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private boolean mWrapSelectorWheel;
    private int mSolidColor;
    private boolean mHasSelectorWheel;
    private Drawable mSelectionDivider;
    private int mSelectionDividerHeight;
    private int mScrollState;
    private boolean mIgnoreMoveEvents;
    private boolean mPerformClickOnTap;
    private int mTopSelectionDividerTop;
    private int mBottomSelectionDividerBottom;
    private int mLastHoveredChildVirtualViewId;
    private boolean mIncrementVirtualButtonPressed;
    private boolean mDecrementVirtualButtonPressed;
    private AccessibilityNodeProviderImpl mAccessibilityNodeProvider;
    private PressedStateHelper mPressedStateHelper;
    private int mLastHandledDownDpadKeyCode;
    private boolean mHideWheelUntilFocused;
    private static char[] DIGIT_CHARACTERS;

    private static final Formatter $$robo$$android_widget_NumberPicker$getTwoDigitFormatter() {
        return sTwoDigitFormatter;
    }

    private void $$robo$$android_widget_NumberPicker$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_NumberPicker$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_NumberPicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_NumberPicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mWrapSelectorWheelPreferred = true;
        this.mLongPressUpdateInterval = 300L;
        this.mSelectorIndexToStringCache = new SparseArray();
        this.mSelectorIndices = new int[3];
        this.mInitialScrollOffset = Integer.MIN_VALUE;
        this.mScrollState = 0;
        this.mLastHandledDownDpadKeyCode = -1;
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyleAttr, defStyleRes);
        int layoutResId = attributesArray.getResourceId(2, 17367206);
        this.mHasSelectorWheel = layoutResId != 17367206;
        this.mHideWheelUntilFocused = attributesArray.getBoolean(1, false);
        this.mSolidColor = attributesArray.getColor(0, 0);
        Drawable selectionDivider = attributesArray.getDrawable(7);
        if (selectionDivider != null) {
            selectionDivider.setCallback(this);
            selectionDivider.setLayoutDirection(this.getLayoutDirection());
            if (selectionDivider.isStateful()) {
                selectionDivider.setState(this.getDrawableState());
            }
        }
        this.mSelectionDivider = selectionDivider;
        int defSelectionDividerHeight = (int)TypedValue.applyDimension(1, 2.0f, this.getResources().getDisplayMetrics());
        this.mSelectionDividerHeight = attributesArray.getDimensionPixelSize(8, defSelectionDividerHeight);
        int defSelectionDividerDistance = (int)TypedValue.applyDimension(1, 48.0f, this.getResources().getDisplayMetrics());
        this.mSelectionDividersDistance = attributesArray.getDimensionPixelSize(9, defSelectionDividerDistance);
        this.mMinHeight = attributesArray.getDimensionPixelSize(5, -1);
        this.mMaxHeight = attributesArray.getDimensionPixelSize(3, -1);
        if (this.mMinHeight != -1 && this.mMaxHeight != -1 && this.mMinHeight > this.mMaxHeight) {
            throw new IllegalArgumentException("minHeight > maxHeight");
        }
        this.mMinWidth = attributesArray.getDimensionPixelSize(6, -1);
        this.mMaxWidth = attributesArray.getDimensionPixelSize(4, -1);
        if (this.mMinWidth != -1 && this.mMaxWidth != -1 && this.mMinWidth > this.mMaxWidth) {
            throw new IllegalArgumentException("minWidth > maxWidth");
        }
        this.mComputeMaxWidth = this.mMaxWidth == -1;
        this.mVirtualButtonPressedDrawable = attributesArray.getDrawable(10);
        attributesArray.recycle();
        this.mPressedStateHelper = new PressedStateHelper(this);
        this.setWillNotDraw(!this.mHasSelectorWheel);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(layoutResId, (ViewGroup)this, true);
        View.OnClickListener onClickListener = new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NumberPicker this$0;

            private void $$robo$$android_widget_NumberPicker_1$__constructor__(NumberPicker this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_NumberPicker_1$onClick(View v) {
                this.this$0.hideSoftInput();
                this.this$0.mInputText.clearFocus();
                if (v.getId() == 16908974) {
                    this.this$0.changeValueByOne(true);
                } else {
                    this.this$0.changeValueByOne(false);
                }
            }

            private void __constructor__(NumberPicker numberPicker) {
                this.$$robo$$android_widget_NumberPicker_1$__constructor__(numberPicker);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_1$__constructor__(android.widget.NumberPicker ), this, numberPicker);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_NumberPicker_1$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NumberPicker this$0;

            private void $$robo$$android_widget_NumberPicker_2$__constructor__(NumberPicker this$0) {
                this.this$0 = this$0;
            }

            private final boolean $$robo$$android_widget_NumberPicker_2$onLongClick(View v) {
                this.this$0.hideSoftInput();
                this.this$0.mInputText.clearFocus();
                if (v.getId() == 16908974) {
                    this.this$0.postChangeCurrentByOneFromLongPress(true, 0L);
                } else {
                    this.this$0.postChangeCurrentByOneFromLongPress(false, 0L);
                }
                return true;
            }

            private void __constructor__(NumberPicker numberPicker) {
                this.$$robo$$android_widget_NumberPicker_2$__constructor__(numberPicker);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_2$__constructor__(android.widget.NumberPicker ), this, numberPicker);
            }

            @Override
            public boolean onLongClick(View view) {
                return (boolean)InvokeDynamicSupport.bootstrap("onLongClick", $$robo$$android_widget_NumberPicker_2$onLongClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton = (ImageButton)this.findViewById(16908974);
            this.mIncrementButton.setOnClickListener(onClickListener);
            this.mIncrementButton.setOnLongClickListener(onLongClickListener);
        } else {
            this.mIncrementButton = null;
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton = (ImageButton)this.findViewById(16908836);
            this.mDecrementButton.setOnClickListener(onClickListener);
            this.mDecrementButton.setOnLongClickListener(onLongClickListener);
        } else {
            this.mDecrementButton = null;
        }
        this.mInputText = (EditText)this.findViewById(16909131);
        this.mInputText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NumberPicker this$0;

            private void $$robo$$android_widget_NumberPicker_3$__constructor__(NumberPicker this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_NumberPicker_3$onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    this.this$0.mInputText.selectAll();
                } else {
                    this.this$0.mInputText.setSelection(0, 0);
                    this.this$0.validateInputTextView(v);
                }
            }

            private void __constructor__(NumberPicker numberPicker) {
                this.$$robo$$android_widget_NumberPicker_3$__constructor__(numberPicker);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_3$__constructor__(android.widget.NumberPicker ), this, numberPicker);
            }

            @Override
            public void onFocusChange(View view, boolean bl) {
                InvokeDynamicSupport.bootstrap("onFocusChange", $$robo$$android_widget_NumberPicker_3$onFocusChange(android.view.View boolean ), this, view, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mInputText.setFilters(new InputFilter[]{new InputTextFilter(this)});
        this.mInputText.setAccessibilityLiveRegion(1);
        this.mInputText.setRawInputType(2);
        this.mInputText.setImeOptions(6);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 8;
        this.mTextSize = (int)this.mInputText.getTextSize();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(this.mTextSize);
        paint.setTypeface(this.mInputText.getTypeface());
        ColorStateList colors = this.mInputText.getTextColors();
        int color2 = colors.getColorForState(ENABLED_STATE_SET, -1);
        paint.setColor(color2);
        this.mSelectorWheelPaint = paint;
        this.mFlingScroller = new Scroller(this.getContext(), null, true);
        this.mAdjustScroller = new Scroller(this.getContext(), new DecelerateInterpolator(2.5f));
        this.updateInputTextView();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        if (this.getFocusable() == 16) {
            this.setFocusable(1);
            this.setFocusableInTouchMode(true);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!this.mHasSelectorWheel) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        int msrdWdth = this.getMeasuredWidth();
        int msrdHght = this.getMeasuredHeight();
        int inptTxtMsrdWdth = this.mInputText.getMeasuredWidth();
        int inptTxtMsrdHght = this.mInputText.getMeasuredHeight();
        int inptTxtLeft = (msrdWdth - inptTxtMsrdWdth) / 2;
        int inptTxtTop = (msrdHght - inptTxtMsrdHght) / 2;
        int inptTxtRight = inptTxtLeft + inptTxtMsrdWdth;
        int inptTxtBottom = inptTxtTop + inptTxtMsrdHght;
        this.mInputText.layout(inptTxtLeft, inptTxtTop, inptTxtRight, inptTxtBottom);
        if (changed) {
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
            this.mTopSelectionDividerTop = (this.getHeight() - this.mSelectionDividersDistance) / 2 - this.mSelectionDividerHeight;
            this.mBottomSelectionDividerBottom = this.mTopSelectionDividerTop + 2 * this.mSelectionDividerHeight + this.mSelectionDividersDistance;
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mHasSelectorWheel) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int newWidthMeasureSpec = this.makeMeasureSpec(widthMeasureSpec, this.mMaxWidth);
        int newHeightMeasureSpec = this.makeMeasureSpec(heightMeasureSpec, this.mMaxHeight);
        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec);
        int widthSize = this.resolveSizeAndStateRespectingMinSize(this.mMinWidth, this.getMeasuredWidth(), widthMeasureSpec);
        int heightSize = this.resolveSizeAndStateRespectingMinSize(this.mMinHeight, this.getMeasuredHeight(), heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private final boolean $$robo$$android_widget_NumberPicker$moveToFinalScrollerPosition(Scroller scroller) {
        scroller.forceFinished(true);
        int amountToScroll = scroller.getFinalY() - scroller.getCurrY();
        int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementHeight;
        int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
        if (overshootAdjustment != 0) {
            if (Math.abs(overshootAdjustment) > this.mSelectorElementHeight / 2) {
                overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementHeight) : (overshootAdjustment += this.mSelectorElementHeight);
            }
            this.scrollBy(0, amountToScroll += overshootAdjustment);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_NumberPicker$onInterceptTouchEvent(MotionEvent event) {
        if (!this.mHasSelectorWheel || !this.isEnabled()) {
            return false;
        }
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                this.removeAllCallbacks();
                this.hideSoftInput();
                this.mLastDownOrMoveEventY = this.mLastDownEventY = event.getY();
                this.mLastDownEventTime = event.getEventTime();
                this.mIgnoreMoveEvents = false;
                this.mPerformClickOnTap = false;
                if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
                    if (this.mScrollState == 0) {
                        this.mPressedStateHelper.buttonPressDelayed(2);
                    }
                } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom && this.mScrollState == 0) {
                    this.mPressedStateHelper.buttonPressDelayed(1);
                }
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (!this.mFlingScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                    this.onScrollStateChange(0);
                } else if (!this.mAdjustScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                } else if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
                    this.postChangeCurrentByOneFromLongPress(false, ViewConfiguration.getLongPressTimeout());
                } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom) {
                    this.postChangeCurrentByOneFromLongPress(true, ViewConfiguration.getLongPressTimeout());
                } else {
                    this.mPerformClickOnTap = true;
                    this.postBeginSoftInputOnLongPressCommand();
                }
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_NumberPicker$onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.mHasSelectorWheel) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action = event.getActionMasked();
        switch (action) {
            case 2: {
                if (this.mIgnoreMoveEvents) break;
                float currentMoveY = event.getY();
                if (this.mScrollState != 1) {
                    int deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY);
                    if (deltaDownY > this.mTouchSlop) {
                        this.removeAllCallbacks();
                        this.onScrollStateChange(1);
                    }
                } else {
                    int deltaMoveY = (int)(currentMoveY - this.mLastDownOrMoveEventY);
                    this.scrollBy(0, deltaMoveY);
                    this.invalidate();
                }
                this.mLastDownOrMoveEventY = currentMoveY;
                break;
            }
            case 1: {
                this.removeBeginSoftInputCommand();
                this.removeChangeCurrentByOneFromLongPress();
                this.mPressedStateHelper.cancel();
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                    this.fling(initialVelocity);
                    this.onScrollStateChange(2);
                } else {
                    int eventY = (int)event.getY();
                    int deltaMoveY = (int)Math.abs((float)eventY - this.mLastDownEventY);
                    long deltaTime = event.getEventTime() - this.mLastDownEventTime;
                    if (deltaMoveY <= this.mTouchSlop && deltaTime < (long)ViewConfiguration.getTapTimeout()) {
                        if (this.mPerformClickOnTap) {
                            this.mPerformClickOnTap = false;
                            this.performClick();
                        } else {
                            int selectorIndexOffset = eventY / this.mSelectorElementHeight - 1;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                                this.mPressedStateHelper.buttonTapped(1);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                                this.mPressedStateHelper.buttonTapped(2);
                            }
                        }
                    } else {
                        this.ensureScrollWheelAdjusted();
                    }
                    this.onScrollStateChange(0);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_widget_NumberPicker$dispatchTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTouchEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean $$robo$$android_widget_NumberPicker$dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 23: 
            case 66: {
                this.removeAllCallbacks();
                return super.dispatchKeyEvent(event);
            }
            case 19: 
            case 20: {
                if (!this.mHasSelectorWheel) return super.dispatchKeyEvent(event);
                switch (event.getAction()) {
                    case 0: {
                        if (!this.mWrapSelectorWheel && !(keyCode == 20 ? this.getValue() < this.getMaxValue() : this.getValue() > this.getMinValue())) return super.dispatchKeyEvent(event);
                        this.requestFocus();
                        this.mLastHandledDownDpadKeyCode = keyCode;
                        this.removeAllCallbacks();
                        if (!this.mFlingScroller.isFinished()) return true;
                        this.changeValueByOne(keyCode == 20);
                        return true;
                    }
                    case 1: {
                        if (this.mLastHandledDownDpadKeyCode != keyCode) return super.dispatchKeyEvent(event);
                        this.mLastHandledDownDpadKeyCode = -1;
                        return true;
                    }
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private final boolean $$robo$$android_widget_NumberPicker$dispatchTrackballEvent(MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTrackballEvent(event);
    }

    private final boolean $$robo$$android_widget_NumberPicker$dispatchHoverEvent(MotionEvent event) {
        if (!this.mHasSelectorWheel) {
            return super.dispatchHoverEvent(event);
        }
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            int eventY = (int)event.getY();
            int hoveredVirtualViewId = eventY < this.mTopSelectionDividerTop ? 3 : (eventY > this.mBottomSelectionDividerBottom ? 1 : 2);
            int action = event.getActionMasked();
            AccessibilityNodeProviderImpl provider = (AccessibilityNodeProviderImpl)this.getAccessibilityNodeProvider();
            switch (action) {
                case 9: {
                    provider.sendAccessibilityEventForVirtualView(hoveredVirtualViewId, 128);
                    this.mLastHoveredChildVirtualViewId = hoveredVirtualViewId;
                    provider.performAction(hoveredVirtualViewId, 64, null);
                    break;
                }
                case 7: {
                    if (this.mLastHoveredChildVirtualViewId == hoveredVirtualViewId || this.mLastHoveredChildVirtualViewId == -1) break;
                    provider.sendAccessibilityEventForVirtualView(this.mLastHoveredChildVirtualViewId, 256);
                    provider.sendAccessibilityEventForVirtualView(hoveredVirtualViewId, 128);
                    this.mLastHoveredChildVirtualViewId = hoveredVirtualViewId;
                    provider.performAction(hoveredVirtualViewId, 64, null);
                    break;
                }
                case 10: {
                    provider.sendAccessibilityEventForVirtualView(hoveredVirtualViewId, 256);
                    this.mLastHoveredChildVirtualViewId = -1;
                }
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_NumberPicker$computeScroll() {
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        int currentScrollerY = scroller.getCurrY();
        if (this.mPreviousScrollerY == 0) {
            this.mPreviousScrollerY = scroller.getStartY();
        }
        this.scrollBy(0, currentScrollerY - this.mPreviousScrollerY);
        this.mPreviousScrollerY = currentScrollerY;
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
        } else {
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_NumberPicker$setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton.setEnabled(enabled);
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton.setEnabled(enabled);
        }
        this.mInputText.setEnabled(enabled);
    }

    private final void $$robo$$android_widget_NumberPicker$scrollBy(int x, int y) {
        int[] selectorIndices = this.mSelectorIndices;
        int startScrollOffset = this.mCurrentScrollOffset;
        if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[1] <= this.mMinValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[1] >= this.mMaxValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        this.mCurrentScrollOffset += y;
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset > this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset -= this.mSelectorElementHeight;
            this.decrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[1], true);
            if (this.mWrapSelectorWheel || selectorIndices[1] > this.mMinValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset += this.mSelectorElementHeight;
            this.incrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[1], true);
            if (this.mWrapSelectorWheel || selectorIndices[1] < this.mMaxValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        if (startScrollOffset != this.mCurrentScrollOffset) {
            this.onScrollChanged(0, this.mCurrentScrollOffset, 0, startScrollOffset);
        }
    }

    private final int $$robo$$android_widget_NumberPicker$computeVerticalScrollOffset() {
        return this.mCurrentScrollOffset;
    }

    private final int $$robo$$android_widget_NumberPicker$computeVerticalScrollRange() {
        return (this.mMaxValue - this.mMinValue + 1) * this.mSelectorElementHeight;
    }

    private final int $$robo$$android_widget_NumberPicker$computeVerticalScrollExtent() {
        return this.getHeight();
    }

    private final int $$robo$$android_widget_NumberPicker$getSolidColor() {
        return this.mSolidColor;
    }

    private final void $$robo$$android_widget_NumberPicker$setOnValueChangedListener(OnValueChangeListener onValueChangedListener) {
        this.mOnValueChangeListener = onValueChangedListener;
    }

    private final void $$robo$$android_widget_NumberPicker$setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    private final void $$robo$$android_widget_NumberPicker$setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    private final void $$robo$$android_widget_NumberPicker$setValue(int value) {
        this.setValueInternal(value, false);
    }

    private final boolean $$robo$$android_widget_NumberPicker$performClick() {
        if (!this.mHasSelectorWheel) {
            return super.performClick();
        }
        if (!super.performClick()) {
            this.showSoftInput();
        }
        return true;
    }

    private final boolean $$robo$$android_widget_NumberPicker$performLongClick() {
        if (!this.mHasSelectorWheel) {
            return super.performLongClick();
        }
        if (!super.performLongClick()) {
            this.showSoftInput();
            this.mIgnoreMoveEvents = true;
        }
        return true;
    }

    private final void $$robo$$android_widget_NumberPicker$showSoftInput() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (this.mHasSelectorWheel) {
                this.mInputText.setVisibility(0);
            }
            this.mInputText.requestFocus();
            inputMethodManager.showSoftInput(this.mInputText, 0);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$hideSoftInput() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null && inputMethodManager.isActive(this.mInputText)) {
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        if (this.mHasSelectorWheel) {
            this.mInputText.setVisibility(4);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$tryComputeMaxWidth() {
        if (!this.mComputeMaxWidth) {
            return;
        }
        int maxTextWidth = 0;
        if (this.mDisplayedValues == null) {
            float maxDigitWidth = 0.0f;
            for (int i = 0; i <= 9; ++i) {
                float digitWidth = this.mSelectorWheelPaint.measureText(NumberPicker.formatNumberWithLocale(i));
                if (!(digitWidth > maxDigitWidth)) continue;
                maxDigitWidth = digitWidth;
            }
            int numberOfDigits = 0;
            for (int current = this.mMaxValue; current > 0; current /= 10) {
                ++numberOfDigits;
            }
            maxTextWidth = (int)((float)numberOfDigits * maxDigitWidth);
        } else {
            int valueCount = this.mDisplayedValues.length;
            for (int i = 0; i < valueCount; ++i) {
                float textWidth = this.mSelectorWheelPaint.measureText(this.mDisplayedValues[i]);
                if (!(textWidth > (float)maxTextWidth)) continue;
                maxTextWidth = (int)textWidth;
            }
        }
        if (this.mMaxWidth != (maxTextWidth += this.mInputText.getPaddingLeft() + this.mInputText.getPaddingRight())) {
            this.mMaxWidth = maxTextWidth > this.mMinWidth ? maxTextWidth : this.mMinWidth;
            this.invalidate();
        }
    }

    private final boolean $$robo$$android_widget_NumberPicker$getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    private final void $$robo$$android_widget_NumberPicker$setWrapSelectorWheel(boolean wrapSelectorWheel) {
        this.mWrapSelectorWheelPreferred = wrapSelectorWheel;
        this.updateWrapSelectorWheel();
    }

    private final void $$robo$$android_widget_NumberPicker$updateWrapSelectorWheel() {
        boolean wrappingAllowed = this.mMaxValue - this.mMinValue >= this.mSelectorIndices.length;
        this.mWrapSelectorWheel = wrappingAllowed && this.mWrapSelectorWheelPreferred;
    }

    private final void $$robo$$android_widget_NumberPicker$setOnLongPressUpdateInterval(long intervalMillis) {
        this.mLongPressUpdateInterval = intervalMillis;
    }

    private final int $$robo$$android_widget_NumberPicker$getValue() {
        return this.mValue;
    }

    private final int $$robo$$android_widget_NumberPicker$getMinValue() {
        return this.mMinValue;
    }

    private final void $$robo$$android_widget_NumberPicker$setMinValue(int minValue) {
        if (this.mMinValue == minValue) {
            return;
        }
        if (minValue < 0) {
            throw new IllegalArgumentException("minValue must be >= 0");
        }
        this.mMinValue = minValue;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        this.updateWrapSelectorWheel();
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    private final int $$robo$$android_widget_NumberPicker$getMaxValue() {
        return this.mMaxValue;
    }

    private final void $$robo$$android_widget_NumberPicker$setMaxValue(int maxValue) {
        if (this.mMaxValue == maxValue) {
            return;
        }
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = maxValue;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        this.updateWrapSelectorWheel();
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    private final String[] $$robo$$android_widget_NumberPicker$getDisplayedValues() {
        return this.mDisplayedValues;
    }

    private final void $$robo$$android_widget_NumberPicker$setDisplayedValues(String[] displayedValues) {
        if (this.mDisplayedValues == displayedValues) {
            return;
        }
        this.mDisplayedValues = displayedValues;
        if (this.mDisplayedValues != null) {
            this.mInputText.setRawInputType(524289);
        } else {
            this.mInputText.setRawInputType(2);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
        this.tryComputeMaxWidth();
    }

    private final CharSequence $$robo$$android_widget_NumberPicker$getDisplayedValueForCurrentSelection() {
        return this.mSelectorIndexToStringCache.get(this.getValue());
    }

    private final float $$robo$$android_widget_NumberPicker$getTopFadingEdgeStrength() {
        return 0.9f;
    }

    private final float $$robo$$android_widget_NumberPicker$getBottomFadingEdgeStrength() {
        return 0.9f;
    }

    private final void $$robo$$android_widget_NumberPicker$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllCallbacks();
    }

    private final void $$robo$$android_widget_NumberPicker$drawableStateChanged() {
        super.drawableStateChanged();
        Drawable selectionDivider = this.mSelectionDivider;
        if (selectionDivider != null && selectionDivider.isStateful() && selectionDivider.setState(this.getDrawableState())) {
            this.invalidateDrawable(selectionDivider);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelectionDivider != null) {
            this.mSelectionDivider.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mSelectionDivider != null) {
            this.mSelectionDivider.setLayoutDirection(layoutDirection);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onDraw(Canvas canvas) {
        if (!this.mHasSelectorWheel) {
            super.onDraw(canvas);
            return;
        }
        boolean showSelectorWheel = this.mHideWheelUntilFocused ? this.hasFocus() : true;
        float x = (this.mRight - this.mLeft) / 2;
        float y = this.mCurrentScrollOffset;
        if (showSelectorWheel && this.mVirtualButtonPressedDrawable != null && this.mScrollState == 0) {
            if (this.mDecrementVirtualButtonPressed) {
                this.mVirtualButtonPressedDrawable.setState(PRESSED_STATE_SET);
                this.mVirtualButtonPressedDrawable.setBounds(0, 0, this.mRight, this.mTopSelectionDividerTop);
                this.mVirtualButtonPressedDrawable.draw(canvas);
            }
            if (this.mIncrementVirtualButtonPressed) {
                this.mVirtualButtonPressedDrawable.setState(PRESSED_STATE_SET);
                this.mVirtualButtonPressedDrawable.setBounds(0, this.mBottomSelectionDividerBottom, this.mRight, this.mBottom);
                this.mVirtualButtonPressedDrawable.draw(canvas);
            }
        }
        int[] selectorIndices = this.mSelectorIndices;
        for (int i = 0; i < selectorIndices.length; ++i) {
            int selectorIndex = selectorIndices[i];
            String scrollSelectorValue = this.mSelectorIndexToStringCache.get(selectorIndex);
            if (showSelectorWheel && i != 1 || i == 1 && this.mInputText.getVisibility() != 0) {
                canvas.drawText(scrollSelectorValue, x, y, this.mSelectorWheelPaint);
            }
            y += (float)this.mSelectorElementHeight;
        }
        if (showSelectorWheel && this.mSelectionDivider != null) {
            int topOfTopDivider = this.mTopSelectionDividerTop;
            int bottomOfTopDivider = topOfTopDivider + this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, topOfTopDivider, this.mRight, bottomOfTopDivider);
            this.mSelectionDivider.draw(canvas);
            int bottomOfBottomDivider = this.mBottomSelectionDividerBottom;
            int topOfBottomDivider = bottomOfBottomDivider - this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, topOfBottomDivider, this.mRight, bottomOfBottomDivider);
            this.mSelectionDivider.draw(canvas);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setClassName(NumberPicker.class.getName());
        event.setScrollable(true);
        event.setScrollY((this.mMinValue + this.mValue) * this.mSelectorElementHeight);
        event.setMaxScrollY((this.mMaxValue - this.mMinValue) * this.mSelectorElementHeight);
    }

    private final AccessibilityNodeProvider $$robo$$android_widget_NumberPicker$getAccessibilityNodeProvider() {
        if (!this.mHasSelectorWheel) {
            return super.getAccessibilityNodeProvider();
        }
        if (this.mAccessibilityNodeProvider == null) {
            this.mAccessibilityNodeProvider = new AccessibilityNodeProviderImpl(this);
        }
        return this.mAccessibilityNodeProvider;
    }

    private final int $$robo$$android_widget_NumberPicker$makeMeasureSpec(int measureSpec, int maxSize) {
        if (maxSize == -1) {
            return measureSpec;
        }
        int size = View.MeasureSpec.getSize(measureSpec);
        int mode = View.MeasureSpec.getMode(measureSpec);
        switch (mode) {
            case 0x40000000: {
                return measureSpec;
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec(Math.min(size, maxSize), 0x40000000);
            }
            case 0: {
                return View.MeasureSpec.makeMeasureSpec(maxSize, 0x40000000);
            }
        }
        throw new IllegalArgumentException("Unknown measure mode: " + mode);
    }

    private final int $$robo$$android_widget_NumberPicker$resolveSizeAndStateRespectingMinSize(int minSize, int measuredSize, int measureSpec) {
        if (minSize != -1) {
            int desiredWidth = Math.max(minSize, measuredSize);
            return NumberPicker.resolveSizeAndState(desiredWidth, measureSpec, 0);
        }
        return measuredSize;
    }

    private final void $$robo$$android_widget_NumberPicker$initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] selectorIndices = this.mSelectorIndices;
        int current = this.getValue();
        for (int i = 0; i < this.mSelectorIndices.length; ++i) {
            int selectorIndex = current + (i - 1);
            if (this.mWrapSelectorWheel) {
                selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
            }
            selectorIndices[i] = selectorIndex;
            this.ensureCachedScrollSelectorValue(selectorIndices[i]);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$setValueInternal(int current, boolean notifyChange) {
        if (this.mValue == current) {
            return;
        }
        if (this.mWrapSelectorWheel) {
            current = this.getWrappedSelectorIndex(current);
        } else {
            current = Math.max(current, this.mMinValue);
            current = Math.min(current, this.mMaxValue);
        }
        int previous = this.mValue;
        this.mValue = current;
        if (this.mScrollState != 2) {
            this.updateInputTextView();
        }
        if (notifyChange) {
            this.notifyChange(previous, current);
        }
        this.initializeSelectorWheelIndices();
        this.invalidate();
    }

    private final void $$robo$$android_widget_NumberPicker$changeValueByOne(boolean increment) {
        if (this.mHasSelectorWheel) {
            this.hideSoftInput();
            if (!this.moveToFinalScrollerPosition(this.mFlingScroller)) {
                this.moveToFinalScrollerPosition(this.mAdjustScroller);
            }
            this.mPreviousScrollerY = 0;
            if (increment) {
                this.mFlingScroller.startScroll(0, 0, 0, -this.mSelectorElementHeight, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, 0, this.mSelectorElementHeight, 300);
            }
            this.invalidate();
        } else if (increment) {
            this.setValueInternal(this.mValue + 1, true);
        } else {
            this.setValueInternal(this.mValue - 1, true);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$initializeSelectorWheel() {
        this.initializeSelectorWheelIndices();
        int[] selectorIndices = this.mSelectorIndices;
        int totalTextHeight = selectorIndices.length * this.mTextSize;
        float totalTextGapHeight = this.mBottom - this.mTop - totalTextHeight;
        float textGapCount = selectorIndices.length;
        this.mSelectorTextGapHeight = (int)(totalTextGapHeight / textGapCount + 0.5f);
        this.mSelectorElementHeight = this.mTextSize + this.mSelectorTextGapHeight;
        int editTextTextPosition = this.mInputText.getBaseline() + this.mInputText.getTop();
        this.mCurrentScrollOffset = this.mInitialScrollOffset = editTextTextPosition - this.mSelectorElementHeight * 1;
        this.updateInputTextView();
    }

    private final void $$robo$$android_widget_NumberPicker$initializeFadingEdges() {
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength((this.mBottom - this.mTop - this.mTextSize) / 2);
    }

    private final void $$robo$$android_widget_NumberPicker$onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            this.ensureScrollWheelAdjusted();
            this.updateInputTextView();
            this.onScrollStateChange(0);
        } else if (this.mScrollState != 1) {
            this.updateInputTextView();
        }
    }

    private final void $$robo$$android_widget_NumberPicker$onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$fling(int velocityY) {
        this.mPreviousScrollerY = 0;
        if (velocityY > 0) {
            this.mFlingScroller.fling(0, 0, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
        } else {
            this.mFlingScroller.fling(0, Integer.MAX_VALUE, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
        }
        this.invalidate();
    }

    private final int $$robo$$android_widget_NumberPicker$getWrappedSelectorIndex(int selectorIndex) {
        if (selectorIndex > this.mMaxValue) {
            return this.mMinValue + (selectorIndex - this.mMaxValue) % (this.mMaxValue - this.mMinValue) - 1;
        }
        if (selectorIndex < this.mMinValue) {
            return this.mMaxValue - (this.mMinValue - selectorIndex) % (this.mMaxValue - this.mMinValue) + 1;
        }
        return selectorIndex;
    }

    private final void $$robo$$android_widget_NumberPicker$incrementSelectorIndices(int[] selectorIndices) {
        for (int i = 0; i < selectorIndices.length - 1; ++i) {
            selectorIndices[i] = selectorIndices[i + 1];
        }
        int nextScrollSelectorIndex = selectorIndices[selectorIndices.length - 2] + 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex > this.mMaxValue) {
            nextScrollSelectorIndex = this.mMinValue;
        }
        selectorIndices[selectorIndices.length - 1] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private final void $$robo$$android_widget_NumberPicker$decrementSelectorIndices(int[] selectorIndices) {
        for (int i = selectorIndices.length - 1; i > 0; --i) {
            selectorIndices[i] = selectorIndices[i - 1];
        }
        int nextScrollSelectorIndex = selectorIndices[1] - 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex < this.mMinValue) {
            nextScrollSelectorIndex = this.mMaxValue;
        }
        selectorIndices[0] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private final void $$robo$$android_widget_NumberPicker$ensureCachedScrollSelectorValue(int selectorIndex) {
        SparseArray<String> cache = this.mSelectorIndexToStringCache;
        String scrollSelectorValue = cache.get(selectorIndex);
        if (scrollSelectorValue != null) {
            return;
        }
        if (selectorIndex < this.mMinValue || selectorIndex > this.mMaxValue) {
            scrollSelectorValue = "";
        } else if (this.mDisplayedValues != null) {
            int displayedValueIndex = selectorIndex - this.mMinValue;
            scrollSelectorValue = this.mDisplayedValues[displayedValueIndex];
        } else {
            scrollSelectorValue = this.formatNumber(selectorIndex);
        }
        cache.put(selectorIndex, scrollSelectorValue);
    }

    private final String $$robo$$android_widget_NumberPicker$formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.format(value) : NumberPicker.formatNumberWithLocale(value);
    }

    private final void $$robo$$android_widget_NumberPicker$validateInputTextView(View v) {
        String str = String.valueOf(((TextView)v).getText());
        if (TextUtils.isEmpty(str)) {
            this.updateInputTextView();
        } else {
            int current = this.getSelectedPos(str.toString());
            this.setValueInternal(current, true);
        }
    }

    private final boolean $$robo$$android_widget_NumberPicker$updateInputTextView() {
        CharSequence beforeText;
        String text;
        String string2 = text = this.mDisplayedValues == null ? this.formatNumber(this.mValue) : this.mDisplayedValues[this.mValue - this.mMinValue];
        if (!TextUtils.isEmpty(text) && !text.equals((beforeText = this.mInputText.getText()).toString())) {
            this.mInputText.setText(text);
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                AccessibilityEvent event = AccessibilityEvent.obtain(16);
                this.mInputText.onInitializeAccessibilityEvent(event);
                this.mInputText.onPopulateAccessibilityEvent(event);
                event.setFromIndex(0);
                event.setRemovedCount(beforeText.length());
                event.setAddedCount(text.length());
                event.setBeforeText(beforeText);
                event.setSource(this, 2);
                this.requestSendAccessibilityEvent(this, event);
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_NumberPicker$notifyChange(int previous, int current) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, previous, this.mValue);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$postChangeCurrentByOneFromLongPress(boolean increment, long delayMillis) {
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand(this);
        } else {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        this.mChangeCurrentByOneFromLongPressCommand.setStep(increment);
        this.postDelayed(this.mChangeCurrentByOneFromLongPressCommand, delayMillis);
    }

    private final void $$robo$$android_widget_NumberPicker$removeChangeCurrentByOneFromLongPress() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$postBeginSoftInputOnLongPressCommand() {
        if (this.mBeginSoftInputOnLongPressCommand == null) {
            this.mBeginSoftInputOnLongPressCommand = new BeginSoftInputOnLongPressCommand(this);
        } else {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.postDelayed(this.mBeginSoftInputOnLongPressCommand, ViewConfiguration.getLongPressTimeout());
    }

    private final void $$robo$$android_widget_NumberPicker$removeBeginSoftInputCommand() {
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
    }

    private final void $$robo$$android_widget_NumberPicker$removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.mSetSelectionCommand.cancel();
        }
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.mPressedStateHelper.cancel();
    }

    private final int $$robo$$android_widget_NumberPicker$getSelectedPos(String value) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                value = value.toLowerCase();
                if (!this.mDisplayedValues[i].toLowerCase().startsWith(value)) continue;
                return this.mMinValue + i;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mMinValue;
    }

    private final void $$robo$$android_widget_NumberPicker$postSetSelectionCommand(int selectionStart, int selectionEnd) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand(this.mInputText);
        }
        this.mSetSelectionCommand.post(selectionStart, selectionEnd);
    }

    private final boolean $$robo$$android_widget_NumberPicker$ensureScrollWheelAdjusted() {
        int deltaY = this.mInitialScrollOffset - this.mCurrentScrollOffset;
        if (deltaY != 0) {
            this.mPreviousScrollerY = 0;
            if (Math.abs(deltaY) > this.mSelectorElementHeight / 2) {
                deltaY += deltaY > 0 ? -this.mSelectorElementHeight : this.mSelectorElementHeight;
            }
            this.mAdjustScroller.startScroll(0, 0, 0, deltaY, 800);
            this.invalidate();
            return true;
        }
        return false;
    }

    private static final String $$robo$$android_widget_NumberPicker$formatNumberWithLocale(int value) {
        return String.format(Locale.getDefault(), "%d", value);
    }

    static void __staticInitializer__() {
        sTwoDigitFormatter = new TwoDigitFormatter();
        DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\u09e6', '\u09e7', '\u09e8', '\u09e9', '\u09ea', '\u09eb', '\u09ec', '\u09ed', '\u09ee', '\u09ef', '\u0ce6', '\u0ce7', '\u0ce8', '\u0ce9', '\u0cea', '\u0ceb', '\u0cec', '\u0ced', '\u0cee', '\u0cef'};
    }

    public static Formatter getTwoDigitFormatter() {
        return InvokeDynamicSupport.bootstrapStatic("getTwoDigitFormatter", $$robo$$android_widget_NumberPicker$getTwoDigitFormatter());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_NumberPicker$__constructor__(context);
    }

    public NumberPicker(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_NumberPicker$__constructor__(context, attributeSet);
    }

    public NumberPicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16844068);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_NumberPicker$__constructor__(context, attributeSet, n);
    }

    public NumberPicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_NumberPicker$__constructor__(context, attributeSet, n, n2);
    }

    public NumberPicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_NumberPicker$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_NumberPicker$onMeasure(int int ), this, n, n2);
    }

    private boolean moveToFinalScrollerPosition(Scroller scroller) {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToFinalScrollerPosition", $$robo$$android_widget_NumberPicker$moveToFinalScrollerPosition(android.widget.Scroller ), this, scroller);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_NumberPicker$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_NumberPicker$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_widget_NumberPicker$dispatchTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_NumberPicker$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$android_widget_NumberPicker$dispatchTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$android_widget_NumberPicker$dispatchHoverEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$android_widget_NumberPicker$computeScroll(), this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_NumberPicker$setEnabled(boolean ), this, bl);
    }

    @Override
    public void scrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollBy", $$robo$$android_widget_NumberPicker$scrollBy(int int ), this, n, n2);
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollOffset", $$robo$$android_widget_NumberPicker$computeVerticalScrollOffset(), this);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_widget_NumberPicker$computeVerticalScrollRange(), this);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$android_widget_NumberPicker$computeVerticalScrollExtent(), this);
    }

    @Override
    public int getSolidColor() {
        return (int)InvokeDynamicSupport.bootstrap("getSolidColor", $$robo$$android_widget_NumberPicker$getSolidColor(), this);
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnValueChangedListener", $$robo$$android_widget_NumberPicker$setOnValueChangedListener(android.widget.NumberPicker$OnValueChangeListener ), this, onValueChangeListener);
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        InvokeDynamicSupport.bootstrap("setOnScrollListener", $$robo$$android_widget_NumberPicker$setOnScrollListener(android.widget.NumberPicker$OnScrollListener ), this, onScrollListener);
    }

    public void setFormatter(Formatter formatter) {
        InvokeDynamicSupport.bootstrap("setFormatter", $$robo$$android_widget_NumberPicker$setFormatter(android.widget.NumberPicker$Formatter ), this, formatter);
    }

    public void setValue(int n) {
        InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_NumberPicker$setValue(int ), this, n);
    }

    @Override
    public boolean performClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_widget_NumberPicker$performClick(), this);
    }

    @Override
    public boolean performLongClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongClick", $$robo$$android_widget_NumberPicker$performLongClick(), this);
    }

    private void showSoftInput() {
        InvokeDynamicSupport.bootstrap("showSoftInput", $$robo$$android_widget_NumberPicker$showSoftInput(), this);
    }

    private void hideSoftInput() {
        InvokeDynamicSupport.bootstrap("hideSoftInput", $$robo$$android_widget_NumberPicker$hideSoftInput(), this);
    }

    private void tryComputeMaxWidth() {
        InvokeDynamicSupport.bootstrap("tryComputeMaxWidth", $$robo$$android_widget_NumberPicker$tryComputeMaxWidth(), this);
    }

    public boolean getWrapSelectorWheel() {
        return (boolean)InvokeDynamicSupport.bootstrap("getWrapSelectorWheel", $$robo$$android_widget_NumberPicker$getWrapSelectorWheel(), this);
    }

    public void setWrapSelectorWheel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWrapSelectorWheel", $$robo$$android_widget_NumberPicker$setWrapSelectorWheel(boolean ), this, bl);
    }

    private void updateWrapSelectorWheel() {
        InvokeDynamicSupport.bootstrap("updateWrapSelectorWheel", $$robo$$android_widget_NumberPicker$updateWrapSelectorWheel(), this);
    }

    public void setOnLongPressUpdateInterval(long l) {
        InvokeDynamicSupport.bootstrap("setOnLongPressUpdateInterval", $$robo$$android_widget_NumberPicker$setOnLongPressUpdateInterval(long ), this, l);
    }

    public int getValue() {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_widget_NumberPicker$getValue(), this);
    }

    public int getMinValue() {
        return (int)InvokeDynamicSupport.bootstrap("getMinValue", $$robo$$android_widget_NumberPicker$getMinValue(), this);
    }

    public void setMinValue(int n) {
        InvokeDynamicSupport.bootstrap("setMinValue", $$robo$$android_widget_NumberPicker$setMinValue(int ), this, n);
    }

    public int getMaxValue() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxValue", $$robo$$android_widget_NumberPicker$getMaxValue(), this);
    }

    public void setMaxValue(int n) {
        InvokeDynamicSupport.bootstrap("setMaxValue", $$robo$$android_widget_NumberPicker$setMaxValue(int ), this, n);
    }

    public String[] getDisplayedValues() {
        return InvokeDynamicSupport.bootstrap("getDisplayedValues", $$robo$$android_widget_NumberPicker$getDisplayedValues(), this);
    }

    public void setDisplayedValues(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setDisplayedValues", $$robo$$android_widget_NumberPicker$setDisplayedValues(java.lang.String[] ), this, stringArray);
    }

    public CharSequence getDisplayedValueForCurrentSelection() {
        return InvokeDynamicSupport.bootstrap("getDisplayedValueForCurrentSelection", $$robo$$android_widget_NumberPicker$getDisplayedValueForCurrentSelection(), this);
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getTopFadingEdgeStrength", $$robo$$android_widget_NumberPicker$getTopFadingEdgeStrength(), this);
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getBottomFadingEdgeStrength", $$robo$$android_widget_NumberPicker$getBottomFadingEdgeStrength(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_NumberPicker$onDetachedFromWindow(), this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_NumberPicker$drawableStateChanged(), this);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_NumberPicker$jumpDrawablesToCurrentState(), this);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$android_widget_NumberPicker$onResolveDrawables(int ), this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_NumberPicker$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_NumberPicker$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityNodeProvider", $$robo$$android_widget_NumberPicker$getAccessibilityNodeProvider(), this);
    }

    private int makeMeasureSpec(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("makeMeasureSpec", $$robo$$android_widget_NumberPicker$makeMeasureSpec(int int ), this, n, n2);
    }

    private int resolveSizeAndStateRespectingMinSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("resolveSizeAndStateRespectingMinSize", $$robo$$android_widget_NumberPicker$resolveSizeAndStateRespectingMinSize(int int int ), this, n, n2, n3);
    }

    private void initializeSelectorWheelIndices() {
        InvokeDynamicSupport.bootstrap("initializeSelectorWheelIndices", $$robo$$android_widget_NumberPicker$initializeSelectorWheelIndices(), this);
    }

    private void setValueInternal(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setValueInternal", $$robo$$android_widget_NumberPicker$setValueInternal(int boolean ), this, n, bl);
    }

    private void changeValueByOne(boolean bl) {
        InvokeDynamicSupport.bootstrap("changeValueByOne", $$robo$$android_widget_NumberPicker$changeValueByOne(boolean ), this, bl);
    }

    private void initializeSelectorWheel() {
        InvokeDynamicSupport.bootstrap("initializeSelectorWheel", $$robo$$android_widget_NumberPicker$initializeSelectorWheel(), this);
    }

    private void initializeFadingEdges() {
        InvokeDynamicSupport.bootstrap("initializeFadingEdges", $$robo$$android_widget_NumberPicker$initializeFadingEdges(), this);
    }

    private void onScrollerFinished(Scroller scroller) {
        InvokeDynamicSupport.bootstrap("onScrollerFinished", $$robo$$android_widget_NumberPicker$onScrollerFinished(android.widget.Scroller ), this, scroller);
    }

    private void onScrollStateChange(int n) {
        InvokeDynamicSupport.bootstrap("onScrollStateChange", $$robo$$android_widget_NumberPicker$onScrollStateChange(int ), this, n);
    }

    private void fling(int n) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_NumberPicker$fling(int ), this, n);
    }

    private int getWrappedSelectorIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getWrappedSelectorIndex", $$robo$$android_widget_NumberPicker$getWrappedSelectorIndex(int ), this, n);
    }

    private void incrementSelectorIndices(int[] nArray) {
        InvokeDynamicSupport.bootstrap("incrementSelectorIndices", $$robo$$android_widget_NumberPicker$incrementSelectorIndices(int[] ), this, nArray);
    }

    private void decrementSelectorIndices(int[] nArray) {
        InvokeDynamicSupport.bootstrap("decrementSelectorIndices", $$robo$$android_widget_NumberPicker$decrementSelectorIndices(int[] ), this, nArray);
    }

    private void ensureCachedScrollSelectorValue(int n) {
        InvokeDynamicSupport.bootstrap("ensureCachedScrollSelectorValue", $$robo$$android_widget_NumberPicker$ensureCachedScrollSelectorValue(int ), this, n);
    }

    private String formatNumber(int n) {
        return InvokeDynamicSupport.bootstrap("formatNumber", $$robo$$android_widget_NumberPicker$formatNumber(int ), this, n);
    }

    private void validateInputTextView(View view) {
        InvokeDynamicSupport.bootstrap("validateInputTextView", $$robo$$android_widget_NumberPicker$validateInputTextView(android.view.View ), this, view);
    }

    private boolean updateInputTextView() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateInputTextView", $$robo$$android_widget_NumberPicker$updateInputTextView(), this);
    }

    private void notifyChange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_widget_NumberPicker$notifyChange(int int ), this, n, n2);
    }

    private void postChangeCurrentByOneFromLongPress(boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("postChangeCurrentByOneFromLongPress", $$robo$$android_widget_NumberPicker$postChangeCurrentByOneFromLongPress(boolean long ), this, bl, l);
    }

    private void removeChangeCurrentByOneFromLongPress() {
        InvokeDynamicSupport.bootstrap("removeChangeCurrentByOneFromLongPress", $$robo$$android_widget_NumberPicker$removeChangeCurrentByOneFromLongPress(), this);
    }

    private void postBeginSoftInputOnLongPressCommand() {
        InvokeDynamicSupport.bootstrap("postBeginSoftInputOnLongPressCommand", $$robo$$android_widget_NumberPicker$postBeginSoftInputOnLongPressCommand(), this);
    }

    private void removeBeginSoftInputCommand() {
        InvokeDynamicSupport.bootstrap("removeBeginSoftInputCommand", $$robo$$android_widget_NumberPicker$removeBeginSoftInputCommand(), this);
    }

    private void removeAllCallbacks() {
        InvokeDynamicSupport.bootstrap("removeAllCallbacks", $$robo$$android_widget_NumberPicker$removeAllCallbacks(), this);
    }

    private int getSelectedPos(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedPos", $$robo$$android_widget_NumberPicker$getSelectedPos(java.lang.String ), this, string2);
    }

    private void postSetSelectionCommand(int n, int n2) {
        InvokeDynamicSupport.bootstrap("postSetSelectionCommand", $$robo$$android_widget_NumberPicker$postSetSelectionCommand(int int ), this, n, n2);
    }

    private boolean ensureScrollWheelAdjusted() {
        return (boolean)InvokeDynamicSupport.bootstrap("ensureScrollWheelAdjusted", $$robo$$android_widget_NumberPicker$ensureScrollWheelAdjusted(), this);
    }

    private static String formatNumberWithLocale(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatNumberWithLocale", $$robo$$android_widget_NumberPicker$formatNumberWithLocale(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(NumberPicker.class);
    }

    public /* synthetic */ NumberPicker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberPicker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AccessibilityNodeProviderImpl
    extends AccessibilityNodeProvider
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int UNDEFINED = Integer.MIN_VALUE;
        private static int VIRTUAL_VIEW_ID_INCREMENT = 1;
        private static int VIRTUAL_VIEW_ID_INPUT = 2;
        private static int VIRTUAL_VIEW_ID_DECREMENT = 3;
        private Rect mTempRect;
        private int[] mTempArray;
        private int mAccessibilityFocusedView;
        /* synthetic */ NumberPicker this$0;

        private void $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$__constructor__(NumberPicker this$0) {
            this.this$0 = this$0;
            this.mTempRect = new Rect();
            this.mTempArray = new int[2];
            this.mAccessibilityFocusedView = Integer.MIN_VALUE;
        }

        private final AccessibilityNodeInfo $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfo(int virtualViewId) {
            switch (virtualViewId) {
                case -1: {
                    return this.createAccessibilityNodeInfoForNumberPicker(this.this$0.mScrollX, this.this$0.mScrollY, this.this$0.mScrollX + (this.this$0.mRight - this.this$0.mLeft), this.this$0.mScrollY + (this.this$0.mBottom - this.this$0.mTop));
                }
                case 3: {
                    return this.createAccessibilityNodeInfoForVirtualButton(3, this.getVirtualDecrementButtonText(), this.this$0.mScrollX, this.this$0.mScrollY, this.this$0.mScrollX + (this.this$0.mRight - this.this$0.mLeft), this.this$0.mTopSelectionDividerTop + this.this$0.mSelectionDividerHeight);
                }
                case 2: {
                    return this.createAccessibiltyNodeInfoForInputText(this.this$0.mScrollX, this.this$0.mTopSelectionDividerTop + this.this$0.mSelectionDividerHeight, this.this$0.mScrollX + (this.this$0.mRight - this.this$0.mLeft), this.this$0.mBottomSelectionDividerBottom - this.this$0.mSelectionDividerHeight);
                }
                case 1: {
                    return this.createAccessibilityNodeInfoForVirtualButton(1, this.getVirtualIncrementButtonText(), this.this$0.mScrollX, this.this$0.mBottomSelectionDividerBottom - this.this$0.mSelectionDividerHeight, this.this$0.mScrollX + (this.this$0.mRight - this.this$0.mLeft), this.this$0.mScrollY + (this.this$0.mBottom - this.this$0.mTop));
                }
            }
            return super.createAccessibilityNodeInfo(virtualViewId);
        }

        private final List<AccessibilityNodeInfo> $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$findAccessibilityNodeInfosByText(String searched, int virtualViewId) {
            if (TextUtils.isEmpty(searched)) {
                return Collections.emptyList();
            }
            String searchedLowerCase = searched.toLowerCase();
            ArrayList<AccessibilityNodeInfo> result = new ArrayList<AccessibilityNodeInfo>();
            switch (virtualViewId) {
                case -1: {
                    this.findAccessibilityNodeInfosByTextInChild(searchedLowerCase, 3, result);
                    this.findAccessibilityNodeInfosByTextInChild(searchedLowerCase, 2, result);
                    this.findAccessibilityNodeInfosByTextInChild(searchedLowerCase, 1, result);
                    return result;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.findAccessibilityNodeInfosByTextInChild(searchedLowerCase, virtualViewId, result);
                    return result;
                }
            }
            return super.findAccessibilityNodeInfosByText(searched, virtualViewId);
        }

        private final boolean $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$performAction(int virtualViewId, int action, Bundle arguments) {
            switch (virtualViewId) {
                case -1: {
                    switch (action) {
                        case 64: {
                            if (this.mAccessibilityFocusedView != virtualViewId) {
                                this.mAccessibilityFocusedView = virtualViewId;
                                this.this$0.requestAccessibilityFocus();
                                return true;
                            }
                            return false;
                        }
                        case 128: {
                            if (this.mAccessibilityFocusedView == virtualViewId) {
                                this.mAccessibilityFocusedView = Integer.MIN_VALUE;
                                this.this$0.clearAccessibilityFocus();
                                return true;
                            }
                            return false;
                        }
                        case 4096: {
                            if (this.this$0.isEnabled() && (this.this$0.getWrapSelectorWheel() || this.this$0.getValue() < this.this$0.getMaxValue())) {
                                this.this$0.changeValueByOne(true);
                                return true;
                            }
                            return false;
                        }
                        case 8192: {
                            if (this.this$0.isEnabled() && (this.this$0.getWrapSelectorWheel() || this.this$0.getValue() > this.this$0.getMinValue())) {
                                this.this$0.changeValueByOne(false);
                                return true;
                            }
                            return false;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (action) {
                        case 1: {
                            if (!this.this$0.isEnabled() || this.this$0.mInputText.isFocused()) break;
                            return this.this$0.mInputText.requestFocus();
                        }
                        case 2: {
                            if (this.this$0.isEnabled() && this.this$0.mInputText.isFocused()) {
                                this.this$0.mInputText.clearFocus();
                                return true;
                            }
                            return false;
                        }
                        case 16: {
                            if (this.this$0.isEnabled()) {
                                this.this$0.performClick();
                                return true;
                            }
                            return false;
                        }
                        case 32: {
                            if (this.this$0.isEnabled()) {
                                this.this$0.performLongClick();
                                return true;
                            }
                            return false;
                        }
                        case 64: {
                            if (this.mAccessibilityFocusedView != virtualViewId) {
                                this.mAccessibilityFocusedView = virtualViewId;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 32768);
                                this.this$0.mInputText.invalidate();
                                return true;
                            }
                            return false;
                        }
                        case 128: {
                            if (this.mAccessibilityFocusedView == virtualViewId) {
                                this.mAccessibilityFocusedView = Integer.MIN_VALUE;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 65536);
                                this.this$0.mInputText.invalidate();
                                return true;
                            }
                            return false;
                        }
                        default: {
                            return this.this$0.mInputText.performAccessibilityAction(action, arguments);
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (action) {
                        case 16: {
                            if (this.this$0.isEnabled()) {
                                this.this$0.changeValueByOne(true);
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 1);
                                return true;
                            }
                            return false;
                        }
                        case 64: {
                            if (this.mAccessibilityFocusedView != virtualViewId) {
                                this.mAccessibilityFocusedView = virtualViewId;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 32768);
                                this.this$0.invalidate(0, this.this$0.mBottomSelectionDividerBottom, this.this$0.mRight, this.this$0.mBottom);
                                return true;
                            }
                            return false;
                        }
                        case 128: {
                            if (this.mAccessibilityFocusedView == virtualViewId) {
                                this.mAccessibilityFocusedView = Integer.MIN_VALUE;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 65536);
                                this.this$0.invalidate(0, this.this$0.mBottomSelectionDividerBottom, this.this$0.mRight, this.this$0.mBottom);
                                return true;
                            }
                            return false;
                        }
                    }
                    return false;
                }
                case 3: {
                    switch (action) {
                        case 16: {
                            if (this.this$0.isEnabled()) {
                                boolean increment = virtualViewId == 1;
                                this.this$0.changeValueByOne(increment);
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 1);
                                return true;
                            }
                            return false;
                        }
                        case 64: {
                            if (this.mAccessibilityFocusedView != virtualViewId) {
                                this.mAccessibilityFocusedView = virtualViewId;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 32768);
                                this.this$0.invalidate(0, 0, this.this$0.mRight, this.this$0.mTopSelectionDividerTop);
                                return true;
                            }
                            return false;
                        }
                        case 128: {
                            if (this.mAccessibilityFocusedView == virtualViewId) {
                                this.mAccessibilityFocusedView = Integer.MIN_VALUE;
                                this.sendAccessibilityEventForVirtualView(virtualViewId, 65536);
                                this.this$0.invalidate(0, 0, this.this$0.mRight, this.this$0.mTopSelectionDividerTop);
                                return true;
                            }
                            return false;
                        }
                    }
                    return false;
                }
            }
            return super.performAction(virtualViewId, action, arguments);
        }

        private final void $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualView(int virtualViewId, int eventType) {
            switch (virtualViewId) {
                case 3: {
                    if (!this.hasVirtualDecrementButton()) break;
                    this.sendAccessibilityEventForVirtualButton(virtualViewId, eventType, this.getVirtualDecrementButtonText());
                    break;
                }
                case 2: {
                    this.sendAccessibilityEventForVirtualText(eventType);
                    break;
                }
                case 1: {
                    if (!this.hasVirtualIncrementButton()) break;
                    this.sendAccessibilityEventForVirtualButton(virtualViewId, eventType, this.getVirtualIncrementButtonText());
                }
            }
        }

        private final void $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualText(int eventType) {
            if (AccessibilityManager.getInstance(this.this$0.mContext).isEnabled()) {
                AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
                this.this$0.mInputText.onInitializeAccessibilityEvent(event);
                this.this$0.mInputText.onPopulateAccessibilityEvent(event);
                event.setSource(this.this$0, 2);
                this.this$0.requestSendAccessibilityEvent(this.this$0, event);
            }
        }

        private final void $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualButton(int virtualViewId, int eventType, String text) {
            if (AccessibilityManager.getInstance(this.this$0.mContext).isEnabled()) {
                AccessibilityEvent event = AccessibilityEvent.obtain(eventType);
                event.setClassName(Button.class.getName());
                event.setPackageName(this.this$0.mContext.getPackageName());
                event.getText().add(text);
                event.setEnabled(this.this$0.isEnabled());
                event.setSource(this.this$0, virtualViewId);
                this.this$0.requestSendAccessibilityEvent(this.this$0, event);
            }
        }

        private final void $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$findAccessibilityNodeInfosByTextInChild(String searchedLowerCase, int virtualViewId, List<AccessibilityNodeInfo> outResult) {
            switch (virtualViewId) {
                case 3: {
                    String text = this.getVirtualDecrementButtonText();
                    if (!TextUtils.isEmpty(text) && text.toString().toLowerCase().contains(searchedLowerCase)) {
                        outResult.add(this.createAccessibilityNodeInfo(3));
                    }
                    return;
                }
                case 2: {
                    CharSequence text = this.this$0.mInputText.getText();
                    if (!TextUtils.isEmpty(text) && text.toString().toLowerCase().contains(searchedLowerCase)) {
                        outResult.add(this.createAccessibilityNodeInfo(2));
                        return;
                    }
                    CharSequence contentDesc = this.this$0.mInputText.getText();
                    if (TextUtils.isEmpty(contentDesc) || !contentDesc.toString().toLowerCase().contains(searchedLowerCase)) break;
                    outResult.add(this.createAccessibilityNodeInfo(2));
                    return;
                }
                case 1: {
                    String text = this.getVirtualIncrementButtonText();
                    if (!TextUtils.isEmpty(text) && text.toString().toLowerCase().contains(searchedLowerCase)) {
                        outResult.add(this.createAccessibilityNodeInfo(1));
                    }
                    return;
                }
            }
        }

        private final AccessibilityNodeInfo $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibiltyNodeInfoForInputText(int left, int top, int right, int bottom) {
            AccessibilityNodeInfo info = this.this$0.mInputText.createAccessibilityNodeInfo();
            info.setSource(this.this$0, 2);
            if (this.mAccessibilityFocusedView != 2) {
                info.addAction(64);
            }
            if (this.mAccessibilityFocusedView == 2) {
                info.addAction(128);
            }
            Rect boundsInParent = this.mTempRect;
            boundsInParent.set(left, top, right, bottom);
            info.setVisibleToUser(this.this$0.isVisibleToUser(boundsInParent));
            info.setBoundsInParent(boundsInParent);
            Rect boundsInScreen = boundsInParent;
            int[] locationOnScreen = this.mTempArray;
            this.this$0.getLocationOnScreen(locationOnScreen);
            boundsInScreen.offset(locationOnScreen[0], locationOnScreen[1]);
            info.setBoundsInScreen(boundsInScreen);
            return info;
        }

        private final AccessibilityNodeInfo $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfoForVirtualButton(int virtualViewId, String text, int left, int top, int right, int bottom) {
            AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
            info.setClassName(Button.class.getName());
            info.setPackageName(this.this$0.mContext.getPackageName());
            info.setSource(this.this$0, virtualViewId);
            info.setParent(this.this$0);
            info.setText(text);
            info.setClickable(true);
            info.setLongClickable(true);
            info.setEnabled(this.this$0.isEnabled());
            Rect boundsInParent = this.mTempRect;
            boundsInParent.set(left, top, right, bottom);
            info.setVisibleToUser(this.this$0.isVisibleToUser(boundsInParent));
            info.setBoundsInParent(boundsInParent);
            Rect boundsInScreen = boundsInParent;
            int[] locationOnScreen = this.mTempArray;
            this.this$0.getLocationOnScreen(locationOnScreen);
            boundsInScreen.offset(locationOnScreen[0], locationOnScreen[1]);
            info.setBoundsInScreen(boundsInScreen);
            if (this.mAccessibilityFocusedView != virtualViewId) {
                info.addAction(64);
            }
            if (this.mAccessibilityFocusedView == virtualViewId) {
                info.addAction(128);
            }
            if (this.this$0.isEnabled()) {
                info.addAction(16);
            }
            return info;
        }

        private final AccessibilityNodeInfo $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfoForNumberPicker(int left, int top, int right, int bottom) {
            AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
            info.setClassName(NumberPicker.class.getName());
            info.setPackageName(this.this$0.mContext.getPackageName());
            info.setSource(this.this$0);
            if (this.hasVirtualDecrementButton()) {
                info.addChild(this.this$0, 3);
            }
            info.addChild(this.this$0, 2);
            if (this.hasVirtualIncrementButton()) {
                info.addChild(this.this$0, 1);
            }
            info.setParent((View)((Object)this.this$0.getParentForAccessibility()));
            info.setEnabled(this.this$0.isEnabled());
            info.setScrollable(true);
            float applicationScale = this.this$0.getContext().getResources().getCompatibilityInfo().applicationScale;
            Rect boundsInParent = this.mTempRect;
            boundsInParent.set(left, top, right, bottom);
            boundsInParent.scale(applicationScale);
            info.setBoundsInParent(boundsInParent);
            info.setVisibleToUser(this.this$0.isVisibleToUser());
            Rect boundsInScreen = boundsInParent;
            int[] locationOnScreen = this.mTempArray;
            this.this$0.getLocationOnScreen(locationOnScreen);
            boundsInScreen.offset(locationOnScreen[0], locationOnScreen[1]);
            boundsInScreen.scale(applicationScale);
            info.setBoundsInScreen(boundsInScreen);
            if (this.mAccessibilityFocusedView != -1) {
                info.addAction(64);
            }
            if (this.mAccessibilityFocusedView == -1) {
                info.addAction(128);
            }
            if (this.this$0.isEnabled()) {
                if (this.this$0.getWrapSelectorWheel() || this.this$0.getValue() < this.this$0.getMaxValue()) {
                    info.addAction(4096);
                }
                if (this.this$0.getWrapSelectorWheel() || this.this$0.getValue() > this.this$0.getMinValue()) {
                    info.addAction(8192);
                }
            }
            return info;
        }

        private final boolean $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$hasVirtualDecrementButton() {
            return this.this$0.getWrapSelectorWheel() || this.this$0.getValue() > this.this$0.getMinValue();
        }

        private final boolean $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$hasVirtualIncrementButton() {
            return this.this$0.getWrapSelectorWheel() || this.this$0.getValue() < this.this$0.getMaxValue();
        }

        private final String $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$getVirtualDecrementButtonText() {
            int value = this.this$0.mValue - 1;
            if (this.this$0.mWrapSelectorWheel) {
                value = this.this$0.getWrappedSelectorIndex(value);
            }
            if (value >= this.this$0.mMinValue) {
                return this.this$0.mDisplayedValues == null ? this.this$0.formatNumber(value) : this.this$0.mDisplayedValues[value - this.this$0.mMinValue];
            }
            return null;
        }

        private final String $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$getVirtualIncrementButtonText() {
            int value = this.this$0.mValue + 1;
            if (this.this$0.mWrapSelectorWheel) {
                value = this.this$0.getWrappedSelectorIndex(value);
            }
            if (value <= this.this$0.mMaxValue) {
                return this.this$0.mDisplayedValues == null ? this.this$0.formatNumber(value) : this.this$0.mDisplayedValues[value - this.this$0.mMinValue];
            }
            return null;
        }

        private void __constructor__(NumberPicker numberPicker) {
            this.$$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$__constructor__(numberPicker);
        }

        public AccessibilityNodeProviderImpl(NumberPicker numberPicker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$__constructor__(android.widget.NumberPicker ), this, numberPicker);
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            return InvokeDynamicSupport.bootstrap("createAccessibilityNodeInfo", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfo(int ), this, n);
        }

        @Override
        public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByText", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$findAccessibilityNodeInfosByText(java.lang.String int ), this, string2, n);
        }

        @Override
        public boolean performAction(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAction", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$performAction(int int android.os.Bundle ), this, n, n2, bundle);
        }

        public void sendAccessibilityEventForVirtualView(int n, int n2) {
            InvokeDynamicSupport.bootstrap("sendAccessibilityEventForVirtualView", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualView(int int ), this, n, n2);
        }

        private void sendAccessibilityEventForVirtualText(int n) {
            InvokeDynamicSupport.bootstrap("sendAccessibilityEventForVirtualText", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualText(int ), this, n);
        }

        private void sendAccessibilityEventForVirtualButton(int n, int n2, String string2) {
            InvokeDynamicSupport.bootstrap("sendAccessibilityEventForVirtualButton", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$sendAccessibilityEventForVirtualButton(int int java.lang.String ), this, n, n2, string2);
        }

        private void findAccessibilityNodeInfosByTextInChild(String string2, int n, List<AccessibilityNodeInfo> list) {
            InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByTextInChild", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$findAccessibilityNodeInfosByTextInChild(java.lang.String int java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), this, string2, n, list);
        }

        private AccessibilityNodeInfo createAccessibiltyNodeInfoForInputText(int n, int n2, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("createAccessibiltyNodeInfoForInputText", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibiltyNodeInfoForInputText(int int int int ), this, n, n2, n3, n4);
        }

        private AccessibilityNodeInfo createAccessibilityNodeInfoForVirtualButton(int n, String string2, int n2, int n3, int n4, int n5) {
            return InvokeDynamicSupport.bootstrap("createAccessibilityNodeInfoForVirtualButton", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfoForVirtualButton(int java.lang.String int int int int ), this, n, string2, n2, n3, n4, n5);
        }

        private AccessibilityNodeInfo createAccessibilityNodeInfoForNumberPicker(int n, int n2, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("createAccessibilityNodeInfoForNumberPicker", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$createAccessibilityNodeInfoForNumberPicker(int int int int ), this, n, n2, n3, n4);
        }

        private boolean hasVirtualDecrementButton() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasVirtualDecrementButton", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$hasVirtualDecrementButton(), this);
        }

        private boolean hasVirtualIncrementButton() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasVirtualIncrementButton", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$hasVirtualIncrementButton(), this);
        }

        private String getVirtualDecrementButtonText() {
            return InvokeDynamicSupport.bootstrap("getVirtualDecrementButtonText", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$getVirtualDecrementButtonText(), this);
        }

        private String getVirtualIncrementButtonText() {
            return InvokeDynamicSupport.bootstrap("getVirtualIncrementButtonText", $$robo$$android_widget_NumberPicker_AccessibilityNodeProviderImpl$getVirtualIncrementButtonText(), this);
        }

        public /* synthetic */ AccessibilityNodeProviderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityNodeProviderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class BeginSoftInputOnLongPressCommand
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ NumberPicker this$0;

        private void $$robo$$android_widget_NumberPicker_BeginSoftInputOnLongPressCommand$__constructor__(NumberPicker this$0) {
            this.this$0 = this$0;
        }

        private final void $$robo$$android_widget_NumberPicker_BeginSoftInputOnLongPressCommand$run() {
            this.this$0.performLongClick();
        }

        private void __constructor__(NumberPicker numberPicker) {
            this.$$robo$$android_widget_NumberPicker_BeginSoftInputOnLongPressCommand$__constructor__(numberPicker);
        }

        public BeginSoftInputOnLongPressCommand(NumberPicker numberPicker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_BeginSoftInputOnLongPressCommand$__constructor__(android.widget.NumberPicker ), this, numberPicker);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_NumberPicker_BeginSoftInputOnLongPressCommand$run(), this);
        }

        public /* synthetic */ BeginSoftInputOnLongPressCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BeginSoftInputOnLongPressCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CustomEditText
    extends EditText
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_NumberPicker_CustomEditText$__constructor__(Context context, AttributeSet attrs) {
        }

        private final void $$robo$$android_widget_NumberPicker_CustomEditText$onEditorAction(int actionCode) {
            super.onEditorAction(actionCode);
            if (actionCode == 6) {
                this.clearFocus();
            }
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_NumberPicker_CustomEditText$__constructor__(context, attributeSet);
        }

        public CustomEditText(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_CustomEditText$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        @Override
        public void onEditorAction(int n) {
            InvokeDynamicSupport.bootstrap("onEditorAction", $$robo$$android_widget_NumberPicker_CustomEditText$onEditorAction(int ), this, n);
        }

        public /* synthetic */ CustomEditText() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CustomEditText)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ChangeCurrentByOneFromLongPressCommand
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mIncrement;
        /* synthetic */ NumberPicker this$0;

        private void $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$__constructor__(NumberPicker this$0) {
            this.this$0 = this$0;
        }

        private final void $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$setStep(boolean increment) {
            this.mIncrement = increment;
        }

        private final void $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$run() {
            this.this$0.changeValueByOne(this.mIncrement);
            this.this$0.postDelayed(this, this.this$0.mLongPressUpdateInterval);
        }

        private void __constructor__(NumberPicker numberPicker) {
            this.$$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$__constructor__(numberPicker);
        }

        public ChangeCurrentByOneFromLongPressCommand(NumberPicker numberPicker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$__constructor__(android.widget.NumberPicker ), this, numberPicker);
        }

        private void setStep(boolean bl) {
            InvokeDynamicSupport.bootstrap("setStep", $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$setStep(boolean ), this, bl);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_NumberPicker_ChangeCurrentByOneFromLongPressCommand$run(), this);
        }

        public /* synthetic */ ChangeCurrentByOneFromLongPressCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeCurrentByOneFromLongPressCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SetSelectionCommand
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private EditText mInputText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mPosted;

        private void $$robo$$android_widget_NumberPicker_SetSelectionCommand$__constructor__(EditText inputText) {
            this.mInputText = inputText;
        }

        private final void $$robo$$android_widget_NumberPicker_SetSelectionCommand$post(int selectionStart, int selectionEnd) {
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            if (!this.mPosted) {
                this.mInputText.post(this);
                this.mPosted = true;
            }
        }

        private final void $$robo$$android_widget_NumberPicker_SetSelectionCommand$cancel() {
            if (this.mPosted) {
                this.mInputText.removeCallbacks(this);
                this.mPosted = false;
            }
        }

        private final void $$robo$$android_widget_NumberPicker_SetSelectionCommand$run() {
            this.mPosted = false;
            this.mInputText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }

        private void __constructor__(EditText editText) {
            this.$$robo$$android_widget_NumberPicker_SetSelectionCommand$__constructor__(editText);
        }

        public SetSelectionCommand(EditText editText) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_SetSelectionCommand$__constructor__(android.widget.EditText ), this, editText);
        }

        public void post(int n, int n2) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_widget_NumberPicker_SetSelectionCommand$post(int int ), this, n, n2);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_widget_NumberPicker_SetSelectionCommand$cancel(), this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_NumberPicker_SetSelectionCommand$run(), this);
        }

        public /* synthetic */ SetSelectionCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetSelectionCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class PressedStateHelper
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int BUTTON_INCREMENT = 1;
        public static int BUTTON_DECREMENT = 2;
        private int MODE_PRESS = 1;
        private int MODE_TAPPED = 2;
        private int mManagedButton;
        private int mMode;
        /* synthetic */ NumberPicker this$0;

        private void $$robo$$android_widget_NumberPicker_PressedStateHelper$__constructor__(NumberPicker this$0) {
            this.this$0 = this$0;
            this.MODE_PRESS = 1;
            this.MODE_TAPPED = 2;
        }

        private final void $$robo$$android_widget_NumberPicker_PressedStateHelper$cancel() {
            this.mMode = 0;
            this.mManagedButton = 0;
            this.this$0.removeCallbacks(this);
            if (this.this$0.mIncrementVirtualButtonPressed) {
                this.this$0.mIncrementVirtualButtonPressed = false;
                this.this$0.invalidate(0, this.this$0.mBottomSelectionDividerBottom, this.this$0.mRight, this.this$0.mBottom);
            }
            this.this$0.mDecrementVirtualButtonPressed = false;
            if (this.this$0.mDecrementVirtualButtonPressed) {
                this.this$0.invalidate(0, 0, this.this$0.mRight, this.this$0.mTopSelectionDividerTop);
            }
        }

        private final void $$robo$$android_widget_NumberPicker_PressedStateHelper$buttonPressDelayed(int button) {
            this.cancel();
            this.mMode = 1;
            this.mManagedButton = button;
            this.this$0.postDelayed(this, ViewConfiguration.getTapTimeout());
        }

        private final void $$robo$$android_widget_NumberPicker_PressedStateHelper$buttonTapped(int button) {
            this.cancel();
            this.mMode = 2;
            this.mManagedButton = button;
            this.this$0.post(this);
        }

        private final void $$robo$$android_widget_NumberPicker_PressedStateHelper$run() {
            block0 : switch (this.mMode) {
                case 1: {
                    switch (this.mManagedButton) {
                        case 1: {
                            this.this$0.mIncrementVirtualButtonPressed = true;
                            this.this$0.invalidate(0, this.this$0.mBottomSelectionDividerBottom, this.this$0.mRight, this.this$0.mBottom);
                            break;
                        }
                        case 2: {
                            this.this$0.mDecrementVirtualButtonPressed = true;
                            this.this$0.invalidate(0, 0, this.this$0.mRight, this.this$0.mTopSelectionDividerTop);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.mManagedButton) {
                        case 1: {
                            if (!this.this$0.mIncrementVirtualButtonPressed) {
                                this.this$0.postDelayed(this, ViewConfiguration.getPressedStateDuration());
                            }
                            this.this$0.mIncrementVirtualButtonPressed = (byte)(this.this$0.mIncrementVirtualButtonPressed ^ 1);
                            this.this$0.invalidate(0, this.this$0.mBottomSelectionDividerBottom, this.this$0.mRight, this.this$0.mBottom);
                            break block0;
                        }
                        case 2: {
                            if (!this.this$0.mDecrementVirtualButtonPressed) {
                                this.this$0.postDelayed(this, ViewConfiguration.getPressedStateDuration());
                            }
                            this.this$0.mDecrementVirtualButtonPressed = (byte)(this.this$0.mDecrementVirtualButtonPressed ^ 1);
                            this.this$0.invalidate(0, 0, this.this$0.mRight, this.this$0.mTopSelectionDividerTop);
                        }
                    }
                }
            }
        }

        private void __constructor__(NumberPicker numberPicker) {
            this.$$robo$$android_widget_NumberPicker_PressedStateHelper$__constructor__(numberPicker);
        }

        public PressedStateHelper(NumberPicker numberPicker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_PressedStateHelper$__constructor__(android.widget.NumberPicker ), this, numberPicker);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_widget_NumberPicker_PressedStateHelper$cancel(), this);
        }

        public void buttonPressDelayed(int n) {
            InvokeDynamicSupport.bootstrap("buttonPressDelayed", $$robo$$android_widget_NumberPicker_PressedStateHelper$buttonPressDelayed(int ), this, n);
        }

        public void buttonTapped(int n) {
            InvokeDynamicSupport.bootstrap("buttonTapped", $$robo$$android_widget_NumberPicker_PressedStateHelper$buttonTapped(int ), this, n);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_NumberPicker_PressedStateHelper$run(), this);
        }

        public /* synthetic */ PressedStateHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PressedStateHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class InputTextFilter
    extends NumberKeyListener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ NumberPicker this$0;

        private void $$robo$$android_widget_NumberPicker_InputTextFilter$__constructor__(NumberPicker this$0) {
            this.this$0 = this$0;
        }

        private final int $$robo$$android_widget_NumberPicker_InputTextFilter$getInputType() {
            return 1;
        }

        private final char[] $$robo$$android_widget_NumberPicker_InputTextFilter$getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        private final CharSequence $$robo$$android_widget_NumberPicker_InputTextFilter$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (this.this$0.mSetSelectionCommand != null) {
                this.this$0.mSetSelectionCommand.cancel();
            }
            if (this.this$0.mDisplayedValues == null) {
                String result;
                CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
                if (filtered == null) {
                    filtered = source.subSequence(start, end);
                }
                if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                    return result;
                }
                int val = this.this$0.getSelectedPos(result);
                if (val > this.this$0.mMaxValue || result.length() > String.valueOf(this.this$0.mMaxValue).length()) {
                    return "";
                }
                return filtered;
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            if (TextUtils.isEmpty(filtered)) {
                return "";
            }
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase();
            for (String val : this.this$0.mDisplayedValues) {
                String valLowerCase = val.toLowerCase();
                if (!valLowerCase.startsWith(str)) continue;
                this.this$0.postSetSelectionCommand(result.length(), val.length());
                return val.subSequence(dstart, val.length());
            }
            return "";
        }

        private void __constructor__(NumberPicker numberPicker) {
            this.$$robo$$android_widget_NumberPicker_InputTextFilter$__constructor__(numberPicker);
        }

        public InputTextFilter(NumberPicker numberPicker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_InputTextFilter$__constructor__(android.widget.NumberPicker ), this, numberPicker);
        }

        @Override
        public int getInputType() {
            return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_widget_NumberPicker_InputTextFilter$getInputType(), this);
        }

        @Override
        protected char[] getAcceptedChars() {
            return InvokeDynamicSupport.bootstrap("getAcceptedChars", $$robo$$android_widget_NumberPicker_InputTextFilter$getAcceptedChars(), this);
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_widget_NumberPicker_InputTextFilter$filter(java.lang.CharSequence int int android.text.Spanned int int ), this, charSequence, n, n2, spanned, n3, n4);
        }

        public /* synthetic */ InputTextFilter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputTextFilter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChange(NumberPicker var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScrollState {
        }
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    private static class TwoDigitFormatter
    implements Formatter,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        StringBuilder mBuilder;
        char mZeroDigit;
        java.util.Formatter mFmt;
        Object[] mArgs;

        private void $$robo$$android_widget_NumberPicker_TwoDigitFormatter$__constructor__() {
            this.mBuilder = new StringBuilder();
            this.mArgs = new Object[1];
            Locale locale = Locale.getDefault();
            this.init(locale);
        }

        private final void $$robo$$android_widget_NumberPicker_TwoDigitFormatter$init(Locale locale) {
            this.mFmt = this.createFormatter(locale);
            this.mZeroDigit = TwoDigitFormatter.getZeroDigit(locale);
        }

        private final String $$robo$$android_widget_NumberPicker_TwoDigitFormatter$format(int value) {
            Locale currentLocale = Locale.getDefault();
            if (this.mZeroDigit != TwoDigitFormatter.getZeroDigit(currentLocale)) {
                this.init(currentLocale);
            }
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }

        private static final char $$robo$$android_widget_NumberPicker_TwoDigitFormatter$getZeroDigit(Locale locale) {
            return LocaleData.get((Locale)locale).zeroDigit;
        }

        private final java.util.Formatter $$robo$$android_widget_NumberPicker_TwoDigitFormatter$createFormatter(Locale locale) {
            return new java.util.Formatter(this.mBuilder, locale);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_NumberPicker_TwoDigitFormatter$__constructor__();
        }

        public TwoDigitFormatter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_NumberPicker_TwoDigitFormatter$__constructor__(), this);
        }

        private void init(Locale locale) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_NumberPicker_TwoDigitFormatter$init(java.util.Locale ), this, locale);
        }

        @Override
        public String format(int n) {
            return InvokeDynamicSupport.bootstrap("format", $$robo$$android_widget_NumberPicker_TwoDigitFormatter$format(int ), this, n);
        }

        private static char getZeroDigit(Locale locale) {
            return (char)InvokeDynamicSupport.bootstrapStatic("getZeroDigit", $$robo$$android_widget_NumberPicker_TwoDigitFormatter$getZeroDigit(java.util.Locale ), (Locale)locale);
        }

        private java.util.Formatter createFormatter(Locale locale) {
            return InvokeDynamicSupport.bootstrap("createFormatter", $$robo$$android_widget_NumberPicker_TwoDigitFormatter$createFormatter(java.util.Locale ), this, locale);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TwoDigitFormatter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

