/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Pools;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int TRUE = -1;
    public static int LEFT_OF = 0;
    public static int RIGHT_OF = 1;
    public static int ABOVE = 2;
    public static int BELOW = 3;
    public static int ALIGN_BASELINE = 4;
    public static int ALIGN_LEFT = 5;
    public static int ALIGN_TOP = 6;
    public static int ALIGN_RIGHT = 7;
    public static int ALIGN_BOTTOM = 8;
    public static int ALIGN_PARENT_LEFT = 9;
    public static int ALIGN_PARENT_TOP = 10;
    public static int ALIGN_PARENT_RIGHT = 11;
    public static int ALIGN_PARENT_BOTTOM = 12;
    public static int CENTER_IN_PARENT = 13;
    public static int CENTER_HORIZONTAL = 14;
    public static int CENTER_VERTICAL = 15;
    public static int START_OF = 16;
    public static int END_OF = 17;
    public static int ALIGN_START = 18;
    public static int ALIGN_END = 19;
    public static int ALIGN_PARENT_START = 20;
    public static int ALIGN_PARENT_END = 21;
    private static int VERB_COUNT = 22;
    private static int[] RULES_VERTICAL;
    private static int[] RULES_HORIZONTAL;
    private static int VALUE_NOT_SET = Integer.MIN_VALUE;
    private View mBaselineView;
    private int mGravity;
    private Rect mContentBounds;
    private Rect mSelfBounds;
    private int mIgnoreGravity;
    private SortedSet<View> mTopToBottomLeftToRightSet;
    private boolean mDirtyHierarchy;
    private View[] mSortedHorizontalChildren;
    private View[] mSortedVerticalChildren;
    private DependencyGraph mGraph;
    private boolean mAllowBrokenMeasureSpecs;
    private boolean mMeasureVerticalWithPaddingMargin;
    private static int DEFAULT_WIDTH = 65536;

    private void $$robo$$android_widget_RelativeLayout$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_RelativeLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_RelativeLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_RelativeLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mBaselineView = null;
        this.mGravity = 0x800033;
        this.mContentBounds = new Rect();
        this.mSelfBounds = new Rect();
        this.mTopToBottomLeftToRightSet = null;
        this.mGraph = new DependencyGraph(null);
        this.mAllowBrokenMeasureSpecs = false;
        this.mMeasureVerticalWithPaddingMargin = false;
        this.initFromAttributes(context, attrs, defStyleAttr, defStyleRes);
        this.queryCompatibilityModes(context);
    }

    private final void $$robo$$android_widget_RelativeLayout$initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RelativeLayout, defStyleAttr, defStyleRes);
        this.mIgnoreGravity = a.getResourceId(1, -1);
        this.mGravity = a.getInt(0, this.mGravity);
        a.recycle();
    }

    private final void $$robo$$android_widget_RelativeLayout$queryCompatibilityModes(Context context) {
        int version = context.getApplicationInfo().targetSdkVersion;
        this.mAllowBrokenMeasureSpecs = version <= 17;
        this.mMeasureVerticalWithPaddingMargin = version >= 18;
    }

    private final boolean $$robo$$android_widget_RelativeLayout$shouldDelayChildPressedState() {
        return false;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_RelativeLayout$setIgnoreGravity(int viewId) {
        this.mIgnoreGravity = viewId;
    }

    private final int $$robo$$android_widget_RelativeLayout$getGravity() {
        return this.mGravity;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_RelativeLayout$setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_RelativeLayout$setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_RelativeLayout$setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    private final int $$robo$$android_widget_RelativeLayout$getBaseline() {
        return this.mBaselineView != null ? this.mBaselineView.getBaseline() : super.getBaseline();
    }

    private final void $$robo$$android_widget_RelativeLayout$requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    private final void $$robo$$android_widget_RelativeLayout$sortChildren() {
        int count = this.getChildCount();
        if (this.mSortedVerticalChildren == null || this.mSortedVerticalChildren.length != count) {
            this.mSortedVerticalChildren = new View[count];
        }
        if (this.mSortedHorizontalChildren == null || this.mSortedHorizontalChildren.length != count) {
            this.mSortedHorizontalChildren = new View[count];
        }
        DependencyGraph graph = this.mGraph;
        graph.clear();
        for (int i = 0; i < count; ++i) {
            graph.add(this.getChildAt(i));
        }
        graph.getSortedViews(this.mSortedVerticalChildren, RULES_VERTICAL);
        graph.getSortedViews(this.mSortedHorizontalChildren, RULES_HORIZONTAL);
    }

    private final void $$robo$$android_widget_RelativeLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] rules;
        LayoutParams params;
        View child;
        int i;
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            this.sortChildren();
        }
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (widthMode == 0x40000000) {
            width = myWidth;
        }
        if (heightMode == 0x40000000) {
            height = myHeight;
        }
        Object ignore = null;
        int gravity = this.mGravity & 0x800007;
        boolean horizontalGravity = gravity != 0x800003 && gravity != 0;
        gravity = this.mGravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean offsetHorizontalAxis = false;
        boolean offsetVerticalAxis = false;
        if ((horizontalGravity || verticalGravity) && this.mIgnoreGravity != -1) {
            ignore = this.findViewById(this.mIgnoreGravity);
        }
        boolean isWrapContentWidth = widthMode != 0x40000000;
        boolean isWrapContentHeight = heightMode != 0x40000000;
        int layoutDirection = this.getLayoutDirection();
        if (this.isLayoutRtl() && myWidth == -1) {
            myWidth = 65536;
        }
        for (View child2 : this.mSortedHorizontalChildren) {
            if (child2.getVisibility() == 8) continue;
            LayoutParams params2 = (LayoutParams)child2.getLayoutParams();
            int[] rules2 = params2.getRules(layoutDirection);
            this.applyHorizontalSizeRules(params2, myWidth, rules2);
            this.measureChildHorizontal(child2, params2, myWidth, myHeight);
            if (!this.positionChildHorizontal(child2, params2, myWidth, isWrapContentWidth)) continue;
            offsetHorizontalAxis = true;
        }
        View[] views = this.mSortedVerticalChildren;
        int count = views.length;
        int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        for (int i2 = 0; i2 < count; ++i2) {
            View child3 = views[i2];
            if (child3.getVisibility() == 8) continue;
            LayoutParams params3 = (LayoutParams)child3.getLayoutParams();
            this.applyVerticalSizeRules(params3, myHeight, child3.getBaseline());
            this.measureChild(child3, params3, myWidth, myHeight);
            if (this.positionChildVertical(child3, params3, myHeight, isWrapContentHeight)) {
                offsetVerticalAxis = true;
            }
            if (isWrapContentWidth) {
                width = this.isLayoutRtl() ? (targetSdkVersion < 19 ? Math.max(width, myWidth - params3.mLeft) : Math.max(width, myWidth - params3.mLeft + params3.leftMargin)) : (targetSdkVersion < 19 ? Math.max(width, params3.mRight) : Math.max(width, params3.mRight + params3.rightMargin));
            }
            if (isWrapContentHeight) {
                height = targetSdkVersion < 19 ? Math.max(height, params3.mBottom) : Math.max(height, params3.mBottom + params3.bottomMargin);
            }
            if (child3 != ignore || verticalGravity) {
                left = Math.min(left, params3.mLeft - params3.leftMargin);
                top = Math.min(top, params3.mTop - params3.topMargin);
            }
            if (child3 == ignore && !horizontalGravity) continue;
            right = Math.max(right, params3.mRight + params3.rightMargin);
            bottom = Math.max(bottom, params3.mBottom + params3.bottomMargin);
        }
        View baselineView = null;
        LayoutParams baselineParams = null;
        for (i = 0; i < count; ++i) {
            child = views[i];
            if (child.getVisibility() == 8) continue;
            LayoutParams childParams = (LayoutParams)child.getLayoutParams();
            if (baselineView != null && baselineParams != null && this.compareLayoutPosition(childParams, baselineParams) >= 0) continue;
            baselineView = child;
            baselineParams = childParams;
        }
        this.mBaselineView = baselineView;
        if (isWrapContentWidth) {
            width += this.mPaddingRight;
            if (this.mLayoutParams != null && this.mLayoutParams.width >= 0) {
                width = Math.max(width, this.mLayoutParams.width);
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
            if (offsetHorizontalAxis) {
                for (i = 0; i < count; ++i) {
                    child = views[i];
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[14] != 0) {
                        RelativeLayout.centerHorizontal(child, params, width);
                        continue;
                    }
                    if (rules[11] == 0) continue;
                    int childWidth = child.getMeasuredWidth();
                    params.mLeft = width - this.mPaddingRight - childWidth;
                    params.mRight = params.mLeft + childWidth;
                }
            }
        }
        if (isWrapContentHeight) {
            height += this.mPaddingBottom;
            if (this.mLayoutParams != null && this.mLayoutParams.height >= 0) {
                height = Math.max(height, this.mLayoutParams.height);
            }
            height = Math.max(height, this.getSuggestedMinimumHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
            if (offsetVerticalAxis) {
                for (i = 0; i < count; ++i) {
                    child = views[i];
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[15] != 0) {
                        RelativeLayout.centerVertical(child, params, height);
                        continue;
                    }
                    if (rules[12] == 0) continue;
                    int childHeight = child.getMeasuredHeight();
                    params.mTop = height - this.mPaddingBottom - childHeight;
                    params.mBottom = params.mTop + childHeight;
                }
            }
        }
        if (horizontalGravity || verticalGravity) {
            Rect selfBounds = this.mSelfBounds;
            selfBounds.set(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
            Rect contentBounds = this.mContentBounds;
            Gravity.apply(this.mGravity, right - left, bottom - top, selfBounds, contentBounds, layoutDirection);
            int horizontalOffset = contentBounds.left - left;
            int verticalOffset = contentBounds.top - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child4 = views[i3];
                    if (child4.getVisibility() == 8 || child4 == ignore) continue;
                    LayoutParams params4 = (LayoutParams)child4.getLayoutParams();
                    if (horizontalGravity) {
                        params4.mLeft += horizontalOffset;
                        params4.mRight += horizontalOffset;
                    }
                    if (!verticalGravity) continue;
                    params4.mTop += verticalOffset;
                    params4.mBottom += verticalOffset;
                }
            }
        }
        if (this.isLayoutRtl()) {
            int offsetWidth = myWidth - width;
            for (int i4 = 0; i4 < count; ++i4) {
                View child5 = views[i4];
                if (child5.getVisibility() == 8) continue;
                LayoutParams params5 = (LayoutParams)child5.getLayoutParams();
                params5.mLeft -= offsetWidth;
                params5.mRight -= offsetWidth;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private final int $$robo$$android_widget_RelativeLayout$compareLayoutPosition(LayoutParams p1, LayoutParams p2) {
        int topDiff = p1.mTop - p2.mTop;
        if (topDiff != 0) {
            return topDiff;
        }
        return p1.mLeft - p2.mLeft;
    }

    private final void $$robo$$android_widget_RelativeLayout$measureChild(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, this.mPaddingTop, this.mPaddingBottom, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_widget_RelativeLayout$measureChildHorizontal(View child, LayoutParams params, int myWidth, int myHeight) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        if (myHeight < 0 && !this.mAllowBrokenMeasureSpecs) {
            childHeightMeasureSpec = params.height >= 0 ? View.MeasureSpec.makeMeasureSpec(params.height, 0x40000000) : View.MeasureSpec.makeMeasureSpec(0, 0);
        } else {
            int maxHeight = this.mMeasureVerticalWithPaddingMargin ? Math.max(0, myHeight - this.mPaddingTop - this.mPaddingBottom - params.topMargin - params.bottomMargin) : Math.max(0, myHeight);
            int heightMode = params.height == -1 ? 0x40000000 : Integer.MIN_VALUE;
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxHeight, heightMode);
        }
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final int $$robo$$android_widget_RelativeLayout$getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int startPadding, int endPadding, int mySize) {
        boolean isUnspecified;
        int childSpecMode = 0;
        int childSpecSize = 0;
        boolean bl = isUnspecified = mySize < 0;
        if (isUnspecified && !this.mAllowBrokenMeasureSpecs) {
            if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
                childSpecSize = Math.max(0, childEnd - childStart);
                childSpecMode = 0x40000000;
            } else if (childSize >= 0) {
                childSpecSize = childSize;
                childSpecMode = 0x40000000;
            } else {
                childSpecSize = 0;
                childSpecMode = 0;
            }
            return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
        }
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart == Integer.MIN_VALUE) {
            tempStart = startPadding + startMargin;
        }
        if (tempEnd == Integer.MIN_VALUE) {
            tempEnd = mySize - endPadding - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
            childSpecMode = isUnspecified ? 0 : 0x40000000;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = isUnspecified ? 0 : 0x40000000;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize == -2) {
            if (maxAvailable >= 0) {
                childSpecMode = Integer.MIN_VALUE;
                childSpecSize = maxAvailable;
            } else {
                childSpecMode = 0;
                childSpecSize = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    private final boolean $$robo$$android_widget_RelativeLayout$positionChildHorizontal(View child, LayoutParams params, int myWidth, boolean wrapContent) {
        int layoutDirection = this.getLayoutDirection();
        int[] rules = params.getRules(layoutDirection);
        if (params.mLeft == Integer.MIN_VALUE && params.mRight != Integer.MIN_VALUE) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft != Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft == Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[14] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerHorizontal(child, params, myWidth);
                } else {
                    this.positionAtEdge(child, params, myWidth);
                }
                return true;
            }
            this.positionAtEdge(child, params, myWidth);
        }
        return rules[21] != 0;
    }

    private final void $$robo$$android_widget_RelativeLayout$positionAtEdge(View child, LayoutParams params, int myWidth) {
        if (this.isLayoutRtl()) {
            params.mRight = myWidth - this.mPaddingRight - params.rightMargin;
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else {
            params.mLeft = this.mPaddingLeft + params.leftMargin;
            params.mRight = params.mLeft + child.getMeasuredWidth();
        }
    }

    private final boolean $$robo$$android_widget_RelativeLayout$positionChildVertical(View child, LayoutParams params, int myHeight, boolean wrapContent) {
        int[] rules = params.getRules();
        if (params.mTop == Integer.MIN_VALUE && params.mBottom != Integer.MIN_VALUE) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop != Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop == Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[15] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerVertical(child, params, myHeight);
                } else {
                    params.mTop = this.mPaddingTop + params.topMargin;
                    params.mBottom = params.mTop + child.getMeasuredHeight();
                }
                return true;
            }
            params.mTop = this.mPaddingTop + params.topMargin;
            params.mBottom = params.mTop + child.getMeasuredHeight();
        }
        return rules[12] != 0;
    }

    private final void $$robo$$android_widget_RelativeLayout$applyHorizontalSizeRules(LayoutParams childParams, int myWidth, int[] rules) {
        childParams.mLeft = Integer.MIN_VALUE;
        childParams.mRight = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (childParams.alignWithParent && rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (childParams.alignWithParent && rules[1] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (childParams.alignWithParent && rules[5] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (childParams.alignWithParent && rules[7] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        if (0 != rules[9]) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        if (0 != rules[11] && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
    }

    private final void $$robo$$android_widget_RelativeLayout$applyVerticalSizeRules(LayoutParams childParams, int myHeight, int myBaseline) {
        int[] rules = childParams.getRules();
        int baselineOffset = this.getRelatedViewBaselineOffset(rules);
        if (baselineOffset != -1) {
            if (myBaseline != -1) {
                baselineOffset -= myBaseline;
            }
            childParams.mTop = baselineOffset;
            childParams.mBottom = Integer.MIN_VALUE;
            return;
        }
        childParams.mTop = Integer.MIN_VALUE;
        childParams.mBottom = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (childParams.alignWithParent && rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (childParams.alignWithParent && rules[3] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (childParams.alignWithParent && rules[6] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 8);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (childParams.alignWithParent && rules[8] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (0 != rules[10]) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        if (0 != rules[12] && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
    }

    private final View $$robo$$android_widget_RelativeLayout$getRelatedView(int[] rules, int relation) {
        int id2 = rules[relation];
        if (id2 != 0) {
            DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(id2);
            if (node == null) {
                return null;
            }
            View v = node.view;
            while (v.getVisibility() == 8) {
                rules = ((LayoutParams)v.getLayoutParams()).getRules(v.getLayoutDirection());
                node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(rules[relation]);
                if (node == null || v == node.view) {
                    return null;
                }
                v = node.view;
            }
            return v;
        }
        return null;
    }

    private final LayoutParams $$robo$$android_widget_RelativeLayout$getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    private final int $$robo$$android_widget_RelativeLayout$getRelatedViewBaselineOffset(int[] rules) {
        ViewGroup.LayoutParams params;
        int baseline;
        View v = this.getRelatedView(rules, 4);
        if (v != null && (baseline = v.getBaseline()) != -1 && (params = v.getLayoutParams()) instanceof LayoutParams) {
            LayoutParams anchorParams = (LayoutParams)v.getLayoutParams();
            return anchorParams.mTop + baseline;
        }
        return -1;
    }

    private static final void $$robo$$android_widget_RelativeLayout$centerHorizontal(View child, LayoutParams params, int myWidth) {
        int childWidth = child.getMeasuredWidth();
        int left = (myWidth - childWidth) / 2;
        params.mLeft = left;
        params.mRight = left + childWidth;
    }

    private static final void $$robo$$android_widget_RelativeLayout$centerVertical(View child, LayoutParams params, int myHeight) {
        int childHeight = child.getMeasuredHeight();
        int top = (myHeight - childHeight) / 2;
        params.mTop = top;
        params.mBottom = top + childHeight;
    }

    private final void $$robo$$android_widget_RelativeLayout$onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams st = (LayoutParams)child.getLayoutParams();
            child.layout(st.mLeft, st.mTop, st.mRight, st.mBottom);
        }
    }

    private final LayoutParams $$robo$$android_widget_RelativeLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_RelativeLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    private final boolean $$robo$$android_widget_RelativeLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_RelativeLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (sPreserveMarginParamsInLayoutParamConversion) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
        }
        return new LayoutParams(lp);
    }

    private final boolean $$robo$$android_widget_RelativeLayout$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        if (this.mTopToBottomLeftToRightSet == null) {
            this.mTopToBottomLeftToRightSet = new TreeSet<View>(new TopToBottomLeftToRightComparator(this, null));
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mTopToBottomLeftToRightSet.add(this.getChildAt(i));
        }
        for (View view : this.mTopToBottomLeftToRightSet) {
            if (view.getVisibility() != 0 || !view.dispatchPopulateAccessibilityEvent(event)) continue;
            this.mTopToBottomLeftToRightSet.clear();
            return true;
        }
        this.mTopToBottomLeftToRightSet.clear();
        return false;
    }

    private final CharSequence $$robo$$android_widget_RelativeLayout$getAccessibilityClassName() {
        return RelativeLayout.class.getName();
    }

    static void __staticInitializer__() {
        RULES_VERTICAL = new int[]{2, 3, 4, 6, 8};
        RULES_HORIZONTAL = new int[]{0, 1, 5, 7, 16, 17, 18, 19};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_RelativeLayout$__constructor__(context);
    }

    public RelativeLayout(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_RelativeLayout$__constructor__(context, attributeSet);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_RelativeLayout$__constructor__(context, attributeSet, n);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_RelativeLayout$__constructor__(context, attributeSet, n, n2);
    }

    public RelativeLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void initFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        InvokeDynamicSupport.bootstrap("initFromAttributes", $$robo$$android_widget_RelativeLayout$initFromAttributes(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void queryCompatibilityModes(Context context) {
        InvokeDynamicSupport.bootstrap("queryCompatibilityModes", $$robo$$android_widget_RelativeLayout$queryCompatibilityModes(android.content.Context ), this, context);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_RelativeLayout$shouldDelayChildPressedState(), this);
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int n) {
        InvokeDynamicSupport.bootstrap("setIgnoreGravity", $$robo$$android_widget_RelativeLayout$setIgnoreGravity(int ), this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_RelativeLayout$getGravity(), this);
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_RelativeLayout$setGravity(int ), this, n);
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalGravity", $$robo$$android_widget_RelativeLayout$setHorizontalGravity(int ), this, n);
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalGravity", $$robo$$android_widget_RelativeLayout$setVerticalGravity(int ), this, n);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_RelativeLayout$getBaseline(), this);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_RelativeLayout$requestLayout(), this);
    }

    private void sortChildren() {
        InvokeDynamicSupport.bootstrap("sortChildren", $$robo$$android_widget_RelativeLayout$sortChildren(), this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_RelativeLayout$onMeasure(int int ), this, n, n2);
    }

    private int compareLayoutPosition(LayoutParams layoutParams, LayoutParams layoutParams2) {
        return (int)InvokeDynamicSupport.bootstrap("compareLayoutPosition", $$robo$$android_widget_RelativeLayout$compareLayoutPosition(android.widget.RelativeLayout$LayoutParams android.widget.RelativeLayout$LayoutParams ), this, layoutParams, layoutParams2);
    }

    private void measureChild(View view, LayoutParams layoutParams, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChild", $$robo$$android_widget_RelativeLayout$measureChild(android.view.View android.widget.RelativeLayout$LayoutParams int int ), this, view, layoutParams, n, n2);
    }

    private void measureChildHorizontal(View view, LayoutParams layoutParams, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChildHorizontal", $$robo$$android_widget_RelativeLayout$measureChildHorizontal(android.view.View android.widget.RelativeLayout$LayoutParams int int ), this, view, layoutParams, n, n2);
    }

    private int getChildMeasureSpec(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (int)InvokeDynamicSupport.bootstrap("getChildMeasureSpec", $$robo$$android_widget_RelativeLayout$getChildMeasureSpec(int int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private boolean positionChildHorizontal(View view, LayoutParams layoutParams, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("positionChildHorizontal", $$robo$$android_widget_RelativeLayout$positionChildHorizontal(android.view.View android.widget.RelativeLayout$LayoutParams int boolean ), this, view, layoutParams, n, bl);
    }

    private void positionAtEdge(View view, LayoutParams layoutParams, int n) {
        InvokeDynamicSupport.bootstrap("positionAtEdge", $$robo$$android_widget_RelativeLayout$positionAtEdge(android.view.View android.widget.RelativeLayout$LayoutParams int ), this, view, layoutParams, n);
    }

    private boolean positionChildVertical(View view, LayoutParams layoutParams, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("positionChildVertical", $$robo$$android_widget_RelativeLayout$positionChildVertical(android.view.View android.widget.RelativeLayout$LayoutParams int boolean ), this, view, layoutParams, n, bl);
    }

    private void applyHorizontalSizeRules(LayoutParams layoutParams, int n, int[] nArray) {
        InvokeDynamicSupport.bootstrap("applyHorizontalSizeRules", $$robo$$android_widget_RelativeLayout$applyHorizontalSizeRules(android.widget.RelativeLayout$LayoutParams int int[] ), this, layoutParams, n, nArray);
    }

    private void applyVerticalSizeRules(LayoutParams layoutParams, int n, int n2) {
        InvokeDynamicSupport.bootstrap("applyVerticalSizeRules", $$robo$$android_widget_RelativeLayout$applyVerticalSizeRules(android.widget.RelativeLayout$LayoutParams int int ), this, layoutParams, n, n2);
    }

    private View getRelatedView(int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrap("getRelatedView", $$robo$$android_widget_RelativeLayout$getRelatedView(int[] int ), this, nArray, n);
    }

    private LayoutParams getRelatedViewParams(int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrap("getRelatedViewParams", $$robo$$android_widget_RelativeLayout$getRelatedViewParams(int[] int ), this, nArray, n);
    }

    private int getRelatedViewBaselineOffset(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getRelatedViewBaselineOffset", $$robo$$android_widget_RelativeLayout$getRelatedViewBaselineOffset(int[] ), this, nArray);
    }

    private static void centerHorizontal(View view, LayoutParams layoutParams, int n) {
        InvokeDynamicSupport.bootstrapStatic("centerHorizontal", $$robo$$android_widget_RelativeLayout$centerHorizontal(android.view.View android.widget.RelativeLayout$LayoutParams int ), (View)view, (LayoutParams)layoutParams, (int)n);
    }

    private static void centerVertical(View view, LayoutParams layoutParams, int n) {
        InvokeDynamicSupport.bootstrapStatic("centerVertical", $$robo$$android_widget_RelativeLayout$centerVertical(android.view.View android.widget.RelativeLayout$LayoutParams int ), (View)view, (LayoutParams)layoutParams, (int)n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_RelativeLayout$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_RelativeLayout$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_RelativeLayout$generateDefaultLayoutParams(), this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_RelativeLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_RelativeLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$android_widget_RelativeLayout$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_RelativeLayout$getAccessibilityClassName(), this);
    }

    static {
        RobolectricInternals.classInitializing(RelativeLayout.class);
    }

    public /* synthetic */ RelativeLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DependencyGraph
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArrayList<Node> mNodes;
        private SparseArray<Node> mKeyNodes;
        private ArrayDeque<Node> mRoots;

        private void $$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__() {
            this.mNodes = new ArrayList();
            this.mKeyNodes = new SparseArray();
            this.mRoots = new ArrayDeque();
        }

        private final void $$robo$$android_widget_RelativeLayout_DependencyGraph$clear() {
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (int i = 0; i < count; ++i) {
                nodes.get(i).release();
            }
            nodes.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        private final void $$robo$$android_widget_RelativeLayout_DependencyGraph$add(View view) {
            int id2 = view.getId();
            Node node = Node.acquire(view);
            if (id2 != -1) {
                this.mKeyNodes.put(id2, node);
            }
            this.mNodes.add(node);
        }

        private final void $$robo$$android_widget_RelativeLayout_DependencyGraph$getSortedViews(View[] sorted, int ... rules) {
            Node node;
            ArrayDeque<Node> roots = this.findRoots(rules);
            int index = 0;
            while ((node = roots.pollLast()) != null) {
                View view = node.view;
                int key = view.getId();
                sorted[index++] = view;
                ArrayMap<Node, DependencyGraph> dependents = node.dependents;
                int count = dependents.size();
                for (int i = 0; i < count; ++i) {
                    Node dependent = dependents.keyAt(i);
                    SparseArray<Node> dependencies = dependent.dependencies;
                    dependencies.remove(key);
                    if (dependencies.size() != 0) continue;
                    roots.add(dependent);
                }
            }
            if (index < sorted.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        private final ArrayDeque<Node> $$robo$$android_widget_RelativeLayout_DependencyGraph$findRoots(int[] rulesFilter) {
            Node node;
            int i;
            SparseArray<Node> keyNodes = this.mKeyNodes;
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                node.dependents.clear();
                node.dependencies.clear();
            }
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                LayoutParams layoutParams = (LayoutParams)node.view.getLayoutParams();
                int[] rules = layoutParams.mRules;
                int rulesCount = rulesFilter.length;
                for (int j = 0; j < rulesCount; ++j) {
                    Node dependency;
                    int rule = rules[rulesFilter[j]];
                    if (rule <= 0 || (dependency = keyNodes.get(rule)) == null || dependency == node) continue;
                    dependency.dependents.put(node, this);
                    node.dependencies.put(rule, dependency);
                }
            }
            ArrayDeque<Node> roots = this.mRoots;
            roots.clear();
            for (int i2 = 0; i2 < count; ++i2) {
                Node node2 = nodes.get(i2);
                if (node2.dependencies.size() != 0) continue;
                roots.addLast(node2);
            }
            return roots;
        }

        private /* synthetic */ void $$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__();
        }

        public DependencyGraph() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__(), this);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_widget_RelativeLayout_DependencyGraph$clear(), this);
        }

        void add(View view) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_widget_RelativeLayout_DependencyGraph$add(android.view.View ), this, view);
        }

        void getSortedViews(View[] viewArray, int ... nArray) {
            InvokeDynamicSupport.bootstrap("getSortedViews", $$robo$$android_widget_RelativeLayout_DependencyGraph$getSortedViews(android.view.View[] int[] ), this, viewArray, nArray);
        }

        private ArrayDeque<Node> findRoots(int[] nArray) {
            return InvokeDynamicSupport.bootstrap("findRoots", $$robo$$android_widget_RelativeLayout_DependencyGraph$findRoots(int[] ), this, nArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__(var1_1);
        }

        public /* synthetic */ DependencyGraph(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_DependencyGraph$__constructor__(android.widget.RelativeLayout$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DependencyGraph)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Node
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            View view;
            ArrayMap<Node, DependencyGraph> dependents;
            SparseArray<Node> dependencies;
            private static int POOL_LIMIT = 100;
            private static Pools.SynchronizedPool<Node> sPool;

            private void $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$__constructor__() {
                this.dependents = new ArrayMap();
                this.dependencies = new SparseArray();
            }

            private static final Node $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$acquire(View view) {
                Node node = sPool.acquire();
                if (node == null) {
                    node = new Node();
                }
                node.view = view;
                return node;
            }

            private final void $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }

            static void __staticInitializer__() {
                sPool = new Pools.SynchronizedPool(100);
            }

            private void __constructor__() {
                this.$$robo$$android_widget_RelativeLayout_DependencyGraph_Node$__constructor__();
            }

            public Node() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$__constructor__(), this);
            }

            static Node acquire(View view) {
                return InvokeDynamicSupport.bootstrapStatic("acquire", $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$acquire(android.view.View ), (View)view);
            }

            void release() {
                InvokeDynamicSupport.bootstrap("release", $$robo$$android_widget_RelativeLayout_DependencyGraph_Node$release(), this);
            }

            static {
                RobolectricInternals.classInitializing(Node.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout", resolveId=true, indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf"), @ViewDebug.IntToString(from=18, to="alignStart"), @ViewDebug.IntToString(from=19, to="alignEnd"), @ViewDebug.IntToString(from=20, to="alignParentStart"), @ViewDebug.IntToString(from=21, to="alignParentEnd"), @ViewDebug.IntToString(from=16, to="startOf"), @ViewDebug.IntToString(from=17, to="endOf")}, mapping={@ViewDebug.IntToString(from=-1, to="true"), @ViewDebug.IntToString(from=0, to="false/NO_ID")})
        private int[] mRules;
        private int[] mInitialRules;
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        private boolean mNeedsLayoutResolution;
        private boolean mRulesChanged;
        private boolean mIsRtlCompatibilityMode;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean alignWithParent;

        private void $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.mRules = new int[22];
            this.mInitialRules = new int[22];
            this.mRulesChanged = false;
            this.mIsRtlCompatibilityMode = false;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.RelativeLayout_Layout);
            int targetSdkVersion = c.getApplicationInfo().targetSdkVersion;
            this.mIsRtlCompatibilityMode = targetSdkVersion < 17 || !c.getApplicationInfo().hasRtlSupport();
            int[] rules = this.mRules;
            int[] initialRules = this.mInitialRules;
            int N = a.getIndexCount();
            block25: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (attr2) {
                    case 16: {
                        this.alignWithParent = a.getBoolean(attr2, false);
                        continue block25;
                    }
                    case 0: {
                        rules[0] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 1: {
                        rules[1] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 2: {
                        rules[2] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 3: {
                        rules[3] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 4: {
                        rules[4] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 5: {
                        rules[5] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 6: {
                        rules[6] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 7: {
                        rules[7] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 8: {
                        rules[8] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 9: {
                        rules[9] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 10: {
                        rules[10] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 11: {
                        rules[11] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 12: {
                        rules[12] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 13: {
                        rules[13] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 14: {
                        rules[14] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 15: {
                        rules[15] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 17: {
                        rules[16] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 18: {
                        rules[17] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 19: {
                        rules[18] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 20: {
                        rules[19] = a.getResourceId(attr2, 0);
                        continue block25;
                    }
                    case 21: {
                        rules[20] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block25;
                    }
                    case 22: {
                        rules[21] = a.getBoolean(attr2, false) ? -1 : 0;
                    }
                }
            }
            this.mRulesChanged = true;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)rules, (int)0, (Object)initialRules, (int)0, (int)22);
            a.recycle();
        }

        private void $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(int w, int h) {
            this.mRules = new int[22];
            this.mInitialRules = new int[22];
            this.mRulesChanged = false;
            this.mIsRtlCompatibilityMode = false;
        }

        private void $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
            this.mRules = new int[22];
            this.mInitialRules = new int[22];
            this.mRulesChanged = false;
            this.mIsRtlCompatibilityMode = false;
        }

        private void $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.mRules = new int[22];
            this.mInitialRules = new int[22];
            this.mRulesChanged = false;
            this.mIsRtlCompatibilityMode = false;
        }

        private void $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.mRules = new int[22];
            this.mInitialRules = new int[22];
            this.mRulesChanged = false;
            this.mIsRtlCompatibilityMode = false;
            this.mIsRtlCompatibilityMode = source.mIsRtlCompatibilityMode;
            this.mRulesChanged = source.mRulesChanged;
            this.alignWithParent = source.alignWithParent;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)source.mRules, (int)0, (Object)this.mRules, (int)0, (int)22);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)source.mInitialRules, (int)0, (Object)this.mInitialRules, (int)0, (int)22);
        }

        private final String $$robo$$android_widget_RelativeLayout_LayoutParams$debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$addRule(int verb) {
            this.addRule(verb, -1);
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$addRule(int verb, int subject) {
            if (!this.mNeedsLayoutResolution && this.isRelativeRule(verb) && this.mInitialRules[verb] != 0 && subject == 0) {
                this.mNeedsLayoutResolution = true;
            }
            this.mRules[verb] = subject;
            this.mInitialRules[verb] = subject;
            this.mRulesChanged = true;
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$removeRule(int verb) {
            this.addRule(verb, 0);
        }

        private final int $$robo$$android_widget_RelativeLayout_LayoutParams$getRule(int verb) {
            return this.mRules[verb];
        }

        private final boolean $$robo$$android_widget_RelativeLayout_LayoutParams$hasRelativeRules() {
            return this.mInitialRules[16] != 0 || this.mInitialRules[17] != 0 || this.mInitialRules[18] != 0 || this.mInitialRules[19] != 0 || this.mInitialRules[20] != 0 || this.mInitialRules[21] != 0;
        }

        private final boolean $$robo$$android_widget_RelativeLayout_LayoutParams$isRelativeRule(int rule) {
            return rule == 16 || rule == 17 || rule == 18 || rule == 19 || rule == 20 || rule == 21;
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$resolveRules(int layoutDirection) {
            boolean isLayoutRtl = layoutDirection == 1;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mInitialRules, (int)0, (Object)this.mRules, (int)0, (int)22);
            if (this.mIsRtlCompatibilityMode) {
                if (this.mRules[18] != 0) {
                    if (this.mRules[5] == 0) {
                        this.mRules[5] = this.mRules[18];
                    }
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    if (this.mRules[7] == 0) {
                        this.mRules[7] = this.mRules[19];
                    }
                    this.mRules[19] = 0;
                }
                if (this.mRules[16] != 0) {
                    if (this.mRules[0] == 0) {
                        this.mRules[0] = this.mRules[16];
                    }
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    if (this.mRules[1] == 0) {
                        this.mRules[1] = this.mRules[17];
                    }
                    this.mRules[17] = 0;
                }
                if (this.mRules[20] != 0) {
                    if (this.mRules[9] == 0) {
                        this.mRules[9] = this.mRules[20];
                    }
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    if (this.mRules[11] == 0) {
                        this.mRules[11] = this.mRules[21];
                    }
                    this.mRules[21] = 0;
                }
            } else {
                if (!(this.mRules[18] == 0 && this.mRules[19] == 0 || this.mRules[5] == 0 && this.mRules[7] == 0)) {
                    this.mRules[5] = 0;
                    this.mRules[7] = 0;
                }
                if (this.mRules[18] != 0) {
                    this.mRules[isLayoutRtl ? 7 : 5] = this.mRules[18];
                    this.mRules[18] = 0;
                }
                if (this.mRules[19] != 0) {
                    this.mRules[isLayoutRtl ? 5 : 7] = this.mRules[19];
                    this.mRules[19] = 0;
                }
                if (!(this.mRules[16] == 0 && this.mRules[17] == 0 || this.mRules[0] == 0 && this.mRules[1] == 0)) {
                    this.mRules[0] = 0;
                    this.mRules[1] = 0;
                }
                if (this.mRules[16] != 0) {
                    this.mRules[isLayoutRtl ? 1 : 0] = this.mRules[16];
                    this.mRules[16] = 0;
                }
                if (this.mRules[17] != 0) {
                    this.mRules[isLayoutRtl ? 0 : 1] = this.mRules[17];
                    this.mRules[17] = 0;
                }
                if (!(this.mRules[20] == 0 && this.mRules[21] == 0 || this.mRules[9] == 0 && this.mRules[11] == 0)) {
                    this.mRules[9] = 0;
                    this.mRules[11] = 0;
                }
                if (this.mRules[20] != 0) {
                    this.mRules[isLayoutRtl ? 11 : 9] = this.mRules[20];
                    this.mRules[20] = 0;
                }
                if (this.mRules[21] != 0) {
                    this.mRules[isLayoutRtl ? 9 : 11] = this.mRules[21];
                    this.mRules[21] = 0;
                }
            }
            this.mRulesChanged = false;
            this.mNeedsLayoutResolution = false;
        }

        private final int[] $$robo$$android_widget_RelativeLayout_LayoutParams$getRules(int layoutDirection) {
            this.resolveLayoutDirection(layoutDirection);
            return this.mRules;
        }

        private final int[] $$robo$$android_widget_RelativeLayout_LayoutParams$getRules() {
            return this.mRules;
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$resolveLayoutDirection(int layoutDirection) {
            if (this.shouldResolveLayoutDirection(layoutDirection)) {
                this.resolveRules(layoutDirection);
            }
            super.resolveLayoutDirection(layoutDirection);
        }

        private final boolean $$robo$$android_widget_RelativeLayout_LayoutParams$shouldResolveLayoutDirection(int layoutDirection) {
            return !(!this.mNeedsLayoutResolution && !this.hasRelativeRules() || !this.mRulesChanged && layoutDirection == this.getLayoutDirection());
        }

        private final void $$robo$$android_widget_RelativeLayout_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("layout:alignWithParent", this.alignWithParent);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_LayoutParams$__constructor__(android.widget.RelativeLayout$LayoutParams ), this, layoutParams);
        }

        @Override
        public String debug(String string2) {
            return InvokeDynamicSupport.bootstrap("debug", $$robo$$android_widget_RelativeLayout_LayoutParams$debug(java.lang.String ), this, string2);
        }

        public void addRule(int n) {
            InvokeDynamicSupport.bootstrap("addRule", $$robo$$android_widget_RelativeLayout_LayoutParams$addRule(int ), this, n);
        }

        public void addRule(int n, int n2) {
            InvokeDynamicSupport.bootstrap("addRule", $$robo$$android_widget_RelativeLayout_LayoutParams$addRule(int int ), this, n, n2);
        }

        public void removeRule(int n) {
            InvokeDynamicSupport.bootstrap("removeRule", $$robo$$android_widget_RelativeLayout_LayoutParams$removeRule(int ), this, n);
        }

        public int getRule(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getRule", $$robo$$android_widget_RelativeLayout_LayoutParams$getRule(int ), this, n);
        }

        private boolean hasRelativeRules() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasRelativeRules", $$robo$$android_widget_RelativeLayout_LayoutParams$hasRelativeRules(), this);
        }

        private boolean isRelativeRule(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isRelativeRule", $$robo$$android_widget_RelativeLayout_LayoutParams$isRelativeRule(int ), this, n);
        }

        private void resolveRules(int n) {
            InvokeDynamicSupport.bootstrap("resolveRules", $$robo$$android_widget_RelativeLayout_LayoutParams$resolveRules(int ), this, n);
        }

        public int[] getRules(int n) {
            return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_widget_RelativeLayout_LayoutParams$getRules(int ), this, n);
        }

        public int[] getRules() {
            return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_widget_RelativeLayout_LayoutParams$getRules(), this);
        }

        @Override
        public void resolveLayoutDirection(int n) {
            InvokeDynamicSupport.bootstrap("resolveLayoutDirection", $$robo$$android_widget_RelativeLayout_LayoutParams$resolveLayoutDirection(int ), this, n);
        }

        private boolean shouldResolveLayoutDirection(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldResolveLayoutDirection", $$robo$$android_widget_RelativeLayout_LayoutParams$shouldResolveLayoutDirection(int ), this, n);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_RelativeLayout_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TopToBottomLeftToRightComparator
    implements Comparator<View> {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RelativeLayout this$0;

        private void $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(RelativeLayout relativeLayout) {
            this.this$0 = relativeLayout;
        }

        private final int $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$compare(View first, View second) {
            int topDifference = first.getTop() - second.getTop();
            if (topDifference != 0) {
                return topDifference;
            }
            int leftDifference = first.getLeft() - second.getLeft();
            if (leftDifference != 0) {
                return leftDifference;
            }
            int heightDiference = first.getHeight() - second.getHeight();
            if (heightDiference != 0) {
                return heightDiference;
            }
            int widthDiference = first.getWidth() - second.getWidth();
            if (widthDiference != 0) {
                return widthDiference;
            }
            return 0;
        }

        private /* synthetic */ void $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(RelativeLayout x0, 1 x1) {
        }

        private void __constructor__(RelativeLayout relativeLayout) {
            this.$$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(relativeLayout);
        }

        public TopToBottomLeftToRightComparator(RelativeLayout relativeLayout) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(android.widget.RelativeLayout ), this, relativeLayout);
        }

        @Override
        public int compare(View view, View view2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$compare(android.view.View android.view.View ), this, view, view2);
        }

        private /* synthetic */ void __constructor__(RelativeLayout relativeLayout, 1 var2_2) {
            this.$$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(relativeLayout, var2_2);
        }

        public /* synthetic */ TopToBottomLeftToRightComparator(RelativeLayout relativeLayout, 1 var2_2) {
            this(relativeLayout);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RelativeLayout_TopToBottomLeftToRightComparator$__constructor__(android.widget.RelativeLayout android.widget.RelativeLayout$1 ), this, relativeLayout, var2_2);
        }

        public /* synthetic */ TopToBottomLeftToRightComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TopToBottomLeftToRightComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

