/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.Cea708CaptionRenderer;
import android.media.ClosedCaptionRenderer;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.Metadata;
import android.media.SubtitleController;
import android.media.SubtitleTrack;
import android.media.TtmlRenderer;
import android.media.WebVttRenderer;
import android.net.Uri;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.MediaController;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VideoView
extends SurfaceView
implements MediaController.MediaPlayerControl,
SubtitleController.Anchor,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "VideoView";
    private static int STATE_ERROR = -1;
    private static int STATE_IDLE = 0;
    private static int STATE_PREPARING = 1;
    private static int STATE_PREPARED = 2;
    private static int STATE_PLAYING = 3;
    private static int STATE_PAUSED = 4;
    private static int STATE_PLAYBACK_COMPLETED = 5;
    private Vector<Pair<InputStream, MediaFormat>> mPendingSubtitleTracks;
    private Uri mUri;
    private Map<String, String> mHeaders;
    private int mCurrentState;
    private int mTargetState;
    private SurfaceHolder mSurfaceHolder;
    private MediaPlayer mMediaPlayer;
    private int mAudioSession;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private MediaController mMediaController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private AudioManager mAudioManager;
    private int mAudioFocusType;
    private AudioAttributes mAudioAttributes;
    private SubtitleTrack.RenderingWidget mSubtitleWidget;
    private SubtitleTrack.RenderingWidget.OnChangedListener mSubtitlesChangedListener;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener;
    MediaPlayer.OnPreparedListener mPreparedListener;
    private MediaPlayer.OnCompletionListener mCompletionListener;
    private MediaPlayer.OnInfoListener mInfoListener;
    private MediaPlayer.OnErrorListener mErrorListener;
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    SurfaceHolder.Callback mSHCallback;

    private void $$robo$$android_widget_VideoView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_VideoView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_VideoView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_VideoView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPendingSubtitleTracks = new Vector();
        this.mCurrentState = 0;
        this.mTargetState = 0;
        this.mSurfaceHolder = null;
        this.mMediaPlayer = null;
        this.mAudioFocusType = 1;
        this.mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_1$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_VideoView_1$onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                this.this$0.mVideoWidth = mp.getVideoWidth();
                this.this$0.mVideoHeight = mp.getVideoHeight();
                if (this.this$0.mVideoWidth != 0 && this.this$0.mVideoHeight != 0) {
                    this.this$0.getHolder().setFixedSize(this.this$0.mVideoWidth, this.this$0.mVideoHeight);
                    this.this$0.requestLayout();
                }
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_1$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_1$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onVideoSizeChanged", $$robo$$android_widget_VideoView_1$onVideoSizeChanged(android.media.MediaPlayer int int ), this, mediaPlayer, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPreparedListener = new MediaPlayer.OnPreparedListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_2$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_VideoView_2$onPrepared(MediaPlayer mp) {
                this.this$0.mCurrentState = 2;
                Metadata data = mp.getMetadata(false, false);
                if (data != null) {
                    this.this$0.mCanPause = !data.has(1) || data.getBoolean(1);
                    this.this$0.mCanSeekBack = !data.has(2) || data.getBoolean(2);
                    this.this$0.mCanSeekForward = !data.has(3) || data.getBoolean(3);
                } else {
                    this.this$0.mCanPause = (this.this$0.mCanSeekBack = (this.this$0.mCanSeekForward = true));
                }
                if (this.this$0.mOnPreparedListener != null) {
                    this.this$0.mOnPreparedListener.onPrepared(this.this$0.mMediaPlayer);
                }
                if (this.this$0.mMediaController != null) {
                    this.this$0.mMediaController.setEnabled(true);
                }
                this.this$0.mVideoWidth = mp.getVideoWidth();
                this.this$0.mVideoHeight = mp.getVideoHeight();
                int seekToPosition = this.this$0.mSeekWhenPrepared;
                if (seekToPosition != 0) {
                    this.this$0.seekTo(seekToPosition);
                }
                if (this.this$0.mVideoWidth != 0 && this.this$0.mVideoHeight != 0) {
                    this.this$0.getHolder().setFixedSize(this.this$0.mVideoWidth, this.this$0.mVideoHeight);
                    if (this.this$0.mSurfaceWidth == this.this$0.mVideoWidth && this.this$0.mSurfaceHeight == this.this$0.mVideoHeight) {
                        if (this.this$0.mTargetState == 3) {
                            this.this$0.start();
                            if (this.this$0.mMediaController != null) {
                                this.this$0.mMediaController.show();
                            }
                        } else if (!(this.this$0.isPlaying() || seekToPosition == 0 && this.this$0.getCurrentPosition() <= 0 || this.this$0.mMediaController == null)) {
                            this.this$0.mMediaController.show(0);
                        }
                    }
                } else if (this.this$0.mTargetState == 3) {
                    this.this$0.start();
                }
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_2$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_2$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                InvokeDynamicSupport.bootstrap("onPrepared", $$robo$$android_widget_VideoView_2$onPrepared(android.media.MediaPlayer ), this, mediaPlayer);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCompletionListener = new MediaPlayer.OnCompletionListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_3$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_VideoView_3$onCompletion(MediaPlayer mp) {
                this.this$0.mCurrentState = 5;
                this.this$0.mTargetState = 5;
                if (this.this$0.mMediaController != null) {
                    this.this$0.mMediaController.hide();
                }
                if (this.this$0.mOnCompletionListener != null) {
                    this.this$0.mOnCompletionListener.onCompletion(this.this$0.mMediaPlayer);
                }
                if (this.this$0.mAudioFocusType != 0) {
                    this.this$0.mAudioManager.abandonAudioFocus(null);
                }
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_3$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_3$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                InvokeDynamicSupport.bootstrap("onCompletion", $$robo$$android_widget_VideoView_3$onCompletion(android.media.MediaPlayer ), this, mediaPlayer);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mInfoListener = new MediaPlayer.OnInfoListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_4$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final boolean $$robo$$android_widget_VideoView_4$onInfo(MediaPlayer mp, int arg1, int arg2) {
                if (this.this$0.mOnInfoListener != null) {
                    this.this$0.mOnInfoListener.onInfo(mp, arg1, arg2);
                }
                return true;
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_4$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_4$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
                return (boolean)InvokeDynamicSupport.bootstrap("onInfo", $$robo$$android_widget_VideoView_4$onInfo(android.media.MediaPlayer int int ), this, mediaPlayer, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mErrorListener = new MediaPlayer.OnErrorListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_5$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final boolean $$robo$$android_widget_VideoView_5$onError(MediaPlayer mp, int framework_err, int impl_err) {
                Log.d("VideoView", "Error: " + framework_err + "," + impl_err);
                this.this$0.mCurrentState = -1;
                this.this$0.mTargetState = -1;
                if (this.this$0.mMediaController != null) {
                    this.this$0.mMediaController.hide();
                }
                if (this.this$0.mOnErrorListener != null && this.this$0.mOnErrorListener.onError(this.this$0.mMediaPlayer, framework_err, impl_err)) {
                    return true;
                }
                if (this.this$0.getWindowToken() != null) {
                    Resources r = this.this$0.mContext.getResources();
                    int messageId = framework_err == 200 ? 17039381 : 0x1040011;
                    new AlertDialog.Builder(this.this$0.mContext).setMessage(messageId).setPositiveButton(0x1040010, new DialogInterface.OnClickListener(this){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ 5 this$1;

                        private void $$robo$$android_widget_VideoView_5_1$__constructor__(5 this$1) {
                            this.this$1 = this$1;
                        }

                        private final void $$robo$$android_widget_VideoView_5_1$onClick(DialogInterface dialog, int whichButton) {
                            if (this.this$1.this$0.mOnCompletionListener != null) {
                                this.this$1.this$0.mOnCompletionListener.onCompletion(this.this$1.this$0.mMediaPlayer);
                            }
                        }

                        private void __constructor__(5 var1_1) {
                            this.$$robo$$android_widget_VideoView_5_1$__constructor__(var1_1);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_5_1$__constructor__(android.widget.VideoView$5 ), this, var1_1);
                        }

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_VideoView_5_1$onClick(android.content.DialogInterface int ), this, dialogInterface, n);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    }).setCancelable(false).show();
                }
                return true;
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_5$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_5$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                return (boolean)InvokeDynamicSupport.bootstrap("onError", $$robo$$android_widget_VideoView_5$onError(android.media.MediaPlayer int int ), this, mediaPlayer, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_6$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_VideoView_6$onBufferingUpdate(MediaPlayer mp, int percent) {
                this.this$0.mCurrentBufferPercentage = percent;
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_6$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_6$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
                InvokeDynamicSupport.bootstrap("onBufferingUpdate", $$robo$$android_widget_VideoView_6$onBufferingUpdate(android.media.MediaPlayer int ), this, mediaPlayer, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSHCallback = new SurfaceHolder.Callback(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoView this$0;

            private void $$robo$$android_widget_VideoView_7$__constructor__(VideoView this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_widget_VideoView_7$surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
                boolean hasValidSize;
                this.this$0.mSurfaceWidth = w;
                this.this$0.mSurfaceHeight = h;
                boolean isValidState = this.this$0.mTargetState == 3;
                boolean bl = hasValidSize = this.this$0.mVideoWidth == w && this.this$0.mVideoHeight == h;
                if (this.this$0.mMediaPlayer != null && isValidState && hasValidSize) {
                    if (this.this$0.mSeekWhenPrepared != 0) {
                        this.this$0.seekTo(this.this$0.mSeekWhenPrepared);
                    }
                    this.this$0.start();
                }
            }

            private final void $$robo$$android_widget_VideoView_7$surfaceCreated(SurfaceHolder holder) {
                this.this$0.mSurfaceHolder = holder;
                this.this$0.openVideo();
            }

            private final void $$robo$$android_widget_VideoView_7$surfaceDestroyed(SurfaceHolder holder) {
                this.this$0.mSurfaceHolder = null;
                if (this.this$0.mMediaController != null) {
                    this.this$0.mMediaController.hide();
                }
                this.this$0.release(true);
            }

            private void __constructor__(VideoView videoView) {
                this.$$robo$$android_widget_VideoView_7$__constructor__(videoView);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_7$__constructor__(android.widget.VideoView ), this, videoView);
            }

            @Override
            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("surfaceChanged", $$robo$$android_widget_VideoView_7$surfaceChanged(android.view.SurfaceHolder int int int ), this, surfaceHolder, n, n2, n3);
            }

            @Override
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_widget_VideoView_7$surfaceCreated(android.view.SurfaceHolder ), this, surfaceHolder);
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_widget_VideoView_7$surfaceDestroyed(android.view.SurfaceHolder ), this, surfaceHolder);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    private final void $$robo$$android_widget_VideoView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = VideoView.getDefaultSize(this.mVideoWidth, widthMeasureSpec);
        int height = VideoView.getDefaultSize(this.mVideoHeight, heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private final CharSequence $$robo$$android_widget_VideoView$getAccessibilityClassName() {
        return VideoView.class.getName();
    }

    private final int $$robo$$android_widget_VideoView$resolveAdjustedSize(int desiredSize, int measureSpec) {
        return VideoView.getDefaultSize(desiredSize, measureSpec);
    }

    private final void $$robo$$android_widget_VideoView$setVideoPath(String path) {
        this.setVideoURI(Uri.parse(path));
    }

    private final void $$robo$$android_widget_VideoView$setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    private final void $$robo$$android_widget_VideoView$setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mHeaders = headers;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_VideoView$setAudioFocusRequest(int focusGain) {
        if (focusGain != 0 && focusGain != 1 && focusGain != 2 && focusGain != 3 && focusGain != 4) {
            throw new IllegalArgumentException("Illegal audio focus type " + focusGain);
        }
        this.mAudioFocusType = focusGain;
    }

    private final void $$robo$$android_widget_VideoView$setAudioAttributes(AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAudioAttributes = attributes;
    }

    private final void $$robo$$android_widget_VideoView$addSubtitleSource(InputStream is, MediaFormat format) {
        if (this.mMediaPlayer == null) {
            this.mPendingSubtitleTracks.add(Pair.create(is, format));
        } else {
            try {
                this.mMediaPlayer.addSubtitleSource(is, format);
            }
            catch (IllegalStateException e) {
                this.mInfoListener.onInfo(this.mMediaPlayer, 901, 0);
            }
        }
    }

    private final void $$robo$$android_widget_VideoView$stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
            this.mAudioManager.abandonAudioFocus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_VideoView$openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        this.release(false);
        if (this.mAudioFocusType != 0) {
            this.mAudioManager.requestAudioFocus(null, this.mAudioAttributes, this.mAudioFocusType, 0);
        }
        try {
            this.mMediaPlayer = new MediaPlayer();
            Context context = this.getContext();
            SubtitleController controller = new SubtitleController(context, this.mMediaPlayer.getMediaTimeProvider(), this.mMediaPlayer);
            controller.registerRenderer(new WebVttRenderer(context));
            controller.registerRenderer(new TtmlRenderer(context));
            controller.registerRenderer(new Cea708CaptionRenderer(context));
            controller.registerRenderer(new ClosedCaptionRenderer(context));
            this.mMediaPlayer.setSubtitleAnchor(controller, this);
            if (this.mAudioSession != 0) {
                this.mMediaPlayer.setAudioSessionId(this.mAudioSession);
            } else {
                this.mAudioSession = this.mMediaPlayer.getAudioSessionId();
            }
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioAttributes(this.mAudioAttributes);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            for (Pair<InputStream, MediaFormat> pending : this.mPendingSubtitleTracks) {
                try {
                    this.mMediaPlayer.addSubtitleSource((InputStream)pending.first, (MediaFormat)pending.second);
                }
                catch (IllegalStateException e) {
                    this.mInfoListener.onInfo(this.mMediaPlayer, 901, 0);
                }
            }
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w("VideoView", "Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.w("VideoView", "Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        finally {
            this.mPendingSubtitleTracks.clear();
        }
    }

    private final void $$robo$$android_widget_VideoView$setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private final void $$robo$$android_widget_VideoView$attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            VideoView anchorView = this.getParent() instanceof View ? (View)((Object)this.getParent()) : this;
            this.mMediaController.setAnchorView(anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    private final void $$robo$$android_widget_VideoView$setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    private final void $$robo$$android_widget_VideoView$setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    private final void $$robo$$android_widget_VideoView$setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    private final void $$robo$$android_widget_VideoView$setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private final void $$robo$$android_widget_VideoView$release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mPendingSubtitleTracks.clear();
            this.mCurrentState = 0;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
            if (this.mAudioFocusType != 0) {
                this.mAudioManager.abandonAudioFocus(null);
            }
        }
    }

    private final boolean $$robo$$android_widget_VideoView$onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return super.onTouchEvent(ev);
    }

    private final boolean $$robo$$android_widget_VideoView$onTrackballEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return super.onTrackballEvent(ev);
    }

    private final boolean $$robo$$android_widget_VideoView$onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(keyCode, event);
    }

    private final void $$robo$$android_widget_VideoView$toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    private final void $$robo$$android_widget_VideoView$start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    private final void $$robo$$android_widget_VideoView$pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    private final void $$robo$$android_widget_VideoView$suspend() {
        this.release(false);
    }

    private final void $$robo$$android_widget_VideoView$resume() {
        this.openVideo();
    }

    private final int $$robo$$android_widget_VideoView$getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    private final int $$robo$$android_widget_VideoView$getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    private final void $$robo$$android_widget_VideoView$seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(msec);
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    private final boolean $$robo$$android_widget_VideoView$isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    private final int $$robo$$android_widget_VideoView$getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private final boolean $$robo$$android_widget_VideoView$isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    private final boolean $$robo$$android_widget_VideoView$canPause() {
        return this.mCanPause;
    }

    private final boolean $$robo$$android_widget_VideoView$canSeekBackward() {
        return this.mCanSeekBack;
    }

    private final boolean $$robo$$android_widget_VideoView$canSeekForward() {
        return this.mCanSeekForward;
    }

    private final int $$robo$$android_widget_VideoView$getAudioSessionId() {
        if (this.mAudioSession == 0) {
            MediaPlayer foo = new MediaPlayer();
            this.mAudioSession = foo.getAudioSessionId();
            foo.release();
        }
        return this.mAudioSession;
    }

    private final void $$robo$$android_widget_VideoView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onAttachedToWindow();
        }
    }

    private final void $$robo$$android_widget_VideoView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onDetachedFromWindow();
        }
    }

    private final void $$robo$$android_widget_VideoView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mSubtitleWidget != null) {
            this.measureAndLayoutSubtitleWidget();
        }
    }

    private final void $$robo$$android_widget_VideoView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mSubtitleWidget != null) {
            int saveCount = canvas.save();
            canvas.translate(this.getPaddingLeft(), this.getPaddingTop());
            this.mSubtitleWidget.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    private final void $$robo$$android_widget_VideoView$measureAndLayoutSubtitleWidget() {
        int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.mSubtitleWidget.setSize(width, height);
    }

    private final void $$robo$$android_widget_VideoView$setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
        if (this.mSubtitleWidget == subtitleWidget) {
            return;
        }
        boolean attachedToWindow = this.isAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            if (attachedToWindow) {
                this.mSubtitleWidget.onDetachedFromWindow();
            }
            this.mSubtitleWidget.setOnChangedListener(null);
        }
        this.mSubtitleWidget = subtitleWidget;
        if (subtitleWidget != null) {
            if (this.mSubtitlesChangedListener == null) {
                this.mSubtitlesChangedListener = new SubtitleTrack.RenderingWidget.OnChangedListener(this){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ VideoView this$0;

                    private void $$robo$$android_widget_VideoView_8$__constructor__(VideoView this$0) {
                        this.this$0 = this$0;
                    }

                    private final void $$robo$$android_widget_VideoView_8$onChanged(SubtitleTrack.RenderingWidget renderingWidget) {
                        this.this$0.invalidate();
                    }

                    private void __constructor__(VideoView videoView) {
                        this.$$robo$$android_widget_VideoView_8$__constructor__(videoView);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView_8$__constructor__(android.widget.VideoView ), this, videoView);
                    }

                    @Override
                    public void onChanged(SubtitleTrack.RenderingWidget renderingWidget) {
                        InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_VideoView_8$onChanged(android.media.SubtitleTrack$RenderingWidget ), this, renderingWidget);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
            this.setWillNotDraw(false);
            subtitleWidget.setOnChangedListener(this.mSubtitlesChangedListener);
            if (attachedToWindow) {
                subtitleWidget.onAttachedToWindow();
                this.requestLayout();
            }
        } else {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    private final Looper $$robo$$android_widget_VideoView$getSubtitleLooper() {
        return Looper.getMainLooper();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_VideoView$__constructor__(context);
    }

    public VideoView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_VideoView$__constructor__(context, attributeSet);
    }

    public VideoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_VideoView$__constructor__(context, attributeSet, n);
    }

    public VideoView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_VideoView$__constructor__(context, attributeSet, n, n2);
    }

    public VideoView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_VideoView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_VideoView$onMeasure(int int ), this, n, n2);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_VideoView$getAccessibilityClassName(), this);
    }

    public int resolveAdjustedSize(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("resolveAdjustedSize", $$robo$$android_widget_VideoView$resolveAdjustedSize(int int ), this, n, n2);
    }

    public void setVideoPath(String string2) {
        InvokeDynamicSupport.bootstrap("setVideoPath", $$robo$$android_widget_VideoView$setVideoPath(java.lang.String ), this, string2);
    }

    public void setVideoURI(Uri uri) {
        InvokeDynamicSupport.bootstrap("setVideoURI", $$robo$$android_widget_VideoView$setVideoURI(android.net.Uri ), this, uri);
    }

    public void setVideoURI(Uri uri, Map<String, String> map) {
        InvokeDynamicSupport.bootstrap("setVideoURI", $$robo$$android_widget_VideoView$setVideoURI(android.net.Uri java.util.Map<java.lang.String, java.lang.String> ), this, uri, map);
    }

    public void setAudioFocusRequest(int n) {
        InvokeDynamicSupport.bootstrap("setAudioFocusRequest", $$robo$$android_widget_VideoView$setAudioFocusRequest(int ), this, n);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_widget_VideoView$setAudioAttributes(android.media.AudioAttributes ), this, audioAttributes);
    }

    public void addSubtitleSource(InputStream inputStream, MediaFormat mediaFormat) {
        InvokeDynamicSupport.bootstrap("addSubtitleSource", $$robo$$android_widget_VideoView$addSubtitleSource(java.io.InputStream android.media.MediaFormat ), this, inputStream, mediaFormat);
    }

    public void stopPlayback() {
        InvokeDynamicSupport.bootstrap("stopPlayback", $$robo$$android_widget_VideoView$stopPlayback(), this);
    }

    private void openVideo() {
        InvokeDynamicSupport.bootstrap("openVideo", $$robo$$android_widget_VideoView$openVideo(), this);
    }

    public void setMediaController(MediaController mediaController) {
        InvokeDynamicSupport.bootstrap("setMediaController", $$robo$$android_widget_VideoView$setMediaController(android.widget.MediaController ), this, mediaController);
    }

    private void attachMediaController() {
        InvokeDynamicSupport.bootstrap("attachMediaController", $$robo$$android_widget_VideoView$attachMediaController(), this);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        InvokeDynamicSupport.bootstrap("setOnPreparedListener", $$robo$$android_widget_VideoView$setOnPreparedListener(android.media.MediaPlayer$OnPreparedListener ), this, onPreparedListener);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        InvokeDynamicSupport.bootstrap("setOnCompletionListener", $$robo$$android_widget_VideoView$setOnCompletionListener(android.media.MediaPlayer$OnCompletionListener ), this, onCompletionListener);
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        InvokeDynamicSupport.bootstrap("setOnErrorListener", $$robo$$android_widget_VideoView$setOnErrorListener(android.media.MediaPlayer$OnErrorListener ), this, onErrorListener);
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener onInfoListener) {
        InvokeDynamicSupport.bootstrap("setOnInfoListener", $$robo$$android_widget_VideoView$setOnInfoListener(android.media.MediaPlayer$OnInfoListener ), this, onInfoListener);
    }

    private void release(boolean bl) {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_widget_VideoView$release(boolean ), this, bl);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_VideoView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_widget_VideoView$onTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_VideoView$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    private void toggleMediaControlsVisiblity() {
        InvokeDynamicSupport.bootstrap("toggleMediaControlsVisiblity", $$robo$$android_widget_VideoView$toggleMediaControlsVisiblity(), this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_VideoView$start(), this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_widget_VideoView$pause(), this);
    }

    public void suspend() {
        InvokeDynamicSupport.bootstrap("suspend", $$robo$$android_widget_VideoView$suspend(), this);
    }

    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_widget_VideoView$resume(), this);
    }

    @Override
    public int getDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_widget_VideoView$getDuration(), this);
    }

    @Override
    public int getCurrentPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPosition", $$robo$$android_widget_VideoView$getCurrentPosition(), this);
    }

    @Override
    public void seekTo(int n) {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_widget_VideoView$seekTo(int ), this, n);
    }

    @Override
    public boolean isPlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaying", $$robo$$android_widget_VideoView$isPlaying(), this);
    }

    @Override
    public int getBufferPercentage() {
        return (int)InvokeDynamicSupport.bootstrap("getBufferPercentage", $$robo$$android_widget_VideoView$getBufferPercentage(), this);
    }

    private boolean isInPlaybackState() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInPlaybackState", $$robo$$android_widget_VideoView$isInPlaybackState(), this);
    }

    @Override
    public boolean canPause() {
        return (boolean)InvokeDynamicSupport.bootstrap("canPause", $$robo$$android_widget_VideoView$canPause(), this);
    }

    @Override
    public boolean canSeekBackward() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSeekBackward", $$robo$$android_widget_VideoView$canSeekBackward(), this);
    }

    @Override
    public boolean canSeekForward() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSeekForward", $$robo$$android_widget_VideoView$canSeekForward(), this);
    }

    @Override
    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_widget_VideoView$getAudioSessionId(), this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_VideoView$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_VideoView$onDetachedFromWindow(), this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_VideoView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_VideoView$draw(android.graphics.Canvas ), this, canvas);
    }

    private void measureAndLayoutSubtitleWidget() {
        InvokeDynamicSupport.bootstrap("measureAndLayoutSubtitleWidget", $$robo$$android_widget_VideoView$measureAndLayoutSubtitleWidget(), this);
    }

    @Override
    public void setSubtitleWidget(SubtitleTrack.RenderingWidget renderingWidget) {
        InvokeDynamicSupport.bootstrap("setSubtitleWidget", $$robo$$android_widget_VideoView$setSubtitleWidget(android.media.SubtitleTrack$RenderingWidget ), this, renderingWidget);
    }

    @Override
    public Looper getSubtitleLooper() {
        return InvokeDynamicSupport.bootstrap("getSubtitleLooper", $$robo$$android_widget_VideoView$getSubtitleLooper(), this);
    }

    public /* synthetic */ VideoView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

