/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.Quantizer;
import com.android.internal.ml.clustering.KMeans;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VariationalKMeansQuantizer
implements Quantizer,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "KMeansQuantizer";
    private static boolean DEBUG = false;
    private float mMinClusterSqDistance;
    private int mInitializations;
    private KMeans mKMeans;
    private List<Palette.Swatch> mQuantizedColors;

    private void $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__() {
    }

    private void $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(float minClusterDistance) {
    }

    private void $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(float minClusterDistance, int initializations) {
        this.mKMeans = new KMeans(new Random(0L), 30, 0.0f);
        this.mMinClusterSqDistance = minClusterDistance * minClusterDistance;
        this.mInitializations = initializations;
    }

    private final void $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$quantize(int[] pixels, int maxColors, Palette.Filter[] filters) {
        float[] hsl = new float[]{0.0f, 0.0f, 0.0f};
        float[][] hslPixels = new float[pixels.length][3];
        for (int i = 0; i < pixels.length; ++i) {
            ColorUtils.colorToHSL(pixels[i], hsl);
            hslPixels[i][0] = hsl[0] / 360.0f;
            hslPixels[i][1] = hsl[1];
            hslPixels[i][2] = hsl[2];
        }
        List<KMeans.Mean> optimalMeans = this.getOptimalKMeans(maxColors, hslPixels);
        for (int i = 0; i < optimalMeans.size(); ++i) {
            KMeans.Mean current = optimalMeans.get(i);
            float[] currentCentroid = current.getCentroid();
            for (int j = i + 1; j < optimalMeans.size(); ++j) {
                KMeans.Mean compareTo = optimalMeans.get(j);
                float[] compareToCentroid = compareTo.getCentroid();
                float sqDistance = KMeans.sqDistance(currentCentroid, compareToCentroid);
                if (!(sqDistance < this.mMinClusterSqDistance)) continue;
                optimalMeans.remove(compareTo);
                current.getItems().addAll(compareTo.getItems());
                for (int k = 0; k < currentCentroid.length; ++k) {
                    int n = k;
                    currentCentroid[n] = (float)((double)currentCentroid[n] + (double)(compareToCentroid[k] - currentCentroid[k]) / 2.0);
                }
                --j;
            }
        }
        this.mQuantizedColors = new ArrayList<Palette.Swatch>();
        for (KMeans.Mean mean : optimalMeans) {
            if (mean.getItems().size() == 0) continue;
            float[] centroid = mean.getCentroid();
            this.mQuantizedColors.add(new Palette.Swatch(new float[]{centroid[0] * 360.0f, centroid[1], centroid[2]}, mean.getItems().size()));
        }
    }

    private final List<KMeans.Mean> $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$getOptimalKMeans(int k, float[][] inputData) {
        List<KMeans.Mean> optimal = null;
        double optimalScore = -1.7976931348623157E308;
        for (int runs = this.mInitializations; runs > 0; --runs) {
            List<KMeans.Mean> means = this.mKMeans.predict(k, inputData);
            double score = KMeans.score(means);
            if (optimal != null && !(score > optimalScore)) continue;
            optimalScore = score;
            optimal = means;
        }
        return optimal;
    }

    private final List<Palette.Swatch> $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$getQuantizedColors() {
        return this.mQuantizedColors;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__();
    }

    public VariationalKMeansQuantizer() {
        this(0.25f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(), this);
    }

    private void __constructor__(float f) {
        this.$$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(f);
    }

    public VariationalKMeansQuantizer(float f) {
        this(f, 1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(float ), this, f);
    }

    private void __constructor__(float f, int n) {
        this.$$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(f, n);
    }

    public VariationalKMeansQuantizer(float f, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$__constructor__(float int ), this, f, n);
    }

    @Override
    public void quantize(int[] nArray, int n, Palette.Filter[] filterArray) {
        InvokeDynamicSupport.bootstrap("quantize", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$quantize(int[] int com.android.internal.graphics.palette.Palette$Filter[] ), this, nArray, n, filterArray);
    }

    private List<KMeans.Mean> getOptimalKMeans(int n, float[][] fArray) {
        return InvokeDynamicSupport.bootstrap("getOptimalKMeans", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$getOptimalKMeans(int float[][] ), this, n, fArray);
    }

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return InvokeDynamicSupport.bootstrap("getQuantizedColors", $$robo$$com_android_internal_graphics_palette_VariationalKMeansQuantizer$getQuantizedColors(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VariationalKMeansQuantizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

