/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BluetoothPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "BluetoothPowerCalculator";
    private double mIdleMa;
    private double mRxMa;
    private double mTxMa;
    private double mAppTotalPowerMah;
    private long mAppTotalTimeMs;

    private void $$robo$$com_android_internal_os_BluetoothPowerCalculator$__constructor__(PowerProfile profile) {
        this.mAppTotalPowerMah = 0.0;
        this.mAppTotalTimeMs = 0L;
        this.mIdleMa = profile.getAveragePower("bluetooth.controller.idle");
        this.mRxMa = profile.getAveragePower("bluetooth.controller.rx");
        this.mTxMa = profile.getAveragePower("bluetooth.controller.tx");
    }

    private final void $$robo$$com_android_internal_os_BluetoothPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = u.getBluetoothControllerActivity();
        if (counter == null) {
            return;
        }
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long totalTimeMs = idleTimeMs + txTimeMs + rxTimeMs;
        double powerMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerMah == 0.0) {
            powerMah = ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
        }
        app.bluetoothPowerMah = powerMah;
        app.bluetoothRunningTimeMs = totalTimeMs;
        app.btRxBytes = u.getNetworkActivityBytes(4, statsType);
        app.btTxBytes = u.getNetworkActivityBytes(5, statsType);
        this.mAppTotalPowerMah += powerMah;
        this.mAppTotalTimeMs += totalTimeMs;
    }

    private final void $$robo$$com_android_internal_os_BluetoothPowerCalculator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = stats.getBluetoothControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        long totalTimeMs = idleTimeMs + txTimeMs + rxTimeMs;
        double powerMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerMah == 0.0) {
            powerMah = ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
        }
        app.bluetoothPowerMah = powerMah = Math.max(0.0, powerMah - this.mAppTotalPowerMah);
        app.bluetoothRunningTimeMs = Math.max(0L, totalTimeMs - this.mAppTotalTimeMs);
    }

    private final void $$robo$$com_android_internal_os_BluetoothPowerCalculator$reset() {
        this.mAppTotalPowerMah = 0.0;
        this.mAppTotalTimeMs = 0L;
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_BluetoothPowerCalculator$__constructor__(powerProfile);
    }

    public BluetoothPowerCalculator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BluetoothPowerCalculator$__constructor__(com.android.internal.os.PowerProfile ), this, powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_BluetoothPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_BluetoothPowerCalculator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), this, batterySipper, batteryStats, l, l2, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BluetoothPowerCalculator$reset(), this);
    }

    public /* synthetic */ BluetoothPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

