/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelCpuProcReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "KernelCpuProcReader";
    private static int ERROR_THRESHOLD = 5;
    private static long DEFAULT_THROTTLE_INTERVAL = 3000L;
    private static int INITIAL_BUFFER_SIZE = 8192;
    private static int MAX_BUFFER_SIZE = 0x100000;
    private static String PROC_UID_FREQ_TIME = "/proc/uid_cpupower/time_in_state";
    private static String PROC_UID_ACTIVE_TIME = "/proc/uid_cpupower/concurrent_active_time";
    private static String PROC_UID_CLUSTER_TIME = "/proc/uid_cpupower/concurrent_policy_time";
    private static KernelCpuProcReader mFreqTimeReader;
    private static KernelCpuProcReader mActiveTimeReader;
    private static KernelCpuProcReader mClusterTimeReader;
    private int mErrors;
    private long mThrottleInterval;
    private long mLastReadTime;
    private Path mProc;
    private ByteBuffer mBuffer;

    private static final KernelCpuProcReader $$robo$$com_android_internal_os_KernelCpuProcReader$getFreqTimeReaderInstance() {
        return mFreqTimeReader;
    }

    private static final KernelCpuProcReader $$robo$$com_android_internal_os_KernelCpuProcReader$getActiveTimeReaderInstance() {
        return mActiveTimeReader;
    }

    private static final KernelCpuProcReader $$robo$$com_android_internal_os_KernelCpuProcReader$getClusterTimeReaderInstance() {
        return mClusterTimeReader;
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_os_KernelCpuProcReader$__constructor__(String procFile) {
        this.mThrottleInterval = 3000L;
        this.mLastReadTime = Long.MIN_VALUE;
        this.mProc = Paths.get(procFile, new String[0]);
        this.mBuffer = ByteBuffer.allocateDirect(8192);
        this.mBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer $$robo$$com_android_internal_os_KernelCpuProcReader$readBytes() {
        Throwable throwable;
        if (this.mErrors >= 5) {
            return null;
        }
        if (SystemClock.elapsedRealtime() < this.mLastReadTime + this.mThrottleInterval) {
            if (this.mBuffer.limit() > 0 && this.mBuffer.limit() < this.mBuffer.capacity()) {
                return this.mBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            }
            return null;
        }
        this.mLastReadTime = SystemClock.elapsedRealtime();
        this.mBuffer.clear();
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            throwable = null;
            try (FileChannel fc = FileChannel.open(this.mProc, StandardOpenOption.READ);){
                while (true) {
                    if (fc.read(this.mBuffer) == this.mBuffer.capacity()) {
                        if (!this.resize()) {
                            ++this.mErrors;
                            Slog.e("KernelCpuProcReader", "Proc file is too large: " + this.mProc);
                            ByteBuffer byteBuffer = null;
                            return byteBuffer;
                        }
                        fc.position(0L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            ++this.mErrors;
            Slog.w("KernelCpuProcReader", "File not exist: " + this.mProc);
            throwable = null;
            return throwable;
        }
        catch (IOException e) {
            ++this.mErrors;
            Slog.e("KernelCpuProcReader", "Error reading: " + this.mProc, e);
            throwable = null;
            return throwable;
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
        this.mBuffer.flip();
        return this.mBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
    }

    private final void $$robo$$com_android_internal_os_KernelCpuProcReader$setThrottleInterval(long throttleInterval) {
        if (throttleInterval >= 0L) {
            this.mThrottleInterval = throttleInterval;
        }
    }

    private final boolean $$robo$$com_android_internal_os_KernelCpuProcReader$resize() {
        if (this.mBuffer.capacity() >= 0x100000) {
            return false;
        }
        int newSize = Math.min(this.mBuffer.capacity() << 1, 0x100000);
        this.mBuffer = ByteBuffer.allocateDirect(newSize);
        return true;
    }

    static void __staticInitializer__() {
        mFreqTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/time_in_state");
        mActiveTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_active_time");
        mClusterTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_policy_time");
    }

    public static KernelCpuProcReader getFreqTimeReaderInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getFreqTimeReaderInstance", $$robo$$com_android_internal_os_KernelCpuProcReader$getFreqTimeReaderInstance());
    }

    public static KernelCpuProcReader getActiveTimeReaderInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getActiveTimeReaderInstance", $$robo$$com_android_internal_os_KernelCpuProcReader$getActiveTimeReaderInstance());
    }

    public static KernelCpuProcReader getClusterTimeReaderInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getClusterTimeReaderInstance", $$robo$$com_android_internal_os_KernelCpuProcReader$getClusterTimeReaderInstance());
    }

    private void __constructor__(String string2) {
        this.$$robo$$com_android_internal_os_KernelCpuProcReader$__constructor__(string2);
    }

    public KernelCpuProcReader(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelCpuProcReader$__constructor__(java.lang.String ), this, string2);
    }

    public ByteBuffer readBytes() {
        return InvokeDynamicSupport.bootstrap("readBytes", $$robo$$com_android_internal_os_KernelCpuProcReader$readBytes(), this);
    }

    public void setThrottleInterval(long l) {
        InvokeDynamicSupport.bootstrap("setThrottleInterval", $$robo$$com_android_internal_os_KernelCpuProcReader$setThrottleInterval(long ), this, l);
    }

    private boolean resize() {
        return (boolean)InvokeDynamicSupport.bootstrap("resize", $$robo$$com_android_internal_os_KernelCpuProcReader$resize(), this);
    }

    static {
        RobolectricInternals.classInitializing(KernelCpuProcReader.class);
    }

    public /* synthetic */ KernelCpuProcReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelCpuProcReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

