/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelUidCpuFreqTimeReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class KernelSingleUidTimeReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String TAG;
    private boolean DBG = false;
    private String PROC_FILE_DIR = "/proc/uid/";
    private String PROC_FILE_NAME = "/time_in_state";
    @VisibleForTesting
    public static int TOTAL_READ_ERROR_COUNT = 5;
    @GuardedBy(value="this")
    private int mCpuFreqsCount;
    @GuardedBy(value="this")
    private SparseArray<long[]> mLastUidCpuTimeMs;
    @GuardedBy(value="this")
    private int mReadErrorCounter;
    @GuardedBy(value="this")
    private boolean mSingleUidCpuTimesAvailable;
    @GuardedBy(value="this")
    private boolean mHasStaleData;
    @GuardedBy(value="this")
    private boolean mCpuFreqsCountVerified;
    private Injector mInjector;

    private void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(int cpuFreqsCount) {
    }

    private void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(int cpuFreqsCount, Injector injector) {
        this.TAG = KernelUidCpuFreqTimeReader.class.getName();
        this.DBG = false;
        this.PROC_FILE_DIR = "/proc/uid/";
        this.PROC_FILE_NAME = "/time_in_state";
        this.mLastUidCpuTimeMs = new SparseArray();
        this.mSingleUidCpuTimesAvailable = true;
        this.mInjector = injector;
        this.mCpuFreqsCount = cpuFreqsCount;
        if (this.mCpuFreqsCount == 0) {
            this.mSingleUidCpuTimesAvailable = false;
        }
    }

    private final boolean $$robo$$com_android_internal_os_KernelSingleUidTimeReader$singleUidCpuTimesAvailable() {
        return this.mSingleUidCpuTimesAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long[] $$robo$$com_android_internal_os_KernelSingleUidTimeReader$readDeltaMs(int uid) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            long[] cpuTimesMs;
            if (!this.mSingleUidCpuTimesAvailable) {
                return null;
            }
            String procFile = "/proc/uid/" + uid + "/time_in_state";
            try {
                byte[] data = this.mInjector.readData(procFile);
                if (!this.mCpuFreqsCountVerified) {
                    this.verifyCpuFreqsCount(data.length, procFile);
                }
                ByteBuffer buffer = ByteBuffer.wrap(data);
                buffer.order(ByteOrder.nativeOrder());
                cpuTimesMs = this.readCpuTimesFromByteBuffer(buffer);
            }
            catch (Exception e) {
                if (++this.mReadErrorCounter >= 5) {
                    this.mSingleUidCpuTimesAvailable = false;
                }
                return null;
            }
            return this.computeDelta(uid, cpuTimesMs);
        }
    }

    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$verifyCpuFreqsCount(int numBytes, String procFile) {
        int actualCount = numBytes / 8;
        if (this.mCpuFreqsCount != actualCount) {
            this.mSingleUidCpuTimesAvailable = false;
            throw new IllegalStateException("Freq count didn't match,count from /proc/uid_time_in_state=" + this.mCpuFreqsCount + ", butcount from " + procFile + "=" + actualCount);
        }
        this.mCpuFreqsCountVerified = true;
    }

    private final long[] $$robo$$com_android_internal_os_KernelSingleUidTimeReader$readCpuTimesFromByteBuffer(ByteBuffer buffer) {
        long[] cpuTimesMs = new long[this.mCpuFreqsCount];
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            cpuTimesMs[i] = buffer.getLong() * 10L;
        }
        return cpuTimesMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long[] $$robo$$com_android_internal_os_KernelSingleUidTimeReader$computeDelta(int uid, long[] latestCpuTimesMs) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            if (!this.mSingleUidCpuTimesAvailable) {
                return null;
            }
            long[] lastCpuTimesMs = this.mLastUidCpuTimeMs.get(uid);
            long[] deltaTimesMs = this.getDeltaLocked(lastCpuTimesMs, latestCpuTimesMs);
            if (deltaTimesMs == null) {
                return null;
            }
            boolean hasNonZero = false;
            for (int i = deltaTimesMs.length - 1; i >= 0; --i) {
                if (deltaTimesMs[i] <= 0L) continue;
                hasNonZero = true;
                break;
            }
            if (hasNonZero) {
                this.mLastUidCpuTimeMs.put(uid, latestCpuTimesMs);
                return deltaTimesMs;
            }
            return null;
        }
    }

    @GuardedBy(value="this")
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final long[] $$robo$$com_android_internal_os_KernelSingleUidTimeReader$getDeltaLocked(long[] lastCpuTimesMs, long[] latestCpuTimesMs) {
        for (int i = latestCpuTimesMs.length - 1; i >= 0; --i) {
            if (latestCpuTimesMs[i] >= 0L) continue;
            return null;
        }
        if (lastCpuTimesMs == null) {
            return latestCpuTimesMs;
        }
        long[] deltaTimesMs = new long[latestCpuTimesMs.length];
        for (int i = latestCpuTimesMs.length - 1; i >= 0; --i) {
            deltaTimesMs[i] = latestCpuTimesMs[i] - lastCpuTimesMs[i];
            if (deltaTimesMs[i] >= 0L) continue;
            return null;
        }
        return deltaTimesMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$markDataAsStale(boolean hasStaleData) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mHasStaleData = hasStaleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_os_KernelSingleUidTimeReader$hasStaleData() {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            return this.mHasStaleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$setAllUidsCpuTimesMs(SparseArray<long[]> allUidsCpuTimesMs) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.clear();
            for (int i = allUidsCpuTimesMs.size() - 1; i >= 0; --i) {
                long[] cpuTimesMs = allUidsCpuTimesMs.valueAt(i);
                if (cpuTimesMs == null) continue;
                this.mLastUidCpuTimeMs.put(allUidsCpuTimesMs.keyAt(i), (long[])cpuTimesMs.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$removeUid(int uid) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.delete(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.put(startUid, null);
            this.mLastUidCpuTimeMs.put(endUid, null);
            int startIdx = this.mLastUidCpuTimeMs.indexOfKey(startUid);
            int endIdx = this.mLastUidCpuTimeMs.indexOfKey(endUid);
            this.mLastUidCpuTimeMs.removeAtRange(startIdx, endIdx - startIdx + 1);
        }
    }

    @VisibleForTesting
    private final SparseArray<long[]> $$robo$$com_android_internal_os_KernelSingleUidTimeReader$getLastUidCpuTimeMs() {
        return this.mLastUidCpuTimeMs;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_os_KernelSingleUidTimeReader$setSingleUidCpuTimesAvailable(boolean singleUidCpuTimesAvailable) {
        this.mSingleUidCpuTimesAvailable = singleUidCpuTimesAvailable;
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(n);
    }

    public KernelSingleUidTimeReader(int n) {
        this(n, new Injector());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(int ), this, n);
    }

    private void __constructor__(int n, Injector injector) {
        this.$$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(n, injector);
    }

    public KernelSingleUidTimeReader(int n, Injector injector) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$__constructor__(int com.android.internal.os.KernelSingleUidTimeReader$Injector ), this, n, injector);
    }

    public boolean singleUidCpuTimesAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("singleUidCpuTimesAvailable", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$singleUidCpuTimesAvailable(), this);
    }

    public long[] readDeltaMs(int n) {
        return InvokeDynamicSupport.bootstrap("readDeltaMs", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$readDeltaMs(int ), this, n);
    }

    private void verifyCpuFreqsCount(int n, String string2) {
        InvokeDynamicSupport.bootstrap("verifyCpuFreqsCount", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$verifyCpuFreqsCount(int java.lang.String ), this, n, string2);
    }

    private long[] readCpuTimesFromByteBuffer(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("readCpuTimesFromByteBuffer", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$readCpuTimesFromByteBuffer(java.nio.ByteBuffer ), this, byteBuffer);
    }

    public long[] computeDelta(int n, long[] lArray) {
        return InvokeDynamicSupport.bootstrap("computeDelta", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$computeDelta(int long[] ), this, n, lArray);
    }

    public long[] getDeltaLocked(long[] lArray, long[] lArray2) {
        return InvokeDynamicSupport.bootstrap("getDeltaLocked", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$getDeltaLocked(long[] long[] ), this, lArray, lArray2);
    }

    public void markDataAsStale(boolean bl) {
        InvokeDynamicSupport.bootstrap("markDataAsStale", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$markDataAsStale(boolean ), this, bl);
    }

    public boolean hasStaleData() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStaleData", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$hasStaleData(), this);
    }

    public void setAllUidsCpuTimesMs(SparseArray<long[]> sparseArray) {
        InvokeDynamicSupport.bootstrap("setAllUidsCpuTimesMs", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$setAllUidsCpuTimesMs(android.util.SparseArray<long[]> ), this, sparseArray);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$removeUid(int ), this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$removeUidsInRange(int int ), this, n, n2);
    }

    public SparseArray<long[]> getLastUidCpuTimeMs() {
        return InvokeDynamicSupport.bootstrap("getLastUidCpuTimeMs", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$getLastUidCpuTimeMs(), this);
    }

    public void setSingleUidCpuTimesAvailable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSingleUidCpuTimesAvailable", $$robo$$com_android_internal_os_KernelSingleUidTimeReader$setSingleUidCpuTimesAvailable(boolean ), this, bl);
    }

    public /* synthetic */ KernelSingleUidTimeReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelSingleUidTimeReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public static class Injector
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_os_KernelSingleUidTimeReader_Injector$__constructor__() {
        }

        private final byte[] $$robo$$com_android_internal_os_KernelSingleUidTimeReader_Injector$readData(String procFile) throws IOException {
            return Files.readAllBytes(Paths.get(procFile, new String[0]));
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_KernelSingleUidTimeReader_Injector$__constructor__();
        }

        public Injector() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelSingleUidTimeReader_Injector$__constructor__(), this);
        }

        public byte[] readData(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("readData", $$robo$$com_android_internal_os_KernelSingleUidTimeReader_Injector$readData(java.lang.String ), this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Injector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

