/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Formatter;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public abstract class LoggingPrintStream
extends PrintStream
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private StringBuilder builder;
    private ByteBuffer encodedBytes;
    private CharBuffer decodedChars;
    private CharsetDecoder decoder;
    private Formatter formatter;

    private void $$robo$$com_android_internal_os_LoggingPrintStream$__constructor__() {
        this.builder = new StringBuilder();
        this.formatter = new Formatter(this.builder, null);
    }

    protected abstract void log(String var1);

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$flush() {
        this.flush(true);
    }

    private final void $$robo$$com_android_internal_os_LoggingPrintStream$flush(boolean completely) {
        int nextBreak;
        int length = this.builder.length();
        int start = 0;
        while (start < length && (nextBreak = this.builder.indexOf("\n", start)) != -1) {
            this.log(this.builder.substring(start, nextBreak));
            start = nextBreak + 1;
        }
        if (completely) {
            if (start < length) {
                this.log(this.builder.substring(start));
            }
            this.builder.setLength(0);
        } else {
            this.builder.delete(0, start);
        }
    }

    private final void $$robo$$com_android_internal_os_LoggingPrintStream$write(int oneByte) {
        this.write(new byte[]{(byte)oneByte}, 0, 1);
    }

    private final void $$robo$$com_android_internal_os_LoggingPrintStream$write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$write(byte[] bytes, int start, int count) {
        if (this.decoder == null) {
            this.encodedBytes = ByteBuffer.allocate(80);
            this.decodedChars = CharBuffer.allocate(80);
            this.decoder = Charset.defaultCharset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        int end = start + count;
        while (start < end) {
            CoderResult coderResult;
            int numBytes = Math.min(this.encodedBytes.remaining(), end - start);
            this.encodedBytes.put(bytes, start, numBytes);
            start += numBytes;
            this.encodedBytes.flip();
            do {
                coderResult = this.decoder.decode(this.encodedBytes, this.decodedChars, false);
                this.decodedChars.flip();
                this.builder.append(this.decodedChars);
                this.decodedChars.clear();
            } while (coderResult.isOverflow());
            this.encodedBytes.compact();
        }
        this.flush(false);
    }

    private final boolean $$robo$$com_android_internal_os_LoggingPrintStream$checkError() {
        return false;
    }

    private final void $$robo$$com_android_internal_os_LoggingPrintStream$setError() {
    }

    private final void $$robo$$com_android_internal_os_LoggingPrintStream$close() {
    }

    private final PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    private final PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$printf(String format, Object ... args) {
        return this.format(format, args);
    }

    private final PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    private final synchronized PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$format(Locale l, String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.formatter.format(l, format, args);
        this.flush(false);
        return this;
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(char[] charArray) {
        this.builder.append(charArray);
        this.flush(false);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(char ch) {
        this.builder.append(ch);
        if (ch == '\n') {
            this.flush(false);
        }
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(double dnum) {
        this.builder.append(dnum);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(float fnum) {
        this.builder.append(fnum);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(int inum) {
        this.builder.append(inum);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(long lnum) {
        this.builder.append(lnum);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(Object obj) {
        this.builder.append(obj);
        this.flush(false);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(String str) {
        this.builder.append(str);
        this.flush(false);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$print(boolean bool2) {
        this.builder.append(bool2);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println() {
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(char[] charArray) {
        this.builder.append(charArray);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(char ch) {
        this.builder.append(ch);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(double dnum) {
        this.builder.append(dnum);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(float fnum) {
        this.builder.append(fnum);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(int inum) {
        this.builder.append(inum);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(long lnum) {
        this.builder.append(lnum);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(Object obj) {
        this.builder.append(obj);
        this.flush(true);
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(String s) {
        if (this.builder.length() == 0 && s != null) {
            int nextBreak;
            int length = s.length();
            int start = 0;
            while (start < length && (nextBreak = s.indexOf(10, start)) != -1) {
                this.log(s.substring(start, nextBreak));
                start = nextBreak + 1;
            }
            if (start < length) {
                this.log(s.substring(start));
            }
        } else {
            this.builder.append(s);
            this.flush(true);
        }
    }

    private final synchronized void $$robo$$com_android_internal_os_LoggingPrintStream$println(boolean bool2) {
        this.builder.append(bool2);
        this.flush(true);
    }

    private final synchronized PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$append(char c) {
        this.print(c);
        return this;
    }

    private final synchronized PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$append(CharSequence csq) {
        this.builder.append(csq);
        this.flush(false);
        return this;
    }

    private final synchronized PrintStream $$robo$$com_android_internal_os_LoggingPrintStream$append(CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        this.flush(false);
        return this;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_LoggingPrintStream$__constructor__();
    }

    public LoggingPrintStream() {
        super((OutputStream)new ShadowedObject(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_os_LoggingPrintStream_1$__constructor__() {
            }

            private final void $$robo$$com_android_internal_os_LoggingPrintStream_1$write(int oneByte) throws IOException {
                throw new AssertionError();
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_os_LoggingPrintStream_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_LoggingPrintStream_1$__constructor__(), this);
            }

            @Override
            public void write(int n) throws IOException {
                InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_os_LoggingPrintStream_1$write(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_LoggingPrintStream$__constructor__(), this);
    }

    @Override
    public synchronized void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_os_LoggingPrintStream$flush(), this);
    }

    private void flush(boolean bl) {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_os_LoggingPrintStream$flush(boolean ), this, bl);
    }

    @Override
    public void write(int n) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_os_LoggingPrintStream$write(int ), this, n);
    }

    @Override
    public void write(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_os_LoggingPrintStream$write(byte[] ), this, byArray);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_os_LoggingPrintStream$write(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    public boolean checkError() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkError", $$robo$$com_android_internal_os_LoggingPrintStream$checkError(), this);
    }

    @Override
    protected void setError() {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$com_android_internal_os_LoggingPrintStream$setError(), this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_os_LoggingPrintStream$close(), this);
    }

    @Override
    public PrintStream format(String string2, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$com_android_internal_os_LoggingPrintStream$format(java.lang.String java.lang.Object[] ), this, string2, objectArray);
    }

    @Override
    public PrintStream printf(String string2, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrap("printf", $$robo$$com_android_internal_os_LoggingPrintStream$printf(java.lang.String java.lang.Object[] ), this, string2, objectArray);
    }

    @Override
    public PrintStream printf(Locale locale, String string2, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrap("printf", $$robo$$com_android_internal_os_LoggingPrintStream$printf(java.util.Locale java.lang.String java.lang.Object[] ), this, locale, string2, objectArray);
    }

    @Override
    public synchronized PrintStream format(Locale locale, String string2, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$com_android_internal_os_LoggingPrintStream$format(java.util.Locale java.lang.String java.lang.Object[] ), this, locale, string2, objectArray);
    }

    @Override
    public synchronized void print(char[] cArray) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(char[] ), this, cArray);
    }

    @Override
    public synchronized void print(char c) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(char ), this, c);
    }

    @Override
    public synchronized void print(double d) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(double ), this, d);
    }

    @Override
    public synchronized void print(float f) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(float ), this, f);
    }

    @Override
    public synchronized void print(int n) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(int ), this, n);
    }

    @Override
    public synchronized void print(long l) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(long ), this, l);
    }

    @Override
    public synchronized void print(Object object) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(java.lang.Object ), this, object);
    }

    @Override
    public synchronized void print(String string2) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(java.lang.String ), this, string2);
    }

    @Override
    public synchronized void print(boolean bl) {
        InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_os_LoggingPrintStream$print(boolean ), this, bl);
    }

    @Override
    public synchronized void println() {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(), this);
    }

    @Override
    public synchronized void println(char[] cArray) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(char[] ), this, cArray);
    }

    @Override
    public synchronized void println(char c) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(char ), this, c);
    }

    @Override
    public synchronized void println(double d) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(double ), this, d);
    }

    @Override
    public synchronized void println(float f) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(float ), this, f);
    }

    @Override
    public synchronized void println(int n) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(int ), this, n);
    }

    @Override
    public synchronized void println(long l) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(long ), this, l);
    }

    @Override
    public synchronized void println(Object object) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(java.lang.Object ), this, object);
    }

    @Override
    public synchronized void println(String string2) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(java.lang.String ), this, string2);
    }

    @Override
    public synchronized void println(boolean bl) {
        InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_os_LoggingPrintStream$println(boolean ), this, bl);
    }

    @Override
    public synchronized PrintStream append(char c) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_os_LoggingPrintStream$append(char ), this, c);
    }

    @Override
    public synchronized PrintStream append(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_os_LoggingPrintStream$append(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public synchronized PrintStream append(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_os_LoggingPrintStream$append(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoggingPrintStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

