/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SensorPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private List<Sensor> mSensors;
    private double mGpsPower;

    private void $$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(PowerProfile profile, SensorManager sensorManager, BatteryStats stats, long rawRealtimeUs, int statsType) {
        this.mSensors = sensorManager.getSensorList(-1);
        this.mGpsPower = this.getAverageGpsPower(profile, stats, rawRealtimeUs, statsType);
    }

    private final void $$robo$$com_android_internal_os_SensorPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int NSE = sensorStats.size();
        block3: for (int ise = 0; ise < NSE; ++ise) {
            BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
            int sensorHandle = sensorStats.keyAt(ise);
            BatteryStats.Timer timer = sensor.getSensorTime();
            long sensorTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            switch (sensorHandle) {
                case -10000: {
                    app.gpsTimeMs = sensorTime;
                    app.gpsPowerMah = (double)app.gpsTimeMs * this.mGpsPower / 3600000.0;
                    continue block3;
                }
                default: {
                    int sensorsCount = this.mSensors.size();
                    for (int i = 0; i < sensorsCount; ++i) {
                        Sensor s = this.mSensors.get(i);
                        if (s.getHandle() != sensorHandle) continue;
                        app.sensorPowerMah += (double)((float)sensorTime * s.getPower() / 3600000.0f);
                        continue block3;
                    }
                }
            }
        }
    }

    private final double $$robo$$com_android_internal_os_SensorPowerCalculator$getAverageGpsPower(PowerProfile profile, BatteryStats stats, long rawRealtimeUs, int statsType) {
        double averagePower = profile.getAveragePowerOrDefault("gps.on", -1.0);
        if (averagePower != -1.0) {
            return averagePower;
        }
        averagePower = 0.0;
        long totalTime = 0L;
        double totalPower = 0.0;
        for (int i = 0; i < 2; ++i) {
            long timePerLevel = stats.getGpsSignalQualityTime(i, rawRealtimeUs, statsType);
            totalTime += timePerLevel;
            totalPower += profile.getAveragePower("gps.signalqualitybased", i) * (double)timePerLevel;
        }
        if (totalTime != 0L) {
            averagePower = totalPower / (double)totalTime;
        }
        return averagePower;
    }

    private void __constructor__(PowerProfile powerProfile, SensorManager sensorManager, BatteryStats batteryStats, long l, int n) {
        this.$$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(powerProfile, sensorManager, batteryStats, l, n);
    }

    public SensorPowerCalculator(PowerProfile powerProfile, SensorManager sensorManager, BatteryStats batteryStats, long l, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_SensorPowerCalculator$__constructor__(com.android.internal.os.PowerProfile android.hardware.SensorManager android.os.BatteryStats long int ), this, powerProfile, sensorManager, batteryStats, l, n);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_SensorPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), this, batterySipper, uid, l, l2, n);
    }

    private double getAverageGpsPower(PowerProfile powerProfile, BatteryStats batteryStats, long l, int n) {
        return (double)InvokeDynamicSupport.bootstrap("getAverageGpsPower", $$robo$$com_android_internal_os_SensorPowerCalculator$getAverageGpsPower(com.android.internal.os.PowerProfile android.os.BatteryStats long int ), this, powerProfile, batteryStats, l, n);
    }

    public /* synthetic */ SensorPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

