/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransferPipe
implements Runnable,
Closeable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "TransferPipe";
    static boolean DEBUG = false;
    static long DEFAULT_TIMEOUT = 5000L;
    Thread mThread;
    ParcelFileDescriptor[] mFds;
    FileDescriptor mOutFd;
    long mEndTime;
    String mFailure;
    boolean mComplete;
    String mBufferPrefix;

    private void $$robo$$com_android_internal_os_TransferPipe$__constructor__() throws IOException {
    }

    private void $$robo$$com_android_internal_os_TransferPipe$__constructor__(String bufferPrefix) throws IOException {
    }

    private void $$robo$$com_android_internal_os_TransferPipe$__constructor__(String bufferPrefix, String threadName) throws IOException {
        this.mThread = new Thread((Runnable)this, threadName);
        this.mFds = ParcelFileDescriptor.createPipe();
        this.mBufferPrefix = bufferPrefix;
    }

    private final ParcelFileDescriptor $$robo$$com_android_internal_os_TransferPipe$getReadFd() {
        return this.mFds[0];
    }

    private final ParcelFileDescriptor $$robo$$com_android_internal_os_TransferPipe$getWriteFd() {
        return this.mFds[1];
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$setBufferPrefix(String prefix) {
        this.mBufferPrefix = prefix;
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$dumpAsync(IBinder binder, FileDescriptor out, String[] args) throws IOException, RemoteException {
        TransferPipe.goDump(binder, out, args);
    }

    private static final byte[] $$robo$$com_android_internal_os_TransferPipe$dumpAsync(IBinder binder, String ... args) throws IOException, RemoteException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        try {
            byte[] byArray;
            TransferPipe.dumpAsync(binder, pipe[1].getFileDescriptor(), args);
            pipe[1].close();
            pipe[1] = null;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream combinedBuffer = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                try (FileInputStream is = new FileInputStream(pipe[0].getFileDescriptor());){
                    int numRead;
                    while ((numRead = is.read(buffer)) != -1) {
                        combinedBuffer.write(buffer, 0, numRead);
                    }
                }
                byArray = combinedBuffer.toByteArray();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    TransferPipe.$closeResource(throwable, combinedBuffer);
                    throw throwable3;
                }
            }
            TransferPipe.$closeResource(throwable, combinedBuffer);
            return byArray;
        }
        finally {
            pipe[0].close();
            IoUtils.closeQuietly(pipe[1]);
        }
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args) throws IOException, RemoteException {
        TransferPipe.go(caller, iface, out, prefix, args, 5000L);
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args, long timeout) throws IOException, RemoteException {
        if (iface.asBinder() instanceof Binder) {
            try {
                caller.go(iface, out, prefix, args);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        try (TransferPipe tp = new TransferPipe();){
            caller.go(iface, tp.getWriteFd().getFileDescriptor(), prefix, args);
            tp.go(out, timeout);
        }
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$goDump(IBinder binder, FileDescriptor out, String[] args) throws IOException, RemoteException {
        TransferPipe.goDump(binder, out, args, 5000L);
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$goDump(IBinder binder, FileDescriptor out, String[] args, long timeout) throws IOException, RemoteException {
        if (binder instanceof Binder) {
            try {
                binder.dump(out, args);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        try (TransferPipe tp = new TransferPipe();){
            binder.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
            tp.go(out, timeout);
        }
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$go(FileDescriptor out) throws IOException {
        this.go(out, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$go(FileDescriptor out, long timeout) throws IOException {
        try {
            TransferPipe transferPipe = this;
            synchronized (transferPipe) {
                this.mOutFd = out;
                this.mEndTime = SystemClock.uptimeMillis() + timeout;
                this.closeFd(1);
                this.mThread.start();
                while (this.mFailure == null && !this.mComplete) {
                    long waitTime = this.mEndTime - SystemClock.uptimeMillis();
                    if (waitTime <= 0L) {
                        this.mThread.interrupt();
                        throw new IOException("Timeout");
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mFailure != null) {
                    throw new IOException(this.mFailure);
                }
            }
        }
        finally {
            this.kill();
        }
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$closeFd(int num) {
        if (this.mFds[num] != null) {
            try {
                this.mFds[num].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mFds[num] = null;
        }
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$close() {
        this.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$kill() {
        TransferPipe transferPipe = this;
        synchronized (transferPipe) {
            this.closeFd(0);
            this.closeFd(1);
        }
    }

    private final OutputStream $$robo$$com_android_internal_os_TransferPipe$getNewOutputStream() {
        return new FileOutputStream(this.mOutFd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$run() {
        OutputStream fos;
        FileInputStream fis;
        byte[] buffer = new byte[1024];
        TransferPipe transferPipe = this;
        synchronized (transferPipe) {
            ParcelFileDescriptor readFd = this.getReadFd();
            if (readFd == null) {
                Slog.w("TransferPipe", "Pipe has been closed...");
                return;
            }
            fis = new FileInputStream(readFd.getFileDescriptor());
            fos = this.getNewOutputStream();
        }
        byte[] bufferPrefix = null;
        boolean needPrefix = true;
        if (this.mBufferPrefix != null) {
            bufferPrefix = this.mBufferPrefix.getBytes();
        }
        try {
            int size;
            while ((size = fis.read(buffer)) > 0) {
                if (bufferPrefix == null) {
                    fos.write(buffer, 0, size);
                    continue;
                }
                int start = 0;
                for (int i = 0; i < size; ++i) {
                    if (buffer[i] == 10) continue;
                    if (i > start) {
                        fos.write(buffer, start, i - start);
                    }
                    start = i;
                    if (needPrefix) {
                        fos.write(bufferPrefix);
                        needPrefix = false;
                    }
                    while (++i < size && buffer[i] != 10) {
                    }
                    if (i >= size) continue;
                    needPrefix = true;
                }
                if (size <= start) continue;
                fos.write(buffer, start, size - start);
            }
            if (!this.mThread.isInterrupted()) {
                // empty if block
            }
        }
        catch (IOException e) {
            TransferPipe transferPipe2 = this;
            synchronized (transferPipe2) {
                this.mFailure = e.toString();
                this.notifyAll();
                return;
            }
        }
        TransferPipe transferPipe3 = this;
        synchronized (transferPipe3) {
            this.mComplete = true;
            this.notifyAll();
            return;
        }
    }

    private void __constructor__() throws IOException {
        this.$$robo$$com_android_internal_os_TransferPipe$__constructor__();
    }

    public TransferPipe() throws IOException {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_TransferPipe$__constructor__(), this);
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$com_android_internal_os_TransferPipe$__constructor__(string2);
    }

    public TransferPipe(String string2) throws IOException {
        this(string2, "TransferPipe");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_TransferPipe$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(String string2, String string3) throws IOException {
        this.$$robo$$com_android_internal_os_TransferPipe$__constructor__(string2, string3);
    }

    public TransferPipe(String string2, String string3) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_TransferPipe$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
    }

    ParcelFileDescriptor getReadFd() {
        return InvokeDynamicSupport.bootstrap("getReadFd", $$robo$$com_android_internal_os_TransferPipe$getReadFd(), this);
    }

    public ParcelFileDescriptor getWriteFd() {
        return InvokeDynamicSupport.bootstrap("getWriteFd", $$robo$$com_android_internal_os_TransferPipe$getWriteFd(), this);
    }

    public void setBufferPrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setBufferPrefix", $$robo$$com_android_internal_os_TransferPipe$setBufferPrefix(java.lang.String ), this, string2);
    }

    public static void dumpAsync(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("dumpAsync", $$robo$$com_android_internal_os_TransferPipe$dumpAsync(android.os.IBinder java.io.FileDescriptor java.lang.String[] ), (IBinder)iBinder, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    public static byte[] dumpAsync(IBinder iBinder, String ... stringArray) throws IOException, RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("dumpAsync", $$robo$$com_android_internal_os_TransferPipe$dumpAsync(android.os.IBinder java.lang.String[] ), (IBinder)iBinder, (String[])stringArray);
    }

    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("go", $$robo$$com_android_internal_os_TransferPipe$go(com.android.internal.os.TransferPipe$Caller android.os.IInterface java.io.FileDescriptor java.lang.String java.lang.String[] ), (Caller)caller, (IInterface)iInterface, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray);
    }

    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray, long l) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("go", $$robo$$com_android_internal_os_TransferPipe$go(com.android.internal.os.TransferPipe$Caller android.os.IInterface java.io.FileDescriptor java.lang.String java.lang.String[] long ), (Caller)caller, (IInterface)iInterface, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray, (long)l);
    }

    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("goDump", $$robo$$com_android_internal_os_TransferPipe$goDump(android.os.IBinder java.io.FileDescriptor java.lang.String[] ), (IBinder)iBinder, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray, long l) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("goDump", $$robo$$com_android_internal_os_TransferPipe$goDump(android.os.IBinder java.io.FileDescriptor java.lang.String[] long ), (IBinder)iBinder, (FileDescriptor)fileDescriptor, (String[])stringArray, (long)l);
    }

    public void go(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("go", $$robo$$com_android_internal_os_TransferPipe$go(java.io.FileDescriptor ), this, fileDescriptor);
    }

    public void go(FileDescriptor fileDescriptor, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("go", $$robo$$com_android_internal_os_TransferPipe$go(java.io.FileDescriptor long ), this, fileDescriptor, l);
    }

    void closeFd(int n) {
        InvokeDynamicSupport.bootstrap("closeFd", $$robo$$com_android_internal_os_TransferPipe$closeFd(int ), this, n);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_os_TransferPipe$close(), this);
    }

    public void kill() {
        InvokeDynamicSupport.bootstrap("kill", $$robo$$com_android_internal_os_TransferPipe$kill(), this);
    }

    protected OutputStream getNewOutputStream() {
        return InvokeDynamicSupport.bootstrap("getNewOutputStream", $$robo$$com_android_internal_os_TransferPipe$getNewOutputStream(), this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_TransferPipe$run(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransferPipe)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Caller {
        public void go(IInterface var1, FileDescriptor var2, String var3, String[] var4) throws RemoteException;
    }
}

