/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.FactoryTest;
import android.os.Process;
import android.os.SystemProperties;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import com.android.internal.os.ZygoteServer;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteConnection
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Zygote";
    private static int[][] intArray2d;
    private LocalSocket mSocket;
    private DataOutputStream mSocketOutStream;
    private BufferedReader mSocketReader;
    private Credentials peer;
    private String abiList;
    private boolean isEof;

    private void $$robo$$com_android_internal_os_ZygoteConnection$__constructor__(LocalSocket socket, String abiList) throws IOException {
        this.mSocket = socket;
        this.abiList = abiList;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e("Zygote", "Cannot read peer credentials", ex);
            throw ex;
        }
        this.isEof = false;
    }

    private final FileDescriptor $$robo$$com_android_internal_os_ZygoteConnection$getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Runnable $$robo$$com_android_internal_os_ZygoteConnection$processOneCommand(ZygoteServer zygoteServer) {
        FileDescriptor[] descriptors;
        String[] args;
        Arguments parsedArgs = null;
        try {
            args = this.readArgumentList();
            descriptors = this.mSocket.getAncillaryFileDescriptors();
        }
        catch (IOException ex) {
            throw new IllegalStateException("IOException on command socket", ex);
        }
        if (args == null) {
            this.isEof = true;
            return null;
        }
        int pid = -1;
        FileDescriptor childPipeFd = null;
        FileDescriptor serverPipeFd = null;
        parsedArgs = new Arguments(args);
        if (parsedArgs.abiListQuery) {
            this.handleAbiListQuery();
            return null;
        }
        if (parsedArgs.preloadDefault) {
            this.handlePreload();
            return null;
        }
        if (parsedArgs.preloadPackage != null) {
            this.handlePreloadPackage(parsedArgs.preloadPackage, parsedArgs.preloadPackageLibs, parsedArgs.preloadPackageLibFileName, parsedArgs.preloadPackageCacheKey);
            return null;
        }
        if (parsedArgs.apiBlacklistExemptions != null) {
            this.handleApiBlacklistExemptions(parsedArgs.apiBlacklistExemptions);
            return null;
        }
        if (parsedArgs.hiddenApiAccessLogSampleRate != -1) {
            this.handleHiddenApiAccessLogSampleRate(parsedArgs.hiddenApiAccessLogSampleRate);
            return null;
        }
        if (parsedArgs.permittedCapabilities != 0L || parsedArgs.effectiveCapabilities != 0L) {
            throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(parsedArgs.permittedCapabilities) + ", effective=0x" + Long.toHexString(parsedArgs.effectiveCapabilities));
        }
        ZygoteConnection.applyUidSecurityPolicy(parsedArgs, this.peer);
        ZygoteConnection.applyInvokeWithSecurityPolicy(parsedArgs, this.peer);
        ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
        ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
        int[][] rlimits = null;
        if (parsedArgs.rlimits != null) {
            rlimits = (int[][])parsedArgs.rlimits.toArray((T[])intArray2d);
        }
        int[] fdsToIgnore = null;
        if (parsedArgs.invokeWith != null) {
            try {
                FileDescriptor[] pipeFds = Os.pipe2(OsConstants.O_CLOEXEC);
                childPipeFd = pipeFds[1];
                serverPipeFd = pipeFds[0];
                Os.fcntlInt(childPipeFd, OsConstants.F_SETFD, 0);
                fdsToIgnore = new int[]{childPipeFd.getInt$(), serverPipeFd.getInt$()};
            }
            catch (ErrnoException errnoEx) {
                throw new IllegalStateException("Unable to set up pipe for invoke-with", errnoEx);
            }
        }
        int[] fdsToClose = new int[]{-1, -1};
        FileDescriptor fd = this.mSocket.getFileDescriptor();
        if (fd != null) {
            fdsToClose[0] = fd.getInt$();
        }
        if ((fd = zygoteServer.getServerSocketFileDescriptor()) != null) {
            fdsToClose[1] = fd.getInt$();
        }
        fd = null;
        pid = Zygote.forkAndSpecialize(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.runtimeFlags, rlimits, parsedArgs.mountExternal, parsedArgs.seInfo, parsedArgs.niceName, fdsToClose, fdsToIgnore, parsedArgs.startChildZygote, parsedArgs.instructionSet, parsedArgs.appDataDir);
        try {
            if (pid == 0) {
                zygoteServer.setForkChild();
                zygoteServer.closeServerSocket();
                IoUtils.closeQuietly(serverPipeFd);
                serverPipeFd = null;
                Runnable runnable = this.handleChildProc(parsedArgs, descriptors, childPipeFd, parsedArgs.startChildZygote);
                return runnable;
            }
            IoUtils.closeQuietly(childPipeFd);
            childPipeFd = null;
            this.handleParentProc(pid, descriptors, serverPipeFd);
            Runnable runnable = null;
            return runnable;
        }
        finally {
            IoUtils.closeQuietly(childPipeFd);
            IoUtils.closeQuietly(serverPipeFd);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handleAbiListQuery() {
        try {
            byte[] abiListBytes = this.abiList.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(abiListBytes.length);
            this.mSocketOutStream.write(abiListBytes);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handlePreload() {
        try {
            if (this.isPreloadComplete()) {
                this.mSocketOutStream.writeInt(1);
            } else {
                this.preload();
                this.mSocketOutStream.writeInt(0);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handleApiBlacklistExemptions(String[] exemptions) {
        try {
            ZygoteInit.setApiBlacklistExemptions(exemptions);
            this.mSocketOutStream.writeInt(0);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handleHiddenApiAccessLogSampleRate(int percent) {
        try {
            ZygoteInit.setHiddenApiAccessLogSampleRate(percent);
            this.mSocketOutStream.writeInt(0);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$preload() {
        ZygoteInit.lazyPreload();
    }

    private final boolean $$robo$$com_android_internal_os_ZygoteConnection$isPreloadComplete() {
        return ZygoteInit.isPreloadComplete();
    }

    private final DataOutputStream $$robo$$com_android_internal_os_ZygoteConnection$getSocketOutputStream() {
        return this.mSocketOutStream;
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handlePreloadPackage(String packagePath, String libsPath, String libFileName, String cacheKey) {
        throw new RuntimeException("Zyogte does not support package preloading");
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e("Zygote", "Exception while closing command socket in parent", ex);
        }
    }

    private final boolean $$robo$$com_android_internal_os_ZygoteConnection$isClosedByPeer() {
        return this.isEof;
    }

    private final String[] $$robo$$com_android_internal_os_ZygoteConnection$readArgumentList() throws IOException {
        int argc;
        try {
            String s = this.mSocketReader.readLine();
            if (s == null) {
                return null;
            }
            argc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            Log.e("Zygote", "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] result = new String[argc];
        for (int i = 0; i < argc; ++i) {
            result[i] = this.mSocketReader.readLine();
            if (result[i] != null) continue;
            throw new IOException("truncated request");
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyUidSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        if (peer.getUid() == 1000) {
            boolean uidRestricted;
            boolean bl = uidRestricted = FactoryTest.getMode() == 0;
            if (uidRestricted && args.uidSpecified && args.uid < 1000) {
                throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
            }
        }
        if (!args.uidSpecified) {
            args.uid = peer.getUid();
            args.uidSpecified = true;
        }
        if (!args.gidSpecified) {
            args.gid = peer.getGid();
            args.gidSpecified = true;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyDebuggerSystemProperty(Arguments args) {
        if (RoSystemProperties.DEBUGGABLE) {
            args.runtimeFlags |= 1;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSecurityPolicy(Arguments args, Credentials peer) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.invokeWith != null && peerUid != 0 && (args.runtimeFlags & 1) == 0) {
            throw new ZygoteSecurityException("Peer is permitted to specify anexplicit invoke-with wrapper command only for debuggableapplications.");
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSystemProperty(Arguments args) {
        if (args.invokeWith == null && args.niceName != null) {
            String property = "wrap." + args.niceName;
            args.invokeWith = SystemProperties.get(property);
            if (args.invokeWith != null && args.invokeWith.length() == 0) {
                args.invokeWith = null;
            }
        }
    }

    private final Runnable $$robo$$com_android_internal_os_ZygoteConnection$handleChildProc(Arguments parsedArgs, FileDescriptor[] descriptors, FileDescriptor pipeFd, boolean isZygote) {
        this.closeSocket();
        if (descriptors != null) {
            try {
                Os.dup2(descriptors[0], OsConstants.STDIN_FILENO);
                Os.dup2(descriptors[1], OsConstants.STDOUT_FILENO);
                Os.dup2(descriptors[2], OsConstants.STDERR_FILENO);
                for (FileDescriptor fd : descriptors) {
                    IoUtils.closeQuietly(fd);
                }
            }
            catch (ErrnoException ex) {
                Log.e("Zygote", "Error reopening stdio", ex);
            }
        }
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        Trace.traceEnd(64L);
        if (parsedArgs.invokeWith != null) {
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, VMRuntime.getCurrentInstructionSet(), pipeFd, parsedArgs.remainingArgs);
            throw new IllegalStateException("WrapperInit.execApplication unexpectedly returned");
        }
        if (!isZygote) {
            return ZygoteInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, null);
        }
        return ZygoteInit.childZygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, null);
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handleParentProc(int pid, FileDescriptor[] descriptors, FileDescriptor pipeFd) {
        if (pid > 0) {
            this.setChildPgid(pid);
        }
        if (descriptors != null) {
            for (FileDescriptor fd : descriptors) {
                IoUtils.closeQuietly(fd);
            }
        }
        boolean usingWrapper = false;
        if (pipeFd != null && pid > 0) {
            int innerPid = -1;
            try {
                int BYTES_REQUIRED = 4;
                StructPollfd[] fds = new StructPollfd[]{new StructPollfd()};
                byte[] data = new byte[4];
                int remainingSleepTime = 30000;
                int dataIndex = 0;
                CallSite startTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
                while (dataIndex < data.length && remainingSleepTime > 0) {
                    fds[0].fd = pipeFd;
                    fds[0].events = (short)OsConstants.POLLIN;
                    fds[0].revents = 0;
                    fds[0].userData = null;
                    int res = Os.poll(fds, remainingSleepTime);
                    CallSite endTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
                    int elapsedTimeMs = (int)((endTime - startTime) / 1000000L);
                    remainingSleepTime = 30000 - elapsedTimeMs;
                    if (res > 0) {
                        if ((fds[0].revents & OsConstants.POLLIN) == 0) break;
                        int readBytes = Os.read(pipeFd, data, dataIndex, 1);
                        if (readBytes < 0) {
                            throw new RuntimeException("Some error");
                        }
                        dataIndex += readBytes;
                        continue;
                    }
                    if (res != 0) continue;
                    Log.w("Zygote", "Timed out waiting for child.");
                }
                if (dataIndex == data.length) {
                    DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
                    innerPid = is.readInt();
                }
                if (innerPid == -1) {
                    Log.w("Zygote", "Error reading pid from wrapped process, child may have died");
                }
            }
            catch (Exception ex) {
                Log.w("Zygote", "Error reading pid from wrapped process, child may have died", ex);
            }
            if (innerPid > 0) {
                int parentPid = innerPid;
                while (parentPid > 0 && parentPid != pid) {
                    parentPid = Process.getParentPid(parentPid);
                }
                if (parentPid > 0) {
                    Log.i("Zygote", "Wrapped process has pid " + innerPid);
                    pid = innerPid;
                    usingWrapper = true;
                } else {
                    Log.w("Zygote", "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + pid + " innerPid=" + innerPid);
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(pid);
            this.mSocketOutStream.writeBoolean(usingWrapper);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error writing to command socket", ex);
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$setChildPgid(int pid) {
        try {
            Os.setpgid(pid, Os.getpgid(this.peer.getPid()));
        }
        catch (ErrnoException ex) {
            Log.i("Zygote", "Zygote: setpgid failed. This is normal if peer is not in our session");
        }
    }

    static void __staticInitializer__() {
        intArray2d = new int[0][0];
    }

    private void __constructor__(LocalSocket localSocket, String string2) throws IOException {
        this.$$robo$$com_android_internal_os_ZygoteConnection$__constructor__(localSocket, string2);
    }

    public ZygoteConnection(LocalSocket localSocket, String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteConnection$__constructor__(android.net.LocalSocket java.lang.String ), this, localSocket, string2);
    }

    FileDescriptor getFileDesciptor() {
        return InvokeDynamicSupport.bootstrap("getFileDesciptor", $$robo$$com_android_internal_os_ZygoteConnection$getFileDesciptor(), this);
    }

    Runnable processOneCommand(ZygoteServer zygoteServer) {
        return InvokeDynamicSupport.bootstrap("processOneCommand", $$robo$$com_android_internal_os_ZygoteConnection$processOneCommand(com.android.internal.os.ZygoteServer ), this, zygoteServer);
    }

    private void handleAbiListQuery() {
        InvokeDynamicSupport.bootstrap("handleAbiListQuery", $$robo$$com_android_internal_os_ZygoteConnection$handleAbiListQuery(), this);
    }

    private void handlePreload() {
        InvokeDynamicSupport.bootstrap("handlePreload", $$robo$$com_android_internal_os_ZygoteConnection$handlePreload(), this);
    }

    private void handleApiBlacklistExemptions(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("handleApiBlacklistExemptions", $$robo$$com_android_internal_os_ZygoteConnection$handleApiBlacklistExemptions(java.lang.String[] ), this, stringArray);
    }

    private void handleHiddenApiAccessLogSampleRate(int n) {
        InvokeDynamicSupport.bootstrap("handleHiddenApiAccessLogSampleRate", $$robo$$com_android_internal_os_ZygoteConnection$handleHiddenApiAccessLogSampleRate(int ), this, n);
    }

    protected void preload() {
        InvokeDynamicSupport.bootstrap("preload", $$robo$$com_android_internal_os_ZygoteConnection$preload(), this);
    }

    protected boolean isPreloadComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreloadComplete", $$robo$$com_android_internal_os_ZygoteConnection$isPreloadComplete(), this);
    }

    protected DataOutputStream getSocketOutputStream() {
        return InvokeDynamicSupport.bootstrap("getSocketOutputStream", $$robo$$com_android_internal_os_ZygoteConnection$getSocketOutputStream(), this);
    }

    protected void handlePreloadPackage(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("handlePreloadPackage", $$robo$$com_android_internal_os_ZygoteConnection$handlePreloadPackage(java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5);
    }

    void closeSocket() {
        InvokeDynamicSupport.bootstrap("closeSocket", $$robo$$com_android_internal_os_ZygoteConnection$closeSocket(), this);
    }

    boolean isClosedByPeer() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosedByPeer", $$robo$$com_android_internal_os_ZygoteConnection$isClosedByPeer(), this);
    }

    private String[] readArgumentList() throws IOException {
        return InvokeDynamicSupport.bootstrap("readArgumentList", $$robo$$com_android_internal_os_ZygoteConnection$readArgumentList(), this);
    }

    private static void applyUidSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyUidSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyUidSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials ), (Arguments)arguments, (Credentials)credentials);
    }

    public static void applyDebuggerSystemProperty(Arguments arguments) {
        InvokeDynamicSupport.bootstrapStatic("applyDebuggerSystemProperty", $$robo$$com_android_internal_os_ZygoteConnection$applyDebuggerSystemProperty(com.android.internal.os.ZygoteConnection$Arguments ), (Arguments)arguments);
    }

    private static void applyInvokeWithSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyInvokeWithSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials ), (Arguments)arguments, (Credentials)credentials);
    }

    public static void applyInvokeWithSystemProperty(Arguments arguments) {
        InvokeDynamicSupport.bootstrapStatic("applyInvokeWithSystemProperty", $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSystemProperty(com.android.internal.os.ZygoteConnection$Arguments ), (Arguments)arguments);
    }

    private Runnable handleChildProc(Arguments arguments, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor, boolean bl) {
        return InvokeDynamicSupport.bootstrap("handleChildProc", $$robo$$com_android_internal_os_ZygoteConnection$handleChildProc(com.android.internal.os.ZygoteConnection$Arguments java.io.FileDescriptor[] java.io.FileDescriptor boolean ), this, arguments, fileDescriptorArray, fileDescriptor, bl);
    }

    private void handleParentProc(int n, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("handleParentProc", $$robo$$com_android_internal_os_ZygoteConnection$handleParentProc(int java.io.FileDescriptor[] java.io.FileDescriptor ), this, n, fileDescriptorArray, fileDescriptor);
    }

    private void setChildPgid(int n) {
        InvokeDynamicSupport.bootstrap("setChildPgid", $$robo$$com_android_internal_os_ZygoteConnection$setChildPgid(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(ZygoteConnection.class);
    }

    public /* synthetic */ ZygoteConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Arguments
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int uid;
        boolean uidSpecified;
        int gid;
        boolean gidSpecified;
        int[] gids;
        int runtimeFlags;
        int mountExternal;
        int targetSdkVersion;
        boolean targetSdkVersionSpecified;
        String niceName;
        boolean capabilitiesSpecified;
        long permittedCapabilities;
        long effectiveCapabilities;
        boolean seInfoSpecified;
        String seInfo;
        ArrayList<int[]> rlimits;
        String invokeWith;
        String[] remainingArgs;
        boolean abiListQuery;
        String instructionSet;
        String appDataDir;
        String preloadPackage;
        String preloadPackageLibs;
        String preloadPackageLibFileName;
        String preloadPackageCacheKey;
        boolean preloadDefault;
        boolean startChildZygote;
        String[] apiBlacklistExemptions;
        int hiddenApiAccessLogSampleRate;

        private void $$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(String[] args) throws IllegalArgumentException {
            this.uid = 0;
            this.gid = 0;
            this.mountExternal = 0;
            this.hiddenApiAccessLogSampleRate = -1;
            this.parseArgs(args);
        }

        private final void $$robo$$com_android_internal_os_ZygoteConnection_Arguments$parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            boolean seenRuntimeArgs = false;
            boolean expectRuntimeArgs = true;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (arg.startsWith("--setuid=")) {
                    if (this.uidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.uidSpecified = true;
                    this.uid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--setgid=")) {
                    if (this.gidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.gidSpecified = true;
                    this.gid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--target-sdk-version=")) {
                    if (this.targetSdkVersionSpecified) {
                        throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                    }
                    this.targetSdkVersionSpecified = true;
                    this.targetSdkVersion = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.equals("--runtime-args")) {
                    seenRuntimeArgs = true;
                    continue;
                }
                if (arg.startsWith("--runtime-flags=")) {
                    this.runtimeFlags = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--seinfo=")) {
                    if (this.seInfoSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.seInfoSpecified = true;
                    this.seInfo = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--capabilities=")) {
                    if (this.capabilitiesSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.capabilitiesSpecified = true;
                    String capString = arg.substring(arg.indexOf(61) + 1);
                    String[] capStrings = capString.split(",", 2);
                    if (capStrings.length == 1) {
                        this.permittedCapabilities = this.effectiveCapabilities = Long.decode(capStrings[0]).longValue();
                        continue;
                    }
                    this.permittedCapabilities = Long.decode(capStrings[0]);
                    this.effectiveCapabilities = Long.decode(capStrings[1]);
                    continue;
                }
                if (arg.startsWith("--rlimit=")) {
                    String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                    if (limitStrings.length != 3) {
                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                    }
                    int[] rlimitTuple = new int[limitStrings.length];
                    for (int i = 0; i < limitStrings.length; ++i) {
                        rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                    }
                    if (this.rlimits == null) {
                        this.rlimits = new ArrayList();
                    }
                    this.rlimits.add(rlimitTuple);
                    continue;
                }
                if (arg.startsWith("--setgroups=")) {
                    if (this.gids != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                    this.gids = new int[params.length];
                    for (int i = params.length - 1; i >= 0; --i) {
                        this.gids[i] = Integer.parseInt(params[i]);
                    }
                    continue;
                }
                if (arg.equals("--invoke-with")) {
                    if (this.invokeWith != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.invokeWith = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("--invoke-with requires argument");
                    }
                }
                if (arg.startsWith("--nice-name=")) {
                    if (this.niceName != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.niceName = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--mount-external-default")) {
                    this.mountExternal = 1;
                    continue;
                }
                if (arg.equals("--mount-external-read")) {
                    this.mountExternal = 2;
                    continue;
                }
                if (arg.equals("--mount-external-write")) {
                    this.mountExternal = 3;
                    continue;
                }
                if (arg.equals("--query-abi-list")) {
                    this.abiListQuery = true;
                    continue;
                }
                if (arg.startsWith("--instruction-set=")) {
                    this.instructionSet = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--app-data-dir=")) {
                    this.appDataDir = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--preload-package")) {
                    this.preloadPackage = args[++curArg];
                    this.preloadPackageLibs = args[++curArg];
                    this.preloadPackageLibFileName = args[++curArg];
                    this.preloadPackageCacheKey = args[++curArg];
                    continue;
                }
                if (arg.equals("--preload-default")) {
                    this.preloadDefault = true;
                    expectRuntimeArgs = false;
                    continue;
                }
                if (arg.equals("--start-child-zygote")) {
                    this.startChildZygote = true;
                    continue;
                }
                if (arg.equals("--set-api-blacklist-exemptions")) {
                    this.apiBlacklistExemptions = Arrays.copyOfRange(args, curArg + 1, args.length);
                    curArg = args.length;
                    expectRuntimeArgs = false;
                    continue;
                }
                if (!arg.startsWith("--hidden-api-log-sampling-rate=")) break;
                String rateStr = arg.substring(arg.indexOf(61) + 1);
                try {
                    this.hiddenApiAccessLogSampleRate = Integer.parseInt(rateStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid log sampling rate: " + rateStr, nfe);
                }
                expectRuntimeArgs = false;
            }
            if (this.abiListQuery) {
                if (args.length - curArg > 0) {
                    throw new IllegalArgumentException("Unexpected arguments after --query-abi-list.");
                }
            } else if (this.preloadPackage != null) {
                if (args.length - curArg > 0) {
                    throw new IllegalArgumentException("Unexpected arguments after --preload-package.");
                }
            } else if (expectRuntimeArgs) {
                if (!seenRuntimeArgs) {
                    throw new IllegalArgumentException("Unexpected argument : " + args[curArg]);
                }
                this.remainingArgs = new String[args.length - curArg];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)args, (int)curArg, (Object)this.remainingArgs, (int)0, (int)this.remainingArgs.length);
            }
            if (this.startChildZygote) {
                boolean seenChildSocketArg = false;
                for (String arg : this.remainingArgs) {
                    if (!arg.startsWith("--zygote-socket=")) continue;
                    seenChildSocketArg = true;
                    break;
                }
                if (!seenChildSocketArg) {
                    throw new IllegalArgumentException("--start-child-zygote specified without --zygote-socket=");
                }
            }
        }

        private void __constructor__(String[] stringArray) throws IllegalArgumentException {
            this.$$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(stringArray);
        }

        public Arguments(String[] stringArray) throws IllegalArgumentException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(java.lang.String[] ), this, stringArray);
        }

        private void parseArgs(String[] stringArray) throws IllegalArgumentException {
            InvokeDynamicSupport.bootstrap("parseArgs", $$robo$$com_android_internal_os_ZygoteConnection_Arguments$parseArgs(java.lang.String[] ), this, stringArray);
        }

        public /* synthetic */ Arguments() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Arguments)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

