/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telecom.ConferenceParticipant;
import android.telephony.Rlog;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Call
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected String LOG_TAG = "Call";
    public State mState;
    public ArrayList<Connection> mConnections;

    private void $$robo$$com_android_internal_telephony_Call$__constructor__() {
        this.LOG_TAG = "Call";
        this.mState = State.IDLE;
        this.mConnections = new ArrayList();
    }

    private static final State $$robo$$com_android_internal_telephony_Call$stateFromDCState(DriverCall.State dcState) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[dcState.ordinal()]) {
            case 1: {
                return State.ACTIVE;
            }
            case 2: {
                return State.HOLDING;
            }
            case 3: {
                return State.DIALING;
            }
            case 4: {
                return State.ALERTING;
            }
            case 5: {
                return State.INCOMING;
            }
            case 6: {
                return State.WAITING;
            }
        }
        throw new RuntimeException("illegal call state:" + (Object)((Object)dcState));
    }

    public abstract List<Connection> getConnections();

    public abstract Phone getPhone();

    public abstract boolean isMultiparty();

    public abstract void hangup() throws CallStateException;

    private final boolean $$robo$$com_android_internal_telephony_Call$hasConnection(Connection c) {
        return c.getCall() == this;
    }

    private final boolean $$robo$$com_android_internal_telephony_Call$hasConnections() {
        List<Connection> connections = this.getConnections();
        if (connections == null) {
            return false;
        }
        return connections.size() > 0;
    }

    private final State $$robo$$com_android_internal_telephony_Call$getState() {
        return this.mState;
    }

    private final List<ConferenceParticipant> $$robo$$com_android_internal_telephony_Call$getConferenceParticipants() {
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_Call$isIdle() {
        return !this.getState().isAlive();
    }

    private final Connection $$robo$$com_android_internal_telephony_Call$getEarliestConnection() {
        long time = Long.MAX_VALUE;
        Connection earliest = null;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t >= time) continue;
            earliest = c;
            time = t;
        }
        return earliest;
    }

    private final long $$robo$$com_android_internal_telephony_Call$getEarliestCreateTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            time = t < time ? t : time;
        }
        return time;
    }

    private final long $$robo$$com_android_internal_telephony_Call$getEarliestConnectTime() {
        long time = Long.MAX_VALUE;
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return 0L;
        }
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getConnectTime();
            time = t < time ? t : time;
        }
        return time;
    }

    private final boolean $$robo$$com_android_internal_telephony_Call$isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    private final boolean $$robo$$com_android_internal_telephony_Call$isRinging() {
        return this.getState().isRinging();
    }

    private final Connection $$robo$$com_android_internal_telephony_Call$getLatestConnection() {
        List<Connection> l = this.getConnections();
        if (l.size() == 0) {
            return null;
        }
        long time = 0L;
        Connection latest = null;
        int s = l.size();
        for (int i = 0; i < s; ++i) {
            Connection c = l.get(i);
            long t = c.getCreateTime();
            if (t <= time) continue;
            latest = c;
            time = t;
        }
        return latest;
    }

    private final void $$robo$$com_android_internal_telephony_Call$hangupIfAlive() {
        if (this.getState().isAlive()) {
            try {
                this.hangup();
            }
            catch (CallStateException ex) {
                Rlog.w("Call", " hangupIfActive: caught " + ex);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_Call$clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            Connection c = this.mConnections.get(i);
            if (c.getState() != State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.setState(State.IDLE);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Call$setState(State newState) {
        this.mState = newState;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_Call$__constructor__();
    }

    public Call() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Call$__constructor__(), this);
    }

    public static State stateFromDCState(DriverCall.State state) {
        return InvokeDynamicSupport.bootstrapStatic("stateFromDCState", $$robo$$com_android_internal_telephony_Call$stateFromDCState(com.android.internal.telephony.DriverCall$State ), (DriverCall.State)state);
    }

    public boolean hasConnection(Connection connection) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasConnection", $$robo$$com_android_internal_telephony_Call$hasConnection(com.android.internal.telephony.Connection ), this, connection);
    }

    public boolean hasConnections() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasConnections", $$robo$$com_android_internal_telephony_Call$hasConnections(), this);
    }

    public State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_Call$getState(), this);
    }

    public List<ConferenceParticipant> getConferenceParticipants() {
        return InvokeDynamicSupport.bootstrap("getConferenceParticipants", $$robo$$com_android_internal_telephony_Call$getConferenceParticipants(), this);
    }

    public boolean isIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdle", $$robo$$com_android_internal_telephony_Call$isIdle(), this);
    }

    public Connection getEarliestConnection() {
        return InvokeDynamicSupport.bootstrap("getEarliestConnection", $$robo$$com_android_internal_telephony_Call$getEarliestConnection(), this);
    }

    public long getEarliestCreateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEarliestCreateTime", $$robo$$com_android_internal_telephony_Call$getEarliestCreateTime(), this);
    }

    public long getEarliestConnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEarliestConnectTime", $$robo$$com_android_internal_telephony_Call$getEarliestConnectTime(), this);
    }

    public boolean isDialingOrAlerting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDialingOrAlerting", $$robo$$com_android_internal_telephony_Call$isDialingOrAlerting(), this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$com_android_internal_telephony_Call$isRinging(), this);
    }

    public Connection getLatestConnection() {
        return InvokeDynamicSupport.bootstrap("getLatestConnection", $$robo$$com_android_internal_telephony_Call$getLatestConnection(), this);
    }

    public void hangupIfAlive() {
        InvokeDynamicSupport.bootstrap("hangupIfAlive", $$robo$$com_android_internal_telephony_Call$hangupIfAlive(), this);
    }

    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_Call$clearDisconnected(), this);
    }

    protected void setState(State state) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_telephony_Call$setState(com.android.internal.telephony.Call$State ), this, state);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Call)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SrvccState
    extends Enum<SrvccState> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ SrvccState NONE;
        public static /* enum */ SrvccState STARTED;
        public static /* enum */ SrvccState COMPLETED;
        public static /* enum */ SrvccState FAILED;
        public static /* enum */ SrvccState CANCELED;
        private static /* synthetic */ SrvccState[] $VALUES;

        private static final SrvccState[] $$robo$$com_android_internal_telephony_Call_SrvccState$values() {
            return (SrvccState[])$VALUES.clone();
        }

        private static final SrvccState $$robo$$com_android_internal_telephony_Call_SrvccState$valueOf(String name) {
            return Enum.valueOf(SrvccState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_Call_SrvccState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NONE = new SrvccState();
            STARTED = new SrvccState();
            COMPLETED = new SrvccState();
            FAILED = new SrvccState();
            CANCELED = new SrvccState();
            $VALUES = new SrvccState[]{NONE, STARTED, COMPLETED, FAILED, CANCELED};
        }

        public static SrvccState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_Call_SrvccState$values());
        }

        public static SrvccState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_Call_SrvccState$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_Call_SrvccState$__constructor__(string2, n);
        }

        public SrvccState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Call_SrvccState$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SrvccState.class);
        }

        public /* synthetic */ SrvccState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SrvccState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ State IDLE;
        public static /* enum */ State ACTIVE;
        public static /* enum */ State HOLDING;
        public static /* enum */ State DIALING;
        public static /* enum */ State ALERTING;
        public static /* enum */ State INCOMING;
        public static /* enum */ State WAITING;
        public static /* enum */ State DISCONNECTED;
        public static /* enum */ State DISCONNECTING;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$com_android_internal_telephony_Call_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$com_android_internal_telephony_Call_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_Call_State$__constructor__(String string2, int n) {
        }

        private final boolean $$robo$$com_android_internal_telephony_Call_State$isAlive() {
            return this != IDLE && this != DISCONNECTED && this != DISCONNECTING;
        }

        private final boolean $$robo$$com_android_internal_telephony_Call_State$isRinging() {
            return this == INCOMING || this == WAITING;
        }

        private final boolean $$robo$$com_android_internal_telephony_Call_State$isDialing() {
            return this == DIALING || this == ALERTING;
        }

        static void __staticInitializer__() {
            IDLE = new State();
            ACTIVE = new State();
            HOLDING = new State();
            DIALING = new State();
            ALERTING = new State();
            INCOMING = new State();
            WAITING = new State();
            DISCONNECTED = new State();
            DISCONNECTING = new State();
            $VALUES = new State[]{IDLE, ACTIVE, HOLDING, DIALING, ALERTING, INCOMING, WAITING, DISCONNECTED, DISCONNECTING};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_Call_State$values());
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_Call_State$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_Call_State$__constructor__(string2, n);
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Call_State$__constructor__(java.lang.String int ), this, string2, n);
        }

        public boolean isAlive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAlive", $$robo$$com_android_internal_telephony_Call_State$isAlive(), this);
        }

        public boolean isRinging() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$com_android_internal_telephony_Call_State$isRinging(), this);
        }

        public boolean isDialing() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDialing", $$robo$$com_android_internal_telephony_Call_State$isDialing(), this);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

