/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.os.UserHandle;
import android.provider.Telephony;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.lang.invoke.CallSite;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierInfoManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierInfoManager";
    private static String KEY_TYPE = "KEY_TYPE";
    private static int RESET_CARRIER_KEY_RATE_LIMIT = 43200000;
    private long mLastAccessResetCarrierKey;

    private void $$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__() {
        this.mLastAccessResetCarrierKey = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImsiEncryptionInfo $$robo$$com_android_internal_telephony_CarrierInfoManager$getCarrierInfoForImsiEncryption(int keyType, Context context) {
        String mcc = "";
        String mnc = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String simOperator = telephonyManager.getSimOperator();
        if (TextUtils.isEmpty(simOperator)) {
            Log.e("CarrierInfoManager", "Invalid networkOperator: " + simOperator);
            return null;
        }
        mcc = simOperator.substring(0, 3);
        mnc = simOperator.substring(3);
        Log.i("CarrierInfoManager", "using values for mnc, mcc: " + mnc + "," + mcc);
        try (Cursor findCursor = null;){
            ContentResolver mContentResolver = context.getContentResolver();
            String[] columns = new String[]{"public_key", "expiration_time", "key_identifier"};
            findCursor = mContentResolver.query(Telephony.CarrierColumns.CONTENT_URI, columns, "mcc=? and mnc=? and key_type=?", new String[]{mcc, mnc, String.valueOf(keyType)}, null);
            if (findCursor == null || !findCursor.moveToFirst()) {
                Log.d("CarrierInfoManager", "No rows found for keyType: " + keyType);
                ImsiEncryptionInfo imsiEncryptionInfo = null;
                return imsiEncryptionInfo;
            }
            if (findCursor.getCount() > 1) {
                Log.e("CarrierInfoManager", "More than 1 row found for the keyType: " + keyType);
            }
            byte[] carrier_key = findCursor.getBlob(0);
            Date expirationTime = new Date(findCursor.getLong(1));
            String keyIdentifier = findCursor.getString(2);
            ImsiEncryptionInfo imsiEncryptionInfo = new ImsiEncryptionInfo(mcc, mnc, keyType, keyIdentifier, carrier_key, expirationTime);
            return imsiEncryptionInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$updateOrInsertCarrierKey(ImsiEncryptionInfo imsiEncryptionInfo, Context context, int phoneId) {
        byte[] keyBytes = imsiEncryptionInfo.getPublicKey().getEncoded();
        ContentResolver mContentResolver = context.getContentResolver();
        TelephonyMetrics tm = TelephonyMetrics.getInstance();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mcc", imsiEncryptionInfo.getMcc());
        contentValues.put("mnc", imsiEncryptionInfo.getMnc());
        contentValues.put("key_type", imsiEncryptionInfo.getKeyType());
        contentValues.put("key_identifier", imsiEncryptionInfo.getKeyIdentifier());
        contentValues.put("public_key", keyBytes);
        contentValues.put("expiration_time", imsiEncryptionInfo.getExpirationTime().getTime());
        boolean downloadSuccessfull = true;
        try {
            Log.i("CarrierInfoManager", "Inserting imsiEncryptionInfo into db");
            mContentResolver.insert(Telephony.CarrierColumns.CONTENT_URI, contentValues);
        }
        catch (SQLiteConstraintException e) {
            Log.i("CarrierInfoManager", "Insert failed, updating imsiEncryptionInfo into db");
            ContentValues updatedValues = new ContentValues();
            updatedValues.put("public_key", keyBytes);
            updatedValues.put("expiration_time", imsiEncryptionInfo.getExpirationTime().getTime());
            updatedValues.put("key_identifier", imsiEncryptionInfo.getKeyIdentifier());
            try {
                int nRows = mContentResolver.update(Telephony.CarrierColumns.CONTENT_URI, updatedValues, "mcc=? and mnc=? and key_type=?", new String[]{imsiEncryptionInfo.getMcc(), imsiEncryptionInfo.getMnc(), String.valueOf(imsiEncryptionInfo.getKeyType())});
                if (nRows == 0) {
                    Log.d("CarrierInfoManager", "Error updating values:" + imsiEncryptionInfo);
                    downloadSuccessfull = false;
                }
            }
            catch (Exception ex) {
                Log.d("CarrierInfoManager", "Error updating values:" + imsiEncryptionInfo + ex);
                downloadSuccessfull = false;
            }
        }
        catch (Exception e) {
            Log.d("CarrierInfoManager", "Error inserting/updating values:" + imsiEncryptionInfo + e);
            downloadSuccessfull = false;
        }
        finally {
            tm.writeCarrierKeyEvent(phoneId, imsiEncryptionInfo.getKeyType(), downloadSuccessfull);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Context context, int phoneId) {
        Log.i("CarrierInfoManager", "inserting carrier key: " + imsiEncryptionInfo);
        CarrierInfoManager.updateOrInsertCarrierKey(imsiEncryptionInfo, context, phoneId);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierInfoManager$resetCarrierKeysForImsiEncryption(Context context, int mPhoneId) {
        Log.i("CarrierInfoManager", "resetting carrier key");
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (now - this.mLastAccessResetCarrierKey < 43200000L) {
            Log.i("CarrierInfoManager", "resetCarrierKeysForImsiEncryption: Access rate exceeded");
            return;
        }
        this.mLastAccessResetCarrierKey = (long)now;
        CarrierInfoManager.deleteCarrierInfoForImsiEncryption(context);
        Intent resetIntent = new Intent("com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD");
        resetIntent.putExtra("phone", mPhoneId);
        context.sendBroadcastAsUser(resetIntent, UserHandle.ALL);
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$deleteCarrierInfoForImsiEncryption(Context context) {
        Log.i("CarrierInfoManager", "deleting carrier key from db");
        String mcc = "";
        String mnc = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String simOperator = telephonyManager.getSimOperator();
        if (TextUtils.isEmpty(simOperator)) {
            Log.e("CarrierInfoManager", "Invalid networkOperator: " + simOperator);
            return;
        }
        mcc = simOperator.substring(0, 3);
        mnc = simOperator.substring(3);
        ContentResolver mContentResolver = context.getContentResolver();
        try {
            String whereClause = "mcc=? and mnc=?";
            String[] whereArgs = new String[]{mcc, mnc};
            mContentResolver.delete(Telephony.CarrierColumns.CONTENT_URI, whereClause, whereArgs);
        }
        catch (Exception e) {
            Log.e("CarrierInfoManager", "Delete failed" + e);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$deleteAllCarrierKeysForImsiEncryption(Context context) {
        Log.i("CarrierInfoManager", "deleting ALL carrier keys from db");
        ContentResolver mContentResolver = context.getContentResolver();
        try {
            mContentResolver.delete(Telephony.CarrierColumns.CONTENT_URI, null, null);
        }
        catch (Exception e) {
            Log.e("CarrierInfoManager", "Delete failed" + e);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__();
    }

    public CarrierInfoManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__(), this);
    }

    public static ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int n, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$getCarrierInfoForImsiEncryption(int android.content.Context ), (int)n, (Context)context);
    }

    public static void updateOrInsertCarrierKey(ImsiEncryptionInfo imsiEncryptionInfo, Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("updateOrInsertCarrierKey", $$robo$$com_android_internal_telephony_CarrierInfoManager$updateOrInsertCarrierKey(android.telephony.ImsiEncryptionInfo android.content.Context int ), (ImsiEncryptionInfo)imsiEncryptionInfo, (Context)context, (int)n);
    }

    public static void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo android.content.Context int ), (ImsiEncryptionInfo)imsiEncryptionInfo, (Context)context, (int)n);
    }

    public void resetCarrierKeysForImsiEncryption(Context context, int n) {
        InvokeDynamicSupport.bootstrap("resetCarrierKeysForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$resetCarrierKeysForImsiEncryption(android.content.Context int ), this, context, n);
    }

    public static void deleteCarrierInfoForImsiEncryption(Context context) {
        InvokeDynamicSupport.bootstrapStatic("deleteCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$deleteCarrierInfoForImsiEncryption(android.content.Context ), (Context)context);
    }

    public static void deleteAllCarrierKeysForImsiEncryption(Context context) {
        InvokeDynamicSupport.bootstrapStatic("deleteAllCarrierKeysForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$deleteAllCarrierKeysForImsiEncryption(android.content.Context ), (Context)context);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierInfoManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

