/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Message;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.SmsCbMessage;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.WakeLockStateMachine;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CellBroadcastHandler
extends WakeLockStateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(Context context, Phone phone) {
    }

    private void $$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(String debugTag, Context context, Phone phone) {
    }

    private static final CellBroadcastHandler $$robo$$com_android_internal_telephony_CellBroadcastHandler$makeCellBroadcastHandler(Context context, Phone phone) {
        CellBroadcastHandler handler = new CellBroadcastHandler(context, phone);
        handler.start();
        return handler;
    }

    private final boolean $$robo$$com_android_internal_telephony_CellBroadcastHandler$handleSmsMessage(Message message) {
        if (message.obj instanceof SmsCbMessage) {
            this.handleBroadcastSms((SmsCbMessage)message.obj);
            return true;
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_CellBroadcastHandler$handleBroadcastSms(SmsCbMessage message) {
        String additionalPackage;
        int appOp;
        String receiverPermission;
        Intent intent;
        TelephonyMetrics metrics = TelephonyMetrics.getInstance();
        metrics.writeNewCBSms(this.mPhone.getPhoneId(), message.getMessageFormat(), message.getMessagePriority(), message.isCmasMessage(), message.isEtwsMessage(), message.getServiceCategory());
        if (message.isEmergencyMessage()) {
            this.log("Dispatching emergency SMS CB, SmsCbMessage is: " + message);
            intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
            intent.setPackage(this.mContext.getResources().getString(17039652));
            receiverPermission = "android.permission.RECEIVE_EMERGENCY_BROADCAST";
            appOp = 17;
        } else {
            this.log("Dispatching SMS CB, SmsCbMessage is: " + message);
            intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
            intent.addFlags(0x1000000);
            receiverPermission = "android.permission.RECEIVE_SMS";
            appOp = 16;
        }
        intent.putExtra("message", message);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        if (Build.IS_DEBUGGABLE && (additionalPackage = Settings.Secure.getString(this.mContext.getContentResolver(), "cmas_additional_broadcast_pkg")) != null) {
            Intent additionalIntent = new Intent(intent);
            additionalIntent.setPackage(additionalPackage);
            this.mContext.sendOrderedBroadcastAsUser(additionalIntent, UserHandle.ALL, receiverPermission, appOp, null, this.getHandler(), -1, null, null);
        }
        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, receiverPermission, appOp, this.mReceiver, this.getHandler(), -1, null, null);
    }

    private void __constructor__(Context context, Phone phone) {
        this.$$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(context, phone);
    }

    public CellBroadcastHandler(Context context, Phone phone) {
        this("CellBroadcastHandler", context, phone);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(android.content.Context com.android.internal.telephony.Phone ), this, context, phone);
    }

    private void __constructor__(String string2, Context context, Phone phone) {
        this.$$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(string2, context, phone);
    }

    public CellBroadcastHandler(String string2, Context context, Phone phone) {
        super(string2, context, phone);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CellBroadcastHandler$__constructor__(java.lang.String android.content.Context com.android.internal.telephony.Phone ), this, string2, context, phone);
    }

    public static CellBroadcastHandler makeCellBroadcastHandler(Context context, Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("makeCellBroadcastHandler", $$robo$$com_android_internal_telephony_CellBroadcastHandler$makeCellBroadcastHandler(android.content.Context com.android.internal.telephony.Phone ), (Context)context, (Phone)phone);
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleSmsMessage", $$robo$$com_android_internal_telephony_CellBroadcastHandler$handleSmsMessage(android.os.Message ), this, message);
    }

    protected void handleBroadcastSms(SmsCbMessage smsCbMessage) {
        InvokeDynamicSupport.bootstrap("handleBroadcastSms", $$robo$$com_android_internal_telephony_CellBroadcastHandler$handleBroadcastSms(android.telephony.SmsCbMessage ), this, smsCbMessage);
    }

    public /* synthetic */ CellBroadcastHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellBroadcastHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

