/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.DisplayManager;
import android.os.BatteryManager;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.LocalLog;
import android.util.SparseIntArray;
import android.view.Display;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DeviceStateMonitor
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected static boolean DBG = false;
    protected static String TAG;
    private static int EVENT_RIL_CONNECTED = 0;
    private static int EVENT_UPDATE_MODE_CHANGED = 1;
    private static int EVENT_SCREEN_STATE_CHANGED = 2;
    private static int EVENT_POWER_SAVE_MODE_CHANGED = 3;
    private static int EVENT_CHARGING_STATE_CHANGED = 4;
    private static int EVENT_TETHERING_STATE_CHANGED = 5;
    private static int HYSTERESIS_KBPS = 50;
    private Phone mPhone;
    private LocalLog mLocalLog;
    private boolean mIsTetheringOn;
    private boolean mIsScreenOn;
    private boolean mIsCharging;
    private boolean mIsPowerSaveOn;
    private boolean mIsLowDataExpected;
    private SparseIntArray mUpdateModes;
    private int mUnsolicitedResponseFilter;
    private DisplayManager.DisplayListener mDisplayListener;
    private BroadcastReceiver mBroadcastReceiver;
    private static int[] LINK_CAPACITY_DOWNLINK_THRESHOLDS;
    private static int[] LINK_CAPACITY_UPLINK_THRESHOLDS;

    private void $$robo$$com_android_internal_telephony_DeviceStateMonitor$__constructor__(Phone phone) {
        this.mLocalLog = new LocalLog(100);
        this.mUpdateModes = new SparseIntArray();
        this.mUnsolicitedResponseFilter = -1;
        this.mDisplayListener = new DisplayManager.DisplayListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DeviceStateMonitor this$0;

            private void $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$__constructor__(DeviceStateMonitor this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayAdded(int displayId) {
            }

            private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayRemoved(int displayId) {
            }

            private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayChanged(int displayId) {
                boolean screenOn = this.this$0.isScreenOn();
                Message msg = this.this$0.obtainMessage(2);
                msg.arg1 = screenOn ? 1 : 0;
                this.this$0.sendMessage(msg);
            }

            private void __constructor__(DeviceStateMonitor deviceStateMonitor) {
                this.$$robo$$com_android_internal_telephony_DeviceStateMonitor_1$__constructor__(deviceStateMonitor);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$__constructor__(com.android.internal.telephony.DeviceStateMonitor ), this, deviceStateMonitor);
            }

            @Override
            public void onDisplayAdded(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayAdded", $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayAdded(int ), this, n);
            }

            @Override
            public void onDisplayRemoved(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayRemoved", $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayRemoved(int ), this, n);
            }

            @Override
            public void onDisplayChanged(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayChanged", $$robo$$com_android_internal_telephony_DeviceStateMonitor_1$onDisplayChanged(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBroadcastReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DeviceStateMonitor this$0;

            private void $$robo$$com_android_internal_telephony_DeviceStateMonitor_2$__constructor__(DeviceStateMonitor this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor_2$onReceive(Context context, Intent intent) {
                Message msg;
                this.this$0.log("received: " + intent, true);
                switch (intent.getAction()) {
                    case "android.os.action.POWER_SAVE_MODE_CHANGED": {
                        msg = this.this$0.obtainMessage(3);
                        msg.arg1 = this.this$0.isPowerSaveModeOn() ? 1 : 0;
                        this.this$0.log("Power Save mode " + (msg.arg1 == 1 ? "on" : "off"), true);
                        break;
                    }
                    case "android.os.action.CHARGING": {
                        msg = this.this$0.obtainMessage(4);
                        msg.arg1 = 1;
                        break;
                    }
                    case "android.os.action.DISCHARGING": {
                        msg = this.this$0.obtainMessage(4);
                        msg.arg1 = 0;
                        break;
                    }
                    case "android.net.conn.TETHER_STATE_CHANGED": {
                        ArrayList<String> activeTetherIfaces = intent.getStringArrayListExtra("tetherArray");
                        boolean isTetheringOn = activeTetherIfaces != null && activeTetherIfaces.size() > 0;
                        this.this$0.log("Tethering " + (isTetheringOn ? "on" : "off"), true);
                        msg = this.this$0.obtainMessage(5);
                        msg.arg1 = isTetheringOn ? 1 : 0;
                        break;
                    }
                    default: {
                        this.this$0.log("Unexpected broadcast intent: " + intent, false);
                        return;
                    }
                }
                this.this$0.sendMessage(msg);
            }

            private void __constructor__(DeviceStateMonitor deviceStateMonitor) {
                this.$$robo$$com_android_internal_telephony_DeviceStateMonitor_2$__constructor__(deviceStateMonitor);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_DeviceStateMonitor_2$__constructor__(com.android.internal.telephony.DeviceStateMonitor ), this, deviceStateMonitor);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_DeviceStateMonitor_2$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        DisplayManager dm = (DisplayManager)phone.getContext().getSystemService("display");
        dm.registerDisplayListener(this.mDisplayListener, null);
        this.mIsPowerSaveOn = this.isPowerSaveModeOn();
        this.mIsCharging = this.isDeviceCharging();
        this.mIsScreenOn = this.isScreenOn();
        this.mIsTetheringOn = false;
        this.mIsLowDataExpected = false;
        this.log("DeviceStateMonitor mIsPowerSaveOn=" + this.mIsPowerSaveOn + ",mIsScreenOn=" + this.mIsScreenOn + ",mIsCharging=" + this.mIsCharging, false);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
        filter.addAction("android.os.action.CHARGING");
        filter.addAction("android.os.action.DISCHARGING");
        filter.addAction("android.net.conn.TETHER_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mBroadcastReceiver, filter, null, this.mPhone);
        this.mPhone.mCi.registerForRilConnected(this, 0, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$isLowDataExpected() {
        return !this.mIsCharging && !this.mIsTetheringOn && !this.mIsScreenOn;
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffSignalStrength() {
        return !this.mIsCharging && !this.mIsScreenOn && this.mUpdateModes.get(1) != 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffFullNetworkUpdate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(2) != 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffDormancyUpdate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(4) != 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffLinkCapacityEstimate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(8) != 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffPhysicalChannelConfig() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(16) != 2;
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$setIndicationUpdateMode(int filters, int mode) {
        this.sendMessage(this.obtainMessage(1, filters, mode));
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$onSetIndicationUpdateMode(int filters, int mode) {
        if ((filters & 1) != 0) {
            this.mUpdateModes.put(1, mode);
        }
        if ((filters & 2) != 0) {
            this.mUpdateModes.put(2, mode);
        }
        if ((filters & 4) != 0) {
            this.mUpdateModes.put(4, mode);
        }
        if ((filters & 8) != 0) {
            this.mUpdateModes.put(8, mode);
        }
        if ((filters & 0x10) != 0) {
            this.mUpdateModes.put(16, mode);
        }
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$handleMessage(Message msg) {
        this.log("handleMessage msg=" + msg, false);
        switch (msg.what) {
            case 0: {
                this.onRilConnected();
                break;
            }
            case 1: {
                this.onSetIndicationUpdateMode(msg.arg1, msg.arg2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.onUpdateDeviceState(msg.what, msg.arg1 != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message arrives. msg = " + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$onUpdateDeviceState(int eventType, boolean state) {
        switch (eventType) {
            case 2: {
                if (this.mIsScreenOn == state) {
                    return;
                }
                this.mIsScreenOn = state;
                break;
            }
            case 4: {
                if (this.mIsCharging == state) {
                    return;
                }
                this.mIsCharging = state;
                this.sendDeviceState(1, this.mIsCharging);
                break;
            }
            case 5: {
                if (this.mIsTetheringOn == state) {
                    return;
                }
                this.mIsTetheringOn = state;
                break;
            }
            case 3: {
                if (this.mIsPowerSaveOn == state) {
                    return;
                }
                this.mIsPowerSaveOn = state;
                this.sendDeviceState(0, this.mIsPowerSaveOn);
                break;
            }
            default: {
                return;
            }
        }
        if (this.mIsLowDataExpected != this.isLowDataExpected()) {
            this.mIsLowDataExpected = !this.mIsLowDataExpected;
            this.sendDeviceState(2, this.mIsLowDataExpected);
        }
        int newFilter = 0;
        if (!this.shouldTurnOffSignalStrength()) {
            newFilter |= 1;
        }
        if (!this.shouldTurnOffFullNetworkUpdate()) {
            newFilter |= 2;
        }
        if (!this.shouldTurnOffDormancyUpdate()) {
            newFilter |= 4;
        }
        if (!this.shouldTurnOffLinkCapacityEstimate()) {
            newFilter |= 8;
        }
        if (!this.shouldTurnOffPhysicalChannelConfig()) {
            newFilter |= 0x10;
        }
        this.setUnsolResponseFilter(newFilter, false);
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$onRilConnected() {
        this.log("RIL connected.", true);
        this.sendDeviceState(1, this.mIsCharging);
        this.sendDeviceState(2, this.mIsLowDataExpected);
        this.sendDeviceState(0, this.mIsPowerSaveOn);
        this.setUnsolResponseFilter(this.mUnsolicitedResponseFilter, true);
        this.setSignalStrengthReportingCriteria();
        this.setLinkCapacityReportingCriteria();
    }

    private final String $$robo$$com_android_internal_telephony_DeviceStateMonitor$deviceTypeToString(int type) {
        switch (type) {
            case 1: {
                return "CHARGING_STATE";
            }
            case 2: {
                return "LOW_DATA_EXPECTED";
            }
            case 0: {
                return "POWER_SAVE_MODE";
            }
        }
        return "UNKNOWN";
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$sendDeviceState(int type, boolean state) {
        this.log("send type: " + this.deviceTypeToString(type) + ", state=" + state, true);
        this.mPhone.mCi.sendDeviceState(type, state, null);
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$setUnsolResponseFilter(int newFilter, boolean force) {
        if (force || newFilter != this.mUnsolicitedResponseFilter) {
            this.log("old filter: " + this.mUnsolicitedResponseFilter + ", new filter: " + newFilter, true);
            this.mPhone.mCi.setUnsolResponseFilter(newFilter, null);
            this.mUnsolicitedResponseFilter = newFilter;
        }
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$setSignalStrengthReportingCriteria() {
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.GERAN, 1);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.UTRAN, 2);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.EUTRAN, 3);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.CDMA2000, 4);
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$setLinkCapacityReportingCriteria() {
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 1);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 2);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 3);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 4);
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$isPowerSaveModeOn() {
        PowerManager pm = (PowerManager)this.mPhone.getContext().getSystemService("power");
        return pm.isPowerSaveMode();
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$isDeviceCharging() {
        BatteryManager bm = (BatteryManager)this.mPhone.getContext().getSystemService("batterymanager");
        return bm.isCharging();
    }

    private final boolean $$robo$$com_android_internal_telephony_DeviceStateMonitor$isScreenOn() {
        DisplayManager dm = (DisplayManager)this.mPhone.getContext().getSystemService("display");
        Display[] displays = dm.getDisplays();
        if (displays != null) {
            for (Display display : displays) {
                if (display.getState() != 2) continue;
                this.log("Screen " + Display.typeToString(display.getType()) + " on", true);
                return true;
            }
            this.log("Screens all off", true);
            return false;
        }
        this.log("No displays found", true);
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$log(String msg, boolean logIntoLocalLog) {
        if (logIntoLocalLog) {
            this.mLocalLog.log(msg);
        }
    }

    private final void $$robo$$com_android_internal_telephony_DeviceStateMonitor$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.increaseIndent();
        ipw.println("mIsTetheringOn=" + this.mIsTetheringOn);
        ipw.println("mIsScreenOn=" + this.mIsScreenOn);
        ipw.println("mIsCharging=" + this.mIsCharging);
        ipw.println("mIsPowerSaveOn=" + this.mIsPowerSaveOn);
        ipw.println("mIsLowDataExpected=" + this.mIsLowDataExpected);
        ipw.println("mUnsolicitedResponseFilter=" + this.mUnsolicitedResponseFilter);
        ipw.println("Local logs:");
        ipw.increaseIndent();
        this.mLocalLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.decreaseIndent();
        ipw.flush();
    }

    static void __staticInitializer__() {
        TAG = DeviceStateMonitor.class.getSimpleName();
        LINK_CAPACITY_DOWNLINK_THRESHOLDS = new int[]{500, 1000, 5000, 10000, 20000};
        LINK_CAPACITY_UPLINK_THRESHOLDS = new int[]{100, 500, 1000, 5000, 10000};
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_DeviceStateMonitor$__constructor__(phone);
    }

    public DeviceStateMonitor(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_DeviceStateMonitor$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    private boolean isLowDataExpected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLowDataExpected", $$robo$$com_android_internal_telephony_DeviceStateMonitor$isLowDataExpected(), this);
    }

    private boolean shouldTurnOffSignalStrength() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldTurnOffSignalStrength", $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffSignalStrength(), this);
    }

    private boolean shouldTurnOffFullNetworkUpdate() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldTurnOffFullNetworkUpdate", $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffFullNetworkUpdate(), this);
    }

    private boolean shouldTurnOffDormancyUpdate() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldTurnOffDormancyUpdate", $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffDormancyUpdate(), this);
    }

    private boolean shouldTurnOffLinkCapacityEstimate() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldTurnOffLinkCapacityEstimate", $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffLinkCapacityEstimate(), this);
    }

    private boolean shouldTurnOffPhysicalChannelConfig() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldTurnOffPhysicalChannelConfig", $$robo$$com_android_internal_telephony_DeviceStateMonitor$shouldTurnOffPhysicalChannelConfig(), this);
    }

    public void setIndicationUpdateMode(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setIndicationUpdateMode", $$robo$$com_android_internal_telephony_DeviceStateMonitor$setIndicationUpdateMode(int int ), this, n, n2);
    }

    private void onSetIndicationUpdateMode(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSetIndicationUpdateMode", $$robo$$com_android_internal_telephony_DeviceStateMonitor$onSetIndicationUpdateMode(int int ), this, n, n2);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_DeviceStateMonitor$handleMessage(android.os.Message ), this, message);
    }

    private void onUpdateDeviceState(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onUpdateDeviceState", $$robo$$com_android_internal_telephony_DeviceStateMonitor$onUpdateDeviceState(int boolean ), this, n, bl);
    }

    private void onRilConnected() {
        InvokeDynamicSupport.bootstrap("onRilConnected", $$robo$$com_android_internal_telephony_DeviceStateMonitor$onRilConnected(), this);
    }

    private String deviceTypeToString(int n) {
        return InvokeDynamicSupport.bootstrap("deviceTypeToString", $$robo$$com_android_internal_telephony_DeviceStateMonitor$deviceTypeToString(int ), this, n);
    }

    private void sendDeviceState(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendDeviceState", $$robo$$com_android_internal_telephony_DeviceStateMonitor$sendDeviceState(int boolean ), this, n, bl);
    }

    private void setUnsolResponseFilter(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnsolResponseFilter", $$robo$$com_android_internal_telephony_DeviceStateMonitor$setUnsolResponseFilter(int boolean ), this, n, bl);
    }

    private void setSignalStrengthReportingCriteria() {
        InvokeDynamicSupport.bootstrap("setSignalStrengthReportingCriteria", $$robo$$com_android_internal_telephony_DeviceStateMonitor$setSignalStrengthReportingCriteria(), this);
    }

    private void setLinkCapacityReportingCriteria() {
        InvokeDynamicSupport.bootstrap("setLinkCapacityReportingCriteria", $$robo$$com_android_internal_telephony_DeviceStateMonitor$setLinkCapacityReportingCriteria(), this);
    }

    private boolean isPowerSaveModeOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPowerSaveModeOn", $$robo$$com_android_internal_telephony_DeviceStateMonitor$isPowerSaveModeOn(), this);
    }

    private boolean isDeviceCharging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceCharging", $$robo$$com_android_internal_telephony_DeviceStateMonitor$isDeviceCharging(), this);
    }

    private boolean isScreenOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenOn", $$robo$$com_android_internal_telephony_DeviceStateMonitor$isScreenOn(), this);
    }

    private void log(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_DeviceStateMonitor$log(java.lang.String boolean ), this, string2, bl);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_DeviceStateMonitor$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DeviceStateMonitor.class);
    }

    public /* synthetic */ DeviceStateMonitor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeviceStateMonitor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class AccessNetworkThresholds
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int[] GERAN;
        public static int[] UTRAN;
        public static int[] EUTRAN;
        public static int[] CDMA2000;

        private void $$robo$$com_android_internal_telephony_DeviceStateMonitor_AccessNetworkThresholds$__constructor__() {
        }

        static void __staticInitializer__() {
            GERAN = new int[]{-109, -103, -97, -89};
            UTRAN = new int[]{-114, -104, -94, -84};
            EUTRAN = new int[]{-140, -128, -118, -108, -98, -44};
            CDMA2000 = new int[]{-105, -90, -75, -65};
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_DeviceStateMonitor_AccessNetworkThresholds$__constructor__();
        }

        public AccessNetworkThresholds() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_DeviceStateMonitor_AccessNetworkThresholds$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(AccessNetworkThresholds.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessNetworkThresholds)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

