/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.app.LocaleStore;
import com.android.internal.telephony.TimeServiceHelper;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import libcore.icu.ICU;
import libcore.util.TimeZoneFinder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MccTable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "MccTable";
    static ArrayList<MccEntry> sTable;
    private static Map<Locale, Locale> FALLBACKS;

    private void $$robo$$com_android_internal_telephony_MccTable$__constructor__() {
    }

    private static final MccEntry $$robo$$com_android_internal_telephony_MccTable$entryForMcc(int mcc) {
        MccEntry m = new MccEntry(mcc, "", 0);
        int index = Collections.binarySearch(sTable, m);
        if (index < 0) {
            return null;
        }
        return sTable.get(index);
    }

    private static final String $$robo$$com_android_internal_telephony_MccTable$defaultTimeZoneForMcc(int mcc) {
        MccEntry entry = MccTable.entryForMcc(mcc);
        if (entry == null) {
            return null;
        }
        String lowerCaseCountryCode = entry.mIso;
        return TimeZoneFinder.getInstance().lookupDefaultTimeZoneIdByCountry(lowerCaseCountryCode);
    }

    private static final String $$robo$$com_android_internal_telephony_MccTable$countryCodeForMcc(int mcc) {
        MccEntry entry = MccTable.entryForMcc(mcc);
        if (entry == null) {
            return "";
        }
        return entry.mIso;
    }

    private static final String $$robo$$com_android_internal_telephony_MccTable$defaultLanguageForMcc(int mcc) {
        MccEntry entry = MccTable.entryForMcc(mcc);
        if (entry == null) {
            Slog.d("MccTable", "defaultLanguageForMcc(" + mcc + "): no country for mcc");
            return null;
        }
        String country = entry.mIso;
        if ("in".equals(country)) {
            return "en";
        }
        Locale likelyLocale = ICU.addLikelySubtags(new Locale("und", country));
        String likelyLanguage = likelyLocale.getLanguage();
        Slog.d("MccTable", "defaultLanguageForMcc(" + mcc + "): country " + country + " uses " + likelyLanguage);
        return likelyLanguage;
    }

    private static final int $$robo$$com_android_internal_telephony_MccTable$smallestDigitsMccForMnc(int mcc) {
        MccEntry entry = MccTable.entryForMcc(mcc);
        if (entry == null) {
            return 2;
        }
        return entry.mSmallestDigitsMnc;
    }

    private static final void $$robo$$com_android_internal_telephony_MccTable$updateMccMncConfiguration(Context context, String mccmnc, boolean fromServiceState) {
        block13: {
            String overrideMcc;
            Slog.d("MccTable", "updateMccMncConfiguration mccmnc='" + mccmnc + "' fromServiceState=" + fromServiceState);
            if (Build.IS_DEBUGGABLE && !TextUtils.isEmpty(overrideMcc = SystemProperties.get("persist.sys.override_mcc"))) {
                mccmnc = overrideMcc;
                Slog.d("MccTable", "updateMccMncConfiguration overriding mccmnc='" + mccmnc + "'");
            }
            if (!TextUtils.isEmpty(mccmnc)) {
                int mnc;
                int mcc;
                String defaultMccMnc = TelephonyManager.getDefault().getSimOperatorNumeric();
                Slog.d("MccTable", "updateMccMncConfiguration defaultMccMnc=" + defaultMccMnc);
                try {
                    mcc = Integer.parseInt(mccmnc.substring(0, 3));
                    mnc = Integer.parseInt(mccmnc.substring(3));
                }
                catch (NumberFormatException e) {
                    Slog.e("MccTable", "Error parsing IMSI: " + mccmnc);
                    return;
                }
                Slog.d("MccTable", "updateMccMncConfiguration: mcc=" + mcc + ", mnc=" + mnc);
                if (mcc != 0) {
                    MccTable.setTimezoneFromMccIfNeeded(context, mcc);
                }
                if (fromServiceState) {
                    MccTable.setWifiCountryCodeFromMcc(context, mcc);
                } else {
                    try {
                        Configuration config = new Configuration();
                        boolean updateConfig = false;
                        if (mcc != 0) {
                            config.mcc = mcc;
                            config.mnc = mnc == 0 ? 65535 : mnc;
                            updateConfig = true;
                        }
                        if (updateConfig) {
                            Slog.d("MccTable", "updateMccMncConfiguration updateConfig config=" + config);
                            ActivityManager.getService().updateConfiguration(config);
                            break block13;
                        }
                        Slog.d("MccTable", "updateMccMncConfiguration nothing to update");
                    }
                    catch (RemoteException e) {
                        Slog.e("MccTable", "Can't update configuration", e);
                    }
                }
            } else if (fromServiceState) {
                MccTable.setWifiCountryCodeFromMcc(context, 0);
            }
        }
    }

    private static final Locale $$robo$$com_android_internal_telephony_MccTable$lookupFallback(Locale target, List<Locale> candidates) {
        Locale fallback = target;
        while ((fallback = FALLBACKS.get(fallback)) != null) {
            if (!candidates.contains(fallback)) continue;
            return fallback;
        }
        return null;
    }

    private static final Locale $$robo$$com_android_internal_telephony_MccTable$getLocaleForLanguageCountry(Context context, String language, String country) {
        if (language == null) {
            Slog.d("MccTable", "getLocaleForLanguageCountry: skipping no language");
            return null;
        }
        if (country == null) {
            country = "";
        }
        Locale target = new Locale(language, country);
        try {
            String[] localeArray = context.getAssets().getLocales();
            ArrayList<String> locales = new ArrayList<String>(Arrays.asList(localeArray));
            locales.remove("ar-XB");
            locales.remove("en-XA");
            ArrayList<Locale> languageMatches = new ArrayList<Locale>();
            for (String locale : locales) {
                Locale l = Locale.forLanguageTag(locale.replace('_', '-'));
                if (l == null || "und".equals(l.getLanguage()) || l.getLanguage().isEmpty() || l.getCountry().isEmpty() || !l.getLanguage().equals(target.getLanguage())) continue;
                if (l.getCountry().equals(target.getCountry())) {
                    Slog.d("MccTable", "getLocaleForLanguageCountry: got perfect match: " + l.toLanguageTag());
                    return l;
                }
                languageMatches.add(l);
            }
            if (languageMatches.isEmpty()) {
                Slog.d("MccTable", "getLocaleForLanguageCountry: no locales for language " + language);
                return null;
            }
            Locale bestMatch = MccTable.lookupFallback(target, languageMatches);
            if (bestMatch != null) {
                Slog.d("MccTable", "getLocaleForLanguageCountry: got a fallback match: " + bestMatch.toLanguageTag());
                return bestMatch;
            }
            if (!TextUtils.isEmpty(target.getCountry())) {
                LocaleStore.fillCache(context);
                LocaleStore.LocaleInfo targetInfo = LocaleStore.getLocaleInfo(target);
                if (targetInfo.isTranslated()) {
                    Slog.d("MccTable", "getLocaleForLanguageCountry: target locale is translated: " + target);
                    return target;
                }
            }
            Slog.d("MccTable", "getLocaleForLanguageCountry: got language-only match: " + language);
            return (Locale)languageMatches.get(0);
        }
        catch (Exception e) {
            Slog.d("MccTable", "getLocaleForLanguageCountry: exception", e);
            return null;
        }
    }

    private static final void $$robo$$com_android_internal_telephony_MccTable$setTimezoneFromMccIfNeeded(Context context, int mcc) {
        String zoneId;
        if (!TimeServiceHelper.isTimeZoneSettingInitializedStatic() && (zoneId = MccTable.defaultTimeZoneForMcc(mcc)) != null && zoneId.length() > 0) {
            TimeServiceHelper.setDeviceTimeZoneStatic(context, zoneId);
            Slog.d("MccTable", "timezone set to " + zoneId);
        }
    }

    private static final Locale $$robo$$com_android_internal_telephony_MccTable$getLocaleFromMcc(Context context, int mcc, String simLanguage) {
        boolean hasSimLanguage = !TextUtils.isEmpty(simLanguage);
        String language = hasSimLanguage ? simLanguage : MccTable.defaultLanguageForMcc(mcc);
        String country = MccTable.countryCodeForMcc(mcc);
        Slog.d("MccTable", "getLocaleFromMcc(" + language + ", " + country + ", " + mcc);
        Locale locale = MccTable.getLocaleForLanguageCountry(context, language, country);
        if (locale == null && hasSimLanguage) {
            language = MccTable.defaultLanguageForMcc(mcc);
            Slog.d("MccTable", "[retry ] getLocaleFromMcc(" + language + ", " + country + ", " + mcc);
            return MccTable.getLocaleForLanguageCountry(context, language, country);
        }
        return locale;
    }

    private static final void $$robo$$com_android_internal_telephony_MccTable$setWifiCountryCodeFromMcc(Context context, int mcc) {
        String country = MccTable.countryCodeForMcc(mcc);
        Slog.d("MccTable", "WIFI_COUNTRY_CODE set to " + country);
        WifiManager wM = (WifiManager)context.getSystemService("wifi");
        wM.setCountryCode(country);
    }

    static void __staticInitializer__() {
        FALLBACKS = new HashMap<Locale, Locale>();
        FALLBACKS.put(Locale.ENGLISH, Locale.US);
        sTable = new ArrayList(240);
        sTable.add(new MccEntry(202, "gr", 2));
        sTable.add(new MccEntry(204, "nl", 2));
        sTable.add(new MccEntry(206, "be", 2));
        sTable.add(new MccEntry(208, "fr", 2));
        sTable.add(new MccEntry(212, "mc", 2));
        sTable.add(new MccEntry(213, "ad", 2));
        sTable.add(new MccEntry(214, "es", 2));
        sTable.add(new MccEntry(216, "hu", 2));
        sTable.add(new MccEntry(218, "ba", 2));
        sTable.add(new MccEntry(219, "hr", 2));
        sTable.add(new MccEntry(220, "rs", 2));
        sTable.add(new MccEntry(222, "it", 2));
        sTable.add(new MccEntry(225, "va", 2));
        sTable.add(new MccEntry(226, "ro", 2));
        sTable.add(new MccEntry(228, "ch", 2));
        sTable.add(new MccEntry(230, "cz", 2));
        sTable.add(new MccEntry(231, "sk", 2));
        sTable.add(new MccEntry(232, "at", 2));
        sTable.add(new MccEntry(234, "gb", 2));
        sTable.add(new MccEntry(235, "gb", 2));
        sTable.add(new MccEntry(238, "dk", 2));
        sTable.add(new MccEntry(240, "se", 2));
        sTable.add(new MccEntry(242, "no", 2));
        sTable.add(new MccEntry(244, "fi", 2));
        sTable.add(new MccEntry(246, "lt", 2));
        sTable.add(new MccEntry(247, "lv", 2));
        sTable.add(new MccEntry(248, "ee", 2));
        sTable.add(new MccEntry(250, "ru", 2));
        sTable.add(new MccEntry(255, "ua", 2));
        sTable.add(new MccEntry(257, "by", 2));
        sTable.add(new MccEntry(259, "md", 2));
        sTable.add(new MccEntry(260, "pl", 2));
        sTable.add(new MccEntry(262, "de", 2));
        sTable.add(new MccEntry(266, "gi", 2));
        sTable.add(new MccEntry(268, "pt", 2));
        sTable.add(new MccEntry(270, "lu", 2));
        sTable.add(new MccEntry(272, "ie", 2));
        sTable.add(new MccEntry(274, "is", 2));
        sTable.add(new MccEntry(276, "al", 2));
        sTable.add(new MccEntry(278, "mt", 2));
        sTable.add(new MccEntry(280, "cy", 2));
        sTable.add(new MccEntry(282, "ge", 2));
        sTable.add(new MccEntry(283, "am", 2));
        sTable.add(new MccEntry(284, "bg", 2));
        sTable.add(new MccEntry(286, "tr", 2));
        sTable.add(new MccEntry(288, "fo", 2));
        sTable.add(new MccEntry(289, "ge", 2));
        sTable.add(new MccEntry(290, "gl", 2));
        sTable.add(new MccEntry(292, "sm", 2));
        sTable.add(new MccEntry(293, "si", 2));
        sTable.add(new MccEntry(294, "mk", 2));
        sTable.add(new MccEntry(295, "li", 2));
        sTable.add(new MccEntry(297, "me", 2));
        sTable.add(new MccEntry(302, "ca", 3));
        sTable.add(new MccEntry(308, "pm", 2));
        sTable.add(new MccEntry(310, "us", 3));
        sTable.add(new MccEntry(311, "us", 3));
        sTable.add(new MccEntry(312, "us", 3));
        sTable.add(new MccEntry(313, "us", 3));
        sTable.add(new MccEntry(314, "us", 3));
        sTable.add(new MccEntry(315, "us", 3));
        sTable.add(new MccEntry(316, "us", 3));
        sTable.add(new MccEntry(330, "pr", 2));
        sTable.add(new MccEntry(332, "vi", 2));
        sTable.add(new MccEntry(334, "mx", 3));
        sTable.add(new MccEntry(338, "jm", 3));
        sTable.add(new MccEntry(340, "gp", 2));
        sTable.add(new MccEntry(342, "bb", 3));
        sTable.add(new MccEntry(344, "ag", 3));
        sTable.add(new MccEntry(346, "ky", 3));
        sTable.add(new MccEntry(348, "vg", 3));
        sTable.add(new MccEntry(350, "bm", 2));
        sTable.add(new MccEntry(352, "gd", 2));
        sTable.add(new MccEntry(354, "ms", 2));
        sTable.add(new MccEntry(356, "kn", 2));
        sTable.add(new MccEntry(358, "lc", 2));
        sTable.add(new MccEntry(360, "vc", 2));
        sTable.add(new MccEntry(362, "ai", 2));
        sTable.add(new MccEntry(363, "aw", 2));
        sTable.add(new MccEntry(364, "bs", 2));
        sTable.add(new MccEntry(365, "ai", 3));
        sTable.add(new MccEntry(366, "dm", 2));
        sTable.add(new MccEntry(368, "cu", 2));
        sTable.add(new MccEntry(370, "do", 2));
        sTable.add(new MccEntry(372, "ht", 2));
        sTable.add(new MccEntry(374, "tt", 2));
        sTable.add(new MccEntry(376, "tc", 2));
        sTable.add(new MccEntry(400, "az", 2));
        sTable.add(new MccEntry(401, "kz", 2));
        sTable.add(new MccEntry(402, "bt", 2));
        sTable.add(new MccEntry(404, "in", 2));
        sTable.add(new MccEntry(405, "in", 2));
        sTable.add(new MccEntry(406, "in", 2));
        sTable.add(new MccEntry(410, "pk", 2));
        sTable.add(new MccEntry(412, "af", 2));
        sTable.add(new MccEntry(413, "lk", 2));
        sTable.add(new MccEntry(414, "mm", 2));
        sTable.add(new MccEntry(415, "lb", 2));
        sTable.add(new MccEntry(416, "jo", 2));
        sTable.add(new MccEntry(417, "sy", 2));
        sTable.add(new MccEntry(418, "iq", 2));
        sTable.add(new MccEntry(419, "kw", 2));
        sTable.add(new MccEntry(420, "sa", 2));
        sTable.add(new MccEntry(421, "ye", 2));
        sTable.add(new MccEntry(422, "om", 2));
        sTable.add(new MccEntry(423, "ps", 2));
        sTable.add(new MccEntry(424, "ae", 2));
        sTable.add(new MccEntry(425, "il", 2));
        sTable.add(new MccEntry(426, "bh", 2));
        sTable.add(new MccEntry(427, "qa", 2));
        sTable.add(new MccEntry(428, "mn", 2));
        sTable.add(new MccEntry(429, "np", 2));
        sTable.add(new MccEntry(430, "ae", 2));
        sTable.add(new MccEntry(431, "ae", 2));
        sTable.add(new MccEntry(432, "ir", 2));
        sTable.add(new MccEntry(434, "uz", 2));
        sTable.add(new MccEntry(436, "tj", 2));
        sTable.add(new MccEntry(437, "kg", 2));
        sTable.add(new MccEntry(438, "tm", 2));
        sTable.add(new MccEntry(440, "jp", 2));
        sTable.add(new MccEntry(441, "jp", 2));
        sTable.add(new MccEntry(450, "kr", 2));
        sTable.add(new MccEntry(452, "vn", 2));
        sTable.add(new MccEntry(454, "hk", 2));
        sTable.add(new MccEntry(455, "mo", 2));
        sTable.add(new MccEntry(456, "kh", 2));
        sTable.add(new MccEntry(457, "la", 2));
        sTable.add(new MccEntry(460, "cn", 2));
        sTable.add(new MccEntry(461, "cn", 2));
        sTable.add(new MccEntry(466, "tw", 2));
        sTable.add(new MccEntry(467, "kp", 2));
        sTable.add(new MccEntry(470, "bd", 2));
        sTable.add(new MccEntry(472, "mv", 2));
        sTable.add(new MccEntry(502, "my", 2));
        sTable.add(new MccEntry(505, "au", 2));
        sTable.add(new MccEntry(510, "id", 2));
        sTable.add(new MccEntry(514, "tl", 2));
        sTable.add(new MccEntry(515, "ph", 2));
        sTable.add(new MccEntry(520, "th", 2));
        sTable.add(new MccEntry(525, "sg", 2));
        sTable.add(new MccEntry(528, "bn", 2));
        sTable.add(new MccEntry(530, "nz", 2));
        sTable.add(new MccEntry(534, "mp", 2));
        sTable.add(new MccEntry(535, "gu", 2));
        sTable.add(new MccEntry(536, "nr", 2));
        sTable.add(new MccEntry(537, "pg", 2));
        sTable.add(new MccEntry(539, "to", 2));
        sTable.add(new MccEntry(540, "sb", 2));
        sTable.add(new MccEntry(541, "vu", 2));
        sTable.add(new MccEntry(542, "fj", 2));
        sTable.add(new MccEntry(543, "wf", 2));
        sTable.add(new MccEntry(544, "as", 2));
        sTable.add(new MccEntry(545, "ki", 2));
        sTable.add(new MccEntry(546, "nc", 2));
        sTable.add(new MccEntry(547, "pf", 2));
        sTable.add(new MccEntry(548, "ck", 2));
        sTable.add(new MccEntry(549, "ws", 2));
        sTable.add(new MccEntry(550, "fm", 2));
        sTable.add(new MccEntry(551, "mh", 2));
        sTable.add(new MccEntry(552, "pw", 2));
        sTable.add(new MccEntry(553, "tv", 2));
        sTable.add(new MccEntry(555, "nu", 2));
        sTable.add(new MccEntry(602, "eg", 2));
        sTable.add(new MccEntry(603, "dz", 2));
        sTable.add(new MccEntry(604, "ma", 2));
        sTable.add(new MccEntry(605, "tn", 2));
        sTable.add(new MccEntry(606, "ly", 2));
        sTable.add(new MccEntry(607, "gm", 2));
        sTable.add(new MccEntry(608, "sn", 2));
        sTable.add(new MccEntry(609, "mr", 2));
        sTable.add(new MccEntry(610, "ml", 2));
        sTable.add(new MccEntry(611, "gn", 2));
        sTable.add(new MccEntry(612, "ci", 2));
        sTable.add(new MccEntry(613, "bf", 2));
        sTable.add(new MccEntry(614, "ne", 2));
        sTable.add(new MccEntry(615, "tg", 2));
        sTable.add(new MccEntry(616, "bj", 2));
        sTable.add(new MccEntry(617, "mu", 2));
        sTable.add(new MccEntry(618, "lr", 2));
        sTable.add(new MccEntry(619, "sl", 2));
        sTable.add(new MccEntry(620, "gh", 2));
        sTable.add(new MccEntry(621, "ng", 2));
        sTable.add(new MccEntry(622, "td", 2));
        sTable.add(new MccEntry(623, "cf", 2));
        sTable.add(new MccEntry(624, "cm", 2));
        sTable.add(new MccEntry(625, "cv", 2));
        sTable.add(new MccEntry(626, "st", 2));
        sTable.add(new MccEntry(627, "gq", 2));
        sTable.add(new MccEntry(628, "ga", 2));
        sTable.add(new MccEntry(629, "cg", 2));
        sTable.add(new MccEntry(630, "cd", 2));
        sTable.add(new MccEntry(631, "ao", 2));
        sTable.add(new MccEntry(632, "gw", 2));
        sTable.add(new MccEntry(633, "sc", 2));
        sTable.add(new MccEntry(634, "sd", 2));
        sTable.add(new MccEntry(635, "rw", 2));
        sTable.add(new MccEntry(636, "et", 2));
        sTable.add(new MccEntry(637, "so", 2));
        sTable.add(new MccEntry(638, "dj", 2));
        sTable.add(new MccEntry(639, "ke", 2));
        sTable.add(new MccEntry(640, "tz", 2));
        sTable.add(new MccEntry(641, "ug", 2));
        sTable.add(new MccEntry(642, "bi", 2));
        sTable.add(new MccEntry(643, "mz", 2));
        sTable.add(new MccEntry(645, "zm", 2));
        sTable.add(new MccEntry(646, "mg", 2));
        sTable.add(new MccEntry(647, "re", 2));
        sTable.add(new MccEntry(648, "zw", 2));
        sTable.add(new MccEntry(649, "na", 2));
        sTable.add(new MccEntry(650, "mw", 2));
        sTable.add(new MccEntry(651, "ls", 2));
        sTable.add(new MccEntry(652, "bw", 2));
        sTable.add(new MccEntry(653, "sz", 2));
        sTable.add(new MccEntry(654, "km", 2));
        sTable.add(new MccEntry(655, "za", 2));
        sTable.add(new MccEntry(657, "er", 2));
        sTable.add(new MccEntry(658, "sh", 2));
        sTable.add(new MccEntry(659, "ss", 2));
        sTable.add(new MccEntry(702, "bz", 2));
        sTable.add(new MccEntry(704, "gt", 2));
        sTable.add(new MccEntry(706, "sv", 2));
        sTable.add(new MccEntry(708, "hn", 3));
        sTable.add(new MccEntry(710, "ni", 2));
        sTable.add(new MccEntry(712, "cr", 2));
        sTable.add(new MccEntry(714, "pa", 2));
        sTable.add(new MccEntry(716, "pe", 2));
        sTable.add(new MccEntry(722, "ar", 3));
        sTable.add(new MccEntry(724, "br", 2));
        sTable.add(new MccEntry(730, "cl", 2));
        sTable.add(new MccEntry(732, "co", 3));
        sTable.add(new MccEntry(734, "ve", 2));
        sTable.add(new MccEntry(736, "bo", 2));
        sTable.add(new MccEntry(738, "gy", 2));
        sTable.add(new MccEntry(740, "ec", 2));
        sTable.add(new MccEntry(742, "gf", 2));
        sTable.add(new MccEntry(744, "py", 2));
        sTable.add(new MccEntry(746, "sr", 2));
        sTable.add(new MccEntry(748, "uy", 2));
        sTable.add(new MccEntry(750, "fk", 2));
        Collections.sort(sTable);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_MccTable$__constructor__();
    }

    public MccTable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_MccTable$__constructor__(), this);
    }

    private static MccEntry entryForMcc(int n) {
        return InvokeDynamicSupport.bootstrapStatic("entryForMcc", $$robo$$com_android_internal_telephony_MccTable$entryForMcc(int ), (int)n);
    }

    public static String defaultTimeZoneForMcc(int n) {
        return InvokeDynamicSupport.bootstrapStatic("defaultTimeZoneForMcc", $$robo$$com_android_internal_telephony_MccTable$defaultTimeZoneForMcc(int ), (int)n);
    }

    public static String countryCodeForMcc(int n) {
        return InvokeDynamicSupport.bootstrapStatic("countryCodeForMcc", $$robo$$com_android_internal_telephony_MccTable$countryCodeForMcc(int ), (int)n);
    }

    public static String defaultLanguageForMcc(int n) {
        return InvokeDynamicSupport.bootstrapStatic("defaultLanguageForMcc", $$robo$$com_android_internal_telephony_MccTable$defaultLanguageForMcc(int ), (int)n);
    }

    public static int smallestDigitsMccForMnc(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("smallestDigitsMccForMnc", $$robo$$com_android_internal_telephony_MccTable$smallestDigitsMccForMnc(int ), (int)n);
    }

    public static void updateMccMncConfiguration(Context context, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("updateMccMncConfiguration", $$robo$$com_android_internal_telephony_MccTable$updateMccMncConfiguration(android.content.Context java.lang.String boolean ), (Context)context, (String)string2, (boolean)bl);
    }

    private static Locale lookupFallback(Locale locale, List<Locale> list) {
        return InvokeDynamicSupport.bootstrapStatic("lookupFallback", $$robo$$com_android_internal_telephony_MccTable$lookupFallback(java.util.Locale java.util.List<java.util.Locale> ), (Locale)locale, list);
    }

    private static Locale getLocaleForLanguageCountry(Context context, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getLocaleForLanguageCountry", $$robo$$com_android_internal_telephony_MccTable$getLocaleForLanguageCountry(android.content.Context java.lang.String java.lang.String ), (Context)context, (String)string2, (String)string3);
    }

    private static void setTimezoneFromMccIfNeeded(Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("setTimezoneFromMccIfNeeded", $$robo$$com_android_internal_telephony_MccTable$setTimezoneFromMccIfNeeded(android.content.Context int ), (Context)context, (int)n);
    }

    public static Locale getLocaleFromMcc(Context context, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getLocaleFromMcc", $$robo$$com_android_internal_telephony_MccTable$getLocaleFromMcc(android.content.Context int java.lang.String ), (Context)context, (int)n, (String)string2);
    }

    private static void setWifiCountryCodeFromMcc(Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("setWifiCountryCodeFromMcc", $$robo$$com_android_internal_telephony_MccTable$setWifiCountryCodeFromMcc(android.content.Context int ), (Context)context, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(MccTable.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MccTable)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MccEntry
    implements Comparable<MccEntry> {
        public /* synthetic */ Object __robo_data__;
        int mMcc;
        String mIso;
        int mSmallestDigitsMnc;

        private void $$robo$$com_android_internal_telephony_MccTable_MccEntry$__constructor__(int mnc, String iso, int smallestDigitsMCC) {
            if (iso == null) {
                throw new NullPointerException();
            }
            this.mMcc = mnc;
            this.mIso = iso;
            this.mSmallestDigitsMnc = smallestDigitsMCC;
        }

        private final int $$robo$$com_android_internal_telephony_MccTable_MccEntry$compareTo(MccEntry o) {
            return this.mMcc - o.mMcc;
        }

        private void __constructor__(int n, String string2, int n2) {
            this.$$robo$$com_android_internal_telephony_MccTable_MccEntry$__constructor__(n, string2, n2);
        }

        public MccEntry(int n, String string2, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_MccTable_MccEntry$__constructor__(int java.lang.String int ), this, n, string2, n2);
        }

        @Override
        public int compareTo(MccEntry mccEntry) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_telephony_MccTable_MccEntry$compareTo(com.android.internal.telephony.MccTable$MccEntry ), this, mccEntry);
        }

        public /* synthetic */ MccEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MccEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

