/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.hardware.radio.V1_0.Carrier;
import android.hardware.radio.V1_0.CarrierRestrictions;
import android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.CdmaSmsAck;
import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.CdmaSmsWriteArgs;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.CellInfoCdma;
import android.hardware.radio.V1_0.CellInfoLte;
import android.hardware.radio.V1_0.CellInfoWcdma;
import android.hardware.radio.V1_0.DataProfileInfo;
import android.hardware.radio.V1_0.Dial;
import android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.GsmSmsMessage;
import android.hardware.radio.V1_0.HardwareConfigModem;
import android.hardware.radio.V1_0.IccIo;
import android.hardware.radio.V1_0.ImsSmsMessage;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.NvWriteItem;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.V1_0.SelectUiccSub;
import android.hardware.radio.V1_0.SimApdu;
import android.hardware.radio.V1_0.SmsWriteArgs;
import android.hardware.radio.V1_0.UusInfo;
import android.hardware.radio.V1_1.ImsiEncryptionInfo;
import android.hardware.radio.V1_1.KeepaliveRequest;
import android.hardware.radio.V1_2.CellInfoGsm;
import android.hardware.radio.V1_2.IRadio;
import android.hardware.radio.V1_2.NetworkScanRequest;
import android.hardware.radio.deprecated.V1_0.IOemHook;
import android.net.ConnectivityManager;
import android.net.KeepalivePacketData;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.service.carrier.CarrierIdentifier;
import android.telephony.CellIdentityCdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.ClientRequestStats;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.RadioAccessFamily;
import android.telephony.RadioAccessSpecifier;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyHistogram;
import android.telephony.data.DataProfile;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.ClientWakelockTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.LinkCapacityEstimate;
import com.android.internal.telephony.OemHookIndication;
import com.android.internal.telephony.OemHookResponse;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.RadioIndication;
import com.android.internal.telephony.RadioResponse;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RIL
extends BaseCommands
implements CommandsInterface,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String RILJ_LOG_TAG = "RILJ";
    static String RILJ_WAKELOCK_TAG = "*telephony-radio*";
    static String RILJ_ACK_WAKELOCK_NAME = "RILJ_ACK_WL";
    static boolean RILJ_LOGD = true;
    static boolean RILJ_LOGV = false;
    static int RIL_HISTOGRAM_BUCKET_COUNT = 5;
    private static int DEFAULT_WAKE_LOCK_TIMEOUT_MS = 60000;
    private static int DEFAULT_ACK_WAKE_LOCK_TIMEOUT_MS = 200;
    private static int DEFAULT_BLOCKING_MESSAGE_RESPONSE_TIMEOUT_MS = 2000;
    public static int INVALID_WAKELOCK = -1;
    public static int FOR_WAKELOCK = 0;
    public static int FOR_ACK_WAKELOCK = 1;
    private ClientWakelockTracker mClientWakelockTracker;
    PowerManager.WakeLock mWakeLock;
    PowerManager.WakeLock mAckWakeLock;
    int mWakeLockTimeout;
    int mAckWakeLockTimeout;
    int mWakeLockCount;
    volatile int mWlSequenceNum;
    volatile int mAckWlSequenceNum;
    SparseArray<RILRequest> mRequestList;
    static SparseArray<TelephonyHistogram> mRilTimeHistograms;
    Object[] mLastNITZTimeInfo;
    AtomicBoolean mTestingEmergencyCall;
    Integer mPhoneId;
    private WorkSource mRILDefaultWorkSource;
    private WorkSource mActiveWakelockWorkSource;
    private TelephonyMetrics mMetrics;
    boolean mIsMobileNetworkSupported;
    RadioResponse mRadioResponse;
    RadioIndication mRadioIndication;
    volatile android.hardware.radio.V1_0.IRadio mRadioProxy;
    OemHookResponse mOemHookResponse;
    OemHookIndication mOemHookIndication;
    volatile IOemHook mOemHookProxy;
    AtomicLong mRadioProxyCookie;
    RadioProxyDeathRecipient mRadioProxyDeathRecipient;
    RilHandler mRilHandler;
    static int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static int EVENT_ACK_WAKE_LOCK_TIMEOUT = 4;
    static int EVENT_BLOCKING_RESPONSE_TIMEOUT = 5;
    static int EVENT_RADIO_PROXY_DEAD = 6;
    static String[] HIDL_SERVICE_NAME;
    static int IRADIO_GET_SERVICE_DELAY_MILLIS = 4000;
    static String EMPTY_ALPHA_LONG = "";
    static String EMPTY_ALPHA_SHORT = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<TelephonyHistogram> $$robo$$com_android_internal_telephony_RIL$getTelephonyRILTimingHistograms() {
        ArrayList<TelephonyHistogram> list;
        SparseArray<TelephonyHistogram> sparseArray = mRilTimeHistograms;
        synchronized (sparseArray) {
            list = new ArrayList<TelephonyHistogram>(mRilTimeHistograms.size());
            for (int i = 0; i < mRilTimeHistograms.size(); ++i) {
                TelephonyHistogram entry = new TelephonyHistogram(mRilTimeHistograms.valueAt(i));
                list.add(entry);
            }
        }
        return list;
    }

    private static final Object $$robo$$com_android_internal_telephony_RIL$getResponseForTimedOutRILRequest(RILRequest rr) {
        if (rr == null) {
            return null;
        }
        ModemActivityInfo timeoutResponse = null;
        switch (rr.mRequest) {
            case 135: {
                timeoutResponse = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
            }
        }
        return timeoutResponse;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$resetProxyAndRequestList() {
        this.mRadioProxy = null;
        this.mOemHookProxy = null;
        this.mRadioProxyCookie.incrementAndGet();
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        RILRequest.resetSerial();
        this.clearRequestList(1, false);
        this.getRadioProxy(null);
        this.getOemHookProxy(null);
    }

    @VisibleForTesting
    private final android.hardware.radio.V1_0.IRadio $$robo$$com_android_internal_telephony_RIL$getRadioProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mRadioProxy != null) {
            return this.mRadioProxy;
        }
        try {
            this.mRadioProxy = android.hardware.radio.V1_0.IRadio.getService(HIDL_SERVICE_NAME[this.mPhoneId == null ? 0 : this.mPhoneId], true);
            if (this.mRadioProxy != null) {
                this.mRadioProxy.linkToDeath(this.mRadioProxyDeathRecipient, this.mRadioProxyCookie.incrementAndGet());
                this.mRadioProxy.setResponseFunctions(this.mRadioResponse, this.mRadioIndication);
            } else {
                this.riljLoge("getRadioProxy: mRadioProxy == null");
            }
        }
        catch (RemoteException | RuntimeException e) {
            this.mRadioProxy = null;
            this.riljLoge("RadioProxy getService/setResponseFunctions: " + e);
        }
        if (this.mRadioProxy == null) {
            this.riljLoge("getRadioProxy: mRadioProxy == null");
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
        }
        return this.mRadioProxy;
    }

    @VisibleForTesting
    private final IOemHook $$robo$$com_android_internal_telephony_RIL$getOemHookProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mOemHookProxy != null) {
            return this.mOemHookProxy;
        }
        try {
            this.mOemHookProxy = IOemHook.getService(HIDL_SERVICE_NAME[this.mPhoneId == null ? 0 : this.mPhoneId], true);
            if (this.mOemHookProxy != null) {
                this.mOemHookProxy.setResponseFunctions(this.mOemHookResponse, this.mOemHookIndication);
            } else {
                this.riljLoge("getOemHookProxy: mOemHookProxy == null");
            }
        }
        catch (RemoteException | RuntimeException e) {
            this.mOemHookProxy = null;
            this.riljLoge("OemHookProxy getService/setResponseFunctions: " + e);
        }
        if (this.mOemHookProxy == null && result != null) {
            AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
            result.sendToTarget();
        }
        return this.mOemHookProxy;
    }

    private void $$robo$$com_android_internal_telephony_RIL$__constructor__(Context context, int preferredNetworkType, int cdmaSubscription) {
    }

    private void $$robo$$com_android_internal_telephony_RIL$__constructor__(Context context, int preferredNetworkType, int cdmaSubscription, Integer instanceId) {
        this.mClientWakelockTracker = new ClientWakelockTracker();
        this.mWlSequenceNum = 0;
        this.mAckWlSequenceNum = 0;
        this.mRequestList = new SparseArray();
        this.mTestingEmergencyCall = new AtomicBoolean(false);
        this.mMetrics = TelephonyMetrics.getInstance();
        this.mRadioProxy = null;
        this.mOemHookProxy = null;
        this.mRadioProxyCookie = new AtomicLong(0L);
        this.riljLog("RIL: init preferredNetworkType=" + preferredNetworkType + " cdmaSubscription=" + cdmaSubscription + ")");
        this.mContext = context;
        this.mCdmaSubscription = cdmaSubscription;
        this.mPreferredNetworkType = preferredNetworkType;
        this.mPhoneType = 0;
        this.mPhoneId = instanceId;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mIsMobileNetworkSupported = cm.isNetworkSupported(0);
        this.mRadioResponse = new RadioResponse(this);
        this.mRadioIndication = new RadioIndication(this);
        this.mOemHookResponse = new OemHookResponse(this);
        this.mOemHookIndication = new OemHookIndication(this);
        this.mRilHandler = new RilHandler(this);
        this.mRadioProxyDeathRecipient = new RadioProxyDeathRecipient(this);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*telephony-radio*");
        this.mWakeLock.setReferenceCounted(false);
        this.mAckWakeLock = pm.newWakeLock(1, "RILJ_ACK_WL");
        this.mAckWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 60000);
        this.mAckWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 200);
        this.mWakeLockCount = 0;
        this.mRILDefaultWorkSource = new WorkSource(context.getApplicationInfo().uid, context.getPackageName());
        TelephonyDevController tdc = TelephonyDevController.getInstance();
        TelephonyDevController.registerRIL(this);
        this.getRadioProxy(null);
        this.getOemHookProxy(null);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setOnNITZTime(Handler h, int what, Object obj) {
        super.setOnNITZTime(h, what, obj);
        if (this.mLastNITZTimeInfo != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, this.mLastNITZTimeInfo, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$addRequest(RILRequest rr) {
        this.acquireWakeLock(rr, 0);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr.mStartTimeMs = SystemClock.elapsedRealtime();
            this.mRequestList.append(rr.mSerial, rr);
        }
    }

    private final RILRequest $$robo$$com_android_internal_telephony_RIL$obtainRequest(int request, Message result, WorkSource workSource) {
        RILRequest rr = RILRequest.obtain(request, result, workSource);
        this.addRequest(rr);
        return rr;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$handleRadioProxyExceptionForRR(RILRequest rr, String caller, Exception e) {
        this.riljLoge(caller + ": " + e);
        this.resetProxyAndRequestList();
    }

    private final String $$robo$$com_android_internal_telephony_RIL$convertNullToEmptyString(String string2) {
        return string2 != null ? string2 : "";
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIccCardStatus(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(1, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getIccCardStatus(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getIccCardStatus", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIccSlotsStatus(Message result) {
        if (result != null) {
            AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
            result.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setLogicalToPhysicalSlotMapping(int[] physicalSlots, Message result) {
        if (result != null) {
            AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
            result.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin(String pin, Message result) {
        this.supplyIccPinForApp(pin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPinForApp(String pin, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(2, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPinForApp(rr.mSerial, this.convertNullToEmptyString(pin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPinForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk(String puk, String newPin, Message result) {
        this.supplyIccPukForApp(puk, newPin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPukForApp(String puk, String newPin, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(3, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPukForApp(rr.mSerial, this.convertNullToEmptyString(puk), this.convertNullToEmptyString(newPin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPukForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin2(String pin, Message result) {
        this.supplyIccPin2ForApp(pin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin2ForApp(String pin, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(4, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPin2ForApp(rr.mSerial, this.convertNullToEmptyString(pin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPin2ForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2(String puk2, String newPin2, Message result) {
        this.supplyIccPuk2ForApp(puk2, newPin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2ForApp(String puk, String newPin2, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(5, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.supplyIccPuk2ForApp(rr.mSerial, this.convertNullToEmptyString(puk), this.convertNullToEmptyString(newPin2), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyIccPuk2ForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin(String oldPin, String newPin, Message result) {
        this.changeIccPinForApp(oldPin, newPin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPinForApp(String oldPin, String newPin, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(6, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " oldPin = " + oldPin + " newPin = " + newPin + " aid = " + aid);
            try {
                radioProxy.changeIccPinForApp(rr.mSerial, this.convertNullToEmptyString(oldPin), this.convertNullToEmptyString(newPin), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeIccPinForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin2(String oldPin2, String newPin2, Message result) {
        this.changeIccPin2ForApp(oldPin2, newPin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin2ForApp(String oldPin2, String newPin2, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(7, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " oldPin = " + oldPin2 + " newPin = " + newPin2 + " aid = " + aid);
            try {
                radioProxy.changeIccPin2ForApp(rr.mSerial, this.convertNullToEmptyString(oldPin2), this.convertNullToEmptyString(newPin2), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeIccPin2ForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyNetworkDepersonalization(String netpin, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(8, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " netpin = " + netpin);
            try {
                radioProxy.supplyNetworkDepersonalization(rr.mSerial, this.convertNullToEmptyString(netpin));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "supplyNetworkDepersonalization", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCurrentCalls(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(9, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCurrentCalls(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCurrentCalls", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$dial(String address, int clirMode, Message result) {
        this.dial(address, clirMode, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(10, result, this.mRILDefaultWorkSource);
            Dial dialInfo = new Dial();
            dialInfo.address = this.convertNullToEmptyString(address);
            dialInfo.clir = clirMode;
            if (uusInfo != null) {
                UusInfo info = new UusInfo();
                info.uusType = uusInfo.getType();
                info.uusDcs = uusInfo.getDcs();
                info.uusData = new String(uusInfo.getUserData());
                dialInfo.uusInfo.add(info);
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.dial(rr.mSerial, dialInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "dial", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMSIForApp(String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(11, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + ">  " + RIL.requestToString(rr.mRequest) + " aid = " + aid);
            try {
                radioProxy.getImsiForApp(rr.mSerial, this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getIMSIForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupConnection(int gsmIndex, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(12, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " gsmIndex = " + gsmIndex);
            try {
                radioProxy.hangup(rr.mSerial, gsmIndex);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupConnection", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupWaitingOrBackground(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(13, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.hangupWaitingOrBackground(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupWaitingOrBackground", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupForegroundResumeBackground(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(14, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.hangupForegroundResumeBackground(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "hangupForegroundResumeBackground", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$switchWaitingOrHoldingAndActive(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(15, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.switchWaitingOrHoldingAndActive(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "switchWaitingOrHoldingAndActive", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$conference(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(16, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.conference(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "conference", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$rejectCall(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(17, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.rejectCall(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "rejectCall", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getLastCallFailCause(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(18, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getLastCallFailCause(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getLastCallFailCause", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getSignalStrength(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(19, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getSignalStrength(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getSignalStrength", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getVoiceRegistrationState(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(20, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getVoiceRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getVoiceRegistrationState", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDataRegistrationState(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(21, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDataRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDataRegistrationState", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getOperator(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(22, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getOperator(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getOperator", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setRadioPower(boolean on, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(23, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " on = " + on);
            try {
                radioProxy.setRadioPower(rr.mSerial, on);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setRadioPower", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendDtmf(char c, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(24, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.sendDtmf(rr.mSerial, c + "");
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendDtmf", e);
            }
        }
    }

    private final GsmSmsMessage $$robo$$com_android_internal_telephony_RIL$constructGsmSendSmsRilRequest(String smscPdu, String pdu) {
        GsmSmsMessage msg = new GsmSmsMessage();
        msg.smscPdu = smscPdu == null ? "" : smscPdu;
        msg.pdu = pdu == null ? "" : pdu;
        return msg;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendSMS(String smscPdu, String pdu, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(25, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            GsmSmsMessage msg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            try {
                radioProxy.sendSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 1, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendSMS", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendSMSExpectMore(String smscPdu, String pdu, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(26, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            GsmSmsMessage msg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            try {
                radioProxy.sendSMSExpectMore(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 1, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendSMSExpectMore", e);
            }
        }
    }

    private static final int $$robo$$com_android_internal_telephony_RIL$convertToHalMvnoType(String mvnoType) {
        switch (mvnoType) {
            case "imsi": {
                return 1;
            }
            case "gid": {
                return 2;
            }
            case "spn": {
                return 3;
            }
        }
        return 0;
    }

    private static final DataProfileInfo $$robo$$com_android_internal_telephony_RIL$convertToHalDataProfile(DataProfile dp) {
        DataProfileInfo dpi = new DataProfileInfo();
        dpi.profileId = dp.getProfileId();
        dpi.apn = dp.getApn();
        dpi.protocol = dp.getProtocol();
        dpi.roamingProtocol = dp.getRoamingProtocol();
        dpi.authType = dp.getAuthType();
        dpi.user = dp.getUserName();
        dpi.password = dp.getPassword();
        dpi.type = dp.getType();
        dpi.maxConnsTime = dp.getMaxConnsTime();
        dpi.maxConns = dp.getMaxConns();
        dpi.waitTime = dp.getWaitTime();
        dpi.enabled = dp.isEnabled();
        dpi.supportedApnTypesBitmap = dp.getSupportedApnTypesBitmap();
        dpi.bearerBitmap = dp.getBearerBitmap();
        dpi.mtu = dp.getMtu();
        dpi.mvnoType = RIL.convertToHalMvnoType(dp.getMvnoType());
        dpi.mvnoMatchData = dp.getMvnoMatchData();
        return dpi;
    }

    private static final int $$robo$$com_android_internal_telephony_RIL$convertToHalResetNvType(int resetType) {
        switch (resetType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(27, result, this.mRILDefaultWorkSource);
            DataProfileInfo dpi = RIL.convertToHalDataProfile(dataProfile);
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            try {
                if (radioProxy12 == null) {
                    ServiceState ss;
                    int dataRat = 0;
                    Phone phone = PhoneFactory.getPhone(this.mPhoneId);
                    if (phone != null && (ss = phone.getServiceState()) != null) {
                        dataRat = ss.getRilDataRadioTechnology();
                    }
                    this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ",dataRat=" + dataRat + ",isRoaming=" + isRoaming + ",allowRoaming=" + allowRoaming + "," + dataProfile);
                    radioProxy.setupDataCall(rr.mSerial, dataRat, dpi, dataProfile.isModemCognitive(), allowRoaming, isRoaming);
                } else {
                    ArrayList<String> addresses = new ArrayList<String>();
                    ArrayList<String> dnses = new ArrayList<String>();
                    if (linkProperties != null) {
                        for (InetAddress address : linkProperties.getAddresses()) {
                            addresses.add(address.getHostAddress());
                        }
                        for (InetAddress dns : linkProperties.getDnsServers()) {
                            dnses.add(dns.getHostAddress());
                        }
                    }
                    this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ",accessNetworkType=" + accessNetworkType + ",isRoaming=" + isRoaming + ",allowRoaming=" + allowRoaming + "," + dataProfile + ",addresses=" + addresses + ",dnses=" + dnses);
                    radioProxy12.setupDataCall_1_2(rr.mSerial, accessNetworkType, dpi, dataProfile.isModemCognitive(), allowRoaming, isRoaming, reason, addresses, dnses);
                }
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setupDataCall", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccIO(int command, int fileId, String path, int p1, int p2, int p3, String data, String pin2, Message result) {
        this.iccIOForApp(command, fileId, path, p1, p2, p3, data, pin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccIOForApp(int command, int fileId, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(28, result, this.mRILDefaultWorkSource);
            if (Build.IS_DEBUGGABLE) {
                this.riljLog(rr.serialString() + "> iccIO: " + RIL.requestToString(rr.mRequest) + " command = 0x" + Integer.toHexString(command) + " fileId = 0x" + Integer.toHexString(fileId) + " path = " + path + " p1 = " + p1 + " p2 = " + p2 + " p3 =  data = " + data + " aid = " + aid);
            } else {
                this.riljLog(rr.serialString() + "> iccIO: " + RIL.requestToString(rr.mRequest));
            }
            IccIo iccIo = new IccIo();
            iccIo.command = command;
            iccIo.fileId = fileId;
            iccIo.path = this.convertNullToEmptyString(path);
            iccIo.p1 = p1;
            iccIo.p2 = p2;
            iccIo.p3 = p3;
            iccIo.data = this.convertNullToEmptyString(data);
            iccIo.pin2 = this.convertNullToEmptyString(pin2);
            iccIo.aid = this.convertNullToEmptyString(aid);
            try {
                radioProxy.iccIOForApp(rr.mSerial, iccIo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccIOForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendUSSD(String ussd, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(29, result, this.mRILDefaultWorkSource);
            String logUssd = "*******";
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " ussd = " + logUssd);
            try {
                radioProxy.sendUssd(rr.mSerial, this.convertNullToEmptyString(ussd));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendUSSD", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$cancelPendingUssd(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(30, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.cancelPendingUssd(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "cancelPendingUssd", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCLIR(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(31, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getClir(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCLIR", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCLIR(int clirMode, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(32, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " clirMode = " + clirMode);
            try {
                radioProxy.setClir(rr.mSerial, clirMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCLIR", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCallForwardStatus(int cfReason, int serviceClass, String number, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(33, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cfreason = " + cfReason + " serviceClass = " + serviceClass);
            android.hardware.radio.V1_0.CallForwardInfo cfInfo = new android.hardware.radio.V1_0.CallForwardInfo();
            cfInfo.reason = cfReason;
            cfInfo.serviceClass = serviceClass;
            cfInfo.toa = PhoneNumberUtils.toaFromString(number);
            cfInfo.number = this.convertNullToEmptyString(number);
            cfInfo.timeSeconds = 0;
            try {
                radioProxy.getCallForwardStatus(rr.mSerial, cfInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCallForwardStatus", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(34, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " action = " + action + " cfReason = " + cfReason + " serviceClass = " + serviceClass + " timeSeconds = " + timeSeconds);
            android.hardware.radio.V1_0.CallForwardInfo cfInfo = new android.hardware.radio.V1_0.CallForwardInfo();
            cfInfo.status = action;
            cfInfo.reason = cfReason;
            cfInfo.serviceClass = serviceClass;
            cfInfo.toa = PhoneNumberUtils.toaFromString(number);
            cfInfo.number = this.convertNullToEmptyString(number);
            cfInfo.timeSeconds = timeSeconds;
            try {
                radioProxy.setCallForward(rr.mSerial, cfInfo);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCallForward", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCallWaiting(int serviceClass, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(35, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " serviceClass = " + serviceClass);
            try {
                radioProxy.getCallWaiting(rr.mSerial, serviceClass);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCallWaiting", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCallWaiting(boolean enable, int serviceClass, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(36, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable + " serviceClass = " + serviceClass);
            try {
                radioProxy.setCallWaiting(rr.mSerial, enable, serviceClass);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCallWaiting", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(37, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success + " cause = " + cause);
            try {
                radioProxy.acknowledgeLastIncomingGsmSms(rr.mSerial, success, cause);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeLastIncomingGsmSms", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acceptCall(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(40, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.acceptCall(rr.mSerial);
                this.mMetrics.writeRilAnswer(this.mPhoneId, rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acceptCall", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deactivateDataCall(int cid, int reason, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(41, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cid = " + cid + " reason = " + reason);
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            try {
                if (radioProxy12 == null) {
                    radioProxy.deactivateDataCall(rr.mSerial, cid, reason == 2);
                } else {
                    radioProxy12.deactivateDataCall_1_2(rr.mSerial, cid, reason);
                }
                this.mMetrics.writeRilDeactivateDataCall(this.mPhoneId, rr.mSerial, cid, reason);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deactivateDataCall", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryFacilityLock(String facility, String password, int serviceClass, Message result) {
        this.queryFacilityLockForApp(facility, password, serviceClass, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryFacilityLockForApp(String facility, String password, int serviceClass, String appId, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(42, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " facility = " + facility + " serviceClass = " + serviceClass + " appId = " + appId);
            try {
                radioProxy.getFacilityLockForApp(rr.mSerial, this.convertNullToEmptyString(facility), this.convertNullToEmptyString(password), serviceClass, this.convertNullToEmptyString(appId));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getFacilityLockForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setFacilityLock(String facility, boolean lockState, String password, int serviceClass, Message result) {
        this.setFacilityLockForApp(facility, lockState, password, serviceClass, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setFacilityLockForApp(String facility, boolean lockState, String password, int serviceClass, String appId, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(43, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " facility = " + facility + " lockstate = " + lockState + " serviceClass = " + serviceClass + " appId = " + appId);
            try {
                radioProxy.setFacilityLockForApp(rr.mSerial, this.convertNullToEmptyString(facility), lockState, this.convertNullToEmptyString(password), serviceClass, this.convertNullToEmptyString(appId));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setFacilityLockForApp", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(44, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "facility = " + facility);
            try {
                radioProxy.setBarringPassword(rr.mSerial, this.convertNullToEmptyString(facility), this.convertNullToEmptyString(oldPwd), this.convertNullToEmptyString(newPwd));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "changeBarringPassword", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getNetworkSelectionMode(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(45, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getNetworkSelectionMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getNetworkSelectionMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeAutomatic(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(46, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.setNetworkSelectionModeAutomatic(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setNetworkSelectionModeAutomatic", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeManual(String operatorNumeric, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(47, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " operatorNumeric = " + operatorNumeric);
            try {
                radioProxy.setNetworkSelectionModeManual(rr.mSerial, this.convertNullToEmptyString(operatorNumeric));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setNetworkSelectionModeManual", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getAvailableNetworks(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(48, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAvailableNetworks(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAvailableNetworks", e);
            }
        }
    }

    private final android.hardware.radio.V1_1.RadioAccessSpecifier $$robo$$com_android_internal_telephony_RIL$convertRadioAccessSpecifierToRadioHAL(RadioAccessSpecifier ras) {
        android.hardware.radio.V1_1.RadioAccessSpecifier rasInHalFormat = new android.hardware.radio.V1_1.RadioAccessSpecifier();
        rasInHalFormat.radioAccessNetwork = ras.getRadioAccessNetwork();
        ArrayList<Integer> bands = null;
        switch (ras.getRadioAccessNetwork()) {
            case 1: {
                bands = rasInHalFormat.geranBands;
                break;
            }
            case 2: {
                bands = rasInHalFormat.utranBands;
                break;
            }
            case 3: {
                bands = rasInHalFormat.eutranBands;
                break;
            }
            default: {
                Log.wtf("RILJ", "radioAccessNetwork " + ras.getRadioAccessNetwork() + " not supported!");
                return null;
            }
        }
        if (ras.getBands() != null) {
            for (int band : ras.getBands()) {
                bands.add(band);
            }
        }
        if (ras.getChannels() != null) {
            for (int channel : ras.getChannels()) {
                rasInHalFormat.channels.add(channel);
            }
        }
        return rasInHalFormat;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startNetworkScan(android.telephony.NetworkScanRequest nsr, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            if (radioProxy12 != null) {
                NetworkScanRequest request = new NetworkScanRequest();
                request.type = nsr.getScanType();
                request.interval = nsr.getSearchPeriodicity();
                request.maxSearchTime = nsr.getMaxSearchTime();
                request.incrementalResultsPeriodicity = nsr.getIncrementalResultsPeriodicity();
                request.incrementalResults = nsr.getIncrementalResults();
                for (RadioAccessSpecifier ras : nsr.getSpecifiers()) {
                    android.hardware.radio.V1_1.RadioAccessSpecifier rasInHalFormat = this.convertRadioAccessSpecifierToRadioHAL(ras);
                    if (rasInHalFormat == null) {
                        return;
                    }
                    request.specifiers.add(rasInHalFormat);
                }
                request.mccMncs.addAll(nsr.getPlmns());
                RILRequest rr = this.obtainRequest(142, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    radioProxy12.startNetworkScan_1_2(rr.mSerial, request);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "startNetworkScan", e);
                }
            } else {
                android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
                if (radioProxy11 == null) {
                    if (result != null) {
                        AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                        result.sendToTarget();
                    }
                } else {
                    android.hardware.radio.V1_1.NetworkScanRequest request = new android.hardware.radio.V1_1.NetworkScanRequest();
                    request.type = nsr.getScanType();
                    request.interval = nsr.getSearchPeriodicity();
                    for (RadioAccessSpecifier ras : nsr.getSpecifiers()) {
                        android.hardware.radio.V1_1.RadioAccessSpecifier rasInHalFormat = this.convertRadioAccessSpecifierToRadioHAL(ras);
                        if (rasInHalFormat == null) {
                            return;
                        }
                        request.specifiers.add(rasInHalFormat);
                    }
                    RILRequest rr = this.obtainRequest(142, result, this.mRILDefaultWorkSource);
                    this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                    try {
                        radioProxy11.startNetworkScan(rr.mSerial, request);
                    }
                    catch (RemoteException | RuntimeException e) {
                        this.handleRadioProxyExceptionForRR(rr, "startNetworkScan", e);
                    }
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopNetworkScan(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                if (result != null) {
                    AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                    result.sendToTarget();
                }
            } else {
                RILRequest rr = this.obtainRequest(143, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    radioProxy11.stopNetworkScan(rr.mSerial);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "stopNetworkScan", e);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startDtmf(char c, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(49, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.startDtmf(rr.mSerial, c + "");
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "startDtmf", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopDtmf(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(50, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.stopDtmf(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "stopDtmf", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$separateConnection(int gsmIndex, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(52, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " gsmIndex = " + gsmIndex);
            try {
                radioProxy.separateConnection(rr.mSerial, gsmIndex);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "separateConnection", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getBasebandVersion(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(51, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getBasebandVersion(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getBasebandVersion", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setMute(boolean enableMute, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(53, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enableMute = " + enableMute);
            try {
                radioProxy.setMute(rr.mSerial, enableMute);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setMute", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getMute(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(54, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getMute(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getMute", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCLIP(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(55, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getClip(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCLIP", e);
            }
        }
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_RIL$getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDataCallList(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(57, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDataCallList(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDataCallList", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestRaw(byte[] data, Message response) {
        IOemHook oemHookProxy = this.getOemHookProxy(response);
        if (oemHookProxy != null) {
            RILRequest rr = this.obtainRequest(59, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "[" + IccUtils.bytesToHexString(data) + "]");
            try {
                oemHookProxy.sendRequestRaw(rr.mSerial, RIL.primitiveArrayToArrayList(data));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "invokeOemRilRequestRaw", e);
            }
        } else {
            this.riljLog("Radio Oem Hook Service is disabled for P and later devices. ");
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestStrings(String[] strings, Message result) {
        IOemHook oemHookProxy = this.getOemHookProxy(result);
        if (oemHookProxy != null) {
            RILRequest rr = this.obtainRequest(60, result, this.mRILDefaultWorkSource);
            String logStr = "";
            for (int i = 0; i < strings.length; ++i) {
                logStr = logStr + strings[i] + " ";
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " strings = " + logStr);
            try {
                oemHookProxy.sendRequestStrings(rr.mSerial, new ArrayList<String>(Arrays.asList(strings)));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "invokeOemRilRequestStrings", e);
            }
        } else {
            this.riljLog("Radio Oem Hook Service is disabled for P and later devices. ");
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSuppServiceNotifications(boolean enable, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(62, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setSuppServiceNotifications(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setSuppServiceNotifications", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeSmsToSim(int status, String smsc, String pdu, Message result) {
        status = this.translateStatus(status);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(63, result, this.mRILDefaultWorkSource);
            SmsWriteArgs args = new SmsWriteArgs();
            args.status = status;
            args.smsc = this.convertNullToEmptyString(smsc);
            args.pdu = this.convertNullToEmptyString(pdu);
            try {
                radioProxy.writeSmsToSim(rr.mSerial, args);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "writeSmsToSim", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deleteSmsOnSim(int index, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(64, result, this.mRILDefaultWorkSource);
            try {
                radioProxy.deleteSmsOnSim(rr.mSerial, index);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deleteSmsOnSim", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setBandMode(int bandMode, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(65, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " bandMode = " + bandMode);
            try {
                radioProxy.setBandMode(rr.mSerial, bandMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setBandMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryAvailableBandMode(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(66, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAvailableBandModes(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryAvailableBandMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendEnvelope(String contents, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(69, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + contents);
            try {
                radioProxy.sendEnvelope(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendEnvelope", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendTerminalResponse(String contents, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(70, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + (Build.IS_DEBUGGABLE ? contents : this.censoredTerminalResponse(contents)));
            try {
                radioProxy.sendTerminalResponseToSim(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendTerminalResponse", e);
            }
        }
    }

    private final String $$robo$$com_android_internal_telephony_RIL$censoredTerminalResponse(String terminalResponse) {
        try {
            byte[] bytes = IccUtils.hexStringToBytes(terminalResponse);
            if (bytes != null) {
                List<ComprehensionTlv> ctlvs = ComprehensionTlv.decodeMany(bytes, 0);
                int from = 0;
                for (ComprehensionTlv ctlv : ctlvs) {
                    if (ComprehensionTlvTag.TEXT_STRING.value() == ctlv.getTag()) {
                        byte[] target = Arrays.copyOfRange(ctlv.getRawValue(), from, ctlv.getValueIndex() + ctlv.getLength());
                        terminalResponse = terminalResponse.toLowerCase().replace(IccUtils.bytesToHexString(target), "********");
                    }
                    from = ctlv.getValueIndex() + ctlv.getLength();
                }
            }
        }
        catch (Exception e) {
            Rlog.e("RILJ", "Could not censor the terminal response: " + e);
            terminalResponse = null;
        }
        return terminalResponse;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendEnvelopeWithStatus(String contents, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(107, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " contents = " + contents);
            try {
                radioProxy.sendEnvelopeWithStatus(rr.mSerial, this.convertNullToEmptyString(contents));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendEnvelopeWithStatus", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$explicitCallTransfer(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(72, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.explicitCallTransfer(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "explicitCallTransfer", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPreferredNetworkType(int networkType, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(73, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " networkType = " + networkType);
            this.mPreferredNetworkType = networkType;
            this.mMetrics.writeSetPreferredNetworkType(this.mPhoneId, networkType);
            try {
                radioProxy.setPreferredNetworkType(rr.mSerial, networkType);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setPreferredNetworkType", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getPreferredNetworkType(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(74, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getPreferredNetworkType(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getPreferredNetworkType", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getNeighboringCids(Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(75, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getNeighboringCids(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getNeighboringCids", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setLocationUpdates(boolean enable, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(76, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setLocationUpdates(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setLocationUpdates", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaSubscriptionSource(int cdmaSubscription, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(77, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cdmaSubscription = " + cdmaSubscription);
            try {
                radioProxy.setCdmaSubscriptionSource(rr.mSerial, cdmaSubscription);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaSubscriptionSource", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCdmaRoamingPreference(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(79, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaRoamingPreference(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryCdmaRoamingPreference", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaRoamingPreference(int cdmaRoamingType, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(78, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cdmaRoamingType = " + cdmaRoamingType);
            try {
                radioProxy.setCdmaRoamingPreference(rr.mSerial, cdmaRoamingType);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaRoamingPreference", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryTTYMode(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(81, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getTTYMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "queryTTYMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setTTYMode(int ttyMode, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(80, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " ttyMode = " + ttyMode);
            try {
                radioProxy.setTTYMode(rr.mSerial, ttyMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setTTYMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPreferredVoicePrivacy(boolean enable, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(82, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " enable = " + enable);
            try {
                radioProxy.setPreferredVoicePrivacy(rr.mSerial, enable);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setPreferredVoicePrivacy", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getPreferredVoicePrivacy(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(83, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getPreferredVoicePrivacy(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getPreferredVoicePrivacy", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendCDMAFeatureCode(String featureCode, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(84, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " featureCode = " + featureCode);
            try {
                radioProxy.sendCDMAFeatureCode(rr.mSerial, this.convertNullToEmptyString(featureCode));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendCDMAFeatureCode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(85, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " dtmfString = " + dtmfString + " on = " + on + " off = " + off);
            try {
                radioProxy.sendBurstDtmf(rr.mSerial, this.convertNullToEmptyString(dtmfString), on, off);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendBurstDtmf", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$constructCdmaSendSmsRilRequest(CdmaSmsMessage msg, byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        try {
            int i;
            msg.teleserviceId = dis.readInt();
            msg.isServicePresent = (byte)dis.readInt() == 1;
            msg.serviceCategory = dis.readInt();
            msg.address.digitMode = dis.read();
            msg.address.numberMode = dis.read();
            msg.address.numberType = dis.read();
            msg.address.numberPlan = dis.read();
            int addrNbrOfDigits = dis.read();
            for (i = 0; i < addrNbrOfDigits; ++i) {
                msg.address.digits.add(dis.readByte());
            }
            msg.subAddress.subaddressType = dis.read();
            msg.subAddress.odd = (byte)dis.read() == 1;
            int subaddrNbrOfDigits = dis.read();
            for (i = 0; i < subaddrNbrOfDigits; ++i) {
                msg.subAddress.digits.add(dis.readByte());
            }
            int bearerDataLength = dis.read();
            for (i = 0; i < bearerDataLength; ++i) {
                msg.bearerData.add(dis.readByte());
            }
        }
        catch (IOException ex) {
            this.riljLog("sendSmsCdma: conversion from input stream to object failed: " + ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendCdmaSms(byte[] pdu, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(87, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            CdmaSmsMessage msg = new CdmaSmsMessage();
            this.constructCdmaSendSmsRilRequest(msg, pdu);
            try {
                radioProxy.sendCdmaSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 2, 2);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendCdmaSms", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(88, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success + " cause = " + cause);
            CdmaSmsAck msg = new CdmaSmsAck();
            msg.errorClass = success ? 0 : 1;
            msg.smsCauseCode = cause;
            try {
                radioProxy.acknowledgeLastIncomingCdmaSms(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeLastIncomingCdmaSms", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getGsmBroadcastConfig(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(89, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getGsmBroadcastConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getGsmBroadcastConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(90, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + config.length + " configs : ");
            for (int i = 0; i < config.length; ++i) {
                this.riljLog(config[i].toString());
            }
            ArrayList<GsmBroadcastSmsConfigInfo> configs = new ArrayList<GsmBroadcastSmsConfigInfo>();
            int numOfConfig = config.length;
            for (int i = 0; i < numOfConfig; ++i) {
                GsmBroadcastSmsConfigInfo info = new GsmBroadcastSmsConfigInfo();
                info.fromServiceId = config[i].getFromServiceId();
                info.toServiceId = config[i].getToServiceId();
                info.fromCodeScheme = config[i].getFromCodeScheme();
                info.toCodeScheme = config[i].getToCodeScheme();
                info.selected = config[i].isSelected();
                configs.add(info);
            }
            try {
                radioProxy.setGsmBroadcastConfig(rr.mSerial, configs);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setGsmBroadcastConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastActivation(boolean activate, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(91, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " activate = " + activate);
            try {
                radioProxy.setGsmBroadcastActivation(rr.mSerial, activate);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setGsmBroadcastActivation", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCdmaBroadcastConfig(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(92, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaBroadcastConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCdmaBroadcastConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(93, result, this.mRILDefaultWorkSource);
            ArrayList<CdmaBroadcastSmsConfigInfo> halConfigs = new ArrayList<CdmaBroadcastSmsConfigInfo>();
            for (CdmaSmsBroadcastConfigInfo config : configs) {
                int i = config.getFromServiceCategory();
                while (i <= config.getToServiceCategory()) {
                    CdmaBroadcastSmsConfigInfo info = new CdmaBroadcastSmsConfigInfo();
                    info.serviceCategory = i++;
                    info.language = config.getLanguage();
                    info.selected = config.isSelected();
                    halConfigs.add(info);
                }
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + halConfigs.size() + " configs : ");
            for (CdmaBroadcastSmsConfigInfo config : halConfigs) {
                this.riljLog(config.toString());
            }
            try {
                radioProxy.setCdmaBroadcastConfig(rr.mSerial, halConfigs);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaBroadcastConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastActivation(boolean activate, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(94, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " activate = " + activate);
            try {
                radioProxy.setCdmaBroadcastActivation(rr.mSerial, activate);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCdmaBroadcastActivation", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCDMASubscription(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(95, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCDMASubscription(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCDMASubscription", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeSmsToRuim(int status, String pdu, Message result) {
        status = this.translateStatus(status);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(96, result, this.mRILDefaultWorkSource);
            CdmaSmsWriteArgs args = new CdmaSmsWriteArgs();
            args.status = status;
            this.constructCdmaSendSmsRilRequest(args.message, pdu.getBytes());
            try {
                radioProxy.writeSmsToRuim(rr.mSerial, args);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "writeSmsToRuim", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deleteSmsOnRuim(int index, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(97, result, this.mRILDefaultWorkSource);
            try {
                radioProxy.deleteSmsOnRuim(rr.mSerial, index);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "deleteSmsOnRuim", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDeviceIdentity(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(98, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getDeviceIdentity(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getDeviceIdentity", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$exitEmergencyCallbackMode(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(99, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.exitEmergencyCallbackMode(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "exitEmergencyCallbackMode", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getSmscAddress(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(100, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getSmscAddress(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getSmscAddress", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSmscAddress(String address, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(101, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " address = " + address);
            try {
                radioProxy.setSmscAddress(rr.mSerial, this.convertNullToEmptyString(address));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setSmscAddress", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$reportSmsMemoryStatus(boolean available, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(102, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " available = " + available);
            try {
                radioProxy.reportSmsMemoryStatus(rr.mSerial, available);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "reportSmsMemoryStatus", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$reportStkServiceIsRunning(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(103, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.reportStkServiceIsRunning(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "reportStkServiceIsRunning", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCdmaSubscriptionSource(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(104, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCdmaSubscriptionSource(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCdmaSubscriptionSource", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(106, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " success = " + success);
            try {
                radioProxy.acknowledgeIncomingGsmSmsWithPdu(rr.mSerial, success, this.convertNullToEmptyString(ackPdu));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "acknowledgeIncomingGsmSmsWithPdu", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getVoiceRadioTechnology(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(108, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getVoiceRadioTechnology(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getVoiceRadioTechnology", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCellInfoList(Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(109, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getCellInfoList(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getCellInfoList", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate(int rateInMillis, Message result, WorkSource workSource) {
        workSource = this.getDeafultWorkSourceIfInvalid(workSource);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(110, result, workSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " rateInMillis = " + rateInMillis);
            try {
                radioProxy.setCellInfoListRate(rr.mSerial, rateInMillis);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setCellInfoListRate", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate() {
        this.setCellInfoListRate(Integer.MAX_VALUE, null, this.mRILDefaultWorkSource);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(111, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + dataProfile);
            try {
                radioProxy.setInitialAttachApn(rr.mSerial, RIL.convertToHalDataProfile(dataProfile), dataProfile.isModemCognitive(), isRoaming);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setInitialAttachApn", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getImsRegistrationState(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(112, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getImsRegistrationState(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getImsRegistrationState", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendImsGsmSms(String smscPdu, String pdu, int retry, int messageRef, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(113, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            ImsSmsMessage msg = new ImsSmsMessage();
            msg.tech = 1;
            msg.retry = (byte)retry >= 1;
            msg.messageRef = messageRef;
            GsmSmsMessage gsmMsg = this.constructGsmSendSmsRilRequest(smscPdu, pdu);
            msg.gsmMessage.add(gsmMsg);
            try {
                radioProxy.sendImsSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 3, 1);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendImsGsmSms", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(113, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            ImsSmsMessage msg = new ImsSmsMessage();
            msg.tech = 2;
            msg.retry = (byte)retry >= 1;
            msg.messageRef = messageRef;
            CdmaSmsMessage cdmaMsg = new CdmaSmsMessage();
            this.constructCdmaSendSmsRilRequest(cdmaMsg, pdu);
            msg.cdmaMessage.add(cdmaMsg);
            try {
                radioProxy.sendImsSms(rr.mSerial, msg);
                this.mMetrics.writeRilSendSms(this.mPhoneId, rr.mSerial, 3, 2);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendImsCdmaSms", e);
            }
        }
    }

    private final SimApdu $$robo$$com_android_internal_telephony_RIL$createSimApdu(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        SimApdu msg = new SimApdu();
        msg.sessionId = channel;
        msg.cla = cla;
        msg.instruction = instruction;
        msg.p1 = p1;
        msg.p2 = p2;
        msg.p3 = p3;
        msg.data = this.convertNullToEmptyString(data);
        return msg;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(114, result, this.mRILDefaultWorkSource);
            if (Build.IS_DEBUGGABLE) {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " cla = " + cla + " instruction = " + instruction + " p1 = " + p1 + " p2 =  p3 = " + p3 + " data = " + data);
            } else {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            }
            SimApdu msg = this.createSimApdu(0, cla, instruction, p1, p2, p3, data);
            try {
                radioProxy.iccTransmitApduBasicChannel(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccTransmitApduBasicChannel", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccOpenLogicalChannel(String aid, int p2, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(115, result, this.mRILDefaultWorkSource);
            if (Build.IS_DEBUGGABLE) {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " aid = " + aid + " p2 = " + p2);
            } else {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            }
            try {
                radioProxy.iccOpenLogicalChannel(rr.mSerial, this.convertNullToEmptyString(aid), p2);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccOpenLogicalChannel", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccCloseLogicalChannel(int channel, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(116, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " channel = " + channel);
            try {
                radioProxy.iccCloseLogicalChannel(rr.mSerial, channel);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccCloseLogicalChannel", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message result) {
        if (channel <= 0) {
            throw new RuntimeException("Invalid channel in iccTransmitApduLogicalChannel: " + channel);
        }
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(117, result, this.mRILDefaultWorkSource);
            if (Build.IS_DEBUGGABLE) {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " channel = " + channel + " cla = " + cla + " instruction = " + instruction + " p1 = " + p1 + " p2 =  p3 = " + p3 + " data = " + data);
            } else {
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            }
            SimApdu msg = this.createSimApdu(channel, cla, instruction, p1, p2, p3, data);
            try {
                radioProxy.iccTransmitApduLogicalChannel(rr.mSerial, msg);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "iccTransmitApduLogicalChannel", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvReadItem(int itemID, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(118, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " itemId = " + itemID);
            try {
                radioProxy.nvReadItem(rr.mSerial, itemID);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvReadItem", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvWriteItem(int itemId, String itemValue, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(119, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " itemId = " + itemId + " itemValue = " + itemValue);
            NvWriteItem item = new NvWriteItem();
            item.itemId = itemId;
            item.value = this.convertNullToEmptyString(itemValue);
            try {
                radioProxy.nvWriteItem(rr.mSerial, item);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvWriteItem", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvWriteCdmaPrl(byte[] preferredRoamingList, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(120, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " PreferredRoamingList = 0x" + IccUtils.bytesToHexString(preferredRoamingList));
            ArrayList<Byte> arrList = new ArrayList<Byte>();
            for (int i = 0; i < preferredRoamingList.length; ++i) {
                arrList.add(preferredRoamingList[i]);
            }
            try {
                radioProxy.nvWriteCdmaPrl(rr.mSerial, arrList);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvWriteCdmaPrl", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvResetConfig(int resetType, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(121, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " resetType = " + resetType);
            try {
                radioProxy.nvResetConfig(rr.mSerial, RIL.convertToHalResetNvType(resetType));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "nvResetConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setUiccSubscription(int slotId, int appIndex, int subId, int subStatus, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(122, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " slot = " + slotId + " appIndex = " + appIndex + " subId = " + subId + " subStatus = " + subStatus);
            SelectUiccSub info = new SelectUiccSub();
            info.slot = slotId;
            info.appIndex = appIndex;
            info.subType = subId;
            info.actStatus = subStatus;
            try {
                radioProxy.setUiccSubscription(rr.mSerial, info);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setUiccSubscription", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setDataAllowed(boolean allowed, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(123, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " allowed = " + allowed);
            try {
                radioProxy.setDataAllowed(rr.mSerial, allowed);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setDataAllowed", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getHardwareConfig(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(124, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getHardwareConfig(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getHardwareConfig", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$requestIccSimAuthentication(int authContext, String data, String aid, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(125, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.requestIccSimAuthentication(rr.mSerial, authContext, this.convertNullToEmptyString(data), this.convertNullToEmptyString(aid));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "requestIccSimAuthentication", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setDataProfile(DataProfile[] dps, boolean isRoaming, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(128, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with data profiles : ");
            for (DataProfile profile : dps) {
                this.riljLog(profile.toString());
            }
            ArrayList<DataProfileInfo> dpis = new ArrayList<DataProfileInfo>();
            for (DataProfile dp : dps) {
                dpis.add(RIL.convertToHalDataProfile(dp));
            }
            try {
                radioProxy.setDataProfile(rr.mSerial, dpis, isRoaming);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setDataProfile", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$requestShutdown(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(129, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.requestShutdown(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "requestShutdown", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getRadioCapability(Message response) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(130, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getRadioCapability(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getRadioCapability", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setRadioCapability(RadioCapability rc, Message response) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(131, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " RadioCapability = " + rc.toString());
            android.hardware.radio.V1_0.RadioCapability halRc = new android.hardware.radio.V1_0.RadioCapability();
            halRc.session = rc.getSession();
            halRc.phase = rc.getPhase();
            halRc.raf = rc.getRadioAccessFamily();
            halRc.logicalModemUuid = this.convertNullToEmptyString(rc.getLogicalModemUuid());
            halRc.status = rc.getStatus();
            try {
                radioProxy.setRadioCapability(rr.mSerial, halRc);
            }
            catch (Exception e) {
                this.handleRadioProxyExceptionForRR(rr, "setRadioCapability", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startLceService(int reportIntervalMs, boolean pullMode, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        IRadio radioProxy12 = IRadio.castFrom(radioProxy);
        if (radioProxy12 != null) {
            return;
        }
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(132, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " reportIntervalMs = " + reportIntervalMs + " pullMode = " + pullMode);
            try {
                radioProxy.startLceService(rr.mSerial, reportIntervalMs, pullMode);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "startLceService", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopLceService(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        IRadio radioProxy12 = IRadio.castFrom(radioProxy);
        if (radioProxy12 != null) {
            return;
        }
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(133, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.stopLceService(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "stopLceService", e);
            }
        }
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_RIL$pullLceData(Message response) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(response);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(134, response, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.pullLceData(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "pullLceData", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getModemActivityInfo(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(135, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getModemActivityInfo(rr.mSerial);
                Message msg = this.mRilHandler.obtainMessage(5);
                msg.obj = null;
                msg.arg1 = rr.mSerial;
                this.mRilHandler.sendMessageDelayed(msg, 2000L);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getModemActivityInfo", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setAllowedCarriers(List<CarrierIdentifier> carriers, Message result) {
        Preconditions.checkNotNull(carriers, "Allowed carriers list cannot be null.");
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(136, result, this.mRILDefaultWorkSource);
            String logStr = "";
            for (int i = 0; i < carriers.size(); ++i) {
                logStr = logStr + carriers.get(i) + " ";
            }
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " carriers = " + logStr);
            boolean allAllowed = carriers.size() == 0;
            CarrierRestrictions carrierList = new CarrierRestrictions();
            for (CarrierIdentifier ci : carriers) {
                Carrier c = new Carrier();
                c.mcc = this.convertNullToEmptyString(ci.getMcc());
                c.mnc = this.convertNullToEmptyString(ci.getMnc());
                int matchType = 0;
                String matchData = null;
                if (!TextUtils.isEmpty(ci.getSpn())) {
                    matchType = 1;
                    matchData = ci.getSpn();
                } else if (!TextUtils.isEmpty(ci.getImsi())) {
                    matchType = 2;
                    matchData = ci.getImsi();
                } else if (!TextUtils.isEmpty(ci.getGid1())) {
                    matchType = 3;
                    matchData = ci.getGid1();
                } else if (!TextUtils.isEmpty(ci.getGid2())) {
                    matchType = 4;
                    matchData = ci.getGid2();
                }
                c.matchType = matchType;
                c.matchData = this.convertNullToEmptyString(matchData);
                carrierList.allowedCarriers.add(c);
            }
            try {
                radioProxy.setAllowedCarriers(rr.mSerial, allAllowed, carrierList);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setAllowedCarriers", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getAllowedCarriers(Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(137, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.getAllowedCarriers(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAllowedCarriers", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendDeviceState(int stateType, boolean state, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(138, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + stateType + ":" + state);
            try {
                radioProxy.sendDeviceState(rr.mSerial, stateType, state);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendDeviceState", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setUnsolResponseFilter(int filter, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(139, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + filter);
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            if (radioProxy12 != null) {
                try {
                    radioProxy12.setIndicationFilter_1_2(rr.mSerial, filter);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setIndicationFilter_1_2", e);
                }
            } else {
                try {
                    int filter10 = filter & 7;
                    radioProxy.setIndicationFilter(rr.mSerial, filter10);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setIndicationFilter", e);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSignalStrengthReportingCriteria(int hysteresisMs, int hysteresisDb, int[] thresholdsDbm, int ran, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            if (radioProxy12 == null) {
                this.riljLoge("setSignalStrengthReportingCriteria ignored. RadioProxy 1.2 is null!");
                return;
            }
            RILRequest rr = this.obtainRequest(148, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy12.setSignalStrengthReportingCriteria(rr.mSerial, hysteresisMs, hysteresisDb, RIL.primitiveArrayToArrayList(thresholdsDbm), RIL.convertRanToHalRan(ran));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setSignalStrengthReportingCriteria", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setLinkCapacityReportingCriteria(int hysteresisMs, int hysteresisDlKbps, int hysteresisUlKbps, int[] thresholdsDlKbps, int[] thresholdsUlKbps, int ran, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            IRadio radioProxy12 = IRadio.castFrom(radioProxy);
            if (radioProxy12 == null) {
                this.riljLoge("setLinkCapacityReportingCriteria ignored. RadioProxy 1.2 is null!");
                return;
            }
            RILRequest rr = this.obtainRequest(149, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy12.setLinkCapacityReportingCriteria(rr.mSerial, hysteresisMs, hysteresisDlKbps, hysteresisUlKbps, RIL.primitiveArrayToArrayList(thresholdsDlKbps), RIL.primitiveArrayToArrayList(thresholdsUlKbps), RIL.convertRanToHalRan(ran));
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "setLinkCapacityReportingCriteria", e);
            }
        }
    }

    private static final int $$robo$$com_android_internal_telephony_RIL$convertRanToHalRan(int radioAccessNetwork) {
        switch (radioAccessNetwork) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSimCardPower(int state, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(140, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + state);
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                try {
                    switch (state) {
                        case 0: {
                            radioProxy.setSimCardPower(rr.mSerial, false);
                            break;
                        }
                        case 1: {
                            radioProxy.setSimCardPower(rr.mSerial, true);
                            break;
                        }
                        default: {
                            if (result != null) {
                                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                                result.sendToTarget();
                            }
                            break;
                        }
                    }
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setSimCardPower", e);
                }
            } else {
                try {
                    radioProxy11.setSimCardPower_1_1(rr.mSerial, state);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setSimCardPower", e);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo imsiEncryptionInfo, Message result) {
        Preconditions.checkNotNull(imsiEncryptionInfo, "ImsiEncryptionInfo cannot be null.");
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
            if (radioProxy11 == null) {
                if (result != null) {
                    AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                    result.sendToTarget();
                }
            } else {
                RILRequest rr = this.obtainRequest(141, result, this.mRILDefaultWorkSource);
                this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
                try {
                    ImsiEncryptionInfo halImsiInfo = new ImsiEncryptionInfo();
                    halImsiInfo.mnc = imsiEncryptionInfo.getMnc();
                    halImsiInfo.mcc = imsiEncryptionInfo.getMcc();
                    halImsiInfo.keyIdentifier = imsiEncryptionInfo.getKeyIdentifier();
                    if (imsiEncryptionInfo.getExpirationTime() != null) {
                        halImsiInfo.expirationTime = imsiEncryptionInfo.getExpirationTime().getTime();
                    }
                    for (byte b : imsiEncryptionInfo.getPublicKey().getEncoded()) {
                        halImsiInfo.carrierKey.add(new Byte(b));
                    }
                    radioProxy11.setCarrierInfoForImsiEncryption(rr.mSerial, halImsiInfo);
                }
                catch (RemoteException | RuntimeException e) {
                    this.handleRadioProxyExceptionForRR(rr, "setCarrierInfoForImsiEncryption", e);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startNattKeepalive(int contextId, KeepalivePacketData packetData, int intervalMillis, Message result) {
        Preconditions.checkNotNull(packetData, "KeepaliveRequest cannot be null.");
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy == null) {
            this.riljLoge("Radio Proxy object is null!");
            return;
        }
        android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
        if (radioProxy11 == null) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                result.sendToTarget();
            }
            return;
        }
        RILRequest rr = this.obtainRequest(146, result, this.mRILDefaultWorkSource);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        try {
            KeepaliveRequest req = new KeepaliveRequest();
            req.cid = contextId;
            if (packetData.dstAddress instanceof Inet4Address) {
                req.type = 0;
            } else if (packetData.dstAddress instanceof Inet6Address) {
                req.type = 1;
            } else {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(44));
                result.sendToTarget();
                return;
            }
            RIL.appendPrimitiveArrayToArrayList(packetData.srcAddress.getAddress(), req.sourceAddress);
            req.sourcePort = packetData.srcPort;
            RIL.appendPrimitiveArrayToArrayList(packetData.dstAddress.getAddress(), req.destinationAddress);
            req.destinationPort = packetData.dstPort;
            radioProxy11.startKeepalive(rr.mSerial, req);
        }
        catch (RemoteException | RuntimeException e) {
            this.handleRadioProxyExceptionForRR(rr, "startNattKeepalive", e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopNattKeepalive(int sessionHandle, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy == null) {
            Rlog.e("RILJ", "Radio Proxy object is null!");
            return;
        }
        android.hardware.radio.V1_1.IRadio radioProxy11 = android.hardware.radio.V1_1.IRadio.castFrom(radioProxy);
        if (radioProxy11 == null) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                result.sendToTarget();
            }
            return;
        }
        RILRequest rr = this.obtainRequest(147, result, this.mRILDefaultWorkSource);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        try {
            radioProxy11.stopKeepalive(rr.mSerial, sessionHandle);
        }
        catch (RemoteException | RuntimeException e) {
            this.handleRadioProxyExceptionForRR(rr, "stopNattKeepalive", e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMEI(Message result) {
        throw new RuntimeException("getIMEI not expected to be called");
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMEISV(Message result) {
        throw new RuntimeException("getIMEISV not expected to be called");
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_RIL$getLastPdpFailCause(Message result) {
        throw new RuntimeException("getLastPdpFailCause not expected to be called");
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getLastDataCallFailCause(Message result) {
        throw new RuntimeException("getLastDataCallFailCause not expected to be called");
    }

    private final int $$robo$$com_android_internal_telephony_RIL$translateStatus(int status) {
        switch (status & 7) {
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 2;
            }
        }
        return 1;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$resetRadio(Message result) {
        throw new RuntimeException("resetRadio not expected to be called");
    }

    private final void $$robo$$com_android_internal_telephony_RIL$handleCallSetupRequestFromSim(boolean accept, Message result) {
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(result);
        if (radioProxy != null) {
            RILRequest rr = this.obtainRequest(71, result, this.mRILDefaultWorkSource);
            this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
            try {
                radioProxy.handleStkCallSetupRequestFromSim(rr.mSerial, accept);
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "getAllowedCarriers", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$processIndication(int indicationType) {
        if (indicationType == 1) {
            this.sendAck();
            this.riljLog("Unsol response received; Sending ack to ril.cpp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$processRequestAck(int serial) {
        RILRequest rr;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
        }
        if (rr == null) {
            Rlog.w("RILJ", "processRequestAck: Unexpected solicited ack response! serial: " + serial);
        } else {
            this.decrementWakeLock(rr);
            this.riljLog(rr.serialString() + " Ack < " + RIL.requestToString(rr.mRequest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final RILRequest $$robo$$com_android_internal_telephony_RIL$processResponse(RadioResponseInfo responseInfo) {
        int serial = responseInfo.serial;
        int error = responseInfo.error;
        int type = responseInfo.type;
        RILRequest rr = null;
        if (type == 1) {
            SparseArray<RILRequest> sparseArray = this.mRequestList;
            synchronized (sparseArray) {
                rr = this.mRequestList.get(serial);
            }
            if (rr == null) {
                Rlog.w("RILJ", "Unexpected solicited ack response! sn: " + serial);
            } else {
                this.decrementWakeLock(rr);
                this.riljLog(rr.serialString() + " Ack < " + RIL.requestToString(rr.mRequest));
            }
            return rr;
        }
        rr = this.findAndRemoveRequestFromList(serial);
        if (rr == null) {
            Rlog.e("RILJ", "processResponse: Unexpected response! serial: " + serial + " error: " + error);
            return null;
        }
        this.addToRilHistogram(rr);
        if (type == 2) {
            this.sendAck();
            this.riljLog("Response received for " + rr.serialString() + " " + RIL.requestToString(rr.mRequest) + " Sending ack to ril.cpp");
        }
        switch (rr.mRequest) {
            case 3: 
            case 5: {
                if (this.mIccStatusChangedRegistrants == null) break;
                this.riljLog("ON enter sim puk fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                break;
            }
            case 129: {
                this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
            }
        }
        if (error != 0) {
            switch (rr.mRequest) {
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 43: {
                    if (this.mIccStatusChangedRegistrants == null) break;
                    this.riljLog("ON some errors fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                    this.mIccStatusChangedRegistrants.notifyRegistrants();
                }
            }
        } else {
            switch (rr.mRequest) {
                case 14: {
                    if (!this.mTestingEmergencyCall.getAndSet(false) || this.mEmergencyCallbackModeRegistrant == null) break;
                    this.riljLog("testing emergency call, notify ECM Registrants");
                    this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                }
            }
        }
        return rr;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_RIL$processResponseDone(RILRequest rr, RadioResponseInfo responseInfo, Object ret) {
        if (responseInfo.error == 0) {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " " + RIL.retToString(rr.mRequest, ret));
        } else {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " error " + responseInfo.error);
            rr.onError(responseInfo.error, ret);
        }
        this.mMetrics.writeOnRilSolicitedResponse(this.mPhoneId, rr.mSerial, responseInfo.error, rr.mRequest, ret);
        if (rr != null) {
            if (responseInfo.type == 0) {
                this.decrementWakeLock(rr);
            }
            rr.release();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendAck() {
        RILRequest rr = RILRequest.obtain(800, null, this.mRILDefaultWorkSource);
        this.acquireWakeLock(rr, 1);
        android.hardware.radio.V1_0.IRadio radioProxy = this.getRadioProxy(null);
        if (radioProxy != null) {
            try {
                radioProxy.responseAcknowledgement();
            }
            catch (RemoteException | RuntimeException e) {
                this.handleRadioProxyExceptionForRR(rr, "sendAck", e);
                this.riljLoge("sendAck: " + e);
            }
        } else {
            Rlog.e("RILJ", "Error trying to send ack, radioProxy = null");
        }
        rr.release();
    }

    private final WorkSource $$robo$$com_android_internal_telephony_RIL$getDeafultWorkSourceIfInvalid(WorkSource workSource) {
        if (workSource == null) {
            workSource = this.mRILDefaultWorkSource;
        }
        return workSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$acquireWakeLock(RILRequest rr, int wakeLockType) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            if (rr.mWakeLockType != -1) {
                Rlog.d("RILJ", "Failed to aquire wakelock for " + rr.serialString());
                return;
            }
            switch (wakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        this.mWakeLock.acquire();
                        ++this.mWakeLockCount;
                        ++this.mWlSequenceNum;
                        String clientId = rr.getWorkSourceClientId();
                        if (!this.mClientWakelockTracker.isClientActive(clientId)) {
                            if (this.mActiveWakelockWorkSource != null) {
                                this.mActiveWakelockWorkSource.add(rr.mWorkSource);
                            } else {
                                this.mActiveWakelockWorkSource = rr.mWorkSource;
                            }
                            this.mWakeLock.setWorkSource(this.mActiveWakelockWorkSource);
                        }
                        this.mClientWakelockTracker.startTracking(rr.mClientId, rr.mRequest, rr.mSerial, this.mWakeLockCount);
                        Message msg = this.mRilHandler.obtainMessage(2);
                        msg.arg1 = this.mWlSequenceNum;
                        this.mRilHandler.sendMessageDelayed(msg, this.mWakeLockTimeout);
                        break;
                    }
                }
                case 1: {
                    PowerManager.WakeLock wakeLock = this.mAckWakeLock;
                    synchronized (wakeLock) {
                        this.mAckWakeLock.acquire();
                        ++this.mAckWlSequenceNum;
                        Message msg = this.mRilHandler.obtainMessage(4);
                        msg.arg1 = this.mAckWlSequenceNum;
                        this.mRilHandler.sendMessageDelayed(msg, this.mAckWakeLockTimeout);
                        break;
                    }
                }
                default: {
                    Rlog.w("RILJ", "Acquiring Invalid Wakelock type " + wakeLockType);
                    return;
                }
            }
            rr.mWakeLockType = wakeLockType;
        }
    }

    @VisibleForTesting
    private final PowerManager.WakeLock $$robo$$com_android_internal_telephony_RIL$getWakeLock(int wakeLockType) {
        return wakeLockType == 0 ? this.mWakeLock : this.mAckWakeLock;
    }

    @VisibleForTesting
    private final RilHandler $$robo$$com_android_internal_telephony_RIL$getRilHandler() {
        return this.mRilHandler;
    }

    @VisibleForTesting
    private final SparseArray<RILRequest> $$robo$$com_android_internal_telephony_RIL$getRilRequestList() {
        return this.mRequestList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$decrementWakeLock(RILRequest rr) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            switch (rr.mWakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        this.mClientWakelockTracker.stopTracking(rr.mClientId, rr.mRequest, rr.mSerial, this.mWakeLockCount > 1 ? this.mWakeLockCount - 1 : 0);
                        String clientId = rr.getWorkSourceClientId();
                        if (!this.mClientWakelockTracker.isClientActive(clientId) && this.mActiveWakelockWorkSource != null) {
                            this.mActiveWakelockWorkSource.remove(rr.mWorkSource);
                            if (this.mActiveWakelockWorkSource.size() == 0) {
                                this.mActiveWakelockWorkSource = null;
                            }
                            this.mWakeLock.setWorkSource(this.mActiveWakelockWorkSource);
                        }
                        if (this.mWakeLockCount > 1) {
                            --this.mWakeLockCount;
                        } else {
                            this.mWakeLockCount = 0;
                            this.mWakeLock.release();
                        }
                        break;
                    }
                }
                case 1: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    Rlog.w("RILJ", "Decrementing Invalid Wakelock type " + rr.mWakeLockType);
                }
            }
            rr.mWakeLockType = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_RIL$clearWakeLock(int wakeLockType) {
        if (wakeLockType == 0) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                if (this.mWakeLockCount == 0 && !this.mWakeLock.isHeld()) {
                    return false;
                }
                Rlog.d("RILJ", "NOTE: mWakeLockCount is " + this.mWakeLockCount + "at time of clearing");
                this.mWakeLockCount = 0;
                this.mWakeLock.release();
                this.mClientWakelockTracker.stopTrackingAll();
                this.mActiveWakelockWorkSource = null;
                return true;
            }
        }
        PowerManager.WakeLock wakeLock = this.mAckWakeLock;
        synchronized (wakeLock) {
            if (!this.mAckWakeLock.isHeld()) {
                return false;
            }
            this.mAckWakeLock.release();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                Rlog.d("RILJ", "clearRequestList  mWakeLockCount=" + this.mWakeLockCount + " mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    Rlog.d("RILJ", i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                this.decrementWakeLock(rr);
                rr.release();
            }
            this.mRequestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RILRequest $$robo$$com_android_internal_telephony_RIL$findAndRemoveRequestFromList(int serial) {
        RILRequest rr = null;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$addToRilHistogram(RILRequest rr) {
        long endTime = SystemClock.elapsedRealtime();
        int totalTime = (int)(endTime - rr.mStartTimeMs);
        SparseArray<TelephonyHistogram> sparseArray = mRilTimeHistograms;
        synchronized (sparseArray) {
            TelephonyHistogram entry = mRilTimeHistograms.get(rr.mRequest);
            if (entry == null) {
                entry = new TelephonyHistogram(1, rr.mRequest, 5);
                mRilTimeHistograms.put(rr.mRequest, entry);
            }
            entry.addTimeTaken(totalTime);
        }
    }

    private final RadioCapability $$robo$$com_android_internal_telephony_RIL$makeStaticRadioCapability() {
        int raf = 1;
        String rafString = this.mContext.getResources().getString(17039707);
        if (!TextUtils.isEmpty(rafString)) {
            raf = RadioAccessFamily.rafTypeFromString(rafString);
        }
        RadioCapability rc = new RadioCapability(this.mPhoneId, 0, 0, raf, "", 1);
        this.riljLog("Faking RIL_REQUEST_GET_RADIO_CAPABILITY response using " + raf);
        return rc;
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$retToString(int req, Object ret) {
        String s;
        if (ret == null) {
            return "";
        }
        switch (req) {
            case 11: 
            case 38: 
            case 39: 
            case 115: 
            case 117: {
                return "";
            }
        }
        if (ret instanceof int[]) {
            int[] intArray = (int[])ret;
            int length = intArray.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(intArray[i++]);
                while (i < length) {
                    sb.append(", ").append(intArray[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (ret instanceof String[]) {
            String[] strings = (String[])ret;
            int length = strings.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(strings[i++]);
                while (i < length) {
                    sb.append(", ").append(strings[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 9) {
            ArrayList calls = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (DriverCall dc : calls) {
                sb.append("[").append(dc).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 75) {
            ArrayList cells = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (NeighboringCellInfo cell : cells) {
                sb.append("[").append(cell).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 33) {
            CallForwardInfo[] cinfo = (CallForwardInfo[])ret;
            int length = cinfo.length;
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < length; ++i) {
                sb.append("[").append(cinfo[i]).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 124) {
            ArrayList hwcfgs = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (HardwareConfig hwcfg : hwcfgs) {
                sb.append("[").append(hwcfg).append("] ");
            }
            s = sb.toString();
        } else {
            s = ret.toString();
        }
        return s;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeMetricsNewSms(int tech, int format) {
        this.mMetrics.writeRilNewSms(this.mPhoneId, tech, format);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeMetricsCallRing(char[] response) {
        this.mMetrics.writeRilCallRing(this.mPhoneId, response);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeMetricsSrvcc(int state) {
        this.mMetrics.writeRilSrvcc(this.mPhoneId, state);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeMetricsModemRestartEvent(String reason) {
        this.mMetrics.writeModemRestartEvent(this.mPhoneId, reason);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsRilConnectionChanged(int rilVer) {
        this.mRilVersion = rilVer;
        if (this.mRilConnectedRegistrants != null) {
            this.mRilConnectedRegistrants.notifyRegistrants(new AsyncResult(null, new Integer(rilVer), null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsCdmaInfoRec(CdmaInformationRecords infoRec) {
        int response = 1027;
        if (infoRec.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mDisplayInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mSignalInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mNumberInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mRedirNumInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mLineControlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mT53ClirInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec && this.mT53AudCntrlInfoRegistrants != null) {
            this.unsljLogRet(response, infoRec.record);
            this.mT53AudCntrlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
        }
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$requestToString(int request) {
        switch (request) {
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "VOICE_REGISTRATION_STATE";
            }
            case 21: {
                return "DATA_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: {
                return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
            }
            case 104: {
                return "RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE";
            }
            case 105: {
                return "RIL_REQUEST_ISIM_AUTHENTICATION";
            }
            case 106: {
                return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
            }
            case 107: {
                return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
            }
            case 108: {
                return "RIL_REQUEST_VOICE_RADIO_TECH";
            }
            case 109: {
                return "RIL_REQUEST_GET_CELL_INFO_LIST";
            }
            case 110: {
                return "RIL_REQUEST_SET_CELL_INFO_LIST_RATE";
            }
            case 111: {
                return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
            }
            case 128: {
                return "RIL_REQUEST_SET_DATA_PROFILE";
            }
            case 112: {
                return "RIL_REQUEST_IMS_REGISTRATION_STATE";
            }
            case 113: {
                return "RIL_REQUEST_IMS_SEND_SMS";
            }
            case 114: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
            }
            case 115: {
                return "RIL_REQUEST_SIM_OPEN_CHANNEL";
            }
            case 116: {
                return "RIL_REQUEST_SIM_CLOSE_CHANNEL";
            }
            case 117: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";
            }
            case 118: {
                return "RIL_REQUEST_NV_READ_ITEM";
            }
            case 119: {
                return "RIL_REQUEST_NV_WRITE_ITEM";
            }
            case 120: {
                return "RIL_REQUEST_NV_WRITE_CDMA_PRL";
            }
            case 121: {
                return "RIL_REQUEST_NV_RESET_CONFIG";
            }
            case 122: {
                return "RIL_REQUEST_SET_UICC_SUBSCRIPTION";
            }
            case 123: {
                return "RIL_REQUEST_ALLOW_DATA";
            }
            case 124: {
                return "GET_HARDWARE_CONFIG";
            }
            case 125: {
                return "RIL_REQUEST_SIM_AUTHENTICATION";
            }
            case 129: {
                return "RIL_REQUEST_SHUTDOWN";
            }
            case 131: {
                return "RIL_REQUEST_SET_RADIO_CAPABILITY";
            }
            case 130: {
                return "RIL_REQUEST_GET_RADIO_CAPABILITY";
            }
            case 132: {
                return "RIL_REQUEST_START_LCE";
            }
            case 133: {
                return "RIL_REQUEST_STOP_LCE";
            }
            case 134: {
                return "RIL_REQUEST_PULL_LCEDATA";
            }
            case 135: {
                return "RIL_REQUEST_GET_ACTIVITY_INFO";
            }
            case 136: {
                return "RIL_REQUEST_SET_ALLOWED_CARRIERS";
            }
            case 137: {
                return "RIL_REQUEST_GET_ALLOWED_CARRIERS";
            }
            case 140: {
                return "RIL_REQUEST_SET_SIM_CARD_POWER";
            }
            case 138: {
                return "RIL_REQUEST_SEND_DEVICE_STATE";
            }
            case 139: {
                return "RIL_REQUEST_SET_UNSOLICITED_RESPONSE_FILTER";
            }
            case 800: {
                return "RIL_RESPONSE_ACKNOWLEDGEMENT";
            }
            case 141: {
                return "RIL_REQUEST_SET_CARRIER_INFO_IMSI_ENCRYPTION";
            }
            case 142: {
                return "RIL_REQUEST_START_NETWORK_SCAN";
            }
            case 143: {
                return "RIL_REQUEST_STOP_NETWORK_SCAN";
            }
            case 144: {
                return "RIL_REQUEST_GET_SLOT_STATUS";
            }
            case 145: {
                return "RIL_REQUEST_SET_LOGICAL_TO_PHYSICAL_SLOT_MAPPING";
            }
            case 146: {
                return "RIL_REQUEST_START_KEEPALIVE";
            }
            case 147: {
                return "RIL_REQUEST_STOP_KEEPALIVE";
            }
            case 148: {
                return "RIL_REQUEST_SET_SIGNAL_STRENGTH_REPORTING_CRITERIA";
            }
            case 149: {
                return "RIL_REQUEST_SET_LINK_CAPACITY_REPORTING_CRITERIA";
            }
        }
        return "<unknown request>";
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$responseToString(int request) {
        switch (request) {
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONE";
            }
            case 1030: {
                return "UNSOL_RESEND_INCALL_MUTE";
            }
            case 1031: {
                return "CDMA_SUBSCRIPTION_SOURCE_CHANGED";
            }
            case 1032: {
                return "UNSOL_CDMA_PRL_CHANGED";
            }
            case 1033: {
                return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 1034: {
                return "UNSOL_RIL_CONNECTED";
            }
            case 1035: {
                return "UNSOL_VOICE_RADIO_TECH_CHANGED";
            }
            case 1036: {
                return "UNSOL_CELL_INFO_LIST";
            }
            case 1037: {
                return "UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED";
            }
            case 1038: {
                return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
            }
            case 1039: {
                return "UNSOL_SRVCC_STATE_NOTIFY";
            }
            case 1040: {
                return "RIL_UNSOL_HARDWARE_CONFIG_CHANGED";
            }
            case 1042: {
                return "RIL_UNSOL_RADIO_CAPABILITY";
            }
            case 1043: {
                return "UNSOL_ON_SS";
            }
            case 1044: {
                return "UNSOL_STK_CC_ALPHA_NOTIFY";
            }
            case 1045: {
                return "UNSOL_LCE_INFO_RECV";
            }
            case 1046: {
                return "UNSOL_PCO_DATA";
            }
            case 1047: {
                return "UNSOL_MODEM_RESTART";
            }
            case 1048: {
                return "RIL_UNSOL_CARRIER_INFO_IMSI_ENCRYPTION";
            }
            case 1049: {
                return "RIL_UNSOL_NETWORK_SCAN_RESULT";
            }
            case 1050: {
                return "RIL_UNSOL_ICC_SLOT_STATUS";
            }
            case 1051: {
                return "RIL_UNSOL_KEEPALIVE_STATUS";
            }
            case 1052: {
                return "RIL_UNSOL_PHYSICAL_CHANNEL_CONFIG";
            }
        }
        return "<unknown response>";
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLog(String msg) {
        Rlog.d("RILJ", msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLoge(String msg) {
        Rlog.e("RILJ", msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLoge(String msg, Exception e) {
        Rlog.e("RILJ", msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""), e);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLogv(String msg) {
        Rlog.v("RILJ", msg + (this.mPhoneId != null ? " [SUB" + this.mPhoneId + "]" : ""));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLog(int response) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogMore(int response, String more) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + more);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogRet(int response, Object ret) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogvRet(int response, Object ret) {
        this.riljLogv("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPhoneType(int phoneType) {
        this.riljLog("setPhoneType=" + phoneType + " old value=" + this.mPhoneType);
        this.mPhoneType = phoneType;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$testingEmergencyCall() {
        this.riljLog("testingEmergencyCall");
        this.mTestingEmergencyCall.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RIL: " + this);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mWakeLockTimeout=" + this.mWakeLockTimeout);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                pw.println(" mWakeLockCount=" + this.mWakeLockCount);
            }
            int count = this.mRequestList.size();
            pw.println(" mRequestList count=" + count);
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                pw.println("  [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
            }
        }
        pw.println(" mLastNITZTimeInfo=" + Arrays.toString(this.mLastNITZTimeInfo));
        pw.println(" mTestingEmergencyCall=" + this.mTestingEmergencyCall.get());
        this.mClientWakelockTracker.dumpClientRequestTracker(pw);
    }

    private final List<ClientRequestStats> $$robo$$com_android_internal_telephony_RIL$getClientRequestStats() {
        return this.mClientWakelockTracker.getClientRequestStats();
    }

    private static final void $$robo$$com_android_internal_telephony_RIL$appendPrimitiveArrayToArrayList(byte[] src, ArrayList<Byte> dst) {
        for (byte b : src) {
            dst.add(b);
        }
    }

    private static final ArrayList<Byte> $$robo$$com_android_internal_telephony_RIL$primitiveArrayToArrayList(byte[] arr) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(arr.length);
        for (byte b : arr) {
            arrayList.add(b);
        }
        return arrayList;
    }

    private static final ArrayList<Integer> $$robo$$com_android_internal_telephony_RIL$primitiveArrayToArrayList(int[] arr) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(arr.length);
        for (int i : arr) {
            arrayList.add(i);
        }
        return arrayList;
    }

    private static final byte[] $$robo$$com_android_internal_telephony_RIL$arrayListToPrimitiveArray(ArrayList<Byte> bytes) {
        byte[] ret = new byte[bytes.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bytes.get(i);
        }
        return ret;
    }

    private static final ArrayList<HardwareConfig> $$robo$$com_android_internal_telephony_RIL$convertHalHwConfigList(ArrayList<android.hardware.radio.V1_0.HardwareConfig> hwListRil, RIL ril) {
        int num = hwListRil.size();
        ArrayList<HardwareConfig> response = new ArrayList<HardwareConfig>(num);
        for (android.hardware.radio.V1_0.HardwareConfig hwRil : hwListRil) {
            HardwareConfig hw;
            int type = hwRil.type;
            switch (type) {
                case 0: {
                    hw = new HardwareConfig(type);
                    HardwareConfigModem hwModem = hwRil.modem.get(0);
                    hw.assignModem(hwRil.uuid, hwRil.state, hwModem.rilModel, hwModem.rat, hwModem.maxVoice, hwModem.maxData, hwModem.maxStandby);
                    break;
                }
                case 1: {
                    hw = new HardwareConfig(type);
                    hw.assignSim(hwRil.uuid, hwRil.state, hwRil.sim.get((int)0).modemUuid);
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_REQUEST_GET_HARDWARE_CONFIG invalid hardward type:" + type);
                }
            }
            response.add(hw);
        }
        return response;
    }

    private static final RadioCapability $$robo$$com_android_internal_telephony_RIL$convertHalRadioCapability(android.hardware.radio.V1_0.RadioCapability rcRil, RIL ril) {
        int session = rcRil.session;
        int phase = rcRil.phase;
        int rat = rcRil.raf;
        String logicModemUuid = rcRil.logicalModemUuid;
        int status = rcRil.status;
        ril.riljLog("convertHalRadioCapability: session=" + session + ", phase=" + phase + ", rat=" + rat + ", logicModemUuid=" + logicModemUuid + ", status=" + status);
        RadioCapability rc = new RadioCapability(ril.mPhoneId, session, phase, rat, logicModemUuid, status);
        return rc;
    }

    private static final LinkCapacityEstimate $$robo$$com_android_internal_telephony_RIL$convertHalLceData(LceDataInfo halData, RIL ril) {
        LinkCapacityEstimate lce = new LinkCapacityEstimate(halData.lastHopCapacityKbps, Byte.toUnsignedInt(halData.confidenceLevel), halData.lceSuspended ? 1 : 0);
        ril.riljLog("LCE capacity information received:" + lce);
        return lce;
    }

    private static final LinkCapacityEstimate $$robo$$com_android_internal_telephony_RIL$convertHalLceData(android.hardware.radio.V1_2.LinkCapacityEstimate halData, RIL ril) {
        LinkCapacityEstimate lce = new LinkCapacityEstimate(halData.downlinkCapacityKbps, halData.uplinkCapacityKbps);
        ril.riljLog("LCE capacity information received:" + lce);
        return lce;
    }

    private static final void $$robo$$com_android_internal_telephony_RIL$writeToParcelForGsm(Parcel p, int lac, int cid, int arfcn, int bsic, String mcc, String mnc, String al, String as, int ss, int ber, int ta) {
        p.writeInt(1);
        p.writeString(mcc);
        p.writeString(mnc);
        p.writeString(al);
        p.writeString(as);
        p.writeInt(lac);
        p.writeInt(cid);
        p.writeInt(arfcn);
        p.writeInt(bsic);
        p.writeInt(ss);
        p.writeInt(ber);
        p.writeInt(ta);
    }

    private static final void $$robo$$com_android_internal_telephony_RIL$writeToParcelForCdma(Parcel p, int ni, int si, int bsi, int lon, int lat, String al, String as, int dbm, int ecio, int eDbm, int eEcio, int eSnr) {
        new CellIdentityCdma(ni, si, bsi, lon, lat, al, as).writeToParcel(p, 0);
        new CellSignalStrengthCdma(dbm, ecio, eDbm, eEcio, eSnr).writeToParcel(p, 0);
    }

    private static final void $$robo$$com_android_internal_telephony_RIL$writeToParcelForLte(Parcel p, int ci, int pci, int tac, int earfcn, int bandwidth, String mcc, String mnc, String al, String as, int ss, int rsrp, int rsrq, int rssnr, int cqi, int ta) {
        p.writeInt(3);
        p.writeString(mcc);
        p.writeString(mnc);
        p.writeString(al);
        p.writeString(as);
        p.writeInt(ci);
        p.writeInt(pci);
        p.writeInt(tac);
        p.writeInt(earfcn);
        p.writeInt(bandwidth);
        p.writeInt(ss);
        p.writeInt(rsrp);
        p.writeInt(rsrq);
        p.writeInt(rssnr);
        p.writeInt(cqi);
        p.writeInt(ta);
    }

    private static final void $$robo$$com_android_internal_telephony_RIL$writeToParcelForWcdma(Parcel p, int lac, int cid, int psc, int uarfcn, String mcc, String mnc, String al, String as, int ss, int ber) {
        p.writeInt(4);
        p.writeString(mcc);
        p.writeString(mnc);
        p.writeString(al);
        p.writeString(as);
        p.writeInt(lac);
        p.writeInt(cid);
        p.writeInt(psc);
        p.writeInt(uarfcn);
        p.writeInt(ss);
        p.writeInt(ber);
    }

    @VisibleForTesting
    private static final ArrayList<android.telephony.CellInfo> $$robo$$com_android_internal_telephony_RIL$convertHalCellInfoList(ArrayList<CellInfo> records) {
        ArrayList<android.telephony.CellInfo> response = new ArrayList<android.telephony.CellInfo>(records.size());
        for (CellInfo record : records) {
            Parcel p = Parcel.obtain();
            p.writeInt(record.cellInfoType);
            p.writeInt(record.registered ? 1 : 0);
            p.writeInt(record.timeStampType);
            p.writeLong(record.timeStamp);
            p.writeInt(Integer.MAX_VALUE);
            switch (record.cellInfoType) {
                case 1: {
                    android.hardware.radio.V1_0.CellInfoGsm cellInfoGsm = record.gsm.get(0);
                    RIL.writeToParcelForGsm(p, cellInfoGsm.cellIdentityGsm.lac, cellInfoGsm.cellIdentityGsm.cid, cellInfoGsm.cellIdentityGsm.arfcn, Byte.toUnsignedInt(cellInfoGsm.cellIdentityGsm.bsic), cellInfoGsm.cellIdentityGsm.mcc, cellInfoGsm.cellIdentityGsm.mnc, "", "", cellInfoGsm.signalStrengthGsm.signalStrength, cellInfoGsm.signalStrengthGsm.bitErrorRate, cellInfoGsm.signalStrengthGsm.timingAdvance);
                    break;
                }
                case 2: {
                    CellInfoCdma cellInfoCdma = record.cdma.get(0);
                    RIL.writeToParcelForCdma(p, cellInfoCdma.cellIdentityCdma.networkId, cellInfoCdma.cellIdentityCdma.systemId, cellInfoCdma.cellIdentityCdma.baseStationId, cellInfoCdma.cellIdentityCdma.longitude, cellInfoCdma.cellIdentityCdma.latitude, "", "", cellInfoCdma.signalStrengthCdma.dbm, cellInfoCdma.signalStrengthCdma.ecio, cellInfoCdma.signalStrengthEvdo.dbm, cellInfoCdma.signalStrengthEvdo.ecio, cellInfoCdma.signalStrengthEvdo.signalNoiseRatio);
                    break;
                }
                case 3: {
                    CellInfoLte cellInfoLte = record.lte.get(0);
                    RIL.writeToParcelForLte(p, cellInfoLte.cellIdentityLte.ci, cellInfoLte.cellIdentityLte.pci, cellInfoLte.cellIdentityLte.tac, cellInfoLte.cellIdentityLte.earfcn, Integer.MAX_VALUE, cellInfoLte.cellIdentityLte.mcc, cellInfoLte.cellIdentityLte.mnc, "", "", cellInfoLte.signalStrengthLte.signalStrength, cellInfoLte.signalStrengthLte.rsrp, cellInfoLte.signalStrengthLte.rsrq, cellInfoLte.signalStrengthLte.rssnr, cellInfoLte.signalStrengthLte.cqi, cellInfoLte.signalStrengthLte.timingAdvance);
                    break;
                }
                case 4: {
                    CellInfoWcdma cellInfoWcdma = record.wcdma.get(0);
                    RIL.writeToParcelForWcdma(p, cellInfoWcdma.cellIdentityWcdma.lac, cellInfoWcdma.cellIdentityWcdma.cid, cellInfoWcdma.cellIdentityWcdma.psc, cellInfoWcdma.cellIdentityWcdma.uarfcn, cellInfoWcdma.cellIdentityWcdma.mcc, cellInfoWcdma.cellIdentityWcdma.mnc, "", "", cellInfoWcdma.signalStrengthWcdma.signalStrength, cellInfoWcdma.signalStrengthWcdma.bitErrorRate);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected cellinfotype: " + record.cellInfoType);
                }
            }
            p.setDataPosition(0);
            android.telephony.CellInfo InfoRec = android.telephony.CellInfo.CREATOR.createFromParcel(p);
            p.recycle();
            response.add(InfoRec);
        }
        return response;
    }

    @VisibleForTesting
    private static final ArrayList<android.telephony.CellInfo> $$robo$$com_android_internal_telephony_RIL$convertHalCellInfoList_1_2(ArrayList<android.hardware.radio.V1_2.CellInfo> records) {
        ArrayList<android.telephony.CellInfo> response = new ArrayList<android.telephony.CellInfo>(records.size());
        for (android.hardware.radio.V1_2.CellInfo record : records) {
            Parcel p = Parcel.obtain();
            p.writeInt(record.cellInfoType);
            p.writeInt(record.registered ? 1 : 0);
            p.writeInt(record.timeStampType);
            p.writeLong(record.timeStamp);
            p.writeInt(record.connectionStatus);
            switch (record.cellInfoType) {
                case 1: {
                    CellInfoGsm cellInfoGsm = record.gsm.get(0);
                    RIL.writeToParcelForGsm(p, cellInfoGsm.cellIdentityGsm.base.lac, cellInfoGsm.cellIdentityGsm.base.cid, cellInfoGsm.cellIdentityGsm.base.arfcn, Byte.toUnsignedInt(cellInfoGsm.cellIdentityGsm.base.bsic), cellInfoGsm.cellIdentityGsm.base.mcc, cellInfoGsm.cellIdentityGsm.base.mnc, cellInfoGsm.cellIdentityGsm.operatorNames.alphaLong, cellInfoGsm.cellIdentityGsm.operatorNames.alphaShort, cellInfoGsm.signalStrengthGsm.signalStrength, cellInfoGsm.signalStrengthGsm.bitErrorRate, cellInfoGsm.signalStrengthGsm.timingAdvance);
                    break;
                }
                case 2: {
                    android.hardware.radio.V1_2.CellInfoCdma cellInfoCdma = record.cdma.get(0);
                    RIL.writeToParcelForCdma(p, cellInfoCdma.cellIdentityCdma.base.networkId, cellInfoCdma.cellIdentityCdma.base.systemId, cellInfoCdma.cellIdentityCdma.base.baseStationId, cellInfoCdma.cellIdentityCdma.base.longitude, cellInfoCdma.cellIdentityCdma.base.latitude, cellInfoCdma.cellIdentityCdma.operatorNames.alphaLong, cellInfoCdma.cellIdentityCdma.operatorNames.alphaShort, cellInfoCdma.signalStrengthCdma.dbm, cellInfoCdma.signalStrengthCdma.ecio, cellInfoCdma.signalStrengthEvdo.dbm, cellInfoCdma.signalStrengthEvdo.ecio, cellInfoCdma.signalStrengthEvdo.signalNoiseRatio);
                    break;
                }
                case 3: {
                    android.hardware.radio.V1_2.CellInfoLte cellInfoLte = record.lte.get(0);
                    RIL.writeToParcelForLte(p, cellInfoLte.cellIdentityLte.base.ci, cellInfoLte.cellIdentityLte.base.pci, cellInfoLte.cellIdentityLte.base.tac, cellInfoLte.cellIdentityLte.base.earfcn, cellInfoLte.cellIdentityLte.bandwidth, cellInfoLte.cellIdentityLte.base.mcc, cellInfoLte.cellIdentityLte.base.mnc, cellInfoLte.cellIdentityLte.operatorNames.alphaLong, cellInfoLte.cellIdentityLte.operatorNames.alphaShort, cellInfoLte.signalStrengthLte.signalStrength, cellInfoLte.signalStrengthLte.rsrp, cellInfoLte.signalStrengthLte.rsrq, cellInfoLte.signalStrengthLte.rssnr, cellInfoLte.signalStrengthLte.cqi, cellInfoLte.signalStrengthLte.timingAdvance);
                    break;
                }
                case 4: {
                    android.hardware.radio.V1_2.CellInfoWcdma cellInfoWcdma = record.wcdma.get(0);
                    RIL.writeToParcelForWcdma(p, cellInfoWcdma.cellIdentityWcdma.base.lac, cellInfoWcdma.cellIdentityWcdma.base.cid, cellInfoWcdma.cellIdentityWcdma.base.psc, cellInfoWcdma.cellIdentityWcdma.base.uarfcn, cellInfoWcdma.cellIdentityWcdma.base.mcc, cellInfoWcdma.cellIdentityWcdma.base.mnc, cellInfoWcdma.cellIdentityWcdma.operatorNames.alphaLong, cellInfoWcdma.cellIdentityWcdma.operatorNames.alphaShort, cellInfoWcdma.signalStrengthWcdma.base.signalStrength, cellInfoWcdma.signalStrengthWcdma.base.bitErrorRate);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected cellinfotype: " + record.cellInfoType);
                }
            }
            p.setDataPosition(0);
            android.telephony.CellInfo InfoRec = android.telephony.CellInfo.CREATOR.createFromParcel(p);
            p.recycle();
            response.add(InfoRec);
        }
        return response;
    }

    @VisibleForTesting
    private static final SignalStrength $$robo$$com_android_internal_telephony_RIL$convertHalSignalStrength(android.hardware.radio.V1_0.SignalStrength signalStrength) {
        int tdscdmaRscp_1_2 = 255;
        if (signalStrength.tdScdma.rscp >= 25 && signalStrength.tdScdma.rscp <= 120) {
            int rscpDbm = -signalStrength.tdScdma.rscp;
            tdscdmaRscp_1_2 = rscpDbm + 120;
        }
        return new SignalStrength(signalStrength.gw.signalStrength, signalStrength.gw.bitErrorRate, signalStrength.cdma.dbm, signalStrength.cdma.ecio, signalStrength.evdo.dbm, signalStrength.evdo.ecio, signalStrength.evdo.signalNoiseRatio, signalStrength.lte.signalStrength, signalStrength.lte.rsrp, signalStrength.lte.rsrq, signalStrength.lte.rssnr, signalStrength.lte.cqi, tdscdmaRscp_1_2);
    }

    @VisibleForTesting
    private static final SignalStrength $$robo$$com_android_internal_telephony_RIL$convertHalSignalStrength_1_2(android.hardware.radio.V1_2.SignalStrength signalStrength) {
        return new SignalStrength(signalStrength.gsm.signalStrength, signalStrength.gsm.bitErrorRate, signalStrength.cdma.dbm, signalStrength.cdma.ecio, signalStrength.evdo.dbm, signalStrength.evdo.ecio, signalStrength.evdo.signalNoiseRatio, signalStrength.lte.signalStrength, signalStrength.lte.rsrp, signalStrength.lte.rsrq, signalStrength.lte.rssnr, signalStrength.lte.cqi, signalStrength.tdScdma.rscp, signalStrength.wcdma.base.signalStrength, signalStrength.wcdma.rscp);
    }

    static void __staticInitializer__() {
        mRilTimeHistograms = new SparseArray();
        HIDL_SERVICE_NAME = new String[]{"slot1", "slot2", "slot3"};
    }

    public static List<TelephonyHistogram> getTelephonyRILTimingHistograms() {
        return InvokeDynamicSupport.bootstrapStatic("getTelephonyRILTimingHistograms", $$robo$$com_android_internal_telephony_RIL$getTelephonyRILTimingHistograms());
    }

    private static Object getResponseForTimedOutRILRequest(RILRequest rILRequest) {
        return InvokeDynamicSupport.bootstrapStatic("getResponseForTimedOutRILRequest", $$robo$$com_android_internal_telephony_RIL$getResponseForTimedOutRILRequest(com.android.internal.telephony.RILRequest ), (RILRequest)rILRequest);
    }

    private void resetProxyAndRequestList() {
        InvokeDynamicSupport.bootstrap("resetProxyAndRequestList", $$robo$$com_android_internal_telephony_RIL$resetProxyAndRequestList(), this);
    }

    public android.hardware.radio.V1_0.IRadio getRadioProxy(Message message) {
        return InvokeDynamicSupport.bootstrap("getRadioProxy", $$robo$$com_android_internal_telephony_RIL$getRadioProxy(android.os.Message ), this, message);
    }

    public IOemHook getOemHookProxy(Message message) {
        return InvokeDynamicSupport.bootstrap("getOemHookProxy", $$robo$$com_android_internal_telephony_RIL$getOemHookProxy(android.os.Message ), this, message);
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$com_android_internal_telephony_RIL$__constructor__(context, n, n2);
    }

    public RIL(Context context, int n, int n2) {
        this(context, n, n2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL$__constructor__(android.content.Context int int ), this, context, n, n2);
    }

    private void __constructor__(Context context, int n, int n2, Integer n3) {
        this.$$robo$$com_android_internal_telephony_RIL$__constructor__(context, n, n2, n3);
    }

    public RIL(Context context, int n, int n2, Integer n3) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL$__constructor__(android.content.Context int int java.lang.Integer ), this, context, n, n2, n3);
    }

    @Override
    public void setOnNITZTime(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnNITZTime", $$robo$$com_android_internal_telephony_RIL$setOnNITZTime(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    private void addRequest(RILRequest rILRequest) {
        InvokeDynamicSupport.bootstrap("addRequest", $$robo$$com_android_internal_telephony_RIL$addRequest(com.android.internal.telephony.RILRequest ), this, rILRequest);
    }

    private RILRequest obtainRequest(int n, Message message, WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("obtainRequest", $$robo$$com_android_internal_telephony_RIL$obtainRequest(int android.os.Message android.os.WorkSource ), this, n, message, workSource);
    }

    private void handleRadioProxyExceptionForRR(RILRequest rILRequest, String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("handleRadioProxyExceptionForRR", $$robo$$com_android_internal_telephony_RIL$handleRadioProxyExceptionForRR(com.android.internal.telephony.RILRequest java.lang.String java.lang.Exception ), this, rILRequest, string2, exception);
    }

    private String convertNullToEmptyString(String string2) {
        return InvokeDynamicSupport.bootstrap("convertNullToEmptyString", $$robo$$com_android_internal_telephony_RIL$convertNullToEmptyString(java.lang.String ), this, string2);
    }

    @Override
    public void getIccCardStatus(Message message) {
        InvokeDynamicSupport.bootstrap("getIccCardStatus", $$robo$$com_android_internal_telephony_RIL$getIccCardStatus(android.os.Message ), this, message);
    }

    @Override
    public void getIccSlotsStatus(Message message) {
        InvokeDynamicSupport.bootstrap("getIccSlotsStatus", $$robo$$com_android_internal_telephony_RIL$getIccSlotsStatus(android.os.Message ), this, message);
    }

    @Override
    public void setLogicalToPhysicalSlotMapping(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setLogicalToPhysicalSlotMapping", $$robo$$com_android_internal_telephony_RIL$setLogicalToPhysicalSlotMapping(int[] android.os.Message ), this, nArray, message);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin", $$robo$$com_android_internal_telephony_RIL$supplyIccPin(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void supplyIccPinForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPinForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPinForApp(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void supplyIccPukForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPukForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPukForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), this, string2, string3, string4, message);
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2", $$robo$$com_android_internal_telephony_RIL$supplyIccPin2(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void supplyIccPin2ForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2ForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPin2ForApp(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2ForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin", $$robo$$com_android_internal_telephony_RIL$changeIccPin(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void changeIccPinForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPinForApp", $$robo$$com_android_internal_telephony_RIL$changeIccPinForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2", $$robo$$com_android_internal_telephony_RIL$changeIccPin2(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void changeIccPin2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2ForApp", $$robo$$com_android_internal_telephony_RIL$changeIccPin2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), this, string2, string3, string4, message);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_RIL$supplyNetworkDepersonalization(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void getCurrentCalls(Message message) {
        InvokeDynamicSupport.bootstrap("getCurrentCalls", $$robo$$com_android_internal_telephony_RIL$getCurrentCalls(android.os.Message ), this, message);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_RIL$dial(java.lang.String int android.os.Message ), this, string2, n, message);
    }

    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_RIL$dial(java.lang.String int com.android.internal.telephony.UUSInfo android.os.Message ), this, string2, n, uUSInfo, message);
    }

    @Override
    public void getIMSI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMSI", $$robo$$com_android_internal_telephony_RIL$getIMSI(android.os.Message ), this, message);
    }

    @Override
    public void getIMSIForApp(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("getIMSIForApp", $$robo$$com_android_internal_telephony_RIL$getIMSIForApp(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("hangupConnection", $$robo$$com_android_internal_telephony_RIL$hangupConnection(int android.os.Message ), this, n, message);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_RIL$hangupWaitingOrBackground(android.os.Message ), this, message);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_RIL$hangupForegroundResumeBackground(android.os.Message ), this, message);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_RIL$switchWaitingOrHoldingAndActive(android.os.Message ), this, message);
    }

    @Override
    public void conference(Message message) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_RIL$conference(android.os.Message ), this, message);
    }

    @Override
    public void rejectCall(Message message) {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_RIL$rejectCall(android.os.Message ), this, message);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastCallFailCause", $$robo$$com_android_internal_telephony_RIL$getLastCallFailCause(android.os.Message ), this, message);
    }

    @Override
    public void getSignalStrength(Message message) {
        InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_RIL$getSignalStrength(android.os.Message ), this, message);
    }

    @Override
    public void getVoiceRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRegistrationState", $$robo$$com_android_internal_telephony_RIL$getVoiceRegistrationState(android.os.Message ), this, message);
    }

    @Override
    public void getDataRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getDataRegistrationState", $$robo$$com_android_internal_telephony_RIL$getDataRegistrationState(android.os.Message ), this, message);
    }

    @Override
    public void getOperator(Message message) {
        InvokeDynamicSupport.bootstrap("getOperator", $$robo$$com_android_internal_telephony_RIL$getOperator(android.os.Message ), this, message);
    }

    @Override
    public void setRadioPower(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_RIL$setRadioPower(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_RIL$sendDtmf(char android.os.Message ), this, c, message);
    }

    private GsmSmsMessage constructGsmSendSmsRilRequest(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("constructGsmSendSmsRilRequest", $$robo$$com_android_internal_telephony_RIL$constructGsmSendSmsRilRequest(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMS", $$robo$$com_android_internal_telephony_RIL$sendSMS(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public void sendSMSExpectMore(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMSExpectMore", $$robo$$com_android_internal_telephony_RIL$sendSMSExpectMore(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    private static int convertToHalMvnoType(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertToHalMvnoType", $$robo$$com_android_internal_telephony_RIL$convertToHalMvnoType(java.lang.String ), (String)string2);
    }

    private static DataProfileInfo convertToHalDataProfile(DataProfile dataProfile) {
        return InvokeDynamicSupport.bootstrapStatic("convertToHalDataProfile", $$robo$$com_android_internal_telephony_RIL$convertToHalDataProfile(android.telephony.data.DataProfile ), (DataProfile)dataProfile);
    }

    private static int convertToHalResetNvType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertToHalResetNvType", $$robo$$com_android_internal_telephony_RIL$convertToHalResetNvType(int ), (int)n);
    }

    @Override
    public void setupDataCall(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, Message message) {
        InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$com_android_internal_telephony_RIL$setupDataCall(int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.os.Message ), this, n, dataProfile, bl, bl2, n2, linkProperties, message);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("iccIO", $$robo$$com_android_internal_telephony_RIL$iccIO(int int java.lang.String int int int java.lang.String java.lang.String android.os.Message ), this, n, n2, string2, n3, n4, n5, string3, string4, message);
    }

    @Override
    public void iccIOForApp(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, String string5, Message message) {
        InvokeDynamicSupport.bootstrap("iccIOForApp", $$robo$$com_android_internal_telephony_RIL$iccIOForApp(int int java.lang.String int int int java.lang.String java.lang.String java.lang.String android.os.Message ), this, n, n2, string2, n3, n4, n5, string3, string4, string5, message);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_RIL$sendUSSD(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        InvokeDynamicSupport.bootstrap("cancelPendingUssd", $$robo$$com_android_internal_telephony_RIL$cancelPendingUssd(android.os.Message ), this, message);
    }

    @Override
    public void getCLIR(Message message) {
        InvokeDynamicSupport.bootstrap("getCLIR", $$robo$$com_android_internal_telephony_RIL$getCLIR(android.os.Message ), this, message);
    }

    @Override
    public void setCLIR(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCLIR", $$robo$$com_android_internal_telephony_RIL$setCLIR(int android.os.Message ), this, n, message);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallForwardStatus", $$robo$$com_android_internal_telephony_RIL$queryCallForwardStatus(int int java.lang.String android.os.Message ), this, n, n2, string2, message);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForward", $$robo$$com_android_internal_telephony_RIL$setCallForward(int int int java.lang.String int android.os.Message ), this, n, n2, n3, string2, n4, message);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallWaiting", $$robo$$com_android_internal_telephony_RIL$queryCallWaiting(int android.os.Message ), this, n, message);
    }

    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_RIL$setCallWaiting(boolean int android.os.Message ), this, bl, n, message);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingGsmSms", $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingGsmSms(boolean int android.os.Message ), this, bl, n, message);
    }

    @Override
    public void acceptCall(Message message) {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_RIL$acceptCall(android.os.Message ), this, message);
    }

    @Override
    public void deactivateDataCall(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$com_android_internal_telephony_RIL$deactivateDataCall(int int android.os.Message ), this, n, n2, message);
    }

    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLock", $$robo$$com_android_internal_telephony_RIL$queryFacilityLock(java.lang.String java.lang.String int android.os.Message ), this, string2, string3, n, message);
    }

    @Override
    public void queryFacilityLockForApp(String string2, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLockForApp", $$robo$$com_android_internal_telephony_RIL$queryFacilityLockForApp(java.lang.String java.lang.String int java.lang.String android.os.Message ), this, string2, string3, n, string4, message);
    }

    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLock", $$robo$$com_android_internal_telephony_RIL$setFacilityLock(java.lang.String boolean java.lang.String int android.os.Message ), this, string2, bl, string3, n, message);
    }

    @Override
    public void setFacilityLockForApp(String string2, boolean bl, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLockForApp", $$robo$$com_android_internal_telephony_RIL$setFacilityLockForApp(java.lang.String boolean java.lang.String int java.lang.String android.os.Message ), this, string2, bl, string3, n, string4, message);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeBarringPassword", $$robo$$com_android_internal_telephony_RIL$changeBarringPassword(java.lang.String java.lang.String java.lang.String android.os.Message ), this, string2, string3, string4, message);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        InvokeDynamicSupport.bootstrap("getNetworkSelectionMode", $$robo$$com_android_internal_telephony_RIL$getNetworkSelectionMode(android.os.Message ), this, message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeAutomatic(android.os.Message ), this, message);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeManual", $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeManual(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_RIL$getAvailableNetworks(android.os.Message ), this, message);
    }

    private android.hardware.radio.V1_1.RadioAccessSpecifier convertRadioAccessSpecifierToRadioHAL(RadioAccessSpecifier radioAccessSpecifier) {
        return InvokeDynamicSupport.bootstrap("convertRadioAccessSpecifierToRadioHAL", $$robo$$com_android_internal_telephony_RIL$convertRadioAccessSpecifierToRadioHAL(android.telephony.RadioAccessSpecifier ), this, radioAccessSpecifier);
    }

    @Override
    public void startNetworkScan(android.telephony.NetworkScanRequest networkScanRequest, Message message) {
        InvokeDynamicSupport.bootstrap("startNetworkScan", $$robo$$com_android_internal_telephony_RIL$startNetworkScan(android.telephony.NetworkScanRequest android.os.Message ), this, networkScanRequest, message);
    }

    @Override
    public void stopNetworkScan(Message message) {
        InvokeDynamicSupport.bootstrap("stopNetworkScan", $$robo$$com_android_internal_telephony_RIL$stopNetworkScan(android.os.Message ), this, message);
    }

    @Override
    public void startDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_RIL$startDtmf(char android.os.Message ), this, c, message);
    }

    @Override
    public void stopDtmf(Message message) {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_RIL$stopDtmf(android.os.Message ), this, message);
    }

    @Override
    public void separateConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("separateConnection", $$robo$$com_android_internal_telephony_RIL$separateConnection(int android.os.Message ), this, n, message);
    }

    @Override
    public void getBasebandVersion(Message message) {
        InvokeDynamicSupport.bootstrap("getBasebandVersion", $$robo$$com_android_internal_telephony_RIL$getBasebandVersion(android.os.Message ), this, message);
    }

    @Override
    public void setMute(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_RIL$setMute(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void getMute(Message message) {
        InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_RIL$getMute(android.os.Message ), this, message);
    }

    @Override
    public void queryCLIP(Message message) {
        InvokeDynamicSupport.bootstrap("queryCLIP", $$robo$$com_android_internal_telephony_RIL$queryCLIP(android.os.Message ), this, message);
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message message) {
        InvokeDynamicSupport.bootstrap("getPDPContextList", $$robo$$com_android_internal_telephony_RIL$getPDPContextList(android.os.Message ), this, message);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_RIL$getDataCallList(android.os.Message ), this, message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestRaw(byte[] android.os.Message ), this, byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), this, stringArray, message);
    }

    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setSuppServiceNotifications", $$robo$$com_android_internal_telephony_RIL$setSuppServiceNotifications(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToSim", $$robo$$com_android_internal_telephony_RIL$writeSmsToSim(int java.lang.String java.lang.String android.os.Message ), this, n, string2, string3, message);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnSim", $$robo$$com_android_internal_telephony_RIL$deleteSmsOnSim(int android.os.Message ), this, n, message);
    }

    @Override
    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_RIL$setBandMode(int android.os.Message ), this, n, message);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_RIL$queryAvailableBandMode(android.os.Message ), this, message);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelope", $$robo$$com_android_internal_telephony_RIL$sendEnvelope(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendTerminalResponse", $$robo$$com_android_internal_telephony_RIL$sendTerminalResponse(java.lang.String android.os.Message ), this, string2, message);
    }

    private String censoredTerminalResponse(String string2) {
        return InvokeDynamicSupport.bootstrap("censoredTerminalResponse", $$robo$$com_android_internal_telephony_RIL$censoredTerminalResponse(java.lang.String ), this, string2);
    }

    @Override
    public void sendEnvelopeWithStatus(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$com_android_internal_telephony_RIL$sendEnvelopeWithStatus(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_RIL$explicitCallTransfer(android.os.Message ), this, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_RIL$setPreferredNetworkType(int android.os.Message ), this, n, message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_RIL$getPreferredNetworkType(android.os.Message ), this, message);
    }

    @Override
    public void getNeighboringCids(Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_RIL$getNeighboringCids(android.os.Message android.os.WorkSource ), this, message, workSource);
    }

    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setLocationUpdates", $$robo$$com_android_internal_telephony_RIL$setLocationUpdates(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void setCdmaSubscriptionSource(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_RIL$setCdmaSubscriptionSource(int android.os.Message ), this, n, message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_RIL$queryCdmaRoamingPreference(android.os.Message ), this, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_RIL$setCdmaRoamingPreference(int android.os.Message ), this, n, message);
    }

    @Override
    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_RIL$queryTTYMode(android.os.Message ), this, message);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_RIL$setTTYMode(int android.os.Message ), this, n, message);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_RIL$setPreferredVoicePrivacy(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_RIL$getPreferredVoicePrivacy(android.os.Message ), this, message);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendCDMAFeatureCode", $$robo$$com_android_internal_telephony_RIL$sendCDMAFeatureCode(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_RIL$sendBurstDtmf(java.lang.String int int android.os.Message ), this, string2, n, n2, message);
    }

    private void constructCdmaSendSmsRilRequest(CdmaSmsMessage cdmaSmsMessage, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("constructCdmaSendSmsRilRequest", $$robo$$com_android_internal_telephony_RIL$constructCdmaSendSmsRilRequest(android.hardware.radio.V1_0.CdmaSmsMessage byte[] ), this, cdmaSmsMessage, byArray);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("sendCdmaSms", $$robo$$com_android_internal_telephony_RIL$sendCdmaSms(byte[] android.os.Message ), this, byArray, message);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingCdmaSms", $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingCdmaSms(boolean int android.os.Message ), this, bl, n, message);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getGsmBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$getGsmBroadcastConfig(android.os.Message ), this, message);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastConfig(com.android.internal.telephony.gsm.SmsBroadcastConfigInfo[] android.os.Message ), this, smsBroadcastConfigInfoArray, message);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastActivation", $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastActivation(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$getCdmaBroadcastConfig(android.os.Message ), this, message);
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] cdmaSmsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastConfig(com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo[] android.os.Message ), this, cdmaSmsBroadcastConfigInfoArray, message);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastActivation", $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastActivation(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void getCDMASubscription(Message message) {
        InvokeDynamicSupport.bootstrap("getCDMASubscription", $$robo$$com_android_internal_telephony_RIL$getCDMASubscription(android.os.Message ), this, message);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToRuim", $$robo$$com_android_internal_telephony_RIL$writeSmsToRuim(int java.lang.String android.os.Message ), this, n, string2, message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnRuim", $$robo$$com_android_internal_telephony_RIL$deleteSmsOnRuim(int android.os.Message ), this, n, message);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        InvokeDynamicSupport.bootstrap("getDeviceIdentity", $$robo$$com_android_internal_telephony_RIL$getDeviceIdentity(android.os.Message ), this, message);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_RIL$exitEmergencyCallbackMode(android.os.Message ), this, message);
    }

    @Override
    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_RIL$getSmscAddress(android.os.Message ), this, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_RIL$setSmscAddress(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("reportSmsMemoryStatus", $$robo$$com_android_internal_telephony_RIL$reportSmsMemoryStatus(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        InvokeDynamicSupport.bootstrap("reportStkServiceIsRunning", $$robo$$com_android_internal_telephony_RIL$reportStkServiceIsRunning(android.os.Message ), this, message);
    }

    @Override
    public void getCdmaSubscriptionSource(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_RIL$getCdmaSubscriptionSource(android.os.Message ), this, message);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeIncomingGsmSmsWithPdu", $$robo$$com_android_internal_telephony_RIL$acknowledgeIncomingGsmSmsWithPdu(boolean java.lang.String android.os.Message ), this, bl, string2, message);
    }

    @Override
    public void getVoiceRadioTechnology(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRadioTechnology", $$robo$$com_android_internal_telephony_RIL$getVoiceRadioTechnology(android.os.Message ), this, message);
    }

    @Override
    public void getCellInfoList(Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("getCellInfoList", $$robo$$com_android_internal_telephony_RIL$getCellInfoList(android.os.Message android.os.WorkSource ), this, message, workSource);
    }

    @Override
    public void setCellInfoListRate(int n, Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate(int android.os.Message android.os.WorkSource ), this, n, message, workSource);
    }

    void setCellInfoListRate() {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate(), this);
    }

    @Override
    public void setInitialAttachApn(DataProfile dataProfile, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$com_android_internal_telephony_RIL$setInitialAttachApn(android.telephony.data.DataProfile boolean android.os.Message ), this, dataProfile, bl, message);
    }

    @Override
    public void getImsRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getImsRegistrationState", $$robo$$com_android_internal_telephony_RIL$getImsRegistrationState(android.os.Message ), this, message);
    }

    @Override
    public void sendImsGsmSms(String string2, String string3, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsGsmSms", $$robo$$com_android_internal_telephony_RIL$sendImsGsmSms(java.lang.String java.lang.String int int android.os.Message ), this, string2, string3, n, n2, message);
    }

    @Override
    public void sendImsCdmaSms(byte[] byArray, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsCdmaSms", $$robo$$com_android_internal_telephony_RIL$sendImsCdmaSms(byte[] int int android.os.Message ), this, byArray, n, n2, message);
    }

    private SimApdu createSimApdu(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        return InvokeDynamicSupport.bootstrap("createSimApdu", $$robo$$com_android_internal_telephony_RIL$createSimApdu(int int int int int int java.lang.String ), this, n, n2, n3, n4, n5, n6, string2);
    }

    @Override
    public void iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$com_android_internal_telephony_RIL$iccTransmitApduBasicChannel(int int int int int java.lang.String android.os.Message ), this, n, n2, n3, n4, n5, string2, message);
    }

    @Override
    public void iccOpenLogicalChannel(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccOpenLogicalChannel(java.lang.String int android.os.Message ), this, string2, n, message);
    }

    @Override
    public void iccCloseLogicalChannel(int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccCloseLogicalChannel(int android.os.Message ), this, n, message);
    }

    @Override
    public void iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccTransmitApduLogicalChannel(int int int int int int java.lang.String android.os.Message ), this, n, n2, n3, n4, n5, n6, string2, message);
    }

    @Override
    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_RIL$nvReadItem(int android.os.Message ), this, n, message);
    }

    @Override
    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_RIL$nvWriteItem(int java.lang.String android.os.Message ), this, n, string2, message);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_RIL$nvWriteCdmaPrl(byte[] android.os.Message ), this, byArray, message);
    }

    @Override
    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_RIL$nvResetConfig(int android.os.Message ), this, n, message);
    }

    @Override
    public void setUiccSubscription(int n, int n2, int n3, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setUiccSubscription", $$robo$$com_android_internal_telephony_RIL$setUiccSubscription(int int int int android.os.Message ), this, n, n2, n3, n4, message);
    }

    @Override
    public void setDataAllowed(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataAllowed", $$robo$$com_android_internal_telephony_RIL$setDataAllowed(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void getHardwareConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getHardwareConfig", $$robo$$com_android_internal_telephony_RIL$getHardwareConfig(android.os.Message ), this, message);
    }

    @Override
    public void requestIccSimAuthentication(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("requestIccSimAuthentication", $$robo$$com_android_internal_telephony_RIL$requestIccSimAuthentication(int java.lang.String java.lang.String android.os.Message ), this, n, string2, string3, message);
    }

    @Override
    public void setDataProfile(DataProfile[] dataProfileArray, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$com_android_internal_telephony_RIL$setDataProfile(android.telephony.data.DataProfile[] boolean android.os.Message ), this, dataProfileArray, bl, message);
    }

    @Override
    public void requestShutdown(Message message) {
        InvokeDynamicSupport.bootstrap("requestShutdown", $$robo$$com_android_internal_telephony_RIL$requestShutdown(android.os.Message ), this, message);
    }

    @Override
    public void getRadioCapability(Message message) {
        InvokeDynamicSupport.bootstrap("getRadioCapability", $$robo$$com_android_internal_telephony_RIL$getRadioCapability(android.os.Message ), this, message);
    }

    @Override
    public void setRadioCapability(RadioCapability radioCapability, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioCapability", $$robo$$com_android_internal_telephony_RIL$setRadioCapability(com.android.internal.telephony.RadioCapability android.os.Message ), this, radioCapability, message);
    }

    @Override
    public void startLceService(int n, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("startLceService", $$robo$$com_android_internal_telephony_RIL$startLceService(int boolean android.os.Message ), this, n, bl, message);
    }

    @Override
    public void stopLceService(Message message) {
        InvokeDynamicSupport.bootstrap("stopLceService", $$robo$$com_android_internal_telephony_RIL$stopLceService(android.os.Message ), this, message);
    }

    @Override
    @Deprecated
    public void pullLceData(Message message) {
        InvokeDynamicSupport.bootstrap("pullLceData", $$robo$$com_android_internal_telephony_RIL$pullLceData(android.os.Message ), this, message);
    }

    @Override
    public void getModemActivityInfo(Message message) {
        InvokeDynamicSupport.bootstrap("getModemActivityInfo", $$robo$$com_android_internal_telephony_RIL$getModemActivityInfo(android.os.Message ), this, message);
    }

    @Override
    public void setAllowedCarriers(List<CarrierIdentifier> list, Message message) {
        InvokeDynamicSupport.bootstrap("setAllowedCarriers", $$robo$$com_android_internal_telephony_RIL$setAllowedCarriers(java.util.List<android.service.carrier.CarrierIdentifier> android.os.Message ), this, list, message);
    }

    @Override
    public void getAllowedCarriers(Message message) {
        InvokeDynamicSupport.bootstrap("getAllowedCarriers", $$robo$$com_android_internal_telephony_RIL$getAllowedCarriers(android.os.Message ), this, message);
    }

    @Override
    public void sendDeviceState(int n, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("sendDeviceState", $$robo$$com_android_internal_telephony_RIL$sendDeviceState(int boolean android.os.Message ), this, n, bl, message);
    }

    @Override
    public void setUnsolResponseFilter(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUnsolResponseFilter", $$robo$$com_android_internal_telephony_RIL$setUnsolResponseFilter(int android.os.Message ), this, n, message);
    }

    @Override
    public void setSignalStrengthReportingCriteria(int n, int n2, int[] nArray, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setSignalStrengthReportingCriteria", $$robo$$com_android_internal_telephony_RIL$setSignalStrengthReportingCriteria(int int int[] int android.os.Message ), this, n, n2, nArray, n3, message);
    }

    @Override
    public void setLinkCapacityReportingCriteria(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setLinkCapacityReportingCriteria", $$robo$$com_android_internal_telephony_RIL$setLinkCapacityReportingCriteria(int int int int[] int[] int android.os.Message ), this, n, n2, n3, nArray, nArray2, n4, message);
    }

    private static int convertRanToHalRan(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertRanToHalRan", $$robo$$com_android_internal_telephony_RIL$convertRanToHalRan(int ), (int)n);
    }

    @Override
    public void setSimCardPower(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setSimCardPower", $$robo$$com_android_internal_telephony_RIL$setSimCardPower(int android.os.Message ), this, n, message);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo imsiEncryptionInfo, Message message) {
        InvokeDynamicSupport.bootstrap("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_RIL$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo android.os.Message ), this, imsiEncryptionInfo, message);
    }

    @Override
    public void startNattKeepalive(int n, KeepalivePacketData keepalivePacketData, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("startNattKeepalive", $$robo$$com_android_internal_telephony_RIL$startNattKeepalive(int android.net.KeepalivePacketData int android.os.Message ), this, n, keepalivePacketData, n2, message);
    }

    @Override
    public void stopNattKeepalive(int n, Message message) {
        InvokeDynamicSupport.bootstrap("stopNattKeepalive", $$robo$$com_android_internal_telephony_RIL$stopNattKeepalive(int android.os.Message ), this, n, message);
    }

    @Override
    public void getIMEI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEI", $$robo$$com_android_internal_telephony_RIL$getIMEI(android.os.Message ), this, message);
    }

    @Override
    public void getIMEISV(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEISV", $$robo$$com_android_internal_telephony_RIL$getIMEISV(android.os.Message ), this, message);
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastPdpFailCause", $$robo$$com_android_internal_telephony_RIL$getLastPdpFailCause(android.os.Message ), this, message);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastDataCallFailCause", $$robo$$com_android_internal_telephony_RIL$getLastDataCallFailCause(android.os.Message ), this, message);
    }

    private int translateStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrap("translateStatus", $$robo$$com_android_internal_telephony_RIL$translateStatus(int ), this, n);
    }

    @Override
    public void resetRadio(Message message) {
        InvokeDynamicSupport.bootstrap("resetRadio", $$robo$$com_android_internal_telephony_RIL$resetRadio(android.os.Message ), this, message);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("handleCallSetupRequestFromSim", $$robo$$com_android_internal_telephony_RIL$handleCallSetupRequestFromSim(boolean android.os.Message ), this, bl, message);
    }

    void processIndication(int n) {
        InvokeDynamicSupport.bootstrap("processIndication", $$robo$$com_android_internal_telephony_RIL$processIndication(int ), this, n);
    }

    void processRequestAck(int n) {
        InvokeDynamicSupport.bootstrap("processRequestAck", $$robo$$com_android_internal_telephony_RIL$processRequestAck(int ), this, n);
    }

    public RILRequest processResponse(RadioResponseInfo radioResponseInfo) {
        return InvokeDynamicSupport.bootstrap("processResponse", $$robo$$com_android_internal_telephony_RIL$processResponse(android.hardware.radio.V1_0.RadioResponseInfo ), this, radioResponseInfo);
    }

    public void processResponseDone(RILRequest rILRequest, RadioResponseInfo radioResponseInfo, Object object) {
        InvokeDynamicSupport.bootstrap("processResponseDone", $$robo$$com_android_internal_telephony_RIL$processResponseDone(com.android.internal.telephony.RILRequest android.hardware.radio.V1_0.RadioResponseInfo java.lang.Object ), this, rILRequest, radioResponseInfo, object);
    }

    private void sendAck() {
        InvokeDynamicSupport.bootstrap("sendAck", $$robo$$com_android_internal_telephony_RIL$sendAck(), this);
    }

    private WorkSource getDeafultWorkSourceIfInvalid(WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("getDeafultWorkSourceIfInvalid", $$robo$$com_android_internal_telephony_RIL$getDeafultWorkSourceIfInvalid(android.os.WorkSource ), this, workSource);
    }

    private void acquireWakeLock(RILRequest rILRequest, int n) {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_RIL$acquireWakeLock(com.android.internal.telephony.RILRequest int ), this, rILRequest, n);
    }

    public PowerManager.WakeLock getWakeLock(int n) {
        return InvokeDynamicSupport.bootstrap("getWakeLock", $$robo$$com_android_internal_telephony_RIL$getWakeLock(int ), this, n);
    }

    public RilHandler getRilHandler() {
        return InvokeDynamicSupport.bootstrap("getRilHandler", $$robo$$com_android_internal_telephony_RIL$getRilHandler(), this);
    }

    public SparseArray<RILRequest> getRilRequestList() {
        return InvokeDynamicSupport.bootstrap("getRilRequestList", $$robo$$com_android_internal_telephony_RIL$getRilRequestList(), this);
    }

    private void decrementWakeLock(RILRequest rILRequest) {
        InvokeDynamicSupport.bootstrap("decrementWakeLock", $$robo$$com_android_internal_telephony_RIL$decrementWakeLock(com.android.internal.telephony.RILRequest ), this, rILRequest);
    }

    private boolean clearWakeLock(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearWakeLock", $$robo$$com_android_internal_telephony_RIL$clearWakeLock(int ), this, n);
    }

    private void clearRequestList(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("clearRequestList", $$robo$$com_android_internal_telephony_RIL$clearRequestList(int boolean ), this, n, bl);
    }

    private RILRequest findAndRemoveRequestFromList(int n) {
        return InvokeDynamicSupport.bootstrap("findAndRemoveRequestFromList", $$robo$$com_android_internal_telephony_RIL$findAndRemoveRequestFromList(int ), this, n);
    }

    private void addToRilHistogram(RILRequest rILRequest) {
        InvokeDynamicSupport.bootstrap("addToRilHistogram", $$robo$$com_android_internal_telephony_RIL$addToRilHistogram(com.android.internal.telephony.RILRequest ), this, rILRequest);
    }

    RadioCapability makeStaticRadioCapability() {
        return InvokeDynamicSupport.bootstrap("makeStaticRadioCapability", $$robo$$com_android_internal_telephony_RIL$makeStaticRadioCapability(), this);
    }

    static String retToString(int n, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("retToString", $$robo$$com_android_internal_telephony_RIL$retToString(int java.lang.Object ), (int)n, (Object)object);
    }

    void writeMetricsNewSms(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeMetricsNewSms", $$robo$$com_android_internal_telephony_RIL$writeMetricsNewSms(int int ), this, n, n2);
    }

    void writeMetricsCallRing(char[] cArray) {
        InvokeDynamicSupport.bootstrap("writeMetricsCallRing", $$robo$$com_android_internal_telephony_RIL$writeMetricsCallRing(char[] ), this, cArray);
    }

    void writeMetricsSrvcc(int n) {
        InvokeDynamicSupport.bootstrap("writeMetricsSrvcc", $$robo$$com_android_internal_telephony_RIL$writeMetricsSrvcc(int ), this, n);
    }

    void writeMetricsModemRestartEvent(String string2) {
        InvokeDynamicSupport.bootstrap("writeMetricsModemRestartEvent", $$robo$$com_android_internal_telephony_RIL$writeMetricsModemRestartEvent(java.lang.String ), this, string2);
    }

    void notifyRegistrantsRilConnectionChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyRegistrantsRilConnectionChanged", $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsRilConnectionChanged(int ), this, n);
    }

    void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords cdmaInformationRecords) {
        InvokeDynamicSupport.bootstrap("notifyRegistrantsCdmaInfoRec", $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsCdmaInfoRec(com.android.internal.telephony.cdma.CdmaInformationRecords ), this, cdmaInformationRecords);
    }

    static String requestToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("requestToString", $$robo$$com_android_internal_telephony_RIL$requestToString(int ), (int)n);
    }

    static String responseToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("responseToString", $$robo$$com_android_internal_telephony_RIL$responseToString(int ), (int)n);
    }

    void riljLog(String string2) {
        InvokeDynamicSupport.bootstrap("riljLog", $$robo$$com_android_internal_telephony_RIL$riljLog(java.lang.String ), this, string2);
    }

    void riljLoge(String string2) {
        InvokeDynamicSupport.bootstrap("riljLoge", $$robo$$com_android_internal_telephony_RIL$riljLoge(java.lang.String ), this, string2);
    }

    void riljLoge(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("riljLoge", $$robo$$com_android_internal_telephony_RIL$riljLoge(java.lang.String java.lang.Exception ), this, string2, exception);
    }

    void riljLogv(String string2) {
        InvokeDynamicSupport.bootstrap("riljLogv", $$robo$$com_android_internal_telephony_RIL$riljLogv(java.lang.String ), this, string2);
    }

    void unsljLog(int n) {
        InvokeDynamicSupport.bootstrap("unsljLog", $$robo$$com_android_internal_telephony_RIL$unsljLog(int ), this, n);
    }

    void unsljLogMore(int n, String string2) {
        InvokeDynamicSupport.bootstrap("unsljLogMore", $$robo$$com_android_internal_telephony_RIL$unsljLogMore(int java.lang.String ), this, n, string2);
    }

    void unsljLogRet(int n, Object object) {
        InvokeDynamicSupport.bootstrap("unsljLogRet", $$robo$$com_android_internal_telephony_RIL$unsljLogRet(int java.lang.Object ), this, n, object);
    }

    void unsljLogvRet(int n, Object object) {
        InvokeDynamicSupport.bootstrap("unsljLogvRet", $$robo$$com_android_internal_telephony_RIL$unsljLogvRet(int java.lang.Object ), this, n, object);
    }

    @Override
    public void setPhoneType(int n) {
        InvokeDynamicSupport.bootstrap("setPhoneType", $$robo$$com_android_internal_telephony_RIL$setPhoneType(int ), this, n);
    }

    @Override
    public void testingEmergencyCall() {
        InvokeDynamicSupport.bootstrap("testingEmergencyCall", $$robo$$com_android_internal_telephony_RIL$testingEmergencyCall(), this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_RIL$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public List<ClientRequestStats> getClientRequestStats() {
        return InvokeDynamicSupport.bootstrap("getClientRequestStats", $$robo$$com_android_internal_telephony_RIL$getClientRequestStats(), this);
    }

    public static void appendPrimitiveArrayToArrayList(byte[] byArray, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("appendPrimitiveArrayToArrayList", $$robo$$com_android_internal_telephony_RIL$appendPrimitiveArrayToArrayList(byte[] java.util.ArrayList<java.lang.Byte> ), (byte[])byArray, arrayList);
    }

    public static ArrayList<Byte> primitiveArrayToArrayList(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("primitiveArrayToArrayList", $$robo$$com_android_internal_telephony_RIL$primitiveArrayToArrayList(byte[] ), (byte[])byArray);
    }

    public static ArrayList<Integer> primitiveArrayToArrayList(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("primitiveArrayToArrayList", $$robo$$com_android_internal_telephony_RIL$primitiveArrayToArrayList(int[] ), (int[])nArray);
    }

    public static byte[] arrayListToPrimitiveArray(ArrayList<Byte> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("arrayListToPrimitiveArray", $$robo$$com_android_internal_telephony_RIL$arrayListToPrimitiveArray(java.util.ArrayList<java.lang.Byte> ), arrayList);
    }

    static ArrayList<HardwareConfig> convertHalHwConfigList(ArrayList<android.hardware.radio.V1_0.HardwareConfig> arrayList, RIL rIL) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalHwConfigList", $$robo$$com_android_internal_telephony_RIL$convertHalHwConfigList(java.util.ArrayList<android.hardware.radio.V1_0.HardwareConfig> com.android.internal.telephony.RIL ), arrayList, (RIL)rIL);
    }

    static RadioCapability convertHalRadioCapability(android.hardware.radio.V1_0.RadioCapability radioCapability, RIL rIL) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalRadioCapability", $$robo$$com_android_internal_telephony_RIL$convertHalRadioCapability(android.hardware.radio.V1_0.RadioCapability com.android.internal.telephony.RIL ), (android.hardware.radio.V1_0.RadioCapability)radioCapability, (RIL)rIL);
    }

    static LinkCapacityEstimate convertHalLceData(LceDataInfo lceDataInfo, RIL rIL) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalLceData", $$robo$$com_android_internal_telephony_RIL$convertHalLceData(android.hardware.radio.V1_0.LceDataInfo com.android.internal.telephony.RIL ), (LceDataInfo)lceDataInfo, (RIL)rIL);
    }

    static LinkCapacityEstimate convertHalLceData(android.hardware.radio.V1_2.LinkCapacityEstimate linkCapacityEstimate, RIL rIL) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalLceData", $$robo$$com_android_internal_telephony_RIL$convertHalLceData(android.hardware.radio.V1_2.LinkCapacityEstimate com.android.internal.telephony.RIL ), (android.hardware.radio.V1_2.LinkCapacityEstimate)linkCapacityEstimate, (RIL)rIL);
    }

    private static void writeToParcelForGsm(Parcel parcel, int n, int n2, int n3, int n4, String string2, String string3, String string4, String string5, int n5, int n6, int n7) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcelForGsm", $$robo$$com_android_internal_telephony_RIL$writeToParcelForGsm(android.os.Parcel int int int int java.lang.String java.lang.String java.lang.String java.lang.String int int int ), (Parcel)parcel, (int)n, (int)n2, (int)n3, (int)n4, (String)string2, (String)string3, (String)string4, (String)string5, (int)n5, (int)n6, (int)n7);
    }

    private static void writeToParcelForCdma(Parcel parcel, int n, int n2, int n3, int n4, int n5, String string2, String string3, int n6, int n7, int n8, int n9, int n10) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcelForCdma", $$robo$$com_android_internal_telephony_RIL$writeToParcelForCdma(android.os.Parcel int int int int int java.lang.String java.lang.String int int int int int ), (Parcel)parcel, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (String)string2, (String)string3, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10);
    }

    private static void writeToParcelForLte(Parcel parcel, int n, int n2, int n3, int n4, int n5, String string2, String string3, String string4, String string5, int n6, int n7, int n8, int n9, int n10, int n11) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcelForLte", $$robo$$com_android_internal_telephony_RIL$writeToParcelForLte(android.os.Parcel int int int int int java.lang.String java.lang.String java.lang.String java.lang.String int int int int int int ), (Parcel)parcel, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (String)string2, (String)string3, (String)string4, (String)string5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)n11);
    }

    private static void writeToParcelForWcdma(Parcel parcel, int n, int n2, int n3, int n4, String string2, String string3, String string4, String string5, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcelForWcdma", $$robo$$com_android_internal_telephony_RIL$writeToParcelForWcdma(android.os.Parcel int int int int java.lang.String java.lang.String java.lang.String java.lang.String int int ), (Parcel)parcel, (int)n, (int)n2, (int)n3, (int)n4, (String)string2, (String)string3, (String)string4, (String)string5, (int)n5, (int)n6);
    }

    public static ArrayList<android.telephony.CellInfo> convertHalCellInfoList(ArrayList<CellInfo> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalCellInfoList", $$robo$$com_android_internal_telephony_RIL$convertHalCellInfoList(java.util.ArrayList<android.hardware.radio.V1_0.CellInfo> ), arrayList);
    }

    public static ArrayList<android.telephony.CellInfo> convertHalCellInfoList_1_2(ArrayList<android.hardware.radio.V1_2.CellInfo> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalCellInfoList_1_2", $$robo$$com_android_internal_telephony_RIL$convertHalCellInfoList_1_2(java.util.ArrayList<android.hardware.radio.V1_2.CellInfo> ), arrayList);
    }

    public static SignalStrength convertHalSignalStrength(android.hardware.radio.V1_0.SignalStrength signalStrength) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalSignalStrength", $$robo$$com_android_internal_telephony_RIL$convertHalSignalStrength(android.hardware.radio.V1_0.SignalStrength ), (android.hardware.radio.V1_0.SignalStrength)signalStrength);
    }

    public static SignalStrength convertHalSignalStrength_1_2(android.hardware.radio.V1_2.SignalStrength signalStrength) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalSignalStrength_1_2", $$robo$$com_android_internal_telephony_RIL$convertHalSignalStrength_1_2(android.hardware.radio.V1_2.SignalStrength ), (android.hardware.radio.V1_2.SignalStrength)signalStrength);
    }

    static {
        RobolectricInternals.classInitializing(RIL.class);
    }

    public /* synthetic */ RIL() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RIL)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class RadioProxyDeathRecipient
    implements IHwBinder.DeathRecipient,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RIL this$0;

        private void $$robo$$com_android_internal_telephony_RIL_RadioProxyDeathRecipient$__constructor__(RIL this$0) {
            this.this$0 = this$0;
        }

        private final void $$robo$$com_android_internal_telephony_RIL_RadioProxyDeathRecipient$serviceDied(long cookie) {
            this.this$0.riljLog("serviceDied");
            this.this$0.mRilHandler.sendMessage(this.this$0.mRilHandler.obtainMessage(6, cookie));
        }

        private void __constructor__(RIL rIL) {
            this.$$robo$$com_android_internal_telephony_RIL_RadioProxyDeathRecipient$__constructor__(rIL);
        }

        public RadioProxyDeathRecipient(RIL rIL) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_RadioProxyDeathRecipient$__constructor__(com.android.internal.telephony.RIL ), this, rIL);
        }

        @Override
        public void serviceDied(long l) {
            InvokeDynamicSupport.bootstrap("serviceDied", $$robo$$com_android_internal_telephony_RIL_RadioProxyDeathRecipient$serviceDied(long ), this, l);
        }

        public /* synthetic */ RadioProxyDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioProxyDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public class RilHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RIL this$0;

        private void $$robo$$com_android_internal_telephony_RIL_RilHandler$__constructor__(RIL this$0) {
            this.this$0 = this$0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_RIL_RilHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    SparseArray<RILRequest> sparseArray = this.this$0.mRequestList;
                    synchronized (sparseArray) {
                        if (msg.arg1 == this.this$0.mWlSequenceNum && this.this$0.clearWakeLock(0)) {
                            int count = this.this$0.mRequestList.size();
                            Rlog.d("RILJ", "WAKE_LOCK_TIMEOUT  mRequestList=" + count);
                            for (int i = 0; i < count; ++i) {
                                RILRequest rr = this.this$0.mRequestList.valueAt(i);
                                Rlog.d("RILJ", i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    if (msg.arg1 != this.this$0.mAckWlSequenceNum || !this.this$0.clearWakeLock(1)) break;
                    break;
                }
                case 5: {
                    int serial = msg.arg1;
                    RILRequest rr = this.this$0.findAndRemoveRequestFromList(serial);
                    if (rr == null) break;
                    if (rr.mResult != null) {
                        Object timeoutResponse = RIL.getResponseForTimedOutRILRequest(rr);
                        AsyncResult.forMessage(rr.mResult, timeoutResponse, null);
                        rr.mResult.sendToTarget();
                        this.this$0.mMetrics.writeOnRilTimeoutResponse(this.this$0.mPhoneId, rr.mSerial, rr.mRequest);
                    }
                    this.this$0.decrementWakeLock(rr);
                    rr.release();
                    break;
                }
                case 6: {
                    this.this$0.riljLog("handleMessage: EVENT_RADIO_PROXY_DEAD cookie = " + msg.obj + " mRadioProxyCookie = " + this.this$0.mRadioProxyCookie.get());
                    if (((Long)msg.obj).longValue() != this.this$0.mRadioProxyCookie.get()) break;
                    this.this$0.resetProxyAndRequestList();
                }
            }
        }

        private void __constructor__(RIL rIL) {
            this.$$robo$$com_android_internal_telephony_RIL_RilHandler$__constructor__(rIL);
        }

        public RilHandler(RIL rIL) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_RilHandler$__constructor__(com.android.internal.telephony.RIL ), this, rIL);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_RIL_RilHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ RilHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RilHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

