/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.os.WorkSource;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RIL;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RILRequest
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "RilRequest";
    static Random sRandom;
    static AtomicInteger sNextSerial;
    private static Object sPoolSync;
    private static RILRequest sPool;
    private static int sPoolSize;
    private static int MAX_POOL_SIZE = 4;
    int mSerial;
    int mRequest;
    Message mResult;
    RILRequest mNext;
    int mWakeLockType;
    WorkSource mWorkSource;
    String mClientId;
    long mStartTimeMs;

    private final int $$robo$$com_android_internal_telephony_RILRequest$getSerial() {
        return this.mSerial;
    }

    private final int $$robo$$com_android_internal_telephony_RILRequest$getRequest() {
        return this.mRequest;
    }

    private final Message $$robo$$com_android_internal_telephony_RILRequest$getResult() {
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RILRequest $$robo$$com_android_internal_telephony_RILRequest$obtain(int request, Message result) {
        RILRequest rr = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                rr = sPool;
                sPool = rr.mNext;
                rr.mNext = null;
                --sPoolSize;
            }
        }
        if (rr == null) {
            rr = new RILRequest();
        }
        rr.mSerial = sNextSerial.getAndIncrement();
        rr.mRequest = request;
        rr.mResult = result;
        rr.mWakeLockType = -1;
        rr.mWorkSource = null;
        rr.mStartTimeMs = SystemClock.elapsedRealtime();
        if (result != null && result.getTarget() == null) {
            throw new NullPointerException("Message target must not be null");
        }
        return rr;
    }

    private static final RILRequest $$robo$$com_android_internal_telephony_RILRequest$obtain(int request, Message result, WorkSource workSource) {
        RILRequest rr = null;
        rr = RILRequest.obtain(request, result);
        if (workSource != null) {
            rr.mWorkSource = workSource;
            rr.mClientId = rr.getWorkSourceClientId();
        } else {
            Rlog.e("RilRequest", "null workSource " + request);
        }
        return rr;
    }

    private final String $$robo$$com_android_internal_telephony_RILRequest$getWorkSourceClientId() {
        if (this.mWorkSource == null || this.mWorkSource.isEmpty()) {
            return null;
        }
        if (this.mWorkSource.size() > 0) {
            return this.mWorkSource.get(0) + ":" + this.mWorkSource.getName(0);
        }
        ArrayList<WorkSource.WorkChain> workChains = this.mWorkSource.getWorkChains();
        if (workChains != null && !workChains.isEmpty()) {
            WorkSource.WorkChain workChain = workChains.get(0);
            return workChain.getAttributionUid() + ":" + workChain.getTags()[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RILRequest$release() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 4) {
                this.mNext = sPool;
                sPool = this;
                ++sPoolSize;
                this.mResult = null;
                if (this.mWakeLockType != -1 && this.mWakeLockType == 0) {
                    Rlog.e("RilRequest", "RILRequest releasing with held wake lock: " + this.serialString());
                }
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_RILRequest$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_RILRequest$resetSerial() {
        sNextSerial.set(sRandom.nextInt());
    }

    private final String $$robo$$com_android_internal_telephony_RILRequest$serialString() {
        StringBuilder sb = new StringBuilder(8);
        long adjustedSerial = ((long)this.mSerial - Integer.MIN_VALUE) % 10000L;
        String sn = Long.toString(adjustedSerial);
        sb.append('[');
        int s = sn.length();
        for (int i = 0; i < 4 - s; ++i) {
            sb.append('0');
        }
        sb.append(sn);
        sb.append(']');
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_telephony_RILRequest$onError(int error, Object ret) {
        CommandException ex = CommandException.fromRilErrno(error);
        Rlog.d("RilRequest", this.serialString() + "< " + RIL.requestToString(this.mRequest) + " error: " + ex + " ret=" + RIL.retToString(this.mRequest, ret));
        if (this.mResult != null) {
            AsyncResult.forMessage(this.mResult, ret, ex);
            this.mResult.sendToTarget();
        }
    }

    static void __staticInitializer__() {
        sRandom = new Random();
        sNextSerial = new AtomicInteger(0);
        sPoolSync = new Object();
        sPool = null;
        sPoolSize = 0;
    }

    public int getSerial() {
        return (int)InvokeDynamicSupport.bootstrap("getSerial", $$robo$$com_android_internal_telephony_RILRequest$getSerial(), this);
    }

    public int getRequest() {
        return (int)InvokeDynamicSupport.bootstrap("getRequest", $$robo$$com_android_internal_telephony_RILRequest$getRequest(), this);
    }

    public Message getResult() {
        return InvokeDynamicSupport.bootstrap("getResult", $$robo$$com_android_internal_telephony_RILRequest$getResult(), this);
    }

    private static RILRequest obtain(int n, Message message) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$com_android_internal_telephony_RILRequest$obtain(int android.os.Message ), (int)n, (Message)message);
    }

    public static RILRequest obtain(int n, Message message, WorkSource workSource) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$com_android_internal_telephony_RILRequest$obtain(int android.os.Message android.os.WorkSource ), (int)n, (Message)message, (WorkSource)workSource);
    }

    public String getWorkSourceClientId() {
        return InvokeDynamicSupport.bootstrap("getWorkSourceClientId", $$robo$$com_android_internal_telephony_RILRequest$getWorkSourceClientId(), this);
    }

    void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$com_android_internal_telephony_RILRequest$release(), this);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_RILRequest$__constructor__();
    }

    public RILRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RILRequest$__constructor__(), this);
    }

    static void resetSerial() {
        InvokeDynamicSupport.bootstrapStatic("resetSerial", $$robo$$com_android_internal_telephony_RILRequest$resetSerial());
    }

    String serialString() {
        return InvokeDynamicSupport.bootstrap("serialString", $$robo$$com_android_internal_telephony_RILRequest$serialString(), this);
    }

    void onError(int n, Object object) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$com_android_internal_telephony_RILRequest$onError(int java.lang.Object ), this, n, object);
    }

    static {
        RobolectricInternals.classInitializing(RILRequest.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RILRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

