/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.CdmaCallWaiting;
import android.hardware.radio.V1_0.CdmaInformationRecord;
import android.hardware.radio.V1_0.CdmaLineControlInfoRecord;
import android.hardware.radio.V1_0.CdmaNumberInfoRecord;
import android.hardware.radio.V1_0.CdmaRedirectingNumberInfoRecord;
import android.hardware.radio.V1_0.CdmaSignalInfoRecord;
import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.CdmaT53AudioControlInfoRecord;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.CfData;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.PcoDataInfo;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.SimRefreshResult;
import android.hardware.radio.V1_0.SsInfoData;
import android.hardware.radio.V1_0.StkCcUnsolSsResult;
import android.hardware.radio.V1_0.SuppSvcNotification;
import android.hardware.radio.V1_2.IRadioIndication;
import android.os.AsyncResult;
import android.os.SystemProperties;
import android.telephony.PcoData;
import android.telephony.PhysicalChannelConfig;
import android.telephony.SignalStrength;
import android.telephony.SmsMessage;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.LinkCapacityEstimate;
import com.android.internal.telephony.NetworkScanResult;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.SmsMessageConverter;
import com.android.internal.telephony.dataconnection.KeepaliveStatus;
import com.android.internal.telephony.gsm.SsData;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadioIndication
extends IRadioIndication.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    RIL mRil;

    private void $$robo$$com_android_internal_telephony_RadioIndication$__constructor__(RIL ril) {
        this.mRil = ril;
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$radioStateChanged(int indicationType, int radioState) {
        this.mRil.processIndication(indicationType);
        CommandsInterface.RadioState newState = this.getRadioStateFromInt(radioState);
        this.mRil.unsljLogMore(1000, "radioStateChanged: " + (Object)((Object)newState));
        this.mRil.setRadioState(newState);
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$callStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1001);
        this.mRil.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$networkStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1002);
        this.mRil.mNetworkStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$newSms(int indicationType, ArrayList<Byte> pdu) {
        this.mRil.processIndication(indicationType);
        byte[] pduArray = RIL.arrayListToPrimitiveArray(pdu);
        this.mRil.unsljLog(1003);
        this.mRil.writeMetricsNewSms(1, 1);
        SmsMessage sms = SmsMessage.newFromCMT(pduArray);
        if (this.mRil.mGsmSmsRegistrant != null) {
            this.mRil.mGsmSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$newSmsStatusReport(int indicationType, ArrayList<Byte> pdu) {
        this.mRil.processIndication(indicationType);
        byte[] pduArray = RIL.arrayListToPrimitiveArray(pdu);
        this.mRil.unsljLog(1004);
        if (this.mRil.mSmsStatusRegistrant != null) {
            this.mRil.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, pduArray, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$newSmsOnSim(int indicationType, int recordNumber) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1005);
        if (this.mRil.mSmsOnSimRegistrant != null) {
            this.mRil.mSmsOnSimRegistrant.notifyRegistrant(new AsyncResult(null, recordNumber, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$onUssd(int indicationType, int ussdModeType, String msg) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogMore(1006, "" + ussdModeType);
        String[] resp = new String[]{"" + ussdModeType, msg};
        if (this.mRil.mUSSDRegistrant != null) {
            this.mRil.mUSSDRegistrant.notifyRegistrant(new AsyncResult(null, resp, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$nitzTimeReceived(int indicationType, String nitzTime, long receivedTime) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1008, nitzTime);
        Object[] result = new Object[]{nitzTime, receivedTime};
        boolean ignoreNitz = SystemProperties.getBoolean("telephony.test.ignore.nitz", false);
        if (ignoreNitz) {
            this.mRil.riljLog("ignoring UNSOL_NITZ_TIME_RECEIVED");
        } else {
            if (this.mRil.mNITZTimeRegistrant != null) {
                this.mRil.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
            }
            this.mRil.mLastNITZTimeInfo = result;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$currentSignalStrength(int indicationType, android.hardware.radio.V1_0.SignalStrength signalStrength) {
        this.mRil.processIndication(indicationType);
        SignalStrength ss = RIL.convertHalSignalStrength(signalStrength);
        if (this.mRil.mSignalStrengthRegistrant != null) {
            this.mRil.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, ss, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$currentLinkCapacityEstimate(int indicationType, android.hardware.radio.V1_2.LinkCapacityEstimate lce) {
        this.mRil.processIndication(indicationType);
        LinkCapacityEstimate response = RIL.convertHalLceData(lce, this.mRil);
        this.mRil.unsljLogRet(1045, response);
        if (this.mRil.mLceInfoRegistrants != null) {
            this.mRil.mLceInfoRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$currentSignalStrength_1_2(int indicationType, android.hardware.radio.V1_2.SignalStrength signalStrength) {
        this.mRil.processIndication(indicationType);
        SignalStrength ss = RIL.convertHalSignalStrength_1_2(signalStrength);
        if (this.mRil.mSignalStrengthRegistrant != null) {
            this.mRil.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, ss, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$currentPhysicalChannelConfigs(int indicationType, ArrayList<android.hardware.radio.V1_2.PhysicalChannelConfig> configs) {
        ArrayList<PhysicalChannelConfig> response = new ArrayList<PhysicalChannelConfig>(configs.size());
        for (android.hardware.radio.V1_2.PhysicalChannelConfig config : configs) {
            int status;
            switch (config.status) {
                case 1: {
                    status = 1;
                    break;
                }
                case 2: {
                    status = 2;
                    break;
                }
                default: {
                    this.mRil.riljLoge("Unsupported CellConnectionStatus in PhysicalChannelConfig: " + config.status);
                    status = Integer.MAX_VALUE;
                }
            }
            response.add(new PhysicalChannelConfig(status, config.cellBandwidthDownlink));
        }
        this.mRil.unsljLogRet(1052, response);
        this.mRil.mPhysicalChannelConfigurationRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$dataCallListChanged(int indicationType, ArrayList<SetupDataCallResult> dcList) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1010, dcList);
        this.mRil.mDataCallListChangedRegistrants.notifyRegistrants(new AsyncResult(null, dcList, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$suppSvcNotify(int indicationType, SuppSvcNotification suppSvcNotification) {
        this.mRil.processIndication(indicationType);
        SuppServiceNotification notification = new SuppServiceNotification();
        notification.notificationType = suppSvcNotification.isMT ? 1 : 0;
        notification.code = suppSvcNotification.code;
        notification.index = suppSvcNotification.index;
        notification.type = suppSvcNotification.type;
        notification.number = suppSvcNotification.number;
        this.mRil.unsljLogRet(1011, notification);
        if (this.mRil.mSsnRegistrant != null) {
            this.mRil.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, notification, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$stkSessionEnd(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1012);
        if (this.mRil.mCatSessionEndRegistrant != null) {
            this.mRil.mCatSessionEndRegistrant.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$stkProactiveCommand(int indicationType, String cmd) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1013);
        if (this.mRil.mCatProCmdRegistrant != null) {
            this.mRil.mCatProCmdRegistrant.notifyRegistrant(new AsyncResult(null, cmd, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$stkEventNotify(int indicationType, String cmd) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1014);
        if (this.mRil.mCatEventRegistrant != null) {
            this.mRil.mCatEventRegistrant.notifyRegistrant(new AsyncResult(null, cmd, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$stkCallSetup(int indicationType, long timeout) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1015, timeout);
        if (this.mRil.mCatCallSetUpRegistrant != null) {
            this.mRil.mCatCallSetUpRegistrant.notifyRegistrant(new AsyncResult(null, timeout, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$simSmsStorageFull(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1016);
        if (this.mRil.mIccSmsFullRegistrant != null) {
            this.mRil.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$simRefresh(int indicationType, SimRefreshResult refreshResult) {
        this.mRil.processIndication(indicationType);
        IccRefreshResponse response = new IccRefreshResponse();
        response.refreshResult = refreshResult.type;
        response.efId = refreshResult.efId;
        response.aid = refreshResult.aid;
        this.mRil.unsljLogRet(1017, response);
        this.mRil.mIccRefreshRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$callRing(int indicationType, boolean isGsm, CdmaSignalInfoRecord record) {
        this.mRil.processIndication(indicationType);
        char[] response = null;
        if (!isGsm) {
            response = new char[]{(char)(record.isPresent ? 1 : 0), (char)record.signalType, (char)record.alertPitch, (char)record.signal};
            this.mRil.writeMetricsCallRing(response);
        }
        this.mRil.unsljLogRet(1018, response);
        if (this.mRil.mRingRegistrant != null) {
            this.mRil.mRingRegistrant.notifyRegistrant(new AsyncResult(null, response, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$simStatusChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1019);
        this.mRil.mIccStatusChangedRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaNewSms(int indicationType, CdmaSmsMessage msg) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1020);
        this.mRil.writeMetricsNewSms(2, 2);
        SmsMessage sms = SmsMessageConverter.newSmsMessageFromCdmaSmsMessage(msg);
        if (this.mRil.mCdmaSmsRegistrant != null) {
            this.mRil.mCdmaSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$newBroadcastSms(int indicationType, ArrayList<Byte> data) {
        this.mRil.processIndication(indicationType);
        byte[] response = RIL.arrayListToPrimitiveArray(data);
        this.mRil.unsljLogvRet(1021, IccUtils.bytesToHexString(response));
        if (this.mRil.mGsmBroadcastSmsRegistrant != null) {
            this.mRil.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, response, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaRuimSmsStorageFull(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1022);
        if (this.mRil.mIccSmsFullRegistrant != null) {
            this.mRil.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$restrictedStateChanged(int indicationType, int state) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogvRet(1023, state);
        if (this.mRil.mRestrictedStateRegistrant != null) {
            this.mRil.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, state, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$enterEmergencyCallbackMode(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1024);
        if (this.mRil.mEmergencyCallbackModeRegistrant != null) {
            this.mRil.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaCallWaiting(int indicationType, CdmaCallWaiting callWaitingRecord) {
        this.mRil.processIndication(indicationType);
        CdmaCallWaitingNotification notification = new CdmaCallWaitingNotification();
        notification.number = callWaitingRecord.number;
        notification.numberPresentation = CdmaCallWaitingNotification.presentationFromCLIP(callWaitingRecord.numberPresentation);
        notification.name = callWaitingRecord.name;
        notification.namePresentation = notification.numberPresentation;
        notification.isPresent = callWaitingRecord.signalInfoRecord.isPresent ? 1 : 0;
        notification.signalType = callWaitingRecord.signalInfoRecord.signalType;
        notification.alertPitch = callWaitingRecord.signalInfoRecord.alertPitch;
        notification.signal = callWaitingRecord.signalInfoRecord.signal;
        notification.numberType = callWaitingRecord.numberType;
        notification.numberPlan = callWaitingRecord.numberPlan;
        this.mRil.unsljLogRet(1025, notification);
        this.mRil.mCallWaitingInfoRegistrants.notifyRegistrants(new AsyncResult(null, notification, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaOtaProvisionStatus(int indicationType, int status) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{status};
        this.mRil.unsljLogRet(1026, response);
        this.mRil.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaInfoRec(int indicationType, android.hardware.radio.V1_0.CdmaInformationRecords records) {
        this.mRil.processIndication(indicationType);
        int numberOfInfoRecs = records.infoRec.size();
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CdmaInformationRecords cdmaInformationRecords;
            CdmaInformationRecord record = records.infoRec.get(i);
            int id2 = record.name;
            switch (id2) {
                case 0: 
                case 7: {
                    CdmaInformationRecords.CdmaDisplayInfoRec cdmaDisplayInfoRec = new CdmaInformationRecords.CdmaDisplayInfoRec(id2, record.display.get((int)0).alphaBuf);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaDisplayInfoRec);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    CdmaNumberInfoRecord numInfoRecord = record.number.get(0);
                    CdmaInformationRecords.CdmaNumberInfoRec cdmaNumberInfoRec = new CdmaInformationRecords.CdmaNumberInfoRec(id2, numInfoRecord.number, numInfoRecord.numberType, numInfoRecord.numberPlan, numInfoRecord.pi, numInfoRecord.si);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaNumberInfoRec);
                    break;
                }
                case 4: {
                    CdmaSignalInfoRecord signalInfoRecord = record.signal.get(0);
                    CdmaInformationRecords.CdmaSignalInfoRec cdmaSignalInfoRec = new CdmaInformationRecords.CdmaSignalInfoRec(signalInfoRecord.isPresent ? 1 : 0, signalInfoRecord.signalType, signalInfoRecord.alertPitch, signalInfoRecord.signal);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaSignalInfoRec);
                    break;
                }
                case 5: {
                    CdmaRedirectingNumberInfoRecord redirectingNumberInfoRecord = record.redir.get(0);
                    CdmaInformationRecords.CdmaRedirectingNumberInfoRec cdmaRedirectingNumberInfoRec = new CdmaInformationRecords.CdmaRedirectingNumberInfoRec(redirectingNumberInfoRecord.redirectingNumber.number, redirectingNumberInfoRecord.redirectingNumber.numberType, redirectingNumberInfoRecord.redirectingNumber.numberPlan, redirectingNumberInfoRecord.redirectingNumber.pi, redirectingNumberInfoRecord.redirectingNumber.si, redirectingNumberInfoRecord.redirectingReason);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaRedirectingNumberInfoRec);
                    break;
                }
                case 6: {
                    CdmaLineControlInfoRecord lineControlInfoRecord = record.lineCtrl.get(0);
                    CdmaInformationRecords.CdmaLineControlInfoRec cdmaLineControlInfoRec = new CdmaInformationRecords.CdmaLineControlInfoRec(lineControlInfoRecord.lineCtrlPolarityIncluded, lineControlInfoRecord.lineCtrlToggle, lineControlInfoRecord.lineCtrlReverse, lineControlInfoRecord.lineCtrlPowerDenial);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaLineControlInfoRec);
                    break;
                }
                case 8: {
                    CdmaInformationRecords.CdmaT53ClirInfoRec cdmaT53ClirInfoRec = new CdmaInformationRecords.CdmaT53ClirInfoRec(record.clir.get((int)0).cause);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaT53ClirInfoRec);
                    break;
                }
                case 10: {
                    CdmaT53AudioControlInfoRecord audioControlInfoRecord = record.audioCtrl.get(0);
                    CdmaInformationRecords.CdmaT53AudioControlInfoRec cdmaT53AudioControlInfoRec = new CdmaInformationRecords.CdmaT53AudioControlInfoRec(audioControlInfoRecord.upLink, audioControlInfoRecord.downLink);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaT53AudioControlInfoRec);
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_UNSOL_CDMA_INFO_REC: unsupported record. Got " + CdmaInformationRecords.idToString(id2) + " ");
                }
            }
            this.mRil.unsljLogRet(1027, cdmaInformationRecords);
            this.mRil.notifyRegistrantsCdmaInfoRec(cdmaInformationRecords);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$indicateRingbackTone(int indicationType, boolean start) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogvRet(1029, start);
        this.mRil.mRingbackToneRegistrants.notifyRegistrants(new AsyncResult(null, start, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$resendIncallMute(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1030);
        this.mRil.mResendIncallMuteRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaSubscriptionSourceChanged(int indicationType, int cdmaSource) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{cdmaSource};
        this.mRil.unsljLogRet(1031, response);
        this.mRil.mCdmaSubscriptionChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cdmaPrlChanged(int indicationType, int version) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{version};
        this.mRil.unsljLogRet(1032, response);
        this.mRil.mCdmaPrlChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$exitEmergencyCallbackMode(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1033);
        this.mRil.mExitEmergencyCallbackModeRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$rilConnected(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1034);
        this.mRil.setRadioPower(false, null);
        this.mRil.setCdmaSubscriptionSource(this.mRil.mCdmaSubscription, null);
        this.mRil.setCellInfoListRate();
        this.mRil.notifyRegistrantsRilConnectionChanged(15);
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$voiceRadioTechChanged(int indicationType, int rat) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{rat};
        this.mRil.unsljLogRet(1035, response);
        this.mRil.mVoiceRadioTechChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cellInfoList(int indicationType, ArrayList<CellInfo> records) {
        this.mRil.processIndication(indicationType);
        ArrayList<android.telephony.CellInfo> response = RIL.convertHalCellInfoList(records);
        this.mRil.unsljLogRet(1036, response);
        this.mRil.mRilCellInfoListRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$cellInfoList_1_2(int indicationType, ArrayList<android.hardware.radio.V1_2.CellInfo> records) {
        this.mRil.processIndication(indicationType);
        ArrayList<android.telephony.CellInfo> response = RIL.convertHalCellInfoList_1_2(records);
        this.mRil.unsljLogRet(1036, response);
        this.mRil.mRilCellInfoListRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$networkScanResult(int indicationType, android.hardware.radio.V1_1.NetworkScanResult result) {
        this.responseCellInfos(indicationType, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$networkScanResult_1_2(int indicationType, android.hardware.radio.V1_2.NetworkScanResult result) {
        this.responseCellInfos_1_2(indicationType, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$imsNetworkStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1037);
        this.mRil.mImsNetworkStateChangedRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$subscriptionStatusChanged(int indicationType, boolean activate) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{activate ? 1 : 0};
        this.mRil.unsljLogRet(1038, response);
        this.mRil.mSubscriptionStatusRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$srvccStateNotify(int indicationType, int state) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{state};
        this.mRil.unsljLogRet(1039, response);
        this.mRil.writeMetricsSrvcc(state);
        this.mRil.mSrvccStateRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$hardwareConfigChanged(int indicationType, ArrayList<android.hardware.radio.V1_0.HardwareConfig> configs) {
        this.mRil.processIndication(indicationType);
        ArrayList<HardwareConfig> response = RIL.convertHalHwConfigList(configs, this.mRil);
        this.mRil.unsljLogRet(1040, response);
        this.mRil.mHardwareConfigChangeRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$radioCapabilityIndication(int indicationType, android.hardware.radio.V1_0.RadioCapability rc) {
        this.mRil.processIndication(indicationType);
        RadioCapability response = RIL.convertHalRadioCapability(rc, this.mRil);
        this.mRil.unsljLogRet(1042, response);
        this.mRil.mPhoneRadioCapabilityChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$onSupplementaryServiceIndication(int indicationType, StkCcUnsolSsResult ss) {
        this.mRil.processIndication(indicationType);
        SsData ssData = new SsData();
        ssData.serviceType = ssData.ServiceTypeFromRILInt(ss.serviceType);
        ssData.requestType = ssData.RequestTypeFromRILInt(ss.requestType);
        ssData.teleserviceType = ssData.TeleserviceTypeFromRILInt(ss.teleserviceType);
        ssData.serviceClass = ss.serviceClass;
        ssData.result = ss.result;
        if (ssData.serviceType.isTypeCF() && ssData.requestType.isTypeInterrogation()) {
            CfData cfData = ss.cfData.get(0);
            int num = cfData.cfInfo.size();
            ssData.cfInfo = new CallForwardInfo[num];
            for (int i = 0; i < num; ++i) {
                android.hardware.radio.V1_0.CallForwardInfo cfInfo = cfData.cfInfo.get(i);
                ssData.cfInfo[i] = new CallForwardInfo();
                ssData.cfInfo[i].status = cfInfo.status;
                ssData.cfInfo[i].reason = cfInfo.reason;
                ssData.cfInfo[i].serviceClass = cfInfo.serviceClass;
                ssData.cfInfo[i].toa = cfInfo.toa;
                ssData.cfInfo[i].number = cfInfo.number;
                ssData.cfInfo[i].timeSeconds = cfInfo.timeSeconds;
                this.mRil.riljLog("[SS Data] CF Info " + i + " : " + ssData.cfInfo[i]);
            }
        } else {
            SsInfoData ssInfo = ss.ssInfo.get(0);
            int num = ssInfo.ssInfo.size();
            ssData.ssInfo = new int[num];
            for (int i = 0; i < num; ++i) {
                ssData.ssInfo[i] = ssInfo.ssInfo.get(i);
                this.mRil.riljLog("[SS Data] SS Info " + i + " : " + ssData.ssInfo[i]);
            }
        }
        this.mRil.unsljLogRet(1043, ssData);
        if (this.mRil.mSsRegistrant != null) {
            this.mRil.mSsRegistrant.notifyRegistrant(new AsyncResult(null, ssData, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$stkCallControlAlphaNotify(int indicationType, String alpha) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1044, alpha);
        if (this.mRil.mCatCcAlphaRegistrant != null) {
            this.mRil.mCatCcAlphaRegistrant.notifyRegistrant(new AsyncResult(null, alpha, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$lceData(int indicationType, LceDataInfo lce) {
        this.mRil.processIndication(indicationType);
        LinkCapacityEstimate response = RIL.convertHalLceData(lce, this.mRil);
        this.mRil.unsljLogRet(1045, response);
        if (this.mRil.mLceInfoRegistrants != null) {
            this.mRil.mLceInfoRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$pcoData(int indicationType, PcoDataInfo pco) {
        this.mRil.processIndication(indicationType);
        PcoData response = new PcoData(pco.cid, pco.bearerProto, pco.pcoId, RIL.arrayListToPrimitiveArray(pco.contents));
        this.mRil.unsljLogRet(1046, response);
        this.mRil.mPcoDataRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$modemReset(int indicationType, String reason) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1047, reason);
        this.mRil.writeMetricsModemRestartEvent(reason);
        this.mRil.mModemResetRegistrants.notifyRegistrants(new AsyncResult(null, reason, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$carrierInfoForImsiEncryption(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1048, null);
        this.mRil.mCarrierInfoForImsiEncryptionRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$keepaliveStatus(int indicationType, android.hardware.radio.V1_1.KeepaliveStatus halStatus) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1051, "handle=" + halStatus.sessionHandle + " code=" + halStatus.code);
        KeepaliveStatus ks = new KeepaliveStatus(halStatus.sessionHandle, halStatus.code);
        this.mRil.mNattKeepaliveStatusRegistrants.notifyRegistrants(new AsyncResult(null, ks, null));
    }

    private final CommandsInterface.RadioState $$robo$$com_android_internal_telephony_RadioIndication$getRadioStateFromInt(int stateInt) {
        CommandsInterface.RadioState state;
        switch (stateInt) {
            case 0: {
                state = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                state = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 10: {
                state = CommandsInterface.RadioState.RADIO_ON;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RadioState: " + stateInt);
            }
        }
        return state;
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$responseCellInfos(int indicationType, android.hardware.radio.V1_1.NetworkScanResult result) {
        this.mRil.processIndication(indicationType);
        NetworkScanResult nsr = null;
        ArrayList<android.telephony.CellInfo> infos = RIL.convertHalCellInfoList(result.networkInfos);
        nsr = new NetworkScanResult(result.status, result.error, infos);
        this.mRil.unsljLogRet(1049, nsr);
        this.mRil.mRilNetworkScanResultRegistrants.notifyRegistrants(new AsyncResult(null, nsr, null));
    }

    private final void $$robo$$com_android_internal_telephony_RadioIndication$responseCellInfos_1_2(int indicationType, android.hardware.radio.V1_2.NetworkScanResult result) {
        this.mRil.processIndication(indicationType);
        NetworkScanResult nsr = null;
        ArrayList<android.telephony.CellInfo> infos = RIL.convertHalCellInfoList_1_2(result.networkInfos);
        nsr = new NetworkScanResult(result.status, result.error, infos);
        this.mRil.unsljLogRet(1049, nsr);
        this.mRil.mRilNetworkScanResultRegistrants.notifyRegistrants(new AsyncResult(null, nsr, null));
    }

    private void __constructor__(RIL rIL) {
        this.$$robo$$com_android_internal_telephony_RadioIndication$__constructor__(rIL);
    }

    public RadioIndication(RIL rIL) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RadioIndication$__constructor__(com.android.internal.telephony.RIL ), this, rIL);
    }

    @Override
    public void radioStateChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("radioStateChanged", $$robo$$com_android_internal_telephony_RadioIndication$radioStateChanged(int int ), this, n, n2);
    }

    @Override
    public void callStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("callStateChanged", $$robo$$com_android_internal_telephony_RadioIndication$callStateChanged(int ), this, n);
    }

    @Override
    public void networkStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("networkStateChanged", $$robo$$com_android_internal_telephony_RadioIndication$networkStateChanged(int ), this, n);
    }

    @Override
    public void newSms(int n, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrap("newSms", $$robo$$com_android_internal_telephony_RadioIndication$newSms(int java.util.ArrayList<java.lang.Byte> ), this, n, arrayList);
    }

    @Override
    public void newSmsStatusReport(int n, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrap("newSmsStatusReport", $$robo$$com_android_internal_telephony_RadioIndication$newSmsStatusReport(int java.util.ArrayList<java.lang.Byte> ), this, n, arrayList);
    }

    @Override
    public void newSmsOnSim(int n, int n2) {
        InvokeDynamicSupport.bootstrap("newSmsOnSim", $$robo$$com_android_internal_telephony_RadioIndication$newSmsOnSim(int int ), this, n, n2);
    }

    @Override
    public void onUssd(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("onUssd", $$robo$$com_android_internal_telephony_RadioIndication$onUssd(int int java.lang.String ), this, n, n2, string2);
    }

    @Override
    public void nitzTimeReceived(int n, String string2, long l) {
        InvokeDynamicSupport.bootstrap("nitzTimeReceived", $$robo$$com_android_internal_telephony_RadioIndication$nitzTimeReceived(int java.lang.String long ), this, n, string2, l);
    }

    @Override
    public void currentSignalStrength(int n, android.hardware.radio.V1_0.SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("currentSignalStrength", $$robo$$com_android_internal_telephony_RadioIndication$currentSignalStrength(int android.hardware.radio.V1_0.SignalStrength ), this, n, signalStrength);
    }

    @Override
    public void currentLinkCapacityEstimate(int n, android.hardware.radio.V1_2.LinkCapacityEstimate linkCapacityEstimate) {
        InvokeDynamicSupport.bootstrap("currentLinkCapacityEstimate", $$robo$$com_android_internal_telephony_RadioIndication$currentLinkCapacityEstimate(int android.hardware.radio.V1_2.LinkCapacityEstimate ), this, n, linkCapacityEstimate);
    }

    @Override
    public void currentSignalStrength_1_2(int n, android.hardware.radio.V1_2.SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("currentSignalStrength_1_2", $$robo$$com_android_internal_telephony_RadioIndication$currentSignalStrength_1_2(int android.hardware.radio.V1_2.SignalStrength ), this, n, signalStrength);
    }

    @Override
    public void currentPhysicalChannelConfigs(int n, ArrayList<android.hardware.radio.V1_2.PhysicalChannelConfig> arrayList) {
        InvokeDynamicSupport.bootstrap("currentPhysicalChannelConfigs", $$robo$$com_android_internal_telephony_RadioIndication$currentPhysicalChannelConfigs(int java.util.ArrayList<android.hardware.radio.V1_2.PhysicalChannelConfig> ), this, n, arrayList);
    }

    @Override
    public void dataCallListChanged(int n, ArrayList<SetupDataCallResult> arrayList) {
        InvokeDynamicSupport.bootstrap("dataCallListChanged", $$robo$$com_android_internal_telephony_RadioIndication$dataCallListChanged(int java.util.ArrayList<android.hardware.radio.V1_0.SetupDataCallResult> ), this, n, arrayList);
    }

    @Override
    public void suppSvcNotify(int n, SuppSvcNotification suppSvcNotification) {
        InvokeDynamicSupport.bootstrap("suppSvcNotify", $$robo$$com_android_internal_telephony_RadioIndication$suppSvcNotify(int android.hardware.radio.V1_0.SuppSvcNotification ), this, n, suppSvcNotification);
    }

    @Override
    public void stkSessionEnd(int n) {
        InvokeDynamicSupport.bootstrap("stkSessionEnd", $$robo$$com_android_internal_telephony_RadioIndication$stkSessionEnd(int ), this, n);
    }

    @Override
    public void stkProactiveCommand(int n, String string2) {
        InvokeDynamicSupport.bootstrap("stkProactiveCommand", $$robo$$com_android_internal_telephony_RadioIndication$stkProactiveCommand(int java.lang.String ), this, n, string2);
    }

    @Override
    public void stkEventNotify(int n, String string2) {
        InvokeDynamicSupport.bootstrap("stkEventNotify", $$robo$$com_android_internal_telephony_RadioIndication$stkEventNotify(int java.lang.String ), this, n, string2);
    }

    @Override
    public void stkCallSetup(int n, long l) {
        InvokeDynamicSupport.bootstrap("stkCallSetup", $$robo$$com_android_internal_telephony_RadioIndication$stkCallSetup(int long ), this, n, l);
    }

    @Override
    public void simSmsStorageFull(int n) {
        InvokeDynamicSupport.bootstrap("simSmsStorageFull", $$robo$$com_android_internal_telephony_RadioIndication$simSmsStorageFull(int ), this, n);
    }

    @Override
    public void simRefresh(int n, SimRefreshResult simRefreshResult) {
        InvokeDynamicSupport.bootstrap("simRefresh", $$robo$$com_android_internal_telephony_RadioIndication$simRefresh(int android.hardware.radio.V1_0.SimRefreshResult ), this, n, simRefreshResult);
    }

    @Override
    public void callRing(int n, boolean bl, CdmaSignalInfoRecord cdmaSignalInfoRecord) {
        InvokeDynamicSupport.bootstrap("callRing", $$robo$$com_android_internal_telephony_RadioIndication$callRing(int boolean android.hardware.radio.V1_0.CdmaSignalInfoRecord ), this, n, bl, cdmaSignalInfoRecord);
    }

    @Override
    public void simStatusChanged(int n) {
        InvokeDynamicSupport.bootstrap("simStatusChanged", $$robo$$com_android_internal_telephony_RadioIndication$simStatusChanged(int ), this, n);
    }

    @Override
    public void cdmaNewSms(int n, CdmaSmsMessage cdmaSmsMessage) {
        InvokeDynamicSupport.bootstrap("cdmaNewSms", $$robo$$com_android_internal_telephony_RadioIndication$cdmaNewSms(int android.hardware.radio.V1_0.CdmaSmsMessage ), this, n, cdmaSmsMessage);
    }

    @Override
    public void newBroadcastSms(int n, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrap("newBroadcastSms", $$robo$$com_android_internal_telephony_RadioIndication$newBroadcastSms(int java.util.ArrayList<java.lang.Byte> ), this, n, arrayList);
    }

    @Override
    public void cdmaRuimSmsStorageFull(int n) {
        InvokeDynamicSupport.bootstrap("cdmaRuimSmsStorageFull", $$robo$$com_android_internal_telephony_RadioIndication$cdmaRuimSmsStorageFull(int ), this, n);
    }

    @Override
    public void restrictedStateChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("restrictedStateChanged", $$robo$$com_android_internal_telephony_RadioIndication$restrictedStateChanged(int int ), this, n, n2);
    }

    @Override
    public void enterEmergencyCallbackMode(int n) {
        InvokeDynamicSupport.bootstrap("enterEmergencyCallbackMode", $$robo$$com_android_internal_telephony_RadioIndication$enterEmergencyCallbackMode(int ), this, n);
    }

    @Override
    public void cdmaCallWaiting(int n, CdmaCallWaiting cdmaCallWaiting) {
        InvokeDynamicSupport.bootstrap("cdmaCallWaiting", $$robo$$com_android_internal_telephony_RadioIndication$cdmaCallWaiting(int android.hardware.radio.V1_0.CdmaCallWaiting ), this, n, cdmaCallWaiting);
    }

    @Override
    public void cdmaOtaProvisionStatus(int n, int n2) {
        InvokeDynamicSupport.bootstrap("cdmaOtaProvisionStatus", $$robo$$com_android_internal_telephony_RadioIndication$cdmaOtaProvisionStatus(int int ), this, n, n2);
    }

    @Override
    public void cdmaInfoRec(int n, android.hardware.radio.V1_0.CdmaInformationRecords cdmaInformationRecords) {
        InvokeDynamicSupport.bootstrap("cdmaInfoRec", $$robo$$com_android_internal_telephony_RadioIndication$cdmaInfoRec(int android.hardware.radio.V1_0.CdmaInformationRecords ), this, n, cdmaInformationRecords);
    }

    @Override
    public void indicateRingbackTone(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("indicateRingbackTone", $$robo$$com_android_internal_telephony_RadioIndication$indicateRingbackTone(int boolean ), this, n, bl);
    }

    @Override
    public void resendIncallMute(int n) {
        InvokeDynamicSupport.bootstrap("resendIncallMute", $$robo$$com_android_internal_telephony_RadioIndication$resendIncallMute(int ), this, n);
    }

    @Override
    public void cdmaSubscriptionSourceChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("cdmaSubscriptionSourceChanged", $$robo$$com_android_internal_telephony_RadioIndication$cdmaSubscriptionSourceChanged(int int ), this, n, n2);
    }

    @Override
    public void cdmaPrlChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("cdmaPrlChanged", $$robo$$com_android_internal_telephony_RadioIndication$cdmaPrlChanged(int int ), this, n, n2);
    }

    @Override
    public void exitEmergencyCallbackMode(int n) {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_RadioIndication$exitEmergencyCallbackMode(int ), this, n);
    }

    @Override
    public void rilConnected(int n) {
        InvokeDynamicSupport.bootstrap("rilConnected", $$robo$$com_android_internal_telephony_RadioIndication$rilConnected(int ), this, n);
    }

    @Override
    public void voiceRadioTechChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("voiceRadioTechChanged", $$robo$$com_android_internal_telephony_RadioIndication$voiceRadioTechChanged(int int ), this, n, n2);
    }

    @Override
    public void cellInfoList(int n, ArrayList<CellInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("cellInfoList", $$robo$$com_android_internal_telephony_RadioIndication$cellInfoList(int java.util.ArrayList<android.hardware.radio.V1_0.CellInfo> ), this, n, arrayList);
    }

    @Override
    public void cellInfoList_1_2(int n, ArrayList<android.hardware.radio.V1_2.CellInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("cellInfoList_1_2", $$robo$$com_android_internal_telephony_RadioIndication$cellInfoList_1_2(int java.util.ArrayList<android.hardware.radio.V1_2.CellInfo> ), this, n, arrayList);
    }

    @Override
    public void networkScanResult(int n, android.hardware.radio.V1_1.NetworkScanResult networkScanResult) {
        InvokeDynamicSupport.bootstrap("networkScanResult", $$robo$$com_android_internal_telephony_RadioIndication$networkScanResult(int android.hardware.radio.V1_1.NetworkScanResult ), this, n, networkScanResult);
    }

    @Override
    public void networkScanResult_1_2(int n, android.hardware.radio.V1_2.NetworkScanResult networkScanResult) {
        InvokeDynamicSupport.bootstrap("networkScanResult_1_2", $$robo$$com_android_internal_telephony_RadioIndication$networkScanResult_1_2(int android.hardware.radio.V1_2.NetworkScanResult ), this, n, networkScanResult);
    }

    @Override
    public void imsNetworkStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("imsNetworkStateChanged", $$robo$$com_android_internal_telephony_RadioIndication$imsNetworkStateChanged(int ), this, n);
    }

    @Override
    public void subscriptionStatusChanged(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("subscriptionStatusChanged", $$robo$$com_android_internal_telephony_RadioIndication$subscriptionStatusChanged(int boolean ), this, n, bl);
    }

    @Override
    public void srvccStateNotify(int n, int n2) {
        InvokeDynamicSupport.bootstrap("srvccStateNotify", $$robo$$com_android_internal_telephony_RadioIndication$srvccStateNotify(int int ), this, n, n2);
    }

    @Override
    public void hardwareConfigChanged(int n, ArrayList<android.hardware.radio.V1_0.HardwareConfig> arrayList) {
        InvokeDynamicSupport.bootstrap("hardwareConfigChanged", $$robo$$com_android_internal_telephony_RadioIndication$hardwareConfigChanged(int java.util.ArrayList<android.hardware.radio.V1_0.HardwareConfig> ), this, n, arrayList);
    }

    @Override
    public void radioCapabilityIndication(int n, android.hardware.radio.V1_0.RadioCapability radioCapability) {
        InvokeDynamicSupport.bootstrap("radioCapabilityIndication", $$robo$$com_android_internal_telephony_RadioIndication$radioCapabilityIndication(int android.hardware.radio.V1_0.RadioCapability ), this, n, radioCapability);
    }

    @Override
    public void onSupplementaryServiceIndication(int n, StkCcUnsolSsResult stkCcUnsolSsResult) {
        InvokeDynamicSupport.bootstrap("onSupplementaryServiceIndication", $$robo$$com_android_internal_telephony_RadioIndication$onSupplementaryServiceIndication(int android.hardware.radio.V1_0.StkCcUnsolSsResult ), this, n, stkCcUnsolSsResult);
    }

    @Override
    public void stkCallControlAlphaNotify(int n, String string2) {
        InvokeDynamicSupport.bootstrap("stkCallControlAlphaNotify", $$robo$$com_android_internal_telephony_RadioIndication$stkCallControlAlphaNotify(int java.lang.String ), this, n, string2);
    }

    @Override
    public void lceData(int n, LceDataInfo lceDataInfo) {
        InvokeDynamicSupport.bootstrap("lceData", $$robo$$com_android_internal_telephony_RadioIndication$lceData(int android.hardware.radio.V1_0.LceDataInfo ), this, n, lceDataInfo);
    }

    @Override
    public void pcoData(int n, PcoDataInfo pcoDataInfo) {
        InvokeDynamicSupport.bootstrap("pcoData", $$robo$$com_android_internal_telephony_RadioIndication$pcoData(int android.hardware.radio.V1_0.PcoDataInfo ), this, n, pcoDataInfo);
    }

    @Override
    public void modemReset(int n, String string2) {
        InvokeDynamicSupport.bootstrap("modemReset", $$robo$$com_android_internal_telephony_RadioIndication$modemReset(int java.lang.String ), this, n, string2);
    }

    @Override
    public void carrierInfoForImsiEncryption(int n) {
        InvokeDynamicSupport.bootstrap("carrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_RadioIndication$carrierInfoForImsiEncryption(int ), this, n);
    }

    @Override
    public void keepaliveStatus(int n, android.hardware.radio.V1_1.KeepaliveStatus keepaliveStatus) {
        InvokeDynamicSupport.bootstrap("keepaliveStatus", $$robo$$com_android_internal_telephony_RadioIndication$keepaliveStatus(int android.hardware.radio.V1_1.KeepaliveStatus ), this, n, keepaliveStatus);
    }

    private CommandsInterface.RadioState getRadioStateFromInt(int n) {
        return InvokeDynamicSupport.bootstrap("getRadioStateFromInt", $$robo$$com_android_internal_telephony_RadioIndication$getRadioStateFromInt(int ), this, n);
    }

    private void responseCellInfos(int n, android.hardware.radio.V1_1.NetworkScanResult networkScanResult) {
        InvokeDynamicSupport.bootstrap("responseCellInfos", $$robo$$com_android_internal_telephony_RadioIndication$responseCellInfos(int android.hardware.radio.V1_1.NetworkScanResult ), this, n, networkScanResult);
    }

    private void responseCellInfos_1_2(int n, android.hardware.radio.V1_2.NetworkScanResult networkScanResult) {
        InvokeDynamicSupport.bootstrap("responseCellInfos_1_2", $$robo$$com_android_internal_telephony_RadioIndication$responseCellInfos_1_2(int android.hardware.radio.V1_2.NetworkScanResult ), this, n, networkScanResult);
    }

    public /* synthetic */ RadioIndication() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioIndication)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

