/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ITelephony;
import com.google.errorprone.annotations.DoNotMock;
import java.util.function.Supplier;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TelephonyPermissions
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TelephonyPermissions";
    private static boolean DBG = false;
    private static Supplier<ITelephony> TELEPHONY_SUPPLIER;

    private void $$robo$$com_android_internal_telephony_TelephonyPermissions$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkCallingOrSelfReadPhoneState(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneState(context, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneState(Context context, int subId, int pid, int uid, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneState(context, TELEPHONY_SUPPLIER, subId, pid, uid, callingPackage, message);
    }

    @VisibleForTesting
    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneState(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage, String message) {
        try {
            context.enforcePermission("android.permission.READ_PRIVILEGED_PHONE_STATE", pid, uid, message);
            return true;
        }
        catch (SecurityException privilegedPhoneStateException) {
            try {
                context.enforcePermission("android.permission.READ_PHONE_STATE", pid, uid, message);
            }
            catch (SecurityException phoneStateException) {
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    TelephonyPermissions.enforceCarrierPrivilege(telephonySupplier, subId, uid, message);
                    return true;
                }
                throw phoneStateException;
            }
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            return appOps.noteOp(51, uid, callingPackage) == 0;
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadCallLog(Context context, int subId, int pid, int uid, String callingPackage) {
        return TelephonyPermissions.checkReadCallLog(context, TELEPHONY_SUPPLIER, subId, pid, uid, callingPackage);
    }

    @VisibleForTesting
    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadCallLog(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage) {
        if (context.checkPermission("android.permission.READ_CALL_LOG", pid, uid) != 0) {
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                TelephonyPermissions.enforceCarrierPrivilege(telephonySupplier, subId, uid, "readCallLog");
                return true;
            }
            return false;
        }
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        return appOps.noteOp(6, uid, callingPackage) == 0;
    }

    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkCallingOrSelfReadPhoneNumber(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneNumber(context, TELEPHONY_SUPPLIER, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    @VisibleForTesting
    private static final boolean $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneNumber(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage, String message) {
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        if (appOps.noteOp(15, uid, callingPackage) == 0) {
            return true;
        }
        try {
            return TelephonyPermissions.checkReadPhoneState(context, telephonySupplier, subId, pid, uid, callingPackage, message);
        }
        catch (SecurityException securityException) {
            try {
                context.enforcePermission("android.permission.READ_SMS", pid, uid, message);
                int opCode = AppOpsManager.permissionToOpCode("android.permission.READ_SMS");
                if (opCode != -1) {
                    return appOps.noteOp(opCode, uid, callingPackage) == 0;
                }
                return true;
            }
            catch (SecurityException opCode) {
                try {
                    context.enforcePermission("android.permission.READ_PHONE_NUMBERS", pid, uid, message);
                    int opCode2 = AppOpsManager.permissionToOpCode("android.permission.READ_PHONE_NUMBERS");
                    if (opCode2 != -1) {
                        return appOps.noteOp(opCode2, uid, callingPackage) == 0;
                    }
                    return true;
                }
                catch (SecurityException securityException2) {
                    throw new SecurityException(message + ": Neither user " + uid + " nor current process has " + "android.permission.READ_PHONE_STATE" + ", " + "android.permission.READ_SMS" + ", or " + "android.permission.READ_PHONE_NUMBERS");
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCallingOrSelfModifyPermissionOrCarrierPrivilege(Context context, int subId, String message) {
        if (context.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(subId, message);
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCallingOrSelfCarrierPrivilege(int subId, String message) {
        TelephonyPermissions.enforceCarrierPrivilege(subId, Binder.getCallingUid(), message);
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCarrierPrivilege(int subId, int uid, String message) {
        TelephonyPermissions.enforceCarrierPrivilege(TELEPHONY_SUPPLIER, subId, uid, message);
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCarrierPrivilege(Supplier<ITelephony> telephonySupplier, int subId, int uid, String message) {
        if (TelephonyPermissions.getCarrierPrivilegeStatus(telephonySupplier, subId, uid) != 1) {
            throw new SecurityException(message);
        }
    }

    private static final int $$robo$$com_android_internal_telephony_TelephonyPermissions$getCarrierPrivilegeStatus(Supplier<ITelephony> telephonySupplier, int subId, int uid) {
        ITelephony telephony = telephonySupplier.get();
        try {
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatusForUid(subId, uid);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Rlog.e("TelephonyPermissions", "Phone process is down, cannot check carrier privileges");
        return 0;
    }

    static void __staticInitializer__() {
        TELEPHONY_SUPPLIER = () -> ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_TelephonyPermissions$__constructor__();
    }

    public TelephonyPermissions() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyPermissions$__constructor__(), this);
    }

    public static boolean checkCallingOrSelfReadPhoneState(Context context, int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkCallingOrSelfReadPhoneState", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkCallingOrSelfReadPhoneState(android.content.Context int java.lang.String java.lang.String ), (Context)context, (int)n, (String)string2, (String)string3);
    }

    public static boolean checkReadPhoneState(Context context, int n, int n2, int n3, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkReadPhoneState", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneState(android.content.Context int int int java.lang.String java.lang.String ), (Context)context, (int)n, (int)n2, (int)n3, (String)string2, (String)string3);
    }

    public static boolean checkReadPhoneState(Context context, Supplier<ITelephony> supplier, int n, int n2, int n3, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkReadPhoneState", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneState(android.content.Context java.util.function.Supplier<com.android.internal.telephony.ITelephony> int int int java.lang.String java.lang.String ), (Context)context, supplier, (int)n, (int)n2, (int)n3, (String)string2, (String)string3);
    }

    public static boolean checkReadCallLog(Context context, int n, int n2, int n3, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkReadCallLog", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadCallLog(android.content.Context int int int java.lang.String ), (Context)context, (int)n, (int)n2, (int)n3, (String)string2);
    }

    public static boolean checkReadCallLog(Context context, Supplier<ITelephony> supplier, int n, int n2, int n3, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkReadCallLog", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadCallLog(android.content.Context java.util.function.Supplier<com.android.internal.telephony.ITelephony> int int int java.lang.String ), (Context)context, supplier, (int)n, (int)n2, (int)n3, (String)string2);
    }

    public static boolean checkCallingOrSelfReadPhoneNumber(Context context, int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkCallingOrSelfReadPhoneNumber", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkCallingOrSelfReadPhoneNumber(android.content.Context int java.lang.String java.lang.String ), (Context)context, (int)n, (String)string2, (String)string3);
    }

    public static boolean checkReadPhoneNumber(Context context, Supplier<ITelephony> supplier, int n, int n2, int n3, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkReadPhoneNumber", $$robo$$com_android_internal_telephony_TelephonyPermissions$checkReadPhoneNumber(android.content.Context java.util.function.Supplier<com.android.internal.telephony.ITelephony> int int int java.lang.String java.lang.String ), (Context)context, supplier, (int)n, (int)n2, (int)n3, (String)string2, (String)string3);
    }

    public static void enforceCallingOrSelfModifyPermissionOrCarrierPrivilege(Context context, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("enforceCallingOrSelfModifyPermissionOrCarrierPrivilege", $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCallingOrSelfModifyPermissionOrCarrierPrivilege(android.content.Context int java.lang.String ), (Context)context, (int)n, (String)string2);
    }

    public static void enforceCallingOrSelfCarrierPrivilege(int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("enforceCallingOrSelfCarrierPrivilege", $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCallingOrSelfCarrierPrivilege(int java.lang.String ), (int)n, (String)string2);
    }

    private static void enforceCarrierPrivilege(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("enforceCarrierPrivilege", $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCarrierPrivilege(int int java.lang.String ), (int)n, (int)n2, (String)string2);
    }

    private static void enforceCarrierPrivilege(Supplier<ITelephony> supplier, int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("enforceCarrierPrivilege", $$robo$$com_android_internal_telephony_TelephonyPermissions$enforceCarrierPrivilege(java.util.function.Supplier<com.android.internal.telephony.ITelephony> int int java.lang.String ), supplier, (int)n, (int)n2, (String)string2);
    }

    private static int getCarrierPrivilegeStatus(Supplier<ITelephony> supplier, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCarrierPrivilegeStatus", $$robo$$com_android_internal_telephony_TelephonyPermissions$getCarrierPrivilegeStatus(java.util.function.Supplier<com.android.internal.telephony.ITelephony> int int ), supplier, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyPermissions.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyPermissions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

