/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Build;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.ims.ImsConferenceState;
import android.telephony.ims.ImsExternalCallState;
import android.telephony.ims.ImsReasonInfo;
import com.android.ims.ImsCall;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.test.TestConferenceEventPackageParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyTester
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TelephonyTester";
    private static boolean DBG = true;
    private static String ACTION_TEST_CONFERENCE_EVENT_PACKAGE = "com.android.internal.telephony.TestConferenceEventPackage";
    private static String ACTION_TEST_DIALOG_EVENT_PACKAGE = "com.android.internal.telephony.TestDialogEventPackage";
    private static String EXTRA_FILENAME = "filename";
    private static String EXTRA_STARTPACKAGE = "startPackage";
    private static String EXTRA_SENDPACKAGE = "sendPackage";
    private static String EXTRA_DIALOGID = "dialogId";
    private static String EXTRA_NUMBER = "number";
    private static String EXTRA_STATE = "state";
    private static String EXTRA_CANPULL = "canPull";
    private static String ACTION_TEST_SUPP_SRVC_FAIL = "com.android.internal.telephony.TestSuppSrvcFail";
    private static String EXTRA_FAILURE_CODE = "failureCode";
    private static String ACTION_TEST_HANDOVER_FAIL = "com.android.internal.telephony.TestHandoverFail";
    private static String ACTION_TEST_SUPP_SRVC_NOTIFICATION = "com.android.internal.telephony.TestSuppSrvcNotification";
    private static String EXTRA_CODE = "code";
    private static String EXTRA_TYPE = "type";
    private static String ACTION_TEST_SERVICE_STATE = "com.android.internal.telephony.TestServiceState";
    private static String EXTRA_ACTION = "action";
    private static String EXTRA_VOICE_RAT = "voice_rat";
    private static String EXTRA_DATA_RAT = "data_rat";
    private static String EXTRA_VOICE_REG_STATE = "voice_reg_state";
    private static String EXTRA_DATA_REG_STATE = "data_reg_state";
    private static String EXTRA_VOICE_ROAMING_TYPE = "voice_roaming_type";
    private static String EXTRA_DATA_ROAMING_TYPE = "data_roaming_type";
    private static String ACTION_RESET = "reset";
    private static List<ImsExternalCallState> mImsExternalCallStates;
    private Intent mServiceStateTestIntent;
    private Phone mPhone;
    protected BroadcastReceiver mIntentReceiver;

    private void $$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(Phone phone) {
        this.mIntentReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TelephonyTester this$0;

            private void $$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(TelephonyTester this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_TelephonyTester_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                try {
                    TelephonyTester.log("sIntentReceiver.onReceive: action=" + action);
                    if (action.equals(this.this$0.mPhone.getActionDetached())) {
                        TelephonyTester.log("simulate detaching");
                        ((TelephonyTester)this.this$0).mPhone.getServiceStateTracker().mDetachedRegistrants.notifyRegistrants();
                    } else if (action.equals(this.this$0.mPhone.getActionAttached())) {
                        TelephonyTester.log("simulate attaching");
                        ((TelephonyTester)this.this$0).mPhone.getServiceStateTracker().mAttachedRegistrants.notifyRegistrants();
                    } else if (action.equals("com.android.internal.telephony.TestConferenceEventPackage")) {
                        TelephonyTester.log("inject simulated conference event package");
                        this.this$0.handleTestConferenceEventPackage(context, intent.getStringExtra("filename"));
                    } else if (action.equals("com.android.internal.telephony.TestDialogEventPackage")) {
                        TelephonyTester.log("handle test dialog event package intent");
                        this.this$0.handleTestDialogEventPackageIntent(intent);
                    } else if (action.equals("com.android.internal.telephony.TestSuppSrvcFail")) {
                        TelephonyTester.log("handle test supp svc failed intent");
                        this.this$0.handleSuppServiceFailedIntent(intent);
                    } else if (action.equals("com.android.internal.telephony.TestHandoverFail")) {
                        TelephonyTester.log("handle handover fail test intent");
                        this.this$0.handleHandoverFailedIntent();
                    } else if (action.equals("com.android.internal.telephony.TestSuppSrvcNotification")) {
                        TelephonyTester.log("handle supp service notification test intent");
                        this.this$0.sendTestSuppServiceNotification(intent);
                    } else if (action.equals("com.android.internal.telephony.TestServiceState")) {
                        TelephonyTester.log("handle test service state changed intent");
                        this.this$0.mServiceStateTestIntent = intent;
                        this.this$0.mPhone.getServiceStateTracker().sendEmptyMessage(2);
                    } else {
                        TelephonyTester.log("onReceive: unknown action=" + action);
                    }
                }
                catch (BadParcelableException e) {
                    Rlog.w("TelephonyTester", e);
                }
            }

            private void __constructor__(TelephonyTester telephonyTester) {
                this.$$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(telephonyTester);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(com.android.internal.telephony.TelephonyTester ), this, telephonyTester);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_TelephonyTester_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        if (Build.IS_DEBUGGABLE) {
            IntentFilter filter = new IntentFilter();
            filter.addAction(this.mPhone.getActionDetached());
            TelephonyTester.log("register for intent action=" + this.mPhone.getActionDetached());
            filter.addAction(this.mPhone.getActionAttached());
            TelephonyTester.log("register for intent action=" + this.mPhone.getActionAttached());
            if (this.mPhone.getPhoneType() == 5) {
                TelephonyTester.log("register for intent action=com.android.internal.telephony.TestConferenceEventPackage");
                filter.addAction("com.android.internal.telephony.TestConferenceEventPackage");
                filter.addAction("com.android.internal.telephony.TestDialogEventPackage");
                filter.addAction("com.android.internal.telephony.TestSuppSrvcFail");
                filter.addAction("com.android.internal.telephony.TestHandoverFail");
                filter.addAction("com.android.internal.telephony.TestSuppSrvcNotification");
                mImsExternalCallStates = new ArrayList<ImsExternalCallState>();
            } else {
                filter.addAction("com.android.internal.telephony.TestServiceState");
                TelephonyTester.log("register for intent action=com.android.internal.telephony.TestServiceState");
            }
            phone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone.getHandler());
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$dispose() {
        if (Build.IS_DEBUGGABLE) {
            this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyTester$log(String s) {
        Rlog.d("TelephonyTester", s);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleSuppServiceFailedIntent(Intent intent) {
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        int code = intent.getIntExtra("failureCode", 0);
        imsPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.values()[code]);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleHandoverFailedIntent() {
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        Call imsPhoneCall = imsPhone.getForegroundCall();
        if (imsPhoneCall == null) {
            return;
        }
        ImsCall imsCall = ((ImsPhoneCall)imsPhoneCall).getImsCall();
        if (imsCall == null) {
            return;
        }
        imsCall.getImsCallSessionListenerProxy().callSessionHandoverFailed(imsCall.getCallSession(), 14, 18, new ImsReasonInfo());
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleTestConferenceEventPackage(Context context, String fileName) {
        FileInputStream is;
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        Call imsPhoneCall = imsPhone.getForegroundCall();
        if (imsPhoneCall == null) {
            return;
        }
        ImsCall imsCall = ((ImsPhoneCall)imsPhoneCall).getImsCall();
        if (imsCall == null) {
            return;
        }
        File packageFile = new File(context.getFilesDir(), fileName);
        try {
            is = new FileInputStream(packageFile);
        }
        catch (FileNotFoundException ex) {
            TelephonyTester.log("Test conference event package file not found: " + packageFile.getAbsolutePath());
            return;
        }
        TestConferenceEventPackageParser parser = new TestConferenceEventPackageParser(is);
        ImsConferenceState imsConferenceState = parser.parse();
        if (imsConferenceState == null) {
            return;
        }
        imsCall.conferenceStateUpdated(imsConferenceState);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleTestDialogEventPackageIntent(Intent intent) {
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        ImsExternalCallTracker externalCallTracker = imsPhone.getExternalCallTracker();
        if (externalCallTracker == null) {
            return;
        }
        if (intent.hasExtra("startPackage")) {
            mImsExternalCallStates.clear();
        } else if (intent.hasExtra("sendPackage")) {
            externalCallTracker.refreshExternalCallState(mImsExternalCallStates);
            mImsExternalCallStates.clear();
        } else if (intent.hasExtra("dialogId")) {
            ImsExternalCallState state = new ImsExternalCallState(intent.getIntExtra("dialogId", 0), Uri.parse(intent.getStringExtra("number")), intent.getBooleanExtra("canPull", true), intent.getIntExtra("state", 1), 2, false);
            mImsExternalCallStates.add(state);
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$sendTestSuppServiceNotification(Intent intent) {
        if (intent.hasExtra("code") && intent.hasExtra("type")) {
            int code = intent.getIntExtra("code", -1);
            int type = intent.getIntExtra("type", -1);
            ImsPhone imsPhone = (ImsPhone)this.mPhone;
            if (imsPhone == null) {
                return;
            }
            TelephonyTester.log("Test supp service notification:" + code);
            SuppServiceNotification suppServiceNotification = new SuppServiceNotification();
            suppServiceNotification.code = code;
            suppServiceNotification.notificationType = type;
            imsPhone.notifySuppSvcNotification(suppServiceNotification);
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$overrideServiceState(ServiceState ss) {
        if (this.mServiceStateTestIntent == null || ss == null) {
            return;
        }
        if (this.mServiceStateTestIntent.hasExtra("action") && "reset".equals(this.mServiceStateTestIntent.getStringExtra("action"))) {
            TelephonyTester.log("Service state override reset");
            return;
        }
        if (this.mServiceStateTestIntent.hasExtra("voice_reg_state")) {
            ss.setVoiceRegState(this.mServiceStateTestIntent.getIntExtra("voice_reg_state", 4));
            TelephonyTester.log("Override voice reg state with " + ss.getVoiceRegState());
        }
        if (this.mServiceStateTestIntent.hasExtra("data_reg_state")) {
            ss.setDataRegState(this.mServiceStateTestIntent.getIntExtra("data_reg_state", 4));
            TelephonyTester.log("Override data reg state with " + ss.getDataRegState());
        }
        if (this.mServiceStateTestIntent.hasExtra("voice_rat")) {
            ss.setRilVoiceRadioTechnology(this.mServiceStateTestIntent.getIntExtra("voice_rat", 0));
            TelephonyTester.log("Override voice rat with " + ss.getRilVoiceRadioTechnology());
        }
        if (this.mServiceStateTestIntent.hasExtra("data_rat")) {
            ss.setRilDataRadioTechnology(this.mServiceStateTestIntent.getIntExtra("data_rat", 0));
            TelephonyTester.log("Override data rat with " + ss.getRilDataRadioTechnology());
        }
        if (this.mServiceStateTestIntent.hasExtra("voice_roaming_type")) {
            ss.setVoiceRoamingType(this.mServiceStateTestIntent.getIntExtra("voice_roaming_type", 1));
            TelephonyTester.log("Override voice roaming type with " + ss.getVoiceRoamingType());
        }
        if (this.mServiceStateTestIntent.hasExtra("data_roaming_type")) {
            ss.setDataRoamingType(this.mServiceStateTestIntent.getIntExtra("data_roaming_type", 1));
            TelephonyTester.log("Override data roaming type with " + ss.getDataRoamingType());
        }
    }

    static void __staticInitializer__() {
        mImsExternalCallStates = null;
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(phone);
    }

    public TelephonyTester(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_TelephonyTester$dispose(), this);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_TelephonyTester$log(java.lang.String ), (String)string2);
    }

    private void handleSuppServiceFailedIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("handleSuppServiceFailedIntent", $$robo$$com_android_internal_telephony_TelephonyTester$handleSuppServiceFailedIntent(android.content.Intent ), this, intent);
    }

    private void handleHandoverFailedIntent() {
        InvokeDynamicSupport.bootstrap("handleHandoverFailedIntent", $$robo$$com_android_internal_telephony_TelephonyTester$handleHandoverFailedIntent(), this);
    }

    private void handleTestConferenceEventPackage(Context context, String string2) {
        InvokeDynamicSupport.bootstrap("handleTestConferenceEventPackage", $$robo$$com_android_internal_telephony_TelephonyTester$handleTestConferenceEventPackage(android.content.Context java.lang.String ), this, context, string2);
    }

    private void handleTestDialogEventPackageIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("handleTestDialogEventPackageIntent", $$robo$$com_android_internal_telephony_TelephonyTester$handleTestDialogEventPackageIntent(android.content.Intent ), this, intent);
    }

    private void sendTestSuppServiceNotification(Intent intent) {
        InvokeDynamicSupport.bootstrap("sendTestSuppServiceNotification", $$robo$$com_android_internal_telephony_TelephonyTester$sendTestSuppServiceNotification(android.content.Intent ), this, intent);
    }

    void overrideServiceState(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("overrideServiceState", $$robo$$com_android_internal_telephony_TelephonyTester$overrideServiceState(android.telephony.ServiceState ), this, serviceState);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyTester.class);
    }

    public /* synthetic */ TelephonyTester() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyTester)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

