/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.icu.util.TimeZone;
import android.text.TextUtils;
import com.android.internal.telephony.NitzData;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Date;
import libcore.util.CountryTimeZones;
import libcore.util.TimeZoneFinder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeZoneLookupHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MS_PER_HOUR = 3600000;
    private CountryTimeZones mLastCountryTimeZones;

    private void $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$__constructor__() {
    }

    private final OffsetResult $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitzCountry(NitzData nitzData, String isoCountryCode) {
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        if (countryTimeZones == null) {
            return null;
        }
        TimeZone bias = TimeZone.getDefault();
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(nitzData.getLocalOffsetMillis(), nitzData.isDst(), nitzData.getCurrentTimeInMillis(), bias);
        if (offsetResult == null) {
            return null;
        }
        return new OffsetResult(offsetResult.mTimeZone.getID(), offsetResult.mOneMatch);
    }

    private final OffsetResult $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitz(NitzData nitzData) {
        return TimeZoneLookupHelper.lookupByNitzStatic(nitzData);
    }

    private final CountryResult $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByCountry(String isoCountryCode, long whenMillis) {
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        if (countryTimeZones == null) {
            return null;
        }
        if (countryTimeZones.getDefaultTimeZoneId() == null) {
            return null;
        }
        return new CountryResult(countryTimeZones.getDefaultTimeZoneId(), countryTimeZones.isDefaultOkForCountryTimeZoneDetection(whenMillis), whenMillis);
    }

    private static final java.util.TimeZone $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$guessZoneByNitzStatic(NitzData nitzData) {
        OffsetResult result = TimeZoneLookupHelper.lookupByNitzStatic(nitzData);
        return result != null ? java.util.TimeZone.getTimeZone(result.zoneId) : null;
    }

    private static final OffsetResult $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitzStatic(NitzData nitzData) {
        int utcOffsetMillis = nitzData.getLocalOffsetMillis();
        boolean isDst = nitzData.isDst();
        long timeMillis = nitzData.getCurrentTimeInMillis();
        OffsetResult match = TimeZoneLookupHelper.lookupByInstantOffsetDst(timeMillis, utcOffsetMillis, isDst);
        if (match == null) {
            match = TimeZoneLookupHelper.lookupByInstantOffsetDst(timeMillis, utcOffsetMillis, !isDst);
        }
        return match;
    }

    private static final OffsetResult $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByInstantOffsetDst(long timeMillis, int utcOffsetMillis, boolean isDst) {
        int rawOffset = utcOffsetMillis;
        if (isDst) {
            rawOffset -= 3600000;
        }
        String[] zones = java.util.TimeZone.getAvailableIDs(rawOffset);
        java.util.TimeZone match = null;
        Date d = new Date(timeMillis);
        boolean isOnlyMatch = true;
        for (String zone : zones) {
            java.util.TimeZone tz = java.util.TimeZone.getTimeZone(zone);
            if (tz.getOffset(timeMillis) != utcOffsetMillis || tz.inDaylightTime(d) != isDst) continue;
            if (match == null) {
                match = tz;
                continue;
            }
            isOnlyMatch = false;
            break;
        }
        if (match == null) {
            return null;
        }
        return new OffsetResult(match.getID(), isOnlyMatch);
    }

    private final boolean $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$countryUsesUtc(String isoCountryCode, long whenMillis) {
        if (TextUtils.isEmpty(isoCountryCode)) {
            return false;
        }
        CountryTimeZones countryTimeZones = this.getCountryTimeZones(isoCountryCode);
        return countryTimeZones != null && countryTimeZones.hasUtcZone(whenMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CountryTimeZones $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$getCountryTimeZones(String isoCountryCode) {
        TimeZoneLookupHelper timeZoneLookupHelper = this;
        synchronized (timeZoneLookupHelper) {
            if (this.mLastCountryTimeZones != null && this.mLastCountryTimeZones.isForCountryCode(isoCountryCode)) {
                return this.mLastCountryTimeZones;
            }
            CountryTimeZones countryTimeZones = TimeZoneFinder.getInstance().lookupCountryTimeZones(isoCountryCode);
            if (countryTimeZones != null) {
                this.mLastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_TimeZoneLookupHelper$__constructor__();
    }

    public TimeZoneLookupHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$__constructor__(), this);
    }

    public OffsetResult lookupByNitzCountry(NitzData nitzData, String string2) {
        return InvokeDynamicSupport.bootstrap("lookupByNitzCountry", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitzCountry(com.android.internal.telephony.NitzData java.lang.String ), this, nitzData, string2);
    }

    public OffsetResult lookupByNitz(NitzData nitzData) {
        return InvokeDynamicSupport.bootstrap("lookupByNitz", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitz(com.android.internal.telephony.NitzData ), this, nitzData);
    }

    public CountryResult lookupByCountry(String string2, long l) {
        return InvokeDynamicSupport.bootstrap("lookupByCountry", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByCountry(java.lang.String long ), this, string2, l);
    }

    static java.util.TimeZone guessZoneByNitzStatic(NitzData nitzData) {
        return InvokeDynamicSupport.bootstrapStatic("guessZoneByNitzStatic", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$guessZoneByNitzStatic(com.android.internal.telephony.NitzData ), (NitzData)nitzData);
    }

    private static OffsetResult lookupByNitzStatic(NitzData nitzData) {
        return InvokeDynamicSupport.bootstrapStatic("lookupByNitzStatic", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByNitzStatic(com.android.internal.telephony.NitzData ), (NitzData)nitzData);
    }

    private static OffsetResult lookupByInstantOffsetDst(long l, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("lookupByInstantOffsetDst", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$lookupByInstantOffsetDst(long int boolean ), (long)l, (int)n, (boolean)bl);
    }

    public boolean countryUsesUtc(String string2, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("countryUsesUtc", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$countryUsesUtc(java.lang.String long ), this, string2, l);
    }

    private CountryTimeZones getCountryTimeZones(String string2) {
        return InvokeDynamicSupport.bootstrap("getCountryTimeZones", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper$getCountryTimeZones(java.lang.String ), this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneLookupHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CountryResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String zoneId;
        public boolean allZonesHaveSameOffset;
        public long whenMillis;

        private void $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$__constructor__(String zoneId, boolean allZonesHaveSameOffset, long whenMillis) {
            this.zoneId = zoneId;
            this.allZonesHaveSameOffset = allZonesHaveSameOffset;
            this.whenMillis = whenMillis;
        }

        private final boolean $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountryResult that = (CountryResult)o;
            if (this.allZonesHaveSameOffset != that.allZonesHaveSameOffset) {
                return false;
            }
            if (this.whenMillis != that.whenMillis) {
                return false;
            }
            return this.zoneId.equals(that.zoneId);
        }

        private final int $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$hashCode() {
            int result = this.zoneId.hashCode();
            result = 31 * result + (this.allZonesHaveSameOffset ? 1 : 0);
            result = 31 * result + (int)(this.whenMillis ^ this.whenMillis >>> 32);
            return result;
        }

        private final String $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$toString() {
            return "CountryResult{zoneId='" + this.zoneId + '\'' + ", allZonesHaveSameOffset=" + this.allZonesHaveSameOffset + ", whenMillis=" + this.whenMillis + '}';
        }

        private void __constructor__(String string2, boolean bl, long l) {
            this.$$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$__constructor__(string2, bl, l);
        }

        public CountryResult(String string2, boolean bl, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$__constructor__(java.lang.String boolean long ), this, string2, bl, l);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_CountryResult$toString(), this);
        }

        public /* synthetic */ CountryResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class OffsetResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String zoneId;
        public boolean isOnlyMatch;

        private void $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$__constructor__(String zoneId, boolean isOnlyMatch) {
            this.zoneId = zoneId;
            this.isOnlyMatch = isOnlyMatch;
        }

        private final boolean $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetResult result = (OffsetResult)o;
            if (this.isOnlyMatch != result.isOnlyMatch) {
                return false;
            }
            return this.zoneId.equals(result.zoneId);
        }

        private final int $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$hashCode() {
            int result = this.zoneId.hashCode();
            result = 31 * result + (this.isOnlyMatch ? 1 : 0);
            return result;
        }

        private final String $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$toString() {
            return "Result{zoneId='" + this.zoneId + '\'' + ", isOnlyMatch=" + this.isOnlyMatch + '}';
        }

        private void __constructor__(String string2, boolean bl) {
            this.$$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$__constructor__(string2, bl);
        }

        public OffsetResult(String string2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$__constructor__(java.lang.String boolean ), this, string2, bl);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_TimeZoneLookupHelper_OffsetResult$toString(), this);
        }

        public /* synthetic */ OffsetResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

