/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.telecom.PhoneAccountHandle;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.VisualVoicemailSms;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.VisualVoicemailSmsParser;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VisualVoicemailSmsFilter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "VvmSmsFilter";
    private static String TELEPHONY_SERVICE_PACKAGE = "com.android.phone";
    private static ComponentName PSTN_CONNECTION_SERVICE_COMPONENT;
    private static Map<String, List<Pattern>> sPatterns;
    private static PhoneAccountHandleConverter DEFAULT_PHONE_ACCOUNT_HANDLE_CONVERTER;
    private static PhoneAccountHandleConverter sPhoneAccountHandleConverter;

    private void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$filter(Context context, byte[][] pdus, String format, int destPort, int subId) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        VisualVoicemailSmsFilterSettings settings = telephonyManager.getActiveVisualVoicemailSmsFilterSettings(subId);
        if (settings == null) {
            return false;
        }
        PhoneAccountHandle phoneAccountHandle = sPhoneAccountHandleConverter.fromSubId(subId);
        if (phoneAccountHandle == null) {
            Log.e("VvmSmsFilter", "Unable to convert subId " + subId + " to PhoneAccountHandle");
            return false;
        }
        FullMessage fullMessage = VisualVoicemailSmsFilter.getFullMessage(pdus, format);
        if (fullMessage == null) {
            Log.i("VvmSmsFilter", "Unparsable SMS received");
            String asciiMessage = VisualVoicemailSmsFilter.parseAsciiPduMessage(pdus);
            VisualVoicemailSmsParser.WrappedMessageData messageData = VisualVoicemailSmsParser.parseAlternativeFormat(asciiMessage);
            if (messageData != null) {
                VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, settings, phoneAccountHandle, messageData, null);
            }
            return false;
        }
        String clientPrefix = settings.clientPrefix;
        String messageBody = fullMessage.fullMessageBody;
        VisualVoicemailSmsParser.WrappedMessageData messageData = VisualVoicemailSmsParser.parse(clientPrefix, messageBody);
        if (messageData != null) {
            if (settings.destinationPort == -2) {
                if (destPort == -1) {
                    Log.i("VvmSmsFilter", "SMS matching VVM format received but is not a DATA SMS");
                    return false;
                }
            } else if (settings.destinationPort != -1 && settings.destinationPort != destPort) {
                Log.i("VvmSmsFilter", "SMS matching VVM format received but is not directed to port " + settings.destinationPort);
                return false;
            }
            if (!settings.originatingNumbers.isEmpty() && !VisualVoicemailSmsFilter.isSmsFromNumbers(fullMessage.firstMessage, settings.originatingNumbers)) {
                Log.i("VvmSmsFilter", "SMS matching VVM format received but is not from originating numbers");
                return false;
            }
            VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, settings, phoneAccountHandle, messageData, null);
            return true;
        }
        VisualVoicemailSmsFilter.buildPatternsMap(context);
        String mccMnc = telephonyManager.getSimOperator(subId);
        List<Pattern> patterns = sPatterns.get(mccMnc);
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(messageBody).matches()) continue;
            Log.w("VvmSmsFilter", "Incoming SMS matches pattern " + pattern + " but has illegal format, still dropping as VVM SMS");
            VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, settings, phoneAccountHandle, null, messageBody);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private static final void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$setPhoneAccountHandleConverterForTest(PhoneAccountHandleConverter converter) {
        sPhoneAccountHandleConverter = converter == null ? DEFAULT_PHONE_ACCOUNT_HANDLE_CONVERTER : converter;
    }

    private static final void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$buildPatternsMap(Context context) {
        if (sPatterns != null) {
            return;
        }
        sPatterns = new ArrayMap<String, List<Pattern>>();
        for (String entry : context.getResources().getStringArray(17236054)) {
            String[] mccMncList = entry.split(";")[0].split(",");
            Pattern pattern = Pattern.compile(entry.split(";")[1]);
            for (String mccMnc : mccMncList) {
                if (!sPatterns.containsKey(mccMnc)) {
                    sPatterns.put(mccMnc, new ArrayList());
                }
                sPatterns.get(mccMnc).add(pattern);
            }
        }
    }

    private static final void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$sendVvmSmsBroadcast(Context context, VisualVoicemailSmsFilterSettings filterSettings, PhoneAccountHandle phoneAccountHandle, VisualVoicemailSmsParser.WrappedMessageData messageData, String messageBody) {
        Log.i("VvmSmsFilter", "VVM SMS received");
        Intent intent = new Intent("com.android.internal.provider.action.VOICEMAIL_SMS_RECEIVED");
        VisualVoicemailSms.Builder builder = new VisualVoicemailSms.Builder();
        if (messageData != null) {
            builder.setPrefix(messageData.prefix);
            builder.setFields(messageData.fields);
        }
        if (messageBody != null) {
            builder.setMessageBody(messageBody);
        }
        builder.setPhoneAccountHandle(phoneAccountHandle);
        intent.putExtra("android.provider.extra.VOICEMAIL_SMS", builder.build());
        intent.putExtra("android.provider.extra.TARGET_PACAKGE", filterSettings.packageName);
        intent.setPackage("com.android.phone");
        context.sendBroadcast(intent);
    }

    private static final FullMessage $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$getFullMessage(byte[][] pdus, String format) {
        FullMessage result = new FullMessage(null);
        StringBuilder builder = new StringBuilder();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        for (byte[] pdu : pdus) {
            String body;
            SmsMessage message = SmsMessage.createFromPdu(pdu, format);
            if (message == null) {
                return null;
            }
            if (result.firstMessage == null) {
                result.firstMessage = message;
            }
            if ((body = message.getMessageBody()) == null && message.getUserData() != null) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(message.getUserData());
                try {
                    body = decoder.decode(byteBuffer).toString();
                }
                catch (CharacterCodingException e) {
                    return null;
                }
            }
            if (body == null) continue;
            builder.append(body);
        }
        result.fullMessageBody = builder.toString();
        return result;
    }

    private static final String $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$parseAsciiPduMessage(byte[][] pdus) {
        StringBuilder builder = new StringBuilder();
        for (byte[] pdu : pdus) {
            builder.append(new String(pdu, StandardCharsets.US_ASCII));
        }
        return builder.toString();
    }

    private static final boolean $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$isSmsFromNumbers(SmsMessage message, List<String> numbers) {
        if (message == null) {
            Log.e("VvmSmsFilter", "Unable to create SmsMessage from PDU, cannot determine originating number");
            return false;
        }
        for (String number : numbers) {
            if (!PhoneNumberUtils.compare(number, message.getOriginatingAddress())) continue;
            return true;
        }
        return false;
    }

    static void __staticInitializer__() {
        PSTN_CONNECTION_SERVICE_COMPONENT = new ComponentName("com.android.phone", "com.android.services.telephony.TelephonyConnectionService");
        sPhoneAccountHandleConverter = DEFAULT_PHONE_ACCOUNT_HANDLE_CONVERTER = new PhoneAccountHandleConverter(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_1$__constructor__() {
            }

            private final PhoneAccountHandle $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_1$fromSubId(int subId) {
                if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                    return null;
                }
                int phoneId = SubscriptionManager.getPhoneId(subId);
                if (phoneId == -1) {
                    return null;
                }
                return new PhoneAccountHandle(PSTN_CONNECTION_SERVICE_COMPONENT, PhoneFactory.getPhone(phoneId).getFullIccSerialNumber());
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_1$__constructor__(), this);
            }

            @Override
            public PhoneAccountHandle fromSubId(int n) {
                return InvokeDynamicSupport.bootstrap("fromSubId", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_1$fromSubId(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$__constructor__();
    }

    public VisualVoicemailSmsFilter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$__constructor__(), this);
    }

    public static boolean filter(Context context, byte[][] byArray, String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("filter", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$filter(android.content.Context byte[][] java.lang.String int int ), (Context)context, (byte[][])byArray, (String)string2, (int)n, (int)n2);
    }

    public static void setPhoneAccountHandleConverterForTest(PhoneAccountHandleConverter phoneAccountHandleConverter) {
        InvokeDynamicSupport.bootstrapStatic("setPhoneAccountHandleConverterForTest", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$setPhoneAccountHandleConverterForTest(com.android.internal.telephony.VisualVoicemailSmsFilter$PhoneAccountHandleConverter ), (PhoneAccountHandleConverter)phoneAccountHandleConverter);
    }

    private static void buildPatternsMap(Context context) {
        InvokeDynamicSupport.bootstrapStatic("buildPatternsMap", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$buildPatternsMap(android.content.Context ), (Context)context);
    }

    private static void sendVvmSmsBroadcast(Context context, VisualVoicemailSmsFilterSettings visualVoicemailSmsFilterSettings, PhoneAccountHandle phoneAccountHandle, VisualVoicemailSmsParser.WrappedMessageData wrappedMessageData, String string2) {
        InvokeDynamicSupport.bootstrapStatic("sendVvmSmsBroadcast", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$sendVvmSmsBroadcast(android.content.Context android.telephony.VisualVoicemailSmsFilterSettings android.telecom.PhoneAccountHandle com.android.internal.telephony.VisualVoicemailSmsParser$WrappedMessageData java.lang.String ), (Context)context, (VisualVoicemailSmsFilterSettings)visualVoicemailSmsFilterSettings, (PhoneAccountHandle)phoneAccountHandle, (VisualVoicemailSmsParser.WrappedMessageData)wrappedMessageData, (String)string2);
    }

    private static FullMessage getFullMessage(byte[][] byArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFullMessage", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$getFullMessage(byte[][] java.lang.String ), (byte[][])byArray, (String)string2);
    }

    private static String parseAsciiPduMessage(byte[][] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseAsciiPduMessage", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$parseAsciiPduMessage(byte[][] ), (byte[][])byArray);
    }

    private static boolean isSmsFromNumbers(SmsMessage smsMessage, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSmsFromNumbers", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter$isSmsFromNumbers(android.telephony.SmsMessage java.util.List<java.lang.String> ), (SmsMessage)smsMessage, list);
    }

    static {
        RobolectricInternals.classInitializing(VisualVoicemailSmsFilter.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VisualVoicemailSmsFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FullMessage
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public SmsMessage firstMessage;
        public String fullMessageBody;

        private void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__() {
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__();
        }

        public FullMessage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__(var1_1);
        }

        public /* synthetic */ FullMessage(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_VisualVoicemailSmsFilter_FullMessage$__constructor__(com.android.internal.telephony.VisualVoicemailSmsFilter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FullMessage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public static interface PhoneAccountHandleConverter {
        public PhoneAccountHandle fromSubId(int var1);
    }
}

