/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.cat.BerTlv;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.CommandParamsFactory;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.RilMessage;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RilMessageDecoder
extends StateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CMD_START = 1;
    private static int CMD_PARAMS_READY = 2;
    private CommandParamsFactory mCmdParamsFactory;
    private RilMessage mCurrentRilMessage;
    private Handler mCaller;
    private static int mSimCount;
    private static RilMessageDecoder[] mInstance;
    private StateStart mStateStart;
    private StateCmdParamsReady mStateCmdParamsReady;

    private static final synchronized RilMessageDecoder $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$getInstance(Handler caller, IccFileHandler fh, int slotId) {
        if (null == mInstance) {
            mSimCount = TelephonyManager.getDefault().getSimCount();
            mInstance = new RilMessageDecoder[mSimCount];
            for (int i = 0; i < mSimCount; ++i) {
                RilMessageDecoder.mInstance[i] = null;
            }
        }
        if (slotId != -1 && slotId < mSimCount) {
            if (null == mInstance[slotId]) {
                RilMessageDecoder.mInstance[slotId] = new RilMessageDecoder(caller, fh);
            }
        } else {
            CatLog.d("RilMessageDecoder", "invaild slot id: " + slotId);
            return null;
        }
        return mInstance[slotId];
    }

    private final void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendStartDecodingMessageParams(RilMessage rilMsg) {
        Message msg = this.obtainMessage(1);
        msg.obj = rilMsg;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendMsgParamsDecoded(ResultCode resCode, CommandParams cmdParams) {
        Message msg = this.obtainMessage(2);
        msg.arg1 = resCode.value();
        msg.obj = cmdParams;
        this.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendCmdForExecution(RilMessage rilMsg) {
        Message msg = this.mCaller.obtainMessage(10, new RilMessage(rilMsg));
        msg.sendToTarget();
    }

    private void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__(Handler caller, IccFileHandler fh) {
        this.mCmdParamsFactory = null;
        this.mCurrentRilMessage = null;
        this.mCaller = null;
        this.mStateStart = new StateStart(this, null);
        this.mStateCmdParamsReady = new StateCmdParamsReady(this, null);
        this.addState(this.mStateStart);
        this.addState(this.mStateCmdParamsReady);
        this.setInitialState(this.mStateStart);
        this.mCaller = caller;
        this.mCmdParamsFactory = CommandParamsFactory.getInstance(this, fh);
    }

    private void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__() {
        this.mCmdParamsFactory = null;
        this.mCurrentRilMessage = null;
        this.mCaller = null;
        this.mStateStart = new StateStart(this, null);
        this.mStateCmdParamsReady = new StateCmdParamsReady(this, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$decodeMessageParams(RilMessage rilMsg) {
        boolean decodingStarted;
        this.mCurrentRilMessage = rilMsg;
        switch (rilMsg.mId) {
            case 1: 
            case 4: {
                this.mCurrentRilMessage.mResCode = ResultCode.OK;
                this.sendCmdForExecution(this.mCurrentRilMessage);
                decodingStarted = false;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                byte[] rawData = null;
                try {
                    rawData = IccUtils.hexStringToBytes((String)rilMsg.mData);
                }
                catch (Exception e) {
                    CatLog.d(this, "decodeMessageParams dropping zombie messages");
                    decodingStarted = false;
                    break;
                }
                try {
                    this.mCmdParamsFactory.make(BerTlv.decode(rawData));
                    decodingStarted = true;
                }
                catch (ResultException e) {
                    CatLog.d(this, "decodeMessageParams: caught ResultException e=" + e);
                    this.mCurrentRilMessage.mResCode = e.result();
                    this.sendCmdForExecution(this.mCurrentRilMessage);
                    decodingStarted = false;
                }
                break;
            }
            default: {
                decodingStarted = false;
            }
        }
        return decodingStarted;
    }

    private final void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$dispose() {
        this.quitNow();
        this.mStateStart = null;
        this.mStateCmdParamsReady = null;
        this.mCmdParamsFactory.dispose();
        this.mCmdParamsFactory = null;
        this.mCurrentRilMessage = null;
        this.mCaller = null;
        mInstance = null;
    }

    static void __staticInitializer__() {
        mSimCount = 0;
        mInstance = null;
    }

    public static synchronized RilMessageDecoder getInstance(Handler handler, IccFileHandler iccFileHandler, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$getInstance(android.os.Handler com.android.internal.telephony.uicc.IccFileHandler int ), (Handler)handler, (IccFileHandler)iccFileHandler, (int)n);
    }

    public void sendStartDecodingMessageParams(RilMessage rilMessage) {
        InvokeDynamicSupport.bootstrap("sendStartDecodingMessageParams", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendStartDecodingMessageParams(com.android.internal.telephony.cat.RilMessage ), this, rilMessage);
    }

    public void sendMsgParamsDecoded(ResultCode resultCode, CommandParams commandParams) {
        InvokeDynamicSupport.bootstrap("sendMsgParamsDecoded", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendMsgParamsDecoded(com.android.internal.telephony.cat.ResultCode com.android.internal.telephony.cat.CommandParams ), this, resultCode, commandParams);
    }

    private void sendCmdForExecution(RilMessage rilMessage) {
        InvokeDynamicSupport.bootstrap("sendCmdForExecution", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$sendCmdForExecution(com.android.internal.telephony.cat.RilMessage ), this, rilMessage);
    }

    private void __constructor__(Handler handler, IccFileHandler iccFileHandler) {
        this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__(handler, iccFileHandler);
    }

    public RilMessageDecoder(Handler handler, IccFileHandler iccFileHandler) {
        super("RilMessageDecoder");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__(android.os.Handler com.android.internal.telephony.uicc.IccFileHandler ), this, handler, iccFileHandler);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__();
    }

    public RilMessageDecoder() {
        super("RilMessageDecoder");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$__constructor__(), this);
    }

    private boolean decodeMessageParams(RilMessage rilMessage) {
        return (boolean)InvokeDynamicSupport.bootstrap("decodeMessageParams", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$decodeMessageParams(com.android.internal.telephony.cat.RilMessage ), this, rilMessage);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder$dispose(), this);
    }

    static {
        RobolectricInternals.classInitializing(RilMessageDecoder.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RilMessageDecoder)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class StateCmdParamsReady
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RilMessageDecoder this$0;

        private void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(RilMessageDecoder rilMessageDecoder) {
            this.this$0 = rilMessageDecoder;
        }

        private final boolean $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$processMessage(Message msg) {
            if (msg.what == 2) {
                ((RilMessageDecoder)this.this$0).mCurrentRilMessage.mResCode = ResultCode.fromInt(msg.arg1);
                ((RilMessageDecoder)this.this$0).mCurrentRilMessage.mData = msg.obj;
                this.this$0.sendCmdForExecution(this.this$0.mCurrentRilMessage);
                this.this$0.transitionTo(this.this$0.mStateStart);
            } else {
                CatLog.d(this, "StateCmdParamsReady expecting CMD_PARAMS_READY=2 got " + msg.what);
                this.this$0.deferMessage(msg);
            }
            return true;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(RilMessageDecoder x0, 1 x1) {
        }

        private void __constructor__(RilMessageDecoder rilMessageDecoder) {
            this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(rilMessageDecoder);
        }

        public StateCmdParamsReady(RilMessageDecoder rilMessageDecoder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(com.android.internal.telephony.cat.RilMessageDecoder ), this, rilMessageDecoder);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(RilMessageDecoder rilMessageDecoder, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(rilMessageDecoder, var2_2);
        }

        public /* synthetic */ StateCmdParamsReady(RilMessageDecoder rilMessageDecoder, 1 var2_2) {
            this(rilMessageDecoder);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateCmdParamsReady$__constructor__(com.android.internal.telephony.cat.RilMessageDecoder com.android.internal.telephony.cat.RilMessageDecoder$1 ), this, rilMessageDecoder, var2_2);
        }

        public /* synthetic */ StateCmdParamsReady() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateCmdParamsReady)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StateStart
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ RilMessageDecoder this$0;

        private void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(RilMessageDecoder rilMessageDecoder) {
            this.this$0 = rilMessageDecoder;
        }

        private final boolean $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$processMessage(Message msg) {
            if (msg.what == 1) {
                if (this.this$0.decodeMessageParams((RilMessage)msg.obj)) {
                    this.this$0.transitionTo(this.this$0.mStateCmdParamsReady);
                }
            } else {
                CatLog.d(this, "StateStart unexpected expecting START=1 got " + msg.what);
            }
            return true;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(RilMessageDecoder x0, 1 x1) {
        }

        private void __constructor__(RilMessageDecoder rilMessageDecoder) {
            this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(rilMessageDecoder);
        }

        public StateStart(RilMessageDecoder rilMessageDecoder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(com.android.internal.telephony.cat.RilMessageDecoder ), this, rilMessageDecoder);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(RilMessageDecoder rilMessageDecoder, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(rilMessageDecoder, var2_2);
        }

        public /* synthetic */ StateStart(RilMessageDecoder rilMessageDecoder, 1 var2_2) {
            this(rilMessageDecoder);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_RilMessageDecoder_StateStart$__constructor__(com.android.internal.telephony.cat.RilMessageDecoder com.android.internal.telephony.cat.RilMessageDecoder$1 ), this, rilMessageDecoder, var2_2);
        }

        public /* synthetic */ StateStart() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateStart)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

