/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.content.Context;
import android.net.KeepalivePacketData;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StringNetworkSpecifier;
import android.os.AsyncResult;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Pair;
import android.util.SparseArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.LinkCapacityEstimate;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataServiceManager;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.KeepaliveStatus;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DataConnection
extends StateMachine
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static boolean VDBG = true;
    private static String NETWORK_TYPE = "MOBILE";
    private DcController mDcController;
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private static AtomicInteger mInstanceNumber;
    private AsyncChannel mAc;
    private DcTracker mDct;
    protected String[] mPcscfAddr;
    private ApnSetting mApnSetting;
    private ConnectionParams mConnectionParams;
    private DisconnectParams mDisconnectParams;
    private DcFailCause mDcFailCause;
    private Phone mPhone;
    private DataServiceManager mDataServiceManager;
    private LinkProperties mLinkProperties;
    private long mCreateTime;
    private long mLastFailTime;
    private DcFailCause mLastFailCause;
    private static String NULL_IP = "0.0.0.0";
    private Object mUserData;
    private int mSubscriptionOverride;
    private int mRilRat;
    private int mDataRegState;
    private NetworkInfo mNetworkInfo;
    private DcNetworkAgent mNetworkAgent;
    private LocalLog mNetCapsLocalLog;
    int mTag;
    public int mCid;
    public HashMap<ApnContext, ConnectionParams> mApnContexts;
    PendingIntent mReconnectIntent;
    static int BASE = 262144;
    static int EVENT_CONNECT = 262144;
    static int EVENT_SETUP_DATA_CONNECTION_DONE = 262145;
    static int EVENT_DEACTIVATE_DONE = 262147;
    static int EVENT_DISCONNECT = 262148;
    static int EVENT_RIL_CONNECTED = 262149;
    static int EVENT_DISCONNECT_ALL = 262150;
    static int EVENT_DATA_STATE_CHANGED = 262151;
    static int EVENT_TEAR_DOWN_NOW = 262152;
    static int EVENT_LOST_CONNECTION = 262153;
    static int EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED = 262155;
    static int EVENT_DATA_CONNECTION_ROAM_ON = 262156;
    static int EVENT_DATA_CONNECTION_ROAM_OFF = 262157;
    static int EVENT_BW_REFRESH_RESPONSE = 262158;
    static int EVENT_DATA_CONNECTION_VOICE_CALL_STARTED = 262159;
    static int EVENT_DATA_CONNECTION_VOICE_CALL_ENDED = 262160;
    static int EVENT_DATA_CONNECTION_OVERRIDE_CHANGED = 262161;
    static int EVENT_KEEPALIVE_STATUS = 262162;
    static int EVENT_KEEPALIVE_STARTED = 262163;
    static int EVENT_KEEPALIVE_STOPPED = 262164;
    static int EVENT_KEEPALIVE_START_REQUEST = 262165;
    static int EVENT_KEEPALIVE_STOP_REQUEST = 262166;
    static int EVENT_LINK_CAPACITY_CHANGED = 262167;
    private static int CMD_TO_STRING_COUNT = 24;
    private static String[] sCmdToString;
    private int mId;
    private static String TCP_BUFFER_SIZES_GPRS = "4092,8760,48000,4096,8760,48000";
    private static String TCP_BUFFER_SIZES_EDGE = "4093,26280,70800,4096,16384,70800";
    private static String TCP_BUFFER_SIZES_UMTS = "58254,349525,1048576,58254,349525,1048576";
    private static String TCP_BUFFER_SIZES_1XRTT = "16384,32768,131072,4096,16384,102400";
    private static String TCP_BUFFER_SIZES_EVDO = "4094,87380,262144,4096,16384,262144";
    private static String TCP_BUFFER_SIZES_EHRPD = "131072,262144,1048576,4096,16384,524288";
    private static String TCP_BUFFER_SIZES_HSDPA = "61167,367002,1101005,8738,52429,262114";
    private static String TCP_BUFFER_SIZES_HSPA = "40778,244668,734003,16777,100663,301990";
    private static String TCP_BUFFER_SIZES_LTE = "524288,1048576,2097152,262144,524288,1048576";
    private static String TCP_BUFFER_SIZES_HSPAP = "122334,734003,2202010,32040,192239,576717";
    private boolean mRestrictedNetworkOverride;
    private DcDefaultState mDefaultState;
    private DcInactiveState mInactiveState;
    private DcActivatingState mActivatingState;
    private DcActiveState mActiveState;
    private DcDisconnectingState mDisconnectingState;
    private DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection;

    private static final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$cmdToString(int cmd) {
        String value;
        if ((value = (cmd -= 262144) >= 0 && cmd < sCmdToString.length ? sCmdToString[cmd] : DcAsyncChannel.cmdToString(cmd + 262144)) == null) {
            value = "0x" + Integer.toHexString(cmd + 262144);
        }
        return value;
    }

    private static final DataConnection $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeDataConnection(Phone phone, int id2, DcTracker dct, DataServiceManager dataServiceManager, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        DataConnection dc = new DataConnection(phone, "DC-" + mInstanceNumber.incrementAndGet(), id2, dct, dataServiceManager, failBringUpAll, dcc);
        dc.start();
        dc.log("Made " + dc.getName());
        return dc;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dispose() {
        this.log("dispose: call quiteNow()");
        this.quitNow();
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isInactive() {
        return this.getCurrentState() == this.mInactiveState;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDisconnecting() {
        return this.getCurrentState() == this.mDisconnectingState;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isActive() {
        return this.getCurrentState() == this.mActiveState;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isActivating() {
        return this.getCurrentState() == this.mActivatingState;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCid() {
        return this.mCid;
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getApnSetting() {
        return this.mApnSetting;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkPropertiesHttpProxy(ProxyInfo proxy) {
        this.mLinkProperties.setHttpProxy(proxy);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv4Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet4Address i4addr;
            if (!(addr instanceof Inet4Address) || (i4addr = (Inet4Address)addr).isAnyLocalAddress() || i4addr.isLinkLocalAddress() || i4addr.isLoopbackAddress() || i4addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv6Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet6Address i6addr;
            if (!(addr instanceof Inet6Address) || (i6addr = (Inet6Address)addr).isAnyLocalAddress() || i6addr.isLinkLocalAddress() || i6addr.isLoopbackAddress() || i6addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @VisibleForTesting
    private final UpdateLinkPropertyResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateLinkProperty(DataCallResponse newState) {
        UpdateLinkPropertyResult result = new UpdateLinkPropertyResult(this.mLinkProperties);
        if (newState == null) {
            return result;
        }
        result.newLp = new LinkProperties();
        result.setupResult = this.setLinkProperties(newState, result.newLp);
        if (result.setupResult != SetupResult.SUCCESS) {
            this.log("updateLinkProperty failed : " + (Object)((Object)result.setupResult));
            return result;
        }
        result.newLp.setHttpProxy(this.mLinkProperties.getHttpProxy());
        this.checkSetMtu(this.mApnSetting, result.newLp);
        this.mLinkProperties = result.newLp;
        this.updateTcpBufferSizes(this.mRilRat);
        if (!result.oldLp.equals(result.newLp)) {
            this.log("updateLinkProperty old LP=" + result.oldLp);
            this.log("updateLinkProperty new LP=" + result.newLp);
        }
        if (!result.newLp.equals(result.oldLp) && this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.mLinkProperties);
        }
        return result;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$checkSetMtu(ApnSetting apn, LinkProperties lp) {
        if (lp == null) {
            return;
        }
        if (apn == null || lp == null) {
            return;
        }
        if (lp.getMtu() != 0) {
            this.log("MTU set by call response to: " + lp.getMtu());
            return;
        }
        if (apn != null && apn.mtu != 0) {
            lp.setMtu(apn.mtu);
            this.log("MTU set by APN to: " + apn.mtu);
            return;
        }
        int mtu = this.mPhone.getContext().getResources().getInteger(17694821);
        if (mtu != 0) {
            lp.setMtu(mtu);
            this.log("MTU set by config resource to: " + mtu);
        }
    }

    private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(Phone phone, String name, int id2, DcTracker dct, DataServiceManager dataServiceManager, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        this.mDct = null;
        this.mLinkProperties = new LinkProperties();
        this.mRilRat = Integer.MAX_VALUE;
        this.mDataRegState = Integer.MAX_VALUE;
        this.mNetCapsLocalLog = new LocalLog(50);
        this.mApnContexts = null;
        this.mReconnectIntent = null;
        this.mRestrictedNetworkOverride = false;
        this.mDefaultState = new DcDefaultState(this, null);
        this.mInactiveState = new DcInactiveState(this, null);
        this.mActivatingState = new DcActivatingState(this, null);
        this.mActiveState = new DcActiveState(this, null);
        this.mDisconnectingState = new DcDisconnectingState(this, null);
        this.mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection(this, null);
        this.setLogRecSize(300);
        this.setLogOnlyTransitions(true);
        this.log("DataConnection created");
        this.mPhone = phone;
        this.mDct = dct;
        this.mDataServiceManager = dataServiceManager;
        this.mDcTesterFailBringUpAll = failBringUpAll;
        this.mDcController = dcc;
        this.mId = id2;
        this.mCid = -1;
        ServiceState ss = this.mPhone.getServiceState();
        this.mRilRat = ss.getRilDataRadioTechnology();
        this.mDataRegState = this.mPhone.getServiceState().getDataRegState();
        int networkType = ss.getDataNetworkType();
        this.mNetworkInfo = new NetworkInfo(0, networkType, "MOBILE", TelephonyManager.getNetworkTypeName(networkType));
        this.mNetworkInfo.setRoaming(ss.getDataRoaming());
        this.mNetworkInfo.setIsAvailable(true);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.mApnContexts = new HashMap();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onConnect(ConnectionParams cp) {
        this.log("onConnect: carrier='" + this.mApnSetting.carrier + "' APN='" + this.mApnSetting.apn + "' proxy='" + this.mApnSetting.proxy + "' port='" + this.mApnSetting.port + "'");
        if (cp.mApnContext != null) {
            cp.mApnContext.requestLog("DataConnection.onConnect");
        }
        if (this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter > 0) {
            DataCallResponse response = new DataCallResponse(this.mDcTesterFailBringUpAll.getDcFailBringUp().mFailCause.getErrorCode(), this.mDcTesterFailBringUpAll.getDcFailBringUp().mSuggestedRetryTime, 0, 0, "", "", null, null, null, null, 0);
            Message msg = this.obtainMessage(262145, cp);
            AsyncResult.forMessage(msg, response, null);
            this.sendMessage(msg);
            this.log("onConnect: FailBringUpAll=" + this.mDcTesterFailBringUpAll.getDcFailBringUp() + " send error response=" + response);
            --this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter;
            return;
        }
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        DataProfile dp = DcTracker.createDataProfile(this.mApnSetting, cp.mProfileId);
        boolean isModemRoaming = this.mPhone.getServiceState().getDataRoamingFromRegistration();
        boolean allowRoaming = this.mPhone.getDataRoamingEnabled() || isModemRoaming && !this.mPhone.getServiceState().getDataRoaming();
        this.mDataServiceManager.setupDataCall(ServiceState.rilRadioTechnologyToAccessNetworkType(cp.mRilRat), dp, isModemRoaming, allowRoaming, 1, null, msg);
        TelephonyMetrics.getInstance().writeSetupDataCall(this.mPhone.getPhoneId(), cp.mRilRat, dp.getProfileId(), dp.getApn(), dp.getProtocol());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSubscriptionOverride(int overrideMask, int overrideValue) {
        this.mSubscriptionOverride = this.mSubscriptionOverride & ~overrideMask | overrideValue & overrideMask;
        this.sendMessage(this.obtainMessage(262161));
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownData(Object o) {
        int discReason = 1;
        ApnContext apnContext = null;
        if (o != null && o instanceof DisconnectParams) {
            DisconnectParams dp = (DisconnectParams)o;
            apnContext = dp.mApnContext;
            if (TextUtils.equals(dp.mReason, "radioTurnedOff") || TextUtils.equals(dp.mReason, "pdpReset")) {
                discReason = 2;
            }
        }
        String str = "tearDownData. mCid=" + this.mCid + ", reason=" + discReason;
        this.log(str);
        if (apnContext != null) {
            apnContext.requestLog(str);
        }
        this.mDataServiceManager.deactivateDataCall(this.mCid, discReason, this.obtainMessage(262147, this.mTag, 0, o));
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllWithEvent(ApnContext alreadySent, int event, String reason) {
        this.mNetworkInfo.setDetailedState(this.mNetworkInfo.getDetailedState(), reason, this.mNetworkInfo.getExtraInfo());
        for (ConnectionParams cp : this.mApnContexts.values()) {
            ApnContext apnContext = cp.mApnContext;
            if (apnContext == alreadySent) continue;
            if (reason != null) {
                apnContext.setReason(reason);
            }
            Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, cp.mConnectionGeneration);
            Message msg = this.mDct.obtainMessage(event, pair);
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfConnected(String reason) {
        this.notifyAllWithEvent(null, 270336, reason);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfDisconnectDcRetrying(String reason) {
        this.notifyAllWithEvent(null, 270370, reason);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllDisconnectCompleted(DcFailCause cause) {
        this.notifyAllWithEvent(null, 270351, cause.toString());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyConnectCompleted(ConnectionParams cp, DcFailCause cause, boolean sendAll) {
        ApnContext alreadySent = null;
        if (cp != null && cp.mOnCompletedMsg != null) {
            Message connectionCompletedMsg = cp.mOnCompletedMsg;
            cp.mOnCompletedMsg = null;
            alreadySent = cp.mApnContext;
            CallSite timeStamp = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            connectionCompletedMsg.arg1 = this.mCid;
            if (cause == DcFailCause.NONE) {
                this.mCreateTime = (long)timeStamp;
                AsyncResult.forMessage(connectionCompletedMsg);
            } else {
                this.mLastFailCause = cause;
                this.mLastFailTime = (long)timeStamp;
                if (cause == null) {
                    cause = DcFailCause.UNKNOWN;
                }
                AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new Throwable(cause.toString()));
            }
            this.log("notifyConnectCompleted at " + (long)timeStamp + " cause=" + (Object)((Object)cause) + " connectionCompletedMsg=" + DataConnection.msgToString(connectionCompletedMsg));
            connectionCompletedMsg.sendToTarget();
        }
        if (sendAll) {
            this.log("Send to all. " + alreadySent + " " + cause.toString());
            this.notifyAllWithEvent(alreadySent, 270371, cause.toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyDisconnectCompleted(DisconnectParams dp, boolean sendAll) {
        this.log("NotifyDisconnectCompleted");
        ApnContext alreadySent = null;
        String reason = null;
        if (dp != null && dp.mOnCompletedMsg != null) {
            Message msg = dp.mOnCompletedMsg;
            dp.mOnCompletedMsg = null;
            if (msg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)msg.obj;
            }
            reason = dp.mReason;
            this.log(String.format("msg=%s msg.obj=%s", msg.toString(), msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (sendAll) {
            if (reason == null) {
                reason = DcFailCause.UNKNOWN.toString();
            }
            this.notifyAllWithEvent(alreadySent, 270351, reason);
        }
        this.log("NotifyDisconnectCompleted DisconnectParams=" + dp);
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getDataConnectionId() {
        return this.mId;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$clearSettings() {
        this.log("clearSettings");
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        this.mCid = -1;
        this.mPcscfAddr = new String[5];
        this.mLinkProperties = new LinkProperties();
        this.mApnContexts.clear();
        this.mApnSetting = null;
        this.mDcFailCause = null;
    }

    private final SetupResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSetupConnectionCompleted(int resultCode, DataCallResponse response, ConnectionParams cp) {
        SetupResult result;
        if (cp.mTag != this.mTag) {
            this.log("onSetupConnectionCompleted stale cp.tag=" + cp.mTag + ", mtag=" + this.mTag);
            result = SetupResult.ERROR_STALE;
        } else if (resultCode == 4) {
            result = SetupResult.ERROR_RADIO_NOT_AVAILABLE;
            result.mFailCause = DcFailCause.RADIO_NOT_AVAILABLE;
        } else if (response.getStatus() != 0) {
            if (response.getStatus() == DcFailCause.RADIO_NOT_AVAILABLE.getErrorCode()) {
                result = SetupResult.ERROR_RADIO_NOT_AVAILABLE;
                result.mFailCause = DcFailCause.RADIO_NOT_AVAILABLE;
            } else {
                result = SetupResult.ERROR_DATA_SERVICE_SPECIFIC_ERROR;
                result.mFailCause = DcFailCause.fromInt(response.getStatus());
            }
        } else {
            this.log("onSetupConnectionCompleted received successful DataCallResponse");
            this.mCid = response.getCallId();
            this.mPcscfAddr = response.getPcscfs().toArray(new String[response.getPcscfs().size()]);
            result = this.updateLinkProperty((DataCallResponse)response).setupResult;
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDnsOk(String[] domainNameServers) {
        if (!(!"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || this.mPhone.isDnsCheckDisabled() || this.mApnSetting.types[0].equals("mms") && DataConnection.isIpAddress(this.mApnSetting.mmsProxy))) {
            this.log(String.format("isDnsOk: return false apn.types[0]=%s APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.mApnSetting.types[0], "mms", this.mApnSetting.mmsProxy, DataConnection.isIpAddress(this.mApnSetting.mmsProxy)));
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateTcpBufferSizes(int rilRat) {
        String sizes = null;
        if (rilRat == 19) {
            rilRat = 14;
        }
        String ratName = ServiceState.rilRadioTechnologyToString(rilRat).toLowerCase(Locale.ROOT);
        if (rilRat == 7 || rilRat == 8 || rilRat == 12) {
            ratName = "evdo";
        }
        String[] configOverride = this.mPhone.getContext().getResources().getStringArray(17236022);
        for (int i = 0; i < configOverride.length; ++i) {
            String[] split = configOverride[i].split(":");
            if (!ratName.equals(split[0]) || split.length != 2) continue;
            sizes = split[1];
            break;
        }
        if (sizes == null) {
            switch (rilRat) {
                case 1: {
                    sizes = "4092,8760,48000,4096,8760,48000";
                    break;
                }
                case 2: {
                    sizes = "4093,26280,70800,4096,16384,70800";
                    break;
                }
                case 3: {
                    sizes = "58254,349525,1048576,58254,349525,1048576";
                    break;
                }
                case 6: {
                    sizes = "16384,32768,131072,4096,16384,102400";
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    sizes = "4094,87380,262144,4096,16384,262144";
                    break;
                }
                case 13: {
                    sizes = "131072,262144,1048576,4096,16384,524288";
                    break;
                }
                case 9: {
                    sizes = "61167,367002,1101005,8738,52429,262114";
                    break;
                }
                case 10: 
                case 11: {
                    sizes = "40778,244668,734003,16777,100663,301990";
                    break;
                }
                case 14: 
                case 19: {
                    sizes = "524288,1048576,2097152,262144,524288,1048576";
                    break;
                }
                case 15: {
                    sizes = "122334,734003,2202010,32040,192239,576717";
                    break;
                }
            }
        }
        this.mLinkProperties.setTcpBufferSizes(sizes);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setNetworkRestriction() {
        this.mRestrictedNetworkOverride = false;
        boolean noRestrictedRequests = true;
        for (ApnContext apnContext : this.mApnContexts.keySet()) {
            noRestrictedRequests &= apnContext.hasNoRestrictedRequests(true);
        }
        if (noRestrictedRequests) {
            return;
        }
        if (!this.mApnSetting.isMetered(this.mPhone)) {
            return;
        }
        this.mRestrictedNetworkOverride = !this.mDct.isDataEnabled();
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getNetworkCapabilities() {
        NetworkCapabilities result = new NetworkCapabilities();
        result.addTransportType(0);
        if (this.mApnSetting != null) {
            block41: for (String type : this.mApnSetting.types) {
                if (!this.mRestrictedNetworkOverride && this.mConnectionParams != null && this.mConnectionParams.mUnmeteredUseOnly && ApnSetting.isMeteredApnType(type, this.mPhone)) {
                    this.log("Dropped the metered " + type + " for the unmetered data call.");
                    continue;
                }
                switch (type) {
                    case "*": {
                        result.addCapability(12);
                        result.addCapability(0);
                        result.addCapability(1);
                        result.addCapability(3);
                        result.addCapability(4);
                        result.addCapability(5);
                        result.addCapability(7);
                        result.addCapability(2);
                        continue block41;
                    }
                    case "default": {
                        result.addCapability(12);
                        continue block41;
                    }
                    case "mms": {
                        result.addCapability(0);
                        continue block41;
                    }
                    case "supl": {
                        result.addCapability(1);
                        continue block41;
                    }
                    case "dun": {
                        result.addCapability(2);
                        continue block41;
                    }
                    case "fota": {
                        result.addCapability(3);
                        continue block41;
                    }
                    case "ims": {
                        result.addCapability(4);
                        continue block41;
                    }
                    case "cbs": {
                        result.addCapability(5);
                        continue block41;
                    }
                    case "ia": {
                        result.addCapability(7);
                        continue block41;
                    }
                    case "emergency": {
                        result.addCapability(10);
                        continue block41;
                    }
                }
            }
            if (this.mConnectionParams != null && this.mConnectionParams.mUnmeteredUseOnly && !this.mRestrictedNetworkOverride || !this.mApnSetting.isMetered(this.mPhone)) {
                result.addCapability(11);
            } else {
                result.removeCapability(11);
            }
            result.maybeMarkCapabilitiesRestricted();
        }
        if (this.mRestrictedNetworkOverride) {
            result.removeCapability(13);
            result.removeCapability(2);
        }
        int up = 14;
        int down = 14;
        switch (this.mRilRat) {
            case 1: {
                up = 80;
                down = 80;
                break;
            }
            case 2: {
                up = 59;
                down = 236;
                break;
            }
            case 3: {
                up = 384;
                down = 384;
                break;
            }
            case 4: 
            case 5: {
                up = 14;
                down = 14;
                break;
            }
            case 7: {
                up = 153;
                down = 2457;
                break;
            }
            case 8: {
                up = 1843;
                down = 3174;
                break;
            }
            case 6: {
                up = 100;
                down = 100;
                break;
            }
            case 9: {
                up = 2048;
                down = 14336;
                break;
            }
            case 10: {
                up = 5898;
                down = 14336;
                break;
            }
            case 11: {
                up = 5898;
                down = 14336;
                break;
            }
            case 12: {
                up = 1843;
                down = 5017;
                break;
            }
            case 14: {
                up = 51200;
                down = 102400;
                break;
            }
            case 19: {
                up = 51200;
                down = 102400;
                break;
            }
            case 13: {
                up = 153;
                down = 2516;
                break;
            }
            case 15: {
                up = 11264;
                down = 43008;
                break;
            }
        }
        result.setLinkUpstreamBandwidthKbps(up);
        result.setLinkDownstreamBandwidthKbps(down);
        result.setNetworkSpecifier(new StringNetworkSpecifier(Integer.toString(this.mPhone.getSubId())));
        result.setCapability(18, !this.mPhone.getServiceState().getDataRoaming());
        result.addCapability(20);
        if ((this.mSubscriptionOverride & 1) != 0) {
            result.addCapability(11);
        }
        if ((this.mSubscriptionOverride & 2) != 0) {
            result.removeCapability(20);
        }
        return result;
    }

    @VisibleForTesting
    private static final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return InetAddress.isNumeric((String)address);
    }

    private final SetupResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkProperties(DataCallResponse response, LinkProperties linkProperties) {
        SetupResult result;
        String propertyPrefix = "net." + response.getIfname() + ".";
        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
        boolean okToUseSystemPropertyDns = this.isDnsOk(dnsServers);
        linkProperties.clear();
        if (response.getStatus() == DcFailCause.NONE.getErrorCode()) {
            try {
                linkProperties.setInterfaceName(response.getIfname());
                if (response.getAddresses().size() > 0) {
                    for (LinkAddress la : response.getAddresses()) {
                        if (la.getAddress().isAnyLocalAddress()) continue;
                        this.log("addr/pl=" + la.getAddress() + "/" + la.getNetworkPrefixLength());
                        linkProperties.addLinkAddress(la);
                    }
                } else {
                    throw new UnknownHostException("no address for ifname=" + response.getIfname());
                }
                if (response.getDnses().size() > 0) {
                    for (InetAddress dns : response.getDnses()) {
                        if (dns.isAnyLocalAddress()) continue;
                        linkProperties.addDnsServer(dns);
                    }
                } else if (okToUseSystemPropertyDns) {
                    for (String string2 : dnsServers) {
                        InetAddress ia;
                        String string3 = string2.trim();
                        if (string3.isEmpty()) continue;
                        try {
                            ia = NetworkUtils.numericToInetAddress(string3);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric dns addr=" + string3);
                        }
                        if (ia.isAnyLocalAddress()) continue;
                        linkProperties.addDnsServer(ia);
                    }
                } else {
                    throw new UnknownHostException("Empty dns response and no system default dns");
                }
                for (InetAddress gateway : response.getGateways()) {
                    linkProperties.addRoute(new RouteInfo(gateway));
                }
                linkProperties.setMtu(response.getMtu());
                result = SetupResult.SUCCESS;
            }
            catch (UnknownHostException e) {
                this.log("setLinkProperties: UnknownHostException " + e);
                result = SetupResult.ERROR_INVALID_ARG;
            }
        } else {
            result = SetupResult.ERROR_DATA_SERVICE_SPECIFIC_ERROR;
        }
        if (result != SetupResult.SUCCESS) {
            this.log("setLinkProperties: error clearing LinkProperties status=" + response.getStatus() + " result=" + (Object)((Object)result));
            linkProperties.clear();
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection$initConnection(ConnectionParams cp) {
        ApnContext apnContext = cp.mApnContext;
        if (this.mApnSetting == null) {
            this.mApnSetting = apnContext.getApnSetting();
        }
        if (this.mApnSetting == null || !this.mApnSetting.canHandleType(apnContext.getApnType())) {
            this.log("initConnection: incompatible apnSetting in ConnectionParams cp=" + cp + " dc=" + this);
            return false;
        }
        ++this.mTag;
        this.mConnectionParams = cp;
        this.mConnectionParams.mTag = this.mTag;
        this.mApnContexts.put(apnContext, cp);
        this.log("initConnection:  RefCount=" + this.mApnContexts.size() + " mApnList=" + this.mApnContexts + " mConnectionParams=" + this.mConnectionParams);
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateNetworkInfo() {
        ServiceState state = this.mPhone.getServiceState();
        int subtype = state.getDataNetworkType();
        this.mNetworkInfo.setSubtype(subtype, TelephonyManager.getNetworkTypeName(subtype));
        this.mNetworkInfo.setRoaming(state.getDataRoaming());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateNetworkInfoSuspendState() {
        ServiceStateTracker sst;
        if (this.mNetworkAgent == null) {
            Rlog.e(this.getName(), "Setting suspend state without a NetworkAgent");
        }
        if ((sst = this.mPhone.getServiceStateTracker()).getCurrentDataConnectionState() != 0) {
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
        } else {
            CallTracker ct;
            if (!sst.isConcurrentVoiceAndDataAllowed() && (ct = this.mPhone.getCallTracker()).getState() != PhoneConstants.State.IDLE) {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
                return;
            }
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, this.mNetworkInfo.getExtraInfo());
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownNow() {
        this.log("tearDownNow()");
        this.sendMessage(this.obtainMessage(262152));
    }

    private final long $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getSuggestedRetryDelay(DataCallResponse response) {
        if (response.getSuggestedRetryTime() < 0) {
            this.log("No suggested retry delay.");
            return -2L;
        }
        if (response.getSuggestedRetryTime() == Integer.MAX_VALUE) {
            this.log("Modem suggested not retrying.");
            return -1L;
        }
        return response.getSuggestedRetryTime();
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getWhatToString(int what) {
        return DataConnection.cmdToString(what);
    }

    private static final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$msgToString(Message msg) {
        String retVal;
        if (msg == null) {
            retVal = "null";
        } else {
            StringBuilder b = new StringBuilder();
            b.append("{what=");
            b.append(DataConnection.cmdToString(msg.what));
            b.append(" when=");
            TimeUtils.formatDuration(msg.getWhen() - SystemClock.uptimeMillis(), b);
            if (msg.arg1 != 0) {
                b.append(" arg1=");
                b.append(msg.arg1);
            }
            if (msg.arg2 != 0) {
                b.append(" arg2=");
                b.append(msg.arg2);
            }
            if (msg.obj != null) {
                b.append(" obj=");
                b.append(msg.obj);
            }
            b.append(" target=");
            b.append(msg.getTarget());
            b.append(" replyTo=");
            b.append(msg.replyTo);
            b.append("}");
            retVal = b.toString();
        }
        return retVal;
    }

    private static final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$slog(String s) {
        Rlog.d("DC", s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$log(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logd(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logv(String s) {
        Rlog.v(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logi(String s) {
        Rlog.i(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logw(String s) {
        Rlog.w(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(String s) {
        Rlog.e(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toStringSimple() {
        return this.getName() + ": State=" + this.getCurrentState().getName() + " mApnSetting=" + this.mApnSetting + " RefCount=" + this.mApnContexts.size() + " mCid=" + this.mCid + " mCreateTime=" + this.mCreateTime + " mLastastFailTime=" + this.mLastFailTime + " mLastFailCause=" + (Object)((Object)this.mLastFailCause) + " mTag=" + this.mTag + " mLinkProperties=" + this.mLinkProperties + " linkCapabilities=" + this.getNetworkCapabilities() + " mRestrictedNetworkOverride=" + this.mRestrictedNetworkOverride;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toString() {
        return "{" + this.toStringSimple() + " mApnContexts=" + this.mApnContexts + "}";
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dumpToLog() {
        this.dump(null, (PrintWriter)new ShadowedObject(this, new StringWriter(0)){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DataConnection this$0;

            private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$__constructor__(DataConnection this$0, Writer x0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$println(String s) {
                this.this$0.logd(s);
            }

            private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$flush() {
            }

            private void __constructor__(DataConnection dataConnection, Writer writer) {
                this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$__constructor__(dataConnection, writer);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$__constructor__(com.android.internal.telephony.dataconnection.DataConnection java.io.Writer ), this, dataConnection, writer);
            }

            @Override
            public void println(String string2) {
                InvokeDynamicSupport.bootstrap("println", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$println(java.lang.String ), this, string2);
            }

            @Override
            public void flush() {
                InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_1$flush(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, " ");
        pw.print("DataConnection ");
        super.dump(fd, pw, args);
        pw.flush();
        pw.increaseIndent();
        pw.println("mApnContexts.size=" + this.mApnContexts.size());
        pw.println("mApnContexts=" + this.mApnContexts);
        pw.println("mDataConnectionTracker=" + this.mDct);
        pw.println("mApnSetting=" + this.mApnSetting);
        pw.println("mTag=" + this.mTag);
        pw.println("mCid=" + this.mCid);
        pw.println("mConnectionParams=" + this.mConnectionParams);
        pw.println("mDisconnectParams=" + this.mDisconnectParams);
        pw.println("mDcFailCause=" + (Object)((Object)this.mDcFailCause));
        pw.println("mPhone=" + this.mPhone);
        pw.println("mLinkProperties=" + this.mLinkProperties);
        pw.flush();
        pw.println("mDataRegState=" + this.mDataRegState);
        pw.println("mRilRat=" + this.mRilRat);
        pw.println("mNetworkCapabilities=" + this.getNetworkCapabilities());
        pw.println("mCreateTime=" + TimeUtils.logTimeOfDay(this.mCreateTime));
        pw.println("mLastFailTime=" + TimeUtils.logTimeOfDay(this.mLastFailTime));
        pw.println("mLastFailCause=" + (Object)((Object)this.mLastFailCause));
        pw.println("mUserData=" + this.mUserData);
        pw.println("mSubscriptionOverride=" + Integer.toHexString(this.mSubscriptionOverride));
        pw.println("mInstanceNumber=" + mInstanceNumber);
        pw.println("mAc=" + this.mAc);
        pw.println("Network capabilities changed history:");
        pw.increaseIndent();
        this.mNetCapsLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
        pw.decreaseIndent();
        pw.println();
        pw.flush();
    }

    static void __staticInitializer__() {
        mInstanceNumber = new AtomicInteger(0);
        sCmdToString = new String[24];
        DataConnection.sCmdToString[0] = "EVENT_CONNECT";
        DataConnection.sCmdToString[1] = "EVENT_SETUP_DATA_CONNECTION_DONE";
        DataConnection.sCmdToString[3] = "EVENT_DEACTIVATE_DONE";
        DataConnection.sCmdToString[4] = "EVENT_DISCONNECT";
        DataConnection.sCmdToString[5] = "EVENT_RIL_CONNECTED";
        DataConnection.sCmdToString[6] = "EVENT_DISCONNECT_ALL";
        DataConnection.sCmdToString[7] = "EVENT_DATA_STATE_CHANGED";
        DataConnection.sCmdToString[8] = "EVENT_TEAR_DOWN_NOW";
        DataConnection.sCmdToString[9] = "EVENT_LOST_CONNECTION";
        DataConnection.sCmdToString[11] = "EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED";
        DataConnection.sCmdToString[12] = "EVENT_DATA_CONNECTION_ROAM_ON";
        DataConnection.sCmdToString[13] = "EVENT_DATA_CONNECTION_ROAM_OFF";
        DataConnection.sCmdToString[14] = "EVENT_BW_REFRESH_RESPONSE";
        DataConnection.sCmdToString[15] = "EVENT_DATA_CONNECTION_VOICE_CALL_STARTED";
        DataConnection.sCmdToString[16] = "EVENT_DATA_CONNECTION_VOICE_CALL_ENDED";
        DataConnection.sCmdToString[17] = "EVENT_DATA_CONNECTION_OVERRIDE_CHANGED";
        DataConnection.sCmdToString[18] = "EVENT_KEEPALIVE_STATUS";
        DataConnection.sCmdToString[19] = "EVENT_KEEPALIVE_STARTED";
        DataConnection.sCmdToString[20] = "EVENT_KEEPALIVE_STOPPED";
        DataConnection.sCmdToString[21] = "EVENT_KEEPALIVE_START_REQUEST";
        DataConnection.sCmdToString[22] = "EVENT_KEEPALIVE_STOP_REQUEST";
        DataConnection.sCmdToString[23] = "EVENT_LINK_CAPACITY_CHANGED";
    }

    static String cmdToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("cmdToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$cmdToString(int ), (int)n);
    }

    public static DataConnection makeDataConnection(Phone phone, int n, DcTracker dcTracker, DataServiceManager dataServiceManager, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        return InvokeDynamicSupport.bootstrapStatic("makeDataConnection", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$makeDataConnection(com.android.internal.telephony.Phone int com.android.internal.telephony.dataconnection.DcTracker com.android.internal.telephony.dataconnection.DataServiceManager com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll com.android.internal.telephony.dataconnection.DcController ), (Phone)phone, (int)n, (DcTracker)dcTracker, (DataServiceManager)dataServiceManager, (DcTesterFailBringUpAll)dcTesterFailBringUpAll, (DcController)dcController);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dispose(), this);
    }

    LinkProperties getCopyLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getCopyLinkProperties", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCopyLinkProperties(), this);
    }

    boolean isInactive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInactive", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isInactive(), this);
    }

    boolean isDisconnecting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisconnecting", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDisconnecting(), this);
    }

    boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isActive(), this);
    }

    boolean isActivating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivating", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isActivating(), this);
    }

    int getCid() {
        return (int)InvokeDynamicSupport.bootstrap("getCid", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getCid(), this);
    }

    ApnSetting getApnSetting() {
        return InvokeDynamicSupport.bootstrap("getApnSetting", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getApnSetting(), this);
    }

    void setLinkPropertiesHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setLinkPropertiesHttpProxy", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkPropertiesHttpProxy(android.net.ProxyInfo ), this, proxyInfo);
    }

    public boolean isIpv4Connected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIpv4Connected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv4Connected(), this);
    }

    public boolean isIpv6Connected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIpv6Connected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpv6Connected(), this);
    }

    public UpdateLinkPropertyResult updateLinkProperty(DataCallResponse dataCallResponse) {
        return InvokeDynamicSupport.bootstrap("updateLinkProperty", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateLinkProperty(android.telephony.data.DataCallResponse ), this, dataCallResponse);
    }

    private void checkSetMtu(ApnSetting apnSetting, LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("checkSetMtu", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$checkSetMtu(com.android.internal.telephony.dataconnection.ApnSetting android.net.LinkProperties ), this, apnSetting, linkProperties);
    }

    private void __constructor__(Phone phone, String string2, int n, DcTracker dcTracker, DataServiceManager dataServiceManager, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(phone, string2, n, dcTracker, dataServiceManager, dcTesterFailBringUpAll, dcController);
    }

    public DataConnection(Phone phone, String string2, int n, DcTracker dcTracker, DataServiceManager dataServiceManager, DcTesterFailBringUpAll dcTesterFailBringUpAll, DcController dcController) {
        super(string2, dcController.getHandler());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$__constructor__(com.android.internal.telephony.Phone java.lang.String int com.android.internal.telephony.dataconnection.DcTracker com.android.internal.telephony.dataconnection.DataServiceManager com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll com.android.internal.telephony.dataconnection.DcController ), this, phone, string2, n, dcTracker, dataServiceManager, dcTesterFailBringUpAll, dcController);
    }

    private void onConnect(ConnectionParams connectionParams) {
        InvokeDynamicSupport.bootstrap("onConnect", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onConnect(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams ), this, connectionParams);
    }

    public void onSubscriptionOverride(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSubscriptionOverride", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSubscriptionOverride(int int ), this, n, n2);
    }

    private void tearDownData(Object object) {
        InvokeDynamicSupport.bootstrap("tearDownData", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownData(java.lang.Object ), this, object);
    }

    private void notifyAllWithEvent(ApnContext apnContext, int n, String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllWithEvent", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllWithEvent(com.android.internal.telephony.dataconnection.ApnContext int java.lang.String ), this, apnContext, n, string2);
    }

    private void notifyAllOfConnected(String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllOfConnected", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfConnected(java.lang.String ), this, string2);
    }

    private void notifyAllOfDisconnectDcRetrying(String string2) {
        InvokeDynamicSupport.bootstrap("notifyAllOfDisconnectDcRetrying", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllOfDisconnectDcRetrying(java.lang.String ), this, string2);
    }

    private void notifyAllDisconnectCompleted(DcFailCause dcFailCause) {
        InvokeDynamicSupport.bootstrap("notifyAllDisconnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyAllDisconnectCompleted(com.android.internal.telephony.dataconnection.DcFailCause ), this, dcFailCause);
    }

    private void notifyConnectCompleted(ConnectionParams connectionParams, DcFailCause dcFailCause, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyConnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyConnectCompleted(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams com.android.internal.telephony.dataconnection.DcFailCause boolean ), this, connectionParams, dcFailCause, bl);
    }

    private void notifyDisconnectCompleted(DisconnectParams disconnectParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyDisconnectCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$notifyDisconnectCompleted(com.android.internal.telephony.dataconnection.DataConnection$DisconnectParams boolean ), this, disconnectParams, bl);
    }

    public int getDataConnectionId() {
        return (int)InvokeDynamicSupport.bootstrap("getDataConnectionId", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getDataConnectionId(), this);
    }

    private void clearSettings() {
        InvokeDynamicSupport.bootstrap("clearSettings", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$clearSettings(), this);
    }

    private SetupResult onSetupConnectionCompleted(int n, DataCallResponse dataCallResponse, ConnectionParams connectionParams) {
        return InvokeDynamicSupport.bootstrap("onSetupConnectionCompleted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$onSetupConnectionCompleted(int android.telephony.data.DataCallResponse com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams ), this, n, dataCallResponse, connectionParams);
    }

    private boolean isDnsOk(String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDnsOk", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isDnsOk(java.lang.String[] ), this, stringArray);
    }

    private void updateTcpBufferSizes(int n) {
        InvokeDynamicSupport.bootstrap("updateTcpBufferSizes", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateTcpBufferSizes(int ), this, n);
    }

    private void setNetworkRestriction() {
        InvokeDynamicSupport.bootstrap("setNetworkRestriction", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setNetworkRestriction(), this);
    }

    NetworkCapabilities getNetworkCapabilities() {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getNetworkCapabilities(), this);
    }

    public static boolean isIpAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIpAddress", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$isIpAddress(java.lang.String ), (String)string2);
    }

    private SetupResult setLinkProperties(DataCallResponse dataCallResponse, LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("setLinkProperties", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$setLinkProperties(android.telephony.data.DataCallResponse android.net.LinkProperties ), this, dataCallResponse, linkProperties);
    }

    private boolean initConnection(ConnectionParams connectionParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("initConnection", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$initConnection(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams ), this, connectionParams);
    }

    private void updateNetworkInfo() {
        InvokeDynamicSupport.bootstrap("updateNetworkInfo", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateNetworkInfo(), this);
    }

    private void updateNetworkInfoSuspendState() {
        InvokeDynamicSupport.bootstrap("updateNetworkInfoSuspendState", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$updateNetworkInfoSuspendState(), this);
    }

    void tearDownNow() {
        InvokeDynamicSupport.bootstrap("tearDownNow", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$tearDownNow(), this);
    }

    private long getSuggestedRetryDelay(DataCallResponse dataCallResponse) {
        return (long)InvokeDynamicSupport.bootstrap("getSuggestedRetryDelay", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getSuggestedRetryDelay(android.telephony.data.DataCallResponse ), this, dataCallResponse);
    }

    @Override
    protected String getWhatToString(int n) {
        return InvokeDynamicSupport.bootstrap("getWhatToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$getWhatToString(int ), this, n);
    }

    private static String msgToString(Message message) {
        return InvokeDynamicSupport.bootstrapStatic("msgToString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$msgToString(android.os.Message ), (Message)message);
    }

    static void slog(String string2) {
        InvokeDynamicSupport.bootstrapStatic("slog", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$slog(java.lang.String ), (String)string2);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$log(java.lang.String ), this, string2);
    }

    @Override
    protected void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logd(java.lang.String ), this, string2);
    }

    @Override
    protected void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logv(java.lang.String ), this, string2);
    }

    @Override
    protected void logi(String string2) {
        InvokeDynamicSupport.bootstrap("logi", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logi(java.lang.String ), this, string2);
    }

    @Override
    protected void logw(String string2) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$logw(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$loge(java.lang.String java.lang.Throwable ), this, string2, throwable);
    }

    public String toStringSimple() {
        return InvokeDynamicSupport.bootstrap("toStringSimple", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toStringSimple(), this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$toString(), this);
    }

    private void dumpToLog() {
        InvokeDynamicSupport.bootstrap("dumpToLog", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dumpToLog(), this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_DataConnection$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DataConnection.class);
    }

    public /* synthetic */ DataConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DcNetworkAgent
    extends NetworkAgent
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private NetworkCapabilities mNetworkCapabilities;
        public DcKeepaliveTracker keepaliveTracker;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(DataConnection dataConnection, Looper l, Context c, String TAG, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc) {
            this.this$0 = dataConnection;
            this.keepaliveTracker = new DcKeepaliveTracker(this, null);
            dataConnection.mNetCapsLocalLog.log("New network agent created. capabilities=" + nc);
            this.mNetworkCapabilities = nc;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$unwanted() {
            if (this.this$0.mNetworkAgent != this) {
                this.log("DcNetworkAgent: unwanted found mNetworkAgent=" + this.this$0.mNetworkAgent + ", which isn't me.  Aborting unwanted");
                return;
            }
            if (this.this$0.mApnContexts == null) {
                return;
            }
            for (ConnectionParams cp : this.this$0.mApnContexts.values()) {
                ApnContext apnContext = cp.mApnContext;
                Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, cp.mConnectionGeneration);
                this.log("DcNetworkAgent: [unwanted]: disconnect apnContext=" + apnContext);
                Message msg = this.this$0.mDct.obtainMessage(270351, pair);
                DisconnectParams dp = new DisconnectParams(apnContext, apnContext.getReason(), msg);
                this.this$0.sendMessage(this.this$0.obtainMessage(262148, dp));
            }
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$pollLceData() {
            if (this.this$0.mPhone.getLceStatus() == 1) {
                ((DataConnection)this.this$0).mPhone.mCi.pullLceData(this.this$0.obtainMessage(262158));
            }
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$networkStatus(int status, String redirectUrl) {
            if (!TextUtils.isEmpty(redirectUrl)) {
                this.log("validation status: " + status + " with redirection URL: " + redirectUrl);
                Message msg = this.this$0.mDct.obtainMessage(270380, redirectUrl);
                msg.sendToTarget();
            }
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
            if (!networkCapabilities.equals(this.mNetworkCapabilities)) {
                String logStr = "Changed from " + this.mNetworkCapabilities + " to " + networkCapabilities + ", Data RAT=" + this.this$0.mPhone.getServiceState().getRilDataRadioTechnology() + ", mApnSetting=" + this.this$0.mApnSetting;
                this.this$0.mNetCapsLocalLog.log(logStr);
                this.log(logStr);
                this.mNetworkCapabilities = networkCapabilities;
            }
            super.sendNetworkCapabilities(networkCapabilities);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$startPacketKeepalive(Message msg) {
            this.this$0.obtainMessage(262165, msg.arg1, msg.arg2, msg.obj).sendToTarget();
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$stopPacketKeepalive(Message msg) {
            this.this$0.obtainMessage(262166, msg.arg1, msg.arg2, msg.obj).sendToTarget();
        }

        private void __constructor__(DataConnection dataConnection, Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n, NetworkMisc networkMisc) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(dataConnection, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, networkMisc);
        }

        public DcNetworkAgent(DataConnection dataConnection, Looper looper, Context context, String string2, NetworkInfo networkInfo, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, int n, NetworkMisc networkMisc) {
            super(looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, networkMisc);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$__constructor__(com.android.internal.telephony.dataconnection.DataConnection android.os.Looper android.content.Context java.lang.String android.net.NetworkInfo android.net.NetworkCapabilities android.net.LinkProperties int android.net.NetworkMisc ), this, dataConnection, looper, context, string2, networkInfo, networkCapabilities, linkProperties, n, networkMisc);
        }

        @Override
        protected void unwanted() {
            InvokeDynamicSupport.bootstrap("unwanted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$unwanted(), this);
        }

        @Override
        protected void pollLceData() {
            InvokeDynamicSupport.bootstrap("pollLceData", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$pollLceData(), this);
        }

        @Override
        protected void networkStatus(int n, String string2) {
            InvokeDynamicSupport.bootstrap("networkStatus", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$networkStatus(int java.lang.String ), this, n, string2);
        }

        @Override
        public void sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
            InvokeDynamicSupport.bootstrap("sendNetworkCapabilities", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$sendNetworkCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
        }

        @Override
        protected void startPacketKeepalive(Message message) {
            InvokeDynamicSupport.bootstrap("startPacketKeepalive", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$startPacketKeepalive(android.os.Message ), this, message);
        }

        @Override
        protected void stopPacketKeepalive(Message message) {
            InvokeDynamicSupport.bootstrap("stopPacketKeepalive", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent$stopPacketKeepalive(android.os.Message ), this, message);
        }

        public /* synthetic */ DcNetworkAgent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcNetworkAgent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class DcKeepaliveTracker
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private SparseArray<KeepaliveRecord> mKeepalives;
            /* synthetic */ DcNetworkAgent this$1;

            private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(DcNetworkAgent dcNetworkAgent) {
                this.this$1 = dcNetworkAgent;
                this.mKeepalives = new SparseArray();
            }

            private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$getHandleForSlot(int slotId) {
                for (int i = 0; i < this.mKeepalives.size(); ++i) {
                    KeepaliveRecord kr = this.mKeepalives.valueAt(i);
                    if (kr.slotId != slotId) continue;
                    return this.mKeepalives.keyAt(i);
                }
                return -1;
            }

            private final int $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$keepaliveStatusErrorToPacketKeepaliveError(int error) {
                switch (error) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return -30;
                    }
                }
                return -31;
            }

            private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$handleKeepaliveStarted(int slot, KeepaliveStatus ks) {
                switch (ks.statusCode) {
                    case 1: {
                        this.this$1.onPacketKeepaliveEvent(slot, this.keepaliveStatusErrorToPacketKeepaliveError(ks.errorCode));
                        break;
                    }
                    case 0: {
                        this.this$1.onPacketKeepaliveEvent(slot, 0);
                    }
                    case 2: {
                        this.this$1.log("Adding keepalive handle=" + ks.sessionHandle + " slot = " + slot);
                        this.mKeepalives.put(ks.sessionHandle, new KeepaliveRecord(this, slot, ks.statusCode));
                        break;
                    }
                    default: {
                        this.this$1.this$0.loge("Invalid KeepaliveStatus Code: " + ks.statusCode);
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$handleKeepaliveStatus(KeepaliveStatus ks) {
                KeepaliveRecord kr = this.mKeepalives.get(ks.sessionHandle);
                if (kr == null) {
                    this.this$1.log("Discarding keepalive event for different data connection:" + ks);
                    return;
                }
                block0 : switch (kr.currentStatus) {
                    case 1: {
                        this.this$1.this$0.loge("Inactive Keepalive received status!");
                        this.this$1.onPacketKeepaliveEvent(kr.slotId, -31);
                        break;
                    }
                    case 2: {
                        switch (ks.statusCode) {
                            case 1: {
                                this.this$1.onPacketKeepaliveEvent(kr.slotId, this.keepaliveStatusErrorToPacketKeepaliveError(ks.errorCode));
                                kr.currentStatus = 1;
                                this.mKeepalives.remove(ks.sessionHandle);
                                break block0;
                            }
                            case 0: {
                                this.this$1.log("Pending Keepalive received active status!");
                                kr.currentStatus = 0;
                                this.this$1.onPacketKeepaliveEvent(kr.slotId, 0);
                                break block0;
                            }
                            case 2: {
                                this.this$1.this$0.loge("Invalid unsolicied Keepalive Pending Status!");
                                break block0;
                            }
                        }
                        this.this$1.this$0.loge("Invalid Keepalive Status received, " + ks.statusCode);
                        break;
                    }
                    case 0: {
                        switch (ks.statusCode) {
                            case 1: {
                                this.this$1.this$0.loge("Keepalive received stopped status!");
                                this.this$1.onPacketKeepaliveEvent(kr.slotId, 0);
                                kr.currentStatus = 1;
                                this.mKeepalives.remove(ks.sessionHandle);
                                break block0;
                            }
                            case 0: 
                            case 2: {
                                this.this$1.this$0.loge("Active Keepalive received invalid status!");
                                break block0;
                            }
                        }
                        this.this$1.this$0.loge("Invalid Keepalive Status received, " + ks.statusCode);
                        break;
                    }
                    default: {
                        this.this$1.this$0.loge("Invalid Keepalive Status received, " + kr.currentStatus);
                    }
                }
            }

            private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(DcNetworkAgent x0, 1 x1) {
            }

            private void __constructor__(DcNetworkAgent dcNetworkAgent) {
                this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(dcNetworkAgent);
            }

            public DcKeepaliveTracker(DcNetworkAgent dcNetworkAgent) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(com.android.internal.telephony.dataconnection.DataConnection$DcNetworkAgent ), this, dcNetworkAgent);
            }

            int getHandleForSlot(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getHandleForSlot", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$getHandleForSlot(int ), this, n);
            }

            int keepaliveStatusErrorToPacketKeepaliveError(int n) {
                return (int)InvokeDynamicSupport.bootstrap("keepaliveStatusErrorToPacketKeepaliveError", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$keepaliveStatusErrorToPacketKeepaliveError(int ), this, n);
            }

            void handleKeepaliveStarted(int n, KeepaliveStatus keepaliveStatus) {
                InvokeDynamicSupport.bootstrap("handleKeepaliveStarted", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$handleKeepaliveStarted(int com.android.internal.telephony.dataconnection.KeepaliveStatus ), this, n, keepaliveStatus);
            }

            void handleKeepaliveStatus(KeepaliveStatus keepaliveStatus) {
                InvokeDynamicSupport.bootstrap("handleKeepaliveStatus", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$handleKeepaliveStatus(com.android.internal.telephony.dataconnection.KeepaliveStatus ), this, keepaliveStatus);
            }

            private /* synthetic */ void __constructor__(DcNetworkAgent dcNetworkAgent, 1 var2_2) {
                this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(dcNetworkAgent, var2_2);
            }

            public /* synthetic */ DcKeepaliveTracker(DcNetworkAgent dcNetworkAgent, 1 var2_2) {
                this(dcNetworkAgent);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker$__constructor__(com.android.internal.telephony.dataconnection.DataConnection$DcNetworkAgent com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dcNetworkAgent, var2_2);
            }

            public /* synthetic */ DcKeepaliveTracker() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcKeepaliveTracker)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            private class KeepaliveRecord
            implements ShadowedObject {
                public /* synthetic */ Object __robo_data__;
                public int slotId;
                public int currentStatus;
                /* synthetic */ DcKeepaliveTracker this$2;

                private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker_KeepaliveRecord$__constructor__(DcKeepaliveTracker dcKeepaliveTracker, int slotId, int status) {
                    this.this$2 = dcKeepaliveTracker;
                    this.slotId = slotId;
                    this.currentStatus = status;
                }

                private void __constructor__(DcKeepaliveTracker dcKeepaliveTracker, int n, int n2) {
                    this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker_KeepaliveRecord$__constructor__(dcKeepaliveTracker, n, n2);
                }

                public KeepaliveRecord(DcKeepaliveTracker dcKeepaliveTracker, int n, int n2) {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcNetworkAgent_DcKeepaliveTracker_KeepaliveRecord$__constructor__(com.android.internal.telephony.dataconnection.DataConnection$DcNetworkAgent$DcKeepaliveTracker int int ), this, dcKeepaliveTracker, n, n2);
                }

                public /* synthetic */ KeepaliveRecord() {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeepaliveRecord)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }
    }

    private class DcDisconnectionErrorCreatingConnection
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$enter() {
            StatsLog.write(75, 5, this.this$0.mPhone.getPhoneId(), this.this$0.mId, this.this$0.mApnSetting != null ? (long)((DataConnection)this.this$0).mApnSetting.typesBitmap : 0L, this.this$0.mApnSetting != null ? this.this$0.mApnSetting.canHandleType("default") : false);
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262147: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (cp.mTag == this.this$0.mTag) {
                        String str = "DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE";
                        this.this$0.log(str);
                        if (cp.mApnContext != null) {
                            cp.mApnContext.requestLog(str);
                        }
                        this.this$0.mInactiveState.setEnterNotificationParams(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    } else {
                        this.this$0.log("DcDisconnectionErrorCreatingConnection stale EVENT_DEACTIVATE_DONE dp.tag=" + cp.mTag + ", mTag=" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcDisconnectionErrorCreatingConnection not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(dataConnection);
        }

        public DcDisconnectionErrorCreatingConnection(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectionErrorCreatingConnection(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectionErrorCreatingConnection$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectionErrorCreatingConnection() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDisconnectionErrorCreatingConnection)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcDisconnectingState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$enter() {
            StatsLog.write(75, 4, this.this$0.mPhone.getPhoneId(), this.this$0.mId, this.this$0.mApnSetting != null ? (long)((DataConnection)this.this$0).mApnSetting.typesBitmap : 0L, this.this$0.mApnSetting != null ? this.this$0.mApnSetting.canHandleType("default") : false);
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    this.this$0.log("DcDisconnectingState msg.what=EVENT_CONNECT. Defer. RefCount = " + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262147: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    String str = "DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE RefCount=" + this.this$0.mApnContexts.size();
                    this.this$0.log(str);
                    if (dp.mApnContext != null) {
                        dp.mApnContext.requestLog(str);
                    }
                    if (dp.mTag == this.this$0.mTag) {
                        this.this$0.mInactiveState.setEnterNotificationParams(dp);
                        this.this$0.transitionTo(this.this$0.mInactiveState);
                    } else {
                        this.this$0.log("DcDisconnectState stale EVENT_DEACTIVATE_DONE dp.tag=" + dp.mTag + " mTag=" + this.this$0.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcDisconnectingState not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(dataConnection);
        }

        public DcDisconnectingState(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectingState(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDisconnectingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcDisconnectingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDisconnectingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcActiveState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$enter() {
            this.this$0.log("DcActiveState: enter dc=" + this.this$0);
            StatsLog.write(75, 3, this.this$0.mPhone.getPhoneId(), this.this$0.mId, this.this$0.mApnSetting != null ? (long)((DataConnection)this.this$0).mApnSetting.typesBitmap : 0L, this.this$0.mApnSetting != null ? this.this$0.mApnSetting.canHandleType("default") : false);
            this.this$0.updateNetworkInfo();
            this.this$0.notifyAllOfConnected("connected");
            this.this$0.mPhone.getCallTracker().registerForVoiceCallStarted(this.this$0.getHandler(), 262159, null);
            this.this$0.mPhone.getCallTracker().registerForVoiceCallEnded(this.this$0.getHandler(), 262160, null);
            this.this$0.mDcController.addActiveDcByCid(this.this$0);
            this.this$0.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, this.this$0.mNetworkInfo.getReason(), null);
            this.this$0.mNetworkInfo.setExtraInfo(((DataConnection)this.this$0).mApnSetting.apn);
            this.this$0.updateTcpBufferSizes(this.this$0.mRilRat);
            NetworkMisc misc = new NetworkMisc();
            CarrierSignalAgent carrierSignalAgent = this.this$0.mPhone.getCarrierSignalAgent();
            if (carrierSignalAgent.hasRegisteredReceivers("com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED")) {
                misc.provisioningNotificationDisabled = true;
            }
            misc.subscriberId = this.this$0.mPhone.getSubscriberId();
            this.this$0.setNetworkRestriction();
            this.this$0.log("mRestrictedNetworkOverride = " + this.this$0.mRestrictedNetworkOverride);
            this.this$0.mNetworkAgent = new DcNetworkAgent(this.this$0, this.this$0.getHandler().getLooper(), this.this$0.mPhone.getContext(), "DcNetworkAgent", this.this$0.mNetworkInfo, this.this$0.getNetworkCapabilities(), this.this$0.mLinkProperties, 50, misc);
            ((DataConnection)this.this$0).mPhone.mCi.registerForNattKeepaliveStatus(this.this$0.getHandler(), 262162, null);
            ((DataConnection)this.this$0).mPhone.mCi.registerForLceInfo(this.this$0.getHandler(), 262167, null);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$exit() {
            this.this$0.log("DcActiveState: exit dc=" + this);
            String reason = this.this$0.mNetworkInfo.getReason();
            if (this.this$0.mDcController.isExecutingCarrierChange()) {
                reason = "carrierChange";
            } else if (this.this$0.mDisconnectParams != null && ((DataConnection)this.this$0).mDisconnectParams.mReason != null) {
                reason = ((DataConnection)this.this$0).mDisconnectParams.mReason;
            } else if (this.this$0.mDcFailCause != null) {
                reason = this.this$0.mDcFailCause.toString();
            }
            this.this$0.mPhone.getCallTracker().unregisterForVoiceCallStarted(this.this$0.getHandler());
            this.this$0.mPhone.getCallTracker().unregisterForVoiceCallEnded(this.this$0.getHandler());
            this.this$0.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, this.this$0.mNetworkInfo.getExtraInfo());
            ((DataConnection)this.this$0).mPhone.mCi.unregisterForNattKeepaliveStatus(this.this$0.getHandler());
            ((DataConnection)this.this$0).mPhone.mCi.unregisterForLceInfo(this.this$0.getHandler());
            if (this.this$0.mNetworkAgent != null) {
                this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                this.this$0.mNetworkAgent = null;
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    this.this$0.mApnContexts.put(cp.mApnContext, cp);
                    this.this$0.log("DcActiveState: EVENT_CONNECT cp=" + cp + " dc=" + this.this$0);
                    this.this$0.notifyConnectCompleted(cp, DcFailCause.NONE, false);
                    retVal = true;
                    break;
                }
                case 262148: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    this.this$0.log("DcActiveState: EVENT_DISCONNECT dp=" + dp + " dc=" + this.this$0);
                    if (this.this$0.mApnContexts.containsKey(dp.mApnContext)) {
                        this.this$0.log("DcActiveState msg.what=EVENT_DISCONNECT RefCount=" + this.this$0.mApnContexts.size());
                        if (this.this$0.mApnContexts.size() == 1) {
                            this.this$0.mApnContexts.clear();
                            this.this$0.mDisconnectParams = dp;
                            this.this$0.mConnectionParams = null;
                            dp.mTag = this.this$0.mTag;
                            this.this$0.tearDownData(dp);
                            this.this$0.transitionTo(this.this$0.mDisconnectingState);
                        } else {
                            this.this$0.mApnContexts.remove(dp.mApnContext);
                            this.this$0.notifyDisconnectCompleted(dp, false);
                        }
                    } else {
                        this.this$0.log("DcActiveState ERROR no such apnContext=" + dp.mApnContext + " in this dc=" + this.this$0);
                        this.this$0.notifyDisconnectCompleted(dp, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    this.this$0.log("DcActiveState EVENT_DISCONNECT clearing apn contexts, dc=" + this.this$0);
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    this.this$0.mDisconnectParams = dp;
                    this.this$0.mConnectionParams = null;
                    dp.mTag = this.this$0.mTag;
                    this.this$0.tearDownData(dp);
                    this.this$0.transitionTo(this.this$0.mDisconnectingState);
                    retVal = true;
                    break;
                }
                case 262153: {
                    this.this$0.log("DcActiveState EVENT_LOST_CONNECTION dc=" + this.this$0);
                    this.this$0.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                    this.this$0.transitionTo(this.this$0.mInactiveState);
                    retVal = true;
                    break;
                }
                case 262156: 
                case 262157: 
                case 262161: {
                    this.this$0.updateNetworkInfo();
                    if (this.this$0.mNetworkAgent != null) {
                        this.this$0.mNetworkAgent.sendNetworkCapabilities(this.this$0.getNetworkCapabilities());
                        this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    }
                    retVal = true;
                    break;
                }
                case 262158: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.this$0.log("EVENT_BW_REFRESH_RESPONSE: error ignoring, e=" + ar.exception);
                    } else {
                        LinkCapacityEstimate lce = (LinkCapacityEstimate)ar.result;
                        NetworkCapabilities nc = this.this$0.getNetworkCapabilities();
                        if (this.this$0.mPhone.getLceStatus() == 1) {
                            nc.setLinkDownstreamBandwidthKbps(lce.downlinkCapacityKbps);
                            if (this.this$0.mNetworkAgent != null) {
                                this.this$0.mNetworkAgent.sendNetworkCapabilities(nc);
                            }
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262159: 
                case 262160: {
                    this.this$0.updateNetworkInfo();
                    this.this$0.updateNetworkInfoSuspendState();
                    if (this.this$0.mNetworkAgent != null) {
                        this.this$0.mNetworkAgent.sendNetworkCapabilities(this.this$0.getNetworkCapabilities());
                        this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    }
                    retVal = true;
                    break;
                }
                case 262165: {
                    KeepalivePacketData pkt = (KeepalivePacketData)msg.obj;
                    int slotId = msg.arg1;
                    int intervalMillis = msg.arg2 * 1000;
                    if (this.this$0.mDataServiceManager.getTransportType() == 1) {
                        ((DataConnection)this.this$0).mPhone.mCi.startNattKeepalive(this.this$0.mCid, pkt, intervalMillis, this.this$0.obtainMessage(262163, slotId, 0, null));
                    } else if (this.this$0.mNetworkAgent != null) {
                        this.this$0.mNetworkAgent.onPacketKeepaliveEvent(msg.arg1, -20);
                    }
                    retVal = true;
                    break;
                }
                case 262166: {
                    int slotId = msg.arg1;
                    int handle = ((DataConnection)this.this$0).mNetworkAgent.keepaliveTracker.getHandleForSlot(slotId);
                    if (handle < 0) {
                        this.this$0.loge("No slot found for stopPacketKeepalive! " + slotId);
                        retVal = true;
                        break;
                    }
                    this.this$0.logd("Stopping keepalive with handle: " + handle);
                    ((DataConnection)this.this$0).mPhone.mCi.stopNattKeepalive(handle, this.this$0.obtainMessage(262164, handle, slotId, null));
                    retVal = true;
                    break;
                }
                case 262163: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int slot = msg.arg1;
                    if (ar.exception != null || ar.result == null) {
                        this.this$0.loge("EVENT_KEEPALIVE_STARTED: error starting keepalive, e=" + ar.exception);
                        this.this$0.mNetworkAgent.onPacketKeepaliveEvent(slot, -31);
                    } else {
                        KeepaliveStatus ks = (KeepaliveStatus)ar.result;
                        if (ks == null) {
                            this.this$0.loge("Null KeepaliveStatus received!");
                        } else {
                            ((DataConnection)this.this$0).mNetworkAgent.keepaliveTracker.handleKeepaliveStarted(slot, ks);
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262162: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.this$0.loge("EVENT_KEEPALIVE_STATUS: error in keepalive, e=" + ar.exception);
                    }
                    if (ar.result != null) {
                        KeepaliveStatus ks = (KeepaliveStatus)ar.result;
                        ((DataConnection)this.this$0).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(ks);
                    }
                    retVal = true;
                    break;
                }
                case 262164: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int handle = msg.arg1;
                    int slotId = msg.arg2;
                    if (ar.exception != null) {
                        this.this$0.loge("EVENT_KEEPALIVE_STOPPED: error stopping keepalive for handle=" + handle + " e=" + ar.exception);
                        ((DataConnection)this.this$0).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(new KeepaliveStatus(3));
                    } else {
                        this.this$0.log("Keepalive Stop Requested for handle=" + handle);
                        ((DataConnection)this.this$0).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(new KeepaliveStatus(handle, 1));
                    }
                    retVal = true;
                    break;
                }
                case 262167: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.this$0.loge("EVENT_LINK_CAPACITY_CHANGED e=" + ar.exception);
                    } else {
                        LinkCapacityEstimate lce = (LinkCapacityEstimate)ar.result;
                        NetworkCapabilities nc = this.this$0.getNetworkCapabilities();
                        if (lce.downlinkCapacityKbps != -1) {
                            nc.setLinkDownstreamBandwidthKbps(lce.downlinkCapacityKbps);
                        }
                        if (lce.uplinkCapacityKbps != -1) {
                            nc.setLinkUpstreamBandwidthKbps(lce.uplinkCapacityKbps);
                        }
                        if (this.this$0.mNetworkAgent != null) {
                            this.this$0.mNetworkAgent.sendNetworkCapabilities(nc);
                        }
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcActiveState not handled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(dataConnection);
        }

        public DcActiveState(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcActiveState(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcActiveState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcActiveState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcActivatingState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$enter() {
            StatsLog.write(75, 2, this.this$0.mPhone.getPhoneId(), this.this$0.mId, this.this$0.mApnSetting != null ? (long)((DataConnection)this.this$0).mApnSetting.typesBitmap : 0L, this.this$0.mApnSetting != null ? this.this$0.mApnSetting.canHandleType("default") : false);
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$processMessage(Message msg) {
            boolean retVal;
            this.this$0.log("DcActivatingState: msg=" + DataConnection.msgToString(msg));
            switch (msg.what) {
                case 262144: 
                case 262155: {
                    this.this$0.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262145: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataCallResponse dataCallResponse = (DataCallResponse)msg.getData().getParcelable("data_call_response");
                    SetupResult result = this.this$0.onSetupConnectionCompleted(msg.arg1, dataCallResponse, cp);
                    if (result != SetupResult.ERROR_STALE && this.this$0.mConnectionParams != cp) {
                        this.this$0.loge("DcActivatingState: WEIRD mConnectionsParams:" + this.this$0.mConnectionParams + " != cp:" + cp);
                    }
                    this.this$0.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result) + " dc=" + this.this$0);
                    if (cp.mApnContext != null) {
                        cp.mApnContext.requestLog("onSetupConnectionCompleted result=" + (Object)((Object)result));
                    }
                    switch (2.$SwitchMap$com$android$internal$telephony$dataconnection$DataConnection$SetupResult[result.ordinal()]) {
                        case 1: {
                            this.this$0.mDcFailCause = DcFailCause.NONE;
                            this.this$0.transitionTo(this.this$0.mActiveState);
                            break;
                        }
                        case 2: {
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                            break;
                        }
                        case 3: {
                            this.this$0.tearDownData(cp);
                            this.this$0.transitionTo(this.this$0.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case 4: {
                            long delay = this.this$0.getSuggestedRetryDelay(dataCallResponse);
                            cp.mApnContext.setModemSuggestedDelay(delay);
                            String str = "DcActivatingState: ERROR_DATA_SERVICE_SPECIFIC_ERROR  delay=" + delay + " result=" + (Object)((Object)result) + " result.isRestartRadioFail=" + result.mFailCause.isRestartRadioFail(this.this$0.mPhone.getContext(), this.this$0.mPhone.getSubId()) + " isPermanentFailure=" + this.this$0.mDct.isPermanentFailure(result.mFailCause);
                            this.this$0.log(str);
                            if (cp.mApnContext != null) {
                                cp.mApnContext.requestLog(str);
                            }
                            this.this$0.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            this.this$0.transitionTo(this.this$0.mInactiveState);
                            break;
                        }
                        case 5: {
                            this.this$0.loge("DcActivatingState: stale EVENT_SETUP_DATA_CONNECTION_DONE tag:" + cp.mTag + " != mTag:" + this.this$0.mTag);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcActivatingState not handled msg.what=" + this.this$0.getWhatToString(msg.what) + " RefCount=" + this.this$0.mApnContexts.size());
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(dataConnection);
        }

        public DcActivatingState(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$enter(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcActivatingState(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcActivatingState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcActivatingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcActivatingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcInactiveState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(ConnectionParams cp, DcFailCause cause) {
            this.this$0.log("DcInactiveState: setEnterNotificationParams cp,cause");
            this.this$0.mConnectionParams = cp;
            this.this$0.mDisconnectParams = null;
            this.this$0.mDcFailCause = cause;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(DisconnectParams dp) {
            this.this$0.log("DcInactiveState: setEnterNotificationParams dp");
            this.this$0.mConnectionParams = null;
            this.this$0.mDisconnectParams = dp;
            this.this$0.mDcFailCause = DcFailCause.NONE;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(DcFailCause cause) {
            this.this$0.mConnectionParams = null;
            this.this$0.mDisconnectParams = null;
            this.this$0.mDcFailCause = cause;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$enter() {
            ++this.this$0.mTag;
            this.this$0.log("DcInactiveState: enter() mTag=" + this.this$0.mTag);
            StatsLog.write(75, 1, this.this$0.mPhone.getPhoneId(), this.this$0.mId, this.this$0.mApnSetting != null ? (long)((DataConnection)this.this$0).mApnSetting.typesBitmap : 0L, this.this$0.mApnSetting != null ? this.this$0.mApnSetting.canHandleType("default") : false);
            if (this.this$0.mConnectionParams != null) {
                this.this$0.log("DcInactiveState: enter notifyConnectCompleted +ALL failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyConnectCompleted(this.this$0.mConnectionParams, this.this$0.mDcFailCause, true);
            }
            if (this.this$0.mDisconnectParams != null) {
                this.this$0.log("DcInactiveState: enter notifyDisconnectCompleted +ALL failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyDisconnectCompleted(this.this$0.mDisconnectParams, true);
            }
            if (this.this$0.mDisconnectParams == null && this.this$0.mConnectionParams == null && this.this$0.mDcFailCause != null) {
                this.this$0.log("DcInactiveState: enter notifyAllDisconnectCompleted failCause=" + (Object)((Object)this.this$0.mDcFailCause));
                this.this$0.notifyAllDisconnectCompleted(this.this$0.mDcFailCause);
            }
            this.this$0.mDcController.removeActiveDcByCid(this.this$0);
            this.this$0.clearSettings();
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$exit() {
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 266252: {
                    this.this$0.log("DcInactiveState: msg.what=RSP_RESET, ignore we're already reset");
                    retVal = true;
                    break;
                }
                case 262144: {
                    this.this$0.log("DcInactiveState: mag.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (this.this$0.initConnection(cp)) {
                        this.this$0.onConnect(this.this$0.mConnectionParams);
                        this.this$0.transitionTo(this.this$0.mActivatingState);
                    } else {
                        this.this$0.log("DcInactiveState: msg.what=EVENT_CONNECT initConnection failed");
                        this.this$0.notifyConnectCompleted(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER, false);
                    }
                    retVal = true;
                    break;
                }
                case 262148: {
                    this.this$0.log("DcInactiveState: msg.what=EVENT_DISCONNECT");
                    this.this$0.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                case 262150: {
                    this.this$0.log("DcInactiveState: msg.what=EVENT_DISCONNECT_ALL");
                    this.this$0.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                default: {
                    this.this$0.log("DcInactiveState nothandled msg.what=" + this.this$0.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(dataConnection);
        }

        public DcInactiveState(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, DcFailCause dcFailCause) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DataConnection$ConnectionParams com.android.internal.telephony.dataconnection.DcFailCause ), this, connectionParams, dcFailCause);
        }

        public void setEnterNotificationParams(DisconnectParams disconnectParams) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DataConnection$DisconnectParams ), this, disconnectParams);
        }

        public void setEnterNotificationParams(DcFailCause dcFailCause) {
            InvokeDynamicSupport.bootstrap("setEnterNotificationParams", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$setEnterNotificationParams(com.android.internal.telephony.dataconnection.DcFailCause ), this, dcFailCause);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcInactiveState(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcInactiveState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcInactiveState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcInactiveState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DcDefaultState
    extends State
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ DataConnection this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(DataConnection dataConnection) {
            this.this$0 = dataConnection;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$enter() {
            this.this$0.log("DcDefaultState: enter");
            this.this$0.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this.this$0.getHandler(), 262155, null);
            this.this$0.mPhone.getServiceStateTracker().registerForDataRoamingOn(this.this$0.getHandler(), 262156, null);
            this.this$0.mPhone.getServiceStateTracker().registerForDataRoamingOff(this.this$0.getHandler(), 262157, null, true);
            this.this$0.mDcController.addDc(this.this$0);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$exit() {
            this.this$0.log("DcDefaultState: exit");
            this.this$0.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this.this$0.getHandler());
            this.this$0.mPhone.getServiceStateTracker().unregisterForDataRoamingOn(this.this$0.getHandler());
            this.this$0.mPhone.getServiceStateTracker().unregisterForDataRoamingOff(this.this$0.getHandler());
            this.this$0.mDcController.removeDc(this.this$0);
            if (this.this$0.mAc != null) {
                this.this$0.mAc.disconnected();
                this.this$0.mAc = null;
            }
            this.this$0.mApnContexts = null;
            this.this$0.mReconnectIntent = null;
            this.this$0.mDct = null;
            this.this$0.mApnSetting = null;
            this.this$0.mPhone = null;
            this.this$0.mDataServiceManager = null;
            this.this$0.mLinkProperties = null;
            this.this$0.mLastFailCause = null;
            this.this$0.mUserData = null;
            this.this$0.mDcController = null;
            this.this$0.mDcTesterFailBringUpAll = null;
        }

        private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$processMessage(Message msg) {
            boolean retVal = true;
            this.this$0.log("DcDefault msg=" + this.this$0.getWhatToString(msg.what) + " RefCount=" + this.this$0.mApnContexts.size());
            switch (msg.what) {
                case 69633: {
                    if (this.this$0.mAc != null) {
                        this.this$0.log("Disconnecting to previous connection mAc=" + this.this$0.mAc);
                        this.this$0.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    this.this$0.mAc = new AsyncChannel();
                    this.this$0.mAc.connected(null, this.this$0.getHandler(), msg.replyTo);
                    this.this$0.log("DcDefaultState: FULL_CONNECTION reply connected");
                    this.this$0.mAc.replyToMessage(msg, 69634, 0, this.this$0.mId, "hi");
                    break;
                }
                case 69636: {
                    this.this$0.log("DcDefault: CMD_CHANNEL_DISCONNECTED before quiting call dump");
                    this.this$0.dumpToLog();
                    this.this$0.quit();
                    break;
                }
                case 266240: {
                    boolean val = this.this$0.isInactive();
                    this.this$0.log("REQ_IS_INACTIVE  isInactive=" + val);
                    this.this$0.mAc.replyToMessage(msg, 266241, val ? 1 : 0);
                    break;
                }
                case 266242: {
                    int cid = this.this$0.getCid();
                    this.this$0.log("REQ_GET_CID  cid=" + cid);
                    this.this$0.mAc.replyToMessage(msg, 266243, cid);
                    break;
                }
                case 266244: {
                    ApnSetting apnSetting = this.this$0.getApnSetting();
                    this.this$0.log("REQ_GET_APNSETTING  mApnSetting=" + apnSetting);
                    this.this$0.mAc.replyToMessage(msg, 266245, apnSetting);
                    break;
                }
                case 266246: {
                    LinkProperties lp = this.this$0.getCopyLinkProperties();
                    this.this$0.log("REQ_GET_LINK_PROPERTIES linkProperties" + lp);
                    this.this$0.mAc.replyToMessage(msg, 266247, lp);
                    break;
                }
                case 266248: {
                    ProxyInfo proxy = (ProxyInfo)msg.obj;
                    this.this$0.log("REQ_SET_LINK_PROPERTIES_HTTP_PROXY proxy=" + proxy);
                    this.this$0.setLinkPropertiesHttpProxy(proxy);
                    this.this$0.mAc.replyToMessage(msg, 266249);
                    if (this.this$0.mNetworkAgent == null) break;
                    this.this$0.mNetworkAgent.sendLinkProperties(this.this$0.mLinkProperties);
                    break;
                }
                case 266250: {
                    NetworkCapabilities nc = this.this$0.getNetworkCapabilities();
                    this.this$0.log("REQ_GET_NETWORK_CAPABILITIES networkCapabilities" + nc);
                    this.this$0.mAc.replyToMessage(msg, 266251, nc);
                    break;
                }
                case 266252: {
                    this.this$0.log("DcDefaultState: msg.what=REQ_RESET");
                    this.this$0.transitionTo(this.this$0.mInactiveState);
                    break;
                }
                case 262144: {
                    this.this$0.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    this.this$0.notifyConnectCompleted(cp, DcFailCause.UNKNOWN, false);
                    break;
                }
                case 262148: {
                    this.this$0.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT RefCount=" + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    break;
                }
                case 262150: {
                    this.this$0.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT_ALL RefCount=" + this.this$0.mApnContexts.size());
                    this.this$0.deferMessage(msg);
                    break;
                }
                case 262152: {
                    this.this$0.log("DcDefaultState EVENT_TEAR_DOWN_NOW");
                    this.this$0.mDataServiceManager.deactivateDataCall(this.this$0.mCid, 1, null);
                    break;
                }
                case 262153: {
                    String s = "DcDefaultState ignore EVENT_LOST_CONNECTION tag=" + msg.arg1 + ":mTag=" + this.this$0.mTag;
                    this.this$0.logAndAddLogRec(s);
                    break;
                }
                case 262155: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Pair drsRatPair = (Pair)ar.result;
                    this.this$0.mDataRegState = (Integer)drsRatPair.first;
                    if (this.this$0.mRilRat != (Integer)drsRatPair.second) {
                        this.this$0.updateTcpBufferSizes((Integer)drsRatPair.second);
                    }
                    this.this$0.mRilRat = (Integer)drsRatPair.second;
                    this.this$0.log("DcDefaultState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED drs=" + this.this$0.mDataRegState + " mRilRat=" + this.this$0.mRilRat);
                    this.this$0.updateNetworkInfo();
                    this.this$0.updateNetworkInfoSuspendState();
                    if (this.this$0.mNetworkAgent == null) break;
                    this.this$0.mNetworkAgent.sendNetworkCapabilities(this.this$0.getNetworkCapabilities());
                    this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    this.this$0.mNetworkAgent.sendLinkProperties(this.this$0.mLinkProperties);
                    break;
                }
                case 262156: 
                case 262157: 
                case 262161: {
                    this.this$0.updateNetworkInfo();
                    if (this.this$0.mNetworkAgent == null) break;
                    this.this$0.mNetworkAgent.sendNetworkCapabilities(this.this$0.getNetworkCapabilities());
                    this.this$0.mNetworkAgent.sendNetworkInfo(this.this$0.mNetworkInfo);
                    break;
                }
                case 262165: 
                case 262166: {
                    if (this.this$0.mNetworkAgent == null) break;
                    this.this$0.mNetworkAgent.onPacketKeepaliveEvent(msg.arg1, -20);
                    break;
                }
                default: {
                    this.this$0.log("DcDefaultState: shouldn't happen but ignore msg.what=" + this.this$0.getWhatToString(msg.what));
                }
            }
            return retVal;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(DataConnection x0, 1 x1) {
        }

        private void __constructor__(DataConnection dataConnection) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(dataConnection);
        }

        public DcDefaultState(DataConnection dataConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection ), this, dataConnection);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$enter(), this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$exit(), this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$processMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(DataConnection dataConnection, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(dataConnection, var2_2);
        }

        public /* synthetic */ DcDefaultState(DataConnection dataConnection, 1 var2_2) {
            this(dataConnection);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DcDefaultState$__constructor__(com.android.internal.telephony.dataconnection.DataConnection com.android.internal.telephony.dataconnection.DataConnection$1 ), this, dataConnection, var2_2);
        }

        public /* synthetic */ DcDefaultState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DcDefaultState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SetupResult
    extends Enum<SetupResult> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ SetupResult SUCCESS;
        public static /* enum */ SetupResult ERROR_RADIO_NOT_AVAILABLE;
        public static /* enum */ SetupResult ERROR_INVALID_ARG;
        public static /* enum */ SetupResult ERROR_STALE;
        public static /* enum */ SetupResult ERROR_DATA_SERVICE_SPECIFIC_ERROR;
        public DcFailCause mFailCause;
        private static /* synthetic */ SetupResult[] $VALUES;

        private static final SetupResult[] $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$values() {
            return (SetupResult[])$VALUES.clone();
        }

        private static final SetupResult $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$valueOf(String name) {
            return Enum.valueOf(SetupResult.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$__constructor__(String string2, int n) {
            this.mFailCause = DcFailCause.fromInt(0);
        }

        private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$toString() {
            return this.name() + "  SetupResult.mFailCause=" + (Object)((Object)this.mFailCause);
        }

        static void __staticInitializer__() {
            SUCCESS = new SetupResult();
            ERROR_RADIO_NOT_AVAILABLE = new SetupResult();
            ERROR_INVALID_ARG = new SetupResult();
            ERROR_STALE = new SetupResult();
            ERROR_DATA_SERVICE_SPECIFIC_ERROR = new SetupResult();
            $VALUES = new SetupResult[]{SUCCESS, ERROR_RADIO_NOT_AVAILABLE, ERROR_INVALID_ARG, ERROR_STALE, ERROR_DATA_SERVICE_SPECIFIC_ERROR};
        }

        public static SetupResult[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$values());
        }

        public static SetupResult valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$__constructor__(string2, n);
        }

        public SetupResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$__constructor__(java.lang.String int ), this, string2, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_SetupResult$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(SetupResult.class);
        }

        public /* synthetic */ SetupResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetupResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UpdateLinkPropertyResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public SetupResult setupResult;
        public LinkProperties oldLp;
        public LinkProperties newLp;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(LinkProperties curLp) {
            this.setupResult = SetupResult.SUCCESS;
            this.oldLp = curLp;
            this.newLp = curLp;
        }

        private void __constructor__(LinkProperties linkProperties) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(linkProperties);
        }

        public UpdateLinkPropertyResult(LinkProperties linkProperties) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_UpdateLinkPropertyResult$__constructor__(android.net.LinkProperties ), this, linkProperties);
        }

        public /* synthetic */ UpdateLinkPropertyResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UpdateLinkPropertyResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DisconnectParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mTag;
        public ApnContext mApnContext;
        String mReason;
        Message mOnCompletedMsg;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(ApnContext apnContext, String reason, Message onCompletedMsg) {
            this.mApnContext = apnContext;
            this.mReason = reason;
            this.mOnCompletedMsg = onCompletedMsg;
        }

        private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mReason=" + this.mReason + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }

        private void __constructor__(ApnContext apnContext, String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(apnContext, string2, message);
        }

        public DisconnectParams(ApnContext apnContext, String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$__constructor__(com.android.internal.telephony.dataconnection.ApnContext java.lang.String android.os.Message ), this, apnContext, string2, message);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_DisconnectParams$toString(), this);
        }

        public /* synthetic */ DisconnectParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisconnectParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ConnectionParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mTag;
        ApnContext mApnContext;
        int mProfileId;
        int mRilRat;
        boolean mUnmeteredUseOnly;
        Message mOnCompletedMsg;
        int mConnectionGeneration;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(ApnContext apnContext, int profileId, int rilRadioTechnology, boolean unmeteredUseOnly, Message onCompletedMsg, int connectionGeneration) {
            this.mApnContext = apnContext;
            this.mProfileId = profileId;
            this.mRilRat = rilRadioTechnology;
            this.mUnmeteredUseOnly = unmeteredUseOnly;
            this.mOnCompletedMsg = onCompletedMsg;
            this.mConnectionGeneration = connectionGeneration;
        }

        private final String $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mProfileId=" + this.mProfileId + " mRat=" + this.mRilRat + " mUnmeteredUseOnly=" + this.mUnmeteredUseOnly + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }

        private void __constructor__(ApnContext apnContext, int n, int n2, boolean bl, Message message, int n3) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(apnContext, n, n2, bl, message, n3);
        }

        public ConnectionParams(ApnContext apnContext, int n, int n2, boolean bl, Message message, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$__constructor__(com.android.internal.telephony.dataconnection.ApnContext int int boolean android.os.Message int ), this, apnContext, n, n2, bl, message, n3);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataConnection_ConnectionParams$toString(), this);
        }

        public /* synthetic */ ConnectionParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

