/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.euicc.DownloadableSubscription;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.euicc.EuiccController;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class EuiccOperation
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "EuiccOperation";
    public static Parcelable.Creator<EuiccOperation> CREATOR;
    @VisibleForTesting
    static int ACTION_GET_METADATA_DEACTIVATE_SIM = 1;
    @VisibleForTesting
    static int ACTION_DOWNLOAD_DEACTIVATE_SIM = 2;
    @VisibleForTesting
    static int ACTION_DOWNLOAD_NO_PRIVILEGES = 3;
    @VisibleForTesting
    static int ACTION_GET_DEFAULT_LIST_DEACTIVATE_SIM = 4;
    @VisibleForTesting
    static int ACTION_SWITCH_DEACTIVATE_SIM = 5;
    @VisibleForTesting
    static int ACTION_SWITCH_NO_PRIVILEGES = 6;
    @VisibleForTesting
    static int ACTION_DOWNLOAD_CONFIRMATION_CODE = 7;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public int mAction;
    private long mCallingToken;
    private DownloadableSubscription mDownloadableSubscription;
    private int mSubscriptionId;
    private boolean mSwitchAfterDownload;
    private String mCallingPackage;

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forGetMetadataDeactivateSim(long callingToken, DownloadableSubscription subscription, String callingPackage) {
        return new EuiccOperation(1, callingToken, subscription, 0, false, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadDeactivateSim(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage) {
        return new EuiccOperation(2, callingToken, subscription, 0, switchAfterDownload, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadNoPrivileges(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage) {
        return new EuiccOperation(3, callingToken, subscription, 0, switchAfterDownload, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadConfirmationCode(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage) {
        return new EuiccOperation(7, callingToken, subscription, 0, switchAfterDownload, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forGetDefaultListDeactivateSim(long callingToken, String callingPackage) {
        return new EuiccOperation(4, callingToken, null, 0, false, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forSwitchDeactivateSim(long callingToken, int subscriptionId, String callingPackage) {
        return new EuiccOperation(5, callingToken, null, subscriptionId, false, callingPackage);
    }

    private static final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forSwitchNoPrivileges(long callingToken, int subscriptionId, String callingPackage) {
        return new EuiccOperation(6, callingToken, null, subscriptionId, false, callingPackage);
    }

    private void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(int action, long callingToken, DownloadableSubscription downloadableSubscription, int subscriptionId, boolean switchAfterDownload, String callingPackage) {
        this.mAction = action;
        this.mCallingToken = callingToken;
        this.mDownloadableSubscription = downloadableSubscription;
        this.mSubscriptionId = subscriptionId;
        this.mSwitchAfterDownload = switchAfterDownload;
        this.mCallingPackage = callingPackage;
    }

    private void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(Parcel in) {
        this.mAction = in.readInt();
        this.mCallingToken = in.readLong();
        this.mDownloadableSubscription = in.readTypedObject(DownloadableSubscription.CREATOR);
        this.mSubscriptionId = in.readInt();
        this.mSwitchAfterDownload = in.readBoolean();
        this.mCallingPackage = in.readString();
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mAction);
        dest.writeLong(this.mCallingToken);
        dest.writeTypedObject(this.mDownloadableSubscription, flags);
        dest.writeInt(this.mSubscriptionId);
        dest.writeBoolean(this.mSwitchAfterDownload);
        dest.writeString(this.mCallingPackage);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$continueOperation(Bundle resolutionExtras, PendingIntent callbackIntent) {
        Binder.restoreCallingIdentity(this.mCallingToken);
        switch (this.mAction) {
            case 1: {
                this.resolvedGetMetadataDeactivateSim(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            case 2: {
                this.resolvedDownloadDeactivateSim(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            case 3: {
                this.resolvedDownloadNoPrivileges(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            case 7: {
                this.resolvedDownloadConfirmationCode(resolutionExtras.getString("android.service.euicc.extra.RESOLUTION_CONFIRMATION_CODE"), callbackIntent);
                break;
            }
            case 4: {
                this.resolvedGetDefaultListDeactivateSim(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            case 5: {
                this.resolvedSwitchDeactivateSim(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            case 6: {
                this.resolvedSwitchNoPrivileges(resolutionExtras.getBoolean("android.service.euicc.extra.RESOLUTION_CONSENT"), callbackIntent);
                break;
            }
            default: {
                Log.wtf("EuiccOperation", "Unknown action: " + this.mAction);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedGetMetadataDeactivateSim(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            EuiccController.get().getDownloadableSubscriptionMetadata(this.mDownloadableSubscription, true, this.mCallingPackage, callbackIntent);
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadDeactivateSim(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            EuiccController.get().downloadSubscription(this.mDownloadableSubscription, this.mSwitchAfterDownload, this.mCallingPackage, true, callbackIntent);
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadNoPrivileges(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            long token = Binder.clearCallingIdentity();
            try {
                EuiccController.get().downloadSubscriptionPrivileged(token, this.mDownloadableSubscription, this.mSwitchAfterDownload, true, this.mCallingPackage, callbackIntent);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadConfirmationCode(String confirmationCode, PendingIntent callbackIntent) {
        if (TextUtils.isEmpty(confirmationCode)) {
            EuiccOperation.fail(callbackIntent);
        } else {
            this.mDownloadableSubscription.setConfirmationCode(confirmationCode);
            EuiccController.get().downloadSubscription(this.mDownloadableSubscription, this.mSwitchAfterDownload, this.mCallingPackage, true, callbackIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedGetDefaultListDeactivateSim(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            EuiccController.get().getDefaultDownloadableSubscriptionList(true, this.mCallingPackage, callbackIntent);
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedSwitchDeactivateSim(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            EuiccController.get().switchToSubscription(this.mSubscriptionId, true, this.mCallingPackage, callbackIntent);
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedSwitchNoPrivileges(boolean consent, PendingIntent callbackIntent) {
        if (consent) {
            long token = Binder.clearCallingIdentity();
            try {
                EuiccController.get().switchToSubscriptionPrivileged(token, this.mSubscriptionId, true, this.mCallingPackage, callbackIntent);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        } else {
            EuiccOperation.fail(callbackIntent);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_euicc_EuiccOperation$fail(PendingIntent callbackIntent) {
        EuiccController.get().sendResult(callbackIntent, 2, null);
    }

    private final int $$robo$$com_android_internal_telephony_euicc_EuiccOperation$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<EuiccOperation>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$__constructor__() {
            }

            private final EuiccOperation $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$createFromParcel(Parcel in) {
                return new EuiccOperation(in);
            }

            private final EuiccOperation[] $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$newArray(int size) {
                return new EuiccOperation[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$__constructor__(), this);
            }

            @Override
            public EuiccOperation createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public EuiccOperation[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_telephony_euicc_EuiccOperation_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static EuiccOperation forGetMetadataDeactivateSim(long l, DownloadableSubscription downloadableSubscription, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forGetMetadataDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forGetMetadataDeactivateSim(long android.telephony.euicc.DownloadableSubscription java.lang.String ), (long)l, (DownloadableSubscription)downloadableSubscription, (String)string2);
    }

    public static EuiccOperation forDownloadDeactivateSim(long l, DownloadableSubscription downloadableSubscription, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forDownloadDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadDeactivateSim(long android.telephony.euicc.DownloadableSubscription boolean java.lang.String ), (long)l, (DownloadableSubscription)downloadableSubscription, (boolean)bl, (String)string2);
    }

    public static EuiccOperation forDownloadNoPrivileges(long l, DownloadableSubscription downloadableSubscription, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forDownloadNoPrivileges", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadNoPrivileges(long android.telephony.euicc.DownloadableSubscription boolean java.lang.String ), (long)l, (DownloadableSubscription)downloadableSubscription, (boolean)bl, (String)string2);
    }

    public static EuiccOperation forDownloadConfirmationCode(long l, DownloadableSubscription downloadableSubscription, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forDownloadConfirmationCode", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forDownloadConfirmationCode(long android.telephony.euicc.DownloadableSubscription boolean java.lang.String ), (long)l, (DownloadableSubscription)downloadableSubscription, (boolean)bl, (String)string2);
    }

    static EuiccOperation forGetDefaultListDeactivateSim(long l, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forGetDefaultListDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forGetDefaultListDeactivateSim(long java.lang.String ), (long)l, (String)string2);
    }

    static EuiccOperation forSwitchDeactivateSim(long l, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forSwitchDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forSwitchDeactivateSim(long int java.lang.String ), (long)l, (int)n, (String)string2);
    }

    static EuiccOperation forSwitchNoPrivileges(long l, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forSwitchNoPrivileges", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$forSwitchNoPrivileges(long int java.lang.String ), (long)l, (int)n, (String)string2);
    }

    private void __constructor__(int n, long l, DownloadableSubscription downloadableSubscription, int n2, boolean bl, String string2) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(n, l, downloadableSubscription, n2, bl, string2);
    }

    public EuiccOperation(int n, long l, DownloadableSubscription downloadableSubscription, int n2, boolean bl, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(int long android.telephony.euicc.DownloadableSubscription int boolean java.lang.String ), this, n, l, downloadableSubscription, n2, bl, string2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(parcel);
    }

    public EuiccOperation(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public void continueOperation(Bundle bundle, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("continueOperation", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$continueOperation(android.os.Bundle android.app.PendingIntent ), this, bundle, pendingIntent);
    }

    private void resolvedGetMetadataDeactivateSim(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedGetMetadataDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedGetMetadataDeactivateSim(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private void resolvedDownloadDeactivateSim(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedDownloadDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadDeactivateSim(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private void resolvedDownloadNoPrivileges(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedDownloadNoPrivileges", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadNoPrivileges(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private void resolvedDownloadConfirmationCode(String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedDownloadConfirmationCode", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedDownloadConfirmationCode(java.lang.String android.app.PendingIntent ), this, string2, pendingIntent);
    }

    private void resolvedGetDefaultListDeactivateSim(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedGetDefaultListDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedGetDefaultListDeactivateSim(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private void resolvedSwitchDeactivateSim(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedSwitchDeactivateSim", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedSwitchDeactivateSim(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private void resolvedSwitchNoPrivileges(boolean bl, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("resolvedSwitchNoPrivileges", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$resolvedSwitchNoPrivileges(boolean android.app.PendingIntent ), this, bl, pendingIntent);
    }

    private static void fail(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrapStatic("fail", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$fail(android.app.PendingIntent ), (PendingIntent)pendingIntent);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_telephony_euicc_EuiccOperation$describeContents(), this);
    }

    static {
        RobolectricInternals.classInitializing(EuiccOperation.class);
    }

    public /* synthetic */ EuiccOperation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccOperation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @VisibleForTesting
    static @interface Action {
    }
}

