/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import android.util.Pair;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.util.SMSDispatcherUtil;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GsmSMSDispatcher
extends SMSDispatcher
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "GsmSMSDispatcher";
    protected UiccController mUiccController;
    private AtomicReference<IccRecords> mIccRecords;
    private AtomicReference<UiccCardApplication> mUiccApplication;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private static int EVENT_NEW_SMS_STATUS_REPORT = 100;

    private void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(Phone phone, SmsDispatchersController smsDispatchersController, GsmInboundSmsHandler gsmInboundSmsHandler) {
        this.mUiccController = null;
        this.mIccRecords = new AtomicReference();
        this.mUiccApplication = new AtomicReference();
        this.mCi.setOnSmsStatus(this, 100, null);
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 15, null);
        Rlog.d("GsmSMSDispatcher", "GsmSMSDispatcher created");
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$dispose() {
        super.dispose();
        this.mCi.unSetOnSmsStatus(this);
        this.mUiccController.unregisterForIccChanged(this);
    }

    private final String $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getFormat() {
        return "3gpp";
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleStatusReport((AsyncResult)msg.obj);
                break;
            }
            case 14: {
                this.mGsmInboundSmsHandler.sendMessage(1, msg.obj);
                break;
            }
            case 15: {
                this.onUpdateIccAvailability();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$shouldBlockSmsForEcbm() {
        return false;
    }

    private final SmsMessageBase.SubmitPduBase $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader, int priority, int validityPeriod) {
        return SMSDispatcherUtil.getSubmitPduGsm(scAddr, destAddr, message, statusReportRequested, validityPeriod);
    }

    private final SmsMessageBase.SubmitPduBase $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] message, boolean statusReportRequested) {
        return SMSDispatcherUtil.getSubmitPduGsm(scAddr, destAddr, destPort, message, statusReportRequested);
    }

    private final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SMSDispatcherUtil.calculateLengthGsm(messageBody, use7bitOnly);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleStatusReport(AsyncResult ar) {
        byte[] pdu = (byte[])ar.result;
        SmsMessage sms = SmsMessage.newFromCDS(pdu);
        if (sms != null) {
            int messageRef = sms.mMessageRef;
            int count = this.deliveryPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                Pair<Boolean, Boolean> result = this.mSmsDispatchersController.handleSmsStatusReport(tracker, this.getFormat(), pdu);
                if (!((Boolean)result.second).booleanValue()) break;
                this.deliveryPendingList.remove(i);
                break;
            }
        }
        this.mCi.acknowledgeLastIncomingGsmSms(true, 1, null);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        if (tracker.mRetryCount > 0) {
            Rlog.d("GsmSMSDispatcher", "sendSms:  mRetryCount=" + tracker.mRetryCount + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
            if ((1 & pdu[0]) == 1) {
                pdu[0] = (byte)(pdu[0] | 4);
                pdu[1] = (byte)tracker.mMessageRef;
            }
        }
        Rlog.d("GsmSMSDispatcher", "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " mUsesImsServiceForIms=" + tracker.mUsesImsServiceForIms + " SS=" + this.mPhone.getServiceState().getState());
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            tracker.onFailed(this.mContext, GsmSMSDispatcher.getNotInServiceError(ss), 0);
            return;
        }
        byte[] smsc = (byte[])map.get("smsc");
        Message reply = this.obtainMessage(2, tracker);
        if (0 == tracker.mImsRetry && !this.isIms() || tracker.mUsesImsServiceForIms) {
            if (tracker.mRetryCount == 0 && tracker.mExpectMore) {
                this.mCi.sendSMSExpectMore(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
            } else {
                this.mCi.sendSMS(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
            }
        } else {
            this.mCi.sendImsGsmSms(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getUiccCardApplication() {
        Rlog.d("GsmSMSDispatcher", "GsmSMSDispatcher: subId = " + this.mPhone.getSubId() + " slotId = " + this.mPhone.getPhoneId());
        return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 1);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        UiccCardApplication app = this.mUiccApplication.get();
        if (app != newUiccApplication) {
            if (app != null) {
                Rlog.d("GsmSMSDispatcher", "Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.mIccRecords.get().unregisterForNewSms(this);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                Rlog.d("GsmSMSDispatcher", "New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                if (this.mIccRecords.get() != null) {
                    this.mIccRecords.get().registerForNewSms(this, 14, null);
                }
            }
        }
    }

    private void __constructor__(Phone phone, SmsDispatchersController smsDispatchersController, GsmInboundSmsHandler gsmInboundSmsHandler) {
        this.$$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(phone, smsDispatchersController, gsmInboundSmsHandler);
    }

    public GsmSMSDispatcher(Phone phone, SmsDispatchersController smsDispatchersController, GsmInboundSmsHandler gsmInboundSmsHandler) {
        super(phone, smsDispatchersController);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsDispatchersController com.android.internal.telephony.gsm.GsmInboundSmsHandler ), this, phone, smsDispatchersController, gsmInboundSmsHandler);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$dispose(), this);
    }

    @Override
    protected String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getFormat(), this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleMessage(android.os.Message ), this, message);
    }

    @Override
    protected boolean shouldBlockSmsForEcbm() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldBlockSmsForEcbm", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$shouldBlockSmsForEcbm(), this);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String string2, String string3, String string4, boolean bl, SmsHeader smsHeader, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean com.android.internal.telephony.SmsHeader int int ), this, string2, string3, string4, bl, smsHeader, n, n2);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSubmitPdu", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getSubmitPdu(java.lang.String java.lang.String int byte[] boolean ), this, string2, string3, n, byArray, bl);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateLength", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$calculateLength(java.lang.CharSequence boolean ), this, charSequence, bl);
    }

    private void handleStatusReport(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleStatusReport", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$handleStatusReport(android.os.AsyncResult ), this, asyncResult);
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSms", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$sendSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), this, smsTracker);
    }

    protected UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$getUiccCardApplication(), this);
    }

    private void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_gsm_GsmSMSDispatcher$onUpdateIccAvailability(), this);
    }

    public /* synthetic */ GsmSMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmSMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

