/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.content.res.Resources;
import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.util.Pair;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.SmsCbHeader;
import java.io.UnsupportedEncodingException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmSmsCbMessage
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String[] LANGUAGE_CODES_GROUP_0;
    private static String[] LANGUAGE_CODES_GROUP_2;
    private static char CARRIAGE_RETURN = '\r';
    private static int PDU_BODY_PAGE_LENGTH = 82;

    private void $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$getEtwsPrimaryMessage(Context context, int category) {
        Resources r = context.getResources();
        switch (category) {
            case 0: {
                return r.getString(17039831);
            }
            case 1: {
                return r.getString(17039835);
            }
            case 2: {
                return r.getString(17039832);
            }
            case 3: {
                return r.getString(17039834);
            }
            case 4: {
                return r.getString(17039833);
            }
        }
        return "";
    }

    private static final SmsCbMessage $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$createSmsCbMessage(Context context, SmsCbHeader header, SmsCbLocation location, byte[][] pdus) throws IllegalArgumentException {
        if (header.isEtwsPrimaryNotification()) {
            return new SmsCbMessage(1, header.getGeographicalScope(), header.getSerialNumber(), location, header.getServiceCategory(), null, GsmSmsCbMessage.getEtwsPrimaryMessage(context, header.getEtwsInfo().getWarningType()), 3, header.getEtwsInfo(), header.getCmasInfo());
        }
        String language = null;
        StringBuilder sb = new StringBuilder();
        for (byte[] pdu : pdus) {
            Pair<String, String> p = GsmSmsCbMessage.parseBody(header, pdu);
            language = (String)p.first;
            sb.append((String)p.second);
        }
        int priority = header.isEmergencyMessage() ? 3 : 0;
        return new SmsCbMessage(1, header.getGeographicalScope(), header.getSerialNumber(), location, header.getServiceCategory(), language, sb.toString(), priority, header.getEtwsInfo(), header.getCmasInfo());
    }

    private static final Pair<String, String> $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$parseBody(SmsCbHeader header, byte[] pdu) {
        int encoding;
        String language = null;
        boolean hasLanguageIndicator = false;
        int dataCodingScheme = header.getDataCodingScheme();
        block0 : switch ((dataCodingScheme & 0xF0) >> 4) {
            case 0: {
                encoding = 1;
                language = LANGUAGE_CODES_GROUP_0[dataCodingScheme & 0xF];
                break;
            }
            case 1: {
                hasLanguageIndicator = true;
                if ((dataCodingScheme & 0xF) == 1) {
                    encoding = 3;
                    break;
                }
                encoding = 1;
                break;
            }
            case 2: {
                encoding = 1;
                language = LANGUAGE_CODES_GROUP_2[dataCodingScheme & 0xF];
                break;
            }
            case 3: {
                encoding = 1;
                break;
            }
            case 4: 
            case 5: {
                switch ((dataCodingScheme & 0xC) >> 2) {
                    case 1: {
                        encoding = 2;
                        break block0;
                    }
                    case 2: {
                        encoding = 3;
                        break block0;
                    }
                }
                encoding = 1;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                throw new IllegalArgumentException("Unsupported GSM dataCodingScheme " + dataCodingScheme);
            }
            case 15: {
                if ((dataCodingScheme & 4) >> 2 == 1) {
                    encoding = 2;
                    break;
                }
                encoding = 1;
                break;
            }
            default: {
                encoding = 1;
            }
        }
        if (header.isUmtsFormat()) {
            int nrPages = pdu[6];
            if (pdu.length < 7 + 83 * nrPages) {
                throw new IllegalArgumentException("Pdu length " + pdu.length + " does not match " + nrPages + " pages");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nrPages; ++i) {
                int offset = 7 + 83 * i;
                byte length = pdu[offset + 82];
                if (length > 82) {
                    throw new IllegalArgumentException("Page length " + length + " exceeds maximum value " + 82);
                }
                Pair<String, String> p = GsmSmsCbMessage.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator, language);
                language = (String)p.first;
                sb.append((String)p.second);
            }
            return new Pair<String, String>(language, sb.toString());
        }
        int offset = 6;
        int length = pdu.length - offset;
        return GsmSmsCbMessage.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator, language);
    }

    private static final Pair<String, String> $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$unpackBody(byte[] pdu, int encoding, int offset, int length, boolean hasLanguageIndicator, String language) {
        String body = null;
        switch (encoding) {
            case 1: {
                body = GsmAlphabet.gsm7BitPackedToString(pdu, offset, length * 8 / 7);
                if (!hasLanguageIndicator || body == null || body.length() <= 2) break;
                language = body.substring(0, 2);
                body = body.substring(3);
                break;
            }
            case 3: {
                if (hasLanguageIndicator && pdu.length >= offset + 2) {
                    language = GsmAlphabet.gsm7BitPackedToString(pdu, offset, 2);
                    offset += 2;
                    length -= 2;
                }
                try {
                    body = new String(pdu, offset, length & 0xFFFE, "utf-16");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Error decoding UTF-16 message", e);
                }
            }
        }
        if (body != null) {
            for (int i = body.length() - 1; i >= 0; --i) {
                if (body.charAt(i) == '\r') continue;
                body = body.substring(0, i + 1);
                break;
            }
        } else {
            body = "";
        }
        return new Pair<String, String>(language, body);
    }

    static void __staticInitializer__() {
        LANGUAGE_CODES_GROUP_0 = new String[]{"de", "en", "it", "fr", "es", "nl", "sv", "da", "pt", "fi", "no", "el", "tr", "hu", "pl", null};
        LANGUAGE_CODES_GROUP_2 = new String[]{"cs", "he", "ar", "ru", "is", null, null, null, null, null, null, null, null, null, null, null};
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$__constructor__();
    }

    public GsmSmsCbMessage() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$__constructor__(), this);
    }

    private static String getEtwsPrimaryMessage(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEtwsPrimaryMessage", $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$getEtwsPrimaryMessage(android.content.Context int ), (Context)context, (int)n);
    }

    public static SmsCbMessage createSmsCbMessage(Context context, SmsCbHeader smsCbHeader, SmsCbLocation smsCbLocation, byte[][] byArray) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("createSmsCbMessage", $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$createSmsCbMessage(android.content.Context com.android.internal.telephony.gsm.SmsCbHeader android.telephony.SmsCbLocation byte[][] ), (Context)context, (SmsCbHeader)smsCbHeader, (SmsCbLocation)smsCbLocation, (byte[][])byArray);
    }

    private static Pair<String, String> parseBody(SmsCbHeader smsCbHeader, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseBody", $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$parseBody(com.android.internal.telephony.gsm.SmsCbHeader byte[] ), (SmsCbHeader)smsCbHeader, (byte[])byArray);
    }

    private static Pair<String, String> unpackBody(byte[] byArray, int n, int n2, int n3, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unpackBody", $$robo$$com_android_internal_telephony_gsm_GsmSmsCbMessage$unpackBody(byte[] int int int boolean java.lang.String ), (byte[])byArray, (int)n, (int)n2, (int)n3, (boolean)bl, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(GsmSmsCbMessage.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmSmsCbMessage)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

