/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.ImsServiceControllerCompat;
import com.android.internal.telephony.ims.ImsServiceControllerStaticCompat;
import com.android.internal.telephony.ims.ImsServiceFeatureQueryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsResolver
implements ImsServiceController.ImsServiceControllerCallbacks,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsResolver";
    public static String METADATA_EMERGENCY_MMTEL_FEATURE = "android.telephony.ims.EMERGENCY_MMTEL_FEATURE";
    public static String METADATA_MMTEL_FEATURE = "android.telephony.ims.MMTEL_FEATURE";
    public static String METADATA_RCS_FEATURE = "android.telephony.ims.RCS_FEATURE";
    private static String METADATA_OVERRIDE_PERM_CHECK = "override_bind_check";
    private static int HANDLER_ADD_PACKAGE = 0;
    private static int HANDLER_REMOVE_PACKAGE = 1;
    private static int HANDLER_CONFIG_CHANGED = 2;
    private static int HANDLER_START_DYNAMIC_FEATURE_QUERY = 3;
    private static int HANDLER_DYNAMIC_FEATURE_CHANGE = 4;
    private static int HANDLER_OVERRIDE_IMS_SERVICE_CONFIG = 5;
    private static int DELAY_DYNAMIC_QUERY_MS = 5000;
    private BroadcastReceiver mAppChangedReceiver;
    private BroadcastReceiver mConfigChangedReceiver;
    private SubscriptionManagerProxy mSubscriptionManagerProxy;
    private ImsServiceControllerFactory mImsServiceControllerFactory;
    private ImsServiceControllerFactory mImsServiceControllerFactoryCompat;
    private ImsServiceControllerFactory mImsServiceControllerFactoryStaticBindingCompat;
    private ImsDynamicQueryManagerFactory mDynamicQueryManagerFactory;
    private CarrierConfigManager mCarrierConfigManager;
    private Context mContext;
    private Object mBoundServicesLock;
    private int mNumSlots;
    private boolean mIsDynamicBinding;
    private String mDeviceService;
    private Handler mHandler;
    private ImsServiceFeatureQueryManager.Listener mDynamicQueryListener;
    private String[] mCarrierServices;
    private List<SparseArray<ImsServiceController>> mBoundImsServicesByFeature;
    private Map<ComponentName, ImsServiceInfo> mInstalledServicesCache;
    private Map<ComponentName, ImsServiceController> mActiveControllers;
    private ComponentName mStaticComponent;
    private ImsServiceFeatureQueryManager mFeatureQueryManager;

    private void $$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(Context context, String defaultImsPackageName, int numSlots, boolean isDynamicBinding) {
        this.mAppChangedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                String packageName = intent.getData().getSchemeSpecificPart();
                switch (action) {
                    case "android.intent.action.PACKAGE_ADDED": 
                    case "android.intent.action.PACKAGE_REPLACED": 
                    case "android.intent.action.PACKAGE_CHANGED": {
                        this.this$0.mHandler.obtainMessage(0, packageName).sendToTarget();
                        break;
                    }
                    case "android.intent.action.PACKAGE_REMOVED": {
                        this.this$0.mHandler.obtainMessage(1, packageName).sendToTarget();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_1$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_ims_ImsResolver_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConfigChangedReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_2$onReceive(Context context, Intent intent) {
                int slotId = intent.getIntExtra("android.telephony.extra.SLOT_INDEX", -1);
                if (slotId == -1) {
                    Log.i("ImsResolver", "Received SIM change for invalid slot id.");
                    return;
                }
                Log.i("ImsResolver", "Received Carrier Config Changed for SlotId: " + slotId);
                this.this$0.mHandler.obtainMessage(2, slotId).sendToTarget();
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_2$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_ims_ImsResolver_2$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSubscriptionManagerProxy = new SubscriptionManagerProxy(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSubId(int slotId) {
                int[] subIds = SubscriptionManager.getSubId(slotId);
                if (subIds != null) {
                    return subIds[0];
                }
                return -1;
            }

            private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSlotIndex(int subId) {
                return SubscriptionManager.getSlotIndex(subId);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public int getSubId(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSubId(int ), this, n);
            }

            @Override
            public int getSlotIndex(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getSlotIndex", $$robo$$com_android_internal_telephony_ims_ImsResolver_3$getSlotIndex(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsServiceControllerFactory = new ImsServiceControllerFactory(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_4$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final String $$robo$$com_android_internal_telephony_ims_ImsResolver_4$getServiceInterface() {
                return "android.telephony.ims.ImsService";
            }

            private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver_4$create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
                return new ImsServiceController(context, componentName, callbacks);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_4$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_4$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public String getServiceInterface() {
                return InvokeDynamicSupport.bootstrap("getServiceInterface", $$robo$$com_android_internal_telephony_ims_ImsResolver_4$getServiceInterface(), this);
            }

            @Override
            public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_telephony_ims_ImsResolver_4$create(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), this, context, componentName, imsServiceControllerCallbacks);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsServiceControllerFactoryCompat = new ImsServiceControllerFactory(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_5$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final String $$robo$$com_android_internal_telephony_ims_ImsResolver_5$getServiceInterface() {
                return "android.telephony.ims.compat.ImsService";
            }

            private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver_5$create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
                return new ImsServiceControllerCompat(context, componentName, callbacks);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_5$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_5$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public String getServiceInterface() {
                return InvokeDynamicSupport.bootstrap("getServiceInterface", $$robo$$com_android_internal_telephony_ims_ImsResolver_5$getServiceInterface(), this);
            }

            @Override
            public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_telephony_ims_ImsResolver_5$create(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), this, context, componentName, imsServiceControllerCallbacks);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsServiceControllerFactoryStaticBindingCompat = new ImsServiceControllerFactory(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_6$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final String $$robo$$com_android_internal_telephony_ims_ImsResolver_6$getServiceInterface() {
                return null;
            }

            private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver_6$create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
                return new ImsServiceControllerStaticCompat(context, componentName, callbacks);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_6$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_6$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public String getServiceInterface() {
                return InvokeDynamicSupport.bootstrap("getServiceInterface", $$robo$$com_android_internal_telephony_ims_ImsResolver_6$getServiceInterface(), this);
            }

            @Override
            public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_telephony_ims_ImsResolver_6$create(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), this, context, componentName, imsServiceControllerCallbacks);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDynamicQueryManagerFactory = ImsServiceFeatureQueryManager::new;
        this.mBoundServicesLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper(), msg -> {
            switch (msg.what) {
                case 0: {
                    String packageName = (String)msg.obj;
                    this.maybeAddedImsService(packageName);
                    break;
                }
                case 1: {
                    String packageName = (String)msg.obj;
                    this.maybeRemovedImsService(packageName);
                    break;
                }
                case 2: {
                    int slotId = (Integer)msg.obj;
                    this.carrierConfigChanged(slotId);
                    break;
                }
                case 3: {
                    ImsServiceInfo info = (ImsServiceInfo)msg.obj;
                    this.startDynamicQuery(info);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ComponentName name = (ComponentName)args.arg1;
                    Set features = (Set)args.arg2;
                    args.recycle();
                    this.dynamicQueryComplete(name, features);
                    break;
                }
                case 5: {
                    int slotId = msg.arg1;
                    boolean isCarrierImsService = msg.arg2 == 1;
                    String packageName = (String)msg.obj;
                    if (isCarrierImsService) {
                        Log.i("ImsResolver", "overriding carrier ImsService - slot=" + slotId + " packageName=" + packageName);
                        this.maybeRebindService(slotId, packageName);
                        break;
                    }
                    Log.i("ImsResolver", "overriding device ImsService -  packageName=" + packageName);
                    if (packageName == null || packageName.isEmpty()) {
                        this.unbindImsService(this.getImsServiceInfoFromCache(this.mDeviceService));
                    }
                    this.mDeviceService = packageName;
                    ImsServiceInfo deviceInfo = this.getImsServiceInfoFromCache(this.mDeviceService);
                    if (deviceInfo == null) break;
                    if (deviceInfo.featureFromMetadata) {
                        this.bindImsService(deviceInfo);
                        break;
                    }
                    this.scheduleQueryForFeatures(deviceInfo);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        this.mDynamicQueryListener = new ImsServiceFeatureQueryManager.Listener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsResolver this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsResolver_7$__constructor__(ImsResolver this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_7$onComplete(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
                Log.d("ImsResolver", "onComplete called for name: " + name + "features:" + this.this$0.printFeatures(features));
                this.this$0.handleFeaturesChanged(name, features);
            }

            private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_7$onError(ComponentName name) {
                Log.w("ImsResolver", "onError: " + name + "returned with an error result");
                this.this$0.scheduleQueryForFeatures(name, 5000);
            }

            private void __constructor__(ImsResolver imsResolver) {
                this.$$robo$$com_android_internal_telephony_ims_ImsResolver_7$__constructor__(imsResolver);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_7$__constructor__(com.android.internal.telephony.ims.ImsResolver ), this, imsResolver);
            }

            @Override
            public void onComplete(ComponentName componentName, Set<ImsFeatureConfiguration.FeatureSlotPair> set) {
                InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_ims_ImsResolver_7$onComplete(android.content.ComponentName java.util.Set<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, componentName, set);
            }

            @Override
            public void onError(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$com_android_internal_telephony_ims_ImsResolver_7$onError(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mInstalledServicesCache = new HashMap<ComponentName, ImsServiceInfo>();
        this.mActiveControllers = new HashMap<ComponentName, ImsServiceController>();
        this.mContext = context;
        this.mDeviceService = defaultImsPackageName;
        this.mNumSlots = numSlots;
        this.mIsDynamicBinding = isDynamicBinding;
        this.mStaticComponent = new ComponentName(this.mContext, ImsResolver.class);
        if (!this.mIsDynamicBinding) {
            Log.i("ImsResolver", "ImsResolver initialized with static binding.");
            this.mDeviceService = this.mStaticComponent.getPackageName();
        }
        this.mCarrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        this.mCarrierServices = new String[numSlots];
        this.mBoundImsServicesByFeature = Stream.generate(SparseArray::new).limit(this.mNumSlots).collect(Collectors.toList());
        if (this.mIsDynamicBinding) {
            IntentFilter appChangedFilter = new IntentFilter();
            appChangedFilter.addAction("android.intent.action.PACKAGE_CHANGED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_REMOVED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_ADDED");
            appChangedFilter.addDataScheme("package");
            context.registerReceiverAsUser(this.mAppChangedReceiver, UserHandle.ALL, appChangedFilter, null, null);
            context.registerReceiver(this.mConfigChangedReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        }
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$setSubscriptionManagerProxy(SubscriptionManagerProxy proxy) {
        this.mSubscriptionManagerProxy = proxy;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsServiceControllerFactory(ImsServiceControllerFactory factory) {
        this.mImsServiceControllerFactory = factory;
    }

    @VisibleForTesting
    private final Handler $$robo$$com_android_internal_telephony_ims_ImsResolver$getHandler() {
        return this.mHandler;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsDynamicQueryManagerFactory(ImsDynamicQueryManagerFactory m) {
        this.mDynamicQueryManagerFactory = m;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$initPopulateCacheAndStartBind() {
        Log.i("ImsResolver", "Initializing cache and binding.");
        this.mFeatureQueryManager = this.mDynamicQueryManagerFactory.create(this.mContext, this.mDynamicQueryListener);
        this.mHandler.obtainMessage(2, -1).sendToTarget();
        this.mHandler.obtainMessage(0, null).sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$enableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).enableIms(slotId);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$disableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).disableIms(slotId);
            }
        }
    }

    private final IImsMmTelFeature $$robo$$com_android_internal_telephony_ims_ImsResolver$getMmTelFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 1, callback);
        return controller != null ? controller.getMmTelFeature(slotId) : null;
    }

    private final IImsRcsFeature $$robo$$com_android_internal_telephony_ims_ImsResolver$getRcsFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 2, callback);
        return controller != null ? controller.getRcsFeature(slotId) : null;
    }

    private final IImsRegistration $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsRegistration(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getRegistration(slotId);
        }
        return null;
    }

    private final IImsConfig $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsConfig(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getConfig(slotId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceController(int slotId, int feature) {
        ImsServiceController controller;
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            controller = services.get(feature);
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SparseArray<ImsServiceController> $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllers(int slotId) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            return services;
        }
    }

    @VisibleForTesting
    private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllerAndListen(int slotId, int feature, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            controller.addImsServiceFeatureCallback(callback);
            return controller;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$overrideImsServiceConfiguration(int slotId, boolean isCarrierService, String packageName) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            Log.w("ImsResolver", "overrideImsServiceConfiguration: invalid slotId!");
            return false;
        }
        if (packageName == null) {
            Log.w("ImsResolver", "overrideImsServiceConfiguration: null packageName!");
            return false;
        }
        int carrierService = isCarrierService ? 1 : 0;
        Message.obtain(this.mHandler, 5, slotId, carrierService, packageName).sendToTarget();
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceConfiguration(int slotId, boolean isCarrierService) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            Log.w("ImsResolver", "getImsServiceConfiguration: invalid slotId!");
            return "";
        }
        return isCarrierService ? this.mCarrierServices[slotId] : this.mDeviceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$putImsController(int slotId, int feature, ImsServiceController controller) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w("ImsResolver", "putImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                services = new SparseArray();
                this.mBoundImsServicesByFeature.add(slotId, services);
            }
            Log.i("ImsResolver", "ImsServiceController added on slot: " + slotId + " with feature: " + feature + " using package: " + controller.getComponentName());
            services.put(feature, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$removeImsController(int slotId, int feature) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w("ImsResolver", "removeImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            ImsServiceController c = services.get(feature, null);
            if (c != null) {
                Log.i("ImsResolver", "ImsServiceController removed on slot: " + slotId + " with feature: " + feature + " using package: " + c.getComponentName());
                services.remove(feature);
            }
            return c;
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeAddedImsService(String packageName) {
        Log.d("ImsResolver", "maybeAddedImsService, packageName: " + packageName);
        List<ImsServiceInfo> infos = this.getImsServiceInfo(packageName);
        ArrayList<ImsServiceInfo> newlyAddedInfos = new ArrayList<ImsServiceInfo>();
        for (ImsServiceInfo info : infos) {
            ImsServiceInfo match = this.getInfoByComponentName(this.mInstalledServicesCache, info.name);
            if (match != null) {
                if (info.featureFromMetadata) {
                    Log.i("ImsResolver", "Updating features in cached ImsService: " + info.name);
                    Log.d("ImsResolver", "Updating features - Old features: " + match + " new features: " + info);
                    match.replaceFeatures(info.getSupportedFeatures());
                    this.updateImsServiceFeatures(info);
                    continue;
                }
                this.scheduleQueryForFeatures(info);
                continue;
            }
            Log.i("ImsResolver", "Adding newly added ImsService to cache: " + info.name);
            this.mInstalledServicesCache.put(info.name, info);
            if (info.featureFromMetadata) {
                newlyAddedInfos.add(info);
                continue;
            }
            this.scheduleQueryForFeatures(info);
        }
        for (ImsServiceInfo info : newlyAddedInfos) {
            if (this.isActiveCarrierService(info)) {
                this.bindImsService(info);
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                continue;
            }
            if (!this.isDeviceService(info)) continue;
            this.bindImsService(info);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRemovedImsService(String packageName) {
        ImsServiceInfo match = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (match != null) {
            this.mInstalledServicesCache.remove(match.name);
            Log.i("ImsResolver", "Removing ImsService: " + match.name);
            this.unbindImsService(match);
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$isActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$isDeviceService(ImsServiceInfo info) {
        return TextUtils.equals(this.mDeviceService, info.name.getPackageName());
    }

    private final int $$robo$$com_android_internal_telephony_ims_ImsResolver$getSlotForActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return i;
        }
        return -1;
    }

    private final ImsServiceController $$robo$$com_android_internal_telephony_ims_ImsResolver$getControllerByServiceInfo(Map<ComponentName, ImsServiceController> searchMap, ImsServiceInfo matchValue) {
        return searchMap.values().stream().filter(c -> Objects.equals(c.getComponentName(), matchValue.name)).findFirst().orElse(null);
    }

    private final ImsServiceInfo $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByPackageName(Map<ComponentName, ImsServiceInfo> searchMap, String matchValue) {
        return searchMap.values().stream().filter(i -> Objects.equals(i.name.getPackageName(), matchValue)).findFirst().orElse(null);
    }

    private final ImsServiceInfo $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByComponentName(Map<ComponentName, ImsServiceInfo> searchMap, ComponentName matchValue) {
        return searchMap.get(matchValue);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$updateImsServiceFeatures(ImsServiceInfo newInfo) {
        if (newInfo == null) {
            return;
        }
        ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, newInfo);
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> features = this.calculateFeaturesToCreate(newInfo);
        if (this.shouldFeaturesCauseBind(features)) {
            try {
                if (controller != null) {
                    Log.i("ImsResolver", "Updating features for ImsService: " + controller.getComponentName());
                    Log.d("ImsResolver", "Updating Features - New Features: " + features);
                    controller.changeImsServiceFeatures(features);
                } else {
                    Log.i("ImsResolver", "updateImsServiceFeatures: unbound with active features, rebinding");
                    this.bindImsServiceWithFeatures(newInfo, features);
                }
                if (this.isActiveCarrierService(newInfo) && !TextUtils.equals(newInfo.name.getPackageName(), this.mDeviceService)) {
                    Log.i("ImsResolver", "Updating device default");
                    this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                }
            }
            catch (RemoteException e) {
                Log.e("ImsResolver", "updateImsServiceFeatures: Remote Exception: " + e.getMessage());
            }
        } else if (controller != null) {
            Log.i("ImsResolver", "Unbinding: features = 0 for ImsService: " + controller.getComponentName());
            this.unbindImsService(newInfo);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$bindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> features = this.calculateFeaturesToCreate(info);
        this.bindImsServiceWithFeatures(info, features);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$bindImsServiceWithFeatures(ImsServiceInfo info, HashSet<ImsFeatureConfiguration.FeatureSlotPair> features) {
        if (this.shouldFeaturesCauseBind(features)) {
            ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, info);
            if (controller != null) {
                Log.i("ImsResolver", "ImsService connection exists, updating features " + features);
                try {
                    controller.changeImsServiceFeatures(features);
                }
                catch (RemoteException e) {
                    Log.w("ImsResolver", "bindImsService: error=" + e.getMessage());
                }
            } else {
                controller = info.controllerFactory.create(this.mContext, info.name, this);
                Log.i("ImsResolver", "Binding ImsService: " + controller.getComponentName() + " with features: " + features);
                controller.bind(features);
            }
            this.mActiveControllers.put(info.name, controller);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$unbindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, info);
        if (controller != null) {
            try {
                Log.i("ImsResolver", "Unbinding ImsService: " + controller.getComponentName());
                controller.unbind();
            }
            catch (RemoteException e) {
                Log.e("ImsResolver", "unbindImsService: Remote Exception: " + e.getMessage());
            }
            this.mActiveControllers.remove(info.name);
        }
    }

    private final HashSet<ImsFeatureConfiguration.FeatureSlotPair> $$robo$$com_android_internal_telephony_ims_ImsResolver$calculateFeaturesToCreate(ImsServiceInfo info) {
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> imsFeaturesBySlot = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>();
        int slotId = this.getSlotForActiveCarrierService(info);
        if (slotId != -1) {
            imsFeaturesBySlot.addAll(info.getSupportedFeatures().stream().filter(feature -> slotId == feature.slotId).collect(Collectors.toList()));
        } else if (this.isDeviceService(info)) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                int currSlotId = i;
                ImsServiceInfo carrierImsInfo = this.getImsServiceInfoFromCache(this.mCarrierServices[i]);
                if (carrierImsInfo == null) {
                    imsFeaturesBySlot.addAll(info.getSupportedFeatures().stream().filter(feature -> currSlotId == feature.slotId).collect(Collectors.toList()));
                    continue;
                }
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> deviceFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(info.getSupportedFeatures());
                deviceFeatures.removeAll(carrierImsInfo.getSupportedFeatures());
                imsFeaturesBySlot.addAll(deviceFeatures.stream().filter(feature -> currSlotId == feature.slotId).collect(Collectors.toList()));
            }
        }
        return imsFeaturesBySlot;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureCreated(int slotId, int feature, ImsServiceController controller) {
        this.putImsController(slotId, feature, controller);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureRemoved(int slotId, int feature, ImsServiceController controller) {
        this.removeImsController(slotId, feature);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeaturesChanged(ImsFeatureConfiguration config, ImsServiceController controller) {
        if (controller == null || config == null) {
            return;
        }
        Log.i("ImsResolver", "imsServiceFeaturesChanged: config=" + config.getServiceFeatures() + ", ComponentName=" + controller.getComponentName());
        this.handleFeaturesChanged(controller.getComponentName(), config.getServiceFeatures());
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver$shouldFeaturesCauseBind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> features) {
        long bindableFeatures = features.stream().filter(f -> f.featureType != 0).count();
        return bindableFeatures > 0L;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRebindService(int slotId, String newPackageName) {
        if (slotId <= -1) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                this.updateBoundCarrierServices(i, newPackageName);
            }
        } else {
            this.updateBoundCarrierServices(slotId, newPackageName);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$carrierConfigChanged(int slotId) {
        int subId = this.mSubscriptionManagerProxy.getSubId(slotId);
        PersistableBundle config = this.mCarrierConfigManager.getConfigForSubId(subId);
        if (config != null) {
            String newPackageName = config.getString("config_ims_package_override_string", null);
            this.maybeRebindService(slotId, newPackageName);
        } else {
            Log.w("ImsResolver", "carrierConfigChanged: CarrierConfig is null!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$updateBoundCarrierServices(int slotId, String newPackageName) {
        if (slotId > -1 && slotId < this.mNumSlots) {
            String oldPackageName = this.mCarrierServices[slotId];
            this.mCarrierServices[slotId] = newPackageName;
            if (!TextUtils.equals(newPackageName, oldPackageName)) {
                Log.i("ImsResolver", "Carrier Config updated, binding new ImsService");
                this.unbindImsService(this.getImsServiceInfoFromCache(oldPackageName));
                ImsServiceInfo newInfo = this.getImsServiceInfoFromCache(newPackageName);
                if (newInfo == null || newInfo.featureFromMetadata) {
                    this.bindImsService(newInfo);
                    this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                } else {
                    this.scheduleQueryForFeatures(newInfo);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(ImsServiceInfo service, int delayMs) {
        if (!this.isDeviceService(service) && this.getSlotForActiveCarrierService(service) == -1) {
            Log.i("ImsResolver", "scheduleQueryForFeatures: skipping query for ImsService that is not set as carrier/device ImsService.");
            return;
        }
        Message msg = Message.obtain(this.mHandler, 3, service);
        if (this.mHandler.hasMessages(3, service)) {
            Log.d("ImsResolver", "scheduleQueryForFeatures: dynamic query for " + service.name + " already scheduled");
            return;
        }
        Log.d("ImsResolver", "scheduleQueryForFeatures: starting dynamic query for " + service.name + " in " + delayMs + "ms.");
        this.mHandler.sendMessageDelayed(msg, delayMs);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(ComponentName name, int delayMs) {
        ImsServiceInfo service = this.getImsServiceInfoFromCache(name.getPackageName());
        if (service == null) {
            Log.w("ImsResolver", "scheduleQueryForFeatures: Couldn't find cached info for name: " + name);
            return;
        }
        this.scheduleQueryForFeatures(service, delayMs);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(ImsServiceInfo service) {
        this.scheduleQueryForFeatures(service, 0);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$handleFeaturesChanged(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = name;
        args.arg2 = features;
        this.mHandler.obtainMessage(4, args).sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$startDynamicQuery(ImsServiceInfo service) {
        boolean queryStarted = this.mFeatureQueryManager.startQuery(service.name, service.controllerFactory.getServiceInterface());
        if (!queryStarted) {
            Log.w("ImsResolver", "startDynamicQuery: service could not connect. Retrying after delay.");
            this.scheduleQueryForFeatures(service, 5000);
        } else {
            Log.d("ImsResolver", "startDynamicQuery: Service queried, waiting for response.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsResolver$dynamicQueryComplete(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        ImsServiceInfo service = this.getImsServiceInfoFromCache(name.getPackageName());
        if (service == null) {
            Log.w("ImsResolver", "handleFeaturesChanged: Couldn't find cached info for name: " + name);
            return;
        }
        service.replaceFeatures(features);
        if (this.isActiveCarrierService(service)) {
            this.bindImsService(service);
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
        } else if (this.isDeviceService(service)) {
            this.bindImsService(service);
        }
    }

    private final String $$robo$$com_android_internal_telephony_ims_ImsResolver$printFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        StringBuilder featureString = new StringBuilder();
        featureString.append("features: [");
        if (features != null) {
            for (ImsFeatureConfiguration.FeatureSlotPair feature : features) {
                featureString.append("{");
                featureString.append(feature.slotId);
                featureString.append(",");
                featureString.append(feature.featureType);
                featureString.append("} ");
            }
            featureString.append("]");
        }
        return featureString.toString();
    }

    @VisibleForTesting
    private final ImsServiceInfo $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfoFromCache(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        ImsServiceInfo infoFilter = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (infoFilter != null) {
            return infoFilter;
        }
        return null;
    }

    private final List<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfo(String packageName) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        if (!this.mIsDynamicBinding) {
            infos.addAll(this.getStaticImsService());
        } else {
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactory));
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactoryCompat));
        }
        return infos;
    }

    private final List<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$getStaticImsService() {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        ImsServiceInfo info = new ImsServiceInfo(this.mNumSlots);
        info.name = this.mStaticComponent;
        info.controllerFactory = this.mImsServiceControllerFactoryStaticBindingCompat;
        info.addFeatureForAllSlots(0);
        info.addFeatureForAllSlots(1);
        infos.add(info);
        return infos;
    }

    private final List<ImsServiceInfo> $$robo$$com_android_internal_telephony_ims_ImsResolver$searchForImsServices(String packageName, ImsServiceControllerFactory controllerFactory) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        Intent serviceIntent = new Intent(controllerFactory.getServiceInterface());
        serviceIntent.setPackage(packageName);
        PackageManager packageManager = this.mContext.getPackageManager();
        for (ResolveInfo entry : packageManager.queryIntentServicesAsUser(serviceIntent, 128, this.mContext.getUserId())) {
            ServiceInfo serviceInfo = entry.serviceInfo;
            if (serviceInfo == null) continue;
            ImsServiceInfo info = new ImsServiceInfo(this.mNumSlots);
            info.name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
            info.controllerFactory = controllerFactory;
            if (this.isDeviceService(info) || this.mImsServiceControllerFactoryCompat == controllerFactory) {
                if (serviceInfo.metaData != null) {
                    if (serviceInfo.metaData.getBoolean("android.telephony.ims.EMERGENCY_MMTEL_FEATURE", false)) {
                        info.addFeatureForAllSlots(0);
                    }
                    if (serviceInfo.metaData.getBoolean("android.telephony.ims.MMTEL_FEATURE", false)) {
                        info.addFeatureForAllSlots(1);
                    }
                    if (serviceInfo.metaData.getBoolean("android.telephony.ims.RCS_FEATURE", false)) {
                        info.addFeatureForAllSlots(2);
                    }
                }
                if (this.mImsServiceControllerFactoryCompat != controllerFactory && info.getSupportedFeatures().isEmpty()) {
                    info.featureFromMetadata = false;
                }
            } else {
                info.featureFromMetadata = false;
            }
            Log.i("ImsResolver", "service name: " + info.name + ", manifest query: " + info.featureFromMetadata);
            if (TextUtils.equals(serviceInfo.permission, "android.permission.BIND_IMS_SERVICE") || serviceInfo.metaData.getBoolean("override_bind_check", false)) {
                infos.add(info);
                continue;
            }
            Log.w("ImsResolver", "ImsService is not protected with BIND_IMS_SERVICE permission: " + info.name);
        }
        return infos;
    }

    private void __constructor__(Context context, String string2, int n, boolean bl) {
        this.$$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(context, string2, n, bl);
    }

    public ImsResolver(Context context, String string2, int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver$__constructor__(android.content.Context java.lang.String int boolean ), this, context, string2, n, bl);
    }

    public void setSubscriptionManagerProxy(SubscriptionManagerProxy subscriptionManagerProxy) {
        InvokeDynamicSupport.bootstrap("setSubscriptionManagerProxy", $$robo$$com_android_internal_telephony_ims_ImsResolver$setSubscriptionManagerProxy(com.android.internal.telephony.ims.ImsResolver$SubscriptionManagerProxy ), this, subscriptionManagerProxy);
    }

    public void setImsServiceControllerFactory(ImsServiceControllerFactory imsServiceControllerFactory) {
        InvokeDynamicSupport.bootstrap("setImsServiceControllerFactory", $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsServiceControllerFactory(com.android.internal.telephony.ims.ImsResolver$ImsServiceControllerFactory ), this, imsServiceControllerFactory);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_telephony_ims_ImsResolver$getHandler(), this);
    }

    public void setImsDynamicQueryManagerFactory(ImsDynamicQueryManagerFactory imsDynamicQueryManagerFactory) {
        InvokeDynamicSupport.bootstrap("setImsDynamicQueryManagerFactory", $$robo$$com_android_internal_telephony_ims_ImsResolver$setImsDynamicQueryManagerFactory(com.android.internal.telephony.ims.ImsResolver$ImsDynamicQueryManagerFactory ), this, imsDynamicQueryManagerFactory);
    }

    public void initPopulateCacheAndStartBind() {
        InvokeDynamicSupport.bootstrap("initPopulateCacheAndStartBind", $$robo$$com_android_internal_telephony_ims_ImsResolver$initPopulateCacheAndStartBind(), this);
    }

    public void enableIms(int n) {
        InvokeDynamicSupport.bootstrap("enableIms", $$robo$$com_android_internal_telephony_ims_ImsResolver$enableIms(int ), this, n);
    }

    public void disableIms(int n) {
        InvokeDynamicSupport.bootstrap("disableIms", $$robo$$com_android_internal_telephony_ims_ImsResolver$disableIms(int ), this, n);
    }

    public IImsMmTelFeature getMmTelFeatureAndListen(int n, IImsServiceFeatureCallback iImsServiceFeatureCallback) {
        return InvokeDynamicSupport.bootstrap("getMmTelFeatureAndListen", $$robo$$com_android_internal_telephony_ims_ImsResolver$getMmTelFeatureAndListen(int com.android.ims.internal.IImsServiceFeatureCallback ), this, n, iImsServiceFeatureCallback);
    }

    public IImsRcsFeature getRcsFeatureAndListen(int n, IImsServiceFeatureCallback iImsServiceFeatureCallback) {
        return InvokeDynamicSupport.bootstrap("getRcsFeatureAndListen", $$robo$$com_android_internal_telephony_ims_ImsResolver$getRcsFeatureAndListen(int com.android.ims.internal.IImsServiceFeatureCallback ), this, n, iImsServiceFeatureCallback);
    }

    public IImsRegistration getImsRegistration(int n, int n2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getImsRegistration", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsRegistration(int int ), this, n, n2);
    }

    public IImsConfig getImsConfig(int n, int n2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getImsConfig", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsConfig(int int ), this, n, n2);
    }

    public ImsServiceController getImsServiceController(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getImsServiceController", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceController(int int ), this, n, n2);
    }

    private SparseArray<ImsServiceController> getImsServiceControllers(int n) {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllers", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllers(int ), this, n);
    }

    public ImsServiceController getImsServiceControllerAndListen(int n, int n2, IImsServiceFeatureCallback iImsServiceFeatureCallback) {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllerAndListen", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceControllerAndListen(int int com.android.ims.internal.IImsServiceFeatureCallback ), this, n, n2, iImsServiceFeatureCallback);
    }

    public boolean overrideImsServiceConfiguration(int n, boolean bl, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("overrideImsServiceConfiguration", $$robo$$com_android_internal_telephony_ims_ImsResolver$overrideImsServiceConfiguration(int boolean java.lang.String ), this, n, bl, string2);
    }

    public String getImsServiceConfiguration(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getImsServiceConfiguration", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceConfiguration(int boolean ), this, n, bl);
    }

    private void putImsController(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("putImsController", $$robo$$com_android_internal_telephony_ims_ImsResolver$putImsController(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    private ImsServiceController removeImsController(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("removeImsController", $$robo$$com_android_internal_telephony_ims_ImsResolver$removeImsController(int int ), this, n, n2);
    }

    private void maybeAddedImsService(String string2) {
        InvokeDynamicSupport.bootstrap("maybeAddedImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeAddedImsService(java.lang.String ), this, string2);
    }

    private boolean maybeRemovedImsService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("maybeRemovedImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRemovedImsService(java.lang.String ), this, string2);
    }

    private boolean isActiveCarrierService(ImsServiceInfo imsServiceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveCarrierService", $$robo$$com_android_internal_telephony_ims_ImsResolver$isActiveCarrierService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private boolean isDeviceService(ImsServiceInfo imsServiceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceService", $$robo$$com_android_internal_telephony_ims_ImsResolver$isDeviceService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private int getSlotForActiveCarrierService(ImsServiceInfo imsServiceInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotForActiveCarrierService", $$robo$$com_android_internal_telephony_ims_ImsResolver$getSlotForActiveCarrierService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private ImsServiceController getControllerByServiceInfo(Map<ComponentName, ImsServiceController> map, ImsServiceInfo imsServiceInfo) {
        return InvokeDynamicSupport.bootstrap("getControllerByServiceInfo", $$robo$$com_android_internal_telephony_ims_ImsResolver$getControllerByServiceInfo(java.util.Map<android.content.ComponentName, com.android.internal.telephony.ims.ImsServiceController> com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, map, imsServiceInfo);
    }

    private ImsServiceInfo getInfoByPackageName(Map<ComponentName, ImsServiceInfo> map, String string2) {
        return InvokeDynamicSupport.bootstrap("getInfoByPackageName", $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByPackageName(java.util.Map<android.content.ComponentName, com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo> java.lang.String ), this, map, string2);
    }

    private ImsServiceInfo getInfoByComponentName(Map<ComponentName, ImsServiceInfo> map, ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getInfoByComponentName", $$robo$$com_android_internal_telephony_ims_ImsResolver$getInfoByComponentName(java.util.Map<android.content.ComponentName, com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo> android.content.ComponentName ), this, map, componentName);
    }

    private void updateImsServiceFeatures(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("updateImsServiceFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$updateImsServiceFeatures(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void bindImsService(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("bindImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$bindImsService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void bindImsServiceWithFeatures(ImsServiceInfo imsServiceInfo, HashSet<ImsFeatureConfiguration.FeatureSlotPair> hashSet) {
        InvokeDynamicSupport.bootstrap("bindImsServiceWithFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$bindImsServiceWithFeatures(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo java.util.HashSet<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, imsServiceInfo, hashSet);
    }

    private void unbindImsService(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("unbindImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$unbindImsService(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private HashSet<ImsFeatureConfiguration.FeatureSlotPair> calculateFeaturesToCreate(ImsServiceInfo imsServiceInfo) {
        return InvokeDynamicSupport.bootstrap("calculateFeaturesToCreate", $$robo$$com_android_internal_telephony_ims_ImsResolver$calculateFeaturesToCreate(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    @Override
    public void imsServiceFeatureCreated(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("imsServiceFeatureCreated", $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureCreated(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    @Override
    public void imsServiceFeatureRemoved(int n, int n2, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("imsServiceFeatureRemoved", $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeatureRemoved(int int com.android.internal.telephony.ims.ImsServiceController ), this, n, n2, imsServiceController);
    }

    @Override
    public void imsServiceFeaturesChanged(ImsFeatureConfiguration imsFeatureConfiguration, ImsServiceController imsServiceController) {
        InvokeDynamicSupport.bootstrap("imsServiceFeaturesChanged", $$robo$$com_android_internal_telephony_ims_ImsResolver$imsServiceFeaturesChanged(android.telephony.ims.stub.ImsFeatureConfiguration com.android.internal.telephony.ims.ImsServiceController ), this, imsFeatureConfiguration, imsServiceController);
    }

    private boolean shouldFeaturesCauseBind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> hashSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldFeaturesCauseBind", $$robo$$com_android_internal_telephony_ims_ImsResolver$shouldFeaturesCauseBind(java.util.HashSet<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, hashSet);
    }

    private void maybeRebindService(int n, String string2) {
        InvokeDynamicSupport.bootstrap("maybeRebindService", $$robo$$com_android_internal_telephony_ims_ImsResolver$maybeRebindService(int java.lang.String ), this, n, string2);
    }

    private void carrierConfigChanged(int n) {
        InvokeDynamicSupport.bootstrap("carrierConfigChanged", $$robo$$com_android_internal_telephony_ims_ImsResolver$carrierConfigChanged(int ), this, n);
    }

    private void updateBoundCarrierServices(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateBoundCarrierServices", $$robo$$com_android_internal_telephony_ims_ImsResolver$updateBoundCarrierServices(int java.lang.String ), this, n, string2);
    }

    private void scheduleQueryForFeatures(ImsServiceInfo imsServiceInfo, int n) {
        InvokeDynamicSupport.bootstrap("scheduleQueryForFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo int ), this, imsServiceInfo, n);
    }

    private void scheduleQueryForFeatures(ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("scheduleQueryForFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(android.content.ComponentName int ), this, componentName, n);
    }

    private void scheduleQueryForFeatures(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("scheduleQueryForFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$scheduleQueryForFeatures(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void handleFeaturesChanged(ComponentName componentName, Set<ImsFeatureConfiguration.FeatureSlotPair> set) {
        InvokeDynamicSupport.bootstrap("handleFeaturesChanged", $$robo$$com_android_internal_telephony_ims_ImsResolver$handleFeaturesChanged(android.content.ComponentName java.util.Set<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, componentName, set);
    }

    private void startDynamicQuery(ImsServiceInfo imsServiceInfo) {
        InvokeDynamicSupport.bootstrap("startDynamicQuery", $$robo$$com_android_internal_telephony_ims_ImsResolver$startDynamicQuery(com.android.internal.telephony.ims.ImsResolver$ImsServiceInfo ), this, imsServiceInfo);
    }

    private void dynamicQueryComplete(ComponentName componentName, Set<ImsFeatureConfiguration.FeatureSlotPair> set) {
        InvokeDynamicSupport.bootstrap("dynamicQueryComplete", $$robo$$com_android_internal_telephony_ims_ImsResolver$dynamicQueryComplete(android.content.ComponentName java.util.Set<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, componentName, set);
    }

    private String printFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> set) {
        return InvokeDynamicSupport.bootstrap("printFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver$printFeatures(java.util.Set<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, set);
    }

    public ImsServiceInfo getImsServiceInfoFromCache(String string2) {
        return InvokeDynamicSupport.bootstrap("getImsServiceInfoFromCache", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfoFromCache(java.lang.String ), this, string2);
    }

    private List<ImsServiceInfo> getImsServiceInfo(String string2) {
        return InvokeDynamicSupport.bootstrap("getImsServiceInfo", $$robo$$com_android_internal_telephony_ims_ImsResolver$getImsServiceInfo(java.lang.String ), this, string2);
    }

    private List<ImsServiceInfo> getStaticImsService() {
        return InvokeDynamicSupport.bootstrap("getStaticImsService", $$robo$$com_android_internal_telephony_ims_ImsResolver$getStaticImsService(), this);
    }

    private List<ImsServiceInfo> searchForImsServices(String string2, ImsServiceControllerFactory imsServiceControllerFactory) {
        return InvokeDynamicSupport.bootstrap("searchForImsServices", $$robo$$com_android_internal_telephony_ims_ImsResolver$searchForImsServices(java.lang.String com.android.internal.telephony.ims.ImsResolver$ImsServiceControllerFactory ), this, string2, imsServiceControllerFactory);
    }

    public /* synthetic */ ImsResolver() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsResolver)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public static interface ImsDynamicQueryManagerFactory {
        public ImsServiceFeatureQueryManager create(Context var1, ImsServiceFeatureQueryManager.Listener var2);
    }

    @VisibleForTesting
    public static interface ImsServiceControllerFactory {
        public String getServiceInterface();

        public ImsServiceController create(Context var1, ComponentName var2, ImsServiceController.ImsServiceControllerCallbacks var3);
    }

    @VisibleForTesting
    public static interface SubscriptionManagerProxy {
        public int getSubId(int var1);

        public int getSlotIndex(int var1);
    }

    @VisibleForTesting
    public static class ImsServiceInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ComponentName name;
        public boolean featureFromMetadata;
        public ImsServiceControllerFactory controllerFactory;
        private HashSet<ImsFeatureConfiguration.FeatureSlotPair> mSupportedFeatures;
        private int mNumSlots;

        private void $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__(int numSlots) {
            this.featureFromMetadata = true;
            this.mNumSlots = numSlots;
            this.mSupportedFeatures = new HashSet();
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$addFeatureForAllSlots(int feature) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                this.mSupportedFeatures.add(new ImsFeatureConfiguration.FeatureSlotPair(i, feature));
            }
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$replaceFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> newFeatures) {
            this.mSupportedFeatures.clear();
            this.mSupportedFeatures.addAll(newFeatures);
        }

        @VisibleForTesting
        private final HashSet<ImsFeatureConfiguration.FeatureSlotPair> $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$getSupportedFeatures() {
            return this.mSupportedFeatures;
        }

        private final boolean $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsServiceInfo that = (ImsServiceInfo)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (!this.mSupportedFeatures.equals(that.mSupportedFeatures)) {
                return false;
            }
            return this.controllerFactory != null ? this.controllerFactory.equals(that.controllerFactory) : that.controllerFactory == null;
        }

        private final int $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.controllerFactory != null ? this.controllerFactory.hashCode() : 0);
            return result;
        }

        private final String $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$toString() {
            StringBuilder res = new StringBuilder();
            res.append("[ImsServiceInfo] name=");
            res.append(this.name);
            res.append(", supportedFeatures=[ ");
            for (ImsFeatureConfiguration.FeatureSlotPair feature : this.mSupportedFeatures) {
                res.append("(");
                res.append(feature.slotId);
                res.append(",");
                res.append(feature.featureType);
                res.append(") ");
            }
            return res.toString();
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__(n);
        }

        public ImsServiceInfo(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$__constructor__(int ), this, n);
        }

        void addFeatureForAllSlots(int n) {
            InvokeDynamicSupport.bootstrap("addFeatureForAllSlots", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$addFeatureForAllSlots(int ), this, n);
        }

        void replaceFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> set) {
            InvokeDynamicSupport.bootstrap("replaceFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$replaceFeatures(java.util.Set<android.telephony.ims.stub.ImsFeatureConfiguration$FeatureSlotPair> ), this, set);
        }

        public HashSet<ImsFeatureConfiguration.FeatureSlotPair> getSupportedFeatures() {
            return InvokeDynamicSupport.bootstrap("getSupportedFeatures", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$getSupportedFeatures(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_ims_ImsResolver_ImsServiceInfo$toString(), this);
        }

        public /* synthetic */ ImsServiceInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

