/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.os.SystemClock;
import com.android.internal.telephony.metrics.CallSessionEventBuilder;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.nano.TelephonyProto;
import java.util.ArrayDeque;
import java.util.Deque;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InProgressCallSession
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MAX_EVENTS = 300;
    public int phoneId;
    public Deque<TelephonyProto.TelephonyCallSession.Event> events;
    public int startSystemTimeMin;
    public long startElapsedTimeMs;
    private long mLastElapsedTimeMs;
    private boolean mEventsDropped;
    private int mLastKnownPhoneState;

    private final boolean $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$isEventsDropped() {
        return this.mEventsDropped;
    }

    private void $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$__constructor__(int phoneId) {
        this.mEventsDropped = false;
        this.phoneId = phoneId;
        this.events = new ArrayDeque<TelephonyProto.TelephonyCallSession.Event>();
        this.startSystemTimeMin = TelephonyMetrics.roundSessionStart((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.mLastElapsedTimeMs = this.startElapsedTimeMs = SystemClock.elapsedRealtime();
    }

    private final void $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$addEvent(CallSessionEventBuilder builder) {
        this.addEvent(SystemClock.elapsedRealtime(), builder);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$addEvent(long timestamp, CallSessionEventBuilder builder) {
        if (this.events.size() >= 300) {
            this.events.removeFirst();
            this.mEventsDropped = true;
        }
        builder.setDelay(TelephonyMetrics.toPrivacyFuzzedTimeInterval(this.mLastElapsedTimeMs, timestamp));
        this.events.add(builder.build());
        this.mLastElapsedTimeMs = timestamp;
    }

    private final boolean $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$containsCsCalls() {
        for (TelephonyProto.TelephonyCallSession.Event event : this.events) {
            if (event.type != 10) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$setLastKnownPhoneState(int state) {
        this.mLastKnownPhoneState = state;
    }

    private final boolean $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$isPhoneIdle() {
        return this.mLastKnownPhoneState == 1;
    }

    public boolean isEventsDropped() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEventsDropped", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$isEventsDropped(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_telephony_metrics_InProgressCallSession$__constructor__(n);
    }

    public InProgressCallSession(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$__constructor__(int ), this, n);
    }

    public void addEvent(CallSessionEventBuilder callSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$addEvent(com.android.internal.telephony.metrics.CallSessionEventBuilder ), this, callSessionEventBuilder);
    }

    public synchronized void addEvent(long l, CallSessionEventBuilder callSessionEventBuilder) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$addEvent(long com.android.internal.telephony.metrics.CallSessionEventBuilder ), this, l, callSessionEventBuilder);
    }

    public boolean containsCsCalls() {
        return (boolean)InvokeDynamicSupport.bootstrap("containsCsCalls", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$containsCsCalls(), this);
    }

    public void setLastKnownPhoneState(int n) {
        InvokeDynamicSupport.bootstrap("setLastKnownPhoneState", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$setLastKnownPhoneState(int ), this, n);
    }

    public boolean isPhoneIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneIdle", $$robo$$com_android_internal_telephony_metrics_InProgressCallSession$isPhoneIdle(), this);
    }

    public /* synthetic */ InProgressCallSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InProgressCallSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

