/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioGroup;
import android.net.sip.SipAudioCall;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.sip.SipCallBase;
import com.android.internal.telephony.sip.SipConnectionBase;
import com.android.internal.telephony.sip.SipPhoneBase;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SipPhone
extends SipPhoneBase
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SipPhone";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int TIMEOUT_MAKE_CALL = 15;
    private static int TIMEOUT_ANSWER_CALL = 8;
    private static int TIMEOUT_HOLD_CALL = 15;
    private static long TIMEOUT_HOLD_PROCESSING = 1000L;
    private SipCall mRingingCall;
    private SipCall mForegroundCall;
    private SipCall mBackgroundCall;
    private SipManager mSipManager;
    private SipProfile mProfile;
    private long mTimeOfLastValidHoldRequest;

    private void $$robo$$com_android_internal_telephony_sip_SipPhone$__constructor__(Context context, PhoneNotifier notifier, SipProfile profile) {
        this.mRingingCall = new SipCall(this, null);
        this.mForegroundCall = new SipCall(this, null);
        this.mBackgroundCall = new SipCall(this, null);
        this.mTimeOfLastValidHoldRequest = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.log("new SipPhone: " + SipPhone.hidePii(profile.getUriString()));
        this.mRingingCall = new SipCall(this, null);
        this.mForegroundCall = new SipCall(this, null);
        this.mBackgroundCall = new SipCall(this, null);
        this.mProfile = profile;
        this.mSipManager = SipManager.newInstance((Context)context);
    }

    private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipPhone)) {
            return false;
        }
        SipPhone that = (SipPhone)o;
        return this.mProfile.getUriString().equals(that.mProfile.getUriString());
    }

    private final String $$robo$$com_android_internal_telephony_sip_SipPhone$getSipUri() {
        return this.mProfile.getUriString();
    }

    private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone$equals(SipPhone phone) {
        return this.getSipUri().equals(phone.getSipUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection $$robo$$com_android_internal_telephony_sip_SipPhone$takeIncomingCall(Object incomingCall) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(incomingCall instanceof SipAudioCall)) {
                this.log("takeIncomingCall: ret=null, not a SipAudioCall");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (this.mRingingCall.getState().isAlive()) {
                this.log("takeIncomingCall: ret=null, ringingCall not alive");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
                this.log("takeIncomingCall: ret=null, foreground and background both alive");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            try {
                SipAudioCall sipAudioCall = (SipAudioCall)incomingCall;
                this.log("takeIncomingCall: taking call from: " + SipPhone.hidePii(sipAudioCall.getPeerProfile().getUriString()));
                String localUri = sipAudioCall.getLocalProfile().getUriString();
                if (localUri.equals(this.mProfile.getUriString())) {
                    boolean makeCallWait = this.mForegroundCall.getState().isAlive();
                    SipConnection connection = this.mRingingCall.initIncomingCall(sipAudioCall, makeCallWait);
                    if (sipAudioCall.getState() != 3) {
                        this.log("    takeIncomingCall: call cancelled !!");
                        this.mRingingCall.reset();
                        connection = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return connection;
                }
            }
            catch (Exception e) {
                this.log("    takeIncomingCall: exception e=" + e);
                this.mRingingCall.reset();
            }
            this.log("takeIncomingCall: NOT taking !!");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$acceptCall(int videoState) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.mRingingCall.getState() != Call.State.INCOMING && this.mRingingCall.getState() != Call.State.WAITING) {
                this.log("acceptCall: throw CallStateException(\"phone not ringing\")");
                throw new CallStateException("phone not ringing");
            }
            this.log("acceptCall: accepting");
            this.mRingingCall.setMute(false);
            this.mRingingCall.acceptCall();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$rejectCall() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!this.mRingingCall.getState().isRinging()) {
                this.log("rejectCall: throw CallStateException(\"phone not ringing\")");
                throw new CallStateException("phone not ringing");
            }
            this.log("rejectCall: rejecting");
            this.mRingingCall.rejectCall();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection $$robo$$com_android_internal_telephony_sip_SipPhone$dial(String dialString, PhoneInternalInterface.DialArgs dialArgs) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.dialInternal(dialString, dialArgs.videoState);
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_sip_SipPhone$dialInternal(String dialString, int videoState) throws CallStateException {
        this.log("dialInternal: dialString=" + SipPhone.hidePii(dialString));
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("dialInternal: cannot dial in current state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            this.switchHoldingAndActive();
        }
        if (this.mForegroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.mForegroundCall.setMute(false);
        try {
            Connection c = this.mForegroundCall.dial(dialString);
            return c;
        }
        catch (SipException e) {
            this.loge("dialInternal: ", (Exception)((Object)e));
            throw new CallStateException("dial error: " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$switchHoldingAndActive() throws CallStateException {
        if (!this.isHoldTimeoutExpired()) {
            this.log("switchHoldingAndActive: Disregarded! Under 1000 ms...");
            return;
        }
        this.log("switchHoldingAndActive: switch fg and bg");
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            if (this.mBackgroundCall.getState().isAlive()) {
                this.mBackgroundCall.hold();
            }
            if (this.mForegroundCall.getState().isAlive()) {
                this.mForegroundCall.unhold();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone$canConference() {
        this.log("canConference: ret=true");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$conference() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.mForegroundCall.getState() != Call.State.ACTIVE || this.mForegroundCall.getState() != Call.State.ACTIVE) {
                throw new CallStateException("wrong state to merge calls: fg=" + (Object)((Object)this.mForegroundCall.getState()) + ", bg=" + (Object)((Object)this.mBackgroundCall.getState()));
            }
            this.log("conference: merge fg & bg");
            this.mForegroundCall.merge(this.mBackgroundCall);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$conference(Call that) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(that instanceof SipCall)) {
                throw new CallStateException("expect " + SipCall.class + ", cannot merge with " + that.getClass());
            }
            this.mForegroundCall.merge((SipCall)that);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone$canTransfer() {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$explicitCallTransfer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$clearDisconnected() {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mRingingCall.clearDisconnected();
            this.mForegroundCall.clearDisconnected();
            this.mBackgroundCall.clearDisconnected();
            this.updatePhoneState();
            this.notifyPreciseCallStateChanged();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("sendDtmf called with invalid character '" + c + "'");
            return;
        }
        if (!this.mForegroundCall.getState().isAlive()) return;
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.sendDtmf(c);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("startDtmf called with invalid character '" + c + "'");
        } else {
            this.sendDtmf(c);
        }
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$stopDtmf() {
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$sendBurstDtmf(String dtmfString) {
        this.loge("sendBurstDtmf() is a CDMA method");
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$getOutgoingCallerIdDisplay(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$getCallWaiting(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$setCallWaiting(boolean enable, Message onComplete) {
        this.loge("call waiting not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$setEchoSuppressionEnabled() {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            String echoSuppression = audioManager.getParameters("ec_supported");
            if (echoSuppression.contains("off")) {
                this.mForegroundCall.setAudioGroupMode();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$setMute(boolean muted) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.setMute(muted);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone$getMute() {
        return this.mForegroundCall.getState().isAlive() ? this.mForegroundCall.getMute() : this.mBackgroundCall.getMute();
    }

    private final Call $$robo$$com_android_internal_telephony_sip_SipPhone$getForegroundCall() {
        return this.mForegroundCall;
    }

    private final Call $$robo$$com_android_internal_telephony_sip_SipPhone$getBackgroundCall() {
        return this.mBackgroundCall;
    }

    private final Call $$robo$$com_android_internal_telephony_sip_SipPhone$getRingingCall() {
        return this.mRingingCall;
    }

    private final ServiceState $$robo$$com_android_internal_telephony_sip_SipPhone$getServiceState() {
        return super.getServiceState();
    }

    private final String $$robo$$com_android_internal_telephony_sip_SipPhone$getUriString(SipProfile p) {
        return p.getUserName() + "@" + this.getSipDomain(p);
    }

    private final String $$robo$$com_android_internal_telephony_sip_SipPhone$getSipDomain(SipProfile p) {
        String domain = p.getSipDomain();
        if (domain.endsWith(":5060")) {
            return domain.substring(0, domain.length() - 5);
        }
        return domain;
    }

    private static final Call.State $$robo$$com_android_internal_telephony_sip_SipPhone$getCallStateFrom(SipAudioCall sipAudioCall) {
        if (sipAudioCall.isOnHold()) {
            return Call.State.HOLDING;
        }
        int sessionState = sipAudioCall.getState();
        switch (sessionState) {
            case 0: {
                return Call.State.IDLE;
            }
            case 3: 
            case 4: {
                return Call.State.INCOMING;
            }
            case 5: {
                return Call.State.DIALING;
            }
            case 6: {
                return Call.State.ALERTING;
            }
            case 7: {
                return Call.State.DISCONNECTING;
            }
            case 8: {
                return Call.State.ACTIVE;
            }
        }
        SipPhone.slog("illegal connection state: " + sessionState);
        return Call.State.DISCONNECTED;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_sip_SipPhone$isHoldTimeoutExpired() {
        CallSite currTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (currTime - this.mTimeOfLastValidHoldRequest > 1000L) {
            this.mTimeOfLastValidHoldRequest = (long)currTime;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$log(String s) {
        Rlog.d("SipPhone", s);
    }

    private static final void $$robo$$com_android_internal_telephony_sip_SipPhone$slog(String s) {
        Rlog.d("SipPhone", s);
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$loge(String s) {
        Rlog.e("SipPhone", s);
    }

    private final void $$robo$$com_android_internal_telephony_sip_SipPhone$loge(String s, Exception e) {
        Rlog.e("SipPhone", s, e);
    }

    private static final String $$robo$$com_android_internal_telephony_sip_SipPhone$hidePii(String s) {
        return "xxxxx";
    }

    private void __constructor__(Context context, PhoneNotifier phoneNotifier, SipProfile sipProfile) {
        this.$$robo$$com_android_internal_telephony_sip_SipPhone$__constructor__(context, phoneNotifier, sipProfile);
    }

    public SipPhone(Context context, PhoneNotifier phoneNotifier, SipProfile sipProfile) {
        super("SIP:" + sipProfile.getUriString(), context, phoneNotifier);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone$__constructor__(android.content.Context com.android.internal.telephony.PhoneNotifier android.net.sip.SipProfile ), this, context, phoneNotifier, sipProfile);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_sip_SipPhone$equals(java.lang.Object ), this, object);
    }

    public String getSipUri() {
        return InvokeDynamicSupport.bootstrap("getSipUri", $$robo$$com_android_internal_telephony_sip_SipPhone$getSipUri(), this);
    }

    public boolean equals(SipPhone sipPhone) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_sip_SipPhone$equals(com.android.internal.telephony.sip.SipPhone ), this, sipPhone);
    }

    public Connection takeIncomingCall(Object object) {
        return InvokeDynamicSupport.bootstrap("takeIncomingCall", $$robo$$com_android_internal_telephony_sip_SipPhone$takeIncomingCall(java.lang.Object ), this, object);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_sip_SipPhone$acceptCall(int ), this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_sip_SipPhone$rejectCall(), this);
    }

    @Override
    public Connection dial(String string2, PhoneInternalInterface.DialArgs dialArgs) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_sip_SipPhone$dial(java.lang.String com.android.internal.telephony.PhoneInternalInterface$DialArgs ), this, string2, dialArgs);
    }

    private Connection dialInternal(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_sip_SipPhone$dialInternal(java.lang.String int ), this, string2, n);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_sip_SipPhone$switchHoldingAndActive(), this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_sip_SipPhone$canConference(), this);
    }

    @Override
    public void conference() throws CallStateException {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_sip_SipPhone$conference(), this);
    }

    public void conference(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_sip_SipPhone$conference(com.android.internal.telephony.Call ), this, call);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_sip_SipPhone$canTransfer(), this);
    }

    @Override
    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_sip_SipPhone$explicitCallTransfer(), this);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_sip_SipPhone$clearDisconnected(), this);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone$sendDtmf(char ), this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone$startDtmf(char ), this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone$stopDtmf(), this);
    }

    public void sendBurstDtmf(String string2) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone$sendBurstDtmf(java.lang.String ), this, string2);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_sip_SipPhone$getOutgoingCallerIdDisplay(android.os.Message ), this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_sip_SipPhone$setOutgoingCallerIdDisplay(int android.os.Message ), this, n, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_sip_SipPhone$getCallWaiting(android.os.Message ), this, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_sip_SipPhone$setCallWaiting(boolean android.os.Message ), this, bl, message);
    }

    @Override
    public void setEchoSuppressionEnabled() {
        InvokeDynamicSupport.bootstrap("setEchoSuppressionEnabled", $$robo$$com_android_internal_telephony_sip_SipPhone$setEchoSuppressionEnabled(), this);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_sip_SipPhone$setMute(boolean ), this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_sip_SipPhone$getMute(), this);
    }

    @Override
    public Call getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_sip_SipPhone$getForegroundCall(), this);
    }

    @Override
    public Call getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_sip_SipPhone$getBackgroundCall(), this);
    }

    @Override
    public Call getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_sip_SipPhone$getRingingCall(), this);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_sip_SipPhone$getServiceState(), this);
    }

    private String getUriString(SipProfile sipProfile) {
        return InvokeDynamicSupport.bootstrap("getUriString", $$robo$$com_android_internal_telephony_sip_SipPhone$getUriString(android.net.sip.SipProfile ), this, sipProfile);
    }

    private String getSipDomain(SipProfile sipProfile) {
        return InvokeDynamicSupport.bootstrap("getSipDomain", $$robo$$com_android_internal_telephony_sip_SipPhone$getSipDomain(android.net.sip.SipProfile ), this, sipProfile);
    }

    private static Call.State getCallStateFrom(SipAudioCall sipAudioCall) {
        return InvokeDynamicSupport.bootstrapStatic("getCallStateFrom", $$robo$$com_android_internal_telephony_sip_SipPhone$getCallStateFrom(android.net.sip.SipAudioCall ), (SipAudioCall)sipAudioCall);
    }

    private synchronized boolean isHoldTimeoutExpired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHoldTimeoutExpired", $$robo$$com_android_internal_telephony_sip_SipPhone$isHoldTimeoutExpired(), this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_sip_SipPhone$log(java.lang.String ), this, string2);
    }

    private static void slog(String string2) {
        InvokeDynamicSupport.bootstrapStatic("slog", $$robo$$com_android_internal_telephony_sip_SipPhone$slog(java.lang.String ), (String)string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_sip_SipPhone$loge(java.lang.String ), this, string2);
    }

    private void loge(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_sip_SipPhone$loge(java.lang.String java.lang.Exception ), this, string2, exception);
    }

    public static String hidePii(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("hidePii", $$robo$$com_android_internal_telephony_sip_SipPhone$hidePii(java.lang.String ), (String)string2);
    }

    public /* synthetic */ SipPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SipPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private abstract class SipAudioCallAdapter
    extends SipAudioCall.Listener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String SACA_TAG = "SipAudioCallAdapter";
        private static boolean SACA_DBG = true;
        /* synthetic */ SipPhone this$0;

        private void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(SipPhone sipPhone) {
            this.this$0 = sipPhone;
        }

        protected abstract void onCallEnded(int var1);

        protected abstract void onError(int var1);

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onCallEnded(SipAudioCall call) {
            this.log("onCallEnded: call=" + call);
            this.onCallEnded(call.isInCall() ? 2 : 1);
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onCallBusy(SipAudioCall call) {
            this.log("onCallBusy: call=" + call);
            this.onCallEnded(4);
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onError(SipAudioCall call, int errorCode, String errorMessage) {
            this.log("onError: call=" + call + " code=" + SipErrorCode.toString((int)errorCode) + ": " + errorMessage);
            switch (errorCode) {
                case -12: {
                    this.onError(9);
                    break;
                }
                case -7: {
                    this.onError(8);
                    break;
                }
                case -6: {
                    this.onError(7);
                    break;
                }
                case -5: 
                case -3: {
                    this.onError(13);
                    break;
                }
                case -10: {
                    this.onError(14);
                    break;
                }
                case -8: {
                    this.onError(10);
                    break;
                }
                case -11: {
                    this.onError(11);
                    break;
                }
                case -2: {
                    this.onError(12);
                    break;
                }
                default: {
                    this.onError(36);
                }
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$log(String s) {
            Rlog.d("SipAudioCallAdapter", s);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(SipPhone x0, 1 x1) {
        }

        private void __constructor__(SipPhone sipPhone) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(sipPhone);
        }

        public SipAudioCallAdapter(SipPhone sipPhone) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(com.android.internal.telephony.sip.SipPhone ), this, sipPhone);
        }

        public void onCallEnded(SipAudioCall sipAudioCall) {
            InvokeDynamicSupport.bootstrap("onCallEnded", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onCallEnded(android.net.sip.SipAudioCall ), this, sipAudioCall);
        }

        public void onCallBusy(SipAudioCall sipAudioCall) {
            InvokeDynamicSupport.bootstrap("onCallBusy", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onCallBusy(android.net.sip.SipAudioCall ), this, sipAudioCall);
        }

        public void onError(SipAudioCall sipAudioCall, int n, String string2) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$onError(android.net.sip.SipAudioCall int java.lang.String ), this, sipAudioCall, n, string2);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$log(java.lang.String ), this, string2);
        }

        private /* synthetic */ void __constructor__(SipPhone sipPhone, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(sipPhone, var2_2);
        }

        public /* synthetic */ SipAudioCallAdapter(SipPhone sipPhone, 1 var2_2) {
            this(sipPhone);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipAudioCallAdapter$__constructor__(com.android.internal.telephony.sip.SipPhone com.android.internal.telephony.sip.SipPhone$1 ), this, sipPhone, var2_2);
        }

        public /* synthetic */ SipAudioCallAdapter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SipAudioCallAdapter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SipConnection
    extends SipConnectionBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String SCN_TAG = "SipConnection";
        private static boolean SCN_DBG = true;
        private SipCall mOwner;
        private SipAudioCall mSipAudioCall;
        private Call.State mState;
        private SipProfile mPeer;
        private boolean mIncoming;
        private String mOriginalNumber;
        private SipAudioCallAdapter mAdapter;
        /* synthetic */ SipPhone this$0;

        private void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(SipPhone sipPhone, SipCall owner, SipProfile callee, String originalNumber) {
            this.this$0 = sipPhone;
            this.mState = Call.State.IDLE;
            this.mIncoming = false;
            this.mAdapter = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SipConnection this$1;

                private void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$__constructor__(SipConnection this$1) {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallEnded(int cause) {
                    if (this.this$1.getDisconnectCause() != 3) {
                        this.this$1.setDisconnectCause(cause);
                    }
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        this.this$1.setState(Call.State.DISCONNECTED);
                        SipAudioCall sipAudioCall = this.this$1.mSipAudioCall;
                        this.this$1.mSipAudioCall = null;
                        String sessionState = sipAudioCall == null ? "" : sipAudioCall.getState() + ", ";
                        this.this$1.log("[SipAudioCallAdapter] onCallEnded: " + SipPhone.hidePii(this.this$1.mPeer.getUriString()) + ": " + sessionState + "cause: " + this.this$1.getDisconnectCause() + ", on phone " + this.this$1.getPhone());
                        if (sipAudioCall != null) {
                            sipAudioCall.setListener(null);
                            sipAudioCall.close();
                        }
                        this.this$1.mOwner.onConnectionEnded(this.this$1);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallEstablished(SipAudioCall call) {
                    this.onChanged(call);
                    if (this.this$1.mState == Call.State.ACTIVE) {
                        call.startAudio();
                    }
                }

                private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallHeld(SipAudioCall call) {
                    this.onChanged(call);
                    if (this.this$1.mState == Call.State.HOLDING) {
                        call.startAudio();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onChanged(SipAudioCall call) {
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        Call.State newState = SipPhone.getCallStateFrom(call);
                        if (this.this$1.mState == newState) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        if (newState == Call.State.INCOMING) {
                            this.this$1.setState(this.this$1.mOwner.getState());
                        } else {
                            if (this.this$1.mOwner == this.this$1.this$0.mRingingCall) {
                                if (this.this$1.this$0.mRingingCall.getState() == Call.State.WAITING) {
                                    try {
                                        this.this$1.this$0.switchHoldingAndActive();
                                    }
                                    catch (CallStateException e) {
                                        this.onCallEnded(3);
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        return;
                                    }
                                }
                                this.this$1.this$0.mForegroundCall.switchWith(this.this$1.this$0.mRingingCall);
                            }
                            this.this$1.setState(newState);
                        }
                        this.this$1.mOwner.onConnectionStateChanged(this.this$1);
                        this.this$1.log("onChanged: " + SipPhone.hidePii(this.this$1.mPeer.getUriString()) + ": " + (Object)((Object)this.this$1.mState) + " on phone " + this.this$1.getPhone());
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onError(int cause) {
                    this.this$1.log("onError: " + cause);
                    this.onCallEnded(cause);
                }

                private void __constructor__(SipConnection sipConnection) {
                    this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$__constructor__(sipConnection);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$__constructor__(com.android.internal.telephony.sip.SipPhone$SipConnection ), this, sipConnection);
                }

                @Override
                protected void onCallEnded(int n) {
                    InvokeDynamicSupport.bootstrap("onCallEnded", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallEnded(int ), this, n);
                }

                public void onCallEstablished(SipAudioCall sipAudioCall) {
                    InvokeDynamicSupport.bootstrap("onCallEstablished", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallEstablished(android.net.sip.SipAudioCall ), this, sipAudioCall);
                }

                public void onCallHeld(SipAudioCall sipAudioCall) {
                    InvokeDynamicSupport.bootstrap("onCallHeld", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onCallHeld(android.net.sip.SipAudioCall ), this, sipAudioCall);
                }

                public void onChanged(SipAudioCall sipAudioCall) {
                    InvokeDynamicSupport.bootstrap("onChanged", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onChanged(android.net.sip.SipAudioCall ), this, sipAudioCall);
                }

                @Override
                protected void onError(int n) {
                    InvokeDynamicSupport.bootstrap("onError", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection_1$onError(int ), this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mOwner = owner;
            this.mPeer = callee;
            this.mOriginalNumber = originalNumber;
        }

        private void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(SipPhone sipPhone, SipCall owner, SipProfile callee) {
        }

        private final String $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getCnapName() {
            String displayName = this.mPeer.getDisplayName();
            return TextUtils.isEmpty(displayName) ? null : displayName;
        }

        private final int $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getNumberPresentation() {
            return 1;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$initIncomingCall(SipAudioCall sipAudioCall, Call.State newState) {
            this.setState(newState);
            this.mSipAudioCall = sipAudioCall;
            sipAudioCall.setListener((SipAudioCall.Listener)this.mAdapter);
            this.mIncoming = true;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$acceptCall() throws CallStateException {
            try {
                this.mSipAudioCall.answerCall(8);
            }
            catch (SipException e) {
                throw new CallStateException("acceptCall(): " + (Object)((Object)e));
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$changeOwner(SipCall owner) {
            this.mOwner = owner;
        }

        private final AudioGroup $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getAudioGroup() {
            if (this.mSipAudioCall == null) {
                return null;
            }
            return this.mSipAudioCall.getAudioGroup();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$dial() throws SipException {
            this.setState(Call.State.DIALING);
            this.mSipAudioCall = this.this$0.mSipManager.makeAudioCall(this.this$0.mProfile, this.mPeer, null, 15);
            this.mSipAudioCall.setListener((SipAudioCall.Listener)this.mAdapter);
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            try {
                this.mSipAudioCall.holdCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("hold(): " + (Object)((Object)e));
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$unhold(AudioGroup audioGroup) throws CallStateException {
            this.mSipAudioCall.setAudioGroup(audioGroup);
            this.setState(Call.State.ACTIVE);
            try {
                this.mSipAudioCall.continueCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("unhold(): " + (Object)((Object)e));
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$setMute(boolean muted) {
            if (this.mSipAudioCall != null && muted != this.mSipAudioCall.isMuted()) {
                this.log("setState: prev muted=" + !muted + " new muted=" + muted);
                this.mSipAudioCall.toggleMute();
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getMute() {
            return this.mSipAudioCall == null ? false : this.mSipAudioCall.isMuted();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$setState(Call.State state) {
            if (state == this.mState) {
                return;
            }
            super.setState(state);
            this.mState = state;
        }

        private final Call.State $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getState() {
            return this.mState;
        }

        private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$isIncoming() {
            return this.mIncoming;
        }

        private final String $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getAddress() {
            return this.mOriginalNumber;
        }

        private final SipCall $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getCall() {
            return this.mOwner;
        }

        private final Phone $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getPhone() {
            return this.mOwner.getPhone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                this.log("hangup: conn=" + SipPhone.hidePii(this.mPeer.getUriString()) + ": " + (Object)((Object)this.mState) + ": on phone " + this.getPhone().getPhoneName());
                if (!this.mState.isAlive()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = this.mSipAudioCall;
                    if (sipAudioCall != null) {
                        sipAudioCall.setListener(null);
                        sipAudioCall.endCall();
                    }
                    this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? 16 : 3);
                }
                catch (SipException e) {
                    try {
                        throw new CallStateException("hangup(): " + (Object)((Object)e));
                    }
                    catch (Throwable throwable) {
                        this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? 16 : 3);
                        throw throwable;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$separate() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall call;
                SipCall sipCall = call = this.getPhone() == this.this$0 ? (SipCall)this.this$0.getBackgroundCall() : (SipCall)this.this$0.getForegroundCall();
                if (call.getState() != Call.State.IDLE) {
                    throw new CallStateException("cannot put conn back to a call in non-idle state: " + (Object)((Object)call.getState()));
                }
                this.log("separate: conn=" + this.mPeer.getUriString() + " from " + this.mOwner + " back to " + call);
                Phone originalPhone = this.getPhone();
                AudioGroup audioGroup = call.getAudioGroup();
                call.add(this);
                this.mSipAudioCall.setAudioGroup(audioGroup);
                originalPhone.switchHoldingAndActive();
                call = (SipCall)this.this$0.getForegroundCall();
                this.mSipAudioCall.startAudio();
                call.onConnectionStateChanged(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$deflect(String number) throws CallStateException {
            throw new CallStateException("deflect is not supported for SipPhone");
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$log(String s) {
            Rlog.d("SipConnection", s);
        }

        private void __constructor__(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile, String string2) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(sipPhone, sipCall, sipProfile, string2);
        }

        public SipConnection(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(com.android.internal.telephony.sip.SipPhone com.android.internal.telephony.sip.SipPhone$SipCall android.net.sip.SipProfile java.lang.String ), this, sipPhone, sipCall, sipProfile, string2);
        }

        private void __constructor__(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(sipPhone, sipCall, sipProfile);
        }

        public SipConnection(SipPhone sipPhone, SipCall sipCall, SipProfile sipProfile) {
            this(sipPhone, sipCall, sipProfile, sipPhone.getUriString(sipProfile));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$__constructor__(com.android.internal.telephony.sip.SipPhone com.android.internal.telephony.sip.SipPhone$SipCall android.net.sip.SipProfile ), this, sipPhone, sipCall, sipProfile);
        }

        @Override
        public String getCnapName() {
            return InvokeDynamicSupport.bootstrap("getCnapName", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getCnapName(), this);
        }

        @Override
        public int getNumberPresentation() {
            return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getNumberPresentation(), this);
        }

        void initIncomingCall(SipAudioCall sipAudioCall, Call.State state) {
            InvokeDynamicSupport.bootstrap("initIncomingCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$initIncomingCall(android.net.sip.SipAudioCall com.android.internal.telephony.Call$State ), this, sipAudioCall, state);
        }

        void acceptCall() throws CallStateException {
            InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$acceptCall(), this);
        }

        void changeOwner(SipCall sipCall) {
            InvokeDynamicSupport.bootstrap("changeOwner", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$changeOwner(com.android.internal.telephony.sip.SipPhone$SipCall ), this, sipCall);
        }

        AudioGroup getAudioGroup() {
            return InvokeDynamicSupport.bootstrap("getAudioGroup", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getAudioGroup(), this);
        }

        void dial() throws SipException {
            InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$dial(), this);
        }

        void hold() throws CallStateException {
            InvokeDynamicSupport.bootstrap("hold", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$hold(), this);
        }

        void unhold(AudioGroup audioGroup) throws CallStateException {
            InvokeDynamicSupport.bootstrap("unhold", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$unhold(android.net.rtp.AudioGroup ), this, audioGroup);
        }

        void setMute(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$setMute(boolean ), this, bl);
        }

        boolean getMute() {
            return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getMute(), this);
        }

        @Override
        protected void setState(Call.State state) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$setState(com.android.internal.telephony.Call$State ), this, state);
        }

        @Override
        public Call.State getState() {
            return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getState(), this);
        }

        @Override
        public boolean isIncoming() {
            return (boolean)InvokeDynamicSupport.bootstrap("isIncoming", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$isIncoming(), this);
        }

        @Override
        public String getAddress() {
            return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getAddress(), this);
        }

        @Override
        public SipCall getCall() {
            return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getCall(), this);
        }

        @Override
        protected Phone getPhone() {
            return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$getPhone(), this);
        }

        @Override
        public void hangup() throws CallStateException {
            InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$hangup(), this);
        }

        @Override
        public void separate() throws CallStateException {
            InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$separate(), this);
        }

        @Override
        public void deflect(String string2) throws CallStateException {
            InvokeDynamicSupport.bootstrap("deflect", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$deflect(java.lang.String ), this, string2);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_sip_SipPhone_SipConnection$log(java.lang.String ), this, string2);
        }

        public /* synthetic */ SipConnection() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SipConnection)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SipCall
    extends SipCallBase
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String SC_TAG = "SipCall";
        private static boolean SC_DBG = true;
        private static boolean SC_VDBG = false;
        /* synthetic */ SipPhone this$0;

        private void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(SipPhone sipPhone) {
            this.this$0 = sipPhone;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$reset() {
            this.log("reset");
            this.mConnections.clear();
            this.setState(Call.State.IDLE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$switchWith(SipCall that) {
            this.log("switchWith");
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall tmp = new SipCall(this.this$0);
                tmp.takeOver(this);
                this.takeOver(that);
                that.takeOver(tmp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$takeOver(SipCall that) {
            this.log("takeOver");
            this.mConnections = that.mConnections;
            this.mState = that.mState;
            for (Connection c : this.mConnections) {
                ((SipConnection)c).changeOwner(this);
            }
        }

        private final Phone $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getPhone() {
            return this.this$0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<Connection> $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getConnections() {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.mConnections;
            }
        }

        private final Connection $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$dial(String originalNumber) throws SipException {
            this.log("dial: num=" + "xxx");
            String calleeSipUri = originalNumber;
            if (!calleeSipUri.contains("@")) {
                String replaceStr = Pattern.quote(this.this$0.mProfile.getUserName() + "@");
                calleeSipUri = this.this$0.mProfile.getUriString().replaceFirst(replaceStr, calleeSipUri + "@");
            }
            try {
                SipProfile callee = new SipProfile.Builder(calleeSipUri).build();
                SipConnection c = new SipConnection(this.this$0, this, callee, originalNumber);
                c.dial();
                this.mConnections.add(c);
                this.setState(Call.State.DIALING);
                return c;
            }
            catch (ParseException e) {
                throw new SipException("dial", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                if (this.mState.isAlive()) {
                    this.log("hangup: call " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                    this.setState(Call.State.DISCONNECTING);
                    CallStateException excp = null;
                    for (Connection c : this.mConnections) {
                        try {
                            c.hangup();
                        }
                        catch (CallStateException e) {
                            excp = e;
                        }
                    }
                    if (excp != null) {
                        throw excp;
                    }
                } else {
                    this.log("hangup: dead call " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private final SipConnection $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$initIncomingCall(SipAudioCall sipAudioCall, boolean makeCallWait) {
            SipProfile callee = sipAudioCall.getPeerProfile();
            SipConnection c = new SipConnection(this.this$0, this, callee);
            this.mConnections.add(c);
            Call.State newState = makeCallWait ? Call.State.WAITING : Call.State.INCOMING;
            c.initIncomingCall(sipAudioCall, newState);
            this.setState(newState);
            this.this$0.notifyNewRingingConnectionP(c);
            return c;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$rejectCall() throws CallStateException {
            this.log("rejectCall:");
            this.hangup();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$acceptCall() throws CallStateException {
            this.log("acceptCall: accepting");
            if (this != this.this$0.mRingingCall) {
                throw new CallStateException("acceptCall() in a non-ringing call");
            }
            if (this.mConnections.size() != 1) {
                throw new CallStateException("acceptCall() in a conf call");
            }
            ((SipConnection)this.mConnections.get(0)).acceptCall();
        }

        private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$isSpeakerOn() {
            Boolean ret = ((AudioManager)this.this$0.mContext.getSystemService("audio")).isSpeakerphoneOn();
            return ret;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setAudioGroupMode() {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                this.log("setAudioGroupMode: audioGroup == null ignore");
                return;
            }
            int mode = audioGroup.getMode();
            if (this.mState == Call.State.HOLDING) {
                audioGroup.setMode(0);
            } else if (this.getMute()) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
            this.log(String.format("setAudioGroupMode change: %d --> %d", mode, audioGroup.getMode()));
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$hold() throws CallStateException {
            this.log("hold:");
            this.setState(Call.State.HOLDING);
            for (Connection c : this.mConnections) {
                ((SipConnection)c).hold();
            }
            this.setAudioGroupMode();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$unhold() throws CallStateException {
            this.log("unhold:");
            this.setState(Call.State.ACTIVE);
            AudioGroup audioGroup = new AudioGroup();
            for (Connection c : this.mConnections) {
                ((SipConnection)c).unhold(audioGroup);
            }
            this.setAudioGroupMode();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setMute(boolean muted) {
            this.log("setMute: muted=" + muted);
            for (Connection c : this.mConnections) {
                ((SipConnection)c).setMute(muted);
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getMute() {
            boolean ret = this.mConnections.isEmpty() ? false : ((SipConnection)this.mConnections.get(0)).getMute();
            this.log("getMute: ret=" + ret);
            return ret;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$merge(SipCall that) throws CallStateException {
            Connection[] cc;
            this.log("merge:");
            AudioGroup audioGroup = this.getAudioGroup();
            for (Connection c : cc = that.mConnections.toArray(new Connection[that.mConnections.size()])) {
                SipConnection conn = (SipConnection)c;
                this.add(conn);
                if (conn.getState() != Call.State.HOLDING) continue;
                conn.unhold(audioGroup);
            }
            that.setState(Call.State.IDLE);
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$add(SipConnection conn) {
            this.log("add:");
            Call call = conn.getCall();
            if (call == this) {
                return;
            }
            if (call != null) {
                ((SipCall)call).mConnections.remove(conn);
            }
            this.mConnections.add(conn);
            conn.changeOwner(this);
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$sendDtmf(char c) {
            this.log("sendDtmf: c=" + c);
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                this.log("sendDtmf: audioGroup == null, ignore c=" + c);
                return;
            }
            audioGroup.sendDtmf(this.convertDtmf(c));
        }

        private final int $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$convertDtmf(char c) {
            int code = c - 48;
            if (code < 0 || code > 9) {
                switch (c) {
                    case '*': {
                        return 10;
                    }
                    case '#': {
                        return 11;
                    }
                    case 'A': {
                        return 12;
                    }
                    case 'B': {
                        return 13;
                    }
                    case 'C': {
                        return 14;
                    }
                    case 'D': {
                        return 15;
                    }
                }
                throw new IllegalArgumentException("invalid DTMF char: " + c);
            }
            return code;
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setState(Call.State newState) {
            if (this.mState != newState) {
                this.log("setState: cur state" + (Object)((Object)this.mState) + " --> " + (Object)((Object)newState) + ": " + this + ": on phone " + this.getPhone() + " " + this.mConnections.size());
                if (newState == Call.State.ALERTING) {
                    this.mState = newState;
                    this.this$0.startRingbackTone();
                } else if (this.mState == Call.State.ALERTING) {
                    this.this$0.stopRingbackTone();
                }
                this.mState = newState;
                this.this$0.updatePhoneState();
                this.this$0.notifyPreciseCallStateChanged();
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$onConnectionStateChanged(SipConnection conn) {
            this.log("onConnectionStateChanged: conn=" + conn);
            if (this.mState != Call.State.ACTIVE) {
                this.setState(conn.getState());
            }
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$onConnectionEnded(SipConnection conn) {
            this.log("onConnectionEnded: conn=" + conn);
            if (this.mState != Call.State.DISCONNECTED) {
                boolean allConnectionsDisconnected = true;
                this.log("---check connections: " + this.mConnections.size());
                for (Connection c : this.mConnections) {
                    this.log("   state=" + (Object)((Object)c.getState()) + ": " + c);
                    if (c.getState() == Call.State.DISCONNECTED) continue;
                    allConnectionsDisconnected = false;
                    break;
                }
                if (allConnectionsDisconnected) {
                    this.setState(Call.State.DISCONNECTED);
                }
            }
            this.this$0.notifyDisconnectP(conn);
        }

        private final AudioGroup $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getAudioGroup() {
            if (this.mConnections.isEmpty()) {
                return null;
            }
            return ((SipConnection)this.mConnections.get(0)).getAudioGroup();
        }

        private final void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$log(String s) {
            Rlog.d("SipCall", s);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(SipPhone x0, 1 x1) {
        }

        private void __constructor__(SipPhone sipPhone) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(sipPhone);
        }

        public SipCall(SipPhone sipPhone) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(com.android.internal.telephony.sip.SipPhone ), this, sipPhone);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$reset(), this);
        }

        void switchWith(SipCall sipCall) {
            InvokeDynamicSupport.bootstrap("switchWith", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$switchWith(com.android.internal.telephony.sip.SipPhone$SipCall ), this, sipCall);
        }

        private void takeOver(SipCall sipCall) {
            InvokeDynamicSupport.bootstrap("takeOver", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$takeOver(com.android.internal.telephony.sip.SipPhone$SipCall ), this, sipCall);
        }

        @Override
        public Phone getPhone() {
            return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getPhone(), this);
        }

        @Override
        public List<Connection> getConnections() {
            return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getConnections(), this);
        }

        Connection dial(String string2) throws SipException {
            return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$dial(java.lang.String ), this, string2);
        }

        @Override
        public void hangup() throws CallStateException {
            InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$hangup(), this);
        }

        SipConnection initIncomingCall(SipAudioCall sipAudioCall, boolean bl) {
            return InvokeDynamicSupport.bootstrap("initIncomingCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$initIncomingCall(android.net.sip.SipAudioCall boolean ), this, sipAudioCall, bl);
        }

        void rejectCall() throws CallStateException {
            InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$rejectCall(), this);
        }

        void acceptCall() throws CallStateException {
            InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$acceptCall(), this);
        }

        private boolean isSpeakerOn() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSpeakerOn", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$isSpeakerOn(), this);
        }

        void setAudioGroupMode() {
            InvokeDynamicSupport.bootstrap("setAudioGroupMode", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setAudioGroupMode(), this);
        }

        void hold() throws CallStateException {
            InvokeDynamicSupport.bootstrap("hold", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$hold(), this);
        }

        void unhold() throws CallStateException {
            InvokeDynamicSupport.bootstrap("unhold", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$unhold(), this);
        }

        void setMute(boolean bl) {
            InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setMute(boolean ), this, bl);
        }

        boolean getMute() {
            return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getMute(), this);
        }

        void merge(SipCall sipCall) throws CallStateException {
            InvokeDynamicSupport.bootstrap("merge", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$merge(com.android.internal.telephony.sip.SipPhone$SipCall ), this, sipCall);
        }

        private void add(SipConnection sipConnection) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$add(com.android.internal.telephony.sip.SipPhone$SipConnection ), this, sipConnection);
        }

        void sendDtmf(char c) {
            InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$sendDtmf(char ), this, c);
        }

        private int convertDtmf(char c) {
            return (int)InvokeDynamicSupport.bootstrap("convertDtmf", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$convertDtmf(char ), this, c);
        }

        @Override
        protected void setState(Call.State state) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$setState(com.android.internal.telephony.Call$State ), this, state);
        }

        void onConnectionStateChanged(SipConnection sipConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionStateChanged", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$onConnectionStateChanged(com.android.internal.telephony.sip.SipPhone$SipConnection ), this, sipConnection);
        }

        void onConnectionEnded(SipConnection sipConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionEnded", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$onConnectionEnded(com.android.internal.telephony.sip.SipPhone$SipConnection ), this, sipConnection);
        }

        private AudioGroup getAudioGroup() {
            return InvokeDynamicSupport.bootstrap("getAudioGroup", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$getAudioGroup(), this);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$log(java.lang.String ), this, string2);
        }

        private /* synthetic */ void __constructor__(SipPhone sipPhone, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(sipPhone, var2_2);
        }

        public /* synthetic */ SipCall(SipPhone sipPhone, 1 var2_2) {
            this(sipPhone);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_sip_SipPhone_SipCall$__constructor__(com.android.internal.telephony.sip.SipPhone com.android.internal.telephony.sip.SipPhone$1 ), this, sipPhone, var2_2);
        }

        public /* synthetic */ SipCall() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SipCall)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

