/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccFileTypeMismatch;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class IccFileHandler
extends Handler
implements IccConstants,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean VDBG = false;
    protected static int COMMAND_READ_BINARY = 176;
    protected static int COMMAND_UPDATE_BINARY = 214;
    protected static int COMMAND_READ_RECORD = 178;
    protected static int COMMAND_UPDATE_RECORD = 220;
    protected static int COMMAND_SEEK = 162;
    protected static int COMMAND_GET_RESPONSE = 192;
    protected static int READ_RECORD_MODE_ABSOLUTE = 4;
    protected static int EF_TYPE_TRANSPARENT = 0;
    protected static int EF_TYPE_LINEAR_FIXED = 1;
    protected static int EF_TYPE_CYCLIC = 3;
    protected static int TYPE_RFU = 0;
    protected static int TYPE_MF = 1;
    protected static int TYPE_DF = 2;
    protected static int TYPE_EF = 4;
    protected static int GET_RESPONSE_EF_SIZE_BYTES = 15;
    protected static int GET_RESPONSE_EF_IMG_SIZE_BYTES = 10;
    protected static int RESPONSE_DATA_RFU_1 = 0;
    protected static int RESPONSE_DATA_RFU_2 = 1;
    protected static int RESPONSE_DATA_FILE_SIZE_1 = 2;
    protected static int RESPONSE_DATA_FILE_SIZE_2 = 3;
    protected static int RESPONSE_DATA_FILE_ID_1 = 4;
    protected static int RESPONSE_DATA_FILE_ID_2 = 5;
    protected static int RESPONSE_DATA_FILE_TYPE = 6;
    protected static int RESPONSE_DATA_RFU_3 = 7;
    protected static int RESPONSE_DATA_ACCESS_CONDITION_1 = 8;
    protected static int RESPONSE_DATA_ACCESS_CONDITION_2 = 9;
    protected static int RESPONSE_DATA_ACCESS_CONDITION_3 = 10;
    protected static int RESPONSE_DATA_FILE_STATUS = 11;
    protected static int RESPONSE_DATA_LENGTH = 12;
    protected static int RESPONSE_DATA_STRUCTURE = 13;
    protected static int RESPONSE_DATA_RECORD_LENGTH = 14;
    protected static int EVENT_GET_BINARY_SIZE_DONE = 4;
    protected static int EVENT_READ_BINARY_DONE = 5;
    protected static int EVENT_GET_RECORD_SIZE_DONE = 6;
    protected static int EVENT_READ_RECORD_DONE = 7;
    protected static int EVENT_GET_EF_LINEAR_RECORD_SIZE_DONE = 8;
    protected static int EVENT_READ_IMG_DONE = 9;
    protected static int EVENT_READ_ICON_DONE = 10;
    protected static int EVENT_GET_RECORD_SIZE_IMG_DONE = 11;
    protected CommandsInterface mCi;
    protected UiccCardApplication mParentApp;
    protected String mAid;

    private void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$__constructor__(UiccCardApplication app, String aid, CommandsInterface ci) {
        this.mParentApp = app;
        this.mAid = aid;
        this.mCi = ci;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$dispose() {
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixed(int fileid, String path, int recordNum, Message onLoaded) {
        String efPath = path == null ? this.getEFPath(fileid) : path;
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, recordNum, efPath, onLoaded));
        this.mCi.iccIOForApp(192, fileid, efPath, 0, 0, 15, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixed(int fileid, int recordNum, Message onLoaded) {
        this.loadEFLinearFixed(fileid, this.getEFPath(fileid), recordNum, onLoaded);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFImgLinearFixed(int recordNum, Message onLoaded) {
        Message response = this.obtainMessage(11, new LoadLinearFixedContext(20256, recordNum, onLoaded));
        this.mCi.iccIOForApp(192, 20256, this.getEFPath(20256), recordNum, 4, 10, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getEFLinearRecordSize(int fileid, String path, Message onLoaded) {
        String efPath = path == null ? this.getEFPath(fileid) : path;
        Message response = this.obtainMessage(8, new LoadLinearFixedContext(fileid, efPath, onLoaded));
        this.mCi.iccIOForApp(192, fileid, efPath, 0, 0, 15, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getEFLinearRecordSize(int fileid, Message onLoaded) {
        this.getEFLinearRecordSize(fileid, this.getEFPath(fileid), onLoaded);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixedAll(int fileid, String path, Message onLoaded) {
        String efPath = path == null ? this.getEFPath(fileid) : path;
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, efPath, onLoaded));
        this.mCi.iccIOForApp(192, fileid, efPath, 0, 0, 15, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixedAll(int fileid, Message onLoaded) {
        this.loadEFLinearFixedAll(fileid, this.getEFPath(fileid), onLoaded);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFTransparent(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(4, fileid, 0, onLoaded);
        this.mCi.iccIOForApp(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFTransparent(int fileid, int size, Message onLoaded) {
        Message response = this.obtainMessage(5, fileid, 0, onLoaded);
        this.mCi.iccIOForApp(176, fileid, this.getEFPath(fileid), 0, 0, size, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFImgTransparent(int fileid, int highOffset, int lowOffset, int length, Message onLoaded) {
        Message response = this.obtainMessage(10, fileid, 0, onLoaded);
        this.logd("IccFileHandler: loadEFImgTransparent fileid = " + fileid + " filePath = " + this.getEFPath(20256) + " highOffset = " + highOffset + " lowOffset = " + lowOffset + " length = " + length);
        this.mCi.iccIOForApp(176, fileid, this.getEFPath(20256), highOffset, lowOffset, length, null, null, this.mAid, response);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFLinearFixed(int fileid, String path, int recordNum, byte[] data, String pin2, Message onComplete) {
        String efPath = path == null ? this.getEFPath(fileid) : path;
        this.mCi.iccIOForApp(220, fileid, efPath, recordNum, 4, data.length, IccUtils.bytesToHexString(data), pin2, this.mAid, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFLinearFixed(int fileid, int recordNum, byte[] data, String pin2, Message onComplete) {
        this.mCi.iccIOForApp(220, fileid, this.getEFPath(fileid), recordNum, 4, data.length, IccUtils.bytesToHexString(data), pin2, this.mAid, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFTransparent(int fileid, byte[] data, Message onComplete) {
        this.mCi.iccIOForApp(214, fileid, this.getEFPath(fileid), 0, 0, data.length, IccUtils.bytesToHexString(data), null, this.mAid, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$sendResult(Message response, Object result, Throwable ex) {
        if (response == null) {
            return;
        }
        AsyncResult.forMessage(response, result, ex);
        response.sendToTarget();
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_IccFileHandler$processException(Message response, AsyncResult ar) {
        boolean flag = false;
        IccIoResult result = (IccIoResult)ar.result;
        if (ar.exception != null) {
            this.sendResult(response, null, ar.exception);
            flag = true;
        } else {
            IccException iccException = result.getException();
            if (iccException != null) {
                this.sendResult(response, null, iccException);
                flag = true;
            }
        }
        return flag;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccFileHandler$handleMessage(Message msg) {
        Message response = null;
        String path = null;
        try {
            switch (msg.what) {
                case 8: {
                    int[] recordSize;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    byte[] data = result.payload;
                    if (4 != data[6] || 1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    recordSize = new int[]{data[14] & 0xFF, ((data[2] & 0xFF) << 8) + (data[3] & 0xFF), recordSize[1] / recordSize[0]};
                    this.sendResult(response, recordSize, null);
                    break;
                }
                case 6: 
                case 11: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    if (this.processException(response, (AsyncResult)msg.obj)) {
                        this.loge("exception caught from EVENT_GET_RECORD_SIZE");
                        break;
                    }
                    byte[] data = result.payload;
                    path = lc.mPath;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    lc.mRecordSize = data[14] & 0xFF;
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    lc.mCountRecords = size / lc.mRecordSize;
                    if (lc.mLoadAll) {
                        lc.results = new ArrayList(lc.mCountRecords);
                    }
                    if (path == null) {
                        path = this.getEFPath(lc.mEfid);
                    }
                    this.mCi.iccIOForApp(178, lc.mEfid, path, lc.mRecordNum, 4, lc.mRecordSize, null, null, this.mAid, this.obtainMessage(7, lc));
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    byte[] data = result.payload;
                    int fileid = msg.arg1;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (0 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    this.mCi.iccIOForApp(176, fileid, this.getEFPath(fileid), 0, 0, size, null, null, this.mAid, this.obtainMessage(5, fileid, 0, response));
                    break;
                }
                case 7: 
                case 9: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    path = lc.mPath;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    if (!lc.mLoadAll) {
                        this.sendResult(response, result.payload, null);
                        break;
                    }
                    lc.results.add(result.payload);
                    ++lc.mRecordNum;
                    if (lc.mRecordNum > lc.mCountRecords) {
                        this.sendResult(response, lc.results, null);
                        break;
                    }
                    if (path == null) {
                        path = this.getEFPath(lc.mEfid);
                    }
                    this.mCi.iccIOForApp(178, lc.mEfid, path, lc.mRecordNum, 4, lc.mRecordSize, null, null, this.mAid, this.obtainMessage(7, lc));
                    break;
                }
                case 5: 
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    this.sendResult(response, result.payload, null);
                }
            }
        }
        catch (Exception exc) {
            if (response != null) {
                this.sendResult(response, null, exc);
            }
            this.loge("uncaught exception" + exc);
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getCommonIccEFPath(int efid) {
        switch (efid) {
            case 28474: 
            case 28475: 
            case 28480: 
            case 28489: 
            case 28490: 
            case 28491: 
            case 28492: 
            case 28645: {
                return "3F007F10";
            }
            case 12037: 
            case 12258: {
                return "3F00";
            }
            case 20272: {
                return "3F007F105F3A";
            }
            case 20256: {
                return "3F007F105F50";
            }
        }
        return null;
    }

    protected abstract String getEFPath(int var1);

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    private void __constructor__(UiccCardApplication uiccCardApplication, String string2, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_IccFileHandler$__constructor__(uiccCardApplication, string2, commandsInterface);
    }

    public IccFileHandler(UiccCardApplication uiccCardApplication, String string2, CommandsInterface commandsInterface) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication java.lang.String com.android.internal.telephony.CommandsInterface ), this, uiccCardApplication, string2, commandsInterface);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$dispose(), this);
    }

    public void loadEFLinearFixed(int n, String string2, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFLinearFixed", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixed(int java.lang.String int android.os.Message ), this, n, string2, n2, message);
    }

    public void loadEFLinearFixed(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFLinearFixed", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixed(int int android.os.Message ), this, n, n2, message);
    }

    public void loadEFImgLinearFixed(int n, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFImgLinearFixed", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFImgLinearFixed(int android.os.Message ), this, n, message);
    }

    public void getEFLinearRecordSize(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("getEFLinearRecordSize", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getEFLinearRecordSize(int java.lang.String android.os.Message ), this, n, string2, message);
    }

    public void getEFLinearRecordSize(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getEFLinearRecordSize", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getEFLinearRecordSize(int android.os.Message ), this, n, message);
    }

    public void loadEFLinearFixedAll(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFLinearFixedAll", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixedAll(int java.lang.String android.os.Message ), this, n, string2, message);
    }

    public void loadEFLinearFixedAll(int n, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFLinearFixedAll", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFLinearFixedAll(int android.os.Message ), this, n, message);
    }

    public void loadEFTransparent(int n, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFTransparent", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFTransparent(int android.os.Message ), this, n, message);
    }

    public void loadEFTransparent(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFTransparent", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFTransparent(int int android.os.Message ), this, n, n2, message);
    }

    public void loadEFImgTransparent(int n, int n2, int n3, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("loadEFImgTransparent", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$loadEFImgTransparent(int int int int android.os.Message ), this, n, n2, n3, n4, message);
    }

    public void updateEFLinearFixed(int n, String string2, int n2, byte[] byArray, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("updateEFLinearFixed", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFLinearFixed(int java.lang.String int byte[] java.lang.String android.os.Message ), this, n, string2, n2, byArray, string3, message);
    }

    public void updateEFLinearFixed(int n, int n2, byte[] byArray, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("updateEFLinearFixed", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFLinearFixed(int int byte[] java.lang.String android.os.Message ), this, n, n2, byArray, string2, message);
    }

    public void updateEFTransparent(int n, byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("updateEFTransparent", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$updateEFTransparent(int byte[] android.os.Message ), this, n, byArray, message);
    }

    private void sendResult(Message message, Object object, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("sendResult", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$sendResult(android.os.Message java.lang.Object java.lang.Throwable ), this, message, object, throwable);
    }

    private boolean processException(Message message, AsyncResult asyncResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("processException", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$processException(android.os.Message android.os.AsyncResult ), this, message, asyncResult);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$handleMessage(android.os.Message ), this, message);
    }

    protected String getCommonIccEFPath(int n) {
        return InvokeDynamicSupport.bootstrap("getCommonIccEFPath", $$robo$$com_android_internal_telephony_uicc_IccFileHandler$getCommonIccEFPath(int ), this, n);
    }

    public /* synthetic */ IccFileHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccFileHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LoadLinearFixedContext
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mEfid;
        int mRecordNum;
        int mRecordSize;
        int mCountRecords;
        boolean mLoadAll;
        String mPath;
        Message mOnLoaded;
        ArrayList<byte[]> results;

        private void $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int efid, int recordNum, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = recordNum;
            this.mOnLoaded = onLoaded;
            this.mLoadAll = false;
            this.mPath = null;
        }

        private void $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int efid, int recordNum, String path, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = recordNum;
            this.mOnLoaded = onLoaded;
            this.mLoadAll = false;
            this.mPath = path;
        }

        private void $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int efid, String path, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = 1;
            this.mLoadAll = true;
            this.mOnLoaded = onLoaded;
            this.mPath = path;
        }

        private void $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int efid, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = 1;
            this.mLoadAll = true;
            this.mOnLoaded = onLoaded;
            this.mPath = null;
        }

        private void __constructor__(int n, int n2, Message message) {
            this.$$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(n, n2, message);
        }

        public LoadLinearFixedContext(int n, int n2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int int android.os.Message ), this, n, n2, message);
        }

        private void __constructor__(int n, int n2, String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(n, n2, string2, message);
        }

        public LoadLinearFixedContext(int n, int n2, String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int int java.lang.String android.os.Message ), this, n, n2, string2, message);
        }

        private void __constructor__(int n, String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(n, string2, message);
        }

        public LoadLinearFixedContext(int n, String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int java.lang.String android.os.Message ), this, n, string2, message);
        }

        private void __constructor__(int n, Message message) {
            this.$$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(n, message);
        }

        public LoadLinearFixedContext(int n, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccFileHandler_LoadLinearFixedContext$__constructor__(int android.os.Message ), this, n, message);
        }

        public /* synthetic */ LoadLinearFixedContext() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadLinearFixedContext)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

