/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.telephony.Rlog;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IccUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "IccUtils";
    private static char[] HEX_CHARS;

    private void $$robo$$com_android_internal_telephony_uicc_IccUtils$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToString(byte[] data, int offset, int length) {
        int v;
        StringBuilder ret = new StringBuilder(length * 2);
        for (int i = offset; i < offset + length && (v = data[i] & 0xF) <= 9; ++i) {
            ret.append((char)(48 + v));
            v = data[i] >> 4 & 0xF;
            if (v == 15) continue;
            if (v > 9) break;
            ret.append((char)(48 + v));
        }
        return ret.toString();
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToString(byte[] data) {
        return IccUtils.bcdToString(data, 0, data.length);
    }

    private static final byte[] $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToBytes(String bcd) {
        byte[] output = new byte[(bcd.length() + 1) / 2];
        IccUtils.bcdToBytes(bcd, output);
        return output;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToBytes(String bcd, byte[] bytes) {
        if (bcd.length() % 2 != 0) {
            bcd = bcd + "0";
        }
        int size = Math.min(bytes.length * 2, bcd.length());
        int i = 0;
        int j = 0;
        while (i + 1 < size) {
            bytes[j] = (byte)(IccUtils.charToByte(bcd.charAt(i + 1)) << 4 | IccUtils.charToByte(bcd.charAt(i)));
            i += 2;
            ++j;
        }
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdPlmnToString(byte[] data, int offset) {
        if (offset + 3 > data.length) {
            return null;
        }
        byte[] trans = new byte[]{(byte)(data[0 + offset] << 4 | data[0 + offset] >> 4 & 0xF), (byte)(data[1 + offset] << 4 | data[2 + offset] & 0xF), (byte)(data[2 + offset] & 0xF0 | data[1 + offset] >> 4 & 0xF)};
        String ret = IccUtils.bytesToHexString(trans);
        if (ret.contains("F")) {
            ret = ret.replaceAll("F", "");
        }
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$bchToString(byte[] data, int offset, int length) {
        StringBuilder ret = new StringBuilder(length * 2);
        for (int i = offset; i < offset + length; ++i) {
            int v = data[i] & 0xF;
            ret.append(HEX_CHARS[v]);
            v = data[i] >> 4 & 0xF;
            ret.append(HEX_CHARS[v]);
        }
        return ret.toString();
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$cdmaBcdToString(byte[] data, int offset, int length) {
        StringBuilder ret = new StringBuilder(length);
        int count = 0;
        int i = offset;
        while (count < length) {
            int v = data[i] & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            if (++count == length) break;
            v = data[i] >> 4 & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            ++count;
            ++i;
        }
        return ret.toString();
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$gsmBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = b >> 4 & 0xF;
        }
        if ((b & 0xF) <= 9) {
            ret += (b & 0xF) * 10;
        }
        return ret;
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$cdmaBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = (b >> 4 & 0xF) * 10;
        }
        if ((b & 0xF) <= 9) {
            ret += b & 0xF;
        }
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$adnStringFieldToString(byte[] data, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (length >= 1 && data[offset] == -128) {
            int ucslen = (length - 1) / 2;
            String ret = null;
            try {
                ret = new String(data, offset + 1, ucslen * 2, "utf-16be");
            }
            catch (UnsupportedEncodingException ex) {
                Rlog.e("IccUtils", "implausible UnsupportedEncodingException", ex);
            }
            if (ret != null) {
                for (ucslen = ret.length(); ucslen > 0 && ret.charAt(ucslen - 1) == '\uffff'; --ucslen) {
                }
                return ret.substring(0, ucslen);
            }
        }
        boolean isucs2 = false;
        int base = 0;
        int len = 0;
        if (length >= 3 && data[offset] == -127) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 3) {
                len = length - 3;
            }
            base = (char)((data[offset + 2] & 0xFF) << 7);
            offset += 3;
            isucs2 = true;
        } else if (length >= 4 && data[offset] == -126) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 4) {
                len = length - 4;
            }
            base = (char)((data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF);
            offset += 4;
            isucs2 = true;
        }
        if (isucs2) {
            StringBuilder ret = new StringBuilder();
            while (len > 0) {
                int count;
                if (data[offset] < 0) {
                    ret.append((char)(base + (data[offset] & 0x7F)));
                    ++offset;
                    --len;
                }
                for (count = 0; count < len && data[offset + count] >= 0; ++count) {
                }
                ret.append(GsmAlphabet.gsm8BitUnpackedToString(data, offset, count));
                offset += count;
                len -= count;
            }
            return ret.toString();
        }
        Resources resource = Resources.getSystem();
        String defaultCharset = "";
        try {
            defaultCharset = resource.getString(17039974);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return GsmAlphabet.gsm8BitUnpackedToString(data, offset, length, defaultCharset.trim());
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("invalid hex char '" + c + "'");
    }

    private static final byte[] $$robo$$com_android_internal_telephony_uicc_IccUtils$hexStringToBytes(String s) {
        if (s == null) {
            return null;
        }
        int sz = s.length();
        byte[] ret = new byte[sz / 2];
        for (int i = 0; i < sz; i += 2) {
            ret[i / 2] = (byte)(IccUtils.hexCharToInt(s.charAt(i)) << 4 | IccUtils.hexCharToInt(s.charAt(i + 1)));
        }
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0xF & bytes[i] >> 4;
            ret.append(HEX_CHARS[b]);
            b = 0xF & bytes[i];
            ret.append(HEX_CHARS[b]);
        }
        return ret.toString();
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$networkNameToString(byte[] data, int offset, int length) {
        String ret;
        if ((data[offset] & 0x80) != 128 || length < 1) {
            return "";
        }
        switch (data[offset] >>> 4 & 7) {
            case 0: {
                int unusedBits = data[offset] & 7;
                int countSeptets = ((length - 1) * 8 - unusedBits) / 7;
                ret = GsmAlphabet.gsm7BitPackedToString(data, offset + 1, countSeptets);
                break;
            }
            case 1: {
                try {
                    ret = new String(data, offset + 1, length - 1, "utf-16");
                }
                catch (UnsupportedEncodingException ex) {
                    ret = "";
                    Rlog.e("IccUtils", "implausible UnsupportedEncodingException", ex);
                }
                break;
            }
            default: {
                ret = "";
            }
        }
        if ((data[offset] & 0x40) != 0) {
            // empty if block
        }
        return ret;
    }

    private static final Bitmap $$robo$$com_android_internal_telephony_uicc_IccUtils$parseToBnW(byte[] data, int length) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        int pixelIndex = 0;
        int bitIndex = 7;
        byte currentByte = 0;
        while (pixelIndex < numOfPixels) {
            if (pixelIndex % 8 == 0) {
                currentByte = data[valueIndex++];
                bitIndex = 7;
            }
            pixels[pixelIndex++] = IccUtils.bitToRGB(currentByte >> bitIndex-- & 1);
        }
        if (pixelIndex != numOfPixels) {
            Rlog.e("IccUtils", "parse end and size error");
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$bitToRGB(int bit) {
        if (bit == 1) {
            return -1;
        }
        return -16777216;
    }

    private static final Bitmap $$robo$$com_android_internal_telephony_uicc_IccUtils$parseToRGB(byte[] data, int length, boolean transparency) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int bits = data[valueIndex++] & 0xFF;
        int colorNumber = data[valueIndex++] & 0xFF;
        int clutOffset = (data[valueIndex++] & 0xFF) << 8 | data[valueIndex++] & 0xFF;
        int[] colorIndexArray = IccUtils.getCLUT(data, clutOffset, colorNumber);
        if (transparency) {
            colorIndexArray[colorNumber - 1] = 0;
        }
        int[] resultArray = null;
        resultArray = 0 == 8 % bits ? IccUtils.mapTo2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits) : IccUtils.mapToNon2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits);
        return Bitmap.createBitmap(resultArray, width, height, Bitmap.Config.RGB_565);
    }

    private static final int[] $$robo$$com_android_internal_telephony_uicc_IccUtils$mapTo2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 != 8 % bits) {
            Rlog.e("IccUtils", "not event number of color");
            return IccUtils.mapToNon2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int mask = 1;
        switch (bits) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 3;
                break;
            }
            case 4: {
                mask = 15;
                break;
            }
            case 8: {
                mask = 255;
            }
        }
        int[] resultArray = new int[length];
        int resultIndex = 0;
        int run = 8 / bits;
        while (resultIndex < length) {
            byte tempByte = data[valueIndex++];
            for (int runIndex = 0; runIndex < run; ++runIndex) {
                int offset = run - runIndex - 1;
                resultArray[resultIndex++] = colorArray[tempByte >> offset * bits & mask];
            }
        }
        return resultArray;
    }

    private static final int[] $$robo$$com_android_internal_telephony_uicc_IccUtils$mapToNon2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 == 8 % bits) {
            Rlog.e("IccUtils", "not odd number of color");
            return IccUtils.mapTo2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int[] resultArray = new int[length];
        return resultArray;
    }

    private static final int[] $$robo$$com_android_internal_telephony_uicc_IccUtils$getCLUT(byte[] rawData, int offset, int number) {
        if (null == rawData) {
            return null;
        }
        int[] result = new int[number];
        int endIndex = offset + number * 3;
        int valueIndex = offset;
        int colorIndex = 0;
        int alpha = -16777216;
        do {
            result[colorIndex++] = alpha | (rawData[valueIndex++] & 0xFF) << 16 | (rawData[valueIndex++] & 0xFF) << 8 | rawData[valueIndex++] & 0xFF;
        } while (valueIndex < endIndex);
        return result;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$getDecimalSubstring(String iccId) {
        int position;
        for (position = 0; position < iccId.length() && Character.isDigit(iccId.charAt(position)); ++position) {
        }
        return iccId.substring(0, position);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToInt(byte[] src, int offset, int length) {
        if (length > 4) {
            throw new IllegalArgumentException("length must be <= 4 (only 32-bit integer supported): " + length);
        }
        if (offset < 0 || length < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: src=[" + src.length + "], offset=" + offset + ", length=" + length);
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | src[offset + i] & 0xFF;
        }
        if (result < 0) {
            throw new IllegalArgumentException("src cannot be parsed as a positive integer: " + result);
        }
        return result;
    }

    private static final long $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToRawLong(byte[] src, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("length must be <= 8 (only 64-bit long supported): " + length);
        }
        if (offset < 0 || length < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: src=[" + src.length + "], offset=" + offset + ", length=" + length);
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | (long)(src[offset + i] & 0xFF);
        }
        return result;
    }

    private static final byte[] $$robo$$com_android_internal_telephony_uicc_IccUtils$unsignedIntToBytes(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        byte[] bytes = new byte[IccUtils.byteNumForUnsignedInt(value)];
        IccUtils.unsignedIntToBytes(value, bytes, 0);
        return bytes;
    }

    private static final byte[] $$robo$$com_android_internal_telephony_uicc_IccUtils$signedIntToBytes(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        byte[] bytes = new byte[IccUtils.byteNumForSignedInt(value)];
        IccUtils.signedIntToBytes(value, bytes, 0);
        return bytes;
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$unsignedIntToBytes(int value, byte[] dest, int offset) {
        return IccUtils.intToBytes(value, dest, offset, false);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$signedIntToBytes(int value, byte[] dest, int offset) {
        return IccUtils.intToBytes(value, dest, offset, true);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForUnsignedInt(int value) {
        return IccUtils.byteNumForInt(value, false);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForSignedInt(int value) {
        return IccUtils.byteNumForInt(value, true);
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$intToBytes(int value, byte[] dest, int offset, boolean signed) {
        int l = IccUtils.byteNumForInt(value, signed);
        if (offset < 0 || offset + l > dest.length) {
            throw new IndexOutOfBoundsException("Not enough space to write. Required bytes: " + l);
        }
        int i = l - 1;
        int v = value;
        while (i >= 0) {
            byte b;
            dest[offset + i] = b = (byte)(v & 0xFF);
            --i;
            v >>>= 8;
        }
        return l;
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForInt(int value, boolean signed) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        if (signed) {
            if (value <= 127) {
                return 1;
            }
            if (value <= Short.MAX_VALUE) {
                return 2;
            }
            if (value <= 0x7FFFFF) {
                return 3;
            }
        } else {
            if (value <= 255) {
                return 1;
            }
            if (value <= 65535) {
                return 2;
            }
            if (value <= 0xFFFFFF) {
                return 3;
            }
        }
        return 4;
    }

    private static final byte $$robo$$com_android_internal_telephony_uicc_IccUtils$countTrailingZeros(byte b) {
        if (b == 0) {
            return 8;
        }
        int v = b & 0xFF;
        byte c = 7;
        if ((v & 0xF) != 0) {
            c = (byte)(c - 4);
        }
        if ((v & 0x33) != 0) {
            c = (byte)(c - 2);
        }
        if ((v & 0x55) != 0) {
            c = (byte)(c - 1);
        }
        return c;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$byteToHex(byte b) {
        return new String(new char[]{HEX_CHARS[(b & 0xFF) >>> 4], HEX_CHARS[b & 0xF]});
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_IccUtils$stripTrailingFs(String s) {
        return s == null ? null : s.replaceAll("(?i)f*$", "");
    }

    private static final byte $$robo$$com_android_internal_telephony_uicc_IccUtils$charToByte(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 55);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 87);
        }
        return 0;
    }

    static void __staticInitializer__() {
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_uicc_IccUtils$__constructor__();
    }

    public IccUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccUtils$__constructor__(), this);
    }

    public static String bcdToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("bcdToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToString(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static String bcdToString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("bcdToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToString(byte[] ), (byte[])byArray);
    }

    public static byte[] bcdToBytes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("bcdToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToBytes(java.lang.String ), (String)string2);
    }

    public static void bcdToBytes(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("bcdToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdToBytes(java.lang.String byte[] ), (String)string2, (byte[])byArray);
    }

    public static String bcdPlmnToString(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("bcdPlmnToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$bcdPlmnToString(byte[] int ), (byte[])byArray, (int)n);
    }

    public static String bchToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("bchToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$bchToString(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static String cdmaBcdToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("cdmaBcdToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$cdmaBcdToString(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static int gsmBcdByteToInt(byte by) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gsmBcdByteToInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$gsmBcdByteToInt(byte ), (byte)by);
    }

    public static int cdmaBcdByteToInt(byte by) {
        return (int)InvokeDynamicSupport.bootstrapStatic("cdmaBcdByteToInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$cdmaBcdByteToInt(byte ), (byte)by);
    }

    public static String adnStringFieldToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("adnStringFieldToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$adnStringFieldToString(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static int hexCharToInt(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hexCharToInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$hexCharToInt(char ), (char)c);
    }

    public static byte[] hexStringToBytes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("hexStringToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$hexStringToBytes(java.lang.String ), (String)string2);
    }

    public static String bytesToHexString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("bytesToHexString", $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToHexString(byte[] ), (byte[])byArray);
    }

    public static String networkNameToString(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("networkNameToString", $$robo$$com_android_internal_telephony_uicc_IccUtils$networkNameToString(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static Bitmap parseToBnW(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseToBnW", $$robo$$com_android_internal_telephony_uicc_IccUtils$parseToBnW(byte[] int ), (byte[])byArray, (int)n);
    }

    private static int bitToRGB(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bitToRGB", $$robo$$com_android_internal_telephony_uicc_IccUtils$bitToRGB(int ), (int)n);
    }

    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("parseToRGB", $$robo$$com_android_internal_telephony_uicc_IccUtils$parseToRGB(byte[] int boolean ), (byte[])byArray, (int)n, (boolean)bl);
    }

    private static int[] mapTo2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("mapTo2OrderBitColor", $$robo$$com_android_internal_telephony_uicc_IccUtils$mapTo2OrderBitColor(byte[] int int int[] int ), (byte[])byArray, (int)n, (int)n2, (int[])nArray, (int)n3);
    }

    private static int[] mapToNon2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("mapToNon2OrderBitColor", $$robo$$com_android_internal_telephony_uicc_IccUtils$mapToNon2OrderBitColor(byte[] int int int[] int ), (byte[])byArray, (int)n, (int)n2, (int[])nArray, (int)n3);
    }

    private static int[] getCLUT(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getCLUT", $$robo$$com_android_internal_telephony_uicc_IccUtils$getCLUT(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static String getDecimalSubstring(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDecimalSubstring", $$robo$$com_android_internal_telephony_uicc_IccUtils$getDecimalSubstring(java.lang.String ), (String)string2);
    }

    public static int bytesToInt(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bytesToInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToInt(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static long bytesToRawLong(byte[] byArray, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("bytesToRawLong", $$robo$$com_android_internal_telephony_uicc_IccUtils$bytesToRawLong(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static byte[] unsignedIntToBytes(int n) {
        return InvokeDynamicSupport.bootstrapStatic("unsignedIntToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$unsignedIntToBytes(int ), (int)n);
    }

    public static byte[] signedIntToBytes(int n) {
        return InvokeDynamicSupport.bootstrapStatic("signedIntToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$signedIntToBytes(int ), (int)n);
    }

    public static int unsignedIntToBytes(int n, byte[] byArray, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("unsignedIntToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$unsignedIntToBytes(int byte[] int ), (int)n, (byte[])byArray, (int)n2);
    }

    public static int signedIntToBytes(int n, byte[] byArray, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("signedIntToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$signedIntToBytes(int byte[] int ), (int)n, (byte[])byArray, (int)n2);
    }

    public static int byteNumForUnsignedInt(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("byteNumForUnsignedInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForUnsignedInt(int ), (int)n);
    }

    public static int byteNumForSignedInt(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("byteNumForSignedInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForSignedInt(int ), (int)n);
    }

    private static int intToBytes(int n, byte[] byArray, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("intToBytes", $$robo$$com_android_internal_telephony_uicc_IccUtils$intToBytes(int byte[] int boolean ), (int)n, (byte[])byArray, (int)n2, (boolean)bl);
    }

    private static int byteNumForInt(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("byteNumForInt", $$robo$$com_android_internal_telephony_uicc_IccUtils$byteNumForInt(int boolean ), (int)n, (boolean)bl);
    }

    public static byte countTrailingZeros(byte by) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("countTrailingZeros", $$robo$$com_android_internal_telephony_uicc_IccUtils$countTrailingZeros(byte ), (byte)by);
    }

    public static String byteToHex(byte by) {
        return InvokeDynamicSupport.bootstrapStatic("byteToHex", $$robo$$com_android_internal_telephony_uicc_IccUtils$byteToHex(byte ), (byte)by);
    }

    public static String stripTrailingFs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stripTrailingFs", $$robo$$com_android_internal_telephony_uicc_IccUtils$stripTrailingFs(java.lang.String ), (String)string2);
    }

    private static byte charToByte(char c) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("charToByte", $$robo$$com_android_internal_telephony_uicc_IccUtils$charToByte(char ), (char)c);
    }

    static {
        RobolectricInternals.classInitializing(IccUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

