/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.uicc.InstallCarrierAppUtils;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InstallCarrierAppTrampolineActivity
extends Activity
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierAppInstall";
    private static int INSTALL_CARRIER_APP_DIALOG_REQUEST = 1;
    private static int DOWNLOAD_RESULT = 2;
    private static String CARRIER_NAME = "carrier_name";
    private static String BUNDLE_KEY_PACKAGE_NAME = "package_name";
    private String mPackageName;

    private void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$__constructor__() {
    }

    private static final Intent $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$get(Context context, String packageName) {
        Intent intent = new Intent(context, InstallCarrierAppTrampolineActivity.class);
        intent.putExtra("package_name", packageName);
        return intent;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mPackageName = intent.getStringExtra("package_name");
        }
        if (savedInstanceState == null) {
            long sleepTimeMillis = Settings.Global.getLong(this.getContentResolver(), "install_carrier_app_notification_sleep_millis", TimeUnit.HOURS.toMillis(24L));
            Log.d("CarrierAppInstall", "Sleeping carrier app install notification for : " + sleepTimeMillis + " millis");
            InstallCarrierAppUtils.showNotificationIfNotInstalledDelayed(this, this.mPackageName, sleepTimeMillis);
        }
        Intent showDialogIntent = new Intent();
        ComponentName dialogComponentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039639));
        showDialogIntent.setComponent(dialogComponentName);
        String appName = InstallCarrierAppUtils.getAppNameFromPackageName(this, this.mPackageName);
        if (!TextUtils.isEmpty(appName)) {
            showDialogIntent.putExtra("carrier_name", appName);
        }
        if (showDialogIntent.resolveActivity(this.getPackageManager()) == null) {
            Log.d("CarrierAppInstall", "Could not resolve activity for installing the carrier app");
            this.finishNoAnimation();
        } else {
            this.startActivityForResult(showDialogIntent, 1);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            if (resultCode == 2) {
                this.startActivity(InstallCarrierAppUtils.getPlayStoreIntent(this.mPackageName));
            }
            this.finishNoAnimation();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$finishNoAnimation() {
        this.finish();
        this.overridePendingTransition(0, 0);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$__constructor__();
    }

    public InstallCarrierAppTrampolineActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$__constructor__(), this);
    }

    public static Intent get(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$get(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$onCreate(android.os.Bundle ), this, bundle);
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("onActivityResult", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$onActivityResult(int int android.content.Intent ), this, n, n2, intent);
    }

    private void finishNoAnimation() {
        InvokeDynamicSupport.bootstrap("finishNoAnimation", $$robo$$com_android_internal_telephony_uicc_InstallCarrierAppTrampolineActivity$finishNoAnimation(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallCarrierAppTrampolineActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

