/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Message;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionInfo;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.AdnRecordLoader;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IccVmFixedException;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.PlmnActRecord;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UsimServiceTable;
import com.android.internal.telephony.uicc.VoiceMailConstants;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SIMRecords
extends IccRecords
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected static String LOG_TAG = "SIMRecords";
    private static boolean CRASH_RIL = false;
    private static boolean VDBG = false;
    VoiceMailConstants mVmConfig;
    private int mCallForwardingStatus;
    private GetSpnFsmState mSpnState;
    private byte[] mCphsInfo;
    boolean mCspPlmnEnabled;
    byte[] mEfMWIS;
    byte[] mEfCPHS_MWI;
    byte[] mEfCff;
    byte[] mEfCfis;
    byte[] mEfLi;
    byte[] mEfPl;
    int mSpnDisplayCondition;
    ArrayList<String> mSpdiNetworks;
    UsimServiceTable mUsimServiceTable;
    static int TAG_SPDI = 163;
    static int TAG_SPDI_PLMN_LIST = 128;
    static int TAG_FULL_NETWORK_NAME = 67;
    static int TAG_SHORT_NETWORK_NAME = 69;
    static int CFF_UNCONDITIONAL_ACTIVE = 10;
    static int CFF_UNCONDITIONAL_DEACTIVE = 5;
    static int CFF_LINE1_MASK = 15;
    static int CFF_LINE1_RESET = 240;
    private static int CPHS_SST_MBN_MASK = 48;
    private static int CPHS_SST_MBN_ENABLED = 48;
    private static int CFIS_BCD_NUMBER_LENGTH_OFFSET = 2;
    private static int CFIS_TON_NPI_OFFSET = 3;
    private static int CFIS_ADN_CAPABILITY_ID_OFFSET = 14;
    private static int CFIS_ADN_EXTENSION_ID_OFFSET = 15;
    private static int SIM_RECORD_EVENT_BASE = 0;
    private static int EVENT_GET_IMSI_DONE = 3;
    private static int EVENT_GET_ICCID_DONE = 4;
    private static int EVENT_GET_MBI_DONE = 5;
    private static int EVENT_GET_MBDN_DONE = 6;
    private static int EVENT_GET_MWIS_DONE = 7;
    private static int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    private static int EVENT_GET_AD_DONE = 9;
    private static int EVENT_GET_MSISDN_DONE = 10;
    private static int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    private static int EVENT_GET_SPN_DONE = 12;
    private static int EVENT_GET_SPDI_DONE = 13;
    private static int EVENT_UPDATE_DONE = 14;
    private static int EVENT_GET_PNN_DONE = 15;
    private static int EVENT_GET_SST_DONE = 17;
    private static int EVENT_GET_ALL_SMS_DONE = 18;
    private static int EVENT_MARK_SMS_READ_DONE = 19;
    private static int EVENT_SET_MBDN_DONE = 20;
    private static int EVENT_SMS_ON_SIM = 21;
    private static int EVENT_GET_SMS_DONE = 22;
    private static int EVENT_GET_CFF_DONE = 24;
    private static int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    private static int EVENT_GET_INFO_CPHS_DONE = 26;
    private static int EVENT_SET_MSISDN_DONE = 30;
    private static int EVENT_GET_CFIS_DONE = 32;
    private static int EVENT_GET_CSP_CPHS_DONE = 33;
    private static int EVENT_GET_GID1_DONE = 34;
    private static int EVENT_GET_GID2_DONE = 36;
    private static int EVENT_GET_PLMN_W_ACT_DONE = 37;
    private static int EVENT_GET_OPLMN_W_ACT_DONE = 38;
    private static int EVENT_GET_HPLMN_W_ACT_DONE = 39;
    private static int EVENT_GET_EHPLMN_DONE = 40;
    private static int EVENT_GET_FPLMN_DONE = 41;
    private static int SYSTEM_EVENT_BASE = 256;
    private static int EVENT_APP_LOCKED = 258;
    private static int EVENT_APP_NETWORK_LOCKED = 259;
    private static String[] MCCMNC_CODES_HAVING_3DIGITS_MNC;

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$toString() {
        return "SimRecords: " + super.toString() + " mVmConfig" + this.mVmConfig + " callForwardingEnabled=" + this.mCallForwardingStatus + " spnState=" + (Object)((Object)this.mSpnState) + " mCphsInfo=" + this.mCphsInfo + " mCspPlmnEnabled=" + this.mCspPlmnEnabled + " efMWIS=" + this.mEfMWIS + " efCPHS_MWI=" + this.mEfCPHS_MWI + " mEfCff=" + this.mEfCff + " mEfCfis=" + this.mEfCfis + " getOperatorNumeric=" + this.getOperatorNumeric();
    }

    private void $$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mCphsInfo = null;
        this.mCspPlmnEnabled = true;
        this.mEfMWIS = null;
        this.mEfCPHS_MWI = null;
        this.mEfCff = null;
        this.mEfCfis = null;
        this.mEfLi = null;
        this.mEfPl = null;
        this.mSpdiNetworks = null;
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mVmConfig = new VoiceMailConstants();
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mRecordsToLoad = 0;
        this.mCi.setOnSmsOnSim(this, 21, null);
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.mParentApp.registerForLocked(this, 258, null);
        this.mParentApp.registerForNetworkLocked(this, 259, null);
        this.log("SIMRecords X ctor this=" + this);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispose() {
        this.log("Disposing SIMRecords this=" + this);
        this.mCi.unSetOnSmsOnSim(this);
        this.mParentApp.unregisterForReady(this);
        this.mParentApp.unregisterForLocked(this);
        this.mParentApp.unregisterForNetworkLocked(this);
        this.resetRecords();
        super.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$finalize() {
        this.log("finalized");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$resetRecords() {
        this.mImsi = null;
        this.mMsisdn = null;
        this.mVoiceMailNum = null;
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mFullIccId = null;
        this.mSpnDisplayCondition = -1;
        this.mEfMWIS = null;
        this.mEfCPHS_MWI = null;
        this.mSpdiNetworks = null;
        this.mPnnHomeName = null;
        this.mGid1 = null;
        this.mGid2 = null;
        this.mPlmnActRecords = null;
        this.mOplmnActRecords = null;
        this.mHplmnActRecords = null;
        this.mFplmns = null;
        this.mEhplmns = null;
        this.mAdnCache.reset();
        this.log("SIMRecords: onRadioOffOrNotAvailable set 'gsm.sim.operator.numeric' to operator=null");
        this.log("update icc_operator_numeric=" + null);
        this.mTelephonyManager.setSimOperatorNumericForPhone(this.mParentApp.getPhoneId(), "");
        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), "");
        this.mTelephonyManager.setSimCountryIsoForPhone(this.mParentApp.getPhoneId(), "");
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mLoaded.set(false);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnNumber() {
        return this.mMsisdn;
    }

    private final UsimServiceTable $$robo$$com_android_internal_telephony_uicc_SIMRecords$getUsimServiceTable() {
        return this.mUsimServiceTable;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$getExtFromEf(int ef) {
        int ext;
        switch (ef) {
            case 28480: {
                if (this.mParentApp.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
                    ext = 28494;
                    break;
                }
                ext = 28490;
                break;
            }
            default: {
                ext = 28490;
            }
        }
        return ext;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.mNewMsisdn = number;
        this.mNewMsisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.mNewMsisdnTag + " " + Rlog.pii("SIMRecords", (Object)this.mNewMsisdn));
        AdnRecord adn = new AdnRecord(this.mNewMsisdnTag, this.mNewMsisdn);
        new AdnRecordLoader(this.mFh).updateEF(adn, 28480, this.getExtFromEf(28480), 1, null, this.obtainMessage(30, onComplete));
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        if (this.mIsVoiceMailFixed) {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmFixedException("Voicemail number is fixed by operator");
            onComplete.sendToTarget();
            return;
        }
        this.mNewVoiceMailNum = voiceNumber;
        this.mNewVoiceMailTag = alphaTag;
        AdnRecord adn = new AdnRecord(this.mNewVoiceMailTag, this.mNewVoiceMailNum);
        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28615, 28616, this.mMailboxIndex, null, this.obtainMessage(20, onComplete));
        } else if (this.isCphsMailboxEnabled()) {
            new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onComplete));
        } else {
            AsyncResult.forMessage((Message)onComplete).exception = new IccVmNotSupportedException("Update SIM voice mailbox error");
            onComplete.sendToTarget();
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMessageWaiting(int line, int countWaiting) {
        if (line != 1) {
            return;
        }
        try {
            if (this.mEfMWIS != null) {
                this.mEfMWIS[0] = (byte)(this.mEfMWIS[0] & 0xFE | (countWaiting == 0 ? 0 : 1));
                this.mEfMWIS[1] = countWaiting < 0 ? (byte)0 : (byte)countWaiting;
                this.mFh.updateEFLinearFixed(28618, 1, this.mEfMWIS, null, this.obtainMessage(14, 28618, 0));
            }
            if (this.mEfCPHS_MWI != null) {
                this.mEfCPHS_MWI[0] = (byte)(this.mEfCPHS_MWI[0] & 0xF0 | (countWaiting == 0 ? 5 : 10));
                this.mFh.updateEFTransparent(28433, this.mEfCPHS_MWI, this.obtainMessage(14, 28433));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving voice mail state to SIM. Probably malformed SIM record", ex);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$validEfCfis(byte[] data) {
        if (data != null) {
            if (data[0] < 1 || data[0] > 4) {
                this.logw("MSP byte: " + data[0] + " is not between 1 and 4", null);
            }
            for (byte b : data) {
                if (b == -1) continue;
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMessageCount() {
        boolean voiceMailWaiting = false;
        int countVoiceMessages = -2;
        if (this.mEfMWIS != null) {
            voiceMailWaiting = (this.mEfMWIS[0] & 1) != 0;
            countVoiceMessages = this.mEfMWIS[1] & 0xFF;
            if (voiceMailWaiting && (countVoiceMessages == 0 || countVoiceMessages == 255)) {
                countVoiceMessages = -1;
            }
            this.log(" VoiceMessageCount from SIM MWIS = " + countVoiceMessages);
        } else if (this.mEfCPHS_MWI != null) {
            int indicator = this.mEfCPHS_MWI[0] & 0xF;
            if (indicator == 10) {
                countVoiceMessages = -1;
            } else if (indicator == 5) {
                countVoiceMessages = 0;
            }
            this.log(" VoiceMessageCount from SIM CPHS = " + countVoiceMessages);
        }
        return countVoiceMessages;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceCallForwardingFlag() {
        return this.mCallForwardingStatus;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlag(int line, boolean enable, String dialNumber) {
        if (line != 1) {
            return;
        }
        this.mCallForwardingStatus = enable ? 1 : 0;
        this.mRecordsEventsRegistrants.notifyResult(1);
        try {
            if (this.validEfCfis(this.mEfCfis)) {
                this.mEfCfis[1] = enable ? (byte)(this.mEfCfis[1] | 1) : (byte)(this.mEfCfis[1] & 0xFE);
                this.log("setVoiceCallForwardingFlag: enable=" + enable + " mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
                if (enable && !TextUtils.isEmpty(dialNumber)) {
                    this.logv("EF_CFIS: updating cf number, " + Rlog.pii("SIMRecords", (Object)dialNumber));
                    byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(dialNumber, 1);
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])bcdNumber, (int)0, (byte[])this.mEfCfis, (int)3, (int)bcdNumber.length);
                    this.mEfCfis[2] = (byte)bcdNumber.length;
                    this.mEfCfis[14] = -1;
                    this.mEfCfis[15] = -1;
                }
                this.mFh.updateEFLinearFixed(28619, 1, this.mEfCfis, null, this.obtainMessage(14, 28619));
            } else {
                this.log("setVoiceCallForwardingFlag: ignoring enable=" + enable + " invalid mEfCfis=" + IccUtils.bytesToHexString(this.mEfCfis));
            }
            if (this.mEfCff != null) {
                this.mEfCff[0] = enable ? (byte)(this.mEfCff[0] & 0xF0 | 0xA) : (byte)(this.mEfCff[0] & 0xF0 | 5);
                this.mFh.updateEFTransparent(28435, this.mEfCff, this.obtainMessage(14, 28435));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.logw("Error saving call forwarding flag to SIM. Probably malformed SIM record", ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchSimRecords();
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords$getOperatorNumeric() {
        String imsi = this.getIMSI();
        if (imsi == null) {
            this.log("getOperatorNumeric: IMSI == null");
            return null;
        }
        if (this.mMncLength == -1 || this.mMncLength == 0) {
            this.log("getSIMOperatorNumeric: bad mncLength");
            return null;
        }
        if (imsi.length() >= 3 + this.mMncLength) {
            return imsi.substring(0, 3 + this.mMncLength);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "]  while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 258: 
                case 259: {
                    this.onLocked(msg.what);
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    }
                    this.mImsi = (String)ar.result;
                    if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                        this.loge("invalid IMSI " + this.mImsi);
                        this.mImsi = null;
                    }
                    this.log("IMSI: mMncLength=" + this.mMncLength);
                    if (this.mImsi != null && this.mImsi.length() >= 6) {
                        this.log("IMSI: " + this.mImsi.substring(0, 6) + Rlog.pii("SIMRecords", (Object)this.mImsi.substring(6)));
                    }
                    String imsi = this.getIMSI();
                    if ((this.mMncLength == 0 || this.mMncLength == 2) && imsi != null && imsi.length() >= 6) {
                        String mccmncCode = imsi.substring(0, 6);
                        for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                            if (!mccmnc.equals(mccmncCode)) continue;
                            this.mMncLength = 3;
                            this.log("IMSI: setting1 mMncLength=" + this.mMncLength);
                            break;
                        }
                    }
                    if (this.mMncLength == 0) {
                        try {
                            int mcc = Integer.parseInt(imsi.substring(0, 3));
                            this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                            this.log("setting2 mMncLength=" + this.mMncLength);
                        }
                        catch (NumberFormatException e) {
                            this.mMncLength = 0;
                            this.loge("Corrupt IMSI! setting3 mMncLength=" + this.mMncLength);
                        }
                    }
                    if (this.mMncLength != 0 && this.mMncLength != -1 && imsi.length() >= 3 + this.mMncLength) {
                        this.log("update mccmnc=" + imsi.substring(0, 3 + this.mMncLength));
                        MccTable.updateMccMncConfiguration(this.mContext, imsi.substring(0, 3 + this.mMncLength), false);
                    }
                    this.mImsiReadyRegistrants.notifyRegistrants();
                    return;
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    boolean isValidMbdn = false;
                    if (ar.exception == null) {
                        this.log("EF_MBI: " + IccUtils.bytesToHexString(data));
                        this.mMailboxIndex = data[0] & 0xFF;
                        if (this.mMailboxIndex != 0 && this.mMailboxIndex != 255) {
                            this.log("Got valid mailbox number for MBDN");
                            isValidMbdn = true;
                        }
                    }
                    ++this.mRecordsToLoad;
                    if (isValidMbdn) {
                        new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                        return;
                    }
                    new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                    return;
                }
                case 6: 
                case 11: {
                    this.mVoiceMailNum = null;
                    this.mVoiceMailTag = null;
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF" + (msg.what == 11 ? "[MAILBOX]" : "[MBDN]"));
                        if (msg.what != 6) return;
                        ++this.mRecordsToLoad;
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    }
                    AdnRecord adn = (AdnRecord)ar.result;
                    this.log("VM: " + adn + (msg.what == 11 ? " EF[MAILBOX]" : " EF[MBDN]"));
                    if (adn.isEmpty() && msg.what == 6) {
                        ++this.mRecordsToLoad;
                        new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                        return;
                    }
                    this.mVoiceMailNum = adn.getNumber();
                    this.mVoiceMailTag = adn.getAlphaTag();
                    return;
                }
                case 10: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("Invalid or missing EF[MSISDN]");
                        return;
                    }
                    AdnRecord adn = (AdnRecord)ar.result;
                    this.mMsisdn = adn.getNumber();
                    this.mMsisdnTag = adn.getAlphaTag();
                    this.log("MSISDN: " + Rlog.pii("SIMRecords", (Object)this.mMsisdn));
                    return;
                }
                case 30: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.mMsisdn = this.mNewMsisdn;
                        this.mMsisdnTag = this.mNewMsisdnTag;
                        this.log("Success to update EF[MSISDN]");
                    }
                    if (ar.userObj == null) return;
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 7: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    this.log("EF_MWIS : " + IccUtils.bytesToHexString(data));
                    if (ar.exception != null) {
                        this.log("EVENT_GET_MWIS_DONE exception = " + ar.exception);
                        return;
                    }
                    if ((data[0] & 0xFF) == 255) {
                        this.log("SIMRecords: Uninitialized record MWIS");
                        return;
                    }
                    this.mEfMWIS = data;
                    return;
                }
                case 8: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    this.log("EF_CPHS_MWI: " + IccUtils.bytesToHexString(data));
                    if (ar.exception != null) {
                        this.log("EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE exception = " + ar.exception);
                        return;
                    }
                    this.mEfCPHS_MWI = data;
                    return;
                }
                case 4: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                    this.mFullIccId = IccUtils.bchToString(data, 0, data.length);
                    this.log("iccid: " + SubscriptionInfo.givePrintableIccid(this.mFullIccId));
                    return;
                }
                case 9: {
                    try {
                        isRecordLoadResponse = true;
                        if (this.mCarrierTestOverride.isInTestMode() && this.getIMSI() != null) {
                            String imsi = this.getIMSI();
                            try {
                                int mcc = Integer.parseInt(imsi.substring(0, 3));
                                this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                this.log("[TestMode] mMncLength=" + this.mMncLength);
                            }
                            catch (NumberFormatException e) {
                                this.mMncLength = 0;
                                this.loge("[TestMode] Corrupt IMSI! mMncLength=" + this.mMncLength);
                            }
                        } else {
                            AsyncResult ar = (AsyncResult)msg.obj;
                            byte[] data = (byte[])ar.result;
                            if (ar.exception != null) {
                                return;
                            }
                            this.log("EF_AD: " + IccUtils.bytesToHexString(data));
                            if (data.length < 3) {
                                this.log("Corrupt AD data on SIM");
                                return;
                            }
                            if (data.length == 3) {
                                this.log("MNC length not present in EF_AD");
                                return;
                            }
                            this.mMncLength = data[3] & 0xF;
                            this.log("setting4 mMncLength=" + this.mMncLength);
                        }
                        if (this.mMncLength == 15) {
                            this.mMncLength = 0;
                            this.log("setting5 mMncLength=" + this.mMncLength);
                            return;
                        }
                        if (this.mMncLength == 2) return;
                        if (this.mMncLength == 3) return;
                        this.mMncLength = -1;
                        this.log("setting5 mMncLength=" + this.mMncLength);
                        return;
                    }
                    finally {
                        String imsi = this.getIMSI();
                        if ((this.mMncLength == -1 || this.mMncLength == 0 || this.mMncLength == 2) && imsi != null && imsi.length() >= 6) {
                            String mccmncCode = imsi.substring(0, 6);
                            this.log("mccmncCode=" + mccmncCode);
                            for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                                if (!mccmnc.equals(mccmncCode)) continue;
                                this.mMncLength = 3;
                                this.log("setting6 mMncLength=" + this.mMncLength);
                                break;
                            }
                        }
                        if (this.mMncLength == 0 || this.mMncLength == -1) {
                            if (imsi != null) {
                                try {
                                    int mcc = Integer.parseInt(imsi.substring(0, 3));
                                    this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                                    this.log("setting7 mMncLength=" + this.mMncLength);
                                }
                                catch (NumberFormatException e) {
                                    this.mMncLength = 0;
                                    this.loge("Corrupt IMSI! setting8 mMncLength=" + this.mMncLength);
                                }
                            } else {
                                this.mMncLength = 0;
                                this.log("MNC length not present in EF_AD setting9 mMncLength=" + this.mMncLength);
                            }
                        }
                        if (imsi != null && this.mMncLength != 0 && imsi.length() >= 3 + this.mMncLength) {
                            this.log("update mccmnc=" + imsi.substring(0, 3 + this.mMncLength));
                            MccTable.updateMccMncConfiguration(this.mContext, imsi.substring(0, 3 + this.mMncLength), false);
                        }
                    }
                }
                case 12: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.getSpnFsm(false, ar);
                    return;
                }
                case 24: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.mEfCff = null;
                        return;
                    }
                    this.log("EF_CFF_CPHS: " + IccUtils.bytesToHexString(data));
                    this.mEfCff = data;
                    return;
                }
                case 13: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.parseEfSpdi(data);
                    return;
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    this.logw("update failed. ", ar.exception);
                    return;
                }
                case 15: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    SimTlv tlv = new SimTlv(data, 0, data.length);
                    while (tlv.isValidObject()) {
                        if (tlv.getTag() == 67) {
                            this.mPnnHomeName = IccUtils.networkNameToString(tlv.getData(), 0, tlv.getData().length);
                            this.log("PNN: " + this.mPnnHomeName);
                            return;
                        }
                        tlv.nextObject();
                    }
                    return;
                }
                case 18: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    }
                    this.handleSmses((ArrayList)ar.result);
                    return;
                }
                case 19: {
                    Rlog.i("ENF", "marked read: sms " + msg.arg1);
                    return;
                }
                case 21: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Integer index = (Integer)ar.result;
                    if (ar.exception == null && index != null) {
                        this.log("READ EF_SMS RECORD index=" + index);
                        this.mFh.loadEFLinearFixed(28476, index, this.obtainMessage(22));
                        return;
                    }
                    this.loge("Error on SMS_ON_SIM with exp " + ar.exception + " index " + index);
                    return;
                }
                case 22: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.handleSms((byte[])ar.result);
                        return;
                    }
                    this.loge("Error on GET_SMS with exp " + ar.exception);
                    return;
                }
                case 17: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mUsimServiceTable = new UsimServiceTable(data);
                    this.log("SST: " + this.mUsimServiceTable);
                    return;
                }
                case 26: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        return;
                    }
                    this.mCphsInfo = (byte[])ar.result;
                    this.log("iCPHS: " + IccUtils.bytesToHexString(this.mCphsInfo));
                    return;
                }
                case 20: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("EVENT_SET_MBDN_DONE ex:" + ar.exception);
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    }
                    if (this.isCphsMailboxEnabled()) {
                        AdnRecord adn = new AdnRecord(this.mVoiceMailTag, this.mVoiceMailNum);
                        Message onCphsCompleted = (Message)ar.userObj;
                        if (ar.exception == null && ar.userObj != null) {
                            AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = null;
                            ((Message)ar.userObj).sendToTarget();
                            this.log("Callback with MBDN successful.");
                            onCphsCompleted = null;
                        }
                        new AdnRecordLoader(this.mFh).updateEF(adn, 28439, 28490, 1, null, this.obtainMessage(25, onCphsCompleted));
                        return;
                    }
                    if (ar.userObj == null) return;
                    CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception != null && configLoader != null && configLoader.getConfig().getBoolean("editable_voicemail_number_bool") ? new IccVmNotSupportedException("Update SIM voice mailbox error") : ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 25: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.mVoiceMailNum = this.mNewVoiceMailNum;
                        this.mVoiceMailTag = this.mNewVoiceMailTag;
                    } else {
                        this.log("Set CPHS MailBox with exception: " + ar.exception);
                    }
                    if (ar.userObj == null) return;
                    this.log("Callback with CPHS MB successful.");
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    return;
                }
                case 32: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.mEfCfis = null;
                        return;
                    }
                    this.log("EF_CFIS: " + IccUtils.bytesToHexString(data));
                    this.mEfCfis = data;
                    return;
                }
                case 33: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception in fetching EF_CSP data " + ar.exception);
                        return;
                    }
                    byte[] data = (byte[])ar.result;
                    this.log("EF_CSP: " + IccUtils.bytesToHexString(data));
                    this.handleEfCspData(data);
                    return;
                }
                case 34: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.loge("Exception in get GID1 " + ar.exception);
                        this.mGid1 = null;
                        return;
                    }
                    this.mGid1 = IccUtils.bytesToHexString(data);
                    this.log("GID1: " + this.mGid1);
                    return;
                }
                case 36: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        this.loge("Exception in get GID2 " + ar.exception);
                        this.mGid2 = null;
                        return;
                    }
                    this.mGid2 = IccUtils.bytesToHexString(data);
                    this.log("GID2: " + this.mGid2);
                    return;
                }
                case 37: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mPlmnActRecords = PlmnActRecord.getRecords(data);
                        return;
                    }
                    this.loge("Failed getting User PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 38: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mOplmnActRecords = PlmnActRecord.getRecords(data);
                        return;
                    }
                    this.loge("Failed getting Operator PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 39: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.log("Received a PlmnActRecord, raw=" + IccUtils.bytesToHexString(data));
                        this.mHplmnActRecords = PlmnActRecord.getRecords(data);
                        this.log("HplmnActRecord[]=" + Arrays.toString(this.mHplmnActRecords));
                        return;
                    }
                    this.loge("Failed getting Home PLMN with Access Tech Records: " + ar.exception);
                    return;
                }
                case 40: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception == null && data != null) {
                        this.mEhplmns = this.parseBcdPlmnList(data, "Equivalent Home");
                        return;
                    }
                    this.loge("Failed getting Equivalent Home PLMNs: " + ar.exception);
                    return;
                }
                case 41: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null || data == null) {
                        this.loge("Failed getting Forbidden PLMNs: " + ar.exception);
                        return;
                    }
                    this.mFplmns = this.parseBcdPlmnList(data, "Forbidden");
                    if (msg.arg1 != 1238273) return;
                    isRecordLoadResponse = false;
                    Message response = this.retrievePendingResponseMessage(msg.arg2);
                    if (response != null) {
                        AsyncResult.forMessage(response, Arrays.copyOf(this.mFplmns, this.mFplmns.length), null);
                        response.sendToTarget();
                        return;
                    }
                    this.loge("Failed to retrieve a response message for FPLMN");
                    return;
                }
            }
            super.handleMessage(msg);
            return;
        }
        catch (RuntimeException exc) {
            this.logw("Exception parsing SIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleFileUpdate(int efid) {
        switch (efid) {
            case 28615: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28615, 28616, this.mMailboxIndex, this.obtainMessage(6));
                break;
            }
            case 28439: {
                ++this.mRecordsToLoad;
                new AdnRecordLoader(this.mFh).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
                break;
            }
            case 28437: {
                ++this.mRecordsToLoad;
                this.log("[CSP] SIM Refresh for EF_CSP_CPHS");
                this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
                break;
            }
            case 28475: {
                this.log("SIM Refresh called for EF_FDN");
                this.mParentApp.queryFdn();
                this.mAdnCache.reset();
                break;
            }
            case 28480: {
                ++this.mRecordsToLoad;
                this.log("SIM Refresh called for EF_MSISDN");
                new AdnRecordLoader(this.mFh).loadFromEF(28480, this.getExtFromEf(28480), 1, this.obtainMessage(10));
                break;
            }
            case 28435: 
            case 28619: {
                this.log("SIM Refresh called for EF_CFIS or EF_CFF_CPHS");
                this.loadCallForwardingRecords();
                break;
            }
            default: {
                this.mAdnCache.reset();
                this.fetchSimRecords();
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispatchGsmMessage(SmsMessage message) {
        this.mNewSmsRegistrants.notifyResult(message);
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSms(byte[] ba) {
        if (ba[0] != 0) {
            Rlog.d("ENF", "status : " + ba[0]);
        }
        if (ba[0] == 3) {
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSmses(ArrayList<byte[]> messages) {
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 0) {
                Rlog.i("ENF", "status " + i + ": " + ba[0]);
            }
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] pdu = new byte[n - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])ba, (int)1, (byte[])pdu, (int)0, (int)(n - 1));
            SmsMessage message = SmsMessage.createFromPdu(pdu, "3gpp");
            this.dispatchGsmMessage(message);
            ba[0] = 1;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.getRecordsLoaded()) {
            this.onAllRecordsLoaded();
        } else if (this.getLockedRecordsLoaded() || this.getNetworkLockedRecordsLoaded()) {
            this.onLockedAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlagFromSimRecords() {
        if (this.validEfCfis(this.mEfCfis)) {
            this.mCallForwardingStatus = this.mEfCfis[1] & 1;
            this.log("EF_CFIS: callForwardingEnabled=" + this.mCallForwardingStatus);
        } else if (this.mEfCff != null) {
            this.mCallForwardingStatus = (this.mEfCff[0] & 0xF) == 10 ? 1 : 0;
            this.log("EF_CFF: callForwardingEnabled=" + this.mCallForwardingStatus);
        } else {
            this.mCallForwardingStatus = -1;
            this.log("EF_CFIS and EF_CFF not valid. callForwardingEnabled=" + this.mCallForwardingStatus);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSimLanguageFromEF() {
        Resources resource = Resources.getSystem();
        if (resource.getBoolean(17957067)) {
            this.setSimLanguage(this.mEfLi, this.mEfPl);
        } else {
            this.log("Not using EF LI/EF PL");
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLockedAllRecordsLoaded() {
        this.setSimLanguageFromEF();
        if (this.mLockedRecordsReqReason == 1) {
            this.mLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (this.mLockedRecordsReqReason == 2) {
            this.mNetworkLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else {
            this.loge("onLockedAllRecordsLoaded: unexpected mLockedRecordsReqReason " + this.mLockedRecordsReqReason);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onAllRecordsLoaded() {
        this.log("record load complete");
        this.setSimLanguageFromEF();
        this.setVoiceCallForwardingFlagFromSimRecords();
        String operator = this.getOperatorNumeric();
        if (!TextUtils.isEmpty(operator)) {
            this.log("onAllRecordsLoaded set 'gsm.sim.operator.numeric' to operator='" + operator + "'");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mParentApp.getPhoneId(), operator);
        } else {
            this.log("onAllRecordsLoaded empty 'gsm.sim.operator.numeric' skipping");
        }
        String imsi = this.getIMSI();
        if (!TextUtils.isEmpty(imsi) && imsi.length() >= 3) {
            this.log("onAllRecordsLoaded set mcc imsi" + "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mParentApp.getPhoneId(), MccTable.countryCodeForMcc(Integer.parseInt(imsi.substring(0, 3))));
        } else {
            this.log("onAllRecordsLoaded empty imsi skipping setting mcc");
        }
        this.setVoiceMailByCountry(operator);
        this.mLoaded.set(true);
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailByCountry(String spn) {
        if (this.mVmConfig.containsCarrier(spn)) {
            this.mIsVoiceMailFixed = true;
            this.mVoiceMailNum = this.mVmConfig.getVoiceMailNumber(spn);
            this.mVoiceMailTag = this.mVmConfig.getVoiceMailTag(spn);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$getForbiddenPlmns(Message response) {
        int key = this.storePendingResponseMessage(response);
        this.mFh.loadEFTransparent(28539, this.obtainMessage(41, 1238273, key));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onReady() {
        this.fetchSimRecords();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLocked(int msg) {
        this.log("only fetch EF_LI, EF_PL and EF_ICCID in locked state");
        this.mLockedRecordsReqReason = msg == 258 ? 1 : 2;
        this.loadEfLiAndEfPl();
        this.mFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.mRecordsToLoad;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadEfLiAndEfPl() {
        if (this.mParentApp.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            this.mFh.loadEFTransparent(28421, this.obtainMessage(100, new EfUsimLiLoaded(this, null)));
            ++this.mRecordsToLoad;
            this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded(this, null)));
            ++this.mRecordsToLoad;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadCallForwardingRecords() {
        this.mRecordsRequested = true;
        this.mFh.loadEFLinearFixed(28619, 1, this.obtainMessage(32));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28435, this.obtainMessage(24));
        ++this.mRecordsToLoad;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$fetchSimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchSimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(4));
        ++this.mRecordsToLoad;
        new AdnRecordLoader(this.mFh).loadFromEF(28480, this.getExtFromEf(28480), 1, this.obtainMessage(10));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28617, 1, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28589, this.obtainMessage(9));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28618, 1, this.obtainMessage(7));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28433, this.obtainMessage(8));
        ++this.mRecordsToLoad;
        this.loadCallForwardingRecords();
        this.getSpnFsm(true, null);
        this.mFh.loadEFTransparent(28621, this.obtainMessage(13));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28613, 1, this.obtainMessage(15));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28472, this.obtainMessage(17));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28438, this.obtainMessage(26));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28437, this.obtainMessage(33));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28478, this.obtainMessage(34));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28479, this.obtainMessage(36));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28512, this.obtainMessage(37));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28513, this.obtainMessage(38));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28514, this.obtainMessage(39));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28633, this.obtainMessage(40));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28539, this.obtainMessage(41, 1238272, -1));
        ++this.mRecordsToLoad;
        this.loadEfLiAndEfPl();
        this.log("fetchSimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_SIMRecords$getDisplayRule(ServiceState serviceState) {
        int rule;
        if (this.mParentApp != null && this.mParentApp.getUiccProfile() != null && this.mParentApp.getUiccProfile().getOperatorBrandOverride() != null) {
            rule = 2;
        } else if (TextUtils.isEmpty(this.getServiceProviderName()) || this.mSpnDisplayCondition == -1) {
            rule = 2;
        } else if (this.useRoamingFromServiceState() ? !serviceState.getRoaming() : this.isOnMatchingPlmn(serviceState.getOperatorNumeric())) {
            rule = 1;
            if ((this.mSpnDisplayCondition & 1) == 1) {
                rule |= 2;
            }
        } else {
            rule = 2;
            if ((this.mSpnDisplayCondition & 2) == 0) {
                rule |= 1;
            }
        }
        return rule;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$useRoamingFromServiceState() {
        PersistableBundle b;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        return configManager != null && (b = configManager.getConfigForSubId(SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mParentApp.getPhoneId()))) != null && b.getBoolean("spn_display_rule_use_roaming_from_service_state_bool");
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isOnMatchingPlmn(String plmn) {
        if (plmn == null) {
            return false;
        }
        if (plmn.equals(this.getOperatorNumeric())) {
            return true;
        }
        if (this.mSpdiNetworks != null) {
            for (String spdiNet : this.mSpdiNetworks) {
                if (!plmn.equals(spdiNet)) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$getSpnFsm(boolean start, AsyncResult ar) {
        if (start) {
            if (this.mSpnState == GetSpnFsmState.READ_SPN_3GPP || this.mSpnState == GetSpnFsmState.READ_SPN_CPHS || this.mSpnState == GetSpnFsmState.READ_SPN_SHORT_CPHS || this.mSpnState == GetSpnFsmState.INIT) {
                this.mSpnState = GetSpnFsmState.INIT;
                return;
            }
            this.mSpnState = GetSpnFsmState.INIT;
        }
        switch (1.$SwitchMap$com$android$internal$telephony$uicc$SIMRecords$GetSpnFsmState[this.mSpnState.ordinal()]) {
            case 1: {
                this.setServiceProviderName(null);
                this.mFh.loadEFTransparent(28486, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnState = GetSpnFsmState.READ_SPN_3GPP;
                break;
            }
            case 2: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.mSpnDisplayCondition = 0xFF & data[0];
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 1, data.length - 1));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.mSpnState = GetSpnFsmState.READ_SPN_CPHS;
                    } else {
                        this.log("Load EF_SPN: " + spn + " spnDisplayCondition: " + this.mSpnDisplayCondition);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                        this.mSpnState = GetSpnFsmState.IDLE;
                    }
                } else {
                    this.mSpnState = GetSpnFsmState.READ_SPN_CPHS;
                }
                if (this.mSpnState != GetSpnFsmState.READ_SPN_CPHS) break;
                this.mFh.loadEFTransparent(28436, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                this.mSpnDisplayCondition = -1;
                break;
            }
            case 3: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.mSpnState = GetSpnFsmState.READ_SPN_SHORT_CPHS;
                    } else {
                        this.mSpnDisplayCondition = 2;
                        this.log("Load EF_SPN_CPHS: " + spn);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                        this.mSpnState = GetSpnFsmState.IDLE;
                    }
                } else {
                    this.mSpnState = GetSpnFsmState.READ_SPN_SHORT_CPHS;
                }
                if (this.mSpnState != GetSpnFsmState.READ_SPN_SHORT_CPHS) break;
                this.mFh.loadEFTransparent(28440, this.obtainMessage(12));
                ++this.mRecordsToLoad;
                break;
            }
            case 4: {
                if (ar != null && ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.setServiceProviderName(IccUtils.adnStringFieldToString(data, 0, data.length));
                    String spn = this.getServiceProviderName();
                    if (spn == null || spn.length() == 0) {
                        this.log("No SPN loaded in either CHPS or 3GPP");
                    } else {
                        this.mSpnDisplayCondition = 2;
                        this.log("Load EF_SPN_SHORT_CPHS: " + spn);
                        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
                    }
                } else {
                    this.setServiceProviderName(null);
                    this.log("No SPN loaded in either CHPS or 3GPP");
                }
                this.mSpnState = GetSpnFsmState.IDLE;
                break;
            }
            default: {
                this.mSpnState = GetSpnFsmState.IDLE;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseEfSpdi(byte[] data) {
        SimTlv tlv = new SimTlv(data, 0, data.length);
        byte[] plmnEntries = null;
        while (tlv.isValidObject()) {
            if (tlv.getTag() == 163) {
                tlv = new SimTlv(tlv.getData(), 0, tlv.getData().length);
            }
            if (tlv.getTag() == 128) {
                plmnEntries = tlv.getData();
                break;
            }
            tlv.nextObject();
        }
        if (plmnEntries == null) {
            return;
        }
        this.mSpdiNetworks = new ArrayList(plmnEntries.length / 3);
        int i = 0;
        while (i + 2 < plmnEntries.length) {
            String plmnCode = IccUtils.bcdPlmnToString(plmnEntries, i);
            if (plmnCode != null && plmnCode.length() >= 5) {
                this.log("EF_SPDI network: " + plmnCode);
                this.mSpdiNetworks.add(plmnCode);
            }
            i += 3;
        }
    }

    private final String[] $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseBcdPlmnList(byte[] data, String description) {
        int packedBcdPlmnLenBytes = 3;
        this.log("Received " + description + " PLMNs, raw=" + IccUtils.bytesToHexString(data));
        if (data.length == 0 || data.length % 3 != 0) {
            this.loge("Received invalid " + description + " PLMN list");
            return null;
        }
        int numPlmns = data.length / 3;
        int numValidPlmns = 0;
        String[] parsed = new String[numPlmns];
        for (int i = 0; i < numPlmns; ++i) {
            parsed[numValidPlmns] = IccUtils.bcdPlmnToString(data, i * 3);
            if (TextUtils.isEmpty(parsed[numValidPlmns])) continue;
            ++numValidPlmns;
        }
        String[] ret = Arrays.copyOf(parsed, numValidPlmns);
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        return (this.mCphsInfo[1] & 0x30) == 48;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$log(String s) {
        Rlog.d("SIMRecords", "[SIMRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$loge(String s) {
        Rlog.e("SIMRecords", "[SIMRecords] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$logw(String s, Throwable tr) {
        Rlog.w("SIMRecords", "[SIMRecords] " + s, tr);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$logv(String s) {
        Rlog.v("SIMRecords", "[SIMRecords] " + s);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCspPlmnEnabled() {
        return this.mCspPlmnEnabled;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleEfCspData(byte[] data) {
        int usedCspGroups = data.length / 2;
        byte valueAddedServicesGroup = -64;
        this.mCspPlmnEnabled = true;
        for (int i = 0; i < usedCspGroups; ++i) {
            if (data[2 * i] != valueAddedServicesGroup) continue;
            this.log("[CSP] found ValueAddedServicesGroup, value " + data[2 * i + 1]);
            if ((data[2 * i + 1] & 0x80) == 128) {
                this.mCspPlmnEnabled = true;
            } else {
                this.mCspPlmnEnabled = false;
                this.log("[CSP] Set Automatic Network Selection");
                this.mNetworkSelectionModeAutomaticRegistrants.notifyRegistrants();
            }
            return;
        }
        this.log("[CSP] Value Added Service Group (0xC0), not found!");
    }

    private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SIMRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mVmConfig=" + this.mVmConfig);
        pw.println(" mCallForwardingStatus=" + this.mCallForwardingStatus);
        pw.println(" mSpnState=" + (Object)((Object)this.mSpnState));
        pw.println(" mCphsInfo=" + this.mCphsInfo);
        pw.println(" mCspPlmnEnabled=" + this.mCspPlmnEnabled);
        pw.println(" mEfMWIS[]=" + Arrays.toString(this.mEfMWIS));
        pw.println(" mEfCPHS_MWI[]=" + Arrays.toString(this.mEfCPHS_MWI));
        pw.println(" mEfCff[]=" + Arrays.toString(this.mEfCff));
        pw.println(" mEfCfis[]=" + Arrays.toString(this.mEfCfis));
        pw.println(" mSpnDisplayCondition=" + this.mSpnDisplayCondition);
        pw.println(" mSpdiNetworks[]=" + this.mSpdiNetworks);
        pw.println(" mUsimServiceTable=" + this.mUsimServiceTable);
        pw.println(" mGid1=" + this.mGid1);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeGid1=" + this.mCarrierTestOverride.getFakeGid1());
        }
        pw.println(" mGid2=" + this.mGid2);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeGid2=" + this.mCarrierTestOverride.getFakeGid2());
        }
        pw.println(" mPnnHomeName=" + this.mPnnHomeName);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakePnnHomeName=" + this.mCarrierTestOverride.getFakePnnHomeName());
        }
        pw.println(" mPlmnActRecords[]=" + Arrays.toString(this.mPlmnActRecords));
        pw.println(" mOplmnActRecords[]=" + Arrays.toString(this.mOplmnActRecords));
        pw.println(" mHplmnActRecords[]=" + Arrays.toString(this.mHplmnActRecords));
        pw.println(" mFplmns[]=" + Arrays.toString(this.mFplmns));
        pw.println(" mEhplmns[]=" + Arrays.toString(this.mEhplmns));
        pw.flush();
    }

    static void __staticInitializer__() {
        MCCMNC_CODES_HAVING_3DIGITS_MNC = new String[]{"302370", "302720", "310260", "405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405854", "405855", "405856", "405857", "405858", "405859", "405860", "405861", "405862", "405863", "405864", "405865", "405866", "405867", "405868", "405869", "405870", "405871", "405872", "405873", "405874", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405912", "405913", "405914", "405915", "405916", "405917", "405918", "405919", "405920", "405921", "405922", "405923", "405924", "405925", "405926", "405927", "405928", "405929", "405930", "405931", "405932", "502142", "502143", "502145", "502146", "502147", "502148"};
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_SIMRecords$toString(), this);
    }

    private void __constructor__(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(uiccCardApplication, context, commandsInterface);
    }

    public SIMRecords(UiccCardApplication uiccCardApplication, Context context, CommandsInterface commandsInterface) {
        super(uiccCardApplication, context, commandsInterface);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords$__constructor__(com.android.internal.telephony.uicc.UiccCardApplication android.content.Context com.android.internal.telephony.CommandsInterface ), this, uiccCardApplication, context, commandsInterface);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispose(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_uicc_SIMRecords$finalize(), this);
    }

    protected void resetRecords() {
        InvokeDynamicSupport.bootstrap("resetRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$resetRecords(), this);
    }

    @Override
    public String getMsisdnNumber() {
        return InvokeDynamicSupport.bootstrap("getMsisdnNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnNumber(), this);
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        return InvokeDynamicSupport.bootstrap("getUsimServiceTable", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getUsimServiceTable(), this);
    }

    private int getExtFromEf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getExtFromEf", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getExtFromEf(int ), this, n);
    }

    @Override
    public void setMsisdnNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setMsisdnNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setMsisdnNumber(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public String getMsisdnAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getMsisdnAlphaTag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getMsisdnAlphaTag(), this);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailNumber(), this);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), this, string2, string3, message);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMailAlphaTag(), this);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMessageWaiting(int int ), this, n, n2);
    }

    private boolean validEfCfis(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("validEfCfis", $$robo$$com_android_internal_telephony_uicc_SIMRecords$validEfCfis(byte[] ), this, byArray);
    }

    @Override
    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceMessageCount(), this);
    }

    @Override
    public int getVoiceCallForwardingFlag() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getVoiceCallForwardingFlag(), this);
    }

    @Override
    public void setVoiceCallForwardingFlag(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlag(int boolean java.lang.String ), this, n, bl, string2);
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onRefresh", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRefresh(boolean int[] ), this, bl, nArray);
    }

    @Override
    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getOperatorNumeric(), this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleMessage(android.os.Message ), this, message);
    }

    @Override
    protected void handleFileUpdate(int n) {
        InvokeDynamicSupport.bootstrap("handleFileUpdate", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleFileUpdate(int ), this, n);
    }

    private int dispatchGsmMessage(SmsMessage smsMessage) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchGsmMessage", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dispatchGsmMessage(android.telephony.SmsMessage ), this, smsMessage);
    }

    private void handleSms(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("handleSms", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSms(byte[] ), this, byArray);
    }

    private void handleSmses(ArrayList<byte[]> arrayList) {
        InvokeDynamicSupport.bootstrap("handleSmses", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleSmses(java.util.ArrayList<byte[]> ), this, arrayList);
    }

    @Override
    protected void onRecordLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onRecordLoaded(), this);
    }

    private void setVoiceCallForwardingFlagFromSimRecords() {
        InvokeDynamicSupport.bootstrap("setVoiceCallForwardingFlagFromSimRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceCallForwardingFlagFromSimRecords(), this);
    }

    private void setSimLanguageFromEF() {
        InvokeDynamicSupport.bootstrap("setSimLanguageFromEF", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setSimLanguageFromEF(), this);
    }

    private void onLockedAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onLockedAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLockedAllRecordsLoaded(), this);
    }

    @Override
    protected void onAllRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onAllRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onAllRecordsLoaded(), this);
    }

    private void setVoiceMailByCountry(String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceMailByCountry", $$robo$$com_android_internal_telephony_uicc_SIMRecords$setVoiceMailByCountry(java.lang.String ), this, string2);
    }

    public void getForbiddenPlmns(Message message) {
        InvokeDynamicSupport.bootstrap("getForbiddenPlmns", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getForbiddenPlmns(android.os.Message ), this, message);
    }

    @Override
    public void onReady() {
        InvokeDynamicSupport.bootstrap("onReady", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onReady(), this);
    }

    private void onLocked(int n) {
        InvokeDynamicSupport.bootstrap("onLocked", $$robo$$com_android_internal_telephony_uicc_SIMRecords$onLocked(int ), this, n);
    }

    private void loadEfLiAndEfPl() {
        InvokeDynamicSupport.bootstrap("loadEfLiAndEfPl", $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadEfLiAndEfPl(), this);
    }

    private void loadCallForwardingRecords() {
        InvokeDynamicSupport.bootstrap("loadCallForwardingRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$loadCallForwardingRecords(), this);
    }

    protected void fetchSimRecords() {
        InvokeDynamicSupport.bootstrap("fetchSimRecords", $$robo$$com_android_internal_telephony_uicc_SIMRecords$fetchSimRecords(), this);
    }

    @Override
    public int getDisplayRule(ServiceState serviceState) {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayRule", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getDisplayRule(android.telephony.ServiceState ), this, serviceState);
    }

    private boolean useRoamingFromServiceState() {
        return (boolean)InvokeDynamicSupport.bootstrap("useRoamingFromServiceState", $$robo$$com_android_internal_telephony_uicc_SIMRecords$useRoamingFromServiceState(), this);
    }

    private boolean isOnMatchingPlmn(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnMatchingPlmn", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isOnMatchingPlmn(java.lang.String ), this, string2);
    }

    private void getSpnFsm(boolean bl, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("getSpnFsm", $$robo$$com_android_internal_telephony_uicc_SIMRecords$getSpnFsm(boolean android.os.AsyncResult ), this, bl, asyncResult);
    }

    private void parseEfSpdi(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parseEfSpdi", $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseEfSpdi(byte[] ), this, byArray);
    }

    private String[] parseBcdPlmnList(byte[] byArray, String string2) {
        return InvokeDynamicSupport.bootstrap("parseBcdPlmnList", $$robo$$com_android_internal_telephony_uicc_SIMRecords$parseBcdPlmnList(byte[] java.lang.String ), this, byArray, string2);
    }

    private boolean isCphsMailboxEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCphsMailboxEnabled", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCphsMailboxEnabled(), this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_SIMRecords$log(java.lang.String ), this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_SIMRecords$loge(java.lang.String ), this, string2);
    }

    protected void logw(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_telephony_uicc_SIMRecords$logw(java.lang.String java.lang.Throwable ), this, string2, throwable);
    }

    protected void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_uicc_SIMRecords$logv(java.lang.String ), this, string2);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_uicc_SIMRecords$isCspPlmnEnabled(), this);
    }

    private void handleEfCspData(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("handleEfCspData", $$robo$$com_android_internal_telephony_uicc_SIMRecords$handleEfCspData(byte[] ), this, byArray);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_SIMRecords$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SIMRecords.class);
    }

    public /* synthetic */ SIMRecords() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SIMRecords)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class GetSpnFsmState
    extends Enum<GetSpnFsmState> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ GetSpnFsmState IDLE;
        public static /* enum */ GetSpnFsmState INIT;
        public static /* enum */ GetSpnFsmState READ_SPN_3GPP;
        public static /* enum */ GetSpnFsmState READ_SPN_CPHS;
        public static /* enum */ GetSpnFsmState READ_SPN_SHORT_CPHS;
        private static /* synthetic */ GetSpnFsmState[] $VALUES;

        private static final GetSpnFsmState[] $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$values() {
            return (GetSpnFsmState[])$VALUES.clone();
        }

        private static final GetSpnFsmState $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$valueOf(String name) {
            return Enum.valueOf(GetSpnFsmState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            IDLE = new GetSpnFsmState();
            INIT = new GetSpnFsmState();
            READ_SPN_3GPP = new GetSpnFsmState();
            READ_SPN_CPHS = new GetSpnFsmState();
            READ_SPN_SHORT_CPHS = new GetSpnFsmState();
            $VALUES = new GetSpnFsmState[]{IDLE, INIT, READ_SPN_3GPP, READ_SPN_CPHS, READ_SPN_SHORT_CPHS};
        }

        public static GetSpnFsmState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$values());
        }

        public static GetSpnFsmState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(string2, n);
        }

        public GetSpnFsmState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_GetSpnFsmState$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(GetSpnFsmState.class);
        }

        public /* synthetic */ GetSpnFsmState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetSpnFsmState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfUsimLiLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ SIMRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(SIMRecords sIMRecords) {
            this.this$0 = sIMRecords;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$getEfName() {
            return "EF_LI";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.mEfLi = (byte[])ar.result;
            this.this$0.log("EF_LI=" + IccUtils.bytesToHexString(this.this$0.mEfLi));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(SIMRecords x0, 1 x1) {
        }

        private void __constructor__(SIMRecords sIMRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(sIMRecords);
        }

        public EfUsimLiLoaded(SIMRecords sIMRecords) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords ), this, sIMRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(SIMRecords sIMRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(sIMRecords, var2_2);
        }

        public /* synthetic */ EfUsimLiLoaded(SIMRecords sIMRecords, 1 var2_2) {
            this(sIMRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfUsimLiLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords com.android.internal.telephony.uicc.SIMRecords$1 ), this, sIMRecords, var2_2);
        }

        public /* synthetic */ EfUsimLiLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfUsimLiLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ SIMRecords this$0;

        private void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(SIMRecords sIMRecords) {
            this.this$0 = sIMRecords;
        }

        private final String $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$getEfName() {
            return "EF_PL";
        }

        private final void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$onRecordLoaded(AsyncResult ar) {
            this.this$0.mEfPl = (byte[])ar.result;
            this.this$0.log("EF_PL=" + IccUtils.bytesToHexString(this.this$0.mEfPl));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(SIMRecords x0, 1 x1) {
        }

        private void __constructor__(SIMRecords sIMRecords) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(sIMRecords);
        }

        public EfPlLoaded(SIMRecords sIMRecords) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords ), this, sIMRecords);
        }

        @Override
        public String getEfName() {
            return InvokeDynamicSupport.bootstrap("getEfName", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$getEfName(), this);
        }

        @Override
        public void onRecordLoaded(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("onRecordLoaded", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$onRecordLoaded(android.os.AsyncResult ), this, asyncResult);
        }

        private /* synthetic */ void __constructor__(SIMRecords sIMRecords, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(sIMRecords, var2_2);
        }

        public /* synthetic */ EfPlLoaded(SIMRecords sIMRecords, 1 var2_2) {
            this(sIMRecords);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_SIMRecords_EfPlLoaded$__constructor__(com.android.internal.telephony.uicc.SIMRecords com.android.internal.telephony.uicc.SIMRecords$1 ), this, sIMRecords, var2_2);
        }

        public /* synthetic */ EfPlLoaded() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EfPlLoaded)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

