/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.euicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Registrant;
import android.os.RegistrantList;
import android.service.carrier.CarrierIdentifier;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.asn1.Asn1Decoder;
import com.android.internal.telephony.uicc.asn1.Asn1Node;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;
import com.android.internal.telephony.uicc.asn1.TagNotFoundException;
import com.android.internal.telephony.uicc.euicc.EuiccCardErrorException;
import com.android.internal.telephony.uicc.euicc.EuiccCardException;
import com.android.internal.telephony.uicc.euicc.EuiccSpecVersion;
import com.android.internal.telephony.uicc.euicc.Tags;
import com.android.internal.telephony.uicc.euicc.apdu.ApduException;
import com.android.internal.telephony.uicc.euicc.apdu.ApduSender;
import com.android.internal.telephony.uicc.euicc.apdu.RequestBuilder;
import com.android.internal.telephony.uicc.euicc.apdu.RequestProvider;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultHelper;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EuiccCard
extends UiccCard
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "EuiccCard";
    private static boolean DBG = true;
    private static String ISD_R_AID = "A0000005591010FFFFFFFF8900000100";
    private static int ICCID_LENGTH = 20;
    private static int APDU_ERROR_SIM_REFRESH = 28416;
    private static int CODE_OK = 0;
    private static int CODE_PROFILE_NOT_IN_EXPECTED_STATE = 2;
    private static int CODE_NOTHING_TO_DELETE = 1;
    private static int CODE_NO_RESULT_AVAILABLE = 1;
    private static EuiccSpecVersion SGP_2_0;
    private static String DEV_CAP_GSM = "gsm";
    private static String DEV_CAP_UTRAN = "utran";
    private static String DEV_CAP_CDMA_1X = "cdma1x";
    private static String DEV_CAP_HRPD = "hrpd";
    private static String DEV_CAP_EHRPD = "ehrpd";
    private static String DEV_CAP_EUTRAN = "eutran";
    private static String DEV_CAP_NFC = "nfc";
    private static String DEV_CAP_CRL = "crl";
    private ApduSender mApduSender;
    private Object mLock;
    private RegistrantList mEidReadyRegistrants;
    private EuiccSpecVersion mSpecVersion;
    private volatile String mEid;

    private void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$__constructor__(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, Object lock) {
        this.mLock = new Object();
        this.mApduSender = new ApduSender(ci, "A0000005591010FFFFFFFF8900000100", false);
        this.loadEidAndNotifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$registerForEidReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        if (this.mEid != null) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        } else {
            if (this.mEidReadyRegistrants == null) {
                this.mEidReadyRegistrants = new RegistrantList();
            }
            this.mEidReadyRegistrants.add(r);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$unregisterForEidReady(Handler h) {
        if (this.mEidReadyRegistrants != null) {
            this.mEidReadyRegistrants.remove(h);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loadEidAndNotifyRegistrants() {
        Handler euiccMainThreadHandler = new Handler();
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ EuiccCard this$0;

            private void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$__constructor__(EuiccCard this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$onResult(String result) {
                if (this.this$0.mEidReadyRegistrants != null) {
                    this.this$0.mEidReadyRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                }
            }

            private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$onException(Throwable e) {
                if (this.this$0.mEidReadyRegistrants != null) {
                    this.this$0.mEidReadyRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                }
                this.this$0.mEid = "";
                this.this$0.mCardId = "";
                Rlog.e("EuiccCard", "Failed loading eid", e);
            }

            private void __constructor__(EuiccCard euiccCard) {
                this.$$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$__constructor__(euiccCard);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$__constructor__(com.android.internal.telephony.uicc.euicc.EuiccCard ), this, euiccCard);
            }

            @Override
            public void onResult(String string2) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$onResult(java.lang.String ), this, string2);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_1$onException(java.lang.Throwable ), this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.getEid(cardCb, euiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getSpecVersion(AsyncResultCallback<EuiccSpecVersion> callback, Handler handler) {
        if (this.mSpecVersion != null) {
            AsyncResultHelper.returnResult(this.mSpecVersion, callback, handler);
            return;
        }
        this.sendApdu(this.newRequestProvider(requestBuilder -> {}), response -> this.mSpecVersion, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$updateCardId() {
        if (TextUtils.isEmpty(this.mEid)) {
            super.updateCardId();
        } else {
            this.mCardId = this.mEid;
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getAllProfiles(AsyncResultCallback<EuiccProfileInfo[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48941).addChildAsBytes(92, Tags.EUICC_PROFILE_TAGS).build().toHex())), response -> {
            List<Asn1Node> profileNodes = new Asn1Decoder(response).nextNode().getChild(160, new int[0]).getChildren(227);
            int size = profileNodes.size();
            EuiccProfileInfo[] profiles = new EuiccProfileInfo[size];
            int profileCount = 0;
            for (int i = 0; i < size; ++i) {
                Asn1Node profileNode = profileNodes.get(i);
                if (!profileNode.hasChild(90, new int[0])) {
                    EuiccCard.loge("Profile must have an ICCID.");
                    continue;
                }
                String strippedIccIdString = EuiccCard.stripTrailingFs(profileNode.getChild(90, new int[0]).asBytes());
                EuiccProfileInfo.Builder profileBuilder = new EuiccProfileInfo.Builder(strippedIccIdString);
                EuiccCard.buildProfile(profileNode, profileBuilder);
                EuiccProfileInfo profile = profileBuilder.build();
                profiles[profileCount++] = profile;
            }
            return profiles;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getProfile(String iccid, AsyncResultCallback<EuiccProfileInfo> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48941).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid))).build()).addChildAsBytes(92, Tags.EUICC_PROFILE_TAGS).build().toHex())), response -> {
            List<Asn1Node> profileNodes = new Asn1Decoder(response).nextNode().getChild(160, new int[0]).getChildren(227);
            if (profileNodes.isEmpty()) {
                return null;
            }
            Asn1Node profileNode = profileNodes.get(0);
            String strippedIccIdString = EuiccCard.stripTrailingFs(profileNode.getChild(90, new int[0]).asBytes());
            EuiccProfileInfo.Builder profileBuilder = new EuiccProfileInfo.Builder(strippedIccIdString);
            EuiccCard.buildProfile(profileNode, profileBuilder);
            return profileBuilder.build();
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$disableProfile(String iccid, boolean refresh, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48946).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, iccidBytes)).addChildAsBoolean(129, refresh).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            switch (result) {
                case 0: {
                    return null;
                }
                case 2: {
                    EuiccCard.logd("Profile is already disabled, iccid: " + SubscriptionInfo.givePrintableIccid(iccid));
                    return null;
                }
            }
            throw new EuiccCardErrorException(11, result);
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$switchToProfile(String iccid, boolean refresh, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48945).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, iccidBytes)).addChildAsBoolean(129, refresh).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            switch (result) {
                case 0: {
                    return null;
                }
                case 2: {
                    EuiccCard.logd("Profile is already enabled, iccid: " + SubscriptionInfo.givePrintableIccid(iccid));
                    return null;
                }
            }
            throw new EuiccCardErrorException(10, result);
        }, callback, handler);
    }

    private final String $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEid() {
        return this.mEid;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEid(AsyncResultCallback<String> callback, Handler handler) {
        if (this.mEid != null) {
            AsyncResultHelper.returnResult(this.mEid, callback, handler);
            return;
        }
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48958).addChildAsBytes(92, new byte[]{90}).build().toHex())), response -> {
            String eid = IccUtils.bytesToHexString(EuiccCard.parseResponse(response).getChild(90, new int[0]).asBytes());
            Object object = this.mLock;
            synchronized (object) {
                this.mEid = eid;
                this.mCardId = eid;
            }
            return eid;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$setNickname(String iccid, String nickname, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48937).addChildAsBytes(90, IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid))).addChildAsString(144, nickname).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(7, result);
            }
            return null;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$deleteProfile(String iccid, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48947).addChildAsBytes(90, iccidBytes).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(12, result);
            }
            return null;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$resetMemory(int options, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48948).addChildAsBits(130, options).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0 && result != 1) {
                throw new EuiccCardErrorException(13, result);
            }
            return null;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getDefaultSmdpAddress(AsyncResultCallback<String> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48956).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(128, new int[0]).asString(), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getSmdsAddress(AsyncResultCallback<String> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48956).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(129, new int[0]).asString(), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$setDefaultSmdpAddress(String defaultSmdpAddress, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48959).addChildAsString(128, defaultSmdpAddress).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(14, result);
            }
            return null;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getRulesAuthTable(AsyncResultCallback<EuiccRulesAuthTable> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48963).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            List<Asn1Node> nodes = root.getChildren(160);
            EuiccRulesAuthTable.Builder builder = new EuiccRulesAuthTable.Builder(nodes.size());
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Asn1Node node = nodes.get(i);
                List<Asn1Node> opIdNodes = node.getChild(161, new int[0]).getChildren();
                int opIdSize = opIdNodes.size();
                CarrierIdentifier[] opIds = new CarrierIdentifier[opIdSize];
                for (int j = 0; j < opIdSize; ++j) {
                    opIds[j] = EuiccCard.buildCarrierIdentifier(opIdNodes.get(j));
                }
                builder.add(node.getChild(128, new int[0]).asBits(), Arrays.asList(opIds), node.getChild(130, new int[0]).asBits());
            }
            return builder.build();
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccChallenge(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48942).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(128, new int[0]).asBytes(), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccInfo1(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48928).build().toHex())), response -> response, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccInfo2(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48930).build().toHex())), response -> response, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$authenticateServer(String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            byte[] imeiBytes = this.getDeviceId();
            byte[] tacBytes = new byte[4];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])imeiBytes, (int)0, (byte[])tacBytes, (int)0, (int)4);
            Asn1Node.Builder devCapsBuilder = Asn1Node.newBuilder(161);
            String[] devCapsStrings = this.getResources().getStringArray(17236041);
            if (devCapsStrings != null) {
                for (String devCapItem : devCapsStrings) {
                    this.addDeviceCapability(devCapsBuilder, devCapItem);
                }
            } else {
                EuiccCard.logd("No device capabilities set.");
            }
            Asn1Node.Builder ctxParams1Builder = Asn1Node.newBuilder(160).addChildAsString(128, matchingId).addChild(Asn1Node.newBuilder(161).addChildAsBytes(128, tacBytes).addChild(devCapsBuilder).addChildAsBytes(130, imeiBytes));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48952).addChild(new Asn1Decoder(serverSigned1).nextNode()).addChild(new Asn1Decoder(serverSignature1).nextNode()).addChild(new Asn1Decoder(euiccCiPkIdToBeUsed).nextNode()).addChild(new Asn1Decoder(serverCertificate).nextNode()).addChild(ctxParams1Builder).build().toHex());
        }), response -> EuiccCard.parseResponseAndCheckSimpleError(response, 3).toBytes(), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$prepareDownload(byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            Asn1Node.Builder builder = Asn1Node.newBuilder(48929).addChild(new Asn1Decoder(smdpSigned2).nextNode()).addChild(new Asn1Decoder(smdpSignature2).nextNode());
            if (hashCc != null) {
                builder.addChildAsBytes(4, hashCc);
            }
            requestBuilder.addStoreData(builder.addChild(new Asn1Decoder(smdpCertificate).nextNode()).build().toHex());
        }), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(161, 2)) {
                throw new EuiccCardErrorException(2, root.getChild(161, 2).asInteger());
            }
            return root.toBytes();
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loadBoundProfilePackage(byte[] boundProfilePackage, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            int i;
            Asn1Node bppNode = new Asn1Decoder(boundProfilePackage).nextNode();
            Asn1Node initialiseSecureChannelRequest = bppNode.getChild(48931, new int[0]);
            Asn1Node firstSequenceOf87 = bppNode.getChild(160, new int[0]);
            Asn1Node sequenceOf88 = bppNode.getChild(161, new int[0]);
            List<Asn1Node> metaDataSeqs = sequenceOf88.getChildren(136);
            Asn1Node sequenceOf86 = bppNode.getChild(163, new int[0]);
            List<Asn1Node> elementSeqs = sequenceOf86.getChildren(134);
            requestBuilder.addStoreData(bppNode.getHeadAsHex() + initialiseSecureChannelRequest.toHex());
            requestBuilder.addStoreData(firstSequenceOf87.toHex());
            requestBuilder.addStoreData(sequenceOf88.getHeadAsHex());
            int size = metaDataSeqs.size();
            for (i = 0; i < size; ++i) {
                requestBuilder.addStoreData(metaDataSeqs.get(i).toHex());
            }
            if (bppNode.hasChild(162, new int[0])) {
                requestBuilder.addStoreData(bppNode.getChild(162, new int[0]).toHex());
            }
            requestBuilder.addStoreData(sequenceOf86.getHeadAsHex());
            size = elementSeqs.size();
            for (i = 0; i < size; ++i) {
                requestBuilder.addStoreData(elementSeqs.get(i).toHex());
            }
        }), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(48935, 162, 161, 129)) {
                Asn1Node errorNode = root.getChild(48935, 162, 161, 129);
                throw new EuiccCardErrorException(5, errorNode.asInteger(), errorNode);
            }
            return root.toBytes();
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$cancelSession(byte[] transactionId, int reason, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48961).addChildAsBytes(128, transactionId).addChildAsInteger(129, reason).build().toHex())), response -> EuiccCard.parseResponseAndCheckSimpleError(response, 4).toBytes(), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$listNotifications(int events, AsyncResultCallback<EuiccNotification[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48936).addChildAsBits(129, events).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponseAndCheckSimpleError(response, 6);
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            EuiccNotification[] notifications = new EuiccNotification[nodes.size()];
            for (int i = 0; i < notifications.length; ++i) {
                notifications[i] = EuiccCard.createNotification(nodes.get(i));
            }
            return notifications;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$retrieveNotificationList(int events, AsyncResultCallback<EuiccNotification[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48939).addChild(Asn1Node.newBuilder(160).addChildAsBits(129, events)).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(129, new int[0])) {
                int error = root.getChild(129, new int[0]).asInteger();
                switch (error) {
                    case 1: {
                        return new EuiccNotification[0];
                    }
                }
                throw new EuiccCardErrorException(8, error);
            }
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            EuiccNotification[] notifications = new EuiccNotification[nodes.size()];
            for (int i = 0; i < notifications.length; ++i) {
                notifications[i] = EuiccCard.createNotification(nodes.get(i));
            }
            return notifications;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$retrieveNotification(int seqNumber, AsyncResultCallback<EuiccNotification> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48939).addChild(Asn1Node.newBuilder(160).addChildAsInteger(128, seqNumber)).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponseAndCheckSimpleError(response, 8);
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            if (nodes.size() > 0) {
                return EuiccCard.createNotification(nodes.get(0));
            }
            return null;
        }, callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$removeNotificationFromList(int seqNumber, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48944).addChildAsInteger(128, seqNumber).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0 && result != 1) {
                throw new EuiccCardErrorException(9, result);
            }
            return null;
        }, callback, handler);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$addDeviceCapability(Asn1Node.Builder devCapBuilder, String devCapItem) {
        Integer version;
        Object[] split = devCapItem.split(",");
        if (split.length != 2) {
            EuiccCard.loge("Invalid device capability item: " + Arrays.toString(split));
            return;
        }
        String devCap = split[0].trim();
        try {
            version = Integer.parseInt(((String)split[1]).trim());
        }
        catch (NumberFormatException e) {
            EuiccCard.loge("Invalid device capability version number.", e);
            return;
        }
        byte[] versionBytes = new byte[]{version.byteValue(), 0, 0};
        switch (devCap) {
            case "gsm": {
                devCapBuilder.addChildAsBytes(128, versionBytes);
                break;
            }
            case "utran": {
                devCapBuilder.addChildAsBytes(129, versionBytes);
                break;
            }
            case "cdma1x": {
                devCapBuilder.addChildAsBytes(130, versionBytes);
                break;
            }
            case "hrpd": {
                devCapBuilder.addChildAsBytes(131, versionBytes);
                break;
            }
            case "ehrpd": {
                devCapBuilder.addChildAsBytes(132, versionBytes);
                break;
            }
            case "eutran": {
                devCapBuilder.addChildAsBytes(133, versionBytes);
                break;
            }
            case "nfc": {
                devCapBuilder.addChildAsBytes(134, versionBytes);
                break;
            }
            case "crl": {
                devCapBuilder.addChildAsBytes(135, versionBytes);
                break;
            }
            default: {
                EuiccCard.loge("Invalid device capability name: " + devCap);
            }
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final byte[] $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getDeviceId() {
        byte[] imeiBytes = new byte[8];
        Phone phone = PhoneFactory.getPhone(this.getPhoneId());
        if (phone != null) {
            IccUtils.bcdToBytes(phone.getDeviceId(), imeiBytes);
        }
        return imeiBytes;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final Resources $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getResources() {
        return Resources.getSystem();
    }

    private final RequestProvider $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$newRequestProvider(ApduRequestBuilder builder) {
        return (selectResponse, requestBuilder) -> {
            EuiccSpecVersion ver = this.getOrExtractSpecVersion(selectResponse);
            if (ver == null) {
                throw new EuiccCardException("Cannot get eUICC spec version.");
            }
            try {
                if (ver.compareTo(SGP_2_0) < 0) {
                    throw new EuiccCardException("eUICC spec version is unsupported: " + ver);
                }
                builder.build(requestBuilder);
            }
            catch (InvalidAsn1DataException | TagNotFoundException e) {
                throw new EuiccCardException("Cannot parse ASN1 to build request.", e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EuiccSpecVersion $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getOrExtractSpecVersion(byte[] selectResponse) {
        if (this.mSpecVersion != null) {
            return this.mSpecVersion;
        }
        EuiccSpecVersion ver = EuiccSpecVersion.fromOpenChannelResponse(selectResponse);
        if (ver != null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSpecVersion == null) {
                    this.mSpecVersion = ver;
                }
            }
        }
        return ver;
    }

    private final <T> void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApdu(RequestProvider requestBuilder, ApduResponseHandler<T> responseHandler, AsyncResultCallback<T> callback, Handler handler) {
        this.sendApdu(requestBuilder, responseHandler, e -> callback.onException(new EuiccCardException("Cannot send APDU.", e)), callback, handler);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApduWithSimResetErrorWorkaround(RequestProvider requestBuilder, ApduResponseHandler<Void> responseHandler, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(requestBuilder, responseHandler, e -> {
            if (e instanceof ApduException && ((ApduException)e).getApduStatus() == 28416) {
                EuiccCard.logi("Sim is refreshed after disabling profile, no response got.");
                callback.onResult(null);
            } else {
                callback.onException(new EuiccCardException("Cannot send APDU.", e));
            }
        }, callback, handler);
    }

    private final <T> void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApdu(RequestProvider requestBuilder, ApduResponseHandler<T> responseHandler, ApduExceptionHandler exceptionHandler, AsyncResultCallback<T> callback, Handler handler) {
        this.mApduSender.send(requestBuilder, new AsyncResultCallback<byte[]>(this, callback, responseHandler, exceptionHandler){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AsyncResultCallback val$callback;
            /* synthetic */ ApduResponseHandler val$responseHandler;
            /* synthetic */ ApduExceptionHandler val$exceptionHandler;
            /* synthetic */ EuiccCard this$0;

            private void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$__constructor__(EuiccCard this$0, AsyncResultCallback asyncResultCallback, ApduResponseHandler apduResponseHandler, ApduExceptionHandler apduExceptionHandler) {
                this.this$0 = this$0;
                this.val$callback = asyncResultCallback;
                this.val$responseHandler = apduResponseHandler;
                this.val$exceptionHandler = apduExceptionHandler;
            }

            private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$onResult(byte[] response) {
                try {
                    this.val$callback.onResult(this.val$responseHandler.handleResult(response));
                }
                catch (EuiccCardException e) {
                    this.val$callback.onException(e);
                }
                catch (InvalidAsn1DataException | TagNotFoundException e) {
                    this.val$callback.onException(new EuiccCardException("Cannot parse response: " + IccUtils.bytesToHexString(response), e));
                }
            }

            private final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$onException(Throwable e) {
                this.val$exceptionHandler.handleException(e);
            }

            private void __constructor__(EuiccCard euiccCard, AsyncResultCallback asyncResultCallback, ApduResponseHandler apduResponseHandler, ApduExceptionHandler apduExceptionHandler) {
                this.$$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$__constructor__(euiccCard, asyncResultCallback, apduResponseHandler, apduExceptionHandler);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$__constructor__(com.android.internal.telephony.uicc.euicc.EuiccCard com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback com.android.internal.telephony.uicc.euicc.EuiccCard$ApduResponseHandler com.android.internal.telephony.uicc.euicc.EuiccCard$ApduExceptionHandler ), this, euiccCard, asyncResultCallback, apduResponseHandler, apduExceptionHandler);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$onResult(byte[] ), this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard_2$onException(java.lang.Throwable ), this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, handler);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildProfile(Asn1Node profileNode, EuiccProfileInfo.Builder profileBuilder) throws TagNotFoundException, InvalidAsn1DataException {
        if (profileNode.hasChild(144, new int[0])) {
            profileBuilder.setNickname(profileNode.getChild(144, new int[0]).asString());
        }
        if (profileNode.hasChild(145, new int[0])) {
            profileBuilder.setServiceProviderName(profileNode.getChild(145, new int[0]).asString());
        }
        if (profileNode.hasChild(146, new int[0])) {
            profileBuilder.setProfileName(profileNode.getChild(146, new int[0]).asString());
        }
        if (profileNode.hasChild(183, new int[0])) {
            profileBuilder.setCarrierIdentifier(EuiccCard.buildCarrierIdentifier(profileNode.getChild(183, new int[0])));
        }
        if (profileNode.hasChild(40816, new int[0])) {
            profileBuilder.setState(profileNode.getChild(40816, new int[0]).asInteger());
        } else {
            profileBuilder.setState(0);
        }
        if (profileNode.hasChild(149, new int[0])) {
            profileBuilder.setProfileClass(profileNode.getChild(149, new int[0]).asInteger());
        } else {
            profileBuilder.setProfileClass(2);
        }
        if (profileNode.hasChild(153, new int[0])) {
            profileBuilder.setPolicyRules(profileNode.getChild(153, new int[0]).asBits());
        }
        if (profileNode.hasChild(49014, new int[0])) {
            List<Asn1Node> refArDoNodes = profileNode.getChild(49014, new int[0]).getChildren(226);
            UiccAccessRule[] rules = EuiccCard.buildUiccAccessRule(refArDoNodes);
            List<UiccAccessRule> rulesList = null;
            if (rules != null) {
                rulesList = Arrays.asList(rules);
            }
            profileBuilder.setUiccAccessRule(rulesList);
        }
    }

    private static final CarrierIdentifier $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildCarrierIdentifier(Asn1Node node) throws InvalidAsn1DataException, TagNotFoundException {
        String gid1 = null;
        if (node.hasChild(129, new int[0])) {
            gid1 = IccUtils.bytesToHexString(node.getChild(129, new int[0]).asBytes());
        }
        String gid2 = null;
        if (node.hasChild(130, new int[0])) {
            gid2 = IccUtils.bytesToHexString(node.getChild(130, new int[0]).asBytes());
        }
        return new CarrierIdentifier(node.getChild(128, new int[0]).asBytes(), gid1, gid2);
    }

    private static final UiccAccessRule[] $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildUiccAccessRule(List<Asn1Node> nodes) throws InvalidAsn1DataException, TagNotFoundException {
        if (nodes.isEmpty()) {
            return null;
        }
        int count = nodes.size();
        UiccAccessRule[] rules = new UiccAccessRule[count];
        for (int i = 0; i < count; ++i) {
            Asn1Node node = nodes.get(i);
            Asn1Node refDoNode = node.getChild(225, new int[0]);
            byte[] signature = refDoNode.getChild(193, new int[0]).asBytes();
            String packageName = null;
            if (refDoNode.hasChild(202, new int[0])) {
                packageName = refDoNode.getChild(202, new int[0]).asString();
            }
            long accessType = 0L;
            if (node.hasChild(227, 219)) {
                Asn1Node permArDoNode = node.getChild(227, 219);
                accessType = permArDoNode.asRawLong();
            }
            rules[i] = new UiccAccessRule(signature, packageName, accessType);
        }
        return rules;
    }

    private static final EuiccNotification $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$createNotification(Asn1Node node) throws TagNotFoundException, InvalidAsn1DataException {
        Asn1Node metadataNode = node.getTag() == 48943 ? node : (node.getTag() == 48951 ? node.getChild(48935, 48943) : node.getChild(48943, new int[0]));
        return new EuiccNotification(metadataNode.getChild(128, new int[0]).asInteger(), metadataNode.getChild(12, new int[0]).asString(), metadataNode.getChild(129, new int[0]).asBits(), node.getTag() == 48943 ? null : node.toBytes());
    }

    private static final int $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseSimpleResult(byte[] response) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException {
        return EuiccCard.parseResponse(response).getChild(128, new int[0]).asInteger();
    }

    private static final Asn1Node $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseResponse(byte[] response) throws EuiccCardException, InvalidAsn1DataException {
        Asn1Decoder decoder = new Asn1Decoder(response);
        if (!decoder.hasNextNode()) {
            throw new EuiccCardException("Empty response", null);
        }
        return decoder.nextNode();
    }

    private static final Asn1Node $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseResponseAndCheckSimpleError(byte[] response, int opCode) throws EuiccCardException, InvalidAsn1DataException, TagNotFoundException {
        Asn1Node root = EuiccCard.parseResponse(response);
        if (root.hasChild(129, new int[0])) {
            throw new EuiccCardErrorException(opCode, root.getChild(129, new int[0]).asInteger());
        }
        return root;
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$stripTrailingFs(byte[] iccId) {
        return IccUtils.stripTrailingFs(IccUtils.bchToString(iccId, 0, iccId.length));
    }

    private static final String $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$padTrailingFs(String iccId) {
        if (!TextUtils.isEmpty(iccId) && iccId.length() < 20) {
            iccId = iccId + new String(new char[20 - iccId.length()]).replace('\u0000', 'F');
        }
        return iccId;
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loge(String message) {
        Rlog.e("EuiccCard", message);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loge(String message, Throwable tr) {
        Rlog.e("EuiccCard", message, tr);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$logi(String message) {
        Rlog.i("EuiccCard", message);
    }

    private static final void $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$logd(String message) {
        Rlog.d("EuiccCard", message);
    }

    static void __staticInitializer__() {
        SGP_2_0 = new EuiccSpecVersion(2, 0, 0);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n, Object object) {
        this.$$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$__constructor__(context, commandsInterface, iccCardStatus, n, object);
    }

    public EuiccCard(Context context, CommandsInterface commandsInterface, IccCardStatus iccCardStatus, int n, Object object) {
        super(context, commandsInterface, iccCardStatus, n, object);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.uicc.IccCardStatus int java.lang.Object ), this, context, commandsInterface, iccCardStatus, n, object);
    }

    public void registerForEidReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEidReady", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$registerForEidReady(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    public void unregisterForEidReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEidReady", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$unregisterForEidReady(android.os.Handler ), this, handler);
    }

    protected void loadEidAndNotifyRegistrants() {
        InvokeDynamicSupport.bootstrap("loadEidAndNotifyRegistrants", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loadEidAndNotifyRegistrants(), this);
    }

    public void getSpecVersion(AsyncResultCallback<EuiccSpecVersion> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getSpecVersion", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getSpecVersion(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<com.android.internal.telephony.uicc.euicc.EuiccSpecVersion> android.os.Handler ), this, asyncResultCallback, handler);
    }

    @Override
    protected void updateCardId() {
        InvokeDynamicSupport.bootstrap("updateCardId", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$updateCardId(), this);
    }

    public void getAllProfiles(AsyncResultCallback<EuiccProfileInfo[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getAllProfiles", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getAllProfiles(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.service.euicc.EuiccProfileInfo[]> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void getProfile(String string2, AsyncResultCallback<EuiccProfileInfo> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getProfile", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getProfile(java.lang.String com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.service.euicc.EuiccProfileInfo> android.os.Handler ), this, string2, asyncResultCallback, handler);
    }

    public void disableProfile(String string2, boolean bl, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("disableProfile", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$disableProfile(java.lang.String boolean com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, string2, bl, asyncResultCallback, handler);
    }

    public void switchToProfile(String string2, boolean bl, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("switchToProfile", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$switchToProfile(java.lang.String boolean com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, string2, bl, asyncResultCallback, handler);
    }

    public String getEid() {
        return InvokeDynamicSupport.bootstrap("getEid", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEid(), this);
    }

    public void getEid(AsyncResultCallback<String> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getEid", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEid(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.String> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void setNickname(String string2, String string3, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setNickname", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$setNickname(java.lang.String java.lang.String com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, string2, string3, asyncResultCallback, handler);
    }

    public void deleteProfile(String string2, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("deleteProfile", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$deleteProfile(java.lang.String com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, string2, asyncResultCallback, handler);
    }

    public void resetMemory(int n, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("resetMemory", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$resetMemory(int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, n, asyncResultCallback, handler);
    }

    public void getDefaultSmdpAddress(AsyncResultCallback<String> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getDefaultSmdpAddress", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getDefaultSmdpAddress(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.String> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void getSmdsAddress(AsyncResultCallback<String> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getSmdsAddress", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getSmdsAddress(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.String> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void setDefaultSmdpAddress(String string2, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setDefaultSmdpAddress", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$setDefaultSmdpAddress(java.lang.String com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, string2, asyncResultCallback, handler);
    }

    public void getRulesAuthTable(AsyncResultCallback<EuiccRulesAuthTable> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getRulesAuthTable", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getRulesAuthTable(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.telephony.euicc.EuiccRulesAuthTable> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void getEuiccChallenge(AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getEuiccChallenge", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccChallenge(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void getEuiccInfo1(AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getEuiccInfo1", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccInfo1(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void getEuiccInfo2(AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("getEuiccInfo2", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getEuiccInfo2(com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, asyncResultCallback, handler);
    }

    public void authenticateServer(String string2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("authenticateServer", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$authenticateServer(java.lang.String byte[] byte[] byte[] byte[] com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, string2, byArray, byArray2, byArray3, byArray4, asyncResultCallback, handler);
    }

    public void prepareDownload(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("prepareDownload", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$prepareDownload(byte[] byte[] byte[] byte[] com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, byArray, byArray2, byArray3, byArray4, asyncResultCallback, handler);
    }

    public void loadBoundProfilePackage(byte[] byArray, AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("loadBoundProfilePackage", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loadBoundProfilePackage(byte[] com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, byArray, asyncResultCallback, handler);
    }

    public void cancelSession(byte[] byArray, int n, AsyncResultCallback<byte[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("cancelSession", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$cancelSession(byte[] int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<byte[]> android.os.Handler ), this, byArray, n, asyncResultCallback, handler);
    }

    public void listNotifications(int n, AsyncResultCallback<EuiccNotification[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("listNotifications", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$listNotifications(int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.telephony.euicc.EuiccNotification[]> android.os.Handler ), this, n, asyncResultCallback, handler);
    }

    public void retrieveNotificationList(int n, AsyncResultCallback<EuiccNotification[]> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("retrieveNotificationList", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$retrieveNotificationList(int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.telephony.euicc.EuiccNotification[]> android.os.Handler ), this, n, asyncResultCallback, handler);
    }

    public void retrieveNotification(int n, AsyncResultCallback<EuiccNotification> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("retrieveNotification", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$retrieveNotification(int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<android.telephony.euicc.EuiccNotification> android.os.Handler ), this, n, asyncResultCallback, handler);
    }

    public void removeNotificationFromList(int n, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("removeNotificationFromList", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$removeNotificationFromList(int com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, n, asyncResultCallback, handler);
    }

    public void addDeviceCapability(Asn1Node.Builder builder, String string2) {
        InvokeDynamicSupport.bootstrap("addDeviceCapability", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$addDeviceCapability(com.android.internal.telephony.uicc.asn1.Asn1Node$Builder java.lang.String ), this, builder, string2);
    }

    protected byte[] getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getDeviceId(), this);
    }

    protected Resources getResources() {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getResources(), this);
    }

    private RequestProvider newRequestProvider(ApduRequestBuilder apduRequestBuilder) {
        return InvokeDynamicSupport.bootstrap("newRequestProvider", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$newRequestProvider(com.android.internal.telephony.uicc.euicc.EuiccCard$ApduRequestBuilder ), this, apduRequestBuilder);
    }

    private EuiccSpecVersion getOrExtractSpecVersion(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getOrExtractSpecVersion", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$getOrExtractSpecVersion(byte[] ), this, byArray);
    }

    private <T> void sendApdu(RequestProvider requestProvider, ApduResponseHandler<T> apduResponseHandler, AsyncResultCallback<T> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("sendApdu", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApdu(com.android.internal.telephony.uicc.euicc.apdu.RequestProvider com.android.internal.telephony.uicc.euicc.EuiccCard$ApduResponseHandler<T> com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<T> android.os.Handler ), this, requestProvider, apduResponseHandler, asyncResultCallback, handler);
    }

    private void sendApduWithSimResetErrorWorkaround(RequestProvider requestProvider, ApduResponseHandler<Void> apduResponseHandler, AsyncResultCallback<Void> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("sendApduWithSimResetErrorWorkaround", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApduWithSimResetErrorWorkaround(com.android.internal.telephony.uicc.euicc.apdu.RequestProvider com.android.internal.telephony.uicc.euicc.EuiccCard$ApduResponseHandler<java.lang.Void> com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<java.lang.Void> android.os.Handler ), this, requestProvider, apduResponseHandler, asyncResultCallback, handler);
    }

    private <T> void sendApdu(RequestProvider requestProvider, ApduResponseHandler<T> apduResponseHandler, ApduExceptionHandler apduExceptionHandler, AsyncResultCallback<T> asyncResultCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("sendApdu", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$sendApdu(com.android.internal.telephony.uicc.euicc.apdu.RequestProvider com.android.internal.telephony.uicc.euicc.EuiccCard$ApduResponseHandler<T> com.android.internal.telephony.uicc.euicc.EuiccCard$ApduExceptionHandler com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback<T> android.os.Handler ), this, requestProvider, apduResponseHandler, apduExceptionHandler, asyncResultCallback, handler);
    }

    private static void buildProfile(Asn1Node asn1Node, EuiccProfileInfo.Builder builder) throws TagNotFoundException, InvalidAsn1DataException {
        InvokeDynamicSupport.bootstrapStatic("buildProfile", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildProfile(com.android.internal.telephony.uicc.asn1.Asn1Node android.service.euicc.EuiccProfileInfo$Builder ), (Asn1Node)asn1Node, (EuiccProfileInfo.Builder)builder);
    }

    private static CarrierIdentifier buildCarrierIdentifier(Asn1Node asn1Node) throws InvalidAsn1DataException, TagNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("buildCarrierIdentifier", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildCarrierIdentifier(com.android.internal.telephony.uicc.asn1.Asn1Node ), (Asn1Node)asn1Node);
    }

    private static UiccAccessRule[] buildUiccAccessRule(List<Asn1Node> list) throws InvalidAsn1DataException, TagNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("buildUiccAccessRule", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$buildUiccAccessRule(java.util.List<com.android.internal.telephony.uicc.asn1.Asn1Node> ), list);
    }

    private static EuiccNotification createNotification(Asn1Node asn1Node) throws TagNotFoundException, InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrapStatic("createNotification", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$createNotification(com.android.internal.telephony.uicc.asn1.Asn1Node ), (Asn1Node)asn1Node);
    }

    private static int parseSimpleResult(byte[] byArray) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseSimpleResult", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseSimpleResult(byte[] ), (byte[])byArray);
    }

    private static Asn1Node parseResponse(byte[] byArray) throws EuiccCardException, InvalidAsn1DataException {
        return InvokeDynamicSupport.bootstrapStatic("parseResponse", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseResponse(byte[] ), (byte[])byArray);
    }

    private static Asn1Node parseResponseAndCheckSimpleError(byte[] byArray, int n) throws EuiccCardException, InvalidAsn1DataException, TagNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("parseResponseAndCheckSimpleError", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$parseResponseAndCheckSimpleError(byte[] int ), (byte[])byArray, (int)n);
    }

    private static String stripTrailingFs(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("stripTrailingFs", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$stripTrailingFs(byte[] ), (byte[])byArray);
    }

    private static String padTrailingFs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("padTrailingFs", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$padTrailingFs(java.lang.String ), (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loge(java.lang.String ), (String)string2);
    }

    private static void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$loge(java.lang.String java.lang.Throwable ), (String)string2, (Throwable)throwable);
    }

    private static void logi(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logi", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$logi(java.lang.String ), (String)string2);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_uicc_euicc_EuiccCard$logd(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(EuiccCard.class);
    }

    public /* synthetic */ EuiccCard() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccCard)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface ApduExceptionHandler {
        public void handleException(Throwable var1);
    }

    private static interface ApduResponseHandler<T> {
        public T handleResult(byte[] var1) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException;
    }

    private static interface ApduRequestBuilder {
        public void build(RequestBuilder var1) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException;
    }
}

