/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlSerializer;

public class FastXmlSerializer
implements XmlSerializer,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String[] ESCAPE_TABLE;
    private static int DEFAULT_BUFFER_LEN = 32768;
    private static String sSpace;
    private int mBufferLen;
    private char[] mText;
    private int mPos;
    private Writer mWriter;
    private OutputStream mOutputStream;
    private CharsetEncoder mCharset;
    private ByteBuffer mBytes;
    private boolean mIndent;
    private boolean mInTag;
    private int mNesting;
    private boolean mLineStart;

    private void $$robo$$com_android_internal_util_FastXmlSerializer$__constructor__() {
    }

    private void $$robo$$com_android_internal_util_FastXmlSerializer$__constructor__(int bufferSize) {
        this.mIndent = false;
        this.mNesting = 0;
        this.mLineStart = true;
        this.mBufferLen = bufferSize > 0 ? bufferSize : 32768;
        this.mText = new char[this.mBufferLen];
        this.mBytes = ByteBuffer.allocate(this.mBufferLen);
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$append(char c) throws IOException {
        int pos = this.mPos;
        if (pos >= this.mBufferLen - 1) {
            this.flush();
            pos = this.mPos;
        }
        this.mText[pos] = c;
        this.mPos = pos + 1;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$append(String str, int i, int length) throws IOException {
        if (length > this.mBufferLen) {
            int end = i + length;
            while (i < end) {
                int next = i + this.mBufferLen;
                this.append(str, i, next < end ? this.mBufferLen : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > this.mBufferLen) {
            this.flush();
            pos = this.mPos;
        }
        str.getChars(i, i + length, this.mText, pos);
        this.mPos = pos + length;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$append(char[] buf, int i, int length) throws IOException {
        if (length > this.mBufferLen) {
            int end = i + length;
            while (i < end) {
                int next = i + this.mBufferLen;
                this.append(buf, i, next < end ? this.mBufferLen : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > this.mBufferLen) {
            this.flush();
            pos = this.mPos;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)buf, (int)i, (Object)this.mText, (int)pos, (int)length);
        this.mPos = pos + length;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$append(String str) throws IOException {
        this.append(str, 0, str.length());
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$appendIndent(int indent) throws IOException {
        if ((indent *= 4) > sSpace.length()) {
            indent = sSpace.length();
        }
        this.append(sSpace, 0, indent);
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$escapeAndAppendString(String string2) throws IOException {
        int pos;
        int N = string2.length();
        char NE = (char)ESCAPE_TABLE.length;
        String[] escapes = ESCAPE_TABLE;
        int lastPos = 0;
        for (pos = 0; pos < N; ++pos) {
            String escape;
            char c = string2.charAt(pos);
            if (c >= NE || (escape = escapes[c]) == null) continue;
            if (lastPos < pos) {
                this.append(string2, lastPos, pos - lastPos);
            }
            lastPos = pos + 1;
            this.append(escape);
        }
        if (lastPos < pos) {
            this.append(string2, lastPos, pos - lastPos);
        }
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$escapeAndAppendString(char[] buf, int start, int len) throws IOException {
        int pos;
        char NE = (char)ESCAPE_TABLE.length;
        String[] escapes = ESCAPE_TABLE;
        int end = start + len;
        int lastPos = start;
        for (pos = start; pos < end; ++pos) {
            String escape;
            char c = buf[pos];
            if (c >= NE || (escape = escapes[c]) == null) continue;
            if (lastPos < pos) {
                this.append(buf, lastPos, pos - lastPos);
            }
            lastPos = pos + 1;
            this.append(escape);
        }
        if (lastPos < pos) {
            this.append(buf, lastPos, pos - lastPos);
        }
    }

    private final XmlSerializer $$robo$$com_android_internal_util_FastXmlSerializer$attribute(String namespace, String name, String value) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append(' ');
        if (namespace != null) {
            this.append(namespace);
            this.append(':');
        }
        this.append(name);
        this.append("=\"");
        this.escapeAndAppendString(value);
        this.append('\"');
        this.mLineStart = false;
        return this;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$cdsect(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$comment(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$docdecl(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.flush();
    }

    private final XmlSerializer $$robo$$com_android_internal_util_FastXmlSerializer$endTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        --this.mNesting;
        if (this.mInTag) {
            this.append(" />\n");
        } else {
            if (this.mIndent && this.mLineStart) {
                this.appendIndent(this.mNesting);
            }
            this.append("</");
            if (namespace != null) {
                this.append(namespace);
                this.append(':');
            }
            this.append(name);
            this.append(">\n");
        }
        this.mLineStart = true;
        this.mInTag = false;
        return this;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$entityRef(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$flushBytes() throws IOException {
        int position = this.mBytes.position();
        if (position > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, position);
            this.mBytes.clear();
        }
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$flush() throws IOException {
        if (this.mPos > 0) {
            if (this.mOutputStream != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult result = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (true) {
                    if (result.isError()) {
                        throw new IOException(result.toString());
                    }
                    if (!result.isOverflow()) break;
                    this.flushBytes();
                    result = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                this.flushBytes();
                this.mOutputStream.flush();
            } else {
                this.mWriter.write(this.mText, 0, this.mPos);
                this.mWriter.flush();
            }
            this.mPos = 0;
        }
    }

    private final int $$robo$$com_android_internal_util_FastXmlSerializer$getDepth() {
        throw new UnsupportedOperationException();
    }

    private final boolean $$robo$$com_android_internal_util_FastXmlSerializer$getFeature(String name) {
        throw new UnsupportedOperationException();
    }

    private final String $$robo$$com_android_internal_util_FastXmlSerializer$getName() {
        throw new UnsupportedOperationException();
    }

    private final String $$robo$$com_android_internal_util_FastXmlSerializer$getNamespace() {
        throw new UnsupportedOperationException();
    }

    private final String $$robo$$com_android_internal_util_FastXmlSerializer$getPrefix(String namespace, boolean generatePrefix) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    private final Object $$robo$$com_android_internal_util_FastXmlSerializer$getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$ignorableWhitespace(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$processingInstruction(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
        if (name.equals("http://xmlpull.org/v1/doc/features.html#indent-output")) {
            this.mIndent = true;
            return;
        }
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$setOutput(OutputStream os, String encoding) throws IOException, IllegalArgumentException, IllegalStateException {
        if (os == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mCharset = Charset.forName(encoding).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (IllegalCharsetNameException e) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(encoding).initCause(e);
        }
        catch (UnsupportedCharsetException e) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(encoding).initCause(e);
        }
        this.mOutputStream = os;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mWriter = writer;
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$setPrefix(String prefix, String namespace) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$com_android_internal_util_FastXmlSerializer$startDocument(String encoding, Boolean standalone) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append("<?xml version='1.0' encoding='utf-8' standalone='" + (standalone != false ? "yes" : "no") + "' ?>\n");
        this.mLineStart = true;
    }

    private final XmlSerializer $$robo$$com_android_internal_util_FastXmlSerializer$startTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">\n");
        }
        if (this.mIndent) {
            this.appendIndent(this.mNesting);
        }
        ++this.mNesting;
        this.append('<');
        if (namespace != null) {
            this.append(namespace);
            this.append(':');
        }
        this.append(name);
        this.mInTag = true;
        this.mLineStart = false;
        return this;
    }

    private final XmlSerializer $$robo$$com_android_internal_util_FastXmlSerializer$text(char[] buf, int start, int len) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(buf, start, len);
        if (this.mIndent) {
            this.mLineStart = buf[start + len - 1] == '\n';
        }
        return this;
    }

    private final XmlSerializer $$robo$$com_android_internal_util_FastXmlSerializer$text(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(text);
        if (this.mIndent) {
            this.mLineStart = text.length() > 0 && text.charAt(text.length() - 1) == '\n';
        }
        return this;
    }

    static void __staticInitializer__() {
        ESCAPE_TABLE = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;", null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
        sSpace = "                                                              ";
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_FastXmlSerializer$__constructor__();
    }

    public FastXmlSerializer() {
        this(32768);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastXmlSerializer$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_util_FastXmlSerializer$__constructor__(n);
    }

    public FastXmlSerializer(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FastXmlSerializer$__constructor__(int ), this, n);
    }

    private void append(char c) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_FastXmlSerializer$append(char ), this, c);
    }

    private void append(String string2, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_FastXmlSerializer$append(java.lang.String int int ), this, string2, n, n2);
    }

    private void append(char[] cArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_FastXmlSerializer$append(char[] int int ), this, cArray, n, n2);
    }

    private void append(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("append", $$robo$$com_android_internal_util_FastXmlSerializer$append(java.lang.String ), this, string2);
    }

    private void appendIndent(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("appendIndent", $$robo$$com_android_internal_util_FastXmlSerializer$appendIndent(int ), this, n);
    }

    private void escapeAndAppendString(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("escapeAndAppendString", $$robo$$com_android_internal_util_FastXmlSerializer$escapeAndAppendString(java.lang.String ), this, string2);
    }

    private void escapeAndAppendString(char[] cArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("escapeAndAppendString", $$robo$$com_android_internal_util_FastXmlSerializer$escapeAndAppendString(char[] int int ), this, cArray, n, n2);
    }

    @Override
    public XmlSerializer attribute(String string2, String string3, String string4) throws IOException, IllegalArgumentException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("attribute", $$robo$$com_android_internal_util_FastXmlSerializer$attribute(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    @Override
    public void cdsect(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("cdsect", $$robo$$com_android_internal_util_FastXmlSerializer$cdsect(java.lang.String ), this, string2);
    }

    @Override
    public void comment(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("comment", $$robo$$com_android_internal_util_FastXmlSerializer$comment(java.lang.String ), this, string2);
    }

    @Override
    public void docdecl(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("docdecl", $$robo$$com_android_internal_util_FastXmlSerializer$docdecl(java.lang.String ), this, string2);
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("endDocument", $$robo$$com_android_internal_util_FastXmlSerializer$endDocument(), this);
    }

    @Override
    public XmlSerializer endTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("endTag", $$robo$$com_android_internal_util_FastXmlSerializer$endTag(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void entityRef(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("entityRef", $$robo$$com_android_internal_util_FastXmlSerializer$entityRef(java.lang.String ), this, string2);
    }

    private void flushBytes() throws IOException {
        InvokeDynamicSupport.bootstrap("flushBytes", $$robo$$com_android_internal_util_FastXmlSerializer$flushBytes(), this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_util_FastXmlSerializer$flush(), this);
    }

    @Override
    public int getDepth() {
        return (int)InvokeDynamicSupport.bootstrap("getDepth", $$robo$$com_android_internal_util_FastXmlSerializer$getDepth(), this);
    }

    @Override
    public boolean getFeature(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFeature", $$robo$$com_android_internal_util_FastXmlSerializer$getFeature(java.lang.String ), this, string2);
    }

    @Override
    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$com_android_internal_util_FastXmlSerializer$getName(), this);
    }

    @Override
    public String getNamespace() {
        return InvokeDynamicSupport.bootstrap("getNamespace", $$robo$$com_android_internal_util_FastXmlSerializer$getNamespace(), this);
    }

    @Override
    public String getPrefix(String string2, boolean bl) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("getPrefix", $$robo$$com_android_internal_util_FastXmlSerializer$getPrefix(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public Object getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$com_android_internal_util_FastXmlSerializer$getProperty(java.lang.String ), this, string2);
    }

    @Override
    public void ignorableWhitespace(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("ignorableWhitespace", $$robo$$com_android_internal_util_FastXmlSerializer$ignorableWhitespace(java.lang.String ), this, string2);
    }

    @Override
    public void processingInstruction(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("processingInstruction", $$robo$$com_android_internal_util_FastXmlSerializer$processingInstruction(java.lang.String ), this, string2);
    }

    @Override
    public void setFeature(String string2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setFeature", $$robo$$com_android_internal_util_FastXmlSerializer$setFeature(java.lang.String boolean ), this, string2, bl);
    }

    @Override
    public void setOutput(OutputStream outputStream, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setOutput", $$robo$$com_android_internal_util_FastXmlSerializer$setOutput(java.io.OutputStream java.lang.String ), this, outputStream, string2);
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setOutput", $$robo$$com_android_internal_util_FastXmlSerializer$setOutput(java.io.Writer ), this, writer);
    }

    @Override
    public void setPrefix(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setPrefix", $$robo$$com_android_internal_util_FastXmlSerializer$setPrefix(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void setProperty(String string2, Object object) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setProperty", $$robo$$com_android_internal_util_FastXmlSerializer$setProperty(java.lang.String java.lang.Object ), this, string2, object);
    }

    @Override
    public void startDocument(String string2, Boolean bl) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("startDocument", $$robo$$com_android_internal_util_FastXmlSerializer$startDocument(java.lang.String java.lang.Boolean ), this, string2, bl);
    }

    @Override
    public XmlSerializer startTag(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("startTag", $$robo$$com_android_internal_util_FastXmlSerializer$startTag(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException, IllegalArgumentException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("text", $$robo$$com_android_internal_util_FastXmlSerializer$text(char[] int int ), this, cArray, n, n2);
    }

    @Override
    public XmlSerializer text(String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("text", $$robo$$com_android_internal_util_FastXmlSerializer$text(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(FastXmlSerializer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FastXmlSerializer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

