/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util.function.pooled;

import android.os.Message;
import com.android.internal.util.function.HexConsumer;
import com.android.internal.util.function.HexFunction;
import com.android.internal.util.function.QuadConsumer;
import com.android.internal.util.function.QuadFunction;
import com.android.internal.util.function.QuintConsumer;
import com.android.internal.util.function.QuintFunction;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.util.function.TriFunction;
import com.android.internal.util.function.pooled.ArgumentPlaceholder;
import com.android.internal.util.function.pooled.PooledConsumer;
import com.android.internal.util.function.pooled.PooledFunction;
import com.android.internal.util.function.pooled.PooledLambdaImpl;
import com.android.internal.util.function.pooled.PooledPredicate;
import com.android.internal.util.function.pooled.PooledRunnable;
import com.android.internal.util.function.pooled.PooledSupplier;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface PooledLambda {
    public void recycle();

    public PooledLambda recycleOnUse();

    public static <R> ArgumentPlaceholder<R> __() {
        return ArgumentPlaceholder.INSTANCE;
    }

    public static <R> ArgumentPlaceholder<R> __(Class<R> typeHint) {
        return PooledLambda.__();
    }

    public static <R> PooledSupplier<R> obtainSupplier(R value) {
        PooledLambdaImpl r = PooledLambdaImpl.acquireConstSupplier(3);
        r.mFunc = value;
        return r;
    }

    public static PooledSupplier.OfInt obtainSupplier(int value) {
        PooledLambdaImpl r = PooledLambdaImpl.acquireConstSupplier(4);
        r.mConstValue = value;
        return r;
    }

    public static PooledSupplier.OfLong obtainSupplier(long value) {
        PooledLambdaImpl r = PooledLambdaImpl.acquireConstSupplier(5);
        r.mConstValue = value;
        return r;
    }

    public static PooledSupplier.OfDouble obtainSupplier(double value) {
        PooledLambdaImpl r = PooledLambdaImpl.acquireConstSupplier(6);
        r.mConstValue = Double.doubleToRawLongBits(value);
        return r;
    }

    public static <A> PooledRunnable obtainRunnable(Consumer<? super A> function, A arg1) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 1, 0, 1, arg1, null, null, null, null, null);
    }

    public static <A> PooledSupplier<Boolean> obtainSupplier(Predicate<? super A> function, A arg1) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 1, 0, 2, arg1, null, null, null, null, null);
    }

    public static <A, R> PooledSupplier<R> obtainSupplier(Function<? super A, ? extends R> function, A arg1) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 1, 0, 3, arg1, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A> Message obtainMessage(Consumer<? super A> function, A arg1) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 1, 0, 1, arg1, null, null, null, null, null);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }

    public static <A, B> PooledRunnable obtainRunnable(BiConsumer<? super A, ? super B> function, A arg1, B arg2) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 0, 1, arg1, arg2, null, null, null, null);
    }

    public static <A, B> PooledSupplier<Boolean> obtainSupplier(BiPredicate<? super A, ? super B> function, A arg1, B arg2) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 0, 2, arg1, arg2, null, null, null, null);
    }

    public static <A, B, R> PooledSupplier<R> obtainSupplier(BiFunction<? super A, ? super B, ? extends R> function, A arg1, B arg2) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 0, 3, arg1, arg2, null, null, null, null);
    }

    public static <A, B> PooledConsumer<A> obtainConsumer(BiConsumer<? super A, ? super B> function, ArgumentPlaceholder<A> arg1, B arg2) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 1, arg1, arg2, null, null, null, null);
    }

    public static <A, B> PooledPredicate<A> obtainPredicate(BiPredicate<? super A, ? super B> function, ArgumentPlaceholder<A> arg1, B arg2) {
        return (PooledPredicate)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 2, arg1, arg2, null, null, null, null);
    }

    public static <A, B, R> PooledFunction<A, R> obtainFunction(BiFunction<? super A, ? super B, ? extends R> function, ArgumentPlaceholder<A> arg1, B arg2) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 3, arg1, arg2, null, null, null, null);
    }

    public static <A, B> PooledConsumer<B> obtainConsumer(BiConsumer<? super A, ? super B> function, A arg1, ArgumentPlaceholder<B> arg2) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 1, arg1, arg2, null, null, null, null);
    }

    public static <A, B> PooledPredicate<B> obtainPredicate(BiPredicate<? super A, ? super B> function, A arg1, ArgumentPlaceholder<B> arg2) {
        return (PooledPredicate)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 2, arg1, arg2, null, null, null, null);
    }

    public static <A, B, R> PooledFunction<B, R> obtainFunction(BiFunction<? super A, ? super B, ? extends R> function, A arg1, ArgumentPlaceholder<B> arg2) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 2, 1, 3, arg1, arg2, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B> Message obtainMessage(BiConsumer<? super A, ? super B> function, A arg1, B arg2) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 2, 0, 1, arg1, arg2, null, null, null, null);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }

    public static <A, B, C> PooledRunnable obtainRunnable(TriConsumer<? super A, ? super B, ? super C> function, A arg1, B arg2, C arg3) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 0, 1, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C, R> PooledSupplier<R> obtainSupplier(TriFunction<? super A, ? super B, ? super C, ? extends R> function, A arg1, B arg2, C arg3) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 0, 3, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C> PooledConsumer<A> obtainConsumer(TriConsumer<? super A, ? super B, ? super C> function, ArgumentPlaceholder<A> arg1, B arg2, C arg3) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 1, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C, R> PooledFunction<A, R> obtainFunction(TriFunction<? super A, ? super B, ? super C, ? extends R> function, ArgumentPlaceholder<A> arg1, B arg2, C arg3) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 3, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C> PooledConsumer<B> obtainConsumer(TriConsumer<? super A, ? super B, ? super C> function, A arg1, ArgumentPlaceholder<B> arg2, C arg3) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 1, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C, R> PooledFunction<B, R> obtainFunction(TriFunction<? super A, ? super B, ? super C, ? extends R> function, A arg1, ArgumentPlaceholder<B> arg2, C arg3) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 3, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C> PooledConsumer<C> obtainConsumer(TriConsumer<? super A, ? super B, ? super C> function, A arg1, B arg2, ArgumentPlaceholder<C> arg3) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 1, arg1, arg2, arg3, null, null, null);
    }

    public static <A, B, C, R> PooledFunction<C, R> obtainFunction(TriFunction<? super A, ? super B, ? super C, ? extends R> function, A arg1, B arg2, ArgumentPlaceholder<C> arg3) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 3, 1, 3, arg1, arg2, arg3, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B, C> Message obtainMessage(TriConsumer<? super A, ? super B, ? super C> function, A arg1, B arg2, C arg3) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 3, 0, 1, arg1, arg2, arg3, null, null, null);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }

    public static <A, B, C, D> PooledRunnable obtainRunnable(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, A arg1, B arg2, C arg3, D arg4) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 0, 1, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D, R> PooledSupplier<R> obtainSupplier(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends R> function, A arg1, B arg2, C arg3, D arg4) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 0, 3, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D> PooledConsumer<A> obtainConsumer(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, ArgumentPlaceholder<A> arg1, B arg2, C arg3, D arg4) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 1, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D, R> PooledFunction<A, R> obtainFunction(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends R> function, ArgumentPlaceholder<A> arg1, B arg2, C arg3, D arg4) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 3, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D> PooledConsumer<B> obtainConsumer(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, A arg1, ArgumentPlaceholder<B> arg2, C arg3, D arg4) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 1, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D, R> PooledFunction<B, R> obtainFunction(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends R> function, A arg1, ArgumentPlaceholder<B> arg2, C arg3, D arg4) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 3, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D> PooledConsumer<C> obtainConsumer(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, A arg1, B arg2, ArgumentPlaceholder<C> arg3, D arg4) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 1, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D, R> PooledFunction<C, R> obtainFunction(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends R> function, A arg1, B arg2, ArgumentPlaceholder<C> arg3, D arg4) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 3, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D> PooledConsumer<D> obtainConsumer(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, A arg1, B arg2, C arg3, ArgumentPlaceholder<D> arg4) {
        return (PooledConsumer)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 1, arg1, arg2, arg3, arg4, null, null);
    }

    public static <A, B, C, D, R> PooledFunction<D, R> obtainFunction(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends R> function, A arg1, B arg2, C arg3, ArgumentPlaceholder<D> arg4) {
        return (PooledFunction)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 4, 1, 3, arg1, arg2, arg3, arg4, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B, C, D> Message obtainMessage(QuadConsumer<? super A, ? super B, ? super C, ? super D> function, A arg1, B arg2, C arg3, D arg4) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 4, 0, 1, arg1, arg2, arg3, arg4, null, null);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }

    public static <A, B, C, D, E> PooledRunnable obtainRunnable(QuintConsumer<? super A, ? super B, ? super C, ? super D, ? super E> function, A arg1, B arg2, C arg3, D arg4, E arg5) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 5, 0, 1, arg1, arg2, arg3, arg4, arg5, null);
    }

    public static <A, B, C, D, E, R> PooledSupplier<R> obtainSupplier(QuintFunction<? super A, ? super B, ? super C, ? super D, ? super E, ? extends R> function, A arg1, B arg2, C arg3, D arg4, E arg5) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 5, 0, 3, arg1, arg2, arg3, arg4, arg5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B, C, D, E> Message obtainMessage(QuintConsumer<? super A, ? super B, ? super C, ? super D, ? super E> function, A arg1, B arg2, C arg3, D arg4, E arg5) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 5, 0, 1, arg1, arg2, arg3, arg4, arg5, null);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }

    public static <A, B, C, D, E, F> PooledRunnable obtainRunnable(HexConsumer<? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function, A arg1, B arg2, C arg3, D arg4, E arg5, F arg6) {
        return (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 6, 0, 1, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <A, B, C, D, E, F, R> PooledSupplier<R> obtainSupplier(HexFunction<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? extends R> function, A arg1, B arg2, C arg3, D arg4, E arg5, F arg6) {
        return (PooledSupplier)PooledLambdaImpl.acquire(PooledLambdaImpl.sPool, function, 6, 0, 3, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B, C, D, E, F> Message obtainMessage(HexConsumer<? super A, ? super B, ? super C, ? super D, ? super E, ? super F> function, A arg1, B arg2, C arg3, D arg4, E arg5, F arg6) {
        Object object = Message.sPoolSync;
        synchronized (object) {
            PooledRunnable callback = (PooledRunnable)PooledLambdaImpl.acquire(PooledLambdaImpl.sMessageCallbacksPool, function, 6, 0, 1, arg1, arg2, arg3, arg4, arg5, arg6);
            return Message.obtain().setCallback(callback.recycleOnUse());
        }
    }
}

