/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MenuItemImpl
implements MenuItem,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MenuItemImpl";
    private static int SHOW_AS_ACTION_MASK = 3;
    private int mId;
    private int mGroup;
    private int mCategoryOrder;
    private int mOrdering;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private Intent mIntent;
    private char mShortcutNumericChar;
    private int mShortcutNumericModifiers;
    private char mShortcutAlphabeticChar;
    private int mShortcutAlphabeticModifiers;
    private Drawable mIconDrawable;
    private int mIconResId;
    private ColorStateList mIconTintList;
    private PorterDuff.Mode mIconTintMode;
    private boolean mHasIconTint;
    private boolean mHasIconTintMode;
    private boolean mNeedToApplyIconTint;
    private MenuBuilder mMenu;
    private SubMenuBuilder mSubMenu;
    private Runnable mItemCallback;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags;
    private static int CHECKABLE = 1;
    private static int CHECKED = 2;
    private static int EXCLUSIVE = 4;
    private static int HIDDEN = 8;
    private static int ENABLED = 16;
    private static int IS_ACTION = 32;
    private int mShowAsAction;
    private View mActionView;
    private ActionProvider mActionProvider;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;
    private boolean mIsActionViewExpanded;
    static int NO_ICON = 0;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private CharSequence mContentDescription;
    private CharSequence mTooltipText;

    private void $$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(MenuBuilder menu2, int group, int id2, int categoryOrder, int ordering, CharSequence title, int showAsAction) {
        this.mShortcutNumericModifiers = 4096;
        this.mShortcutAlphabeticModifiers = 4096;
        this.mIconResId = 0;
        this.mIconTintList = null;
        this.mIconTintMode = null;
        this.mHasIconTint = false;
        this.mHasIconTintMode = false;
        this.mNeedToApplyIconTint = false;
        this.mFlags = 16;
        this.mShowAsAction = 0;
        this.mIsActionViewExpanded = false;
        this.mMenu = menu2;
        this.mId = id2;
        this.mGroup = group;
        this.mCategoryOrder = categoryOrder;
        this.mOrdering = ordering;
        this.mTitle = title;
        this.mShowAsAction = showAsAction;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        if (this.mMenu.dispatchMenuItemSelected(this.mMenu, this)) {
            return true;
        }
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return true;
        }
        if (this.mIntent != null) {
            try {
                this.mMenu.getContext().startActivity(this.mIntent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                Log.e("MenuItemImpl", "Can't find activity to handle intent; ignoring", e);
            }
        }
        return this.mActionProvider != null && this.mActionProvider.onPerformDefaultAction();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setEnabled(boolean enabled) {
        this.mFlags = enabled ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getGroupId() {
        return this.mGroup;
    }

    @ViewDebug.CapturedViewProperty
    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getItemId() {
        return this.mId;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrder() {
        return this.mCategoryOrder;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrdering() {
        return this.mOrdering;
    }

    private final Intent $$robo$$com_android_internal_view_menu_MenuItemImpl$getIntent() {
        return this.mIntent;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    private final Runnable $$robo$$com_android_internal_view_menu_MenuItemImpl$getCallback() {
        return this.mItemCallback;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setCallback(Runnable callback) {
        this.mItemCallback = callback;
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticModifiers() {
        return this.mShortcutAlphabeticModifiers;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char alphaChar) {
        if (this.mShortcutAlphabeticChar == alphaChar) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char alphaChar, int alphaModifiers) {
        if (this.mShortcutAlphabeticChar == alphaChar && this.mShortcutAlphabeticModifiers == alphaModifiers) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mShortcutAlphabeticModifiers = KeyEvent.normalizeMetaState(alphaModifiers);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericModifiers() {
        return this.mShortcutNumericModifiers;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char numericChar) {
        if (this.mShortcutNumericChar == numericChar) {
            return this;
        }
        this.mShortcutNumericChar = numericChar;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char numericChar, int numericModifiers) {
        if (this.mShortcutNumericChar == numericChar && this.mShortcutNumericModifiers == numericModifiers) {
            return this;
        }
        this.mShortcutNumericChar = numericChar;
        this.mShortcutNumericModifiers = KeyEvent.normalizeMetaState(numericModifiers);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char numericChar, char alphaChar) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutNumericModifiers = KeyEvent.normalizeMetaState(numericModifiers);
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.mShortcutAlphabeticModifiers = KeyEvent.normalizeMetaState(alphaModifiers);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final char $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcut() {
        return this.mMenu.isQwertyMode() ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
    }

    private final String $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcutLabel() {
        char shortcut = this.getShortcut();
        if (shortcut == '\u0000') {
            return "";
        }
        Resources res = this.mMenu.getContext().getResources();
        StringBuilder sb = new StringBuilder();
        if (ViewConfiguration.get(this.mMenu.getContext()).hasPermanentMenuKey()) {
            sb.append(res.getString(17040725));
        }
        int modifiers = this.mMenu.isQwertyMode() ? this.mShortcutAlphabeticModifiers : this.mShortcutNumericModifiers;
        MenuItemImpl.appendModifier(sb, modifiers, 65536, res.getString(17040303));
        MenuItemImpl.appendModifier(sb, modifiers, 4096, res.getString(17040299));
        MenuItemImpl.appendModifier(sb, modifiers, 2, res.getString(17040298));
        MenuItemImpl.appendModifier(sb, modifiers, 1, res.getString(17040304));
        MenuItemImpl.appendModifier(sb, modifiers, 4, res.getString(17040306));
        MenuItemImpl.appendModifier(sb, modifiers, 8, res.getString(17040302));
        switch (shortcut) {
            case '\n': {
                sb.append(res.getString(17040301));
                break;
            }
            case '\b': {
                sb.append(res.getString(17040300));
                break;
            }
            case ' ': {
                sb.append(res.getString(17040305));
                break;
            }
            default: {
                sb.append(shortcut);
            }
        }
        return sb.toString();
    }

    private static final void $$robo$$com_android_internal_view_menu_MenuItemImpl$appendModifier(StringBuilder sb, int mask, int modifier, String label) {
        if ((mask & modifier) == modifier) {
            sb.append(label);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowShortcut() {
        return this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuItemImpl$getSubMenu() {
        return this.mSubMenu;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$hasSubMenu() {
        return this.mSubMenu != null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setSubMenu(SubMenuBuilder subMenu) {
        this.mSubMenu = subMenu;
        subMenu.setHeaderTitle(this.getTitle());
    }

    @ViewDebug.CapturedViewProperty
    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitle() {
        return this.mTitle;
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleForItemView(MenuView.ItemView itemView) {
        return itemView != null && itemView.prefersCondensedTitle() ? this.getTitleCondensed() : this.getTitle();
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(CharSequence title) {
        this.mTitle = title;
        this.mMenu.onItemsChanged(false);
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(title);
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(int title) {
        return this.setTitle(this.mMenu.getContext().getString(title));
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleCondensed() {
        return this.mTitleCondensed != null ? this.mTitleCondensed : this.mTitle;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitleCondensed(CharSequence title) {
        this.mTitleCondensed = title;
        if (title == null) {
            title = this.mTitle;
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final Drawable $$robo$$com_android_internal_view_menu_MenuItemImpl$getIcon() {
        if (this.mIconDrawable != null) {
            return this.applyIconTintIfNecessary(this.mIconDrawable);
        }
        if (this.mIconResId != 0) {
            Drawable icon = this.mMenu.getContext().getDrawable(this.mIconResId);
            this.mIconResId = 0;
            this.mIconDrawable = icon;
            return this.applyIconTintIfNecessary(icon);
        }
        return null;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(Drawable icon) {
        this.mIconResId = 0;
        this.mIconDrawable = icon;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(int iconResId) {
        this.mIconDrawable = null;
        this.mIconResId = iconResId;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIconTintList(ColorStateList iconTintList) {
        this.mIconTintList = iconTintList;
        this.mHasIconTint = true;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final ColorStateList $$robo$$com_android_internal_view_menu_MenuItemImpl$getIconTintList() {
        return this.mIconTintList;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setIconTintMode(PorterDuff.Mode iconTintMode) {
        this.mIconTintMode = iconTintMode;
        this.mHasIconTintMode = true;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final PorterDuff.Mode $$robo$$com_android_internal_view_menu_MenuItemImpl$getIconTintMode() {
        return this.mIconTintMode;
    }

    private final Drawable $$robo$$com_android_internal_view_menu_MenuItemImpl$applyIconTintIfNecessary(Drawable icon) {
        if (icon != null && this.mNeedToApplyIconTint && (this.mHasIconTint || this.mHasIconTintMode)) {
            icon = icon.mutate();
            if (this.mHasIconTint) {
                icon.setTintList(this.mIconTintList);
            }
            if (this.mHasIconTintMode) {
                icon.setTintMode(this.mIconTintMode);
            }
            this.mNeedToApplyIconTint = false;
        }
        return icon;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isCheckable() {
        return (this.mFlags & 1) == 1;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckable(boolean checkable) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFE | (checkable ? 1 : 0);
        if (oldFlags != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setExclusiveCheckable(boolean exclusive) {
        this.mFlags = this.mFlags & 0xFFFFFFFB | (exclusive ? 4 : 0);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isExclusiveCheckable() {
        return (this.mFlags & 4) != 0;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isChecked() {
        return (this.mFlags & 2) == 2;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setChecked(boolean checked) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
        } else {
            this.setCheckedInt(checked);
        }
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckedInt(boolean checked) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFD | (checked ? 2 : 0);
        if (oldFlags != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isVisible() {
        if (this.mActionProvider != null && this.mActionProvider.overridesItemVisibility()) {
            return (this.mFlags & 8) == 0 && this.mActionProvider.isVisible();
        }
        return (this.mFlags & 8) == 0;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisibleInt(boolean shown) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFF7 | (shown ? 0 : 8);
        return oldFlags != this.mFlags;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisible(boolean shown) {
        if (this.setVisibleInt(shown)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener clickListener) {
        this.mClickListener = clickListener;
        return this;
    }

    private final String $$robo$$com_android_internal_view_menu_MenuItemImpl$toString() {
        return this.mTitle != null ? this.mTitle.toString() : null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        this.mMenuInfo = menuInfo;
    }

    private final ContextMenu.ContextMenuInfo $$robo$$com_android_internal_view_menu_MenuItemImpl$getMenuInfo() {
        return this.mMenuInfo;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionButton() {
        return (this.mFlags & 0x20) == 32;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$requestsActionButton() {
        return (this.mShowAsAction & 1) == 1;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresActionButton() {
        return (this.mShowAsAction & 2) == 2;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresOverflow() {
        return !this.requiresActionButton() && !this.requestsActionButton();
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setIsActionButton(boolean isActionButton) {
        this.mFlags = isActionButton ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$showsTextAsAction() {
        return (this.mShowAsAction & 4) == 4;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsAction(int actionEnum) {
        switch (actionEnum & 3) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
            }
        }
        this.mShowAsAction = actionEnum;
        this.mMenu.onItemActionRequestChanged(this);
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(View view) {
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && this.mId > 0) {
            view.setId(this.mId);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(int resId) {
        Context context = this.mMenu.getContext();
        LayoutInflater inflater = LayoutInflater.from(context);
        this.setActionView(inflater.inflate(resId, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    private final View $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionView() {
        if (this.mActionView != null) {
            return this.mActionView;
        }
        if (this.mActionProvider != null) {
            this.mActionView = this.mActionProvider.onCreateActionView(this);
            return this.mActionView;
        }
        return null;
    }

    private final ActionProvider $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionProvider() {
        return this.mActionProvider;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionProvider(ActionProvider actionProvider) {
        if (this.mActionProvider != null) {
            this.mActionProvider.reset();
        }
        this.mActionView = null;
        this.mActionProvider = actionProvider;
        this.mMenu.onItemsChanged(true);
        if (this.mActionProvider != null) {
            this.mActionProvider.setVisibilityListener(new ActionProvider.VisibilityListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ MenuItemImpl this$0;

                private void $$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(MenuItemImpl this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_view_menu_MenuItemImpl_1$onActionProviderVisibilityChanged(boolean isVisible) {
                    this.this$0.mMenu.onItemVisibleChanged(this.this$0);
                }

                private void __constructor__(MenuItemImpl menuItemImpl) {
                    this.$$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(menuItemImpl);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuItemImpl_1$__constructor__(com.android.internal.view.menu.MenuItemImpl ), this, menuItemImpl);
                }

                @Override
                public void onActionProviderVisibilityChanged(boolean bl) {
                    InvokeDynamicSupport.bootstrap("onActionProviderVisibilityChanged", $$robo$$com_android_internal_view_menu_MenuItemImpl_1$onActionProviderVisibilityChanged(boolean ), this, bl);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        return this;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsActionFlags(int actionEnum) {
        this.setShowAsAction(actionEnum);
        return this;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$expandActionView() {
        if (!this.hasCollapsibleActionView()) {
            return false;
        }
        if (this.mOnActionExpandListener == null || this.mOnActionExpandListener.onMenuItemActionExpand(this)) {
            return this.mMenu.expandItemActionView(this);
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$collapseActionView() {
        if ((this.mShowAsAction & 8) == 0) {
            return false;
        }
        if (this.mActionView == null) {
            return true;
        }
        if (this.mOnActionExpandListener == null || this.mOnActionExpandListener.onMenuItemActionCollapse(this)) {
            return this.mMenu.collapseItemActionView(this);
        }
        return false;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnActionExpandListener(MenuItem.OnActionExpandListener listener) {
        this.mOnActionExpandListener = listener;
        return this;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$hasCollapsibleActionView() {
        if ((this.mShowAsAction & 8) != 0) {
            if (this.mActionView == null && this.mActionProvider != null) {
                this.mActionView = this.mActionProvider.onCreateActionView(this);
            }
            return this.mActionView != null;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionViewExpanded(boolean isExpanded) {
        this.mIsActionViewExpanded = isExpanded;
        this.mMenu.onItemsChanged(false);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getContentDescription() {
        return this.mContentDescription;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuItemImpl$setTooltipText(CharSequence tooltipText) {
        this.mTooltipText = tooltipText;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuItemImpl$getTooltipText() {
        return this.mTooltipText;
    }

    private void __constructor__(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.$$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(menuBuilder, n, n2, n3, n4, charSequence, n5);
    }

    public MenuItemImpl(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuItemImpl$__constructor__(com.android.internal.view.menu.MenuBuilder int int int int java.lang.CharSequence int ), this, menuBuilder, n, n2, n3, n4, charSequence, n5);
    }

    public boolean invoke() {
        return (boolean)InvokeDynamicSupport.bootstrap("invoke", $$robo$$com_android_internal_view_menu_MenuItemImpl$invoke(), this);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_view_menu_MenuItemImpl$isEnabled(), this);
    }

    @Override
    public MenuItem setEnabled(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$com_android_internal_view_menu_MenuItemImpl$setEnabled(boolean ), this, bl);
    }

    @Override
    public int getGroupId() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupId", $$robo$$com_android_internal_view_menu_MenuItemImpl$getGroupId(), this);
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return (int)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_view_menu_MenuItemImpl$getItemId(), this);
    }

    @Override
    public int getOrder() {
        return (int)InvokeDynamicSupport.bootstrap("getOrder", $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrder(), this);
    }

    public int getOrdering() {
        return (int)InvokeDynamicSupport.bootstrap("getOrdering", $$robo$$com_android_internal_view_menu_MenuItemImpl$getOrdering(), this);
    }

    @Override
    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIntent(), this);
    }

    @Override
    public MenuItem setIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("setIntent", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIntent(android.content.Intent ), this, intent);
    }

    Runnable getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$com_android_internal_view_menu_MenuItemImpl$getCallback(), this);
    }

    public MenuItem setCallback(Runnable runnable) {
        return InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCallback(java.lang.Runnable ), this, runnable);
    }

    @Override
    public char getAlphabeticShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getAlphabeticShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticShortcut(), this);
    }

    @Override
    public int getAlphabeticModifiers() {
        return (int)InvokeDynamicSupport.bootstrap("getAlphabeticModifiers", $$robo$$com_android_internal_view_menu_MenuItemImpl$getAlphabeticModifiers(), this);
    }

    @Override
    public MenuItem setAlphabeticShortcut(char c) {
        return InvokeDynamicSupport.bootstrap("setAlphabeticShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char ), this, c);
    }

    @Override
    public MenuItem setAlphabeticShortcut(char c, int n) {
        return InvokeDynamicSupport.bootstrap("setAlphabeticShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setAlphabeticShortcut(char int ), this, c, n);
    }

    @Override
    public char getNumericShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getNumericShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericShortcut(), this);
    }

    @Override
    public int getNumericModifiers() {
        return (int)InvokeDynamicSupport.bootstrap("getNumericModifiers", $$robo$$com_android_internal_view_menu_MenuItemImpl$getNumericModifiers(), this);
    }

    @Override
    public MenuItem setNumericShortcut(char c) {
        return InvokeDynamicSupport.bootstrap("setNumericShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char ), this, c);
    }

    @Override
    public MenuItem setNumericShortcut(char c, int n) {
        return InvokeDynamicSupport.bootstrap("setNumericShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setNumericShortcut(char int ), this, c, n);
    }

    @Override
    public MenuItem setShortcut(char c, char c2) {
        return InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char char ), this, c, c2);
    }

    @Override
    public MenuItem setShortcut(char c, char c2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShortcut(char char int int ), this, c, c2, n, n2);
    }

    char getShortcut() {
        return (char)InvokeDynamicSupport.bootstrap("getShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcut(), this);
    }

    String getShortcutLabel() {
        return InvokeDynamicSupport.bootstrap("getShortcutLabel", $$robo$$com_android_internal_view_menu_MenuItemImpl$getShortcutLabel(), this);
    }

    private static void appendModifier(StringBuilder stringBuilder, int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("appendModifier", $$robo$$com_android_internal_view_menu_MenuItemImpl$appendModifier(java.lang.StringBuilder int int java.lang.String ), (StringBuilder)stringBuilder, (int)n, (int)n2, (String)string2);
    }

    boolean shouldShowShortcut() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowShortcut", $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowShortcut(), this);
    }

    @Override
    public SubMenu getSubMenu() {
        return InvokeDynamicSupport.bootstrap("getSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$getSubMenu(), this);
    }

    @Override
    public boolean hasSubMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$hasSubMenu(), this);
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        InvokeDynamicSupport.bootstrap("setSubMenu", $$robo$$com_android_internal_view_menu_MenuItemImpl$setSubMenu(com.android.internal.view.menu.SubMenuBuilder ), this, subMenuBuilder);
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitle(), this);
    }

    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        return InvokeDynamicSupport.bootstrap("getTitleForItemView", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleForItemView(com.android.internal.view.menu.MenuView$ItemView ), this, itemView);
    }

    @Override
    public MenuItem setTitle(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public MenuItem setTitle(int n) {
        return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitle(int ), this, n);
    }

    @Override
    public CharSequence getTitleCondensed() {
        return InvokeDynamicSupport.bootstrap("getTitleCondensed", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTitleCondensed(), this);
    }

    @Override
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setTitleCondensed", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTitleCondensed(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public Drawable getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIcon(), this);
    }

    @Override
    public MenuItem setIcon(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public MenuItem setIcon(int n) {
        return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIcon(int ), this, n);
    }

    @Override
    public MenuItem setIconTintList(ColorStateList colorStateList) {
        return InvokeDynamicSupport.bootstrap("setIconTintList", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIconTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    @Override
    public ColorStateList getIconTintList() {
        return InvokeDynamicSupport.bootstrap("getIconTintList", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIconTintList(), this);
    }

    @Override
    public MenuItem setIconTintMode(PorterDuff.Mode mode) {
        return InvokeDynamicSupport.bootstrap("setIconTintMode", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIconTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    @Override
    public PorterDuff.Mode getIconTintMode() {
        return InvokeDynamicSupport.bootstrap("getIconTintMode", $$robo$$com_android_internal_view_menu_MenuItemImpl$getIconTintMode(), this);
    }

    private Drawable applyIconTintIfNecessary(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("applyIconTintIfNecessary", $$robo$$com_android_internal_view_menu_MenuItemImpl$applyIconTintIfNecessary(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public boolean isCheckable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$isCheckable(), this);
    }

    @Override
    public MenuItem setCheckable(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckable(boolean ), this, bl);
    }

    public void setExclusiveCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExclusiveCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$setExclusiveCheckable(boolean ), this, bl);
    }

    public boolean isExclusiveCheckable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExclusiveCheckable", $$robo$$com_android_internal_view_menu_MenuItemImpl$isExclusiveCheckable(), this);
    }

    @Override
    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$com_android_internal_view_menu_MenuItemImpl$isChecked(), this);
    }

    @Override
    public MenuItem setChecked(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_view_menu_MenuItemImpl$setChecked(boolean ), this, bl);
    }

    void setCheckedInt(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckedInt", $$robo$$com_android_internal_view_menu_MenuItemImpl$setCheckedInt(boolean ), this, bl);
    }

    @Override
    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$com_android_internal_view_menu_MenuItemImpl$isVisible(), this);
    }

    boolean setVisibleInt(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisibleInt", $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisibleInt(boolean ), this, bl);
    }

    @Override
    public MenuItem setVisible(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setVisible", $$robo$$com_android_internal_view_menu_MenuItemImpl$setVisible(boolean ), this, bl);
    }

    @Override
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        return InvokeDynamicSupport.bootstrap("setOnMenuItemClickListener", $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnMenuItemClickListener(android.view.MenuItem$OnMenuItemClickListener ), this, onMenuItemClickListener);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_view_menu_MenuItemImpl$toString(), this);
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        InvokeDynamicSupport.bootstrap("setMenuInfo", $$robo$$com_android_internal_view_menu_MenuItemImpl$setMenuInfo(android.view.ContextMenu$ContextMenuInfo ), this, contextMenuInfo);
    }

    @Override
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return InvokeDynamicSupport.bootstrap("getMenuInfo", $$robo$$com_android_internal_view_menu_MenuItemImpl$getMenuInfo(), this);
    }

    public void actionFormatChanged() {
        InvokeDynamicSupport.bootstrap("actionFormatChanged", $$robo$$com_android_internal_view_menu_MenuItemImpl$actionFormatChanged(), this);
    }

    public boolean shouldShowIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldShowIcon", $$robo$$com_android_internal_view_menu_MenuItemImpl$shouldShowIcon(), this);
    }

    public boolean isActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionButton(), this);
    }

    public boolean requestsActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestsActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$requestsActionButton(), this);
    }

    @Override
    public boolean requiresActionButton() {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresActionButton(), this);
    }

    @Override
    public boolean requiresOverflow() {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresOverflow", $$robo$$com_android_internal_view_menu_MenuItemImpl$requiresOverflow(), this);
    }

    public void setIsActionButton(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsActionButton", $$robo$$com_android_internal_view_menu_MenuItemImpl$setIsActionButton(boolean ), this, bl);
    }

    public boolean showsTextAsAction() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsTextAsAction", $$robo$$com_android_internal_view_menu_MenuItemImpl$showsTextAsAction(), this);
    }

    @Override
    public void setShowAsAction(int n) {
        InvokeDynamicSupport.bootstrap("setShowAsAction", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsAction(int ), this, n);
    }

    @Override
    public MenuItem setActionView(View view) {
        return InvokeDynamicSupport.bootstrap("setActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(android.view.View ), this, view);
    }

    @Override
    public MenuItem setActionView(int n) {
        return InvokeDynamicSupport.bootstrap("setActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionView(int ), this, n);
    }

    @Override
    public View getActionView() {
        return InvokeDynamicSupport.bootstrap("getActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionView(), this);
    }

    @Override
    public ActionProvider getActionProvider() {
        return InvokeDynamicSupport.bootstrap("getActionProvider", $$robo$$com_android_internal_view_menu_MenuItemImpl$getActionProvider(), this);
    }

    @Override
    public MenuItem setActionProvider(ActionProvider actionProvider) {
        return InvokeDynamicSupport.bootstrap("setActionProvider", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionProvider(android.view.ActionProvider ), this, actionProvider);
    }

    @Override
    public MenuItem setShowAsActionFlags(int n) {
        return InvokeDynamicSupport.bootstrap("setShowAsActionFlags", $$robo$$com_android_internal_view_menu_MenuItemImpl$setShowAsActionFlags(int ), this, n);
    }

    @Override
    public boolean expandActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("expandActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$expandActionView(), this);
    }

    @Override
    public boolean collapseActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$collapseActionView(), this);
    }

    @Override
    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        return InvokeDynamicSupport.bootstrap("setOnActionExpandListener", $$robo$$com_android_internal_view_menu_MenuItemImpl$setOnActionExpandListener(android.view.MenuItem$OnActionExpandListener ), this, onActionExpandListener);
    }

    public boolean hasCollapsibleActionView() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCollapsibleActionView", $$robo$$com_android_internal_view_menu_MenuItemImpl$hasCollapsibleActionView(), this);
    }

    public void setActionViewExpanded(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActionViewExpanded", $$robo$$com_android_internal_view_menu_MenuItemImpl$setActionViewExpanded(boolean ), this, bl);
    }

    @Override
    public boolean isActionViewExpanded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActionViewExpanded", $$robo$$com_android_internal_view_menu_MenuItemImpl$isActionViewExpanded(), this);
    }

    @Override
    public MenuItem setContentDescription(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$com_android_internal_view_menu_MenuItemImpl$setContentDescription(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public CharSequence getContentDescription() {
        return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$com_android_internal_view_menu_MenuItemImpl$getContentDescription(), this);
    }

    @Override
    public MenuItem setTooltipText(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setTooltipText", $$robo$$com_android_internal_view_menu_MenuItemImpl$setTooltipText(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public CharSequence getTooltipText() {
        return InvokeDynamicSupport.bootstrap("getTooltipText", $$robo$$com_android_internal_view_menu_MenuItemImpl$getTooltipText(), this);
    }

    public /* synthetic */ MenuItemImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuItemImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

